/*
 *  mshtml.h    Hypertext Markup Language (HTML) interfaces
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2010 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#include <rpc.h>
#include <rpcndr.h>
#ifndef COM_NO_WINDOWS_H
    #include <windows.h>
    #include <ole2.h>
#endif

#ifndef __mshtml_h__
#define __mshtml_h__

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#include <ocidl.h>
#include <dimm.h>
#include <shtypes.h>
#include <dispex.h>
#include <olectl.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Forward declarations */
typedef interface IHTMLElementCollection        IHTMLElementCollection;
typedef interface IHTMLDocument                 IHTMLDocument;
typedef interface IHTMLEventObj                 IHTMLEventObj;
typedef interface IHTMLStyleSheetsCollection    IHTMLStyleSheetsCollection;
typedef interface IHTMLDocument2                IHTMLDocument2;
typedef interface IHTMLFrameBase                IHTMLFrameBase;
typedef interface IHTMLSelectionObject          IHTMLSelectionObject;
typedef interface IHTMLTableSection             IHTMLTableSection;
typedef interface IMarkupPointer                IMarkupPointer;
typedef interface IMarkupContainer              IMarkupContainer;
typedef interface ISegmentList                  ISegmentList;
typedef interface IHTMLChangeSink               IHTMLChangeSink;
typedef interface IHTMLChangeLog                IHTMLChangeLog;
typedef interface IDisplayPointer               IDisplayPointer;
typedef interface IHighlightSegment             IHighlightSegment;
typedef interface IElementSegment               IElementSegment;
typedef interface IElementBehaviorSite          IElementBehaviorSite;
typedef interface IElementBehavior              IElementBehavior;
typedef interface IHTMLElement2                 IHTMLElement2;
typedef interface IHTMLOptionElement            IHTMLOptionElement;
typedef interface IHTMLStorage                  IHTMLStorage;

/* Cookie actions */
#define COOKIEACTION_NONE       0x00000000L
#define COOKIEACTION_ACCEPT     0x00000001L
#define COOKIEACTION_REJECT     0x00000002L
#define COOKIEACTION_DOWNGRADE  0x00000004L
#define COOKIEACTION_LEASH      0x00000008L
#define COOKIEACTION_SUPPRESS   0x00000010L
#define COOKIEACTION_READ       0x00000020L

/* Privacy flags */
#define PRIVACY_URLISTOPLEVEL           0x00010000L
#define PRIVACY_URLHASCOMPACTPOLICY     0x00020000L
#define PRIVACY_URLHASPOSTDATA          0x00080000L
#define PRIVACY_URLHASPOLICYREFLINK     0x00100000L
#define PRIVACY_URLHASPOLICYREFHEADER   0x00200000L
#define PRIVACY_URLHASP3PHEADER         0x00400000L

/* HTML design modes */
typedef enum _htmlDesignMode {
    htmlDesignModeInherit   = -2,
    htmlDesignModeOn        = -1,
    htmlDesignModeOff       = 0,
    htmlDesignMode_Max      = 2147483647
} htmlDesignMode;

/* HTML z-order values */
typedef enum _htmlZOrder {
    htmlZOrderFront = 0,
    htmlZOrderBack  = 1,
    htmlZOrder_Max  = 2147483647
} htmlZOrder;

/* HTML clear values */
typedef enum _htmlClear {
    htmlClearNotSet = 0,
    htmlClearAll    = 1,
    htmlClearLeft   = 2,
    htmlClearRight  = 3,
    htmlClearBoth   = 4,
    htmlClearNone   = 5,
    htmlClear_Max   = 2147483647
} htmlClear;

/* HTML control align values */
typedef enum _htmlControlAlign {
    htmlControlAlignNotSet      = 0,
    htmlControlAlignLeft        = 1,
    htmlControlAlignCenter      = 2,
    htmlControlAlignRight       = 3,
    htmlControlAlignTextTop     = 4,
    htmlControlAlignAbsMiddle   = 5,
    htmlControlAlignBaseline    = 6,
    htmlControlAlignAbsBottom   = 7,
    htmlControlAlignBottom      = 8,
    htmlControlAlignMiddle      = 9,
    htmlControlAlignTop         = 10,
    htmlControlAlign_Max        = 2147483647
} htmlControlAlign;

/* HTML block align */
typedef enum _htmlBlockAlign {
    htmlBlockAlignNotSet    = 0,
    htmlBlockAlignLeft      = 1,
    htmlBlockAlignCenter    = 2,
    htmlBlockAlignRight     = 3,
    htmlBlockAlignJustify   = 4,
    htmlBlockAlign_Max      = 2147483647
} htmlBlockAlign;

/* HTML ready states */
typedef enum _htmlReadyState {
    htmlReadyStateuninitialized = 0,
    htmlReadyStateloading       = 1,
    htmlReadyStateloaded        = 2,
    htmlReadyStateinteractive   = 3,
    htmlReadyStatecomplete      = 4,
    htmlReadyState_Max          = 2147483647
} htmlReadyState;

/* HTML loop values */
typedef enum _htmlLoop {
    htmlLoopLoopInfinite    = -1,
    htmlLoop_Max            = 2147483647
} htmlLoop;

/* Media types */
typedef enum _mediaType {
    mediaTypeNotSet     = 0,
    mediaTypeAll        = 511,
    mediaTypeAural      = 1,
    mediaTypeBraille    = 2,
    mediaTypeEmbossed   = 4,
    mediaTypeHandheld   = 8,
    mediaTypePrint      = 16,
    mediaTypeProjection = 32,
    mediaTypeScreen     = 64,
    mediaTypeTty        = 128,
    mediaTypeTv         = 256,
    mediaType_Max       = 2147483647
} mediaType;

/* DOM constructors */
typedef enum _DomConstructor {
    DomConstructorObject                        = 0,
    DomConstructorAttr                          = 1,
    DomConstructorBehaviorUrnsCollection        = 2,
    DomConstructorBookmarkCollection            = 3,
    DomConstructorCompatibleInfo                = 4,
    DomConstructorCompatibleInfoCollection      = 5,
    DomConstructorControlRangeCollection        = 6,
    DomConstructorCSSCurrentStyleDeclaration    = 7,
    DomConstructorCSSRuleList                   = 8,
    DomConstructorCSSRuleStyleDeclaration       = 9,
    DomConstructorCSSStyleDeclaration           = 10,
    DomConstructorCSSStyleRule                  = 11,
    DomConstructorCSSStyleSheet                 = 12,
    DomConstructorDataTransfer                  = 13,
    DomConstructorDOMImplementation             = 14,
    DomConstructorElement                       = 15,
    DomConstructorEvent                         = 16,
    DomConstructorHistory                       = 17,
    DomConstructorHTCElementBehaviorDefaults    = 18,
    DomConstructorHTMLAnchorElement             = 19,
    DomConstructorHTMLAreaElement               = 20,
    DomConstructorHTMLAreasCollection           = 21,
    DomConstructorHTMLBaseElement               = 22,
    DomConstructorHTMLBaseFontElement           = 23,
    DomConstructorHTMLBGSoundElement            = 24,
    DomConstructorHTMLBlockElement              = 25,
    DomConstructorHTMLBodyElement               = 26,
    DomConstructorHTMLBRElement                 = 27,
    DomConstructorHTMLButtonElement             = 28,
    DomConstructorHTMLCollection                = 29,
    DomConstructorHTMLCommentElement            = 30,
    DomConstructorHTMLDDElement                 = 31,
    DomConstructorHTMLDivElement                = 32,
    DomConstructorHTMLDocument                  = 33,
    DomConstructorHTMLDListElement              = 34,
    DomConstructorHTMLDTElement                 = 35,
    DomConstructorHTMLEmbedElement              = 36,
    DomConstructorHTMLFieldSetElement           = 37,
    DomConstructorHTMLFontElement               = 38,
    DomConstructorHTMLFormElement               = 39,
    DomConstructorHTMLFrameElement              = 40,
    DomConstructorHTMLFrameSetElement           = 41,
    DomConstructorHTMLGenericElement            = 42,
    DomConstructorHTMLHeadElement               = 43,
    DomConstructorHTMLHeadingElement            = 44,
    DomConstructorHTMLHRElement                 = 45,
    DomConstructorHTMLHtmlElement               = 46,
    DomConstructorHTMLIFrameElement             = 47,
    DomConstructorHTMLImageElement              = 48,
    DomConstructorHTMLInputElement              = 49,
    DomConstructorHTMLIsIndexElement            = 50,
    DomConstructorHTMLLabelElement              = 51,
    DomConstructorHTMLLegendElement             = 52,
    DomConstructorHTMLLIElement                 = 53,
    DomConstructorHTMLLinkElement               = 54,
    DomConstructorHTMLMapElement                = 55,
    DomConstructorHTMLMarqueeElement            = 56,
    DomConstructorHTMLMetaElement               = 57,
    DomConstructorHTMLModelessDialog            = 58,
    DomConstructorHTMLNamespaceInfo             = 59,
    DomConstructorHTMLNamespaceInfoCollection   = 60,
    DomConstructorHTMLNextIdElement             = 61,
    DomConstructorHTMLNoShowElement             = 62,
    DomConstructorHTMLObjectElement             = 63,
    DomConstructorHTMLOListElement              = 64,
    DomConstructorHTMLOptionElement             = 65,
    DomConstructorHTMLParagraphElement          = 66,
    DomConstructorHTMLParamElement              = 67,
    DomConstructorHTMLPhraseElement             = 68,
    DomConstructorHTMLPluginsCollection         = 69,
    DomConstructorHTMLPopup                     = 70,
    DomConstructorHTMLScriptElement             = 71,
    DomConstructorHTMLSelectElement             = 72,
    DomConstructorHTMLSpanElement               = 73,
    DomConstructorHTMLStyleElement              = 74,
    DomConstructorHTMLTableCaptionElement       = 75,
    DomConstructorHTMLTableCellElement          = 76,
    DomConstructorHTMLTableColElement           = 77,
    DomConstructorHTMLTableElement              = 78,
    DomConstructorHTMLTableRowElement           = 79,
    DomConstructorHTMLTableSectionElement       = 80,
    DomConstructorHTMLTextAreaElement           = 81,
    DomConstructorHTMLTextElement               = 82,
    DomConstructorHTMLTitleElement              = 83,
    DomConstructorHTMLUListElement              = 84,
    DomConstructorHTMLUnknownElement            = 85,
    DomConstructorImage                         = 86,
    DomConstructorLocation                      = 87,
    DomConstructorNamedNodeMap                  = 88,
    DomConstructorNavigator                     = 89,
    DomConstructorNodeList                      = 90,
    DomConstructorOption                        = 91,
    DomConstructorScreen                        = 92,
    DomConstructorSelection                     = 93,
    DomConstructorStaticNodeList                = 94,
    DomConstructorStorage                       = 95,
    DomConstructorStyleSheetList                = 96,
    DomConstructorStyleSheetPage                = 97,
    DomConstructorStyleSheetPageList            = 98,
    DomConstructorText                          = 99,
    DomConstructorTextRange                     = 100,
    DomConstructorTextRangeCollection           = 101,
    DomConstructorTextRectangle                 = 102,
    DomConstructorTextRectangleList             = 103,
    DomConstructorWindow                        = 104,
    DomConstructorXDomainRequest                = 105,
    DomConstructorXMLHttpRequest                = 106,
    DomConstructorMax                           = 107,
    DomConstructor_Max                          = 2147483647
} DomConstructor;

/* Style text transforms */
typedef enum _styleTextTransform {
    styleTextTransformNotSet        = 0,
    styleTextTransformCapitalize    = 1,
    styleTextTransformLowercase     = 2,
    styleTextTransformUppercase     = 3,
    styleTextTransformNone          = 4,
    styleTextTransform_Max          = 2147483647
} styleTextTransform;

/* Style data repeat values */
typedef enum _styleDataRepeat {
    styleDataRepeatNone     = 0,
    styleDataRepeatInner    = 1,
    styleDataRepeat_Max     = 2147483647
} styleDataRepeat;

/* Style overflow values */
typedef enum _styleOverflow {
    styleOverflowNotSet     = 0,
    styleOverflowAuto       = 1,
    styleOverflowHidden     = 2,
    styleOverflowVisible    = 3,
    styleOverflowScroll     = 4,
    styleOverflow_Max       = 2147483647
} styleOverflow;

/* Style table layouts */
typedef enum _styleTableLayout {
    styleTableLayoutNotSet  = 0,
    styleTableLayoutAuto    = 1,
    styleTableLayoutFixed   = 2,
    styleTableLayout_Max    = 2147483647
} styleTableLayout;

/* Style border collapse values */
typedef enum _styleBorderCollapse {
    styleBorderCollapseNotSet   = 0,
    styleBorderCollapseSeparate = 1,
    styleBorderCollapseCollapse = 2,
    styleBorderCollapse_Max     = 2147483647
} styleBorderCollapse;

/* Style caption sides */
typedef enum _styleCaptionSide {
    styleCaptionSideNotSet  = 0,
    styleCaptionSideTop     = 1,
    styleCaptionSideBottom  = 2,
    styleCaptionSideLeft    = 3,
    styleCaptionSideRight   = 4,
    styleCaptionSide_Max    = 2147483647
} styleCaptionSide;

/* Style empty cells */
typedef enum _styleEmptyCells {
    styleEmptyCellsNotSet   = 0,
    styleEmptyCellsShow     = 1,
    styleEmptyCellsHide     = 2,
    styleEmptyCells_Max     = 2147483647
} styleEmptyCells;

/* Style font styles */
typedef enum _styleFontStyle {
    styleFontStyleNotSet    = 0,
    styleFontStyleItalic    = 1,
    styleFontStyleOblique   = 2,
    styleFontStyleNormal    = 3,
    styleFontStyle_Max      = 2147483647
} styleFontStyle;

/* Style font variants */
typedef enum _styleFontVariant {
    styleFontVariantNotSet      = 0,
    styleFontVariantSmallCaps   = 1,
    styleFontVariantNormal      = 2,
    styleFontVariant_Max        = 2147483647
} styleFontVariant;

/* Style background repeat values */
typedef enum _styleBackgroundRepeat {
    styleBackgroundRepeatRepeat     = 0,
    styleBackgroundRepeatRepeatX    = 1,
    styleBackgroundRepeatRepeatY    = 2,
    styleBackgroundRepeatNoRepeat   = 3,
    styleBackgroundRepeatNotSet     = 4,
    styleBackgroundRepeat_Max       = 2147483647
} styleBackgroundRepeat;

/* Style background attachment values */
typedef enum _styleBackgroundAttachment {
    styleBackgroundAttachmentFixed  = 0,
    styleBackgroundAttachmentScroll = 1,
    styleBackgroundAttachmentNotSet = 2,
    styleBackgroundAttachment_Max   = 2147483647
} styleBackgroundAttachment;

/* Style vertical align values */
typedef enum _styleVerticalAlign {
    styleVerticalAlignAuto          = 0,
    styleVerticalAlignBaseline      = 1,
    styleVerticalAlignSub           = 2,
    styleVerticalAlignSuper         = 3,
    styleVerticalAlignTop           = 4,
    styleVerticalAlignTextTop       = 5,
    styleVerticalAlignMiddle        = 6,
    styleVerticalAlignBottom        = 7,
    styleVerticalAlignTextBottom    = 8,
    styleVerticalAlignInherit       = 9,
    styleVerticalAlignNotSet        = 10,
    styleVerticalAlign_Max          = 2147483647
} styleVerticalAlign;

/* Style font weight values */
typedef enum _styleFontWeight {
    styleFontWeightNotSet   = 0,
    styleFontWeight100      = 1,
    styleFontWeight200      = 2,
    styleFontWeight300      = 3,
    styleFontWeight400      = 4,
    styleFontWeight500      = 5,
    styleFontWeight600      = 6,
    styleFontWeight700      = 7,
    styleFontWeight800      = 8,
    styleFontWeight900      = 9,
    styleFontWeightNormal   = 10,
    styleFontWeightBold     = 11,
    styleFontWeightBolder   = 12,
    styleFontWeightLighter  = 13,
    styleFontWeight_Max     = 2147483647
} styleFontWeight;

/* Style background horizontal positions */
typedef enum _styleBackgroundPositionX {
    styleBackgroundPositionXNotSet  = 0,
    styleBackgroundPositionXLeft    = 1,
    styleBackgroundPositionXCenter  = 2,
    styleBackgroundPositionXRight   = 3,
    styleBackgroundPositionX_Max    = 2147483647
} styleBackgroundPositionX;

/* Style background vertical positions */
typedef enum _styleBackgroundPositionY {
    styleBackgroundPositionYNotSet  = 0,
    styleBackgroundPositionYTop     = 1,
    styleBackgroundPositionYCenter  = 2,
    styleBackgroundPositionYBottom  = 3,
    styleBackgroundPositionY_Max    = 2147483647
} styleBackgroundPositionY;

/* Style font sizes */
typedef enum _styleFontSize {
    styleFontSizeXXSmall    = 0,
    styleFontSizeXSmall     = 1,
    styleFontSizeSmall      = 2,
    styleFontSizeMedium     = 3,
    styleFontSizeLarge      = 4,
    styleFontSizeXLarge     = 5,
    styleFontSizeXXLarge    = 6,
    styleFontSizeSmaller    = 7,
    styleFontSizeLarger     = 8,
    styleFontSize_Max       = 2147483647
} styleFontSize;

/* Style z-indices */
typedef enum _styleZIndex {
    styleZIndexAuto = -2147483647,
    styleZIndex_Max = 2147483647
} styleZIndex;

/* Style widows/orphans values */
typedef enum _styleWidowsOrphans {
    styleWidowsOrphansNotSet    = -2147483647,
    styleWidowsOrphans_Max      = 2147483647
} styleWidowsOrphans;

/* Style automatic values */
typedef enum _styleAuto {
    styleAutoAuto   = 0,
    styleAuto_Max   = 2147483647
} styleAuto;

/* Style none values */
typedef enum _styleNone {
    styleNoneNone   = 0,
    styleNone_Max   = 2147483647
} styleNone;

/* Style normal values */
typedef enum _styleNormal {
    styleNormalNormal   = 0,
    styleNormal_Max     = 2147483647
} styleNormal;

/* Style border widths */
typedef enum _styleBorderWidth {
    styleBorderWidthThin    = 0,
    styleBorderWidthMedium  = 1,
    styleBorderWidthThick   = 2,
    styleBorderWidth_Max    = 2147483647
} styleBorderWidth;

/* Style positions */
typedef enum _stylePosition {
    stylePositionNotSet     = 0,
    stylePositionstatic     = 1,
    stylePositionrelative   = 2,
    stylePositionabsolute   = 3,
    stylePositionfixed      = 4,
    stylePosition_Max       = 2147483647
} stylePosition;

/* Style border styles */
typedef enum _styleBorderStyle {
    styleBorderStyleNotSet      = 0,
    styleBorderStyleDotted      = 1,
    styleBorderStyleDashed      = 2,
    styleBorderStyleSolid       = 3,
    styleBorderStyleDouble      = 4,
    styleBorderStyleGroove      = 5,
    styleBorderStyleRidge       = 6,
    styleBorderStyleInset       = 7,
    styleBorderStyleOutset      = 8,
    styleBorderStyleWindowInset = 9,
    styleBorderStyleNone        = 10,
    styleBorderStyleHidden      = 11,
    styleBorderStyle_Max        = 2147483647
} styleBorderStyle;

/* Style style float values */
typedef enum _styleStyleFloat {
    styleStyleFloatNotSet   = 0,
    styleStyleFloatLeft     = 1,
    styleStyleFloatRight    = 2,
    styleStyleFloatNone     = 3,
    styleStyleFloat_Max     = 2147483647
} styleStyleFloat;

/* Style display values */
typedef enum _styleDisplay {
    styleDisplayNotSet              = 0,
    styleDisplayBlock               = 1,
    styleDisplayInline              = 2,
    styleDisplayListItem            = 3,
    styleDisplayNone                = 4,
    styleDisplayTableHeaderGroup    = 5,
    styleDisplayTableFooterGroup    = 6,
    styleDisplayInlineBlock         = 7,
    styleDisplayTable               = 8,
    styleDisplayInlineTable         = 9,
    styleDisplayTableRow            = 10,
    styleDisplayTableRowGroup       = 11,
    styleDisplayTableColumn         = 12,
    styleDisplayTableColumnGroup    = 13,
    styleDisplayTableCell           = 14,
    styleDisplayTableCaption        = 15,
    styleDisplayRunIn               = 16,
    styleDisplayRuby                = 17,
    styleDisplayRubyBase            = 18,
    styleDisplayRubyText            = 19,
    styleDisplayRubyBaseContainer   = 20,
    styleDisplayRubyTextContainer   = 21,
    styleDisplay_Max                = 2147483647
} styleDisplay;

/* Style visibility values */
typedef enum _styleVisibility {
    styleVisibilityNotSet   = 0,
    styleVisibilityInherit  = 1,
    styleVisibilityVisible  = 2,
    styleVisibilityHidden   = 3,
    styleVisibilityCollapse = 4,
    styleVisibility_Max     = 2147483647
} styleVisibility;

/* Style list style types */
typedef enum _styleListStyleType {
    styleListStyleTypeNotSet                = 0,
    styleListStyleTypeDisc                  = 1,
    styleListStyleTypeCircle                = 2,
    styleListStyleTypeSquare                = 3,
    styleListStyleTypeDecimal               = 4,
    styleListStyleTypeLowerRoman            = 5,
    styleListStyleTypeUpperRoman            = 6,
    styleListStyleTypeLowerAlpha            = 7,
    styleListStyleTypeUpperAlpha            = 8,
    styleListStyleTypeNone                  = 9,
    styleListStyleTypeDecimalLeadingZero    = 10,
    styleListStyleTypeGeorgian              = 11,
    styleListStyleTypeArmenian              = 12,
    styleListStyleTypeUpperLatin            = 13,
    styleListStyleTypeLowerLatin            = 14,
    styleListStyleTypeUpperGreek            = 15,
    styleListStyleTypeLowerGreek            = 16,
    styleListStyleType_Max                  = 2147483647
} styleListStyleType;

/* Style list style positions */
typedef enum _styleListStylePosition {
    styleListStylePositionNotSet    = 0,
    styleListStylePositionInside    = 1,
    styleListStylePositionOutSide   = 2,
    styleListStylePosition_Max      = 2147483647
} styleListStylePosition;

/* Style white space values */
typedef enum _styleWhiteSpace {
    styleWhiteSpaceNotSet   = 0,
    styleWhiteSpaceNormal   = 1,
    styleWhiteSpacePre      = 2,
    styleWhiteSpaceNowrap   = 3,
    styleWhiteSpacePreline  = 4,
    styleWhiteSpacePrewrap  = 5,
    styleWhiteSpace_Max     = 2147483647
} styleWhiteSpace;

/* Style page break values */
typedef enum _stylePageBreak {
    stylePageBreakNotSet    = 0,
    stylePageBreakAuto      = 1,
    stylePageBreakAlways    = 2,
    stylePageBreakLeft      = 3,
    stylePageBreakRight     = 4,
    stylePageBreak_Max      = 2147483647
} stylePageBreak;

/* Style page break inside values */
typedef enum _stylePageBreakInside {
    stylePageBreakInsideNotSet  = 0,
    stylePageBreakInsideAuto    = 1,
    stylePageBreakInsideAvoid   = 2,
    stylePageBreakInside_Max    = 2147483647
} stylePageBreakInside;

/* Style cursor values */
typedef enum _styleCursor {
    styleCursorAuto             = 0,
    styleCursorCrosshair        = 1,
    styleCursorDefault          = 2,
    styleCursorHand             = 3,
    styleCursorMove             = 4,
    styleCursorE_resize         = 5,
    styleCursorNe_resize        = 6,
    styleCursorNw_resize        = 7,
    styleCursorN_resize         = 8,
    styleCursorSe_resize        = 9,
    styleCursorSw_resize        = 10,
    styleCursorS_resize         = 11,
    styleCursorW_resize         = 12,
    styleCursorText             = 13,
    styleCursorWait             = 14,
    styleCursorHelp             = 15,
    styleCursorPointer          = 16,
    styleCursorProgress         = 17,
    styleCursorNot_allowed      = 18,
    styleCursorNo_drop          = 19,
    styleCursorVertical_text    = 20,
    styleCursorall_scroll       = 21,
    styleCursorcol_resize       = 22,
    styleCursorrow_resize       = 23,
    styleCursorcustom           = 24,
    styleCursorNotSet           = 25,
    styleCursor_Max             = 2147483647
} styleCursor;

/* Style directions */
typedef enum _styleDir {
    styleDirNotSet      = 0,
    styleDirLeftToRight = 1,
    styleDirRightToLeft = 2,
    styleDirInherit     = 3,
    styleDir_Max        = 2147483647
} styleDir;

/* Style bidirectional values */
typedef enum _styleBidi {
    styleBidiNotSet     = 0,
    styleBidiNormal     = 1,
    styleBidiEmbed      = 2,
    styleBidiOverride   = 3,
    styleBidiInherit    = 4,
    styleBidi_Max       = 2147483647
} styleBidi;

/* Style IME modes */
typedef enum _styleImeMode {
    styleImeModeAuto        = 0,
    styleImeModeActive      = 1,
    styleImeModeInactive    = 2,
    styleImeModeDisabled    = 3,
    styleImeModeNotSet      = 4,
    styleImeMode_Max        = 2147483647
} styleImeMode;

/* Style ruby align values */
typedef enum _styleRubyAlign {
    styleRubyAlignNotSet            = 0,
    styleRubyAlignAuto              = 1,
    styleRubyAlignLeft              = 2,
    styleRubyAlignCenter            = 3,
    styleRubyAlignRight             = 4,
    styleRubyAlignDistributeLetter  = 5,
    styleRubyAlignDistrubuteSpace   = 6,
    styleRubyAlignLineEdge          = 7,
    styleRubyAlign_Max              = 2147483647
} styleRubyAlign;

/* Style ruby position values */
typedef enum _styleRubyPosition {
    styleRubyPositionNotSet = 0,
    styleRubyPositionAbove  = 1,
    styleRubyPositionInline = 2,
    styleRubyPosition_Max   = 2147483647
} styleRubyPosition;

/* Style ruby overhang values */
typedef enum _styleRubyOverhang {
    styleRubyOverhangNotSet     = 0,
    styleRubyOverhangAuto       = 1,
    styleRubyOverhangWhitespace = 2,
    styleRubyOverhangNone       = 3,
    styleRubyOverhang_Max       = 2147483647
} styleRubyOverhang;

/* Style layout grid characters */
typedef enum _styleLayoutGridChar {
    styleLayoutGridCharNotSet   = 0,
    styleLayoutGridCharAuto     = 1,
    styleLayoutGridCharNone     = 2,
    styleLayoutGridChar_Max     = 2147483647
} styleLayoutGridChar;

/* Style layout grid line values */
typedef enum _styleLayoutGridLine {
    styleLayoutGridLineNotSet   = 0,
    styleLayoutGridLineAuto     = 1,
    styleLayoutGridLineNone     = 2,
    styleLayoutGridLine_Max     = 2147483647
} styleLayoutGridLine;

/* Style layout grid modes */
typedef enum _styleLayoutGridMode {
    styleLayoutGridModeNotSet   = 0,
    styleLayoutGridModeChar     = 1,
    styleLayoutGridModeLine     = 2,
    styleLayoutGridModeBoth     = 3,
    styleLayoutGridModeNone     = 4,
    styleLayoutGridMode_Max     = 2147483647
} styleLayoutGridMode;

/* Style layout grid types */
typedef enum _styleLayoutGridType {
    styleLayoutGridTypeNotSet   = 0,
    styleLayoutGridTypeLoose    = 1,
    styleLayoutGridTypeStrict   = 2,
    styleLayoutGridTypeFixed    = 3,
    styleLayoutGridType_Max     = 2147483647
} styleLayoutGridType;

/* Style line break values */
typedef enum _styleLineBreak {
    styleLineBreakNotSet    = 0,
    styleLineBreakNormal    = 1,
    styleLineBreakStrict    = 2,
    styleLineBreak_Max      = 2147483647
} styleLineBreak;

/* Style word break values */
typedef enum _styleWordBreak {
    styleWordBreakNotSet    = 0,
    styleWordBreakNormal    = 1,
    styleWordBreakBreakAll  = 2,
    styleWordBreakKeepAll   = 3,
    styleWordBreak_Max      = 2147483647
} styleWordBreak;

/* Style word wrap values */
typedef enum _styleWordWrap {
    styleWordWrapNotSet = 0,
    styleWordWrapOff    = 1,
    styleWordWrapOn     = 2,
    styleWordWrap_Max   = 2147483647
} styleWordWrap;

/* Style text justify values */
typedef enum _styleTextJustify {
    styleTextJustifyNotSet              = 0,
    styleTextJustifyInterWord           = 1,
    styleTextJustifyNewspaper           = 2,
    styleTextJustifyDistribute          = 3,
    styleTextJustifyDistributeAllLines  = 4,
    styleTextJustifyInterIdeograph      = 5,
    styleTextJustifyInterCluster        = 6,
    styleTextJustifyKashida             = 7,
    styleTextJustifyAuto                = 8,
    styleTextJustify_Max                = 2147483647
} styleTextJustify;

/* Style text align last values */
typedef enum _styleTextAlignLast {
    styleTextAlignLastNotSet    = 0,
    styleTextAlignLastLeft      = 1,
    styleTextAlignLastCenter    = 2,
    styleTextAlignLastRight     = 3,
    styleTextAlignLastJustify   = 4,
    styleTextAlignLastAuto      = 5,
    styleTextAlignLast_Max      = 2147483647
} styleTextAlignLast;

/* Style text justify trim */
typedef enum _styleTextJustifyTrim {
    styleTextJustifyTrimNotSet          = 0,
    styleTextJustifyTrimNone            = 1,
    styleTextJustifyTrimPunctuation     = 2,
    styleTextJustifyTrimPunctAndKana    = 3,
    styleTextJustifyTrim_Max            = 2147483647
} styleTextJustifyTrim;

/* Style accelerator values */
typedef enum _styleAccelerator {
    styleAcceleratorFalse   = 0,
    styleAcceleratorTrue    = 1,
    styleAccelerator_Max    = 2147483647
} styleAccelerator;

/* Style layout flow values */
typedef enum _styleLayoutFlow {
    styleLayoutFlowHorizontal           = 0,
    styleLayoutFlowVerticalIdeographic  = 1,
    styleLayoutFlowNotSet               = 2,
    styleLayoutFlow_Max                 = 2147483647
} styleLayoutFlow;

/* Style block progression values */
typedef enum _styleBlockProgressionValues {
    styleBlockProgressionTb     = 0,
    styleBlockProgressionRl     = 1,
    styleBlockProgressionBt     = 2,
    styleBlockProgressionLr     = 3,
    styleBlockProgressionNotSet = 4,
    styleBlockProgression_Max   = 2147483647
} styleBlockProgressionValues;

/* Style writing modes */
typedef enum _styleWritingMode {
    styleWritingModeLrtb    = 0,
    styleWritingModeTbrl    = 1,
    styleWritingModeRltb    = 2,
    styleWritingModeBtrl    = 3,
    styleWritingModeNotSet  = 4,
    styleWritingModeTblr    = 5,
    styleWritingModeBtlr    = 6,
    styleWritingModeLrbt    = 7,
    styleWritingModeRlbt    = 8,
    styleWritingMode_Max    = 2147483647
} styleWritingMode;

/* Style boolean */
typedef enum _styleBool {
    styleBoolFalse  = 0,
    styleBoolTrue   = 1,
    styleBool_Max   = 2147483647
} styleBool;

/* Style text underline positions */
typedef enum _styleTextUnderlinePosition {
    styleTextUnderlinePositionBelow     = 0,
    styleTextUnderlinePositionAbove     = 1,
    styleTextUnderlinePositionAuto      = 2,
    styleTextUnderlinePositionNotSet    = 3,
    styleTextUnderlinePosition_Max      = 2147483647
} styleTextUnderlinePosition;

/* Style text overflow values */
typedef enum _styleTextOverflow {
    styleTextOverflowClip       = 0,
    styleTextOverflowEllipsis   = 1,
    styleTextOverflowNotSet     = 2,
    styleTextOverflow_Max       = 2147483647
} styleTextOverflow;

/* Style interpolation values */
typedef enum _styleInterpolation {
    styleInterpolationNotSet    = 0,
    styleInterpolationNN        = 1,
    styleInterpolationBCH       = 2,
    styleInterpolation_Max      = 2147483647
} styleInterpolation;

/* Style box sizing values */
typedef enum _styleBoxSizing {
    styleBoxSizingNotSet        = 0,
    styleBoxSizingContentBox    = 1,
    styleBoxSizingBorderBox     = 2,
    styleBoxSizing_Max          = 2147483647
} styleBoxSizing;

/* Style text line-through styles */
typedef enum _styleTextLineThroughStyle {
    styleTextLineThroughStyleUndefined  = 0,
    styleTextLineThroughStyleSingle     = 1,
    styleTextLineThroughStyleDouble     = 2,
    styleTextLineThroughStyle_Max       = 2147483647
} styleTextLineThroughStyle;

/* Style text underline styles */
typedef enum _styleTextUnderlineStyle {
    styleTextUnderlineStyleUndefined        = 0,
    styleTextUnderlineStyleSingle           = 1,
    styleTextUnderlineStyleDouble           = 2,
    styleTextUnderlineStyleWords            = 3,
    styleTextUnderlineStyleDotted           = 4,
    styleTextUnderlineStyleThick            = 5,
    styleTextUnderlineStyleDash             = 6,
    styleTextUnderlineStyleDotDash          = 7,
    styleTextUnderlineStyleDotDotDash       = 8,
    styleTextUnderlineStyleWave             = 9,
    styleTextUnderlineStyleSingleAccounting = 10,
    styleTextUnderlineStyleDoubleAccounting = 11,
    styleTextUnderlineStyleThickDash        = 12,
    styleTextUnderlineStyle_Max             = 2147483647
} styleTextUnderlineStyle;

/* Style text effects */
typedef enum _styleTextEffect {
    styleTextEffectNone     = 0,
    styleTextEffectEmboss   = 1,
    styleTextEffectEngrave  = 2,
    styleTextEffectOutline  = 3,
    styleTextEffect_Max     = 2147483647
} styleTextEffect;

/* Style default text selection values */
typedef enum _styleDefaultTextSelection {
    styleDefaultTextSelectionFalse  = 0,
    styleDefaultTextSelectionTrue   = 1,
    styleDefaultTextSelection_Max   = 2147483647
} styleDefaultTextSelection;

/* Style text decorations */
typedef enum _styleTextDecoration {
    styleTextDecorationNone         = 0,
    styleTextDecorationUnderline    = 1,
    styleTextDecorationOverline     = 2,
    styleTextDecorationLineThrough  = 3,
    styleTextDecorationBlink        = 4,
    styleTextDecoration_Max         = 2147483647
} styleTextDecoration;

/* Text decorations */
typedef enum _textDecoration {
    textDecorationNone          = 0,
    textDecorationUnderline     = 1,
    textDecorationOverline      = 2,
    textDecorationLineThrough   = 3,
    textDecorationBlink         = 4,
    textDecoration_Max          = 2147483647
} textDecoration;

/* HTML list types */
typedef enum _htmlListType {
    htmlListTypeNotSet      = 0,
    htmlListTypeLargeAlpha  = 1,
    htmlListTypeSmallAlpha  = 2,
    htmlListTypeLargeRoman  = 3,
    htmlListTypeSmallRoman  = 4,
    htmlListTypeNumbers     = 5,
    htmlListTypeDisc        = 6,
    htmlListTypeCircle      = 7,
    htmlListTypeSquare      = 8,
    htmlListType_Max        = 2147483647
} htmlListType;

/* HTML methods */
typedef enum _htmlMethod {
    htmlMethodNotSet    = 0,
    htmlMethodGet       = 1,
    htmlMethodPost      = 2,
    htmlMethod_Max      = 2147483647
} htmlMethod;

/* HTML wrap values */
typedef enum _htmlWrap {
    htmlWrapOff     = 1,
    htmlWrapSoft    = 2,
    htmlWrapHard    = 3,
    htmlWrap_Max    = 2147483647
} htmlWrap;

/* HTML directions */
typedef enum _htmlDir {
    htmlDirNotSet       = 0,
    htmlDirLeftToRight  = 1,
    htmlDirRightToLeft  = 2,
    htmlDir_Max         = 2147483647
} htmlDir;

/* HTML editable values */
typedef enum _htmlEditable {
    htmlEditableInherit = 0,
    htmlEditableTrue    = 1,
    htmlEditableFalse   = 2,
    htmlEditable_Max    = 2147483647
} htmlEditable;

/* HTML input types */
typedef enum _htmlInput {
    htmlInputNotSet         = 0,
    htmlInputButton         = 1,
    htmlInputCheckbox       = 2,
    htmlInputFile           = 3,
    htmlInputHidden         = 4,
    htmlInputImage          = 5,
    htmlInputPassword       = 6,
    htmlInputRadio          = 7,
    htmlInputReset          = 8,
    htmlInputSelectOne      = 9,
    htmlInputSelectMultiple = 10,
    htmlInputSubmit         = 11,
    htmlInputText           = 12,
    htmlInputTextarea       = 13,
    htmlInputRichtext       = 14,
    htmlInput_Max           = 2147483647
} htmlInput;

/* HTML encodings */
typedef enum _htmlEncoding {
    htmlEncodingURL         = 0,
    htmlEncodingMultipart   = 1,
    htmlEncodingText        = 2,
    htmlEncoding_Max        = 2147483647
} htmlEncoding;

/* HTML adjacency values */
typedef enum _htmlAdjacency {
    htmlAdjacencyBeforeBegin    = 1,
    htmlAdjacencyAfterBegin     = 2,
    htmlAdjacencyBeforeEnd      = 3,
    htmlAdjacencyAfterEnd       = 4,
    htmlAdjacency_Max           = 2147483647
} htmlAdjacency;

/* HTML tab indices */
typedef enum _htmlTabIndex {
    htmlTabIndexNotSet  = -32768,
    htmlTabIndex_Max    = 2147483647
} htmlTabIndex;

/* HTML component */
typedef enum _htmlComponent {
    htmlComponentClient         = 0,
    htmlComponentSbLeft         = 1,
    htmlComponentSbPageLeft     = 2,
    htmlComponentSbHThumb       = 3,
    htmlComponentSbPageRight    = 4,
    htmlComponentSbRight        = 5,
    htmlComponentSbUp           = 6,
    htmlComponentSbPageUp       = 7,
    htmlComponentSbVThumb       = 8,
    htmlComponentSbPageDown     = 9,
    htmlComponentSbDown         = 10,
    htmlComponentSbLeft2        = 11,
    htmlComponentSbPageLeft2    = 12,
    htmlComponentSbRight2       = 13,
    htmlComponentSbPageRight2   = 14,
    htmlComponentSbUp2          = 15,
    htmlComponentSbPageUp2      = 16,
    htmlComponentSbDown2        = 17,
    htmlComponentSbPageDown2    = 18,
    htmlComponentSbTop          = 19,
    htmlComponentSbBottom       = 20,
    htmlComponentOutside        = 21,
    htmlComponentGHTopLeft      = 22,
    htmlComponentGHLeft         = 23,
    htmlComponentGHTop          = 24,
    htmlComponentGHBottomLeft   = 25,
    htmlComponentGHTopRight     = 26,
    htmlComponentGHBottom       = 27,
    htmlComponentGHRight        = 28,
    htmlComponentGHBottomRight  = 29,
    htmlComponent_Max           = 2147483647
} htmlComponent;

/* HTML apply locations */
typedef enum _htmlApplyLocation {
    htmlApplyLocationInside     = 0,
    htmlApplyLocationOutside    = 1,
    htmlApplyLocation_Max       = 2147483647
} htmlApplyLocation;

/* HTML glyph modes */
typedef enum _htmlGlyphMode {
    htmlGlyphModeNone   = 0,
    htmlGlyphModeBegin  = 1,
    htmlGlyphModeEnd    = 2,
    htmlGlyphModeBoth   = 3,
    htmlGlyphMode_Max   = 2147483647
} htmlGlyphMode;

/* HTML units */
typedef enum _htmlUnit {
    htmlUnitCharacter   = 1,
    htmlUnitWord        = 2,
    htmlUnitSentence    = 3,
    htmlUnitTextEdit    = 6,
    htmlUnit_Max        = 2147483647
} htmlUnit;

/* HTML end points */
typedef enum _htmlEndPoints {
    htmlEndPointsStartToStart   = 1,
    htmlEndPointsStartToEnd     = 2,
    htmlEndPointsEndToStart     = 3,
    htmlEndPointsEndToEnd       = 4,
    htmlEndPoints_Max           = 2147483647
} htmlEndPoints;

/* HTML directions */
typedef enum _htmlDirection {
    htmlDirectionForward    = 99999,
    htmlDirectionBackward   = -99999,
    htmlDirection_Max       = 2147483647
} htmlDirection;

/* HTML start values */
typedef enum _htmlStart {
    htmlStartfileopen   = 0,
    htmlStartmouseover  = 1,
    htmlStart_Max       = 2147483647
} htmlStart;

/* Body scroll values */
typedef enum _bodyScroll {
    bodyScrollyes       = 1,
    bodyScrollno        = 2,
    bodyScrolldefault   = 3,
    bodyScrollauto      = 4,
    bodyScroll_Max      = 2147483647
} bodyScroll;

/* HTML select types */
typedef enum _htmlSelectType {
    htmlSelectTypeSelectOne         = 1,
    htmlSelectTypeSelectMultiple    = 2,
    htmlSelectType_Max              = 2147483647
} htmlSelectType;

/* HTML select extended flags */
typedef enum _htmlSelectExFlag {
    htmlSelectExFlagNone                    = 0x00000000,
    htmlSelectExFlagHideSelectionInDesign   = 0x00000001,
    htmlSelectExFlag_Max                    = 2147483647
} htmlSelectExFlag;

/* HTML selection values */
typedef enum _htmlSelection {
    htmlSelectionNone       = 0,
    htmlSelectionText       = 1,
    htmlSelectionControl    = 2,
    htmlSelectionTable      = 3,
    htmlSelection_Max       = 2147483647
} htmlSelection;

/* HTML marquee behaviors */
typedef enum _htmlMarqueeBehavior {
    htmlMarqueeBehaviorscroll       = 1,
    htmlMarqueeBehaviorslide        = 2,
    htmlMarqueeBehavioralternate    = 3,
    htmlMarqueeBehavior_Max         = 2147483647
} htmlMarqueeBehavior;

/* HTML marquee directions */
typedef enum _htmlMarqueeDirection {
    htmlMarqueeDirectionleft    = 1,
    htmlMarqueeDirectionright   = 3,
    htmlMarqueeDirectionup      = 5,
    htmlMarqueeDirectiondown    = 7,
    htmlMarqueeDirection_Max    = 2147483647
} htmlMarqueeDirection;

/* HTML persist states */
typedef enum _htmlPersistState {
    htmlPersistStateNormal      = 0,
    htmlPersistStateFavorite    = 1,
    htmlPersistStateHistory     = 2,
    htmlPersistStateSnapshot    = 3,
    htmlPersistStateUserData    = 4,
    htmlPersistState_Max        = 2147483647
} htmlPersistState;

/* HTML drop effects */
typedef enum _htmlDropEffect {
    htmlDropEffectCopy  = 0,
    htmlDropEffectLink  = 1,
    htmlDropEffectMove  = 2,
    htmlDropEffectNone  = 3,
    htmlDropEffect_Max  = 2147483647
} htmlDropEffect;

/* HTML effect allowed values */
typedef enum _htmlEffectAllowed {
    htmlEffectAllowedCopy           = 0,
    htmlEffectAllowedLink           = 1,
    htmlEffectAllowedMove           = 2,
    htmlEffectAllowedCopyLink       = 3,
    htmlEffectAllowedCopyMove       = 4,
    htmlEffectAllowedLinkMove       = 5,
    htmlEffectAllowedAll            = 6,
    htmlEffectAllowedNone           = 7,
    htmlEffectAllowedUninitialized  = 8,
    htmlEffectAllowed_Max           = 2147483647
} htmlEffectAllowed;

/* HTML compatibility modes */
typedef enum _htmlCompatMode {
    htmlCompatModeBackCompat    = 0,
    htmlCompatModeCSS1Compat    = 1,
    htmlCompatMode_Max          = 2147483647
} htmlCompatMode;

/* Boolean values */
typedef enum _BoolValue {
    False           = 0,
    True            = 1,
    BoolValue_Max   = 2147483647
};

/* HTML caption alignments */
typedef enum _htmlCaptionAlign {
    htmlCaptionAlignNotSet  = 0,
    htmlCaptionAlignLeft    = 1,
    htmlCaptionAlignCenter  = 2,
    htmlCaptionAlignRight   = 3,
    htmlCaptionAlignJustify = 4,
    htmlCaptionAlignTop     = 5,
    htmlCaptionAlignBottom  = 6,
    htmlCaptionAlign_Max    = 2147483647
} htmlCaptionAlign;

/* HTML caption vertical alignments */
typedef enum _htmlCaptionVAlign {
    htmlCaptionVAlignNotSet = 0,
    htmlCaptionVAlignTop    = 1,
    htmlCaptionVAlignBottom = 2,
    htmlCaptionVAlign_Max   = 2147483647
} htmlCaptionVAlign;

/* HTML frames */
typedef enum _htmlFrame {
    htmlFrameNotSet = 0,
    htmlFramevoid   = 1,
    htmlFrameabove  = 2,
    htmlFramebelow  = 3,
    htmlFramehsides = 4,
    htmlFramelhs    = 5,
    htmlFramerhs    = 6,
    htmlFramevsides = 7,
    htmlFramebox    = 8,
    htmlFrameborder = 9,
    htmlFrame_Max   = 2147483647
} htmlFrame;

/* HTML rules */
typedef enum _htmlRules {
    htmlRulesNotSet = 0,
    htmlRulesnone   = 1,
    htmlRulesgroups = 2,
    htmlRulesrows   = 3,
    htmlRulescols   = 4,
    htmlRulesall    = 5,
    htmlRules_Max   = 2147483647
} htmlRules;

/* HTML cell alignments */
typedef enum _htmlCellAlign {
    htmlCellAlignNotSet = 0,
    htmlCellAlignLeft   = 1,
    htmlCellAlignCenter = 2,
    htmlCellAlignRight  = 3,
    htmlCellAlignMiddle = htmlCellAlignCenter,
    htmlCellAlign_Max   = 2147483647
} htmlCellAlign;

/* HTML cell vertical alignments */
typedef enum _htmlCellVAlign {
    htmlCellVAlignNotSet    = 0,
    htmlCellVAlignTop       = 1,
    htmlCellVAlignMiddle    = 2,
    htmlCellVAlignBottom    = 3,
    htmlCellVAlignBaseline  = 4,
    htmlCellVAlignCenter    = htmlCellVAlignMiddle,
    htmlCellVAlign_Max      = 2147483647
} htmlCellVAlign;

/* Frame scrolling values */
typedef enum _frameScrolling {
    frameScrollingyes   = 1,
    frameScrollingno    = 2,
    frameScrollingauto  = 4,
    frameScrolling_Max  = 2147483647
} frameScrolling;

/* Element corners */
typedef enum _ELEMENT_CORNER {
    ELEMENT_CORNER_NONE         = 0,
    ELEMENT_CORNER_TOP          = 1,
    ELEMENT_CORNER_LEFT         = 2,
    ELEMENT_CORNER_BOTTOM       = 3,
    ELEMENT_CORNER_RIGHT        = 4,
    ELEMENT_CORNER_TOPLEFT      = 5,
    ELEMENT_CORNER_TOPRIGHT     = 6,
    ELEMENT_CORNER_BOTTOMLEFT   = 7,
    ELEMENT_CORNER_BOTTOMRIGHT  = 8,
    ELEMENT_CORNER_Max          = 2147483647
} ELEMENT_CORNER;

/* Secure URL host validation flags */
typedef enum _SECUREURLHOSTVALIDATE_FLAGS {
    SUHV_PROMPTBEFORENO             = 0x00000001,
    SUHV_SILENTYES                  = 0x00000002,
    SUHV_UNSECURESOURCE             = 0x00000004,
    SECUREURLHOSTVALIDATE_FLAGS_Max = 2147483647
} SECUREURLHOSTVALIDATE_FLAGS;

/* Pointer gravity values */
typedef enum _POINTER_GRAVITY {
    POINTER_GRAVITY_Left    = 0,
    POINTER_GRAVITY_Right   = 1,
    POINTER_GRAVITY_Max     = 2147483647
} POINTER_GRAVITY;

/* Element adjacency values */
typedef enum _ELEMENT_ADJACENCY {
    ELEM_ADJ_BeforeBegin    = 0,
    ELEM_ADJ_AfterBegin     = 1,
    ELEM_ADJ_BeforeEnd      = 2,
    ELEM_ADJ_AfterEnd       = 3,
    ELEMENT_ADJACENCY_Max   = 2147483647
} ELEMENT_ADJACENCY;

/* Markup context types */
typedef enum _MARKUP_CONTEXT_TYPE {
    CONTEXT_TYPE_None       = 0,
    CONTEXT_TYPE_Text       = 1,
    CONTEXT_TYPE_EnterScope = 2,
    CONTEXT_TYPE_ExitScope  = 3,
    CONTEXT_TYPE_NoScope    = 4,
    MARKUP_CONTEXT_TYPE_Max = 2147483647
} MARKUP_CONTEXT_TYPE;

/* IMarkupPointer::FindText() flags */
typedef enum _FINDTEXT_FLAGS {
    FINDTEXT_BACKWARDS      = 0x00000001,
    FINDTEXT_WHOLEWORD      = 0x00000002,
    FINDTEXT_MATCHCASE      = 0x00000004,
    FINDTEXT_RAW            = 0x00020000,
    FINDTEXT_MATCHDIAC      = 0x20000000,
    FINDTEXT_MATCHKASHIDA   = 0x40000000,
    FINDTEXT_MATCHALEFHAMZA = 0x80000000,
    FINDTEXT_FLAGS_Max      = 2147483647
} FINDTEXT_FLAGS;

/* IMarkupPointer::MoveUnit() actions */
typedef enum _MOVEUNIT_ACTION {
    MOVEUNIT_PREVCHAR           = 0,
    MOVEUNIT_NEXTCHAR           = 1,
    MOVEUNIT_PREVCLUSTERBEGIN   = 2,
    MOVEUNIT_NEXTCLUSTERBEGIN   = 3,
    MOVEUNIT_PREVCLUSTEREND     = 4,
    MOVEUNIT_NEXTCLUSTEREND     = 5,
    MOVEUNIT_PREVWORDBEGIN      = 6,
    MOVEUNIT_NEXTWORDBEGIN      = 7,
    MOVEUNIT_PREVWORDEND        = 8,
    MOVEUNIT_NEXTWORDEND        = 9,
    MOVEUNIT_PREVPROOFWORD      = 10,
    MOVEUNIT_NEXTPROOFWORD      = 11,
    MOVEUNIT_NEXTURLBEGIN       = 12,
    MOVEUNIT_PREVURLBEGIN       = 13,
    MOVEUNIT_NEXTURLEND         = 14,
    MOVEUNIT_PREVURLEND         = 15,
    MOVEUNIT_PREVSENTENCE       = 16,
    MOVEUNIT_NEXTSENTENCE       = 17,
    MOVEUNIT_PREVBLOCK          = 18,
    MOVEUNIT_NEXTBLOCK          = 19,
    MOVEUNIT_ACTION_Max         = 2147483647
} MOVEUNIT_ACTION;

/* Parse flags */
typedef enum _PARSE_FLAGS {
    PARSE_ABSOLUTIFYIE40URLS    = 0x00000001,
    PARSE_FLAGS_Max             = 2147483647
} PARSE_FLAGS;

/* Element tag identifiers */
typedef enum _ELEMENT_TAG_ID {
    TAGID_NULL              = 0,
    TAGID_UNKNOWN           = 1,
    TAGID_A                 = 2,
    TAGID_ACRONYM           = 3,
    TAGID_ADDRESS           = 4,
    TAGID_APPLET            = 5,
    TAGID_AREA              = 6,
    TAGID_B                 = 7,
    TAGID_BASE              = 8,
    TAGID_BASEFONT          = 9,
    TAGID_BDO               = 10,
    TAGID_BGSOUND           = 11,
    TAGID_BIG               = 12,
    TAGID_BLINK             = 13,
    TAGID_BLOCKQUOTE        = 14,
    TAGID_BODY              = 15,
    TAGID_BR                = 16,
    TAGID_BUTTON            = 17,
    TAGID_CAPTION           = 18,
    TAGID_CENTER            = 19,
    TAGID_CITE              = 20,
    TAGID_CODE              = 21,
    TAGID_COL               = 22,
    TAGID_COLGROUP          = 23,
    TAGID_COMMENT           = 24,
    TAGID_COMMENT_RAW       = 25,
    TAGID_DD                = 26,
    TAGID_DEL               = 27,
    TAGID_DFN               = 28,
    TAGID_DIR               = 29,
    TAGID_DIV               = 30,
    TAGID_DL                = 31,
    TAGID_DT                = 32,
    TAGID_EM                = 33,
    TAGID_EMBED             = 34,
    TAGID_FIELDSET          = 35,
    TAGID_FONT              = 36,
    TAGID_FORM              = 37,
    TAGID_FRAME             = 38,
    TAGID_FRAMESET          = 39,
    TAGID_GENERIC           = 40,
    TAGID_H1                = 41,
    TAGID_H2                = 42,
    TAGID_H3                = 43,
    TAGID_H4                = 44,
    TAGID_H5                = 45,
    TAGID_H6                = 46,
    TAGID_HEAD              = 47,
    TAGID_HR                = 48,
    TAGID_HTML              = 49,
    TAGID_I                 = 50,
    TAGID_IFRAME            = 51,
    TAGID_IMG               = 52,
    TAGID_INPUT             = 53,
    TAGID_INS               = 54,
    TAGID_KBD               = 55,
    TAGID_LABEL             = 56,
    TAGID_LEGEND            = 57,
    TAGID_LI                = 58,
    TAGID_LINK              = 59,
    TAGID_LISTING           = 60,
    TAGID_MAP               = 61,
    TAGID_MARQUEE           = 62,
    TAGID_MENU              = 63,
    TAGID_META              = 64,
    TAGID_NEXTID            = 65,
    TAGID_NOBR              = 66,
    TAGID_NOEMBED           = 67,
    TAGID_NOFRAMES          = 68,
    TAGID_NOSCRIPT          = 69,
    TAGID_OBJECT            = 70,
    TAGID_OL                = 71,
    TAGID_OPTION            = 72,
    TAGID_P                 = 73,
    TAGID_PARAM             = 74,
    TAGID_PLAINTEXT         = 75,
    TAGID_PRE               = 76,
    TAGID_Q                 = 77,
    TAGID_RP                = 78,
    TAGID_RT                = 79,
    TAGID_RUBY              = 80,
    TAGID_S                 = 81,
    TAGID_SAMP              = 82,
    TAGID_SCRIPT            = 83,
    TAGID_SELECT            = 84,
    TAGID_SMALL             = 85,
    TAGID_SPAN              = 86,
    TAGID_STRIKE            = 87,
    TAGID_STRONG            = 88,
    TAGID_STYLE             = 89,
    TAGID_SUB               = 90,
    TAGID_SUP               = 91,
    TAGID_TABLE             = 92,
    TAGID_TBODY             = 93,
    TAGID_TC                = 94,
    TAGID_TD                = 95,
    TAGID_TEXTAREA          = 96,
    TAGID_TFOOT             = 97,
    TAGID_TH                = 98,
    TAGID_THEAD             = 99,
    TAGID_TITLE             = 100,
    TAGID_TR                = 101,
    TAGID_TT                = 102,
    TAGID_U                 = 103,
    TAGID_UL                = 104,
    TAGID_VAR               = 105,
    TAGID_WBR               = 106,
    TAGID_XMP               = 107,
    TAGID_ROOT              = 108,
    TAGID_OPTGROUP          = 109,
    TAGID_ABBR              = 110,
    TAGID_COUNT             = 111,
    TAGID_LAST_PREDEFINED   = 10000,
    ELEMENT_TAG_ID_Max      = 2147483647
} ELEMENT_TAG_ID;

/* Selection types */
typedef enum _SELECTION_TYPE {
    SELECTION_TYPE_None     = 0,
    SELECTION_TYPE_Caret    = 1,
    SELECTION_TYPE_Text     = 2,
    SELECTION_TYPE_Control  = 3,
    SELECTION_TYPE_Max      = 2147483647
} SELECTION_TYPE;

/* Save segments flags */
typedef enum _SAVE_SEGMENTS_FLAGS {
    SAVE_SEGMENTS_NoIE4SelectionCompat  = 0x00000001,
    SAVE_SEGMENTS_FLAGS_Max             = 2147483647
} SAVE_SEGMENTS_FLAGS;

/* Caret directions */
typedef enum _CARET_DIRECTION {
    CARET_DIRECTION_INDETERMINATE   = 0,
    CARET_DIRECTION_SAME            = 1,
    CARET_DIRECTION_BACKWARD        = 2,
    CARET_DIRECTION_FORWARD         = 3,
    CARET_DIRECTION_Max             = 2147483647
} CARET_DIRECTION;

/* Line directions */
typedef enum _LINE_DIRECTION {
    LINE_DIRECTION_RightToLeft  = 1,
    LINE_DIRECTION_LeftToRight  = 2,
    LINE_DIRECTION_Max          = 2147483647
} LINE_DIRECTION;

/* Hypertext options */
typedef enum _HT_OPTIONS {
    HT_OPT_AllowAfterEOL    = 0x00000001,
    HT_OPTIONS_Max          = 2147483647
} HT_OPTIONS;

/* Hypertext results */
typedef enum _HT_RESULTS {
    HT_RESULTS_Glyph    = 0x00000001,
    HT_RESULTS_Max      = 2147483647
} HT_RESULTS;

/* IDisplayPointer::MoveUnit() move units */
typedef enum _DISPLAY_MOVEUNIT {
    DISPLAY_MOVEUNIT_PreviousLine       = 1,
    DISPLAY_MOVEUNIT_NextLine           = 2,
    DISPLAY_MOVEUNIT_CurrentLineStart   = 3,
    DISPLAY_MOVEUNIT_CurrentLineEnd     = 4,
    DISPLAY_MOVEUNIT_TopOfWindow        = 5,
    DISPLAY_MOVEUNIT_BottomOfWindow     = 6,
    DISPLAY_MOVEUNIT_Max                = 2147483647
} DISPLAY_MOVEUNIT;

/* Display gravity values */
typedef enum _DISPLAY_GRAVITY {
    DISPLAY_GRAVITY_PreviousLine    = 1,
    DISPLAY_GRAVITY_NextLine        = 2,
    DISPLAY_GRAVITY_Max             = 2147483647
} DISPLAY_GRAVITY;

/* Display break values */
typedef enum _DISPLAY_BREAK {
    DISPLAY_BREAK_None  = 0x00000000,
    DISPLAY_BREAK_Block = 0x00000001,
    DISPLAY_BREAK_Break = 0x00000002,
    DISPLAY_BREAK_Max   = 2147483647
} DISPLAY_BREAK;

/* Coordinate systems */
typedef enum _COORD_SYSTEM {
    COORD_SYSTEM_GLOBAL     = 0,
    COORD_SYSTEM_PARENT     = 1,
    COORD_SYSTEM_CONTAINER  = 2,
    COORD_SYSTEM_CONTENT    = 3,
    COORD_SYSTEM_FRAME      = 4,
    COORD_SYSTEM_Max        = 2147483647
} COORD_SYSTEM;

/* HTML painter flags */
typedef enum _HTML_PAINTER {
    HTMLPAINTER_OPAQUE          = 0x00000001,
    HTMLPAINTER_TRANSPARENT     = 0x00000002,
    HTMLPAINTER_ALPHA           = 0x00000004,
    HTMLPAINTER_COMPLEX         = 0x00000008,
    HTMLPAINTER_OVERLAY         = 0x00000010,
    HTMLPAINTER_HITTEST         = 0x00000020,
    HTMLPAINTER_SURFACE         = 0x00000100,
    HTMLPAINTER_3DSURFACE       = 0x00000200,
    HTMLPAINTER_NOBAND          = 0x00000400,
    HTMLPAINTER_NODC            = 0x00001000,
    HTMLPAINTER_NOPHYSICALCLIP  = 0x00002000,
    HTMLPAINTER_NOSAVEDC        = 0x00004000,
    HTMLPAINTER_SUPPORTS_XFORM  = 0x00008000,
    HTMLPAINTER_EXPAND          = 0x00010000,
    HTMLPAINTER_NOSCROLLBITS    = 0x00020000,
    HTML_PAINTER_Max            = 2147483647
} HTML_PAINTER;

/* HTML paint z-order values */
typedef enum _HTML_PAINT_ZORDER {
    HTMLPAINT_ZORDER_NONE               = 0,
    HTMLPAINT_ZORDER_REPLACE_ALL        = 1,
    HTMLPAINT_ZORDER_REPLACE_CONTENT    = 2,
    HTMLPAINT_ZORDER_REPLACE_BACKGROUND = 3,
    HTMLPAINT_ZORDER_BELOW_CONTENT      = 4,
    HTMLPAINT_ZORDER_BELOW_FLOW         = 5,
    HTMLPAINT_ZORDER_ABOVE_FLOW         = 6,
    HTMLPAINT_ZORDER_ABOVE_CONTENT      = 7,
    HTMLPAINT_ZORDER_WINDOW_TOP         = 8,
    HTML_PAINT_ZORDER_Max               = 2147483647
} HTML_PAINT_ZORDER;

/* HTML paint draw flags */
typedef enum _HTML_PAINT_DRAW_FLAGS {
    HTMLPAINT_DRAW_UPDATEREGION = 0x00000001,
    HTMLPAINT_DRAW_USE_XFORM    = 0x00000002,
    HTML_PAINT_DRAW_FLAGS_Max   = 2147483647
} HTML_PAINT_DRAW_FLAGS;

/* HTML paint event flags */
typedef enum _HTML_PAINT_EVENT_FLAGS {
    HTMLPAINT_EVENT_TARGET      = 0x00000001,
    HTMLPAINT_EVENT_SETCURSOR   = 0x00000002,
    HTML_PAINT_EVENT_FLAGS_Max  = 2147483647
} HTML_PAINT_EVENT_FLAGS;

/* HTML paint draw information flags */
typedef enum _HTML_PAINT_DRAW_INFO_FLAGS {
    HTMLPAINT_DRAWINFO_VIEWPORT     = 0x00000001,
    HTMLPAINT_DRAWINFO_UPDATEREGION = 0x00000002,
    HTMLPAINT_DRAWINFO_XFORM        = 0x00000004,
    HTML_PAINT_DRAW_INFO_FLAGS_Max  = 2147483647
} HTML_PAINT_DRAW_INFO_FLAGS;

/* HTML painter information */
typedef struct _HTML_PAINTER_INFO {
    LONG    lFlags;
    LONG    lZOrder;
    IID     iidDrawObject;
    RECT    rcExpand;
} HTML_PAINTER_INFO;

/* HTML paint transformation */
typedef struct _HTML_PAINT_XFORM {
    FLOAT   eM11;
    FLOAT   eM12;
    FLOAT   eM21;
    FLOAT   eM22;
    FLOAT   eDx;
    FLOAT   eDy;
} HTML_PAINT_XFORM;

/* HTML paint draw information */
typedef struct _HTML_PAINT_DRAW_INFO {
    RECT                rcViewport;
    HRGN                hrgnUpdate;
    HTML_PAINT_XFORM    xform;
} HTML_PAINT_DRAW_INFO;

/* HTML dialog flags */
typedef enum _HTMLDlgFlag {
    HTMLDlgFlagNo       = 0,
    HTMLDlgFlagOff      = 0,
    HTMLDlgFlag0        = 0,
    HTMLDlgFlagYes      = 1,
    HTMLDlgFlagOn       = 1,
    HTMLDlgFlag1        = 1,
    HTMLDlgFlagNotSet   = -1,
    HTMLDlgFlag_Max     = 2147483647
} HTMLDlgFlag;

/* HTML dialog border types */
typedef enum _HTMLDlgBorder {
    HTMLDlgBorderThin   = 0x00000000,
    HTMLDlgBorderThick  = 0x00040000,
    HTMLDlgBorder_Max   = 2147483647
} HTMLDlgBorder;

/* HTML dialog edge types */
typedef enum _HTMLDlgEdge {
    HTMLDlgEdgeSunken   = 0,
    HTMLDlgEdgeRaised   = 1,
    HTMLDlgEdge_Max     = 2147483647
} HTMLDlgEdge;

/* HTML dialog center values */
typedef enum _HTMLDlgCenter {
    HTMLDlgCenterNo         = 0,
    HTMLDlgCenterOff        = 0,
    HTMLDlgCenter0          = 0,
    HTMLDlgCenterYes        = 1,
    HTMLDlgCenterOn         = 1,
    HTMLDlgCenter1          = 1,
    HTMLDlgCenterParent     = 1,
    HTMLDlgCenterDesktop    = 2,
    HTMLDlgCenter_Max       = 2147483647
} HTMLDlgCenter;

/* HTML application flags */
typedef enum _HTMLAppFlag {
    HTMLAppFlagNo   = 0,
    HTMLAppFlagOff  = 0,
    HTMLAppFlag0    = 0,
    HTMLAppFlagYes  = 1,
    HTMLAppFlagOn   = 1,
    HTMLAppFlag1    = 1,
    HTMLAppFlag_Max = 2147483647
} HTMLAppFlag;

/* HTML minimize flags */
typedef enum _HTMLMinimizeFlag {
    HTMLMinimizeFlagNo      = 0x00000000,
    HTMLMinimizeFlagYes     = 0x00020000,
    HTMLMinimizeFlag_Max    = 2147483647
} HTMLMinimizeFlag;

/* HTML maximize flags */
typedef enum _HTMLMaximizeFlag {
    HTMLMaximizeFlagNo      = 0x00000000,
    HTMLMaximizeFlagYes     = 0x00010000,
    HTMLMaximizeFlag_Max    = 2147483647
} HTMLMaximizeFlag;

/* HTML caption flags */
typedef enum _HTMLCaptionFlag {
    HTMLCaptionFlagNo   = 0x00000000,
    HTMLCaptionFlagYes  = 0x00C00000,
    HTMLCaptionFlag_Max = 2147483647
} HTMLCaptionFlag;

/* HTML system menu flags */
typedef enum _HTMLSysMenuFlag {
    HTMLSysMenuFlagNo   = 0x00000000,
    HTMLSysMenuFlagYes  = 0x00080000,
    HTMLSysMenuFlag_Max = 2147483647
} HTMLSysMenuFlag;

/* HTML border types */
typedef enum _HTMLBorder {
    HTMLBorderNone      = 0x00000000,
    HTMLBorderThick     = 0x00040000,
    HTMLBorderDialog    = 0x00400000,
    HTMLBorderThin      = 0x00800000,
    HTMLBorder_Max      = 2147483647
} HTMLBorder;

/* HTML border styles */
typedef enum _HTMLBorderStyle {
    HTMLBorderStyleNormal   = 0x00000000,
    HTMLBorderStyleRaised   = 0x00000100,
    HTMLBorderStyleSunken   = 0x00000200,
    HTMLBorderStylecombined = 0x00000300,
    HTMLBorderStyleStatic   = 0x00020000,
    HTMLBorderStyle_Max     = 2147483647
} HTMLBorderStyle;

/* HTML window states */
typedef enum _HTMLWindowState {
    HTMLWindowStateNormal   = 1,
    HTMLWindowStateMaximize = 3,
    HTMLWindowStateMinimize = 6,
    HTMLWindowState_Max     = 2147483647
} HTMLWindowState;

/* Behavior events */
typedef enum _BEHAVIOR_EVENT {
    BEHAVIOREVENT_FIRST                 = 0,
    BEHAVIOREVENT_CONTENTREADY          = 0,
    BEHAVIOREVENT_DOCUMENTREADY         = 1,
    BEHAVIOREVENT_APPLYSTYLE            = 2,
    BEHAVIOREVENT_DOCUMENTCONTEXTCHANGE = 3,
    BEHAVIOREVENT_CONTENTSAVE           = 4,
    BEHAVIOREVENT_LAST                  = 4,
    BEHAVIOR_EVENT_Max                  = 2147483647
} BEHAVIOR_EVENT;

/* Behavior event flags */
typedef enum _BEHAVIOR_EVENT_FLAGS {
    BEHAVIOREVENTFLAGS_BUBBLE           = 1,
    BEHAVIOREVENTFLAGS_STANDARDADDITIVE = 2,
    BEHAVIOR_EVENT_FLAGS_Max            = 2147483647
} BEHAVIOR_EVENT_FLAGS;

/* Behavior render information flags */
typedef enum _BEHAVIOR_RENDER_INFO {
    BEHAVIORRENDERINFO_BEFOREBACKGROUND     = 0x00000001,
    BEHAVIORRENDERINFO_AFTERBACKGROUND      = 0x00000002,
    BEHAVIORRENDERINFO_BEFORECONTENT        = 0x00000004,
    BEHAVIORRENDERINFO_AFTERCONTENT         = 0x00000008,
    BEHAVIORRENDERINFO_AFTERFOREGROUND      = 0x00000020,
    BEHAVIORRENDERINFO_ABOVECONTENT         = 0x00000028,
    BEHAVIORRENDERINFO_ALLLAYERS            = 0x000000FF,
    BEHAVIORRENDERINFO_DISABLEBACKGROUND    = 0x00000100,
    BEHAVIORRENDERINFO_DISABLENEGATIVEZ     = 0x00000200,
    BEHAVIORRENDERINFO_DISABLECONTENT       = 0x00000400,
    BEHAVIORRENDERINFO_DISABLEPOSITIVEZ     = 0x00000800,
    BEHAVIORRENDERINFO_DISABLEALLLAYERS     = 0x00000F00,
    BEHAVIORRENDERINFO_HITTESTING           = 0x00001000,
    BEHAVIORRENDERINFO_SURFACE              = 0x00100000,
    BEHAVIORRENDERINFO_3DSURFACE            = 0x00200000,
    BEHAVIOR_RENDER_INFO_Max                = 2147483647
} BEHAVIOR_RENDER_INFO;

/* Behavior relations */
typedef enum _BEHAVIOR_RELATION {
    BEHAVIOR_FIRSTRELATION  = 0,
    BEHAVIOR_SAMEELEMENT    = 0,
    BEHAVIOR_PARENT         = 1,
    BEHAVIOR_CHILD          = 2,
    BEHAVIOR_SIBLING        = 3,
    BEHAVIOR_LASTRELATION   = 4,
    BEHAVIOR_RELATION_Max   = 2147483647
} BEHAVIOR_RELATION;

/* Behavior layout information flags */
typedef enum _BEHAVIOR_LAYOUT_INFO {
    BEHAVIORLAYOUTINFO_FULLDELEGATION   = 0x00000001,
    BEHAVIORLAYOUTINFO_MODIFYNATURAL    = 0x00000002,
    BEHAVIORLAYOUTINFO_MAPSIZE          = 0x00000004,
    BEHAVIOR_LAYOUT_INFO_Max            = 2147483647
} BEHAVIOR_LAYOUT_INFO;

/* Behavior layout modes */
typedef enum _BEHAVIOR_LAYOUT_MODE {
    BEHAVIORLAYOUTMODE_NATURAL          = 0x00000001,
    BEHAVIORLAYOUTMODE_MINWIDTH         = 0x00000002,
    BEHAVIORLAYOUTMODE_MAXWIDTH         = 0x00000004,
    BEHAVIORLAYOUTMODE_MEDIA_RESOLUTION = 0x00004000,
    BEHAVIORLAYOUTMODE_FINAL_PERCENT    = 0x00008000,
    BEHAVIOR_LAYOUT_MODE_Max            = 2147483647
} BEHAVIOR_LAYOUT_MODE;

/* Element descriptor flags */
typedef enum _ELEMENTDESCRIPTOR_FLAGS {
    ELEMENTDESCRIPTORFLAGS_LITERAL          = 1,
    ELEMENTDESCRIPTORFLAGS_NESTED_LITERAL   = 2,
    ELEMENTDESCRIPTOR_FLAGS_Max             = 2147483647
} ELEMENTDESCRIPTOR_FLAGS;

/* Element namespace flags */
typedef enum _ELEMENTNAMESPACE_FLAGS {
    ELEMENTNAMESPACEFLAGS_ALLOWANYTAG           = 0x00000001,
    ELEMENTNAMESPACEFLAGS_QUERYFORUNKNOWNTAGS   = 0x00000002,
    ELEMENTNAMESPACE_FLAGS_Max                  = 2147483647
} ELEMENTNAMESPACE_FLAGS;

/* GUIDs */
EXTERN_C const IID      IID_IHTMLFiltersCollection;
EXTERN_C const IID      IID_IIE70DispatchEx;
EXTERN_C const IID      IID_IIE80DispatchEx;
EXTERN_C const IID      LIBID_MSHTML;
EXTERN_C const IID      IID_IHTMLDOMConstructor;
EXTERN_C const IID      IID_IHTMLStyle;
EXTERN_C const IID      IID_IHTMLStyle2;
EXTERN_C const IID      IID_IHTMLStyle3;
EXTERN_C const IID      IID_IHTMLStyle4;
EXTERN_C const IID      IID_IHTMLStyle5;
EXTERN_C const IID      IID_IHTMLStyle6;
EXTERN_C const IID      IID_IHTMLRuleStyle;
EXTERN_C const IID      IID_IHTMLRuleStyle2;
EXTERN_C const IID      IID_IHTMLRuleStyle3;
EXTERN_C const IID      IID_IHTMLRuleStyle4;
EXTERN_C const IID      IID_IHTMLRuleStyle5;
EXTERN_C const IID      IID_IHTMLRuleStyle6;
EXTERN_C const IID      DIID_DispHTMLStyle;
EXTERN_C const CLSID    CLSID_HTMLStyle;
EXTERN_C const IID      DIID_DispHTMLRuleStyle;
EXTERN_C const CLSID    CLSID_HTMLRuleStyle;
EXTERN_C const IID      IID_IHTMLRenderStyle;
EXTERN_C const IID      DIID_DispHTMLRenderStyle;
EXTERN_C const CLSID    CLSID_HTMLRenderStyle;
EXTERN_C const IID      IID_IHTMLCurrentStyle;
EXTERN_C const IID      IID_IHTMLCurrentStyle2;
EXTERN_C const IID      IID_IHTMLCurrentStyle3;
EXTERN_C const IID      IID_IHTMLCurrentStyle4;
EXTERN_C const IID      IID_IHTMLCurrentStyle5;
EXTERN_C const IID      DIID_DispHTMLCurrentStyle;
EXTERN_C const CLSID    CLSID_HTMLCurrentStyle;
EXTERN_C const IID      IID_IHTMLRect;
EXTERN_C const IID      IID_IHTMLRectCollection;
EXTERN_C const IID      IID_IHTMLDOMNode;
EXTERN_C const IID      IID_IHTMLDOMNode2;
EXTERN_C const IID      IID_IHTMLDOMAttribute;
EXTERN_C const IID      IID_IHTMLDOMAttribute2;
EXTERN_C const IID      IID_IHTMLDOMAttribute3;
EXTERN_C const IID      IID_IHTMLDOMTextNode;
EXTERN_C const IID      IID_IHTMLDOMTextNode2;
EXTERN_C const IID      IID_IHTMLDOMImplementation;
EXTERN_C const IID      DIID_DispHTMLDOMAttribute;
EXTERN_C const CLSID    CLSID_HTMLDOMAttribute;
EXTERN_C const IID      DIID_DispHTMLDOMTextNode;
EXTERN_C const CLSID    CLSID_HTMLDOMTextNode;
EXTERN_C const IID      DIID_DispHTMLDOMImplementation;
EXTERN_C const CLSID    CLSID_HTMLDOMImplementation;
EXTERN_C const IID      IID_IHTMLAttributeCollection;
EXTERN_C const IID      IID_IHTMLAttributeCollection2;
EXTERN_C const IID      IID_IHTMLAttributeCollection3;
EXTERN_C const IID      IID_IHTMLDOMChildrenCollection;
EXTERN_C const IID      DIID_DispHTMLAttributeCollection;
EXTERN_C const CLSID    CLSID_HTMLAttributeCollection;
EXTERN_C const IID      DIID_DispStaticNodeList;
EXTERN_C const CLSID    CLSID_StaticNodeList;
EXTERN_C const IID      DIID_DispDOMChildrenCollection;
EXTERN_C const CLSID    CLSID_DOMChildrenCollection;
EXTERN_C const IID      DIID_HTMLElementEvents3;
EXTERN_C const IID      DIID_HTMLElementEvents2;
EXTERN_C const IID      DIID_HTMLElementEvents;
EXTERN_C const IID      IID_IHTMLElement;
EXTERN_C const IID      IID_IHTMLElement2;
EXTERN_C const IID      IID_IHTMLElement3;
EXTERN_C const IID      IID_IHTMLElement4;
EXTERN_C const IID      IID_IElementSelector;
EXTERN_C const IID      IID_IHTMLElementRender;
EXTERN_C const IID      IID_IHTMLUniqueName;
EXTERN_C const IID      IID_IHTMLElement5;
EXTERN_C const IID      IID_IHTMLDatabinding;
EXTERN_C const IID      IID_IHTMLElementDefaults;
EXTERN_C const IID      DIID_DispHTMLDefaults;
EXTERN_C const CLSID    CLSID_HTMLDefaults;
EXTERN_C const IID      IID_IHTCDefaultDispatch;
EXTERN_C const IID      IID_IHTCPropertyBehavior;
EXTERN_C const IID      IID_IHTCMethodBehavior;
EXTERN_C const IID      IID_IHTCEventBehavior;
EXTERN_C const IID      IID_IHTCAttachBehavior;
EXTERN_C const IID      IID_IHTCAttachBehavior2;
EXTERN_C const IID      IID_IHTCDescBehavior;
EXTERN_C const IID      DIID_DispHTCDefaultDispatch;
EXTERN_C const CLSID    CLSID_HTCDefaultDispatch;
EXTERN_C const IID      DIID_DispHTCPropertyBehavior;
EXTERN_C const CLSID    CLSID_HTCPropertyBehavior;
EXTERN_C const IID      DIID_DispHTCMethodBehavior;
EXTERN_C const CLSID    CLSID_HTCMethodBehavior;
EXTERN_C const IID      DIID_DispHTCEventBehavior;
EXTERN_C const CLSID    CLSID_HTCEventBehavior;
EXTERN_C const IID      DIID_DispHTCAttachBehavior;
EXTERN_C const CLSID    CLSID_HTCAttachBehavior;
EXTERN_C const IID      DIID_DispHTCDescBehavior;
EXTERN_C const CLSID    CLSID_HTCDescBehavior;
EXTERN_C const IID      IID_IHTMLUrnCollection;
EXTERN_C const IID      DIID_DispHTMLUrnCollection;
EXTERN_C const CLSID    CLSID_HTMLUrnCollection;
EXTERN_C const IID      IID_IHTMLGenericElement;
EXTERN_C const IID      DIID_DispHTMLGenericElement;
EXTERN_C const CLSID    CLSID_HTMLGenericElement;
EXTERN_C const IID      IID_IHTMLStyleSheetRule;
EXTERN_C const IID      IID_IHTMLStyleSheetRulesCollection;
EXTERN_C const IID      DIID_DispHTMLStyleSheetRule;
EXTERN_C const CLSID    CLSID_HTMLStyleSheetRule;
EXTERN_C const IID      DIID_DispHTMLStyleSheetRulesCollection;
EXTERN_C const CLSID    CLSID_HTMLStyleSheetRulesCollection;
EXTERN_C const IID      IID_IHTMLStyleSheetPage;
EXTERN_C const IID      IID_IHTMLStyleSheetPagesCollection;
EXTERN_C const IID      DIID_DispHTMLStyleSheetPage;
EXTERN_C const CLSID    CLSID_HTMLStyleSheetPage;
EXTERN_C const IID      DIID_DispHTMLStyleSheetPagesCollection;
EXTERN_C const CLSID    CLSID_HTMLStyleSheetPagesCollection;
EXTERN_C const IID      IID_IHTMLStyleSheet;
EXTERN_C const IID      IID_IHTMLStyleSheet2;
EXTERN_C const IID      IID_IHTMLStyleSheet3;
EXTERN_C const IID      DIID_DispHTMLStyleSheet;
EXTERN_C const CLSID    CLSID_HTMLStyleSheet;
EXTERN_C const IID      IID_IHTMLStyleSheetsCollection;
EXTERN_C const IID      DIID_DispHTMLStyleSheetsCollection;
EXTERN_C const CLSID    CLSID_HTMLStyleSheetsCollection;
EXTERN_C const IID      DIID_HTMLLinkElementEvents2;
EXTERN_C const IID      DIID_HTMLLinkElementEvents;
EXTERN_C const IID      IID_IHTMLLinkElement;
EXTERN_C const IID      IID_IHTMLLinkElement2;
EXTERN_C const IID      IID_IHTMLLinkElement3;
EXTERN_C const IID      IID_IHTMLLinkElement4;
EXTERN_C const IID      DIID_DispHTMLLinkElement;
EXTERN_C const CLSID    CLSID_HTMLLinkElement;
EXTERN_C const IID      IID_IHTMLTxtRange;
EXTERN_C const IID      IID_IHTMLTextRangeMetrics;
EXTERN_C const IID      IID_IHTMLTextRangeMetrics2;
EXTERN_C const IID      IID_IHTMLTxtRangeCollection;
EXTERN_C const IID      DIID_HTMLFormElementEvents2;
EXTERN_C const IID      DIID_HTMLFormElementEvents;
EXTERN_C const IID      IID_IHTMLFormElement;
EXTERN_C const IID      IID_IHTMLFormElement2;
EXTERN_C const IID      IID_IHTMLFormElement3;
EXTERN_C const IID      IID_IHTMLSubmitData;
EXTERN_C const IID      IID_IHTMLFormElement4;
EXTERN_C const IID      DIID_DispHTMLFormElement;
EXTERN_C const CLSID    CLSID_HTMLFormElement;
EXTERN_C const IID      DIID_HTMLControlElementEvents2;
EXTERN_C const IID      DIID_HTMLControlElementEvents;
EXTERN_C const IID      IID_IHTMLControlElement;
EXTERN_C const IID      IID_IHTMLTextElement;
EXTERN_C const IID      DIID_DispHTMLTextElement;
EXTERN_C const CLSID    CLSID_HTMLTextElement;
EXTERN_C const IID      DIID_HTMLTextContainerEvents2;
EXTERN_C const IID      DIID_HTMLTextContainerEvents;
EXTERN_C const IID      IID_IHTMLTextContainer;
EXTERN_C const IID      IID_IHTMLControlRange;
EXTERN_C const IID      IID_IHTMLControlRange2;
EXTERN_C const IID      DIID_HTMLImgEvents2;
EXTERN_C const IID      DIID_HTMLImgEvents;
EXTERN_C const IID      IID_IHTMLImgElement;
EXTERN_C const IID      IID_IHTMLImgElement2;
EXTERN_C const IID      IID_IHTMLImgElement3;
EXTERN_C const IID      IID_IHTMLImageElementFactory;
EXTERN_C const IID      DIID_DispHTMLImg;
EXTERN_C const CLSID    CLSID_HTMLImg;
EXTERN_C const CLSID    CLSID_HTMLImageElementFactory;
EXTERN_C const IID      DIID_HTMLXMLHttpRequestEvents;
EXTERN_C const IID      IID_IHTMLXMLHttpRequest;
EXTERN_C const IID      IID_IHTMLXMLHttpRequest2;
EXTERN_C const IID      IID_IHTMLXMLHttpRequestFactory;
EXTERN_C const IID      DIID_DispHTMLXMLHttpRequest;
EXTERN_C const CLSID    CLSID_HTMLXMLHttpRequest;
EXTERN_C const CLSID    CLSID_HTMLXMLHttpRequestFactory;
EXTERN_C const IID      IID_IHTMLBodyElement;
EXTERN_C const IID      IID_IHTMLBodyElement2;
EXTERN_C const IID      IID_IHTMLBodyElement3;
EXTERN_C const IID      DIID_DispHTMLBody;
EXTERN_C const CLSID    CLSID_HTMLBody;
EXTERN_C const IID      IID_IHTMLFontElement;
EXTERN_C const IID      DIID_DispHTMLFontElement;
EXTERN_C const CLSID    CLSID_HTMLFontElement;
EXTERN_C const IID      DIID_HTMLAnchorEvents2;
EXTERN_C const IID      DIID_HTMLAnchorEvents;
EXTERN_C const IID      IID_IHTMLAnchorElement;
EXTERN_C const IID      IID_IHTMLAnchorElement2;
EXTERN_C const IID      IID_IHTMLAnchorElement3;
EXTERN_C const IID      DIID_DispHTMLAnchorElement;
EXTERN_C const CLSID    CLSID_HTMLAnchorElement;
EXTERN_C const IID      DIID_HTMLLabelEvents2;
EXTERN_C const IID      DIID_HTMLLabelEvents;
EXTERN_C const IID      IID_IHTMLLabelElement;
EXTERN_C const IID      IID_IHTMLLabelElement2;
EXTERN_C const IID      DIID_DispHTMLLabelElement;
EXTERN_C const CLSID    CLSID_HTMLLabelElement;
EXTERN_C const IID      IID_IHTMLListElement;
EXTERN_C const IID      IID_IHTMLListElement2;
EXTERN_C const IID      DIID_DispHTMLListElement;
EXTERN_C const CLSID    CLSID_HTMLListElement;
EXTERN_C const IID      IID_IHTMLUListElement;
EXTERN_C const IID      DIID_DispHTMLUListElement;
EXTERN_C const CLSID    CLSID_HTMLUListElement;
EXTERN_C const IID      IID_IHTMLOListElement;
EXTERN_C const IID      DIID_DispHTMLOListElement;
EXTERN_C const CLSID    CLSID_HTMLOListElement;
EXTERN_C const IID      IID_IHTMLLIElement;
EXTERN_C const IID      DIID_DispHTMLLIElement;
EXTERN_C const CLSID    CLSID_HTMLLIElement;
EXTERN_C const IID      IID_IHTMLBlockElement;
EXTERN_C const IID      IID_IHTMLBlockElement2;
EXTERN_C const IID      IID_IHTMLBlockElement3;
EXTERN_C const IID      DIID_DispHTMLBlockElement;
EXTERN_C const CLSID    CLSID_HTMLBlockElement;
EXTERN_C const IID      IID_IHTMLDivElement;
EXTERN_C const IID      DIID_DispHTMLDivElement;
EXTERN_C const CLSID    CLSID_HTMLDivElement;
EXTERN_C const IID      IID_IHTMLDDElement;
EXTERN_C const IID      DIID_DispHTMLDDElement;
EXTERN_C const CLSID    CLSID_HTMLDDElement;
EXTERN_C const IID      IID_IHTMLDTElement;
EXTERN_C const IID      DIID_DispHTMLDTElement;
EXTERN_C const CLSID    CLSID_HTMLDTElement;
EXTERN_C const IID      IID_IHTMLBRElement;
EXTERN_C const IID      DIID_DispHTMLBRElement;
EXTERN_C const CLSID    CLSID_HTMLBRElement;
EXTERN_C const IID      IID_IHTMLDListElement;
EXTERN_C const IID      DIID_DispHTMLDListElement;
EXTERN_C const CLSID    CLSID_HTMLDListElement;
EXTERN_C const IID      IID_IHTMLHRElement;
EXTERN_C const IID      DIID_DispHTMLHRElement;
EXTERN_C const CLSID    CLSID_HTMLHRElement;
EXTERN_C const IID      IID_IHTMLParaElement;
EXTERN_C const IID      DIID_DispHTMLParaElement;
EXTERN_C const CLSID    CLSID_HTMLParaElement;
EXTERN_C const IID      IID_IHTMLElementCollection;
EXTERN_C const IID      IID_IHTMLElementCollection2;
EXTERN_C const IID      IID_IHTMLElementCollection3;
EXTERN_C const IID      IID_IHTMLElementCollection4;
EXTERN_C const IID      DIID_DispHTMLElementCollection;
EXTERN_C const CLSID    CLSID_HTMLElementCollection;
EXTERN_C const IID      IID_IHTMLHeaderElement;
EXTERN_C const IID      DIID_DispHTMLHeaderElement;
EXTERN_C const CLSID    CLSID_HTMLHeaderElement;
EXTERN_C const IID      DIID_HTMLSelectElementEvents2;
EXTERN_C const IID      DIID_HTMLSelectElementEvents;
EXTERN_C const IID      IID_IHTMLSelectElementEx;
EXTERN_C const IID      IID_IHTMLSelectElement;
EXTERN_C const IID      IID_IHTMLSelectElement2;
EXTERN_C const IID      IID_IHTMLSelectElement4;
EXTERN_C const IID      IID_IHTMLSelectElement5;
EXTERN_C const IID      DIID_DispHTMLSelectElement;
EXTERN_C const CLSID    CLSID_HTMLSelectElement;
EXTERN_C const IID      DIID_DispHTMLWndSelectElement;
EXTERN_C const CLSID    CLSID_HTMLWndSelectElement;
EXTERN_C const IID      IID_IHTMLSelectionObject;
EXTERN_C const IID      IID_IHTMLSelectionObject2;
EXTERN_C const IID      IID_IHTMLOptionElement;
EXTERN_C const IID      IID_IHTMLOptionElement3;
EXTERN_C const IID      IID_IHTMLOptionElementFactory;
EXTERN_C const IID      DIID_DispHTMLOptionElement;
EXTERN_C const CLSID    CLSID_HTMLOptionElement;
EXTERN_C const CLSID    CLSID_HTMLOptionElementFactory;
EXTERN_C const IID      DIID_DispHTMLWndOptionElement;
EXTERN_C const CLSID    CLSID_HTMLWndOptionElement;
EXTERN_C const IID      DIID_HTMLButtonElementEvents2;
EXTERN_C const IID      DIID_HTMLButtonElementEvents;
EXTERN_C const IID      DIID_HTMLInputTextElementEvents2;
EXTERN_C const IID      DIID_HTMLOptionButtonElementEvents2;
EXTERN_C const IID      DIID_HTMLInputFileElementEvents2;
EXTERN_C const IID      DIID_HTMLInputImageEvents2;
EXTERN_C const IID      DIID_HTMLInputTextElementEvents;
EXTERN_C const IID      DIID_HTMLOptionButtonElementEvents;
EXTERN_C const IID      DIID_HTMLInputFileElementEvents;
EXTERN_C const IID      DIID_HTMLInputImageEvents;
EXTERN_C const IID      IID_IHTMLInputElement;
EXTERN_C const IID      IID_IHTMLInputElement2;
EXTERN_C const IID      IID_IHTMLInputElement3;
EXTERN_C const IID      IID_IHTMLInputButtonElement;
EXTERN_C const IID      IID_IHTMLInputHiddenElement;
EXTERN_C const IID      IID_IHTMLInputTextElement;
EXTERN_C const IID      IID_IHTMLInputFileElement;
EXTERN_C const IID      IID_IHTMLOptionButtonElement;
EXTERN_C const IID      IID_IHTMLInputImage;
EXTERN_C const IID      DIID_DispHTMLInputElement;
EXTERN_C const CLSID    CLSID_HTMLInputElement;
EXTERN_C const IID      IID_IHTMLTextAreaElement;
EXTERN_C const IID      DIID_DispHTMLTextAreaElement;
EXTERN_C const CLSID    CLSID_HTMLTextAreaElement;
EXTERN_C const IID      DIID_DispHTMLRichtextElement;
EXTERN_C const CLSID    CLSID_HTMLRichtextElement;
EXTERN_C const IID      IID_IHTMLButtonElement;
EXTERN_C const IID      DIID_DispHTMLButtonElement;
EXTERN_C const CLSID    CLSID_HTMLButtonElement;
EXTERN_C const IID      DIID_HTMLMarqueeElementEvents2;
EXTERN_C const IID      DIID_HTMLMarqueeElementEvents;
EXTERN_C const IID      IID_IHTMLMarqueeElement;
EXTERN_C const IID      DIID_DispHTMLMarqueeElement;
EXTERN_C const CLSID    CLSID_HTMLMarqueeElement;
EXTERN_C const IID      IID_IHTMLHtmlElement;
EXTERN_C const IID      IID_IHTMLHeadElement;
EXTERN_C const IID      IID_IHTMLHeadElement2;
EXTERN_C const IID      IID_IHTMLTitleElement;
EXTERN_C const IID      IID_IHTMLMetaElement;
EXTERN_C const IID      IID_IHTMLMetaElement2;
EXTERN_C const IID      IID_IHTMLMetaElement3;
EXTERN_C const IID      IID_IHTMLBaseElement;
EXTERN_C const IID      IID_IHTMLBaseElement2;
EXTERN_C const IID      IID_IHTMLIsIndexElement;
EXTERN_C const IID      IID_IHTMLIsIndexElement2;
EXTERN_C const IID      IID_IHTMLNextIdElement;
EXTERN_C const IID      DIID_DispHTMLHtmlElement;
EXTERN_C const CLSID    CLSID_HTMLHtmlElement;
EXTERN_C const IID      DIID_DispHTMLHeadElement;
EXTERN_C const CLSID    CLSID_HTMLHeadElement;
EXTERN_C const IID      DIID_DispHTMLTitleElement;
EXTERN_C const CLSID    CLSID_HTMLTitleElement;
EXTERN_C const IID      DIID_DispHTMLMetaElement;
EXTERN_C const CLSID    CLSID_HTMLMetaElement;
EXTERN_C const IID      DIID_DispHTMLBaseElement;
EXTERN_C const CLSID    CLSID_HTMLBaseElement;
EXTERN_C const IID      DIID_DispHTMLIsIndexElement;
EXTERN_C const CLSID    CLSID_HTMLIsIndexElement;
EXTERN_C const IID      DIID_DispHTMLNextIdElement;
EXTERN_C const CLSID    CLSID_HTMLNextIdElement;
EXTERN_C const IID      IID_IHTMLBaseFontElement;
EXTERN_C const IID      DIID_DispHTMLBaseFontElement;
EXTERN_C const CLSID    CLSID_HTMLBaseFontElement;
EXTERN_C const IID      IID_IHTMLUnknownElement;
EXTERN_C const IID      DIID_DispHTMLUnknownElement;
EXTERN_C const CLSID    CLSID_HTMLUnknownElement;
EXTERN_C const IID      IID_IOmHistory;
EXTERN_C const IID      IID_IHTMLMimeTypesCollection;
EXTERN_C const IID      IID_IHTMLPluginsCollection;
EXTERN_C const IID      IID_IHTMLOpsProfile;
EXTERN_C const IID      IID_IOmNavigator;
EXTERN_C const IID      IID_IHTMLLocation;
EXTERN_C const IID      DIID_DispHTMLHistory;
EXTERN_C const CLSID    CLSID_HTMLHistory;
EXTERN_C const CLSID    CLSID_CMimeTypes;
EXTERN_C const IID      DIID_DispCPlugins;
EXTERN_C const CLSID    CLSID_CPlugins;
EXTERN_C const CLSID    CLSID_COpsProfile;
EXTERN_C const IID      DIID_DispHTMLNavigator;
EXTERN_C const CLSID    CLSID_HTMLNavigator;
EXTERN_C const IID      DIID_DispHTMLLocation;
EXTERN_C const CLSID    CLSID_HTMLLocation;
EXTERN_C const IID      IID_IHTMLBookmarkCollection;
EXTERN_C const IID      IID_IHTMLDataTransfer;
EXTERN_C const IID      IID_IHTMLEventObj;
EXTERN_C const IID      IID_IHTMLEventObj2;
EXTERN_C const IID      IID_IHTMLEventObj3;
EXTERN_C const IID      IID_IHTMLEventObj4;
EXTERN_C const IID      IID_IHTMLEventObj5;
EXTERN_C const IID      DIID_DispCEventObj;
EXTERN_C const CLSID    CLSID_CEventObj;
EXTERN_C const IID      DIID_HTMLWindowEvents3;
EXTERN_C const IID      DIID_HTMLWindowEvents2;
EXTERN_C const IID      DIID_HTMLWindowEvents;
EXTERN_C const IID      IID_IHTMLFramesCollection2;
EXTERN_C const IID      IID_IHTMLScreen;
EXTERN_C const IID      IID_IHTMLScreen2;
EXTERN_C const IID      IID_IHTMLScreen3;
EXTERN_C const IID      IID_IHTMLWindow2;
EXTERN_C const IID      IID_IHTMLWindow3;
EXTERN_C const IID      IID_IHTMLWindow4;
EXTERN_C const IID      IID_IHTMLWindow5;
EXTERN_C const IID      IID_IHTMLWindow6;
EXTERN_C const CLSID    CLSID_FramesCollection;
EXTERN_C const IID      DIID_DispHTMLScreen;
EXTERN_C const CLSID    CLSID_HTMLScreen;
EXTERN_C const IID      DIID_DispHTMLWindow2;
EXTERN_C const CLSID    CLSID_HTMLWindow2;
EXTERN_C const IID      DIID_DispHTMLWindowProxy;
EXTERN_C const CLSID    CLSID_HTMLWindowProxy;
EXTERN_C const IID      IID_IHTMLDocumentCompatibleInfo;
EXTERN_C const IID      IID_IHTMLDocumentCompatibleInfoCollection;
EXTERN_C const IID      DIID_DispHTMLDocumentCompatibleInfo;
EXTERN_C const CLSID    CLSID_HTMLDocumentCompatibleInfo;
EXTERN_C const IID      DIID_DispHTMLDocumentCompatibleInfoCollection;
EXTERN_C const CLSID    CLSID_HTMLDocumentCompatibleInfoCollection;
EXTERN_C const IID      DIID_HTMLDocumentEvents3;
EXTERN_C const IID      DIID_HTMLDocumentEvents2;
EXTERN_C const IID      DIID_HTMLDocumentEvents;
EXTERN_C const IID      IID_IHTMLDocument;
EXTERN_C const IID      IID_IHTMLDocument2;
EXTERN_C const IID      IID_IHTMLDocument3;
EXTERN_C const IID      IID_IHTMLDocument4;
EXTERN_C const IID      IID_IHTMLDocument5;
EXTERN_C const IID      IID_IHTMLDocument6;
EXTERN_C const IID      IID_IDocumentSelector;
EXTERN_C const IID      DIID_DispHTMLDocument;
EXTERN_C const CLSID    CLSID_HTMLDocument;
EXTERN_C const IID      DIID_DWebBridgeEvents;
EXTERN_C const IID      IID_IWebBridge;
EXTERN_C const IID      IID_IWBScriptControl;
EXTERN_C const CLSID    CLSID_Scriptlet;
EXTERN_C const IID      IID_IHTMLEmbedElement;
EXTERN_C const IID      IID_IHTMLEmbedElement2;
EXTERN_C const IID      DIID_DispHTMLEmbed;
EXTERN_C const CLSID    CLSID_HTMLEmbed;
EXTERN_C const IID      DIID_HTMLMapEvents2;
EXTERN_C const IID      DIID_HTMLMapEvents;
EXTERN_C const IID      IID_IHTMLAreasCollection;
EXTERN_C const IID      IID_IHTMLAreasCollection2;
EXTERN_C const IID      IID_IHTMLAreasCollection3;
EXTERN_C const IID      IID_IHTMLAreasCollection4;
EXTERN_C const IID      IID_IHTMLMapElement;
EXTERN_C const IID      DIID_DispHTMLAreasCollection;
EXTERN_C const CLSID    CLSID_HTMLAreasCollection;
EXTERN_C const IID      DIID_DispHTMLMapElement;
EXTERN_C const CLSID    CLSID_HTMLMapElement;
EXTERN_C const IID      DIID_HTMLAreaEvents2;
EXTERN_C const IID      DIID_HTMLAreaEvents;
EXTERN_C const IID      IID_IHTMLAreaElement;
EXTERN_C const IID      IID_IHTMLAreaElement2;
EXTERN_C const IID      DIID_DispHTMLAreaElement;
EXTERN_C const CLSID    CLSID_HTMLAreaElement;
EXTERN_C const IID      IID_IHTMLTableCaption;
EXTERN_C const IID      DIID_DispHTMLTableCaption;
EXTERN_C const CLSID    CLSID_HTMLTableCaption;
EXTERN_C const IID      IID_IHTMLCommentElement;
EXTERN_C const IID      IID_IHTMLCommentElement2;
EXTERN_C const IID      DIID_DispHTMLCommentElement;
EXTERN_C const CLSID    CLSID_HTMLCommentElement;
EXTERN_C const IID      IID_IHTMLPhraseElement;
EXTERN_C const IID      IID_IHTMLPhraseElement2;
EXTERN_C const IID      IID_IHTMLPhraseElement3;
EXTERN_C const IID      IID_IHTMLSpanElement;
EXTERN_C const IID      DIID_DispHTMLPhraseElement;
EXTERN_C const CLSID    CLSID_HTMLPhraseElement;
EXTERN_C const IID      DIID_DispHTMLSpanElement;
EXTERN_C const CLSID    CLSID_HTMLSpanElement;
EXTERN_C const IID      DIID_HTMLTableEvents2;
EXTERN_C const IID      DIID_HTMLTableEvents;
EXTERN_C const IID      IID_IHTMLTable;
EXTERN_C const IID      IID_IHTMLTable2;
EXTERN_C const IID      IID_IHTMLTable3;
EXTERN_C const IID      IID_IHTMLTableCol;
EXTERN_C const IID      IID_IHTMLTableCol2;
EXTERN_C const IID      IID_IHTMLTableSection;
EXTERN_C const IID      IID_IHTMLTableSection2;
EXTERN_C const IID      IID_IHTMLTableSection3;
EXTERN_C const IID      IID_IHTMLTableRow;
EXTERN_C const IID      IID_IHTMLTableRow2;
EXTERN_C const IID      IID_IHTMLTableRow3;
EXTERN_C const IID      IID_IHTMLTableRowMetrics;
EXTERN_C const IID      IID_IHTMLTableCell;
EXTERN_C const IID      IID_IHTMLTableCell2;
EXTERN_C const IID      DIID_DispHTMLTable;
EXTERN_C const CLSID    CLSID_HTMLTable;
EXTERN_C const IID      DIID_DispHTMLTableCol;
EXTERN_C const CLSID    CLSID_HTMLTableCol;
EXTERN_C const IID      DIID_DispHTMLTableSection;
EXTERN_C const CLSID    CLSID_HTMLTableSection;
EXTERN_C const IID      DIID_DispHTMLTableRow;
EXTERN_C const CLSID    CLSID_HTMLTableRow;
EXTERN_C const IID      DIID_DispHTMLTableCell;
EXTERN_C const CLSID    CLSID_HTMLTableCell;
EXTERN_C const IID      DIID_HTMLScriptEvents2;
EXTERN_C const IID      DIID_HTMLScriptEvents;
EXTERN_C const IID      IID_IHTMLScriptElement;
EXTERN_C const IID      IID_IHTMLScriptElement2;
EXTERN_C const IID      IID_IHTMLScriptElement3;
EXTERN_C const IID      DIID_DispHTMLScriptElement;
EXTERN_C const CLSID    CLSID_HTMLScriptElement;
EXTERN_C const IID      IID_IHTMLNoShowElement;
EXTERN_C const IID      DIID_DispHTMLNoShowElement;
EXTERN_C const CLSID    CLSID_HTMLNoShowElement;
EXTERN_C const IID      DIID_HTMLObjectElementEvents2;
EXTERN_C const IID      DIID_HTMLObjectElementEvents;
EXTERN_C const IID      IID_IHTMLObjectElement;
EXTERN_C const IID      IID_IHTMLObjectElement2;
EXTERN_C const IID      IID_IHTMLObjectElement3;
EXTERN_C const IID      IID_IHTMLObjectElement4;
EXTERN_C const IID      IID_IHTMLParamElement;
EXTERN_C const IID      IID_IHTMLParamElement2;
EXTERN_C const IID      DIID_DispHTMLObjectElement;
EXTERN_C const CLSID    CLSID_HTMLObjectElement;
EXTERN_C const IID      DIID_DispHTMLParamElement;
EXTERN_C const CLSID    CLSID_HTMLParamElement;
EXTERN_C const IID      DIID_HTMLFrameSiteEvents2;
EXTERN_C const IID      DIID_HTMLFrameSiteEvents;
EXTERN_C const IID      IID_IHTMLFrameBase;
EXTERN_C const IID      IID_IHTMLFrameBase2;
EXTERN_C const IID      IID_IHTMLFrameBase3;
EXTERN_C const IID      DIID_DispHTMLFrameBase;
EXTERN_C const CLSID    CLSID_HTMLFrameBase;
EXTERN_C const IID      IID_IHTMLFrameElement;
EXTERN_C const IID      IID_IHTMLFrameElement2;
EXTERN_C const IID      IID_IHTMLFrameElement3;
EXTERN_C const IID      DIID_DispHTMLFrameElement;
EXTERN_C const CLSID    CLSID_HTMLFrameElement;
EXTERN_C const IID      IID_IHTMLIFrameElement;
EXTERN_C const IID      IID_IHTMLIFrameElement2;
EXTERN_C const IID      IID_IHTMLIFrameElement3;
EXTERN_C const IID      DIID_DispHTMLIFrame;
EXTERN_C const CLSID    CLSID_HTMLIFrame;
EXTERN_C const IID      IID_IHTMLDivPosition;
EXTERN_C const IID      IID_IHTMLFieldSetElement;
EXTERN_C const IID      IID_IHTMLFieldSetElement2;
EXTERN_C const IID      IID_IHTMLLegendElement;
EXTERN_C const IID      IID_IHTMLLegendElement2;
EXTERN_C const IID      DIID_DispHTMLDivPosition;
EXTERN_C const CLSID    CLSID_HTMLDivPosition;
EXTERN_C const IID      DIID_DispHTMLFieldSetElement;
EXTERN_C const CLSID    CLSID_HTMLFieldSetElement;
EXTERN_C const IID      DIID_DispHTMLLegendElement;
EXTERN_C const CLSID    CLSID_HTMLLegendElement;
EXTERN_C const IID      IID_IHTMLSpanFlow;
EXTERN_C const IID      DIID_DispHTMLSpanFlow;
EXTERN_C const CLSID    CLSID_HTMLSpanFlow;
EXTERN_C const IID      IID_IHTMLFrameSetElement;
EXTERN_C const IID      IID_IHTMLFrameSetElement2;
EXTERN_C const IID      DIID_DispHTMLFrameSetSite;
EXTERN_C const CLSID    CLSID_HTMLFrameSetSite;
EXTERN_C const IID      IID_IHTMLBGsound;
EXTERN_C const IID      DIID_DispHTMLBGsound;
EXTERN_C const CLSID    CLSID_HTMLBGsound;
EXTERN_C const IID      IID_IHTMLFontNamesCollection;
EXTERN_C const IID      IID_IHTMLFontSizesCollection;
EXTERN_C const IID      IID_IHTMLOptionsHolder;
EXTERN_C const IID      DIID_HTMLStyleElementEvents2;
EXTERN_C const IID      DIID_HTMLStyleElementEvents;
EXTERN_C const IID      IID_IHTMLStyleElement;
EXTERN_C const IID      DIID_DispHTMLStyleElement;
EXTERN_C const CLSID    CLSID_HTMLStyleElement;
EXTERN_C const IID      IID_IHTMLStyleFontFace;
EXTERN_C const CLSID    CLSID_HTMLStyleFontFace;
EXTERN_C const IID      IID_IHTMLXDomainRequest;
EXTERN_C const IID      IID_IHTMLXDomainRequestFactory;
EXTERN_C const IID      DIID_DispXDomainRequest;
EXTERN_C const CLSID    CLSID_XDomainRequest;
EXTERN_C const CLSID    CLSID_XDomainRequestFactory;
EXTERN_C const IID      IID_IHTMLStorage;
EXTERN_C const IID      DIID_DispHTMLStorage;
EXTERN_C const CLSID    CLSID_HTMLStorage;
EXTERN_C const IID      IID_ICSSFilterSite;
EXTERN_C const IID      IID_ICSSFilter;
EXTERN_C const IID      IID_ISecureUrlHost;
EXTERN_C const IID      IID_IMarkupServices;
EXTERN_C const IID      IID_IMarkupServices2;
EXTERN_C const IID      IID_IMarkupContainer;
EXTERN_C const IID      IID_IMarkupContainer2;
EXTERN_C const IID      IID_IHTMLChangePlayback;
EXTERN_C const IID      IID_IMarkupPointer;
EXTERN_C const IID      IID_IMarkupPointer2;
EXTERN_C const IID      IID_IMarkupTextFrags;
EXTERN_C const IID      IID_IHTMLChangeLog;
EXTERN_C const IID      IID_IHTMLChangeSink;
EXTERN_C const IID      IID_IXMLGenericParse;
EXTERN_C const IID      IID_IHTMLEditHost;
EXTERN_C const IID      IID_IHTMLEditHost2;
EXTERN_C const IID      IID_ISegment;
EXTERN_C const IID      IID_ISegmentListIterator;
EXTERN_C const IID      IID_ISegmentList;
EXTERN_C const IID      IID_ISequenceNumber;
EXTERN_C const IID      IID_IIMEServices;
EXTERN_C const IID      IID_IHTMLCaret;
EXTERN_C const IID      IID_IHighlightRenderingServices;
EXTERN_C const IID      IID_ISelectionServicesListener;
EXTERN_C const IID      IID_ISelectionServices;
EXTERN_C const IID      IID_IElementSegment;
EXTERN_C const IID      IID_IHighlightSegment;
EXTERN_C const IID      IID_IHTMLEditDesigner;
EXTERN_C const IID      IID_IHTMLEditServices;
EXTERN_C const IID      IID_IHTMLEditServices2;
EXTERN_C const IID      IID_ILineInfo;
EXTERN_C const IID      IID_IHTMLComputedStyle;
EXTERN_C const IID      IID_IDisplayPointer;
EXTERN_C const IID      IID_IDisplayServices;
EXTERN_C const IID      IID_IHtmlDlgSafeHelper;
EXTERN_C const IID      IID_IBlockFormats;
EXTERN_C const IID      IID_IFontNames;
EXTERN_C const CLSID    CLSID_HtmlDlgSafeHelper;
EXTERN_C const CLSID    CLSID_BlockFormats;
EXTERN_C const CLSID    CLSID_FontNames;
EXTERN_C const IID      DIID_HTMLNamespaceEvents;
EXTERN_C const IID      IID_IHTMLNamespace;
EXTERN_C const IID      IID_IHTMLNamespaceCollection;
EXTERN_C const IID      DIID_DispHTMLNamespace;
EXTERN_C const CLSID    CLSID_HTMLNamespace;
EXTERN_C const IID      DIID_DispHTMLNamespaceCollection;
EXTERN_C const CLSID    CLSID_HTMLNamespaceCollection;
EXTERN_C const IID      IID_IHTMLPainter;
EXTERN_C const IID      IID_IHTMLPainterEventInfo;
EXTERN_C const IID      IID_IHTMLPainterOverlay;
EXTERN_C const IID      IID_IHTMLPaintSite;
EXTERN_C const IID      IID_IHTMLIPrintCollection;
EXTERN_C const IID      IID_IEnumPrivacyRecords;
EXTERN_C const IID      IID_IWPCBlockedUrls;
EXTERN_C const IID      IID_IHTMLDOMConstructorCollection;
EXTERN_C const IID      IID_IHTMLDialog;
EXTERN_C const IID      IID_IHTMLDialog2;
EXTERN_C const IID      IID_IHTMLDialog3;
EXTERN_C const IID      IID_IHTMLModelessInit;
EXTERN_C const CLSID    CLSID_ThreadDialogProcParam;
EXTERN_C const CLSID    CLSID_HTMLDialog;
EXTERN_C const IID      IID_IHTMLPopup;
EXTERN_C const IID      DIID_DispHTMLPopup;
EXTERN_C const CLSID    CLSID_HTMLPopup;
EXTERN_C const IID      IID_IHTMLAppBehavior;
EXTERN_C const IID      IID_IHTMLAppBehavior2;
EXTERN_C const IID      IID_IHTMLAppBehavior3;
EXTERN_C const IID      DIID_DispHTMLAppBehavior;
EXTERN_C const CLSID    CLSID_HTMLAppBehavior;
EXTERN_C const CLSID    CLSID_OldHTMLDocument;
EXTERN_C const CLSID    CLSID_OldHTMLFormElement;
EXTERN_C const IID      DIID_DispIHTMLInputButtonElement;
EXTERN_C const CLSID    CLSID_HTMLInputButtonElement;
EXTERN_C const IID      DIID_DispIHTMLInputTextElement;
EXTERN_C const CLSID    CLSID_HTMLInputTextElement;
EXTERN_C const IID      DIID_DispIHTMLInputFileElement;
EXTERN_C const CLSID    CLSID_HTMLInputFileElement;
EXTERN_C const IID      DIID_DispIHTMLOptionButtonElement;
EXTERN_C const CLSID    CLSID_HTMLOptionButtonElement;
EXTERN_C const IID      DIID_DispIHTMLInputImage;
EXTERN_C const CLSID    CLSID_HTMLInputImage;
EXTERN_C const IID      IID_IElementBehaviorFactory;
EXTERN_C const IID      IID_IElementNamespace;
EXTERN_C const IID      IID_IElementNamespaceTable;
EXTERN_C const IID      IID_IElementNamespaceFactory;
EXTERN_C const IID      IID_IElementNamespaceFactory2;
EXTERN_C const IID      IID_IElementNamespaceFactoryCallback;
EXTERN_C const IID      IID_IElementBehavior;
EXTERN_C const IID      IID_IElementBehaviorSite;
EXTERN_C const IID      IID_IElementBehaviorSiteOM;
EXTERN_C const IID      IID_IElementBehaviorSiteOM2;
EXTERN_C const IID      IID_IElementBehaviorRender;
EXTERN_C const IID      IID_IElementBehaviorSiteRender;
EXTERN_C const IID      IID_IElementBehaviorCategory;
EXTERN_C const IID      IID_IElementBehaviorSiteCategory;
EXTERN_C const IID      IID_IElementBehaviorSubmit;
EXTERN_C const IID      IID_IElementBehaviorFocus;
EXTERN_C const IID      IID_IElementBehaviorLayout;
EXTERN_C const IID      IID_IElementBehaviorLayout2;
EXTERN_C const IID      IID_IElementBehaviorSiteLayout;
EXTERN_C const IID      IID_IElementBehaviorSiteLayout2;
EXTERN_C const IID      IID_IHostBehaviorInit;

/* IHTMLFiltersCollection interface */
#undef INTERFACE
#define INTERFACE   IHTMLFiltersCollection
DECLARE_INTERFACE_( IHTMLFiltersCollection, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
    
    /* IHTMLFiltersCollection methods */
    STDMETHOD( get_length )( THIS_ long * ) PURE;
    STDMETHOD( get__newEnum )( THIS_ IUnknown ** ) PURE;
    STDMETHOD( item )( THIS_ VARIANT *, VARIANT * ) PURE;
};

/* IIE70DispatchEx interface */
#undef INTERFACE
#define INTERFACE   IIE70DispatchEx
DECLARE_INTERFACE_( IIE70DispatchEx, IDispatchEx ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IDispatchEx methods */
    STDMETHOD( GetDispID )( THIS_ BSTR, DWORD, DISPID * ) PURE;
    STDMETHOD( InvokeEx )( THIS_ DISPID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, IServiceProvider * ) PURE;
    STDMETHOD( DeleteMemberByName )( THIS_ BSTR, DWORD ) PURE;
    STDMETHOD( DeleteMemberByDispID )( THIS_ DISPID ) PURE;
    STDMETHOD( GetMemberProperties )( THIS_ DISPID, DWORD, DWORD * ) PURE;
    STDMETHOD( GetMemberName )( THIS_ DISPID, BSTR * ) PURE;
    STDMETHOD( GetNextDispID )( THIS_ DWORD, DISPID, DISPID * ) PURE;
    STDMETHOD( GetNameSpaceParent )( THIS_ IUnknown ** ) PURE;
};

/* IIE80DispatchEx interface */
#undef INTERFACE
#define INTERFACE   IIE80DispatchEx
DECLARE_INTERFACE_( IIE80DispatchEx, IDispatchEx ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IDispatchEx methods */
    STDMETHOD( GetDispID )( THIS_ BSTR, DWORD, DISPID * ) PURE;
    STDMETHOD( InvokeEx )( THIS_ DISPID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, IServiceProvider * ) PURE;
    STDMETHOD( DeleteMemberByName )( THIS_ BSTR, DWORD ) PURE;
    STDMETHOD( DeleteMemberByDispID )( THIS_ DISPID ) PURE;
    STDMETHOD( GetMemberProperties )( THIS_ DISPID, DWORD, DWORD * ) PURE;
    STDMETHOD( GetMemberName )( THIS_ DISPID, BSTR * ) PURE;
    STDMETHOD( GetNextDispID )( THIS_ DWORD, DISPID, DISPID * ) PURE;
    STDMETHOD( GetNameSpaceParent )( THIS_ IUnknown ** ) PURE;
};

/* IHTMLDOMConstructor interface */
#undef INTERFACE
#define INTERFACE   IHTMLDOMConstructor
DECLARE_INTERFACE_( IHTMLDOMConstructor, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLDOMConstructor methods */
    STDMETHOD( get_constructor )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( LookupGetter )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( LookupSetter )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( DefineGetter )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( DefineSetter )( THIS_ BSTR, VARIANT * ) PURE;
};

/* IHTMLStyle interface */
#undef INTERFACE
#define INTERFACE   IHTMLStyle
DECLARE_INTERFACE_( IHTMLStyle, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLStyle methods */
    STDMETHOD( put_fontFamily )( THIS_ BSTR ) PURE;
    STDMETHOD( get_fontFamily )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_fontStyle )( THIS_ BSTR ) PURE;
    STDMETHOD( get_fontStyle )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_fontVariant )( THIS_ BSTR ) PURE;
    STDMETHOD( get_fontVariant )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_fontWeight )( THIS_ BSTR ) PURE;
    STDMETHOD( get_fontWeight )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_fontSize )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_fontSize )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_font )( THIS_ BSTR ) PURE;
    STDMETHOD( get_font )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_color )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_color )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_background )( THIS_ BSTR ) PURE;
    STDMETHOD( get_background )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_backgroundColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_backgroundColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_backgroundImage )( THIS_ BSTR ) PURE;
    STDMETHOD( get_backgroundImage )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_backgroundRepeat )( THIS_ BSTR ) PURE;
    STDMETHOD( get_backgroundRepeat )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_backgroundAttachment )( THIS_ BSTR ) PURE;
    STDMETHOD( get_backgroundAttachment )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_backgroundPosition )( THIS_ BSTR ) PURE;
    STDMETHOD( get_backgroundPosition )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_backgroundPositionX )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_backgroundPositionX )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_backgroundPositionY )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_backgroundPositionY )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_wordSpacing )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_wordSpacing )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_letterSpacing )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_letterSpacing )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_textDecoration )( THIS_ BSTR ) PURE;
    STDMETHOD( get_textDecoration )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_textDecorationNone )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_textDecorationNone )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_textDecorationUnderline )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_textDecorationUnderline )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_textDecorationOverline )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_textDecorationOverline )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_textDecorationLineThrough )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_textDecorationLineThrough )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_textDecorationBlink )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_textDecorationBlink )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_verticalAlign )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_verticalAlign )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_textTransform )( THIS_ BSTR ) PURE;
    STDMETHOD( get_textTransform )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_textAlign )( THIS_ BSTR ) PURE;
    STDMETHOD( get_textAlign )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_textIndent )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_textIndent )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_lineHeight )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_lineHeight )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_marginTop )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_marginTop )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_marginRight )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_marginRight )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_marginBottom )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_marginBottom )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_marginLeft )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_marginLeft )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_margin )( THIS_ BSTR ) PURE;
    STDMETHOD( get_margin )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_paddingTop )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_paddingTop )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_paddingRight )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_paddingRight )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_paddingBottom )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_paddingBottom )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_paddingLeft )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_paddingLeft )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_padding )( THIS_ BSTR ) PURE;
    STDMETHOD( get_padding )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_border )( THIS_ BSTR ) PURE;
    STDMETHOD( get_border )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_borderTop )( THIS_ BSTR ) PURE;
    STDMETHOD( get_borderTop )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_borderRight )( THIS_ BSTR ) PURE;
    STDMETHOD( get_borderRight )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_borderBottom )( THIS_ BSTR ) PURE;
    STDMETHOD( get_borderBottom )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_borderLeft )( THIS_ BSTR ) PURE;
    STDMETHOD( get_borderLeft )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_borderColor )( THIS_ BSTR ) PURE;
    STDMETHOD( get_borderColor )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_borderTopColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_borderTopColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_borderRightColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_borderRightColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_borderBottomColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_borderBottomColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_borderLeftColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_borderLeftColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_borderWidth )( THIS_ BSTR ) PURE;
    STDMETHOD( get_borderWidth )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_borderTopWidth )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_borderTopWidth )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_borderRightWidth )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_borderRightWidth )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_borderBottomWidth )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_borderBottomWidth )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_borderLeftWidth )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_borderLeftWidth )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_borderStyle )( THIS_ BSTR ) PURE;
    STDMETHOD( get_borderStyle )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_borderTopStyle )( THIS_ BSTR ) PURE;
    STDMETHOD( get_borderTopStyle )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_borderRightStyle )( THIS_ BSTR ) PURE;
    STDMETHOD( get_borderRightStyle )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_borderBottomStyle )( THIS_ BSTR ) PURE;
    STDMETHOD( get_borderBottomStyle )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_borderLeftStyle )( THIS_ BSTR ) PURE;
    STDMETHOD( get_borderLeftStyle )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_width )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_width )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_height )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_height )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_styleFloat )( THIS_ BSTR ) PURE;
    STDMETHOD( get_styleFloat )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_clear )( THIS_ BSTR ) PURE;
    STDMETHOD( get_clear )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_display )( THIS_ BSTR ) PURE;
    STDMETHOD( get_display )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_visibility )( THIS_ BSTR ) PURE;
    STDMETHOD( get_visibility )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_listStyleType )( THIS_ BSTR ) PURE;
    STDMETHOD( get_listStyleType )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_listStylePosition )( THIS_ BSTR ) PURE;
    STDMETHOD( get_listStylePosition )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_listStyleImage )( THIS_ BSTR ) PURE;
    STDMETHOD( get_listStyleImage )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_listStyle )( THIS_ BSTR ) PURE;
    STDMETHOD( get_listStyle )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_whiteSpace )( THIS_ BSTR ) PURE;
    STDMETHOD( get_whiteSpace )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_top )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_top )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_left )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_left )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_position )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_zIndex )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_zIndex )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_overflow )( THIS_ BSTR ) PURE;
    STDMETHOD( get_overflow )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_pageBreakBefore )( THIS_ BSTR ) PURE;
    STDMETHOD( get_pageBreakBefore )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_pageBreakAfter )( THIS_ BSTR ) PURE;
    STDMETHOD( get_pageBreakAfter )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_cssText )( THIS_ BSTR ) PURE;
    STDMETHOD( get_cssText )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_pixelTop )( THIS_ long ) PURE;
    STDMETHOD( get_pixelTop )( THIS_ long * ) PURE;
    STDMETHOD( put_pixelLeft )( THIS_ long ) PURE;
    STDMETHOD( get_pixelLeft )( THIS_ long * ) PURE;
    STDMETHOD( put_pixelWidth )( THIS_ long ) PURE;
    STDMETHOD( get_pixelWidth )( THIS_ long * ) PURE;
    STDMETHOD( put_pixelHeight )( THIS_ long ) PURE;
    STDMETHOD( get_pixelHeight )( THIS_ long * ) PURE;
    STDMETHOD( put_posTop )( THIS_ float ) PURE;
    STDMETHOD( get_posTop )( THIS_ float * ) PURE;
    STDMETHOD( put_posLeft )( THIS_ float ) PURE;
    STDMETHOD( get_posLeft )( THIS_ float * ) PURE;
    STDMETHOD( put_posWidth )( THIS_ float ) PURE;
    STDMETHOD( get_posWidth )( THIS_ float * ) PURE;
    STDMETHOD( put_posHeight )( THIS_ float ) PURE;
    STDMETHOD( get_posHeight )( THIS_ float * ) PURE;
    STDMETHOD( put_cursor )( THIS_ BSTR ) PURE;
    STDMETHOD( get_cursor )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_clip )( THIS_ BSTR ) PURE;
    STDMETHOD( get_clip )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_filter )( THIS_ BSTR ) PURE;
    STDMETHOD( get_filter )( THIS_ BSTR * ) PURE;
    STDMETHOD( setAttribute )( THIS_ BSTR, VARIANT, LONG ) PURE;
    STDMETHOD( getAttribute )( THIS_ BSTR, LONG, VARIANT * ) PURE;
    STDMETHOD( removeAttribute )( THIS_ BSTR, LONG, VARIANT_BOOL * ) PURE;
    STDMETHOD( toString )( THIS_ BSTR * ) PURE;
};

/* IHTMLStyle2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLStyle2
DECLARE_INTERFACE_( IHTMLStyle2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLStyle2 methods */
    STDMETHOD( put_tableLayout )( THIS_ BSTR ) PURE;
    STDMETHOD( get_tableLayout )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_borderCollapse )( THIS_ BSTR ) PURE;
    STDMETHOD( get_borderCollapse )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_direction )( THIS_ BSTR ) PURE;
    STDMETHOD( get_direction )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_behavior )( THIS_ BSTR ) PURE;
    STDMETHOD( get_behavior )( THIS_ BSTR * ) PURE;
    STDMETHOD( setExpression )( THIS_ BSTR, BSTR, BSTR ) PURE;
    STDMETHOD( getExpression )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( removeExpression )( THIS_ BSTR, VARIANT_BOOL * ) PURE;
    STDMETHOD( put_position )( THIS_ BSTR ) PURE;
    STDMETHOD( get_position )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_unicodeBidi )( THIS_ BSTR ) PURE;
    STDMETHOD( get_unicodeBidi )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_bottom )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_bottom )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_right )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_right )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_pixelBottom )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_pixelBottom )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_pixelRight )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_pixelRight )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_posBottom )( THIS_ float ) PURE;
    STDMETHOD( get_posBottom )( THIS_ float * ) PURE;
    STDMETHOD( put_posRight )( THIS_ float ) PURE;
    STDMETHOD( get_posRight )( THIS_ float * ) PURE;
    STDMETHOD( put_imeMode )( THIS_ BSTR ) PURE;
    STDMETHOD( get_imeMode )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_rubyAlign )( THIS_ BSTR ) PURE;
    STDMETHOD( get_rubyAlign )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_rubyPosition )( THIS_ BSTR ) PURE;
    STDMETHOD( get_rubyPosition )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_rubyOverhang )( THIS_ BSTR ) PURE;
    STDMETHOD( get_rubyOverhang )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_layoutGridChar )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_layoutGridChar )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_layoutGridLine )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_layoutGridLine )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_layoutGridMode )( THIS_ BSTR ) PURE;
    STDMETHOD( get_layoutGridMode )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_layoutGridType )( THIS_ BSTR ) PURE;
    STDMETHOD( get_layoutGridType )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_layoutGrid )( THIS_ BSTR ) PURE;
    STDMETHOD( get_layoutGrid )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_wordBreak )( THIS_ BSTR ) PURE;
    STDMETHOD( get_wordBreak )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_lineBreak )( THIS_ BSTR ) PURE;
    STDMETHOD( get_lineBreak )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_textJustify )( THIS_ BSTR ) PURE;
    STDMETHOD( get_textJustify )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_textJustifyTrim )( THIS_ BSTR ) PURE;
    STDMETHOD( get_textJustifyTrim )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_textKashida )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_textKashida )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_textAutospace )( THIS_ BSTR ) PURE;
    STDMETHOD( get_textAutospace )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_overflowX )( THIS_ BSTR ) PURE;
    STDMETHOD( get_overflowX )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_overflowY )( THIS_ BSTR ) PURE;
    STDMETHOD( get_overflowY )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_accelerator )( THIS_ BSTR ) PURE;
    STDMETHOD( get_accelerator )( THIS_ BSTR * ) PURE;
};

/* IHTMLStyle3 interface */
#undef INTERFACE
#define INTERFACE   IHTMLStyle3
DECLARE_INTERFACE_( IHTMLStyle3, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLStyle3 methods */
    STDMETHOD( put_layoutFlow )( THIS_ BSTR ) PURE;
    STDMETHOD( get_layoutFlow )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_zoom )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_zoom )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_wordWrap )( THIS_ BSTR ) PURE;
    STDMETHOD( get_wordWrap )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_textUnderlinePosition )( THIS_ BSTR ) PURE;
    STDMETHOD( get_textUnderlinePosition )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_scrollbarBaseColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_scrollbarBaseColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_scrollbarFaceColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_scrollbarFaceColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_scrollbar3dLightColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_scrollbar3dLightColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_scrollbarShadowColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_scrollbarShadowColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_scrollbarHighlightColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_scrollbarHighlightColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_scrollbarDarkShadowColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_scrollbarDarkShadowColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_scrollbarArrowColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_scrollbarArrowColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_scrollbarTrackColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_scrollbarTrackColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_writingMode )( THIS_ BSTR ) PURE;
    STDMETHOD( get_writingMode )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_textAlignLast )( THIS_ BSTR ) PURE;
    STDMETHOD( get_textAlignLast )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_textKashidaSpace )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_textKashidaSpace )( THIS_ VARIANT * ) PURE;
};

/* IHTMLStyle4 interface */
#undef INTERFACE
#define INTERFACE   IHTMLStyle4
DECLARE_INTERFACE_( IHTMLStyle4, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLStyle4 methods */
    STDMETHOD( put_textOverflow )( THIS_ BSTR ) PURE;
    STDMETHOD( get_textOverflow )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_minHeight )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_minHeight )( THIS_ VARIANT * ) PURE;
};

/* IHTMLStyle5 interface */
#undef INTERFACE
#define INTERFACE   IHTMLStyle5
DECLARE_INTERFACE_( IHTMLStyle5, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLStyle5 methods */
    STDMETHOD( put_msInterpolationMode )( THIS_ BSTR ) PURE;
    STDMETHOD( get_msInterpolationMode )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_maxHeight )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_maxHeight )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_minWidth )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_minWidth )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_maxWidth )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_maxWidth )( THIS_ VARIANT * ) PURE;
};

/* IHTMLStyle6 interface */
#undef INTERFACE
#define INTERFACE   IHTMLStyle6
DECLARE_INTERFACE_( IHTMLStyle6, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLStyle6 methods */
    STDMETHOD( put_content )( THIS_ BSTR ) PURE;
    STDMETHOD( get_content )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_captionSide )( THIS_ BSTR ) PURE;
    STDMETHOD( get_captionSide )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_counterIncrement )( THIS_ BSTR ) PURE;
    STDMETHOD( get_counterIncrement )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_counterReset )( THIS_ BSTR ) PURE;
    STDMETHOD( get_counterReset )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_outline )( THIS_ BSTR ) PURE;
    STDMETHOD( get_outline )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_outlineWidth )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_outlineWidth )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_outlineStyle )( THIS_ BSTR ) PURE;
    STDMETHOD( get_outlineStyle )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_outlineColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_outlineColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_boxSizing )( THIS_ BSTR ) PURE;
    STDMETHOD( get_boxSizing )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_borderSpacing )( THIS_ BSTR ) PURE;
    STDMETHOD( get_borderSpacing )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_orphans )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_orphans )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_widows )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_widows )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_pageBreakInside )( THIS_ BSTR ) PURE;
    STDMETHOD( get_pageBreakInside )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_emptyCells )( THIS_ BSTR ) PURE;
    STDMETHOD( get_emptyCells )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_msBlockProgression )( THIS_ BSTR ) PURE;
    STDMETHOD( get_msBlockProgression )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_quotes )( THIS_ BSTR ) PURE;
    STDMETHOD( get_quotes )( THIS_ BSTR * ) PURE;
};

/* IHTMLRuleStyle interface */
#undef INTERFACE
#define INTERFACE   IHTMLRuleStyle
DECLARE_INTERFACE_( IHTMLRuleStyle, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
    
    /* IHTMLRuleStyle methods */
    STDMETHOD( put_fontFamily )( THIS_ BSTR ) PURE;
    STDMETHOD( get_fontFamily )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_fontStyle )( THIS_ BSTR ) PURE;
    STDMETHOD( get_fontStyle )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_fontVariant )( THIS_ BSTR ) PURE;
    STDMETHOD( get_fontVariant )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_fontWeight )( THIS_ BSTR ) PURE;
    STDMETHOD( get_fontWeight )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_fontSize )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_fontSize )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_font )( THIS_ BSTR ) PURE;
    STDMETHOD( get_font )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_color )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_color )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_background )( THIS_ BSTR ) PURE;
    STDMETHOD( get_background )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_backgroundColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_backgroundColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_backgroundImage )( THIS_ BSTR ) PURE;
    STDMETHOD( get_backgroundImage )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_backgroundRepeat )( THIS_ BSTR ) PURE;
    STDMETHOD( get_backgroundRepeat )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_backgroundAttachment )( THIS_ BSTR ) PURE;
    STDMETHOD( get_backgroundAttachment )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_backgroundPosition )( THIS_ BSTR ) PURE;
    STDMETHOD( get_backgroundPosition )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_backgroundPositionX )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_backgroundPositionX )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_backgroundPositionY )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_backgroundPositionY )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_wordSpacing )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_wordSpacing )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_letterSpacing )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_letterSpacing )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_textDecoration )( THIS_ BSTR ) PURE;
    STDMETHOD( get_textDecoration )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_textDecorationNone )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_textDecorationNone )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_textDecorationUnderline )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_textDecorationUnderline )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_textDecorationOverline )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_textDecorationOverline )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_textDecorationLineThrough )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_textDecorationLineThrough )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_textDecorationBlink )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_textDecorationBlink )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_verticalAlign )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_verticalAlign )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_textTransform )( THIS_ BSTR ) PURE;
    STDMETHOD( get_textTransform )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_textAlign )( THIS_ BSTR ) PURE;
    STDMETHOD( get_textAlign )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_textIndent )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_textIndent )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_lineHeight )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_lineHeight )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_marginTop )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_marginTop )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_marginRight )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_marginRight )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_marginBottom )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_marginBottom )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_marginLeft )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_marginLeft )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_margin )( THIS_ BSTR ) PURE;
    STDMETHOD( get_margin )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_paddingTop )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_paddingTop )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_paddingRight )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_paddingRight )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_paddingBottom )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_paddingBottom )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_paddingLeft )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_paddingLeft )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_padding )( THIS_ BSTR ) PURE;
    STDMETHOD( get_padding )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_border )( THIS_ BSTR ) PURE;
    STDMETHOD( get_border )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_borderTop )( THIS_ BSTR ) PURE;
    STDMETHOD( get_borderTop )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_borderRight )( THIS_ BSTR ) PURE;
    STDMETHOD( get_borderRight )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_borderBottom )( THIS_ BSTR ) PURE;
    STDMETHOD( get_borderBottom )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_borderLeft )( THIS_ BSTR ) PURE;
    STDMETHOD( get_borderLeft )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_borderColor )( THIS_ BSTR ) PURE;
    STDMETHOD( get_borderColor )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_borderTopColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_borderTopColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_borderRightColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_borderRightColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_borderBottomColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_borderBottomColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_borderLeftColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_borderLeftColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_borderWidth )( THIS_ BSTR ) PURE;
    STDMETHOD( get_borderWidth )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_borderTopWidth )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_borderTopWidth )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_borderRightWidth )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_borderRightWidth )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_borderBottomWidth )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_borderBottomWidth )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_borderLeftWidth )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_borderLeftWidth )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_borderStyle )( THIS_ BSTR ) PURE;
    STDMETHOD( get_borderStyle )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_borderTopStyle )( THIS_ BSTR ) PURE;
    STDMETHOD( get_borderTopStyle )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_borderRightStyle )( THIS_ BSTR ) PURE;
    STDMETHOD( get_borderRightStyle )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_borderBottomStyle )( THIS_ BSTR ) PURE;
    STDMETHOD( get_borderBottomStyle )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_borderLeftStyle )( THIS_ BSTR ) PURE;
    STDMETHOD( get_borderLeftStyle )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_width )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_width )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_height )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_height )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_styleFloat )( THIS_ BSTR ) PURE;
    STDMETHOD( get_styleFloat )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_clear )( THIS_ BSTR ) PURE;
    STDMETHOD( get_clear )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_display )( THIS_ BSTR ) PURE;
    STDMETHOD( get_display )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_visibility )( THIS_ BSTR ) PURE;
    STDMETHOD( get_visibility )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_listStyleType )( THIS_ BSTR ) PURE;
    STDMETHOD( get_listStyleType )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_listStylePosition )( THIS_ BSTR ) PURE;
    STDMETHOD( get_listStylePosition )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_listStyleImage )( THIS_ BSTR ) PURE;
    STDMETHOD( get_listStyleImage )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_listStyle )( THIS_ BSTR ) PURE;
    STDMETHOD( get_listStyle )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_whiteSpace )( THIS_ BSTR ) PURE;
    STDMETHOD( get_whiteSpace )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_top )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_top )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_left )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_left )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_position )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_zIndex )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_zIndex )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_overflow )( THIS_ BSTR ) PURE;
    STDMETHOD( get_overflow )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_pageBreakBefore )( THIS_ BSTR ) PURE;
    STDMETHOD( get_pageBreakBefore )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_pageBreakAfter )( THIS_ BSTR ) PURE;
    STDMETHOD( get_pageBreakAfter )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_cssText )( THIS_ BSTR ) PURE;
    STDMETHOD( get_cssText )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_cursor )( THIS_ BSTR ) PURE;
    STDMETHOD( get_cursor )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_clip )( THIS_ BSTR ) PURE;
    STDMETHOD( get_clip )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_filter )( THIS_ BSTR ) PURE;
    STDMETHOD( get_filter )( THIS_ BSTR * ) PURE;
    STDMETHOD( setAttribute )( THIS_ BSTR, VARIANT, LONG ) PURE;
    STDMETHOD( getAttribute )( THIS_ BSTR, LONG, VARIANT * ) PURE;
    STDMETHOD( removeAttribute )( THIS_ BSTR, LONG, VARIANT_BOOL * ) PURE;
    STDMETHOD( toString )( THIS_ BSTR * ) PURE;
};

/* IHTMLRuleStyle2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLRuleStyle2
DECLARE_INTERFACE_( IHTMLRuleStyle2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
    
    /* IHTMLRuleStyle2 methods */
    STDMETHOD( put_tableLayout )( THIS_ BSTR ) PURE;
    STDMETHOD( get_tableLayout )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_borderCollapse )( THIS_ BSTR ) PURE;
    STDMETHOD( get_borderCollapse )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_direction )( THIS_ BSTR ) PURE;
    STDMETHOD( get_direction )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_behavior )( THIS_ BSTR ) PURE;
    STDMETHOD( get_behavior )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_position )( THIS_ BSTR ) PURE;
    STDMETHOD( get_position )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_unicodeBidi )( THIS_ BSTR ) PURE;
    STDMETHOD( get_unicodeBidi )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_bottom )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_bottom )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_right )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_right )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_pixelBottom )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_pixelBottom )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_pixelRight )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_pixelRight )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_posBottom )( THIS_ float ) PURE;
    STDMETHOD( get_posBottom )( THIS_ float * ) PURE;
    STDMETHOD( put_posRight )( THIS_ float ) PURE;
    STDMETHOD( get_posRight )( THIS_ float * ) PURE;
    STDMETHOD( put_imeMode )( THIS_ BSTR ) PURE;
    STDMETHOD( get_imeMode )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_rubyAlign )( THIS_ BSTR ) PURE;
    STDMETHOD( get_rubyAlign )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_rubyPosition )( THIS_ BSTR ) PURE;
    STDMETHOD( get_rubyPosition )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_rubyOverhang )( THIS_ BSTR ) PURE;
    STDMETHOD( get_rubyOverhang )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_layoutGridChar )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_layoutGridChar )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_layoutGridLine )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_layoutGridLine )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_layoutGridMode )( THIS_ BSTR ) PURE;
    STDMETHOD( get_layoutGridMode )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_layoutGridType )( THIS_ BSTR ) PURE;
    STDMETHOD( get_layoutGridType )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_layoutGrid )( THIS_ BSTR ) PURE;
    STDMETHOD( get_layoutGrid )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_textAutospace )( THIS_ BSTR ) PURE;
    STDMETHOD( get_textAutospace )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_wordBreak )( THIS_ BSTR ) PURE;
    STDMETHOD( get_wordBreak )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_lineBreak )( THIS_ BSTR ) PURE;
    STDMETHOD( get_lineBreak )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_textJustify )( THIS_ BSTR ) PURE;
    STDMETHOD( get_textJustify )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_textJustifyTrim )( THIS_ BSTR ) PURE;
    STDMETHOD( get_textJustifyTrim )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_textKashida )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_textKashida )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_overflowX )( THIS_ BSTR ) PURE;
    STDMETHOD( get_overflowX )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_overflowY )( THIS_ BSTR ) PURE;
    STDMETHOD( get_overflowY )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_accelerator )( THIS_ BSTR ) PURE;
    STDMETHOD( get_accelerator )( THIS_ BSTR * ) PURE;
};

/* IHTMLRuleStyle3 interface */
#undef INTERFACE
#define INTERFACE   IHTMLRuleStyle3
DECLARE_INTERFACE_( IHTMLRuleStyle3, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLRuleStyle3 methods */
    STDMETHOD( put_layoutFlow )( THIS_ BSTR ) PURE;
    STDMETHOD( get_layoutFlow )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_zoom )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_zoom )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_wordWrap )( THIS_ BSTR ) PURE;
    STDMETHOD( get_wordWrap )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_textUnderlinePosition )( THIS_ BSTR ) PURE;
    STDMETHOD( get_textUnderlinePosition )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_scrollbarBaseColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_scrollbarBaseColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_scrollbarFaceColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_scrollbarFaceColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_scrollbar3dLightColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_scrollbar3dLightColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_scrollbarShadowColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_scrollbarShadowColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_scrollbarHighlightColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_scrollbarHighlightColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_scrollbarDarkShadowColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_scrollbarDarkShadowColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_scrollbarArrowColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_scrollbarArrowColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_scrollbarTrackColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_scrollbarTrackColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_writingMode )( THIS_ BSTR ) PURE;
    STDMETHOD( get_writingMode )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_textAlignLast )( THIS_ BSTR ) PURE;
    STDMETHOD( get_textAlignLast )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_textKashidaSpace )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_textKashidaSpace )( THIS_ VARIANT * ) PURE;
};

/* IHTMLRuleStyle4 interface */
#undef INTERFACE
#define INTERFACE   IHTMLRuleStyle4
DECLARE_INTERFACE_( IHTMLRuleStyle4, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLRuleStyle4 methods */
    STDMETHOD( put_textOverflow )( THIS_ BSTR ) PURE;
    STDMETHOD( get_textOverflow )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_minHeight )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_minHeight )( THIS_ VARIANT * ) PURE;
};

/* IHTMLRuleStyle5 interface */
#undef INTERFACE
#define INTERFACE   IHTMLRuleStyle5
DECLARE_INTERFACE_( IHTMLRuleStyle5, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLRuleStyle5 methods */
    STDMETHOD( put_msInterpolationMode )( THIS_ BSTR ) PURE;
    STDMETHOD( get_msInterpolationMode )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_maxHeight )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_maxHeight )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_minWidth )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_minWidth )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_maxWidth )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_maxWidth )( THIS_ VARIANT * ) PURE;
};

/* IHTMLRuleStyle6 interface */
#undef INTERFACE
#define INTERFACE   IHTMLRuleStyle6
DECLARE_INTERFACE_( IHTMLRuleStyle6, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLRuleStyle6 methods */
    STDMETHOD( put_content )( THIS_ BSTR ) PURE;
    STDMETHOD( get_content )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_captionSide )( THIS_ BSTR ) PURE;
    STDMETHOD( get_captionSide )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_counterIncrement )( THIS_ BSTR ) PURE;
    STDMETHOD( get_counterIncrement )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_counterReset )( THIS_ BSTR ) PURE;
    STDMETHOD( get_counterReset )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_outline )( THIS_ BSTR ) PURE;
    STDMETHOD( get_outline )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_outlineWidth )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_outlineWidth )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_outlineStyle )( THIS_ BSTR ) PURE;
    STDMETHOD( get_outlineStyle )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_outlineColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_outlineColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_boxSizing )( THIS_ BSTR ) PURE;
    STDMETHOD( get_boxSizing )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_borderSpacing )( THIS_ BSTR ) PURE;
    STDMETHOD( get_borderSpacing )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_orphans )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_orphans )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_widows )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_widows )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_pageBreakInside )( THIS_ BSTR ) PURE;
    STDMETHOD( get_pageBreakInside )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_emptyCells )( THIS_ BSTR ) PURE;
    STDMETHOD( get_emptyCells )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_msBlockProgression )( THIS_ BSTR ) PURE;
    STDMETHOD( get_msBlockProgression )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_quotes )( THIS_ BSTR ) PURE;
    STDMETHOD( get_quotes )( THIS_ BSTR * ) PURE;
};

/* DispHTMLStyle interface */
#undef INTERFACE
#define INTERFACE   DispHTMLStyle
DECLARE_INTERFACE_( DispHTMLStyle, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispHTMLRuleStyle interface */
#undef INTERFACE
#define INTERFACE   DispHTMLRuleStyle
DECLARE_INTERFACE_( DispHTMLRuleStyle, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLRenderStyle interface */
#undef INTERFACE
#define INTERFACE   IHTMLRenderStyle
DECLARE_INTERFACE_( IHTMLRenderStyle, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
    
    /* IHTMLRenderStyle methods */
    STDMETHOD( put_textLineThroughStyle )( THIS_ BSTR ) PURE;
    STDMETHOD( get_textLineThroughStyle )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_textUnderlineStyle )( THIS_ BSTR ) PURE;
    STDMETHOD( get_textUnderlineStyle )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_textEffect )( THIS_ BSTR ) PURE;
    STDMETHOD( get_textEffect )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_textColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_textColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_textBackgroundColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_textBackgroundColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_textDecorationColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_textDecorationColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_renderingPriority )( THIS_ long ) PURE;
    STDMETHOD( get_renderingPriority )( THIS_ long * ) PURE;
    STDMETHOD( put_defaultTextSelection )( THIS_ BSTR ) PURE;
    STDMETHOD( get_defaultTextSelection )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_textDecoration )( THIS_ BSTR ) PURE;
    STDMETHOD( get_textDecoration )( THIS_ BSTR * ) PURE;
};

/* DispHTMLRenderStyle interface */
#undef INTERFACE
#define INTERFACE   DispHTMLRenderStyle
DECLARE_INTERFACE_( DispHTMLRenderStyle, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLCurrentStyle interface */
#undef INTERFACE
#define INTERFACE   IHTMLCurrentStyle
DECLARE_INTERFACE_( IHTMLCurrentStyle, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLCurrentStyle methods */
    STDMETHOD( get_position )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_styleFloat )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_color )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_backgroundColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_fontFamily )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_fontStyle )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_fontVariant )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_fontWeight )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_fontSize )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_backgroundImage )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_backgroundPositionX )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_backgroundPositionY )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_backgroundRepeat )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_borderLeftColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_borderTopColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_borderRightColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_borderBottomColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_borderTopStyle )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_borderRightStyle )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_borderBottomStyle )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_borderLeftStyle )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_borderTopWidth )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_borderRightWidth )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_borderBottomWidth )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_borderLeftWidth )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_left )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_top )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_width )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_height )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_paddingLeft )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_paddingTop )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_paddingRight )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_paddingBottom )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_textAlign )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_textDecoration )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_display )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_visibility )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_zIndex )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_letterSpacing )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_lineHeight )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_textIndent )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_verticalAlign )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_backgroundAttachment )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_marginTop )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_marginRight )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_marginBottom )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_marginLeft )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_clear )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_listStyleType )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_listStylePosition )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_listStyleImage )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_clipTop )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_clipRight )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_clipBottom )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_clipLeft )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_overflow )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_pageBreakBefore )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_pageBreakAfter )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_cursor )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_tableLayout )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_borderCollapse )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_direction )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_behavior )( THIS_ BSTR * ) PURE;
    STDMETHOD( getAttribute )( THIS_ BSTR, LONG, VARIANT * ) PURE;
    STDMETHOD( get_unicodeBidi )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_right )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_bottom )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_imeMode )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_rubyAlign )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_rubyPosition )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_rubyOverhang )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_textAutospace )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_lineBreak )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_wordBreak )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_textJustify )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_textJustifyTrim )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_textKashida )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_blockDirection )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_layoutGridChar )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_layoutGridLine )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_layoutGridMode )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_layoutGridType )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_borderStyle )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_borderColor )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_borderWidth )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_padding )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_margin )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_accelerator )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_overflowX )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_overflowY )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_textTransform )( THIS_ BSTR * ) PURE;
};

/* IHTMLCurrentStyle2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLCurrentStyle2
DECLARE_INTERFACE_( IHTMLCurrentStyle2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLCurrentStyle2 methods */
    STDMETHOD( get_layoutFlow )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_wordWrap )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_textUnderlinePosition )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_hasLayout )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_scrollbarBaseColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_scrollbarFaceColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_scrollbar3dLightColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_scrollbarShadowColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_scrollbarHighlightColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_scrollbarDarkShadowColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_scrollbarArrowColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_scrollbarTrackColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_writingMode )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_zoom )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_filter )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_textAlignLast )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_textKashidaSpace )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_isBlock )( THIS_ VARIANT_BOOL * ) PURE;
};

/* IHTMLCurrentStyle3 interface */
#undef INTERFACE
#define INTERFACE   IHTMLCurrentStyle3
DECLARE_INTERFACE_( IHTMLCurrentStyle3, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLCurrentStyle3 methods */
    STDMETHOD( get_textOverflow )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_minHeight )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_wordSpacing )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_whiteSpace )( THIS_ BSTR * ) PURE;
};

/* IHTMLCurrentStyle4 interface */
#undef INTERFACE
#define INTERFACE   IHTMLCurrentStyle4
DECLARE_INTERFACE_( IHTMLCurrentStyle4, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLCurrentStyle4 methods */
    STDMETHOD( get_msInterpolationMode )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_maxHeight )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_minWidth )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_maxWidth )( THIS_ VARIANT * ) PURE;
};

/* IHTMLCurrentStyle5 interface */
#undef INTERFACE
#define INTERFACE   IHTMLCurrentStyle5
DECLARE_INTERFACE_( IHTMLCurrentStyle5, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLCurrentStyle5 methods */
    STDMETHOD( get_captionSide )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_outline )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_outlineWidth )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_outlineStyle )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_outlineColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_boxSizing )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_borderSpacing )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_orphans )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_widows )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_pageBreakInside )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_emptyCells )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_msBlockProgression )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_quotes )( THIS_ BSTR * ) PURE;
};

/* DispHTMLCurrentStyle interface */
#undef INTERFACE
#define INTERFACE   DispHTMLCurrentStyle
DECLARE_INTERFACE_( DispHTMLCurrentStyle, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLRect interface */
#undef INTERFACE
#define INTERFACE   IHTMLRect
DECLARE_INTERFACE_( IHTMLRect, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLRect methods */
    STDMETHOD( put_left )( THIS_ long ) PURE;
    STDMETHOD( get_left )( THIS_ long * ) PURE;
    STDMETHOD( put_top )( THIS_ long ) PURE;
    STDMETHOD( get_top )( THIS_ long * ) PURE;
    STDMETHOD( put_right )( THIS_ long ) PURE;
    STDMETHOD( get_right )( THIS_ long * ) PURE;
    STDMETHOD( put_bottom )( THIS_ long ) PURE;
    STDMETHOD( get_bottom )( THIS_ long * ) PURE;
};

/* IHTMLRectCollection interface */
#undef INTERFACE
#define INTERFACE   IHTMLRectCollection
DECLARE_INTERFACE_( IHTMLRectCollection, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLRectCollection methods */
    STDMETHOD( get_length )( THIS_ long * ) PURE;
    STDMETHOD( get__newEnum )( THIS_ IUnknown ** ) PURE;
    STDMETHOD( item )( THIS_ VARIANT *, VARIANT * ) PURE;
};

/* IHTMLDOMNode interface */
#undef INTERFACE
#define INTERFACE   IHTMLDOMNode
DECLARE_INTERFACE_( IHTMLDOMNode, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLDOMNode methods */
    STDMETHOD( get_nodeType )( THIS_ long * ) PURE;
    STDMETHOD( get_parentNode )( THIS_ IHTMLDOMNode ** ) PURE;
    STDMETHOD( hasChildNodes )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_childNodes )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_attributes )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( insertBefore )( THIS_ IHTMLDOMNode *, VARIANT, IHTMLDOMNode ** ) PURE;
    STDMETHOD( removeChild )( THIS_ IHTMLDOMNode *, IHTMLDOMNode ** ) PURE;
    STDMETHOD( replaceChild )( THIS_ IHTMLDOMNode *, IHTMLDOMNode *, IHTMLDOMNode ** ) PURE;
    STDMETHOD( cloneNode )( THIS_ VARIANT_BOOL, IHTMLDOMNode ** ) PURE;
    STDMETHOD( removeNode )( THIS_ VARIANT_BOOL, IHTMLDOMNode ** ) PURE;
    STDMETHOD( swapNode )( THIS_ IHTMLDOMNode *, IHTMLDOMNode ** ) PURE;
    STDMETHOD( replaceNode )( THIS_ IHTMLDOMNode *, IHTMLDOMNode ** ) PURE;
    STDMETHOD( appendChild )( THIS_ IHTMLDOMNode *, IHTMLDOMNode ** ) PURE;
    STDMETHOD( get_nodeName )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_nodeValue )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_nodeValue )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_firstChild )( THIS_ IHTMLDOMNode ** ) PURE;
    STDMETHOD( get_lastChild )( THIS_ IHTMLDOMNode ** ) PURE;
    STDMETHOD( get_previousSibling )( THIS_ IHTMLDOMNode ** ) PURE;
    STDMETHOD( get_nextSibling )( THIS_ IHTMLDOMNode ** ) PURE;
};

/* IHTMLDOMNode2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLDOMNode2
DECLARE_INTERFACE_( IHTMLDOMNode2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLDOMNode2 methods */
    STDMETHOD( get_ownerDocument )( THIS_ IDispatch ** ) PURE;
};

/* IHTMLDOMAttribute interface */
#undef INTERFACE
#define INTERFACE   IHTMLDOMAttribute
DECLARE_INTERFACE_( IHTMLDOMAttribute, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLDOMAttribute methods */
    STDMETHOD( get_nodeName )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_nodeValue )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_nodeValue )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_specified )( THIS_ VARIANT_BOOL * ) PURE;
};

/* IHTMLDOMAttribute2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLDOMAttribute2
DECLARE_INTERFACE_( IHTMLDOMAttribute2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLDOMAttribute2 methods */
    STDMETHOD( get_name )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_value )( THIS_ BSTR ) PURE;
    STDMETHOD( get_value )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_expando )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_nodeType )( THIS_ long * ) PURE;
    STDMETHOD( get_parentNode )( THIS_ IHTMLDOMNode ** ) PURE;
    STDMETHOD( get_childNodes )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_firstChild )( THIS_ IHTMLDOMNode ** ) PURE;
    STDMETHOD( get_lastChild )( THIS_ IHTMLDOMNode ** ) PURE;
    STDMETHOD( get_previousSibling )( THIS_ IHTMLDOMNode ** ) PURE;
    STDMETHOD( get_nextSibling )( THIS_ IHTMLDOMNode ** ) PURE;
    STDMETHOD( get_attributes )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_ownerDocument )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( insertBefore )( THIS_ IHTMLDOMNode *, VARIANT, IHTMLDOMNode ** ) PURE;
    STDMETHOD( replaceChild )( THIS_ IHTMLDOMNode *, IHTMLDOMNode *, IHTMLDOMNode ** ) PURE;
    STDMETHOD( removeChild )( THIS_ IHTMLDOMNode *, IHTMLDOMNode ** ) PURE;
    STDMETHOD( appendChild )( THIS_ IHTMLDOMNode *, IHTMLDOMNode ** ) PURE;
    STDMETHOD( hasChildNodes )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( cloneNodes )( THIS_ VARIANT_BOOL, IHTMLDOMAttribute ** ) PURE;
};

/* IHTMLDOMAttribute3 interface */
#undef INTERFACE
#define INTERFACE   IHTMLDOMAttribute3
DECLARE_INTERFACE_( IHTMLDOMAttribute3, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLDOMAttribute3 methods */
    STDMETHOD( put_nodeValue )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_nodeValue )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_value )( THIS_ BSTR ) PURE;
    STDMETHOD( get_value )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_specified )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_ownerElement )( THIS_ IHTMLElement2 ** ) PURE;
};

/* IHTMLDOMTextNode interface */
#undef INTERFACE
#define INTERFACE   IHTMLDOMTextNode
DECLARE_INTERFACE_( IHTMLDOMTextNode, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
    
    /* IHTMLDOMTextNode methods */
    STDMETHOD( put_data )( THIS_ BSTR ) PURE;
    STDMETHOD( get_data )( THIS_ BSTR * ) PURE;
    STDMETHOD( toString )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_length )( THIS_ long * ) PURE;
    STDMETHOD( splitText )( THIS_ long, IHTMLDOMNode ** ) PURE;
};

/* IHTMLDOMTextNode2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLDOMTextNode2
DECLARE_INTERFACE_( IHTMLDOMTextNode2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLDOMTextNode2 methods */
    STDMETHOD( substringData )( THIS_ long, long, BSTR * ) PURE;
    STDMETHOD( appendData )( THIS_ BSTR ) PURE;
    STDMETHOD( insertData )( THIS_ long, BSTR ) PURE;
    STDMETHOD( deleteData )( THIS_ long, long ) PURE;
    STDMETHOD( replaceData )( THIS_ long, long, BSTR ) PURE;
};

/* IHTMLDOMImplementation interface */
#undef INTERFACE
#define INTERFACE   IHTMLDOMImplementation
DECLARE_INTERFACE_( IHTMLDOMImplementation, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLDOMImplementation methods */
    STDMETHOD( hasFeature )( THIS_ BSTR, VARIANT, VARIANT_BOOL * ) PURE;
};

/* DispHTMLDOMAttribute interface */
#undef INTERFACE
#define INTERFACE   DispHTMLDOMAttribute
DECLARE_INTERFACE_( DispHTMLDOMAttribute, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispHTMLDOMTextNode interface */
#undef INTERFACE
#define INTERFACE   DispHTMLDOMTextNode
DECLARE_INTERFACE_( DispHTMLDOMTextNode, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispHTMLDOMImplementation interface */
#undef INTERFACE
#define INTERFACE   DispHTMLDOMImplementation
DECLARE_INTERFACE_( DispHTMLDOMImplementation, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLAttributeCollection interface */
#undef INTERFACE
#define INTERFACE   IHTMLAttributeCollection
DECLARE_INTERFACE_( IHTMLAttributeCollection, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLAttributeCollection methods */
    STDMETHOD( get_length )( THIS_ long * ) PURE;
    STDMETHOD( get__newEnum )( THIS_ IUnknown ** ) PURE;
    STDMETHOD( item )( THIS_ VARIANT *, IDispatch ** ) PURE;
};

/* IHTMLAttributeCollection2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLAttributeCollection2
DECLARE_INTERFACE_( IHTMLAttributeCollection2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLAttributeCollection2 methods */
    STDMETHOD( getNamedItem )( THIS_ BSTR, IHTMLDOMAttribute ** ) PURE;
    STDMETHOD( setNamedItem )( THIS_ IHTMLDOMAttribute *, IHTMLDOMAttribute ** ) PURE;
    STDMETHOD( removeNamedItem )( THIS_ BSTR, IHTMLDOMAttribute ** ) PURE;
};

/* IHTMLAttributeCollection3 interface */
#undef INTERFACE
#define INTERFACE   IHTMLAttributeCollection3
DECLARE_INTERFACE_( IHTMLAttributeCollection3, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLAttributeCollection3 methods */
    STDMETHOD( getNamedItem )( THIS_ BSTR, IHTMLDOMAttribute ** ) PURE;
    STDMETHOD( setNamedItem )( THIS_ IHTMLDOMAttribute *, IHTMLDOMAttribute ** ) PURE;
    STDMETHOD( removeNamedItem )( THIS_ BSTR, IHTMLDOMAttribute ** ) PURE;
    STDMETHOD( item )( THIS_ long, IHTMLDOMAttribute ** ) PURE;
    STDMETHOD( get_length )( THIS_ long * ) PURE;
};

/* IHTMLDOMChildrenCollection interface */
#undef INTERFACE
#define INTERFACE   IHTMLDOMChildrenCollection
DECLARE_INTERFACE_( IHTMLDOMChildrenCollection, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLDOMChildrenCollection methods */
    STDMETHOD( get_length )( THIS_ long * ) PURE;
    STDMETHOD( get__newEnum )( THIS_ IUnknown ** ) PURE;
    STDMETHOD( item )( THIS_ long, IDispatch ** ) PURE;
};

/* DispHTMLAttributeCollection interface */
#undef INTERFACE
#define INTERFACE   DispHTMLAttributeCollection
DECLARE_INTERFACE_( DispHTMLAttributeCollection, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispStaticNodeList interface */
#undef INTERFACE
#define INTERFACE   DispStaticNodeList
DECLARE_INTERFACE_( DispStaticNodeList, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispDOMChildrenCollection interface */
#undef INTERFACE
#define INTERFACE   DispDOMChildrenCollection
DECLARE_INTERFACE_( DispDOMChildrenCollection, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLElementEvents3 interface */
#undef INTERFACE
#define INTERFACE   HTMLElementEvents3
DECLARE_INTERFACE_( HTMLElementEvents3, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLElementEvents2 interface */
#undef INTERFACE
#define INTERFACE   HTMLElementEvents2
DECLARE_INTERFACE_( HTMLElementEvents2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLElementEvents interface */
#undef INTERFACE
#define INTERFACE   HTMLElementEvents
DECLARE_INTERFACE_( HTMLElementEvents, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLElement
DECLARE_INTERFACE_( IHTMLElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLElement methods */
    STDMETHOD( setAttribute )( THIS_ BSTR, VARIANT, LONG ) PURE;
    STDMETHOD( getAttribute )( THIS_ BSTR, LONG, VARIANT * ) PURE;
    STDMETHOD( removeAttribute )( THIS_ BSTR, LONG, VARIANT_BOOL * ) PURE;
    STDMETHOD( put_className )( THIS_ BSTR ) PURE;
    STDMETHOD( get_className )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_id )( THIS_ BSTR ) PURE;
    STDMETHOD( get_id )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_tagName )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_parentElement )( THIS_ IHTMLElement ** ) PURE;
    STDMETHOD( get_style )( THIS_ IHTMLStyle ** ) PURE;
    STDMETHOD( put_onhelp )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onhelp )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onclick )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onclick )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_ondblclick )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_ondblclick )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onkeydown )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onkeydown )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onkeyup )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onkeyup )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onkeypress )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onkeypress )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onmouseout )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onmouseout )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onmouseover )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onmouseover )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onmousemove )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onmousemove )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onmousedown )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onmousedown )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onmouseup )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onmouseup )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_document )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( put_title )( THIS_ BSTR ) PURE;
    STDMETHOD( get_title )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_language )( THIS_ BSTR ) PURE;
    STDMETHOD( get_language )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_onselectstart )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onselectstart )( THIS_ VARIANT * ) PURE;
    STDMETHOD( scrollIntoView )( THIS_ VARIANT ) PURE;
    STDMETHOD( contains )( THIS_ IHTMLElement *, VARIANT_BOOL * ) PURE;
    STDMETHOD( get_sourceIndex )( THIS_ long * ) PURE;
    STDMETHOD( get_recordNumber )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_lang )( THIS_ BSTR ) PURE;
    STDMETHOD( get_lang )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_offsetLeft )( THIS_ long * ) PURE;
    STDMETHOD( get_offsetTop )( THIS_ long * ) PURE;
    STDMETHOD( get_offsetWidth )( THIS_ long * ) PURE;
    STDMETHOD( get_offsetHeight )( THIS_ long * ) PURE;
    STDMETHOD( get_offsetParent )( THIS_ IHTMLElement ** ) PURE;
    STDMETHOD( put_innerHTML )( THIS_ BSTR ) PURE;
    STDMETHOD( get_innerHTML )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_innerText )( THIS_ BSTR ) PURE;
    STDMETHOD( get_innerText )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_outerHTML )( THIS_ BSTR ) PURE;
    STDMETHOD( get_outerHTML )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_outerText )( THIS_ BSTR ) PURE;
    STDMETHOD( get_outerText )( THIS_ BSTR * ) PURE;
    STDMETHOD( insertAdjacentHTML )( THIS_ BSTR, BSTR ) PURE;
    STDMETHOD( insertAdjacentText )( THIS_ BSTR, BSTR ) PURE;
    STDMETHOD( get_parentTextEdit )( THIS_ IHTMLElement ** ) PURE;
    STDMETHOD( get_isTextEdit )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( click )( THIS ) PURE;
    STDMETHOD( get_filters )( THIS_ IHTMLFiltersCollection ** ) PURE;
    STDMETHOD( put_ondragstart )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_ondragstart )( THIS_ VARIANT * ) PURE;
    STDMETHOD( toString )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_onbeforeupdate )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onbeforeupdate )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onafterupdate )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onafterupdate )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onerrorupdate )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onerrorupdate )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onrowexit )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onrowexit )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onrowenter )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onrowenter )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_ondatasetchanged )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_ondatasetchanged )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_ondataavailable )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_ondataavailable )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_ondatasetcomplete )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_ondatasetcomplete )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onfilterchange )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onfilterchange )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_children )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_all )( THIS_ IDispatch ** ) PURE;
};

/* IHTMLElement2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLElement2
DECLARE_INTERFACE_( IHTMLElement2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLElement2 methods */
    STDMETHOD( get_scopeName )( THIS_ BSTR * ) PURE;
    STDMETHOD( setCapture )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( releaseCapture )( THIS ) PURE;
    STDMETHOD( put_onlosecapture )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onlosecapture )( THIS_ VARIANT * ) PURE;
    STDMETHOD( componentFromPoint )( THIS_ long, long, BSTR * ) PURE;
    STDMETHOD( doScroll )( THIS_ VARIANT ) PURE;
    STDMETHOD( put_onscroll )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onscroll )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_ondrag )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_ondrag )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_ondragend )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_ondragend )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_ondragenter )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_ondragenter )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_ondragover )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_ondragover )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_ondragleave )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_ondragleave )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_ondrop )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_ondrop )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onbeforecut )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onbeforecut )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_oncut )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_oncut )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onbeforecopy )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onbeforecopy )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_oncopy )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_oncopy )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onbeforepaste )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onbeforepaste )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onpaste )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onpaste )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_currentStyle )( THIS_ IHTMLCurrentStyle ** ) PURE;
    STDMETHOD( put_onpropertychange )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onpropertychange )( THIS_ VARIANT * ) PURE;
    STDMETHOD( getClientRects )( THIS_ IHTMLRectCollection ** ) PURE;
    STDMETHOD( getBoundingClientRect )( THIS_ IHTMLRect ** ) PURE;
    STDMETHOD( setExpression )( THIS_ BSTR, BSTR, BSTR ) PURE;
    STDMETHOD( getExpression )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( removeExpression )( THIS_ BSTR, VARIANT_BOOL * ) PURE;
    STDMETHOD( put_tabIndex )( THIS_ short ) PURE;
    STDMETHOD( get_tabIndex )( THIS_ short * ) PURE;
    STDMETHOD( focus )( THIS ) PURE;
    STDMETHOD( put_accessKey )( THIS_ BSTR ) PURE;
    STDMETHOD( get_accessKey )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_onblur )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onblur )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onfocus )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onfocus )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onresize )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onresize )( THIS_ VARIANT * ) PURE;
    STDMETHOD( blur )( THIS ) PURE;
    STDMETHOD( addFilter )( THIS_ IUnknown * ) PURE;
    STDMETHOD( removeFilter )( THIS_ IUnknown * ) PURE;
    STDMETHOD( get_clientHeight )( THIS_ long * ) PURE;
    STDMETHOD( get_clientWidth )( THIS_ long * ) PURE;
    STDMETHOD( get_clientTop )( THIS_ long * ) PURE;
    STDMETHOD( get_clientLeft )( THIS_ long * ) PURE;
    STDMETHOD( attachEvent )( THIS_ BSTR, IDispatch *, VARIANT_BOOL * ) PURE;
    STDMETHOD( detachEvent )( THIS_ BSTR, IDispatch * ) PURE;
    STDMETHOD( get_readyState )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onreadystatechange )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onreadystatechange )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onrowsdelete )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onrowsdelete )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onrowsinserted )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onrowsinserted )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_oncellchange )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_oncellchange )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_dir )( THIS_ BSTR ) PURE;
    STDMETHOD( get_dir )( THIS_ BSTR * ) PURE;
    STDMETHOD( createControlRange )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_scrollHeight )( THIS_ long * ) PURE;
    STDMETHOD( get_scrollWidth )( THIS_ long * ) PURE;
    STDMETHOD( put_scrollTop )( THIS_ long ) PURE;
    STDMETHOD( get_scrollTop )( THIS_ long * ) PURE;
    STDMETHOD( put_scrollLeft )( THIS_ long ) PURE;
    STDMETHOD( get_scrollLeft )( THIS_ long * ) PURE;
    STDMETHOD( clearAttributes )( THIS ) PURE;
    STDMETHOD( mergeAttributes )( THIS_ IHTMLElement * ) PURE;
    STDMETHOD( put_oncontextmenu )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_oncontextmenu )( THIS_ VARIANT * ) PURE;
    STDMETHOD( insertAdjacentElement )( THIS_ BSTR, IHTMLElement *, IHTMLElement ** ) PURE;
    STDMETHOD( applyElement )( THIS_ IHTMLElement *, BSTR, IHTMLElement ** ) PURE;
    STDMETHOD( getAdjacentText )( THIS_ BSTR, BSTR * ) PURE;
    STDMETHOD( replaceAdjacentText )( THIS_ BSTR, BSTR, BSTR * ) PURE;
    STDMETHOD( get_canHaveChildren )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( addBehavior )( THIS_ BSTR, VARIANT *, long * ) PURE;
    STDMETHOD( removeBehavior )( THIS_ long, VARIANT_BOOL * ) PURE;
    STDMETHOD( get_runtimeStyle )( THIS_ IHTMLStyle ** ) PURE;
    STDMETHOD( get_behaviorUrns )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( put_tagUrn )( THIS_ BSTR ) PURE;
    STDMETHOD( get_tagUrn )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_onbeforeeditfocus )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onbeforeeditfocus )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_readyStateValue )( THIS_ long * ) PURE;
    STDMETHOD( getElementsByTagName )( THIS_ BSTR, IHTMLElementCollection ** ) PURE;
};

/* IHTMLElement3 interface */
#undef INTERFACE
#define INTERFACE   IHTMLElement3
DECLARE_INTERFACE_( IHTMLElement3, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLElement3 interface */
    STDMETHOD( mergeAttributes )( THIS_ IHTMLElement *, VARIANT * ) PURE;
    STDMETHOD( get_isMultiLine )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_canHaveHTML )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_onlayoutcomplete )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onlayoutcompelte )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onpage )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onpage )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_inflateBlock )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_inflateBlock )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_onbeforedeactivate )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onbeforedeactivate )( THIS_ VARIANT * ) PURE;
    STDMETHOD( setActive )( THIS ) PURE;
    STDMETHOD( put_contentEditable )( THIS_ BSTR ) PURE;
    STDMETHOD( get_contentEditable )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_isContentEditable )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_hideFocus )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_hideFocus )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_disabled )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_disabled )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_isDisabled )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_onmove )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onmove )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_oncontrolselect )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_oncontrolselect )( THIS_ VARIANT * ) PURE;
    STDMETHOD( fireEvent )( THIS_ BSTR, VARIANT *, VARIANT_BOOL * ) PURE;
    STDMETHOD( put_onresizestart )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onresizestart )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onresizeend )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onresizeend )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onmovestart )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onmovestart )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onmoveend )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onmoveend )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onmouseenter )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onmouseenter )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onmouseleave )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onmouseleave )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onactivate )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onactivate )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_ondeactivate )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_ondeactivate )( THIS_ VARIANT * ) PURE;
    STDMETHOD( dragDrop )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_glyphMode )( THIS_ LONG * ) PURE;
};

/* IHTMLElement4 interface */
#undef INTERFACE
#define INTERFACE   IHTMLElement4
DECLARE_INTERFACE_( IHTMLElement4, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLElement4 methods */
    STDMETHOD( put_onmousewheel )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onmousewheel )( THIS_ VARIANT * ) PURE;
    STDMETHOD( normalize )( THIS ) PURE;
    STDMETHOD( getAttributeNode )( THIS_ BSTR, IHTMLDOMAttribute ** ) PURE;
    STDMETHOD( setAttributeNode )( THIS_ IHTMLDOMAttribute *, IHTMLDOMAttribute ** ) PURE;
    STDMETHOD( removeAttributeNode )( THIS_ IHTMLDOMAttribute *, IHTMLDOMAttribute ** ) PURE;
    STDMETHOD( put_onbeforeactivate )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onbeforeactivate )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onfocusin )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onfocusin )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onfocusout )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onfocusout )( THIS_ VARIANT * ) PURE;
};

/* IElementSelector interface */
#undef INTERFACE
#define INTERFACE   IElementSelector
DECLARE_INTERFACE_( IElementSelector, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
    
    /* IElementSelector methods */
    STDMETHOD( querySelector )( THIS_ BSTR, IHTMLElement ** ) PURE;
    STDMETHOD( querySelectorAll )( THIS_ BSTR, IHTMLDOMChildrenCollection ** ) PURE;
};

/* IHTMLElementRender interface */
#undef INTERFACE
#define INTERFACE   IHTMLElementRender
DECLARE_INTERFACE_( IHTMLElementRender, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IHTMLElementRender methods */
    STDMETHOD( DrawToDC )( THIS_ HDC ) PURE;
    STDMETHOD( SetDocumentPrinter )( THIS_ BSTR, HDC ) PURE;
};

/* IHTMLUniqueName interface */
#undef INTERFACE
#define INTERFACE   IHTMLUniqueName
DECLARE_INTERFACE_( IHTMLUniqueName, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLUniqueName methods */
    STDMETHOD( get_uniqueNumber )( THIS_ long * ) PURE;
    STDMETHOD( get_uniqueID )( THIS_ BSTR * ) PURE;
};

/* IHTMLElement5 interface */
#undef INTERFACE
#define INTERFACE   IHTMLElement5
DECLARE_INTERFACE_( IHTMLElement5, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLElement5 methods */
    STDMETHOD( getAttributeNode )( THIS_ BSTR, IHTMLDOMAttribute2 ** ) PURE;
    STDMETHOD( setAttributeNode )( THIS_ IHTMLDOMAttribute2 *, IHTMLDOMAttribute2 ** ) PURE;
    STDMETHOD( removeAttributeNode )( THIS_ IHTMLDOMAttribute2 *, IHTMLDOMAttribute2 ** ) PURE;
    STDMETHOD( hasAttribute )( THIS_ BSTR, VARIANT_BOOL * ) PURE;
    STDMETHOD( put_role )( THIS_ BSTR ) PURE;
    STDMETHOD( get_role )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_ariaBusy )( THIS_ BSTR ) PURE;
    STDMETHOD( get_ariaBusy )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_ariaChecked )( THIS_ BSTR ) PURE;
    STDMETHOD( get_ariaChecked )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_ariaDisabled )( THIS_ BSTR ) PURE;
    STDMETHOD( get_ariaDisabled )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_ariaExpanded )( THIS_ BSTR ) PURE;
    STDMETHOD( get_ariaExpanded )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_ariaHaspopup )( THIS_ BSTR ) PURE;
    STDMETHOD( get_ariaHaspopup )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_ariaHidden )( THIS_ BSTR ) PURE;
    STDMETHOD( get_ariaHidden )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_ariaInvalid )( THIS_ BSTR ) PURE;
    STDMETHOD( get_ariaInvalid )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_ariaMultiselectable )( THIS_ BSTR ) PURE;
    STDMETHOD( get_ariaMultiselectable )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_ariaPressed )( THIS_ BSTR ) PURE;
    STDMETHOD( get_ariaPressed )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_ariaReadonly )( THIS_ BSTR ) PURE;
    STDMETHOD( get_ariaReadonly )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_ariaRequired )( THIS_ BSTR ) PURE;
    STDMETHOD( get_ariaRequired )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_ariaSecret )( THIS_ BSTR ) PURE;
    STDMETHOD( get_ariaSecret )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_ariaSelected )( THIS_ BSTR ) PURE;
    STDMETHOD( get_ariaSelected )( THIS_ BSTR * ) PURE;
    STDMETHOD( getAttribute )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( setAttribute )( THIS_ BSTR, VARIANT ) PURE;
    STDMETHOD( removeAttribute )( THIS_ BSTR, VARIANT_BOOL * ) PURE;
    STDMETHOD( get_attributes )( THIS_ IHTMLAttributeCollection3 ** ) PURE;
    STDMETHOD( put_ariaValuenow )( THIS_ BSTR ) PURE;
    STDMETHOD( get_ariaValuenow )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_ariaPosinset )( THIS_ short ) PURE;
    STDMETHOD( get_ariaPosinset )( THIS_ short * ) PURE;
    STDMETHOD( put_ariaSetsize )( THIS_ short ) PURE;
    STDMETHOD( get_ariaSetsize )( THIS_ short * ) PURE;
    STDMETHOD( put_ariaLevel )( THIS_ short ) PURE;
    STDMETHOD( get_ariaLevel )( THIS_ short * ) PURE;
    STDMETHOD( put_ariaValuemin )( THIS_ BSTR ) PURE;
    STDMETHOD( get_ariaValuemin )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_ariaValuemax )( THIS_ BSTR ) PURE;
    STDMETHOD( get_ariaValuemax )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_ariaControls )( THIS_ BSTR ) PURE;
    STDMETHOD( get_ariaControls )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_ariaDescribedby )( THIS_ BSTR ) PURE;
    STDMETHOD( get_ariaDescribedby )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_ariaFlowto )( THIS_ BSTR ) PURE;
    STDMETHOD( get_ariaFlowto )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_ariaLabelledby )( THIS_ BSTR ) PURE;
    STDMETHOD( get_ariaLabelledby )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_ariaActivedescendant )( THIS_ BSTR ) PURE;
    STDMETHOD( get_ariaActivedescendant )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_ariaOwns )( THIS_ BSTR ) PURE;
    STDMETHOD( get_ariaOwns )( THIS_ BSTR * ) PURE;
    STDMETHOD( hasAttributes )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_ariaLive )( THIS_ BSTR ) PURE;
    STDMETHOD( get_ariaLive )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_ariaRelevant )( THIS_ BSTR ) PURE;
    STDMETHOD( get_ariaRelevant )( THIS_ BSTR * ) PURE;
};

/* IHTMLDatabinding interface */
#undef INTERFACE
#define INTERFACE   IHTMLDatabinding
DECLARE_INTERFACE_( IHTMLDatabinding, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLDatabinding */
    STDMETHOD( put_dataFld )( THIS_ BSTR ) PURE;
    STDMETHOD( get_dataFld )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_dataSrc )( THIS_ BSTR ) PURE;
    STDMETHOD( get_dataSrc )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_dataFormatAs )( THIS_ BSTR ) PURE;
    STDMETHOD( get_dataFormatAs )( THIS_ BSTR * ) PURE;
};

/* IHTMLElementDefaults interface */
#undef INTERFACE
#define INTERFACE   IHTMLElementDefaults
DECLARE_INTERFACE_( IHTMLElementDefaults, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLElementDefaults methods */
    STDMETHOD( get_style )( THIS_ IHTMLStyle ** ) PURE;
    STDMETHOD( put_tabStop )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_tabStop )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_viewInheritStyle )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_viewInheritStyle )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_viewMasterTab )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_viewMasterTab )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_scrollSegmentX )( THIS_ long ) PURE;
    STDMETHOD( get_scrollSegmentX )( THIS_ long * ) PURE;
    STDMETHOD( put_scrollSegmentY )( THIS_ long ) PURE;
    STDMETHOD( get_scrollSegmentY )( THIS_ long * ) PURE;
    STDMETHOD( put_isMultiLine )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_isMultiLine )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_contentEditable )( THIS_ BSTR ) PURE;
    STDMETHOD( get_contentEditable )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_canHaveHTML )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_canHaveHTML )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( putref_viewLink )( THIS_ IHTMLDocument * ) PURE;
    STDMETHOD( get_viewLink )( THIS_ IHTMLDocument ** ) PURE;
    STDMETHOD( put_frozen )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_frozen )( THIS_ VARIANT_BOOL * ) PURE;
};

/* DispHTMLDefaults interface */
#undef INTERFACE
#define INTERFACE   DispHTMLDefaults
DECLARE_INTERFACE_( DispHTMLDefaults, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTCDefaultDispatch interface */
#undef INTERFACE
#define INTERFACE   IHTCDefaultDispatch
DECLARE_INTERFACE_( IHTCDefaultDispatch, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTCDefaultDispatch methods */
    STDMETHOD( get_element )( THIS_ IHTMLElement ** ) PURE;
    STDMETHOD( createEventObject )( THIS_ IHTMLEventObj ** ) PURE;
    STDMETHOD( get_defaults )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_document )( THIS_ IDispatch ** ) PURE;
};

/* IHTCPropertyBehavior interface */
#undef INTERFACE
#define INTERFACE   IHTCPropertyBehavior
DECLARE_INTERFACE_( IHTCPropertyBehavior, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTCPropertyBehavior methods */
    STDMETHOD( fireChange )( THIS ) PURE;
    STDMETHOD( put_value )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_value )( THIS_ VARIANT * ) PURE;
};

/* IHTCMethodBehavior interface */
#undef INTERFACE
#define INTERFACE   IHTCMethodBehavior
DECLARE_INTERFACE_( IHTCMethodBehavior, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTCEventBehavior interface */
#undef INTERFACE
#define INTERFACE   IHTCEventBehavior
DECLARE_INTERFACE_( IHTCEventBehavior, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
    
    /* IHTCEventBehavior methods */
    STDMETHOD( fire )( THIS_ IHTMLEventObj * ) PURE;
};

/* IHTCAttachBehavior interface */
#undef INTERFACE
#define INTERFACE   IHTCAttachBehavior
DECLARE_INTERFACE_( IHTCAttachBehavior, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
    
    /* IHTCAttachBehavior methods */
    STDMETHOD( fireEvent )( THIS_ IDispatch * ) PURE;
    STDMETHOD( detachEvent )( THIS ) PURE;
};

/* IHTCAttachBehavior2 interface */
#undef INTERFACE
#define INTERFACE   IHTCAttachBehavior2
DECLARE_INTERFACE_( IHTCAttachBehavior2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
    
    /* IHTCAttachBehavior2 methods */
    STDMETHOD( fireEvent )( THIS_ VARIANT ) PURE;
};

/* IHTCDescBehavior interface */
#undef INTERFACE
#define INTERFACE   IHTCDescBehavior
DECLARE_INTERFACE_( IHTCDescBehavior, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
    
    /* IHTCDescBehavior methods */
    STDMETHOD( get_urn )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_name )( THIS_ BSTR * ) PURE;
};

/* DispHTCDefaultDispatch interface */
#undef INTERFACE
#define INTERFACE   DispHTCDefaultDispatch
DECLARE_INTERFACE_( DispHTCDefaultDispatch, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispHTCPropertyBehavior interface */
#undef INTERFACE
#define INTERFACE   DispHTCPropertyBehavior
DECLARE_INTERFACE_( DispHTCPropertyBehavior, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispHTCMethodBehavior interface */
#undef INTERFACE
#define INTERFACE   DispHTCMethodBehavior
DECLARE_INTERFACE_( DispHTCMethodBehavior, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispHTCEventBehavior interface */
#undef INTERFACE
#define INTERFACE   DispHTCEventBehavior
DECLARE_INTERFACE_( DispHTCEventBehavior, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispHTCAttachBehavior interface */
#undef INTERFACE
#define INTERFACE   DispHTCAttachBehavior
DECLARE_INTERFACE_( DispHTCAttachBehavior, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispHTCDescBehavior interface */
#undef INTERFACE
#define INTERFACE   DispHTCDescBehavior
DECLARE_INTERFACE_( DispHTCDescBehavior, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLUrnCollection interface */
#undef INTERFACE
#define INTERFACE   IHTMLUrnCollection
DECLARE_INTERFACE_( IHTMLUrnCollection, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLUrnCollection methods */
    STDMETHOD( get_length )( THIS_ long * ) PURE;
    STDMETHOD( item )( THIS_ long, BSTR * ) PURE;
};

/* DispHTMLUrnCollection interface */
#undef INTERFACE
#define INTERFACE   DispHTMLUrnCollection
DECLARE_INTERFACE_( DispHTMLUrnCollection, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLGenericElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLGenericElement
DECLARE_INTERFACE_( IHTMLGenericElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLGenericElement methods */
    STDMETHOD( get_recordset )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( namedRecordset )( THIS_ BSTR, VARIANT *, IDispatch ** ) PURE;
};

/* DispHTMLGenericElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLGenericElement
DECLARE_INTERFACE_( DispHTMLGenericElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLStyleSheetRule interface */
#undef INTERFACE
#define INTERFACE   IHTMLStyleSheetRule
DECLARE_INTERFACE_( IHTMLStyleSheetRule, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLStyleSheetRule methods */
    STDMETHOD( put_selectorText )( THIS_ BSTR ) PURE;
    STDMETHOD( get_selectorText )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_style )( THIS_ IHTMLRuleStyle ** ) PURE;
    STDMETHOD( get_readOnly )( THIS_ VARIANT_BOOL * ) PURE;
};

/* IHTMLStyleSheetRulesCollection interface */
#undef INTERFACE
#define INTERFACE   IHTMLStyleSheetRulesCollection
DECLARE_INTERFACE_( IHTMLStyleSheetRulesCollection, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLStyleSheetRulesCollection methods */
    STDMETHOD( get_length )( THIS_ long * ) PURE;
    STDMETHOD( item )( THIS_ IHTMLStyleSheetRule ** ) PURE;
};

/* DispHTMLStyleSheetRule interface */
#undef INTERFACE
#define INTERFACE   DispHTMLStyleSheetRule
DECLARE_INTERFACE_( DispHTMLStyleSheetRule, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispHTMLStyleSheetRulesCollection interface */
#undef INTERFACE
#define INTERFACE   DispHTMLStyleSheetRulesCollection
DECLARE_INTERFACE_( DispHTMLStyleSheetRulesCollection, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLStyleSheetPage interface */
#undef INTERFACE
#define INTERFACE   IHTMLStyleSheetPage
DECLARE_INTERFACE_( IHTMLStyleSheetPage, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLStyleSheetPage methods */
    STDMETHOD( get_selector )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_pseudoClass )( THIS_ BSTR * ) PURE;
};

/* IHTMLStyleSheetPagesCollection interface */
#undef INTERFACE
#define INTERFACE   IHTMLStyleSheetPagesCollection
DECLARE_INTERFACE_( IHTMLStyleSheetPagesCollection, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLStyleSheetPagesCollection methods */
    STDMETHOD( get_length )( THIS_ long * ) PURE;
    STDMETHOD( item )( THIS_ long, IHTMLStyleSheetPage ** ) PURE;
};

/* DispHTMLStyleSheetPage interface */
#undef INTERFACE
#define INTERFACE   DispHTMLStyleSheetPage
DECLARE_INTERFACE_( DispHTMLStyleSheetPage, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispHTMLStyleSheetPagesCollection interface */
#undef INTERFACE
#define INTERFACE   DispHTMLStyleSheetPagesCollection
DECLARE_INTERFACE_( DispHTMLStyleSheetPagesCollection, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLStyleSheet interface */
#undef INTERFACE
#define INTERFACE   IHTMLStyleSheet
DECLARE_INTERFACE_( IHTMLStyleSheet, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLStyleSheet methods */
    STDMETHOD( put_title )( THIS_ BSTR ) PURE;
    STDMETHOD( get_title )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_parentStyleSheet )( THIS_ IHTMLStyleSheet ** ) PURE;
    STDMETHOD( get_owningElement )( THIS_ IHTMLElement ** ) PURE;
    STDMETHOD( put_disabled )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_disabled )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_readOnly )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_imports )( THIS_ IHTMLStyleSheetsCollection ** );
    STDMETHOD( put_href )( THIS_ BSTR ) PURE;
    STDMETHOD( get_href )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_type )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_id )( THIS_ BSTR * ) PURE;
    STDMETHOD( addImport )( THIS_ BSTR, long, long * ) PURE;
    STDMETHOD( addRule )( THIS_ BSTR, BSTR, long, long * ) PURE;
    STDMETHOD( removeImport )( THIS_ long ) PURE;
    STDMETHOD( removeRule )( THIS_ long ) PURE;
    STDMETHOD( put_media )( THIS_ BSTR ) PURE;
    STDMETHOD( get_media )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_cssText )( THIS_ BSTR ) PURE;
    STDMETHOD( get_cssText )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_rules )( THIS_ IHTMLStyleSheetRulesCollection ** ) PURE;
};

/* IHTMLStyleSheet2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLStyleSheet2
DECLARE_INTERFACE_( IHTMLStyleSheet2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLStyleSheet2 methods */
    STDMETHOD( get_pages )( THIS_ IHTMLStyleSheetPagesCollection ** ) PURE;
    STDMETHOD( addPageRule )( THIS_ BSTR, BSTR, long, long * ) PURE;
};

/* IHTMLStyleSheet3 interface */
#undef INTERFACE
#define INTERFACE   IHTMLStyleSheet3
DECLARE_INTERFACE_( IHTMLStyleSheet3, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLStyleSheet3 methods */
    STDMETHOD( put_href )( THIS_ BSTR ) PURE;
    STDMETHOD( get_href )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_isAlternate )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_isPrefAlternate )( THIS_ VARIANT_BOOL * ) PURE;
};

/* DispHTMLStyleSheet interface */
#undef INTERFACE
#define INTERFACE   DispHTMLStyleSheet
DECLARE_INTERFACE_( DispHTMLStyleSheet, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLStyleSheetsCollection interface */
#undef INTERFACE
#define INTERFACE   IHTMLStyleSheetsCollection
DECLARE_INTERFACE_( IHTMLStyleSheetsCollection, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLStyleSheetsCollection methods */
    STDMETHOD( get_length )( THIS_ long * ) PURE;
    STDMETHOD( get__newEnum )( THIS_ IUnknown ** ) PURE;
    STDMETHOD( item )( THIS_ VARIANT *, VARIANT * ) PURE;
};

/* DispHTMLStyleSheetsCollection interface */
#undef INTERFACE
#define INTERFACE   DispHTMLStyleSheetsCollection
DECLARE_INTERFACE_( DispHTMLStyleSheetsCollection, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLLinkElementEvents2 interface */
#undef INTERFACE
#define INTERFACE   HTMLLinkElementEvents2
DECLARE_INTERFACE_( HTMLLinkElementEvents2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLLinkElementEvents interface */
#undef INTERFACE
#define INTERFACE   HTMLLinkElementEvents
DECLARE_INTERFACE_( HTMLLinkElementEvents, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLLinkElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLLinkElement
DECLARE_INTERFACE_( IHTMLLinkElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLLinkElement methods */
    STDMETHOD( put_href )( THIS_ BSTR ) PURE;
    STDMETHOD( get_href )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_rel )( THIS_ BSTR ) PURE;
    STDMETHOD( get_rel )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_rev )( THIS_ BSTR ) PURE;
    STDMETHOD( get_rev )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_type )( THIS_ BSTR ) PURE;
    STDMETHOD( get_type )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_readyState )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_onreadystatechange )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onreadystatechange )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onload )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onload )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onerror )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onerror )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_styleSheet )( THIS_ IHTMLStyleSheet ** ) PURE;
    STDMETHOD( put_disabled )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_disabled )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_media )( THIS_ BSTR ) PURE;
    STDMETHOD( get_media )( THIS_ BSTR * ) PURE;
};

/* IHTMLLinkElement2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLLinkElement2
DECLARE_INTERFACE_( IHTMLLinkElement2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLLinkElement2 methods */
    STDMETHOD( put_target )( THIS_ BSTR ) PURE;
    STDMETHOD( get_target )( THIS_ BSTR * ) PURE;
};

/* IHTMLLinkElement3 interface */
#undef INTERFACE
#define INTERFACE   IHTMLLinkElement3
DECLARE_INTERFACE_( IHTMLLinkElement3, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLLinkElement3 methods */
    STDMETHOD( put_charset )( THIS_ BSTR ) PURE;
    STDMETHOD( get_charset )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_hreflang )( THIS_ BSTR ) PURE;
    STDMETHOD( get_hreflang )( THIS_ BSTR * ) PURE;
};

/* IHTMLLinkElement4 interface */
#undef INTERFACE
#define INTERFACE   IHTMLLinkElement4
DECLARE_INTERFACE_( IHTMLLinkElement4, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLLinkElement4 methods */
    STDMETHOD( put_href )( THIS_ BSTR ) PURE;
    STDMETHOD( get_href )( THIS_ BSTR * ) PURE;
};

/* DispHTMLLinkElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLLinkElement
DECLARE_INTERFACE_( DispHTMLLinkElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLTxtRange interface */
#undef INTERFACE
#define INTERFACE   IHTMLTxtRange
DECLARE_INTERFACE_( IHTMLTxtRange, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLTxtRange methods */
    STDMETHOD( get_htmlText )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_text )( THIS_ BSTR ) PURE;
    STDMETHOD( get_text )( THIS_ BSTR * ) PURE;
    STDMETHOD( parentElement )( THIS_ IHTMLElement ** ) PURE;
    STDMETHOD( duplicate )( THIS_ IHTMLTxtRange ** ) PURE;
    STDMETHOD( inRange )( THIS_ IHTMLTxtRange *, VARIANT_BOOL * ) PURE;
    STDMETHOD( isEqual )( THIS_ IHTMLTxtRange *, VARIANT_BOOL * ) PURE;
    STDMETHOD( scrollIntoView )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( collapse )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( expand )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( move )( THIS_ BSTR, long, long * ) PURE;
    STDMETHOD( moveStart )( THIS_ BSTR, long, long * ) PURE;
    STDMETHOD( moveEnd )( THIS_ BSTR, long, long * ) PURE;
    STDMETHOD( select )( THIS ) PURE;
    STDMETHOD( pasteHTML )( THIS_ BSTR ) PURE;
    STDMETHOD( moveToElementText )( THIS_ IHTMLElement * ) PURE;
    STDMETHOD( setEndPoint )( THIS_ BSTR, IHTMLTxtRange * ) PURE;
    STDMETHOD( compareEndPoints )( THIS_ BSTR, IHTMLTxtRange *, long * ) PURE;
    STDMETHOD( findText )( THIS_ BSTR, long, long, VARIANT_BOOL * ) PURE;
    STDMETHOD( moveToPoints )( THIS_ long, long ) PURE;
    STDMETHOD( getBookmark )( THIS_ BSTR * ) PURE;
    STDMETHOD( moveToBookmark )( THIS_ BSTR, VARIANT_BOOL * ) PURE;
    STDMETHOD( queryCommandSupported )( THIS_ BSTR, VARIANT_BOOL * ) PURE;
    STDMETHOD( queryCommandEnabled )( THIS_ BSTR, VARIANT_BOOL * ) PURE;
    STDMETHOD( queryCommandState )( THIS_ BSTR, VARIANT_BOOL * ) PURE;
    STDMETHOD( queryCommandIndeterm )( THIS_ BSTR, VARIANT_BOOL * ) PURE;
    STDMETHOD( queryCommandText )( THIS_ BSTR, BSTR * ) PURE;
    STDMETHOD( queryCommandValue )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( execCommand )( THIS_ BSTR, VARIANT_BOOL, VARIANT, VARIANT_BOOL * ) PURE;
    STDMETHOD( execCommandShowHelp )( THIS_ BSTR, VARIANT_BOOL * ) PURE;
};

/* IHTMLTextRangeMetrics interface */
#undef INTERFACE
#define INTERFACE   IHTMLTextRangeMetrics
DECLARE_INTERFACE_( IHTMLTextRangeMetrics, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLTextRangeMetric methods */
    STDMETHOD( get_offsetTop )( THIS_ long * ) PURE;
    STDMETHOD( get_offsetLeft )( THIS_ long * ) PURE;
    STDMETHOD( get_boundingTop )( THIS_ long * ) PURE;
    STDMETHOD( get_boundingLeft )( THIS_ long * ) PURE;
    STDMETHOD( get_boundingWidth )( THIS_ long * ) PURE;
    STDMETHOD( get_boundingHeight )( THIS_ long * ) PURE;
};

/* IHTMLTextRangeMetrics2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLTextRangeMetrics2
DECLARE_INTERFACE_( IHTMLTextRangeMetrics2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLTextRangeMetrics2 methods */
    STDMETHOD( getClientRects )( THIS_ IHTMLRectCollection ** ) PURE;
    STDMETHOD( getBoundingClientRect )( THIS_ IHTMLRect ** ) PURE;
};

/* IHTMLTxtRangeCollection interface */
#undef INTERFACE
#define INTERFACE   IHTMLTxtRangeCollection
DECLARE_INTERFACE_( IHTMLTxtRangeCollection, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLTxtRangeCollection methods */
    STDMETHOD( get_length )( THIS_ long * ) PURE;
    STDMETHOD( get__newEnum )( THIS_ IUnknown ** ) PURE;
    STDMETHOD( item )( THIS_ VARIANT *, VARIANT * ) PURE;
};

/* HTMLFormElementEvents2 interface */
#undef INTERFACE
#define INTERFACE   HTMLFormElementEvents2
DECLARE_INTERFACE_( HTMLFormElementEvents2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLFormElementEvents interface */
#undef INTERFACE
#define INTERFACE   HTMLFormElementEvents
DECLARE_INTERFACE_( HTMLFormElementEvents, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLFormElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLFormElement
DECLARE_INTERFACE_( IHTMLFormElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLFormElement methods */
    STDMETHOD( put_action )( THIS_ BSTR ) PURE;
    STDMETHOD( get_action )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_dir )( THIS_ BSTR ) PURE;
    STDMETHOD( get_dir )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_encoding )( THIS_ BSTR ) PURE;
    STDMETHOD( get_encoding )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_method )( THIS_ BSTR ) PURE;
    STDMETHOD( get_method )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_elements )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( put_target )( THIS_ BSTR ) PURE;
    STDMETHOD( get_target )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_name )( THIS_ BSTR ) PURE;
    STDMETHOD( get_name )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_onsubmit )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onsubmit )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onreset )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onreset )( THIS_ VARIANT ) PURE;
    STDMETHOD( submit )( THIS ) PURE;
    STDMETHOD( reset )( THIS ) PURE;
    STDMETHOD( put_length )( THIS_ long ) PURE;
    STDMETHOD( get_length )( THIS_ long * ) PURE;
    STDMETHOD( get__newEnum )( THIS_ IUnknown ** ) PURE;
    STDMETHOD( item )( THIS_ VARIANT, VARIANT, IDispatch ** ) PURE;
    STDMETHOD( tags )( THIS_ VARIANT, IDispatch ** ) PURE;
};

/* IHTMLFormElement2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLFormElement2
DECLARE_INTERFACE_( IHTMLFormElement2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLFormElement2 methods */
    STDMETHOD( put_acceptCharset )( THIS_ BSTR ) PURE;
    STDMETHOD( get_acceptCharset )( THIS_ BSTR * ) PURE;
    STDMETHOD( urns )( THIS_ VARIANT, IDispatch ** ) PURE;
};

/* IHTMLFormElement3 interface */
#undef INTERFACE
#define INTERFACE   IHTMLFormElement3
DECLARE_INTERFACE_( IHTMLFormElement3, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLFormElement3 methods */
    STDMETHOD( namedItem )( THIS_ BSTR, IDispatch ** ) PURE;
};

/* IHTMLSubmitData interface */
#undef INTERFACE
#define INTERFACE   IHTMLSubmitData
DECLARE_INTERFACE_( IHTMLSubmitData, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLSubmitData methods */
    STDMETHOD( appendNameValuePair )( THIS_ BSTR, BSTR ) PURE;
    STDMETHOD( appendNameFilePair )( THIS_ BSTR, BSTR ) PURE;
    STDMETHOD( appendItemSeparator )( THIS ) PURE;
};

/* IHTMLFormElement4 interface */
#undef INTERFACE
#define INTERFACE   IHTMLFormElement4
DECLARE_INTERFACE_( IHTMLFormElement4, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLFormElement4 methods */
    STDMETHOD( put_action )( THIS_ BSTR ) PURE;
    STDMETHOD( get_action )( THIS_ BSTR * ) PURE;
};

/* DispHTMLFormElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLFormElement
DECLARE_INTERFACE_( DispHTMLFormElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLControlElementEvents2 interface */
#undef INTERFACE
#define INTERFACE   HTMLControlElementEvents2
DECLARE_INTERFACE_( HTMLControlElementEvents2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLControlElementEvents interface */
#undef INTERFACE
#define INTERFACE   HTMLControlElementEvents
DECLARE_INTERFACE_( HTMLControlElementEvents, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLControlElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLControlElement
DECLARE_INTERFACE_( IHTMLControlElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLControlElement methods */
    STDMETHOD( put_tabIndex )( THIS_ short ) PURE;
    STDMETHOD( get_tabIndex )( THIS_ short * ) PURE;
    STDMETHOD( focus )( THIS ) PURE;
    STDMETHOD( put_accessKey )( THIS_ BSTR ) PURE;
    STDMETHOD( get_accessKey )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_onblur )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onblur )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onfocus )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onfocus )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onresize )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onresize )( THIS_ VARIANT * ) PURE;
    STDMETHOD( blur )( THIS ) PURE;
    STDMETHOD( addFilter )( THIS_ IUnknown * ) PURE;
    STDMETHOD( removeFilter )( THIS_ IUnknown * ) PURE;
    STDMETHOD( get_clientHeight )( THIS_ long * ) PURE;
    STDMETHOD( get_clientWidth )( THIS_ long * ) PURE;
    STDMETHOD( get_clientTop )( THIS_ long * ) PURE;
    STDMETHOD( get_clientLeft )( THIS_ long * ) PURE;
};

/* IHTMLTextElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLTextElement
DECLARE_INTERFACE_( IHTMLTextElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispHTMLTextElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLTextElement
DECLARE_INTERFACE_( DispHTMLTextElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLTextContainerEvents2 interface */
#undef INTERFACE
#define INTERFACE   HTMLTextContainerEvents2
DECLARE_INTERFACE_( HTMLTextContainerEvents2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLTextContainerEvents interface */
#undef INTERFACE
#define INTERFACE   HTMLTextContainerEvents
DECLARE_INTERFACE_( HTMLTextContainerEvents, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLTextContainer interface */
#undef INTERFACE
#define INTERFACE   IHTMLTextContainer
DECLARE_INTERFACE_( IHTMLTextContainer, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLTextContainer methods */
    STDMETHOD( createControlRange )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_scrollHeight )( THIS_ long * ) PURE;
    STDMETHOD( get_scrollWidth )( THIS_ long * ) PURE;
    STDMETHOD( put_scrollTop )( THIS_ long ) PURE;
    STDMETHOD( get_scrollTop )( THIS_ long * ) PURE;
    STDMETHOD( put_scrollLeft )( THIS_ long ) PURE;
    STDMETHOD( get_scrollLeft )( THIS_ long * ) PURE;
    STDMETHOD( put_onscroll )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onscroll )( THIS_ VARIANT * ) PURE;
};

/* IHTMLControlRange interface */
#undef INTERFACE
#define INTERFACE   IHTMLControlRange
DECLARE_INTERFACE_( IHTMLControlRange, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLControlRange methods */
    STDMETHOD( select )( THIS ) PURE;
    STDMETHOD( add )( THIS_ IHTMLControlElement * ) PURE;
    STDMETHOD( remove )( THIS_ long ) PURE;
    STDMETHOD( item )( THIS_ long, IHTMLElement ** ) PURE;
    STDMETHOD( scrollIntoView )( THIS_ VARIANT ) PURE;
    STDMETHOD( queryCommandSupported )( THIS_ BSTR, VARIANT_BOOL * ) PURE;
    STDMETHOD( queryCommandEnabled )( THIS_ BSTR, VARIANT_BOOL * ) PURE;
    STDMETHOD( queryCommandState )( THIS_ BSTR, VARIANT_BOOL * ) PURE;
    STDMETHOD( queryCommandIndeterm )( THIS_ BSTR, VARIANT_BOOL * ) PURE;
    STDMETHOD( queryCommandText )( THIS_ BSTR, BSTR * ) PURE;
    STDMETHOD( queryCommandValue )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( execCommand )( THIS_ BSTR, VARIANT_BOOL, VARIANT, VARIANT_BOOL * ) PURE;
    STDMETHOD( execCommandShowHelp )( THIS_ BSTR, VARIANT_BOOL * ) PURE;
    STDMETHOD( commonParentElement )( THIS_ IHTMLElement ** ) PURE;
    STDMETHOD( get_length )( THIS_ long * ) PURE;
};

/* IHTMLControlRange2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLControlRange2
DECLARE_INTERFACE_( IHTMLControlRange2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLControlRange2 methods */
    STDMETHOD( addElement )( THIS_ IHTMLElement * ) PURE;
};

/* HTMLImgEvents2 interface */
#undef INTERFACE
#define INTERFACE   HTMLImgEvents2
DECLARE_INTERFACE_( HTMLImgEvents2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLImgEvents interface */
#undef INTERFACE
#define INTERFACE   HTMLImgEvents
DECLARE_INTERFACE_( HTMLImgEvents, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLImgElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLImgElement
DECLARE_INTERFACE_( IHTMLImgElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLImgElement methods */
    STDMETHOD( put_isMap )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_isMap )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_useMap )( THIS_ BSTR ) PURE;
    STDMETHOD( get_useMap )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_mimeType )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_fileSize )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_fileCreatedDate )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_fileModifiedDate )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_fileUpdatedDate )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_protocol )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_href )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_nameProp )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_border )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_border )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_vspace )( THIS_ long ) PURE;
    STDMETHOD( get_vspace )( THIS_ long * ) PURE;
    STDMETHOD( put_hspace )( THIS_ long ) PURE;
    STDMETHOD( get_hspace )( THIS_ long * ) PURE;
    STDMETHOD( put_alt )( THIS_ BSTR ) PURE;
    STDMETHOD( get_alt )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_src )( THIS_ BSTR ) PURE;
    STDMETHOD( get_src )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_lowsrc )( THIS_ BSTR ) PURE;
    STDMETHOD( get_lowsrc )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_vrml )( THIS_ BSTR ) PURE;
    STDMETHOD( get_vrml )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_dynsrc )( THIS_ BSTR ) PURE;
    STDMETHOD( get_dynsrc )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_readyState )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_complete )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_loop )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_loop )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_align )( THIS_ BSTR ) PURE;
    STDMETHOD( get_align )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_onload )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onload )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onerror )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onerror )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onabort )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onabort )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_name )( THIS_ BSTR ) PURE;
    STDMETHOD( get_name )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_width )( THIS_ long ) PURE;
    STDMETHOD( get_width )( THIS_ long * ) PURE;
    STDMETHOD( put_height )( THIS_ long ) PURE;
    STDMETHOD( get_height )( THIS_ long * ) PURE;
    STDMETHOD( put_start )( THIS_ long ) PURE;
    STDMETHOD( get_start )( THIS_ long * ) PURE;
};

/* IHTMLImgElement2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLImgElement2
DECLARE_INTERFACE_( IHTMLImgElement2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLImgElement2 methods */
    STDMETHOD( put_longDesc )( THIS_ BSTR ) PURE;
    STDMETHOD( get_longDesc )( THIS_ BSTR * ) PURE;
};

/* IHTMLImgElement3 interface */
#undef INTERFACE
#define INTERFACE   IHTMLImgElement3
DECLARE_INTERFACE_( IHTMLImgElement3, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLImgElement3 methods */
    STDMETHOD( put_longDesc )( THIS_ BSTR ) PURE;
    STDMETHOD( get_longDesc )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_vrml )( THIS_ BSTR ) PURE;
    STDMETHOD( get_vrml )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_lowsrc )( THIS_ BSTR ) PURE;
    STDMETHOD( get_lowsrc )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_dynsrc )( THIS_ BSTR ) PURE;
    STDMETHOD( get_dynsrc )( THIS_ BSTR * ) PURE;
};

/* IHTMLImageElementFactory interface */
#undef INTERFACE
#define INTERFACE   IHTMLImageElementFactory
DECLARE_INTERFACE_( IHTMLImageElementFactory, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLImageElementFactory methods */
    STDMETHOD( create )( THIS_ VARIANT, VARIANT, IHTMLImgElement ** ) PURE;
};

/* DispHTMLImg interface */
#undef INTERFACE
#define INTERFACE   DispHTMLImg
DECLARE_INTERFACE_( DispHTMLImg, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLXMLHttpRequestEvents interface */
#undef INTERFACE
#define INTERFACE   HTMLXMLHttpRequestEvents
DECLARE_INTERFACE_( HTMLXMLHttpRequestEvents, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLXMLHttpRequest interface */
#undef INTERFACE
#define INTERFACE   IHTMLXMLHttpRequest
DECLARE_INTERFACE_( IHTMLXMLHttpRequest, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLXMLHttpRequest methods */
    STDMETHOD( get_readyState )( THIS_ long * ) PURE;
    STDMETHOD( get_responseBody )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_responseText )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_responseXML )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_status )( THIS_ long * ) PURE;
    STDMETHOD( get_statusText )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_onreadystatechange )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onreadystatechange )( THIS_ VARIANT * ) PURE;
    STDMETHOD( abort )( THIS ) PURE;
    STDMETHOD( open )( THIS_ BSTR, BSTR, VARIANT, VARIANT, VARIANT ) PURE;
    STDMETHOD( send )( THIS_ VARIANT ) PURE;
    STDMETHOD( getAllResponseHeaders )( THIS_ BSTR * ) PURE;
    STDMETHOD( getResponseHeader )( THIS_ BSTR, BSTR * ) PURE;
    STDMETHOD( setRequestHeader )( THIS_ BSTR, BSTR ) PURE;
};

/* IHTMLXMLHttpRequest2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLXMLHttpRequest2
DECLARE_INTERFACE_( IHTMLXMLHttpRequest2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLXMLHttpRequest2 methods */
    STDMETHOD( put_timeout )( THIS_ long ) PURE;
    STDMETHOD( get_timeout )( THIS_ long * ) PURE;
    STDMETHOD( put_ontimeout )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_ontimeout )( THIS_ VARIANT * ) PURE;
};

/* IHTMLXMLHttpRequestFactory interface */
#undef INTERFACE
#define INTERFACE   IHTMLXMLHttpRequestFactory
DECLARE_INTERFACE_( IHTMLXMLHttpRequestFactory, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLXMLHttpRequestFactory methods */
    STDMETHOD( create )( THIS_ IHTMLXMLHttpRequest ** ) PURE;
};

/* DispHTMLXMLHttpRequest interface */
#undef INTERFACE
#define INTERFACE   DispHTMLXMLHttpRequest
DECLARE_INTERFACE_( DispHTMLXMLHttpRequest, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLBodyElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLBodyElement
DECLARE_INTERFACE_( IHTMLBodyElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLBodyElement methods */
    STDMETHOD( put_background )( THIS_ BSTR ) PURE;
    STDMETHOD( get_background )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_bgProperties )( THIS_ BSTR ) PURE;
    STDMETHOD( get_bgProperties )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_leftMargin )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_leftMargin )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_topMargin )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_topMargin )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_rightMargin )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_rightMargin )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_bottomMargin )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_bottomMargin )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_noWrap )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_noWrap )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_bgColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_bgColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_text )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_text )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_link )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_link )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_vLink )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_vLink )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_aLink )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_aLink )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onload )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onload )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onunload )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onunload )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_scroll )( THIS_ BSTR ) PURE;
    STDMETHOD( get_scroll )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_onselect )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onselect )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onbeforeunload )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onbeforeunload )( THIS_ VARIANT * ) PURE;
    STDMETHOD( createTextRange )( THIS_ IHTMLTxtRange ** ) PURE;
};

/* IHTMLBodyElement2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLBodyElement2
DECLARE_INTERFACE_( IHTMLBodyElement2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLBodyElement2 methods */
    STDMETHOD( put_onbeforeprint )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onbeforeprint )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onafterprint )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onafterprint )( THIS_ VARIANT * ) PURE;
};

/* IHTMLBodyElement3 interface */
#undef INTERFACE
#define INTERFACE   IHTMLBodyElement3
DECLARE_INTERFACE_( IHTMLBodyElement3, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLBodyElement3 methods */
    STDMETHOD( put_background )( THIS_ BSTR ) PURE;
    STDMETHOD( get_background )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_ononline )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_ononline )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onoffline )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onoffline )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onhashchange )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onhashchange )( THIS_ VARIANT * ) PURE;
};

/* DispHTMLBody interface */
#undef INTERFACE
#define INTERFACE   DispHTMLBody
DECLARE_INTERFACE_( DispHTMLBody, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLFontElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLFontElement
DECLARE_INTERFACE_( IHTMLFontElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLFontElement methods */
    STDMETHOD( put_color )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_color )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_face )( THIS_ BSTR ) PURE;
    STDMETHOD( get_face )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_size )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_size )( THIS_ VARIANT * ) PURE;
};

/* DispHTMLFontElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLFontElement
DECLARE_INTERFACE_( DispHTMLFontElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLAnchorEvents2 interface */
#undef INTERFACE
#define INTERFACE   HTMLAnchorEvents2
DECLARE_INTERFACE_( HTMLAnchorEvents2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLAnchorEvents interface */
#undef INTERFACE
#define INTERFACE   HTMLAnchorEvents
DECLARE_INTERFACE_( HTMLAnchorEvents, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLAnchorElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLAnchorElement
DECLARE_INTERFACE_( IHTMLAnchorElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLAnchorElement methods */
    STDMETHOD( put_href )( THIS_ BSTR ) PURE;
    STDMETHOD( get_href )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_target )( THIS_ BSTR ) PURE;
    STDMETHOD( get_target )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_rel )( THIS_ BSTR ) PURE;
    STDMETHOD( get_rel )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_rev )( THIS_ BSTR ) PURE;
    STDMETHOD( get_rev )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_urn )( THIS_ BSTR ) PURE;
    STDMETHOD( get_urn )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Methods )( THIS_ BSTR ) PURE;
    STDMETHOD( get_Methods )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_name )( THIS_ BSTR ) PURE;
    STDMETHOD( get_name )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_host )( THIS_ BSTR ) PURE;
    STDMETHOD( get_host )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_hostname )( THIS_ BSTR ) PURE;
    STDMETHOD( get_hostname )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_pathname )( THIS_ BSTR ) PURE;
    STDMETHOD( get_pathname )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_port )( THIS_ BSTR ) PURE;
    STDMETHOD( get_port )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_protocol )( THIS_ BSTR ) PURE;
    STDMETHOD( get_protocol )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_search )( THIS_ BSTR ) PURE;
    STDMETHOD( get_search )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_hash )( THIS_ BSTR ) PURE;
    STDMETHOD( get_hash )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_onblur )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onblur )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onfocus )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onfocus )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_accessKey )( THIS_ BSTR ) PURE;
    STDMETHOD( get_accessKey )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_protocolLong )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_mimeType )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_nameProp )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_tabIndex )( THIS_ short ) PURE;
    STDMETHOD( get_tabIndex )( THIS_ short * ) PURE;
    STDMETHOD( focus )( THIS ) PURE;
    STDMETHOD( blur )( THIS ) PURE;
};

/* IHTMLAnchorElement2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLAnchorElement2
DECLARE_INTERFACE_( IHTMLAnchorElement2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLAnchorElement2 methods */
    STDMETHOD( put_charset )( THIS_ BSTR ) PURE;
    STDMETHOD( get_charset )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_coords )( THIS_ BSTR ) PURE;
    STDMETHOD( get_coords )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_hreflang )( THIS_ BSTR ) PURE;
    STDMETHOD( get_hreflang )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_shape )( THIS_ BSTR ) PURE;
    STDMETHOD( get_shape )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_type )( THIS_ BSTR ) PURE;
    STDMETHOD( get_type )( THIS_ BSTR * ) PURE;
};

/* IHTMLAnchorElement3 interface */
#undef INTERFACE
#define INTERFACE   IHTMLAnchorElement3
DECLARE_INTERFACE_( IHTMLAnchorElement3, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLAnchorElement3 methods */
    STDMETHOD( put_shape )( THIS_ BSTR ) PURE;
    STDMETHOD( get_shape )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_coords )( THIS_ BSTR ) PURE;
    STDMETHOD( get_coords )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_href )( THIS_ BSTR ) PURE;
    STDMETHOD( get_href )( THIS_ BSTR * ) PURE;
};

/* DispHTMLAnchorElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLAnchorElement
DECLARE_INTERFACE_( DispHTMLAnchorElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLLabelEvents2 interface */
#undef INTERFACE
#define INTERFACE   HTMLLabelEvents2
DECLARE_INTERFACE_( HTMLLabelEvents2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLLabelEvents interface */
#undef INTERFACE
#define INTERFACE   HTMLLabelEvents
DECLARE_INTERFACE_( HTMLLabelEvents, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLLabelElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLLabelElement
DECLARE_INTERFACE_( IHTMLLabelElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLLabelElement methods */
    STDMETHOD( put_htmlFor )( THIS_ BSTR ) PURE;
    STDMETHOD( get_htmlFor )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_accessKey )( THIS_ BSTR ) PURE;
    STDMETHOD( get_accessKey )( THIS_ BSTR * ) PURE;
};

/* IHTMLLabelElement2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLLabelElement2
DECLARE_INTERFACE_( IHTMLLabelElement2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLLabelElement2 methods */
    STDMETHOD( get_form )( THIS_ IHTMLFormElement ** ) PURE;
};

/* DispHTMLLabelElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLLabelElement
DECLARE_INTERFACE_( DispHTMLLabelElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLListElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLListElement
DECLARE_INTERFACE_( IHTMLListElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLListElement2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLListElement2
DECLARE_INTERFACE_( IHTMLListElement2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLListElement2 methods */
    STDMETHOD( put_compact )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_compact )( THIS_ VARIANT_BOOL * ) PURE;
};

/* DispHTMLListElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLListElement
DECLARE_INTERFACE_( DispHTMLListElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLUListElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLUListElement
DECLARE_INTERFACE_( IHTMLUListElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLUListElement methods */
    STDMETHOD( put_compact )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_compact )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_type )( THIS_ BSTR ) PURE;
    STDMETHOD( get_type )( THIS_ BSTR * ) PURE;
};

/* DispHTMLUListElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLUListElement
DECLARE_INTERFACE_( DispHTMLUListElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLOListElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLOListElement
DECLARE_INTERFACE_( IHTMLOListElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLOListElement methods */
    STDMETHOD( put_compact )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_compact )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_start )( THIS_ long ) PURE;
    STDMETHOD( get_start )( THIS_ long * ) PURE;
    STDMETHOD( put_type )( THIS_ BSTR ) PURE;
    STDMETHOD( get_type )( THIS_ BSTR * ) PURE;
};

/* DispHTMLOListElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLOListElement
DECLARE_INTERFACE_( DispHTMLOListElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLLIElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLLIElement
DECLARE_INTERFACE_( IHTMLLIElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLLIElement methods */
    STDMETHOD( put_type )( THIS_ BSTR ) PURE;
    STDMETHOD( get_type )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_value )( THIS_ long ) PURE;
    STDMETHOD( get_value )( THIS_ long * ) PURE;
};

/* DispHTMLLIElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLLIElement
DECLARE_INTERFACE_( DispHTMLLIElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLBlockElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLBlockElement
DECLARE_INTERFACE_( IHTMLBlockElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLBlockElement methods */
    STDMETHOD( put_clear )( THIS_ BSTR ) PURE;
    STDMETHOD( get_clear )( THIS_ BSTR * ) PURE;
};

/* IHTMLBlockElement2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLBlockElement2
DECLARE_INTERFACE_( IHTMLBlockElement2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLBlockElement2 methods */
    STDMETHOD( put_cite )( THIS_ BSTR ) PURE;
    STDMETHOD( get_cite )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_width )( THIS_ BSTR ) PURE;
    STDMETHOD( get_width )( THIS_ BSTR * ) PURE;
};

/* IHTMLBlockElement3 interface */
#undef INTERFACE
#define INTERFACE   IHTMLBlockElement3
DECLARE_INTERFACE_( IHTMLBlockElement3, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLBlockElement3 methods */
    STDMETHOD( put_cite )( THIS_ BSTR ) PURE;
    STDMETHOD( get_cite )( THIS_ BSTR * ) PURE;
};

/* DispHTMLBlockElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLBlockElement
DECLARE_INTERFACE_( DispHTMLBlockElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLDivElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLDivElement
DECLARE_INTERFACE_( IHTMLDivElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLDivElement methods */
    STDMETHOD( put_align )( THIS_ BSTR ) PURE;
    STDMETHOD( get_align )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_noWrap )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_noWrap )( THIS_ VARIANT_BOOL * ) PURE;
};

/* DispHTMLDivElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLDivElement
DECLARE_INTERFACE_( DispHTMLDivElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLDDElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLDDElement
DECLARE_INTERFACE_( IHTMLDDElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLDDElement methods */
    STDMETHOD( put_noWrap )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_noWrap )( THIS_ VARIANT_BOOL * ) PURE;
};

/* DispHTMLDDElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLDDElement
DECLARE_INTERFACE_( DispHTMLDDElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLDTElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLDTElement
DECLARE_INTERFACE_( IHTMLDTElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLDTElement methods */
    STDMETHOD( put_noWrap )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_noWrap )( THIS_ VARIANT_BOOL * ) PURE;
};

/* DispHTMLDTElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLDTElement
DECLARE_INTERFACE_( DispHTMLDTElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLBRElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLBRElement
DECLARE_INTERFACE_( IHTMLBRElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLBRElement methods */
    STDMETHOD( put_clear )( THIS_ BSTR ) PURE;
    STDMETHOD( get_clear )( THIS_ BSTR * ) PURE;
};

/* DispHTMLBRElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLBRElement
DECLARE_INTERFACE_( DispHTMLBRElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLDListElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLDListElement
DECLARE_INTERFACE_( IHTMLDListElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLDListElement methods */
    STDMETHOD( put_compact )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_compact )( THIS_ VARIANT_BOOL * ) PURE;
};

/* DispHTMLDListElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLDListElement
DECLARE_INTERFACE_( DispHTMLDListElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLHRElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLHRElement
DECLARE_INTERFACE_( IHTMLHRElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLHRElement methods */
    STDMETHOD( put_align )( THIS_ BSTR ) PURE;
    STDMETHOD( get_align )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_color )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_color )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_noShade )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_noShade )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_width )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_width )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_size )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_size )( THIS_ VARIANT * ) PURE;
};

/* DispHTMLHRElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLHRElement
DECLARE_INTERFACE_( DispHTMLHRElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLParaElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLParaElement
DECLARE_INTERFACE_( IHTMLParaElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLParaElement methods */
    STDMETHOD( put_align )( THIS_ BSTR ) PURE;
    STDMETHOD( get_align )( THIS_ BSTR * ) PURE;
};

/* DispHTMLParaElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLParaElement
DECLARE_INTERFACE_( DispHTMLParaElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLElementCollection interface */
#undef INTERFACE
#define INTERFACE   IHTMLElementCollection
DECLARE_INTERFACE_( IHTMLElementCollection, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLElementCollection methods */
    STDMETHOD( toString )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_length )( THIS_ long ) PURE;
    STDMETHOD( get_length )( THIS_ long * ) PURE;
    STDMETHOD( get__newEnum )( THIS_ IUnknown ** ) PURE;
    STDMETHOD( item )( THIS_ VARIANT, VARIANT, IDispatch ** ) PURE;
    STDMETHOD( tags )( THIS_ VARIANT, IDispatch ** ) PURE;
};

/* IHTMLElementCollection2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLElementCollection2
DECLARE_INTERFACE_( IHTMLElementCollection2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLElementCollection2 methods */
    STDMETHOD( urns )( THIS_ VARIANT, IDispatch ** ) PURE;
};

/* IHTMLElementCollection3 interface */
#undef INTERFACE
#define INTERFACE   IHTMLElementCollection3
DECLARE_INTERFACE_( IHTMLElementCollection3, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLElementCollection3 methods */
    STDMETHOD( namedItem )( THIS_ BSTR, IDispatch ** ) PURE;
};

/* IHTMLElementCollection4 interface */
#undef INTERFACE
#define INTERFACE   IHTMLElementCollection4
DECLARE_INTERFACE_( IHTMLElementCollection4, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLElementCollection4 methods */
    STDMETHOD( get_length )( THIS_ long * ) PURE;
    STDMETHOD( item )( THIS_ long, IHTMLElement2 ** ) PURE;
    STDMETHOD( namedItem )( THIS_ BSTR, IHTMLElement2 ** ) PURE;
};

/* DispHTMLElementCollection interface */
#undef INTERFACE
#define INTERFACE   DispHTMLElementCollection
DECLARE_INTERFACE_( DispHTMLElementCollection, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLHeaderElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLHeaderElement
DECLARE_INTERFACE_( IHTMLHeaderElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLHeaderElement methods */
    STDMETHOD( put_align )( THIS_ BSTR ) PURE;
    STDMETHOD( get_align )( THIS_ BSTR * ) PURE;
};

/* DispHTMLHeaderElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLHeaderElement
DECLARE_INTERFACE_( DispHTMLHeaderElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLSelectElementEvents2 interface */
#undef INTERFACE
#define INTERFACE   HTMLSelectElementEvents2
DECLARE_INTERFACE_( HTMLSelectElementEvents2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLSelectElementEvents interface */
#undef INTERFACE
#define INTERFACE   HTMLSelectElementEvents
DECLARE_INTERFACE_( HTMLSelectElementEvents, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLSelectElementEx interface */
#undef INTERFACE
#define INTERFACE   IHTMLSelectElementEx
DECLARE_INTERFACE_( IHTMLSelectElementEx, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IHTMLSelectElementEx methods */
    STDMETHOD( ShowDropDown )( THIS_ BOOL ) PURE;
    STDMETHOD( SetSelectExFlags )( THIS_ DWORD ) PURE;
    STDMETHOD( GetSelectExFlags )( THIS_ DWORD * ) PURE;
    STDMETHOD( GetDropdownOpen )( THIS_ BOOL * ) PURE;
};

/* IHTMLSelectElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLSelectElement
DECLARE_INTERFACE_( IHTMLSelectElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLSelectElement methods */
    STDMETHOD( put_size )( THIS_ long ) PURE;
    STDMETHOD( get_size )( THIS_ long * ) PURE;
    STDMETHOD( put_multiple )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_multiple )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_name )( THIS_ BSTR ) PURE;
    STDMETHOD( get_name )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_options )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( put_onchange )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onchange )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_selectedIndex )( THIS_ long ) PURE;
    STDMETHOD( get_selectedIndex )( THIS_ long * ) PURE;
    STDMETHOD( get_type )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_value )( THIS_ BSTR ) PURE;
    STDMETHOD( get_value )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_disabled )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_disabled )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_form )( THIS_ IHTMLFormElement ** ) PURE;
    STDMETHOD( add )( THIS_ IHTMLElement *, VARIANT ) PURE;
    STDMETHOD( remove )( THIS_ long ) PURE;
    STDMETHOD( put_length )( THIS_ long ) PURE;
    STDMETHOD( get_length )( THIS_ long * ) PURE;
    STDMETHOD( get__newEnum )( THIS_ IUnknown ** ) PURE;
    STDMETHOD( item )( THIS_ VARIANT, VARIANT, IDispatch ** ) PURE;
    STDMETHOD( tags )( THIS_ VARIANT, IDispatch ** ) PURE;
};

/* IHTMLSelectElement2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLSelectElement2
DECLARE_INTERFACE_( IHTMLSelectElement2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLSelectElement2 methods */
    STDMETHOD( urns )( THIS_ VARIANT, IDispatch ** ) PURE;
};

/* IHTMLSelectElement4 interface */
#undef INTERFACE
#define INTERFACE   IHTMLSelectElement4
DECLARE_INTERFACE_( IHTMLSelectElement4, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLSelectElement4 methods */
    STDMETHOD( namedItem )( THIS_ BSTR, IDispatch ** ) PURE;
};

/* IHTMLSelectElement5 interface */
#undef INTERFACE
#define INTERFACE   IHTMLSelectElement5
DECLARE_INTERFACE_( IHTMLSelectElement5, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLSelectElement5 methods */
    STDMETHOD( add )( THIS_ IHTMLOptionElement *, VARIANT * ) PURE;
};

/* DispHTMLSelectElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLSelectElement
DECLARE_INTERFACE_( DispHTMLSelectElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispHTMLWndSelectElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLWndSelectElement
DECLARE_INTERFACE_( DispHTMLWndSelectElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLSelectionObject interface */
#undef INTERFACE
#define INTERFACE   IHTMLSelectionObject
DECLARE_INTERFACE_( IHTMLSelectionObject, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLSelectionObject methods */
    STDMETHOD( createRange )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( empty )( THIS ) PURE;
    STDMETHOD( clear )( THIS ) PURE;
    STDMETHOD( get_type )( THIS_ BSTR * ) PURE;
};

/* IHTMLSelectionObject2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLSelectionObject2
DECLARE_INTERFACE_( IHTMLSelectionObject2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLSelectionObject2 methods */
    STDMETHOD( createRangeCollection )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_typeDetail )( THIS_ BSTR * ) PURE;
};

/* IHTMLOptionElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLOptionElement
DECLARE_INTERFACE_( IHTMLOptionElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLOptionElement methods */
    STDMETHOD( put_selected )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_selected )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_value )( THIS_ BSTR ) PURE;
    STDMETHOD( get_value )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_defaultSelected )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_defaultSelected )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_index )( THIS_ LONG ) PURE;
    STDMETHOD( get_index )( THIS_ LONG * ) PURE;
    STDMETHOD( put_text )( THIS_ BSTR ) PURE;
    STDMETHOD( get_text )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_form )( THIS_ IHTMLFormElement ** ) PURE;
};

/* IHTMLOptionElement3 interface */
#undef INTERFACE
#define INTERFACE   IHTMLOptionElement3
DECLARE_INTERFACE_( IHTMLOptionElement3, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLOptionElement3 methods */
    STDMETHOD( put_label )( THIS_ BSTR ) PURE;
    STDMETHOD( get_label )( THIS_ BSTR * ) PURE;
};

/* IHTMLOptionElementFactory interface */
#undef INTERFACE
#define INTERFACE   IHTMLOptionElementFactory
DECLARE_INTERFACE_( IHTMLOptionElementFactory, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLOptionElementFactory methods */
    STDMETHOD( create )( THIS_ VARIANT, VARIANT, VARIANT, VARIANT, IHTMLOptionElement ** ) PURE;
};

/* DispHTMLOptionElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLOptionElement
DECLARE_INTERFACE_( DispHTMLOptionElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispHTMLWndOptionElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLWndOptionElement
DECLARE_INTERFACE_( DispHTMLWndOptionElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLButtonElementEvents2 interface */
#undef INTERFACE
#define INTERFACE   HTMLButtonElementEvents2
DECLARE_INTERFACE_( HTMLButtonElementEvents2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLButtonElementEvents interface */
#undef INTERFACE
#define INTERFACE   HTMLButtonElementEvents
DECLARE_INTERFACE_( HTMLButtonElementEvents, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLInputTextElementEvents2 interface */
#undef INTERFACE
#define INTERFACE   HTMLInputTextElementEvents2
DECLARE_INTERFACE_( HTMLInputTextElementEvents2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLOptionButtonElementEvents2 interface */
#undef INTERFACE
#define INTERFACE   HTMLOptionButtonElementEvents2
DECLARE_INTERFACE_( HTMLOptionButtonElementEvents2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLInputFileElementEvents2 interface */
#undef INTERFACE
#define INTERFACE   HTMLInputFileElementEvents2
DECLARE_INTERFACE_( HTMLInputFileElementEvents2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLInputImageEvents2 interface */
#undef INTERFACE
#define INTERFACE   HTMLInputImageEvents2
DECLARE_INTERFACE_( HTMLInputImageEvents2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLInputTextElementEvents interface */
#undef INTERFACE
#define INTERFACE   HTMLInputTextElementEvents
DECLARE_INTERFACE_( HTMLInputTextElementEvents, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLOptionButtonElementEvents interface */
#undef INTERFACE
#define INTERFACE   HTMLOptionButtonElementEvents
DECLARE_INTERFACE_( HTMLOptionButtonElementEvents, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLInputFileElementEvents interface */
#undef INTERFACE
#define INTERFACE   HTMLInputFileElementEvents
DECLARE_INTERFACE_( HTMLInputFileElementEvents, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLInputImageEvents interface */
#undef INTERFACE
#define INTERFACE   HTMLInputImageEvents
DECLARE_INTERFACE_( HTMLInputImageEvents, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLInputElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLInputElement
DECLARE_INTERFACE_( IHTMLInputElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLInputElement methods */
    STDMETHOD( put_type )( THIS_ BSTR ) PURE;
    STDMETHOD( get_type )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_value )( THIS_ BSTR ) PURE;
    STDMETHOD( get_value )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_name )( THIS_ BSTR ) PURE;
    STDMETHOD( get_name )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_status )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_status )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_disabled )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_disabled )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_form )( THIS_ IHTMLFormElement ** ) PURE;
    STDMETHOD( put_size )( THIS_ long ) PURE;
    STDMETHOD( get_size )( THIS_ long * ) PURE;
    STDMETHOD( put_maxLength )( THIS_ long ) PURE;
    STDMETHOD( get_maxLength )( THIS_ long * ) PURE;
    STDMETHOD( select )( THIS ) PURE;
    STDMETHOD( put_onchange )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onchange )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onselect )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onselect )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_defaultValue )( THIS_ BSTR ) PURE;
    STDMETHOD( get_defaultValue )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_readOnly )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_readOnly )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( createTextRange )( THIS_ IHTMLTxtRange ** ) PURE;
    STDMETHOD( put_indeterminate )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_indeterminate )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_defaultChecked )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_defaultChecked )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_checked )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_checked )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_border )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_border )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_vspace )( THIS_ long ) PURE;
    STDMETHOD( get_vspace )( THIS_ long * ) PURE;
    STDMETHOD( put_hspace )( THIS_ long ) PURE;
    STDMETHOD( get_hspace )( THIS_ long * ) PURE;
    STDMETHOD( put_alt )( THIS_ BSTR ) PURE;
    STDMETHOD( get_alt )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_src )( THIS_ BSTR ) PURE;
    STDMETHOD( get_src )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_lowsrc )( THIS_ BSTR ) PURE;
    STDMETHOD( get_lowsrc )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_vrml )( THIS_ BSTR ) PURE;
    STDMETHOD( get_vrml )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_dynsrc )( THIS_ BSTR ) PURE;
    STDMETHOD( get_dynsrc )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_readyState )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_complete )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_loop )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_loop )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_align )( THIS_ BSTR ) PURE;
    STDMETHOD( get_align )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_onload )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onload )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onerror )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onerror )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onabort )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onabort )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_width )( THIS_ long ) PURE;
    STDMETHOD( get_width )( THIS_ long * ) PURE;
    STDMETHOD( put_height )( THIS_ long ) PURE;
    STDMETHOD( get_height )( THIS_ long * ) PURE;
    STDMETHOD( put_start )( THIS_ BSTR ) PURE;
    STDMETHOD( get_start )( THIS_ BSTR * ) PURE;
};

/* IHTMLInputElement2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLInputElement2
DECLARE_INTERFACE_( IHTMLInputElement2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLInputElement2 methods */
    STDMETHOD( put_accept )( THIS_ BSTR ) PURE;
    STDMETHOD( get_accept )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_useMap )( THIS_ BSTR ) PURE;
    STDMETHOD( get_useMap )( THIS_ BSTR * ) PURE;
};

/* IHTMLInputElement3 interface */
#undef INTERFACE
#define INTERFACE   IHTMLInputElement3
DECLARE_INTERFACE_( IHTMLInputElement3, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLInputElement3 methods */
    STDMETHOD( put_src )( THIS_ BSTR ) PURE;
    STDMETHOD( get_src )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_lowsrc )( THIS_ BSTR ) PURE;
    STDMETHOD( get_lowsrc )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_vrml )( THIS_ BSTR ) PURE;
    STDMETHOD( get_vrml )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_dynsrc )( THIS_ BSTR ) PURE;
    STDMETHOD( get_dynsrc )( THIS_ BSTR * ) PURE;
};

/* IHTMLInputButtonElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLInputButtonElement
DECLARE_INTERFACE_( IHTMLInputButtonElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLInputButtonElement methods */
    STDMETHOD( get_type )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_value )( THIS_ BSTR ) PURE;
    STDMETHOD( get_value )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_name )( THIS_ BSTR ) PURE;
    STDMETHOD( get_name )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_status )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_status )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_disabled )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_disabled )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_form )( THIS_ IHTMLFormElement ** ) PURE;
    STDMETHOD( createTextRange )( THIS_ IHTMLTxtRange ** ) PURE;
};

/* IHTMLInputHiddenElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLInputHiddenElement
DECLARE_INTERFACE_( IHTMLInputHiddenElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLInputHiddenElement methods */
    STDMETHOD( get_type )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_value )( THIS_ BSTR ) PURE;
    STDMETHOD( get_value )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_name )( THIS_ BSTR ) PURE;
    STDMETHOD( get_name )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_status )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_status )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_disabled )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_disabled )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_form )( THIS_ IHTMLFormElement ** ) PURE;
    STDMETHOD( createTextRange )( THIS_ IHTMLTxtRange ** ) PURE;
};

/* IHTMLInputTextElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLInputTextElement
DECLARE_INTERFACE_( IHTMLInputTextElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLInputTextElement methods */
    STDMETHOD( get_type )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_value )( THIS_ BSTR ) PURE;
    STDMETHOD( get_value )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_name )( THIS_ BSTR ) PURE;
    STDMETHOD( get_name )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_status )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_status )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_disabled )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_disabled )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_form )( THIS_ IHTMLFormElement ** ) PURE;
    STDMETHOD( put_defaultValue )( THIS_ BSTR ) PURE;
    STDMETHOD( get_defaultValue )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_size )( THIS_ long ) PURE;
    STDMETHOD( get_size )( THIS_ long * ) PURE;
    STDMETHOD( put_maxLength )( THIS_ long ) PURE;
    STDMETHOD( get_maxLength )( THIS_ long * ) PURE;
    STDMETHOD( select )( THIS ) PURE;
    STDMETHOD( put_onchange )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onchange )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onselect )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onselect )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_readOnly )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_readOnly )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( createTextRange )( THIS_ IHTMLTxtRange ** ) PURE;
};

/* IHTMLInputFileElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLInputFileElement
DECLARE_INTERFACE_( IHTMLInputFileElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLInputFileElement methods */
    STDMETHOD( get_type )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_name )( THIS_ BSTR ) PURE;
    STDMETHOD( get_name )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_status )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_status )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_disabled )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_disabled )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_form )( THIS_ IHTMLFormElement ** ) PURE;
    STDMETHOD( put_size )( THIS_ long ) PURE;
    STDMETHOD( get_size )( THIS_ long * ) PURE;
    STDMETHOD( put_maxLength )( THIS_ long ) PURE;
    STDMETHOD( get_maxLength )( THIS_ long * ) PURE;
    STDMETHOD( select )( THIS ) PURE;
    STDMETHOD( put_onchange )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onchange )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onselect )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onselect )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_value )( THIS_ BSTR ) PURE;
    STDMETHOD( get_value )( THIS_ BSTR * ) PURE;
};

/* IHTMLOptionButtonElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLOptionButtonElement
DECLARE_INTERFACE_( IHTMLOptionButtonElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLOptionButtonElement methods */
    STDMETHOD( put_value )( THIS_ BSTR ) PURE;
    STDMETHOD( get_value )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_type )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_name )( THIS_ BSTR ) PURE;
    STDMETHOD( get_name )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_checked )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_checked )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_defaultChecked )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_defaultChecked )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_onchange )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onchange )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_disabled )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_disabled )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_status )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_status )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_indeterminate )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_indeterminate )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_form )( THIS_ IHTMLFormElement ** ) PURE;
};

/* IHTMLInputImage interface */
#undef INTERFACE
#define INTERFACE   IHTMLInputImage
DECLARE_INTERFACE_( IHTMLInputImage, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLInputImage methods */
    STDMETHOD( get_type )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_disabled )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_disabled )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_border )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_border )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_vspace )( THIS_ long ) PURE;
    STDMETHOD( get_vspace )( THIS_ long * ) PURE;
    STDMETHOD( put_hspace )( THIS_ long ) PURE;
    STDMETHOD( get_hspace )( THIS_ long * ) PURE;
    STDMETHOD( put_alt )( THIS_ BSTR ) PURE;
    STDMETHOD( get_alt )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_src )( THIS_ BSTR ) PURE;
    STDMETHOD( get_src )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_lowsrc )( THIS_ BSTR ) PURE;
    STDMETHOD( get_lowsrc )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_vrml )( THIS_ BSTR ) PURE;
    STDMETHOD( get_vrml )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_dynsrc )( THIS_ BSTR ) PURE;
    STDMETHOD( get_dynsrc )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_readyState )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_complete )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_loop )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_loop )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_align )( THIS_ BSTR ) PURE;
    STDMETHOD( get_align )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_onload )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onload )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onerror )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onerror )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onabort )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onabort )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_name )( THIS_ BSTR ) PURE;
    STDMETHOD( get_name )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_width )( THIS_ long ) PURE;
    STDMETHOD( get_width )( THIS_ long * ) PURE;
    STDMETHOD( put_height )( THIS_ long ) PURE;
    STDMETHOD( get_height )( THIS_ long * ) PURE;
    STDMETHOD( put_start )( THIS_ BSTR ) PURE;
    STDMETHOD( get_start )( THIS_ BSTR * ) PURE;
};

/* DispHTMLInputElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLInputElement
DECLARE_INTERFACE_( DispHTMLInputElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLTextAreaElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLTextAreaElement
DECLARE_INTERFACE_( IHTMLTextAreaElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLTextAreaElement methods */
    STDMETHOD( get_type )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_value )( THIS_ BSTR ) PURE;
    STDMETHOD( get_value )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_name )( THIS_ BSTR ) PURE;
    STDMETHOD( get_name )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_status )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_status )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_disabled )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_disabled )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_form )( THIS_ IHTMLFormElement ** ) PURE;
    STDMETHOD( put_defaultValue )( THIS_ BSTR ) PURE;
    STDMETHOD( get_defaultValue )( THIS_ BSTR * ) PURE;
    STDMETHOD( select )( THIS ) PURE;
    STDMETHOD( put_onchange )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onchange )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onselect )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onselect )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_readOnly )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_readOnly )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_rows )( THIS_ long ) PURE;
    STDMETHOD( get_rows )( THIS_ long * ) PURE;
    STDMETHOD( put_cols )( THIS_ long ) PURE;
    STDMETHOD( get_cols )( THIS_ long * ) PURE;
    STDMETHOD( put_wrap )( THIS_ BSTR ) PURE;
    STDMETHOD( get_wrap )( THIS_ BSTR * ) PURE;
    STDMETHOD( createTextRange )( THIS_ IHTMLTxtRange ** ) PURE;
};

/* DispHTMLTextAreaElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLTextAreaElement
DECLARE_INTERFACE_( DispHTMLTextAreaElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispHTMLRichtextElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLRichtextElement
DECLARE_INTERFACE_( DispHTMLRichtextElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLButtonElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLButtonElement
DECLARE_INTERFACE_( IHTMLButtonElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLButtonElement methods */
    STDMETHOD( get_type )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_value )( THIS_ BSTR ) PURE;
    STDMETHOD( get_value )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_name )( THIS_ BSTR ) PURE;
    STDMETHOD( get_name )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_status )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_status )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_disabled )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_disabled )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_form )( THIS_ IHTMLFormElement ** ) PURE;
    STDMETHOD( createTextRange )( THIS_ IHTMLTxtRange ** ) PURE;
};

/* DispHTMLButtonElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLButtonElement
DECLARE_INTERFACE_( DispHTMLButtonElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLMarqueeElementEvents2 interface */
#undef INTERFACE
#define INTERFACE   HTMLMarqueeElementEvents2
DECLARE_INTERFACE_( HTMLMarqueeElementEvents2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLMarqueeElementEvents interface */
#undef INTERFACE
#define INTERFACE   HTMLMarqueeElementEvents
DECLARE_INTERFACE_( HTMLMarqueeElementEvents, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLMarqueeElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLMarqueeElement
DECLARE_INTERFACE_( IHTMLMarqueeElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLMarqueeElement methods */
    STDMETHOD( put_bgColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_bgColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_scrollDelay )( THIS_ long ) PURE;
    STDMETHOD( get_scrollDelay )( THIS_ long * ) PURE;
    STDMETHOD( put_direction )( THIS_ BSTR ) PURE;
    STDMETHOD( get_direction )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_behavior )( THIS_ BSTR ) PURE;
    STDMETHOD( get_behavior )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_scrollAmount )( THIS_ long ) PURE;
    STDMETHOD( get_scrollAmount )( THIS_ long * ) PURE;
    STDMETHOD( put_loop )( THIS_ long ) PURE;
    STDMETHOD( get_loop )( THIS_ long * ) PURE;
    STDMETHOD( put_vspace )( THIS_ long ) PURE;
    STDMETHOD( get_vspace )( THIS_ long * ) PURE;
    STDMETHOD( put_hspace )( THIS_ long ) PURE;
    STDMETHOD( get_hspace )( THIS_ long * ) PURE;
    STDMETHOD( put_onfinish )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onfinish )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onstart )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onstart )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onbounce )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onbounce )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_width )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_width )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_height )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_height )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_trueSpeed )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_trueSpeed )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( start )( THIS ) PURE;
    STDMETHOD( stop )( THIS ) PURE;
};

/* DispHTMLMarqueeElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLMarqueeElement
DECLARE_INTERFACE_( DispHTMLMarqueeElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLHtmlElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLHtmlElement
DECLARE_INTERFACE_( IHTMLHtmlElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLHtmlElement methods */
    STDMETHOD( put_version )( THIS_ BSTR ) PURE;
    STDMETHOD( get_version )( THIS_ BSTR * ) PURE;
};

/* IHTMLHeadElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLHeadElement
DECLARE_INTERFACE_( IHTMLHeadElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLHeadElement methods */
    STDMETHOD( put_profile )( THIS_ BSTR ) PURE;
    STDMETHOD( get_profile )( THIS_ BSTR * ) PURE;
};

/* IHTMLHeadElement2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLHeadElement2
DECLARE_INTERFACE_( IHTMLHeadElement2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLHeadElement2 methods */
    STDMETHOD( put_profile )( THIS_ BSTR ) PURE;
    STDMETHOD( get_profile )( THIS_ BSTR * ) PURE;
};

/* IHTMLTitleElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLTitleElement
DECLARE_INTERFACE_( IHTMLTitleElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLTitleElement methods */
    STDMETHOD( put_text )( THIS_ BSTR ) PURE;
    STDMETHOD( get_text )( THIS_ BSTR * ) PURE;
};

/* IHTMLMetaElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLMetaElement
DECLARE_INTERFACE_( IHTMLMetaElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLMetaElement methods */
    STDMETHOD( put_httpEquiv )( THIS_ BSTR ) PURE;
    STDMETHOD( get_httpEquiv )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_content )( THIS_ BSTR ) PURE;
    STDMETHOD( get_content )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_name )( THIS_ BSTR ) PURE;
    STDMETHOD( get_name )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_url )( THIS_ BSTR ) PURE;
    STDMETHOD( get_url )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_charset )( THIS_ BSTR ) PURE;
    STDMETHOD( get_charset )( THIS_ BSTR * ) PURE;
};

/* IHTMLMetaElement2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLMetaElement2
DECLARE_INTERFACE_( IHTMLMetaElement2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLMetaElement2 methods */
    STDMETHOD( put_scheme )( THIS_ BSTR ) PURE;
    STDMETHOD( get_scheme )( THIS_ BSTR * ) PURE;
};

/* IHTMLMetaElement3 interface */
#undef INTERFACE
#define INTERFACE   IHTMLMetaElement3
DECLARE_INTERFACE_( IHTMLMetaElement3, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLMetaElement3 methods */
    STDMETHOD( put_url )( THIS_ BSTR ) PURE;
    STDMETHOD( get_url )( THIS_ BSTR * ) PURE;
};

/* IHTMLBaseElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLBaseElement
DECLARE_INTERFACE_( IHTMLBaseElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLBaseElement methods */
    STDMETHOD( put_href )( THIS_ BSTR ) PURE;
    STDMETHOD( get_href )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_target )( THIS_ BSTR ) PURE;
    STDMETHOD( get_target )( THIS_ BSTR * ) PURE;
};

/* IHTMLBaseElement2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLBaseElement2
DECLARE_INTERFACE_( IHTMLBaseElement2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLBaseElement2 methods */
    STDMETHOD( put_href )( THIS_ BSTR ) PURE;
    STDMETHOD( get_href )( THIS_ BSTR * ) PURE;
};

/* IHTMLIsIndexElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLIsIndexElement
DECLARE_INTERFACE_( IHTMLIsIndexElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLIsIndexElement methods */
    STDMETHOD( put_prompt )( THIS_ BSTR ) PURE;
    STDMETHOD( get_prompt )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_action )( THIS_ BSTR ) PURE;
    STDMETHOD( get_action )( THIS_ BSTR * ) PURE;
};

/* IHTMLIsIndexElement2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLIsIndexElement2
DECLARE_INTERFACE_( IHTMLIsIndexElement2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLIsIndexElement2 methods */
    STDMETHOD( get_form )( THIS_ IHTMLFormElement ** ) PURE;
};

/* IHTMLNextIdElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLNextIdElement
DECLARE_INTERFACE_( IHTMLNextIdElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLNextIdElement methods */
    STDMETHOD( put_n )( THIS_ BSTR ) PURE;
    STDMETHOD( get_n )( THIS_ BSTR * ) PURE;
};

/* DispHTMLHtmlElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLHtmlElement
DECLARE_INTERFACE_( DispHTMLHtmlElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispHTMLHeadElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLHeadElement
DECLARE_INTERFACE_( DispHTMLHeadElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispHTMLTitleElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLTitleElement
DECLARE_INTERFACE_( DispHTMLTitleElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispHTMLMetaElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLMetaElement
DECLARE_INTERFACE_( DispHTMLMetaElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispHTMLBaseElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLBaseElement
DECLARE_INTERFACE_( DispHTMLBaseElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispHTMLIsIndexElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLIsIndexElement
DECLARE_INTERFACE_( DispHTMLIsIndexElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispHTMLNextIdElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLNextIdElement
DECLARE_INTERFACE_( DispHTMLNextIdElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLBaseFontElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLBaseFontElement
DECLARE_INTERFACE_( IHTMLBaseFontElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLBaseFontElement methods */
    STDMETHOD( put_color )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_color )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_face )( THIS_ BSTR ) PURE;
    STDMETHOD( get_face )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_size )( THIS_ long ) PURE;
    STDMETHOD( get_size )( THIS_ long * ) PURE;
};

/* DispHTMLBaseFontElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLBaseFontElement
DECLARE_INTERFACE_( DispHTMLBaseFontElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLUnknownElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLUnknownElement
DECLARE_INTERFACE_( IHTMLUnknownElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispHTMLUnknownElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLUnknownElement
DECLARE_INTERFACE_( DispHTMLUnknownElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IOmHistory interface */
#undef INTERFACE
#define INTERFACE   IOmHistory
DECLARE_INTERFACE_( IOmHistory, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IOmHistory methods */
    STDMETHOD( get_length )( THIS_ short * ) PURE;
    STDMETHOD( back )( THIS_ VARIANT * ) PURE;
    STDMETHOD( forward )( THIS_ VARIANT * ) PURE;
    STDMETHOD( go )( THIS_ VARIANT * ) PURE;
};

/* IHTMLMimeTypesCollection interface */
#undef INTERFACE
#define INTERFACE   IHTMLMimeTypesCollection
DECLARE_INTERFACE_( IHTMLMimeTypesCollection, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLMimeTypesCollection methods */
    STDMETHOD( get_length )( THIS_ long * ) PURE;
};

/* IHTMLPluginsCollection interface */
#undef INTERFACE
#define INTERFACE   IHTMLPluginsCollection
DECLARE_INTERFACE_( IHTMLPluginsCollection, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLPluginsCollection methods */
    STDMETHOD( get_length )( THIS_ long * ) PURE;
    STDMETHOD( refresh )( THIS_ VARIANT_BOOL ) PURE;
};

/* IHTMLOpsProfile interface */
#undef INTERFACE
#define INTERFACE   IHTMLOpsProfile
DECLARE_INTERFACE_( IHTMLOpsProfile, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLOpsProfile methods */
    STDMETHOD( addRequest )( THIS_ BSTR, VARIANT, VARIANT_BOOL * ) PURE;
    STDMETHOD( clearRequest )( THIS ) PURE;
    STDMETHOD( doRequest )( THIS_ VARIANT, VARIANT, VARIANT, VARIANT, VARIANT, VARIANT ) PURE;
    STDMETHOD( getAttribute )( THIS_ BSTR, BSTR * ) PURE;
    STDMETHOD( setAttribute )( THIS_ BSTR, BSTR, VARIANT, VARIANT_BOOL * ) PURE;
    STDMETHOD( commitChanges )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( addReadRequest )( THIS_ BSTR, VARIANT, VARIANT_BOOL * ) PURE;
    STDMETHOD( doReadRequest )( THIS_ VARIANT, VARIANT, VARIANT, VARIANT, VARIANT, VARIANT ) PURE;
    STDMETHOD( doWriteRequest )( THIS_ VARIANT_BOOL * ) PURE;
};

/* IOmNavigator interface */
#undef INTERFACE
#define INTERFACE   IOmNavigator
DECLARE_INTERFACE_( IOmNavigator, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IOmNavigator methods */
    STDMETHOD( get_appCodeName )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_appName )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_appVersion )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_userAgent )( THIS_ BSTR * ) PURE;
    STDMETHOD( javaEnabled )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( taintEnabled )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_mimeTypes )( THIS_ IHTMLMimeTypesCollection ** ) PURE;
    STDMETHOD( get_plugins )( THIS_ IHTMLPluginsCollection ** ) PURE;
    STDMETHOD( get_cookieEnabled )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_opsProfile )( THIS_ IHTMLOpsProfile ** ) PURE;
    STDMETHOD( toString )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_cpuClass )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_systemLanguage )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_browserLanguage )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_userLanguage )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_platform )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_appMinorVersion )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_connectionSpeed )( THIS_ long * ) PURE;
    STDMETHOD( get_onLine )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_userProfile )( THIS_ IHTMLOpsProfile ** ) PURE;
};

/* IHTMLLocation interface */
#undef INTERFACE
#define INTERFACE   IHTMLLocation
DECLARE_INTERFACE_( IHTMLLocation, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLLocation methods */
    STDMETHOD( put_href )( THIS_ BSTR ) PURE;
    STDMETHOD( get_href )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_protocol )( THIS_ BSTR ) PURE;
    STDMETHOD( get_protocol )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_host )( THIS_ BSTR ) PURE;
    STDMETHOD( get_host )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_hostname )( THIS_ BSTR ) PURE;
    STDMETHOD( get_hostname )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_port )( THIS_ BSTR ) PURE;
    STDMETHOD( get_port )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_pathname )( THIS_ BSTR ) PURE;
    STDMETHOD( get_pathname )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_search )( THIS_ BSTR ) PURE;
    STDMETHOD( get_search )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_hash )( THIS_ BSTR ) PURE;
    STDMETHOD( get_hash )( THIS_ BSTR * ) PURE;
    STDMETHOD( reload )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( replace )( THIS_ BSTR ) PURE;
    STDMETHOD( assign )( THIS_ BSTR ) PURE;
    STDMETHOD( toString )( THIS_ BSTR * ) PURE;
};

/* DispHTMLHistory interface */
#undef INTERFACE
#define INTERFACE   DispHTMLHistory
DECLARE_INTERFACE_( DispHTMLHistory, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispCPlugins interface */
#undef INTERFACE
#define INTERFACE   DispCPlugins
DECLARE_INTERFACE_( DispCPlugins, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispHTMLNavigator interface */
#undef INTERFACE
#define INTERFACE   DispHTMLNavigator
DECLARE_INTERFACE_( DispHTMLNavigator, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispHTMLLocation interface */
#undef INTERFACE
#define INTERFACE   DispHTMLLocation
DECLARE_INTERFACE_( DispHTMLLocation, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLBookmarkCollection interface */
#undef INTERFACE
#define INTERFACE   IHTMLBookmarkCollection
DECLARE_INTERFACE_( IHTMLBookmarkCollection, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLBookmarkCollection methods */
    STDMETHOD( get_length )( THIS_ long * ) PURE;
    STDMETHOD( get__newEnum )( THIS_ IUnknown ** ) PURE;
    STDMETHOD( item )( THIS_ long, VARIANT * ) PURE;
};

/* IHTMLDataTransfer interface */
#undef INTERFACE
#define INTERFACE   IHTMLDataTransfer
DECLARE_INTERFACE_( IHTMLDataTransfer, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLDataTransfer methods */
    STDMETHOD( setData )( THIS_ BSTR, VARIANT *, VARIANT_BOOL * ) PURE;
    STDMETHOD( getData )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( clearData )( THIS_ BSTR, VARIANT_BOOL * ) PURE;
    STDMETHOD( put_dropEffect )( THIS_ BSTR ) PURE;
    STDMETHOD( get_dropEffect )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_effectAllowed )( THIS_ BSTR ) PURE;
    STDMETHOD( get_effectAllowed )( THIS_ BSTR * ) PURE;
};

/* IHTMLEventObj interface */
#undef INTERFACE
#define INTERFACE   IHTMLEventObj
DECLARE_INTERFACE_( IHTMLEventObj, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLEventObj methods */
    STDMETHOD( get_srcElement )( THIS_ IHTMLElement ** ) PURE;
    STDMETHOD( get_altKey )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_ctrlKey )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_shiftKey )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_returnValue )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_returnValue )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_cancelBubble )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_cancelBubble )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_fromElement )( THIS_ IHTMLElement ** ) PURE;
    STDMETHOD( get_toElement )( THIS_ IHTMLElement ** ) PURE;
    STDMETHOD( put_keyCode )( THIS_ long ) PURE;
    STDMETHOD( get_keyCode )( THIS_ long * ) PURE;
    STDMETHOD( get_button )( THIS_ long * ) PURE;
    STDMETHOD( get_type )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_qualifier )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_reason )( THIS_ long * ) PURE;
    STDMETHOD( get_x )( THIS_ long * ) PURE;
    STDMETHOD( get_y )( THIS_ long * ) PURE;
    STDMETHOD( get_clientX )( THIS_ long * ) PURE;
    STDMETHOD( get_clientY )( THIS_ long * ) PURE;
    STDMETHOD( get_offsetX )( THIS_ long * ) PURE;
    STDMETHOD( get_offsetY )( THIS_ long * ) PURE;
    STDMETHOD( get_screenX )( THIS_ long * ) PURE;
    STDMETHOD( get_screenY )( THIS_ long * ) PURE;
    STDMETHOD( get_srcFilter )( THIS_ IDispatch ** ) PURE;
};

/* IHTMLEventObj2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLEventObj2
DECLARE_INTERFACE_( IHTMLEventObj2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLEventObj2 methods */
    STDMETHOD( setAttribute )( THIS_ BSTR, VARIANT, LONG ) PURE;
    STDMETHOD( getAttribute )( THIS_ BSTR, LONG, VARIANT * ) PURE;
    STDMETHOD( removeAttribute )( THIS_ BSTR, LONG, VARIANT_BOOL * ) PURE;
    STDMETHOD( put_propertyName )( THIS_ BSTR ) PURE;
    STDMETHOD( get_propertyName )( THIS_ BSTR * ) PURE;
    STDMETHOD( putref_bookmarks )( THIS_ IHTMLBookmarkCollection * ) PURE;
    STDMETHOD( get_bookmarks )( THIS_ IHTMLBookmarkCollection ** ) PURE;
    STDMETHOD( putref_recordset )( THIS_ IDispatch * ) PURE;
    STDMETHOD( get_recordset )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( put_dataFld )( THIS_ BSTR ) PURE;
    STDMETHOD( get_dataFld )( THIS_ BSTR * ) PURE;
    STDMETHOD( putref_boundElements )( THIS_ IHTMLElementCollection * ) PURE;
    STDMETHOD( get_boundElements )( THIS_ IHTMLElementCollection ** ) PURE;
    STDMETHOD( put_repeat )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_repeat )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_srcUrn )( THIS_ BSTR ) PURE;
    STDMETHOD( get_srcUrn )( THIS_ BSTR * ) PURE;
    STDMETHOD( putref_srcElement )( THIS_ IHTMLElement * ) PURE;
    STDMETHOD( get_srcElement )( THIS_ IHTMLElement ** ) PURE;
    STDMETHOD( put_altKey )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_altKey )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_ctrlKey )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_ctrlKey )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_shiftKey )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_shiftKey )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( putref_fromElement )( THIS_ IHTMLElement * ) PURE;
    STDMETHOD( get_fromElement )( THIS_ IHTMLElement ** ) PURE;
    STDMETHOD( putref_toElement )( THIS_ IHTMLElement * ) PURE;
    STDMETHOD( get_toElement )( THIS_ IHTMLElement ** ) PURE;
    STDMETHOD( put_button )( THIS_ long ) PURE;
    STDMETHOD( get_button )( THIS_ long * ) PURE;
    STDMETHOD( put_type )( THIS_ BSTR ) PURE;
    STDMETHOD( get_type )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_qualifier )( THIS_ BSTR ) PURE;
    STDMETHOD( get_qualifier )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_reason )( THIS_ long ) PURE;
    STDMETHOD( get_reason )( THIS_ long * ) PURE;
    STDMETHOD( put_x )( THIS_ long ) PURE;
    STDMETHOD( get_x )( THIS_ long * ) PURE;
    STDMETHOD( put_y )( THIS_ long ) PURE;
    STDMETHOD( get_y )( THIS_ long * ) PURE;
    STDMETHOD( put_clientX )( THIS_ long ) PURE;
    STDMETHOD( get_clientX )( THIS_ long * ) PURE;
    STDMETHOD( put_clientY )( THIS_ long ) PURE;
    STDMETHOD( get_clientY )( THIS_ long * ) PURE;
    STDMETHOD( put_offsetX )( THIS_ long ) PURE;
    STDMETHOD( get_offsetX )( THIS_ long * ) PURE;
    STDMETHOD( put_offsetY )( THIS_ long ) PURE;
    STDMETHOD( get_offsetY )( THIS_ long * ) PURE;
    STDMETHOD( put_screenX )( THIS_ long ) PURE;
    STDMETHOD( get_screenX )( THIS_ long * ) PURE;
    STDMETHOD( put_screenY )( THIS_ long ) PURE;
    STDMETHOD( get_screenY )( THIS_ long * ) PURE;
    STDMETHOD( putref_srcFilter )( THIS_ IDispatch * ) PURE;
    STDMETHOD( get_srcFilter )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_dataTransfer )( THIS_ IHTMLDataTransfer ** ) PURE;
};

/* IHTMLEventObj3 interface */
#undef INTERFACE
#define INTERFACE   IHTMLEventObj3
DECLARE_INTERFACE_( IHTMLEventObj3, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLEventObj3 methods */
    STDMETHOD( get_contentOverflow )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_shiftLeft )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_shiftLeft )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_altLeft )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_altLeft )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_ctrlLeft )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_ctrlLeft )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_imeCompositionChange )( THIS_ LONG_PTR * ) PURE;
    STDMETHOD( get_imeNotifyCommand )( THIS_ LONG_PTR * ) PURE;
    STDMETHOD( get_imeNotifyData )( THIS_ LONG_PTR * ) PURE;
    STDMETHOD( get_imeRequest )( THIS_ LONG_PTR * ) PURE;
    STDMETHOD( get_imeRequestData )( THIS_ LONG_PTR * ) PURE;
    STDMETHOD( get_keyboardLayout )( THIS_ LONG_PTR * ) PURE;
    STDMETHOD( get_behaviorCookie )( THIS_ long * ) PURE;
    STDMETHOD( get_behaviorPart )( THIS_ long * ) PURE;
    STDMETHOD( get_nextPage )( THIS_ BSTR * ) PURE;
};

/* IHTMLEventObj4 interface */
#undef INTERFACE
#define INTERFACE   IHTMLEventObj4
DECLARE_INTERFACE_( IHTMLEventObj4, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLEventObj4 methods */
    STDMETHOD( get_wheelDelta )( THIS_ long * ) PURE;
};

/* IHTMLEventObj5 interface */
#undef INTERFACE
#define INTERFACE   IHTMLEventObj5
DECLARE_INTERFACE_( IHTMLEventObj5, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLEventObj5 methods */
    STDMETHOD( put_url )( THIS_ BSTR ) PURE;
    STDMETHOD( get_url )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_data )( THIS_ BSTR ) PURE;
    STDMETHOD( get_data )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_source )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( put_origin )( THIS_ BSTR ) PURE;
    STDMETHOD( get_origin )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_issession )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_issession )( THIS_ VARIANT_BOOL * ) PURE;
};

/* DispCEventObj interface */
#undef INTERFACE
#define INTERFACE   DispCEventObj
DECLARE_INTERFACE_( DispCEventObj, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLWindowEvents3 interface */
#undef INTERFACE
#define INTERFACE   HTMLWindowEvents3
DECLARE_INTERFACE_( HTMLWindowEvents3, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLWindowEvents2 interface */
#undef INTERFACE
#define INTERFACE   HTMLWindowEvents2
DECLARE_INTERFACE_( HTMLWindowEvents2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLWindowEvents interface */
#undef INTERFACE
#define INTERFACE   HTMLWindowEvents
DECLARE_INTERFACE_( HTMLWindowEvents, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLFramesCollection2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLFramesCollection2
DECLARE_INTERFACE_( IHTMLFramesCollection2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLFramesCollection2 methods */
    STDMETHOD( item )( THIS_ VARIANT *, VARIANT * ) PURE;
    STDMETHOD( get_length )( THIS_ long * ) PURE;
};

/* IHTMLScreen interface */
#undef INTERFACE
#define INTERFACE   IHTMLScreen
DECLARE_INTERFACE_( IHTMLScreen, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLScreen methods */
    STDMETHOD( get_colorDepth )( THIS_ long * ) PURE;
    STDMETHOD( put_bufferDepth )( THIS_ long ) PURE;
    STDMETHOD( get_bufferDepth )( THIS_ long * ) PURE;
    STDMETHOD( get_width )( THIS_ long * ) PURE;
    STDMETHOD( get_height )( THIS_ long * ) PURE;
    STDMETHOD( put_updateInterval )( THIS_ long ) PURE;
    STDMETHOD( get_updateInterval )( THIS_ long * ) PURE;
    STDMETHOD( get_availHeight )( THIS_ long * ) PURE;
    STDMETHOD( get_availWidth )( THIS_ long * ) PURE;
    STDMETHOD( get_fontSmoothingEnabled )( THIS_ VARIANT_BOOL * ) PURE;
};

/* IHTMLScreen2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLScreen2
DECLARE_INTERFACE_( IHTMLScreen2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLScreen2 methods */
    STDMETHOD( get_logicalXDPI )( THIS_ long * ) PURE;
    STDMETHOD( get_logicalYDPI )( THIS_ long * ) PURE;
    STDMETHOD( get_deviceXDPI )( THIS_ long * ) PURE;
    STDMETHOD( get_deviceYDPI )( THIS_ long * ) PURE;
};

/* IHTMLScreen3 interface */
#undef INTERFACE
#define INTERFACE   IHTMLScreen3
DECLARE_INTERFACE_( IHTMLScreen3, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLScreen3 methods */
    STDMETHOD( get_systemXDPI )( THIS_ long * ) PURE;
    STDMETHOD( get_systemYDPI )( THIS_ long * ) PURE;
};

/* IHTMLWindow2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLWindow2
DECLARE_INTERFACE_( IHTMLWindow2, IHTMLFramesCollection2 ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLFramesCollection2 methods */
    STDMETHOD( item )( THIS_ VARIANT *, VARIANT * ) PURE;
    STDMETHOD( get_length )( THIS_ long * ) PURE;

    /* IHTMLWindow2 methods */
    STDMETHOD( get_frames )( THIS_ IHTMLFramesCollection2 ** ) PURE;
    STDMETHOD( put_defaultStatus )( THIS_ BSTR ) PURE;
    STDMETHOD( get_defaultStatus )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_status )( THIS_ BSTR ) PURE;
    STDMETHOD( get_status )( THIS_ BSTR * ) PURE;
    STDMETHOD( setTimeout )( THIS_ BSTR, long, VARIANT *, long * ) PURE;
    STDMETHOD( clearTimeout )( THIS_ long ) PURE;
    STDMETHOD( alert )( THIS_ BSTR ) PURE;
    STDMETHOD( confirm )( THIS_ BSTR, VARIANT_BOOL * ) PURE;
    STDMETHOD( prompt )( THIS_ BSTR, BSTR, VARIANT * ) PURE;
    STDMETHOD( get_Image )( THIS_ IHTMLImageElementFactory ** ) PURE;
    STDMETHOD( get_location )( THIS_ IHTMLLocation ** ) PURE;
    STDMETHOD( get_history )( THIS_ IOmHistory ** ) PURE;
    STDMETHOD( close )( THIS ) PURE;
    STDMETHOD( put_opener )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_opener )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_navigator )( THIS_ IOmNavigator ** ) PURE;
    STDMETHOD( put_name )( THIS_ BSTR ) PURE;
    STDMETHOD( get_name )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_parent )( THIS_ IHTMLWindow2 ** ) PURE;
    STDMETHOD( open )( THIS_ BSTR, BSTR, BSTR, VARIANT_BOOL, IHTMLWindow2 ** ) PURE;
    STDMETHOD( get_self )( THIS_ IHTMLWindow2 ** ) PURE;
    STDMETHOD( get_top )( THIS_ IHTMLWindow2 ** ) PURE;
    STDMETHOD( get_window )( THIS_ IHTMLWindow2 ** ) PURE;
    STDMETHOD( navigate )( THIS_ BSTR ) PURE;
    STDMETHOD( put_onfocus )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onfocus )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onblur )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onblur )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onload )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onload )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onbeforeunload )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onbeforeunload )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onunload )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onunload )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onhelp )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onhelp )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onerror )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onerror )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onresize )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onresize )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onscroll )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onscroll )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_document )( THIS_ IHTMLDocument2 ** ) PURE;
    STDMETHOD( get_event )( THIS_ IHTMLEventObj ** ) PURE;
    STDMETHOD( get__newEnum )( THIS_ IUnknown ** ) PURE;
    STDMETHOD( showModalDialog )( THIS_ BSTR, VARIANT *, VARIANT *, VARIANT * ) PURE;
    STDMETHOD( showHelp )( THIS_ BSTR, VARIANT, BSTR ) PURE;
    STDMETHOD( get_screen )( THIS_ IHTMLScreen ** ) PURE;
    STDMETHOD( get_Option )( THIS_ IHTMLOptionElementFactory ** ) PURE;
    STDMETHOD( focus )( THIS ) PURE;
    STDMETHOD( get_closed )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( blur )( THIS ) PURE;
    STDMETHOD( scroll )( THIS_ long, long ) PURE;
    STDMETHOD( get_clientInformation )( THIS_ IOmNavigator ** ) PURE;
    STDMETHOD( setInterval )( THIS_ BSTR, long, VARIANT *, long * ) PURE;
    STDMETHOD( clearInterval )( THIS_ long ) PURE;
    STDMETHOD( put_offscreenBuffering )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_offscreenBuffering )( THIS_ VARIANT * ) PURE;
    STDMETHOD( execScript )( THIS_ BSTR, BSTR, VARIANT * ) PURE;
    STDMETHOD( toString )( THIS_ BSTR * ) PURE;
    STDMETHOD( scrollBy )( THIS_ long, long ) PURE;
    STDMETHOD( scrollTo )( THIS_ long, long ) PURE;
    STDMETHOD( moveTo )( THIS_ long, long ) PURE;
    STDMETHOD( moveBy )( THIS_ long, long ) PURE;
    STDMETHOD( resizeTo )( THIS_ long, long ) PURE;
    STDMETHOD( resizeBy )( THIS_ long, long ) PURE;
    STDMETHOD( get_external )( THIS_ IDispatch ** ) PURE;
};

/* IHTMLWindow3 interface */
#undef INTERFACE
#define INTERFACE   IHTMLWindow3
DECLARE_INTERFACE_( IHTMLWindow3, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLWindow3 methods */
    STDMETHOD( get_screenLeft )( THIS_ long * ) PURE;
    STDMETHOD( get_screenTop )( THIS_ long * ) PURE;
    STDMETHOD( attachEvent )( THIS_ BSTR, IDispatch *, VARIANT_BOOL * ) PURE;
    STDMETHOD( detachEvent )( THIS_ BSTR, IDispatch * ) PURE;
    STDMETHOD( setTimeout )( THIS_ VARIANT *, long, VARIANT *, long * ) PURE;
    STDMETHOD( setInterval )( THIS_ VARIANT *, long, VARIANT *, long * ) PURE;
    STDMETHOD( print )( THIS ) PURE;
    STDMETHOD( put_onbeforeprint )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onbeforeprint )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onafterprint )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onafterprint )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_clipboardData )( THIS_ IHTMLDataTransfer ** ) PURE;
    STDMETHOD( showModelessDialog )( THIS_ BSTR, VARIANT *, VARIANT *, IHTMLWindow2 ** ) PURE;
};

/* IHTMLWindow4 interface */
#undef INTERFACE
#define INTERFACE   IHTMLWindow4
DECLARE_INTERFACE_( IHTMLWindow4, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLWindow4 methods */
    STDMETHOD( createPopup )( THIS_ VARIANT *, IDispatch ** ) PURE;
    STDMETHOD( get_frameElement )( THIS_ IHTMLFrameBase ** ) PURE;
};

/* IHTMLWindow5 interface */
#undef INTERFACE
#define INTERFACE   IHTMLWindow5
DECLARE_INTERFACE_( IHTMLWindow5, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLWindow5 methods */
    STDMETHOD( put_XMLHttpRequest )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_XMLHttpRequest )( THIS_ VARIANT * ) PURE;
};

/* IHTMLWindow6 interface */
#undef INTERFACE
#define INTERFACE   IHTMLWindow6
DECLARE_INTERFACE_( IHTMLWindow6, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLWindow6 methods */
    STDMETHOD( put_XDomainRequest )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_XDomainRequest )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_sessionStorage )( THIS_ IHTMLStorage ** ) PURE;
    STDMETHOD( get_localStorage )( THIS_ IHTMLStorage ** ) PURE;
    STDMETHOD( put_onhashchange )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onhashchange )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_maxConnectionsPerServer )( THIS_ long * ) PURE;
    STDMETHOD( postMessage )( THIS_ BSTR, VARIANT ) PURE;
    STDMETHOD( toStaticHTML )( THIS_ BSTR, BSTR * ) PURE;
    STDMETHOD( put_onmessage )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onmessage )( THIS_ VARIANT * ) PURE;
    STDMETHOD( msWriteProfilerMark )( THIS_ BSTR ) PURE;
};

/* DispHTMLScreen interface */
#undef INTERFACE
#define INTERFACE   DispHTMLScreen
DECLARE_INTERFACE_( DispHTMLScreen, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispHTMLWindow2 interface */
#undef INTERFACE
#define INTERFACE   DispHTMLWindow2
DECLARE_INTERFACE_( DispHTMLWindow2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispHTMLWindowProxy interface */
#undef INTERFACE
#define INTERFACE   DispHTMLWindowProxy
DECLARE_INTERFACE_( DispHTMLWindowProxy, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLDocumentCompatibleInfo interface */
#undef INTERFACE
#define INTERFACE   IHTMLDocumentCompatibleInfo
DECLARE_INTERFACE_( IHTMLDocumentCompatibleInfo, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLDocumentCompatibleInfo methods */
    STDMETHOD( get_userAgent )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_version )( THIS_ BSTR * ) PURE;
};

/* IHTMLDocumentCompatibleInfoCollection interface */
#undef INTERFACE
#define INTERFACE   IHTMLDocumentCompatibleInfoCollection
DECLARE_INTERFACE_( IHTMLDocumentCompatibleInfoCollection, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLDocumentCompatibleInfoCollection methods */
    STDMETHOD( get_length )( THIS_ long * ) PURE;
    STDMETHOD( item )( THIS_ long, IHTMLDocumentCompatibleInfo ** ) PURE;
};

/* DispHTMLDocumentCompatibleInfo interface */
#undef INTERFACE
#define INTERFACE   DispHTMLDocumentCompatibleInfo
DECLARE_INTERFACE_( DispHTMLDocumentCompatibleInfo, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispHTMLDocumentCompatibleInfoCollection interface */
#undef INTERFACE
#define INTERFACE   DispHTMLDocumentCompatibleInfoCollection
DECLARE_INTERFACE_( DispHTMLDocumentCompatibleInfoCollection, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLDocumentEvents3 interface */
#undef INTERFACE
#define INTERFACE   HTMLDocumentEvents3
DECLARE_INTERFACE_( HTMLDocumentEvents3, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLDocumentEvents2 interface */
#undef INTERFACE
#define INTERFACE   HTMLDocumentEvents2
DECLARE_INTERFACE_( HTMLDocumentEvents2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLDocumentEvents interface */
#undef INTERFACE
#define INTERFACE   HTMLDocumentEvents
DECLARE_INTERFACE_( HTMLDocumentEvents, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLDocument interface */
#undef INTERFACE
#define INTERFACE   IHTMLDocument
DECLARE_INTERFACE_( IHTMLDocument, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLDocument methods */
    STDMETHOD( get_Script )( THIS_ IDispatch ** ) PURE;
};

/* IHTMLDocument2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLDocument2
DECLARE_INTERFACE_( IHTMLDocument2, IHTMLDocument ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLDocument methods */
    STDMETHOD( get_Script )( THIS_ IDispatch ** ) PURE;

    /* IHTMLDocument2 methods */
    STDMETHOD( get_all )( THIS_ IHTMLElementCollection ** ) PURE;
    STDMETHOD( get_body )(  THIS_ IHTMLElement ** ) PURE;
    STDMETHOD( get_activeElement )( THIS_ IHTMLElement ** ) PURE;
    STDMETHOD( get_images )( THIS_ IHTMLElementCollection ** ) PURE;
    STDMETHOD( get_applets )( THIS_ IHTMLElementCollection ** ) PURE;
    STDMETHOD( get_links )( THIS_ IHTMLElementCollection ** ) PURE;
    STDMETHOD( get_forms )( THIS_ IHTMLElementCollection ** ) PURE;
    STDMETHOD( get_anchors )( THIS_ IHTMLElementCollection ** ) PURE;
    STDMETHOD( put_title )( THIS_ BSTR ) PURE;
    STDMETHOD( get_title )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_scripts )( THIS_ IHTMLElementCollection ** ) PURE;
    STDMETHOD( put_designMode )( THIS_ BSTR ) PURE;
    STDMETHOD( get_designMode )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_selection )( THIS_ IHTMLSelectionObject ** ) PURE;
    STDMETHOD( get_readyState )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_frames )( THIS_ IHTMLFramesCollection2 ** ) PURE;
    STDMETHOD( get_embeds )( THIS_ IHTMLElementCollection ** ) PURE;
    STDMETHOD( get_plugins )( THIS_ IHTMLElementCollection ** ) PURE;
    STDMETHOD( put_alinkColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_alinkColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_bgColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_bgColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_fgColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_fgColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_linkColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_linkColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_vlinkColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_vlinkColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_referrer )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_location )( THIS_ IHTMLLocation ** ) PURE;
    STDMETHOD( get_lastModified )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_URL )( THIS_ BSTR ) PURE;
    STDMETHOD( get_URL )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_domain )( THIS_ BSTR ) PURE;
    STDMETHOD( get_domain )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_cookie )( THIS_ BSTR ) PURE;
    STDMETHOD( get_cookie )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_expando )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_expando )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_charset )( THIS_ BSTR ) PURE;
    STDMETHOD( get_charset )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_defaultCharset )( THIS_ BSTR ) PURE;
    STDMETHOD( get_defaultCharset )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_mimeType )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_fileSize )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_fileCreatedDate )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_fileModifiedDate )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_fileUpdatedDate )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_security )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_protocol )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_nameProp )( THIS_ BSTR * ) PURE;
    STDMETHOD( write )( THIS_ SAFEARRAY * ) PURE;
    STDMETHOD( writeln )( THIS_ SAFEARRAY * ) PURE;
    STDMETHOD( open )( THIS_ BSTR, VARIANT, VARIANT, VARIANT, IDispatch ** ) PURE;
    STDMETHOD( close )( THIS ) PURE;
    STDMETHOD( clear )( THIS ) PURE;
    STDMETHOD( queryCommandSupported )( THIS_ BSTR, VARIANT_BOOL * ) PURE;
    STDMETHOD( queryCommandEnabled )( THIS_ BSTR, VARIANT_BOOL * ) PURE;
    STDMETHOD( queryCommandState )( THIS_ BSTR, VARIANT_BOOL * ) PURE;
    STDMETHOD( queryCommandIndeterm )( THIS_ BSTR, VARIANT_BOOL * ) PURE;
    STDMETHOD( queryCommandText )( THIS_ BSTR, BSTR * ) PURE;
    STDMETHOD( queryCommandValue )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( execCommand )( THIS_ BSTR, VARIANT_BOOL, VARIANT, VARIANT_BOOL * ) PURE;
    STDMETHOD( execCommandShowHelp )( THIS_ BSTR, VARIANT_BOOL * ) PURE;
    STDMETHOD( createElement )( THIS_ BSTR, IHTMLElement ** ) PURE;
    STDMETHOD( put_onhelp )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onhelp )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onclick )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onclick )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_ondblclick )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_ondblclick )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onkeyup )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onkeyup )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onkeydown )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onkeydown )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onkeypress )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onkeypress )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onmouseup )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onmouseup )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onmousedown )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onmousedown )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onmousemove )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onmousemove )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onmouseout )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onmouseout )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onmouseover )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onmouseover )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onreadystatechange )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onreadystatechange )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onafterupdate )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onafterupdate )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onrowexit )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onrowexit )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onrowenter )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onrowenter )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_ondragstart )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_ondragstart )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onselectstart )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onselectstart )( THIS_ VARIANT * ) PURE;
    STDMETHOD( elementFromPoint )( THIS_ long, long, IHTMLElement ** ) PURE;
    STDMETHOD( get_parentWindow )( THIS_ IHTMLWindow2 ** ) PURE;
    STDMETHOD( get_styleSheets )( THIS_ IHTMLStyleSheetsCollection ** ) PURE;
    STDMETHOD( put_onbeforeupdate )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onbeforeupdate )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onerrorupdate )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onerrorupdate )( THIS_ VARIANT * ) PURE;
    STDMETHOD( toString )( THIS_ BSTR * ) PURE;
    STDMETHOD( createStyleSheet )( THIS_ BSTR, long, IHTMLStyleSheet ** ) PURE;
};

/* IHTMLDocument3 interface */
#undef INTERFACE
#define INTERFACE   IHTMLDocument3
DECLARE_INTERFACE_( IHTMLDocument3, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLDocument3 methods */
    STDMETHOD( releaseCapture )( THIS ) PURE;
    STDMETHOD( recalc )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( createTextNode )( THIS_ BSTR, IHTMLDOMNode ** ) PURE;
    STDMETHOD( get_documentElement )( THIS_ IHTMLElement ** ) PURE;
    STDMETHOD( get_uniqueID )( THIS_ BSTR * ) PURE;
    STDMETHOD( attachEvent )( THIS_ BSTR, IDispatch *, VARIANT_BOOL * ) PURE;
    STDMETHOD( detachEvent )( THIS_ BSTR, IDispatch * ) PURE;
    STDMETHOD( put_onrowsdelete )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onrowsdelete )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onrowsinserted )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onrowsinserted )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_oncellchange )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_oncellchange )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_ondatasetchanged )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_ondatasetchanged )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_ondataavailable )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_ondataavailable )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_ondatasetcomplete )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_ondatasetcomplete )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onpropertychange )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onpropertychange )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_dir )( THIS_ BSTR ) PURE;
    STDMETHOD( get_dir )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_oncontextmenu )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_oncontextmenu )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onstop )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onstop )( THIS_ VARIANT * ) PURE;
    STDMETHOD( createDocumentFragment )( THIS_ IHTMLDocument2 ** ) PURE;
    STDMETHOD( get_parentDocument )( THIS_ IHTMLDocument2 ** ) PURE;
    STDMETHOD( put_enableDownload )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_enableDownload )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_baseUrl )( THIS_ BSTR ) PURE;
    STDMETHOD( get_baseUrl )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_childNodes )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( put_inheritStyleSheets )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_inheritStyleSheets )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_onbeforeeditfocus )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onbeforeeditfocus )( THIS_ VARIANT * ) PURE;
    STDMETHOD( getElementsByName )( THIS_ BSTR, IHTMLElementCollection ** ) PURE;
    STDMETHOD( getElementById )( THIS_ BSTR, IHTMLElement ** ) PURE;
    STDMETHOD( getElementsByTagName )( THIS_ BSTR, IHTMLElementCollection ** ) PURE;
};

/* IHTMLDocument4 interface */
#undef INTERFACE
#define INTERFACE   IHTMLDocument4
DECLARE_INTERFACE_( IHTMLDocument4, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLDocument4 methods */
    STDMETHOD( focus )( THIS ) PURE;
    STDMETHOD( hasFocus )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_onselectionchange )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onselectionchange )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_namespaces )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( createDocumentFromUrl )( THIS_ BSTR, BSTR, IHTMLDocument2 ** ) PURE;
    STDMETHOD( put_media )( THIS_ BSTR ) PURE;
    STDMETHOD( get_media )( THIS_ BSTR * ) PURE;
    STDMETHOD( createEventObject )( THIS_ VARIANT *, IHTMLEventObj ** ) PURE;
    STDMETHOD( fireEvent )( THIS_ BSTR, VARIANT *, VARIANT_BOOL * ) PURE;
    STDMETHOD( createRenderStyle )( THIS_ BSTR, IHTMLRenderStyle ** ) PURE;
    STDMETHOD( put_oncontrolselect )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_oncontrolselect )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_URLUnencoded )( THIS_ BSTR * ) PURE;
};

/* IHTMLDocument5 interface */
#undef INTERFACE
#define INTERFACE   IHTMLDocument5
DECLARE_INTERFACE_( IHTMLDocument5, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLDocument5 methods */
    STDMETHOD( put_onmousewheel )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onmousewheel )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_doctype )( THIS_ IHTMLDOMNode ** ) PURE;
    STDMETHOD( get_implementation )( THIS_ IHTMLDOMImplementation ** ) PURE;
    STDMETHOD( createAttribute )( THIS_ BSTR, IHTMLDOMAttribute ** ) PURE;
    STDMETHOD( createComment )( THIS_ BSTR, IHTMLDOMNode ** ) PURE;
    STDMETHOD( put_onfocusin )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onfocusin )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onfocusout )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onfocusout )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onactivate )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onactivate )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_ondeactivate )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_ondeactivate )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onbeforeactivate )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onbeforeactivate )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onbeforedeactivate )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onbeforedeactivate )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_compatMode )( THIS_ BSTR * ) PURE;
};

/* IHTMLDocument6 interface */
#undef INTERFACE
#define INTERFACE   IHTMLDocument6
DECLARE_INTERFACE_( IHTMLDocument6, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLDocument6 methods */
    STDMETHOD( get_compatible )( THIS_ IHTMLDocumentCompatibleInfoCollection ** ) PURE;
    STDMETHOD( get_documentMode )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onstorage )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onstorage )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onstoragecommit )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onstoragecommit )( THIS_ VARIANT * ) PURE;
    STDMETHOD( getElementById )( THIS_ BSTR, IHTMLElement2 ** ) PURE;
    STDMETHOD( updateSettings )( THIS ) PURE;
};

/* IDocumentSelector interface */
#undef INTERFACE
#define INTERFACE   IDocumentSelector
DECLARE_INTERFACE_( IDocumentSelector, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IDocumentSelector methods */
    STDMETHOD( querySelector )( THIS_ BSTR, IHTMLElement ** ) PURE;
    STDMETHOD( querySelectorAll )( THIS_ BSTR, IHTMLDOMChildrenCollection ** ) PURE;
};

/* DispHTMLDocument interface */
#undef INTERFACE
#define INTERFACE   DispHTMLDocument
DECLARE_INTERFACE_( DispHTMLDocument, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DWebBridgeEvents interface */
#undef INTERFACE
#define INTERFACE   DWebBridgeEvents
DECLARE_INTERFACE_( DWebBridgeEvents, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IWebBridge interface */
#undef INTERFACE
#define INTERFACE   IWebBridge
DECLARE_INTERFACE_( IWebBridge, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IWebBridge methods */
    STDMETHOD( put_URL )( THIS_ BSTR ) PURE;
    STDMETHOD( get_URL )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_Scrollbar )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_Scrollbar )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_embed )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_embed )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_event )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_readyState )( THIS_ long * ) PURE;
    STDMETHOD( AboutBox )( THIS ) PURE;
};

/* IWBScriptControl interface */
#undef INTERFACE
#define INTERFACE   IWBScriptControl
DECLARE_INTERFACE_( IWBScriptControl, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IWBScriptControl methods */
    STDMETHOD( raiseEvent )( THIS_ BSTR, VARIANT ) PURE;
    STDMETHOD( bubbleEvent )( THIS ) PURE;
    STDMETHOD( setContextMenu )( THIS_ VARIANT ) PURE;
    STDMETHOD( put_selectableContent )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_selectableContent )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_frozen )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_scrollbar )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_scrollbar )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_version )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_visibility )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_onvisibilitychange )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onvisibilitychange )( THIS_ VARIANT * ) PURE;
};

/* IHTMLEmbedElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLEmbedElement
DECLARE_INTERFACE_( IHTMLEmbedElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLEmbedElement methods */
    STDMETHOD( put_hidden )( THIS_ BSTR ) PURE;
    STDMETHOD( get_hidden )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_palette )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_pluginspage )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_src )( THIS_ BSTR ) PURE;
    STDMETHOD( get_src )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_units )( THIS_ BSTR ) PURE;
    STDMETHOD( get_units )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_name )( THIS_ BSTR ) PURE;
    STDMETHOD( get_name )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_width )( THIS_ BSTR ) PURE;
    STDMETHOD( get_width )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_height )( THIS_ BSTR ) PURE;
    STDMETHOD( get_height )( THIS_ BSTR * ) PURE;
};

/* IHTMLEmbedElement2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLEmbedElement2
DECLARE_INTERFACE_( IHTMLEmbedElement2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLEmbedElement2 methods */
    STDMETHOD( put_src )( THIS_ BSTR ) PURE;
    STDMETHOD( get_src )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_pluginspage )( THIS_ BSTR * ) PURE;
};

/* DispHTMLEmbed interface */
#undef INTERFACE
#define INTERFACE   DispHTMLEmbed
DECLARE_INTERFACE_( DispHTMLEmbed, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLMapEvents2 interface */
#undef INTERFACE
#define INTERFACE   HTMLMapEvents2
DECLARE_INTERFACE_( HTMLMapEvents2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLMapEvents interface */
#undef INTERFACE
#define INTERFACE   HTMLMapEvents
DECLARE_INTERFACE_( HTMLMapEvents, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLAreasCollection interface */
#undef INTERFACE
#define INTERFACE   IHTMLAreasCollection
DECLARE_INTERFACE_( IHTMLAreasCollection, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLAreasCollection methods */
    STDMETHOD( put_length )( THIS_ long ) PURE;
    STDMETHOD( get_length )( THIS_ long * ) PURE;
    STDMETHOD( get__newEnum )( THIS_ IUnknown ** ) PURE;
    STDMETHOD( item )( THIS_ VARIANT, VARIANT, IDispatch ** ) PURE;
    STDMETHOD( tags )( THIS_ VARIANT, IDispatch ** ) PURE;
    STDMETHOD( add )( THIS_ IHTMLElement *, VARIANT ) PURE;
    STDMETHOD( remove )( THIS_ long ) PURE;
};

/* IHTMLAreasCollection2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLAreasCollection2
DECLARE_INTERFACE_( IHTMLAreasCollection2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLAreasCollection2 methods */
    STDMETHOD( urns )( THIS_ VARIANT, IDispatch ** ) PURE;
};

/* IHTMLAreasCollection3 interface */
#undef INTERFACE
#define INTERFACE   IHTMLAreasCollection3
DECLARE_INTERFACE_( IHTMLAreasCollection3, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLAreasCollection3 methods */
    STDMETHOD( namedItem )( THIS_ BSTR, IDispatch ** ) PURE;
};

/* IHTMLAreasCollection4 interface */
#undef INTERFACE
#define INTERFACE   IHTMLAreasCollection4
DECLARE_INTERFACE_( IHTMLAreasCollection4, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLAreasCollection4 methods */
    STDMETHOD( get_length )( THIS_ long * ) PURE;
    STDMETHOD( item )( THIS_ long, IHTMLElement2 ** ) PURE;
    STDMETHOD( namedItem )( THIS_ BSTR, IHTMLElement2 ** ) PURE;
};

/* IHTMLMapElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLMapElement
DECLARE_INTERFACE_( IHTMLMapElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLMapElement methods */
    STDMETHOD( get_areas )( THIS_ IHTMLAreasCollection ** ) PURE;
    STDMETHOD( put_name )( THIS_ BSTR ) PURE;
    STDMETHOD( get_name )( THIS_ BSTR * ) PURE;
};

/* DispHTMLAreasCollection interface */
#undef INTERFACE
#define INTERFACE   DispHTMLAreasCollection
DECLARE_INTERFACE_( DispHTMLAreasCollection, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispHTMLMapElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLMapElement
DECLARE_INTERFACE_( DispHTMLMapElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLAreaEvents2 interface */
#undef INTERFACE
#define INTERFACE   HTMLAreaEvents2
DECLARE_INTERFACE_( HTMLAreaEvents2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLAreaEvents interface */
#undef INTERFACE
#define INTERFACE   HTMLAreaEvents
DECLARE_INTERFACE_( HTMLAreaEvents, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLAreaElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLAreaElement
DECLARE_INTERFACE_( IHTMLAreaElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLAreaElement methods */
    STDMETHOD( put_shape )( THIS_ BSTR ) PURE;
    STDMETHOD( get_shape )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_coords )( THIS_ BSTR ) PURE;
    STDMETHOD( get_coords )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_href )( THIS_ BSTR ) PURE;
    STDMETHOD( get_href )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_target )( THIS_ BSTR ) PURE;
    STDMETHOD( get_target )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_alt )( THIS_ BSTR ) PURE;
    STDMETHOD( get_alt )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_noHref )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_noHref )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_host )( THIS_ BSTR ) PURE;
    STDMETHOD( get_host )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_hostname )( THIS_ BSTR ) PURE;
    STDMETHOD( get_hostname )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_pathname )( THIS_ BSTR ) PURE;
    STDMETHOD( get_pathname )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_port )( THIS_ BSTR ) PURE;
    STDMETHOD( get_port )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_protocol )( THIS_ BSTR ) PURE;
    STDMETHOD( get_protocol )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_search )( THIS_ BSTR ) PURE;
    STDMETHOD( get_search )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_hash )( THIS_ BSTR ) PURE;
    STDMETHOD( get_hash )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_onblur )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onblur )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onfocus )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onfocus )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_tabIndex )( THIS_ short ) PURE;
    STDMETHOD( get_tabIndex )( THIS_ short * ) PURE;
    STDMETHOD( focus )( THIS ) PURE;
    STDMETHOD( blur )( THIS ) PURE;
};

/* IHTMLAreaElement2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLAreaElement2
DECLARE_INTERFACE_( IHTMLAreaElement2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLAreaElement2 methods */
    STDMETHOD( put_shape )( THIS_ BSTR ) PURE;
    STDMETHOD( get_shape )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_coords )( THIS_ BSTR ) PURE;
    STDMETHOD( get_coords )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_href )( THIS_ BSTR ) PURE;
    STDMETHOD( get_href )( THIS_ BSTR * ) PURE;
};

/* DispHTMLAreaElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLAreaElement
DECLARE_INTERFACE_( DispHTMLAreaElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLTableCaption interface */
#undef INTERFACE
#define INTERFACE   IHTMLTableCaption
DECLARE_INTERFACE_( IHTMLTableCaption, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
    
    /* IHTMLTableCaption methods */
    STDMETHOD( put_align )( THIS_ BSTR ) PURE;
    STDMETHOD( get_align )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_vAlign )( THIS_ BSTR ) PURE;
    STDMETHOD( get_vAlign )( THIS_ BSTR * ) PURE;
};

/* DispHTMLTableCaption interface */
#undef INTERFACE
#define INTERFACE   DispHTMLTableCaption
DECLARE_INTERFACE_( DispHTMLTableCaption, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLCommentElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLCommentElement
DECLARE_INTERFACE_( IHTMLCommentElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLCommentElement methods */
    STDMETHOD( put_text )( THIS_ BSTR ) PURE;
    STDMETHOD( get_text )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_atomic )( THIS_ long ) PURE;
    STDMETHOD( get_atomic )( THIS_ long * ) PURE;
};

/* IHTMLCommentElement2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLCommentElement2
DECLARE_INTERFACE_( IHTMLCommentElement2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLCommentElement2 methods */
    STDMETHOD( put_data )( THIS_ BSTR ) PURE;
    STDMETHOD( get_data )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_length )( THIS_ long * ) PURE;
    STDMETHOD( substringData )( THIS_ long, long, BSTR * ) PURE;
    STDMETHOD( appendData )( THIS_ BSTR ) PURE;
    STDMETHOD( insertData )( THIS_ long, BSTR ) PURE;
    STDMETHOD( deleteData )( THIS_ long, long ) PURE;
    STDMETHOD( replaceData )( THIS_ long, long, BSTR ) PURE;
};

/* IHTMLPhraseElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLPhraseElement
DECLARE_INTERFACE_( IHTMLPhraseElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLPhraseElement2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLPhraseElement2
DECLARE_INTERFACE_( IHTMLPhraseElement2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLPhraseElement2 methods */
    STDMETHOD( put_cite )( THIS_ BSTR ) PURE;
    STDMETHOD( get_cite )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_dateTime )( THIS_ BSTR ) PURE;
    STDMETHOD( get_dateTime )( THIS_ BSTR * ) PURE;
};

/* IHTMLPhraseElement3 interface */
#undef INTERFACE
#define INTERFACE   IHTMLPhraseElement3
DECLARE_INTERFACE_( IHTMLPhraseElement3, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLPhraseElement3 methods */
    STDMETHOD( put_cite )( THIS_ BSTR ) PURE;
    STDMETHOD( get_cite )( THIS_ BSTR * ) PURE;
};

/* IHTMLSpanElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLSpanElement
DECLARE_INTERFACE_( IHTMLSpanElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispHTMLPhraseElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLPhraseElement
DECLARE_INTERFACE_( DispHTMLPhraseElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispHTMLSpanElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLSpanElement
DECLARE_INTERFACE_( DispHTMLSpanElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLTableEvents2 interface */
#undef INTERFACE
#define INTERFACE   HTMLTableEvents2
DECLARE_INTERFACE_( HTMLTableEvents2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLTableEvents interface */
#undef INTERFACE
#define INTERFACE   HTMLTableEvents
DECLARE_INTERFACE_( HTMLTableEvents, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLTable interface */
#undef INTERFACE
#define INTERFACE   IHTMLTable
DECLARE_INTERFACE_( IHTMLTable, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLTable methods */
    STDMETHOD( put_cols )( THIS_ long ) PURE;
    STDMETHOD( get_cols )( THIS_ long * ) PURE;
    STDMETHOD( put_border )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_border )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_frame )( THIS_ BSTR ) PURE;
    STDMETHOD( get_frame )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_rules )( THIS_ BSTR ) PURE;
    STDMETHOD( get_rules )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_cellSpacing )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_cellSpacing )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_cellPadding )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_cellPadding )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_background )( THIS_ BSTR ) PURE;
    STDMETHOD( get_background )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_bgColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_bgColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_borderColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_borderColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_borderColorLight )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_borderColorLight )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_borderColorDark )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_borderColorDark )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_align )( THIS_ BSTR ) PURE;
    STDMETHOD( get_align )( THIS_ BSTR * ) PURE;
    STDMETHOD( refresh )( THIS ) PURE;
    STDMETHOD( get_rows )( THIS_ IHTMLElementCollection ** ) PURE;
    STDMETHOD( put_width )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_width )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_height )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_height )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_dataPageSize )( THIS_ long ) PURE;
    STDMETHOD( get_dataPageSize )( THIS_ long * ) PURE;
    STDMETHOD( nextPage )( THIS ) PURE;
    STDMETHOD( previousPage )( THIS ) PURE;
    STDMETHOD( get_tHead )( THIS_ IHTMLTableSection ** ) PURE;
    STDMETHOD( get_tFoot )( THIS_ IHTMLTableSection ** ) PURE;
    STDMETHOD( get_tBodies )( THIS_ IHTMLElementCollection ** ) PURE;
    STDMETHOD( get_caption )( THIS_ IHTMLTableCaption ** ) PURE;
    STDMETHOD( createTHead )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( deleteTHead )( THIS ) PURE;
    STDMETHOD( createTFoot )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( deleteTFoot )( THIS ) PURE;
    STDMETHOD( createCaption )( THIS_ IHTMLTableCaption ** ) PURE;
    STDMETHOD( deleteCaption )( THIS ) PURE;
    STDMETHOD( insertRow )( THIS_ long, IDispatch ** ) PURE;
    STDMETHOD( deleteRow )( THIS_ long ) PURE;
    STDMETHOD( get_readyState )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_onreadystatechange )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onreadystatechange )( THIS_ VARIANT * ) PURE;
};

/* IHTMLTable2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLTable2
DECLARE_INTERFACE_( IHTMLTable2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLTable2 methods */
    STDMETHOD( firstPage )( THIS ) PURE;
    STDMETHOD( lastPage )( THIS ) PURE;
    STDMETHOD( get_cells )( THIS_ IHTMLElementCollection ** ) PURE;
    STDMETHOD( moveRow )( THIS_ long, long, IDispatch ** ) PURE;
};

/* IHTMLTable3 interface */
#undef INTERFACE
#define INTERFACE   IHTMLTable3
DECLARE_INTERFACE_( IHTMLTable3, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLTable3 methods */
    STDMETHOD( put_summary )( THIS_ BSTR ) PURE;
    STDMETHOD( get_summary )( THIS_ BSTR * ) PURE;
};

/* IHTMLTableCol interface */
#undef INTERFACE
#define INTERFACE   IHTMLTableCol
DECLARE_INTERFACE_( IHTMLTableCol, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLTableCol methods */
    STDMETHOD( put_span )( THIS_ long ) PURE;
    STDMETHOD( get_span )( THIS_ long * ) PURE;
    STDMETHOD( put_width )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_width )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_align )( THIS_ BSTR ) PURE;
    STDMETHOD( get_align )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_vAlign )( THIS_ BSTR ) PURE;
    STDMETHOD( get_vAlign )( THIS_ BSTR * ) PURE;
};

/* IHTMLTableCol2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLTableCol2
DECLARE_INTERFACE_( IHTMLTableCol2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLTableCol2 methods */
    STDMETHOD( put_ch )( THIS_ BSTR ) PURE;
    STDMETHOD( get_ch )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_chOff )( THIS_ BSTR ) PURE;
    STDMETHOD( get_chOff )( THIS_ BSTR * ) PURE;
};

/* IHTMLTableSection interface */
#undef INTERFACE
#define INTERFACE   IHTMLTableSection
DECLARE_INTERFACE_( IHTMLTableSection, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLTableSection methods */
    STDMETHOD( put_align )( THIS_ BSTR ) PURE;
    STDMETHOD( get_align )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_vAlign )( THIS_ BSTR ) PURE;
    STDMETHOD( get_vAlign )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_bgColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_bgColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_rows )( THIS_ IHTMLElementCollection ** ) PURE;
    STDMETHOD( insertRow )( THIS_ long, IDispatch ** ) PURE;
    STDMETHOD( deleteRow )( THIS_ long ) PURE;
};

/* IHTMLTableSection2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLTableSection2
DECLARE_INTERFACE_( IHTMLTableSection2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLTableSection2 methods */
    STDMETHOD( moveRow )( THIS_ long, long, IDispatch ** ) PURE;
};

/* IHTMLTableSection3 interface */
#undef INTERFACE
#define INTERFACE   IHTMLTableSection3
DECLARE_INTERFACE_( IHTMLTableSection3, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLTableSection3 methods */
    STDMETHOD( put_ch )( THIS_ BSTR ) PURE;
    STDMETHOD( get_ch )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_chOff )( THIS_ BSTR ) PURE;
    STDMETHOD( get_chOff )( THIS_ BSTR * ) PURE;
};

/* IHTMLTableRow interface */
#undef INTERFACE
#define INTERFACE   IHTMLTableRow
DECLARE_INTERFACE_( IHTMLTableRow, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLTableRow methods */
    STDMETHOD( put_align )( THIS_ BSTR ) PURE;
    STDMETHOD( get_align )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_vAlign )( THIS_ BSTR ) PURE;
    STDMETHOD( get_vAlign )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_bgColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_bgColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_borderColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_borderColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_borderColorLight )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_borderColorLight )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_borderColorDark )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_borderColorDark )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_rowIndex )( THIS_ long * ) PURE;
    STDMETHOD( get_sectionRowIndex )( THIS_ long * ) PURE;
    STDMETHOD( get_cells )( THIS_ IHTMLElementCollection ** ) PURE;
    STDMETHOD( insertCell )( THIS_ long, IDispatch ** ) PURE;
    STDMETHOD( deleteCell )( THIS_ long ) PURE;
};

/* IHTMLTableRow2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLTableRow2
DECLARE_INTERFACE_( IHTMLTableRow2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLTableRow2 methods */
    STDMETHOD( put_height )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_height )( THIS_ VARIANT * ) PURE;
};

/* IHTMLTableRow3 interface */
#undef INTERFACE
#define INTERFACE   IHTMLTableRow3
DECLARE_INTERFACE_( IHTMLTableRow3, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLTableRow3 methods */
    STDMETHOD( put_ch )( THIS_ BSTR ) PURE;
    STDMETHOD( get_ch )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_chOff )( THIS_ BSTR ) PURE;
    STDMETHOD( get_chOff )( THIS_ BSTR * ) PURE;
};

/* IHTMLTableRowMetrics interface */
#undef INTERFACE
#define INTERFACE   IHTMLTableRowMetrics
DECLARE_INTERFACE_( IHTMLTableRowMetrics, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLTableRowMetrics methods */
    STDMETHOD( get_clientHeight )( THIS_ long * ) PURE;
    STDMETHOD( get_clientWidth )( THIS_ long * ) PURE;
    STDMETHOD( get_clientTop )( THIS_ long * ) PURE;
    STDMETHOD( get_clientLeft )( THIS_ long * ) PURE;
};

/* IHTMLTableCell interface */
#undef INTERFACE
#define INTERFACE   IHTMLTableCell
DECLARE_INTERFACE_( IHTMLTableCell, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLTableCell methods */
    STDMETHOD( put_rowSpan )( THIS_ long ) PURE;
    STDMETHOD( get_rowSpan )( THIS_ long * ) PURE;
    STDMETHOD( put_colSpan )( THIS_ long ) PURE;
    STDMETHOD( get_colSpan )( THIS_ long * ) PURE;
    STDMETHOD( put_align )( THIS_ BSTR ) PURE;
    STDMETHOD( get_align )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_vAlign )( THIS_ BSTR ) PURE;
    STDMETHOD( get_vAlign )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_bgColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_bgColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_noWrap )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_noWrap )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_background )( THIS_ BSTR ) PURE;
    STDMETHOD( get_background )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_borderColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_borderColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_borderColorLight )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_borderColorLight )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_borderColorDark )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_borderColorDark )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_width )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_width )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_height )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_height )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_cellIndex )( THIS_ long * ) PURE;
};

/* IHTMLTableCell2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLTableCell2
DECLARE_INTERFACE_( IHTMLTableCell2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLTableCell2 methods */
    STDMETHOD( put_abbr )( THIS_ BSTR ) PURE;
    STDMETHOD( get_abbr )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_axis )( THIS_ BSTR ) PURE;
    STDMETHOD( get_axis )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_ch )( THIS_ BSTR ) PURE;
    STDMETHOD( get_ch )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_chOff )( THIS_ BSTR ) PURE;
    STDMETHOD( get_chOff )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_headers )( THIS_ BSTR ) PURE;
    STDMETHOD( get_headers )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_scope )( THIS_ BSTR ) PURE;
    STDMETHOD( get_scope )( THIS_ BSTR * ) PURE;
};

/* DispHTMLTable interface */
#undef INTERFACE
#define INTERFACE   DispHTMLTable
DECLARE_INTERFACE_( DispHTMLTable, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispHTMLTableCol interface */
#undef INTERFACE
#define INTERFACE   DispHTMLTableCol
DECLARE_INTERFACE_( DispHTMLTableCol, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispHTMLTableSection interface */
#undef INTERFACE
#define INTERFACE   DispHTMLTableSection
DECLARE_INTERFACE_( DispHTMLTableSection, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispHTMLTableRow interface */
#undef INTERFACE
#define INTERFACE   DispHTMLTableRow
DECLARE_INTERFACE_( DispHTMLTableRow, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispHTMLTableCell interface */
#undef INTERFACE
#define INTERFACE   DispHTMLTableCell
DECLARE_INTERFACE_( DispHTMLTableCell, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLScriptEvents2 interface */
#undef INTERFACE
#define INTERFACE   HTMLScriptEvents2
DECLARE_INTERFACE_( HTMLScriptEvents2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLScriptEvents interface */
#undef INTERFACE
#define INTERFACE   HTMLScriptEvents
DECLARE_INTERFACE_( HTMLScriptEvents, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLScriptElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLScriptElement
DECLARE_INTERFACE_( IHTMLScriptElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLScriptElement methods */
    STDMETHOD( put_src )( THIS_ BSTR ) PURE;
    STDMETHOD( get_src )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_htmlFor )( THIS_ BSTR ) PURE;
    STDMETHOD( get_htmlFor )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_event )( THIS_ BSTR ) PURE;
    STDMETHOD( get_event )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_text )( THIS_ BSTR ) PURE;
    STDMETHOD( get_text )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_defer )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_defer )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_readyState )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_onerror )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onerror )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_type )( THIS_ BSTR ) PURE;
    STDMETHOD( get_type )( THIS_ BSTR * ) PURE;
};

/* IHTMLScriptElement2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLScriptElement2
DECLARE_INTERFACE_( IHTMLScriptElement2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLScriptElement2 methods */
    STDMETHOD( put_charset )( THIS_ BSTR ) PURE;
    STDMETHOD( get_charset )( THIS_ BSTR * ) PURE;
};

/* IHTMLScriptElement3 interface */
#undef INTERFACE
#define INTERFACE   IHTMLScriptElement3
DECLARE_INTERFACE_( IHTMLScriptElement3, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLScriptElement3 methods */
    STDMETHOD( put_src )( THIS_ BSTR ) PURE;
    STDMETHOD( get_src )( THIS_ BSTR * ) PURE;
};

/* DispHTMLScriptElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLScriptElement
DECLARE_INTERFACE_( DispHTMLScriptElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLNoShowElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLNoShowElement
DECLARE_INTERFACE_( IHTMLNoShowElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispHTMLNoShowElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLNoShowElement
DECLARE_INTERFACE_( DispHTMLNoShowElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLObjectElementEvents2 interface */
#undef INTERFACE
#define INTERFACE   HTMLObjectElementEvents2
DECLARE_INTERFACE_( HTMLObjectElementEvents2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLObjectElementEvents interface */
#undef INTERFACE
#define INTERFACE   HTMLObjectElementEvents
DECLARE_INTERFACE_( HTMLObjectElementEvents, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLObjectElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLObjectElement
DECLARE_INTERFACE_( IHTMLObjectElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLObjectElement methods */
    STDMETHOD( get_object )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_classid )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_data )( THIS_ BSTR * ) PURE;
    STDMETHOD( putref_recordset )( THIS_ IDispatch * ) PURE;
    STDMETHOD( get_recordset )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( put_align )( THIS_ BSTR ) PURE;
    STDMETHOD( get_align )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_name )( THIS_ BSTR ) PURE;
    STDMETHOD( get_name )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_codeBase )( THIS_ BSTR ) PURE;
    STDMETHOD( get_codeBase )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_codeType )( THIS_ BSTR ) PURE;
    STDMETHOD( get_codeType )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_code )( THIS_ BSTR ) PURE;
    STDMETHOD( get_code )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_BaseHref )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_type )( THIS_ BSTR ) PURE;
    STDMETHOD( get_type )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_form )( THIS_ IHTMLFormElement ** ) PURE;
    STDMETHOD( put_width )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_width )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_height )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_height )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_readyState )( THIS_ long * ) PURE;
    STDMETHOD( put_onreadystatechange )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onreadystatechange )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onerror )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onerror )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_altHtml )( THIS_ BSTR ) PURE;
    STDMETHOD( get_altHtml )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_vspace )( THIS_ long ) PURE;
    STDMETHOD( get_vspace )( THIS_ long * ) PURE;
    STDMETHOD( put_hspace )( THIS_ long ) PURE;
    STDMETHOD( get_hspace )( THIS_ long * ) PURE;
};

/* IHTMLObjectElement2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLObjectElement2
DECLARE_INTERFACE_( IHTMLObjectElement2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLObjectElement2 methods */
    STDMETHOD( namedRecordset )( THIS_ BSTR, VARIANT *, IDispatch ** ) PURE;
    STDMETHOD( put_classid )( THIS_ BSTR ) PURE;
    STDMETHOD( get_classid )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_data )( THIS_ BSTR ) PURE;
    STDMETHOD( get_data )( THIS_ BSTR * ) PURE;
};

/* IHTMLObjectElement3 interface */
#undef INTERFACE
#define INTERFACE   IHTMLObjectElement3
DECLARE_INTERFACE_( IHTMLObjectElement3, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLObjectElement3 methods */
    STDMETHOD( put_archive )( THIS_ BSTR ) PURE;
    STDMETHOD( get_archive )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_alt )( THIS_ BSTR ) PURE;
    STDMETHOD( get_alt )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_declare )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_declare )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_standby )( THIS_ BSTR ) PURE;
    STDMETHOD( get_standby )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_border )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_border )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_useMap )( THIS_ BSTR ) PURE;
    STDMETHOD( get_useMap )( THIS_ BSTR * ) PURE;
};

/* IHTMLObjectElement4 interface */
#undef INTERFACE
#define INTERFACE   IHTMLObjectElement4
DECLARE_INTERFACE_( IHTMLObjectElement4, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLObjectElement4 methods */
    STDMETHOD( get_contentDocument )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( put_codeBase )( THIS_ BSTR ) PURE;
    STDMETHOD( get_codeBase )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_data )( THIS_ BSTR ) PURE;
    STDMETHOD( get_data )( THIS_ BSTR * ) PURE;
};

/* IHTMLParamElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLParamElement
DECLARE_INTERFACE_( IHTMLParamElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLParamElement methods */
    STDMETHOD( put_name )( THIS_ BSTR ) PURE;
    STDMETHOD( get_name )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_value )( THIS_ BSTR ) PURE;
    STDMETHOD( get_value )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_type )( THIS_ BSTR ) PURE;
    STDMETHOD( get_type )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_valueType )( THIS_ BSTR ) PURE;
    STDMETHOD( get_valueType )( THIS_ BSTR * ) PURE;
};

/* IHTMLParamElement2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLParamElement2
DECLARE_INTERFACE_( IHTMLParamElement2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLParamElement2 methods */
    STDMETHOD( put_name )( THIS_ BSTR ) PURE;
    STDMETHOD( get_name )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_type )( THIS_ BSTR ) PURE;
    STDMETHOD( get_type )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_value )( THIS_ BSTR ) PURE;
    STDMETHOD( get_value )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_valueType )( THIS_ BSTR ) PURE;
    STDMETHOD( get_valueType )( THIS_ BSTR * ) PURE;
};

/* DispHTMLObjectElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLObjectElement
DECLARE_INTERFACE_( DispHTMLObjectElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispHTMLParamElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLParamElement
DECLARE_INTERFACE_( DispHTMLParamElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLFrameSiteEvents2 interface */
#undef INTERFACE
#define INTERFACE   HTMLFrameSiteEvents2
DECLARE_INTERFACE_( HTMLFrameSiteEvents2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLFrameSiteEvents interface */
#undef INTERFACE
#define INTERFACE   HTMLFrameSiteEvents
DECLARE_INTERFACE_( HTMLFrameSiteEvents, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLFrameBase interface */
#undef INTERFACE
#define INTERFACE   IHTMLFrameBase
DECLARE_INTERFACE_( IHTMLFrameBase, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLFrameBase methods */
    STDMETHOD( put_src )( THIS_ BSTR ) PURE;
    STDMETHOD( get_src )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_name )( THIS_ BSTR ) PURE;
    STDMETHOD( get_name )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_border )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_border )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_frameBorder )( THIS_ BSTR ) PURE;
    STDMETHOD( get_frameBorder )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_frameSpacing )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_frameSpacing )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_marginWidth )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_marginWidth )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_marginHeight )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_marginHeight )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_noResize )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_noResize )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_scrolling )( THIS_ BSTR ) PURE;
    STDMETHOD( get_scrolling )( THIS_ BSTR * ) PURE;
};

/* IHTMLFrameBase2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLFrameBase2
DECLARE_INTERFACE_( IHTMLFrameBase2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLFrameBase2 methods */
    STDMETHOD( get_contentWindow )( THIS_ IHTMLWindow2 ** ) PURE;
    STDMETHOD( put_onload )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onload )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onreadystatechange )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onreadystatechange )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_readyState )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_allowTransparency )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_allowTransparency )( THIS_ VARIANT_BOOL * ) PURE;
};

/* IHTMLFrameBase3 interface */
#undef INTERFACE
#define INTERFACE   IHTMLFrameBase3
DECLARE_INTERFACE_( IHTMLFrameBase3, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLFrameBase3 methods */
    STDMETHOD( put_longDesc )( THIS_ BSTR ) PURE;
    STDMETHOD( get_longDesc )( THIS_ BSTR * ) PURE;
};

/* DispHTMLFrameBase interface */
#undef INTERFACE
#define INTERFACE   DispHTMLFrameBase
DECLARE_INTERFACE_( DispHTMLFrameBase, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLFrameElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLFrameElement
DECLARE_INTERFACE_( IHTMLFrameElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLFrameElement methods */
    STDMETHOD( put_borderColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_borderColor )( THIS_ VARIANT * ) PURE;
};

/* IHTMLFrameElement2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLFrameElement2
DECLARE_INTERFACE_( IHTMLFrameElement2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLFrameElement2 methods */
    STDMETHOD( put_height )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_height )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_width )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_width )( THIS_ VARIANT * ) PURE;
};

/* IHTMLFrameElement3 interface */
#undef INTERFACE
#define INTERFACE   IHTMLFrameElement3
DECLARE_INTERFACE_( IHTMLFrameElement3, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLFrameElement3 methods */
    STDMETHOD( get_contentDocument )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( put_src )( THIS_ BSTR ) PURE;
    STDMETHOD( get_src )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_longDesc )( THIS_ BSTR ) PURE;
    STDMETHOD( get_longDesc )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_frameBorder )( THIS_ BSTR ) PURE;
    STDMETHOD( get_frameBorder )( THIS_ BSTR * ) PURE;
};

/* DispHTMLFrameElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLFrameElement
DECLARE_INTERFACE_( DispHTMLFrameElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLIFrameElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLIFrameElement
DECLARE_INTERFACE_( IHTMLIFrameElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLIFrameElement methods */
    STDMETHOD( put_vspace )( THIS_ long ) PURE;
    STDMETHOD( get_vspace )( THIS_ long * ) PURE;
    STDMETHOD( put_hspace )( THIS_ long ) PURE;
    STDMETHOD( get_hspace )( THIS_ long * ) PURE;
    STDMETHOD( put_align )( THIS_ BSTR ) PURE;
    STDMETHOD( get_align )( THIS_ BSTR * ) PURE;
};

/* IHTMLIFrameElement2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLIFrameElement2
DECLARE_INTERFACE_( IHTMLIFrameElement2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLIFrameElement2 methods */
    STDMETHOD( put_height )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_height )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_width )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_width )( THIS_ VARIANT * ) PURE;
};

/* IHTMLIFrameElement3 interface */
#undef INTERFACE
#define INTERFACE   IHTMLIFrameElement3
DECLARE_INTERFACE_( IHTMLIFrameElement3, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLIFrameElement3 methods */
    STDMETHOD( get_contentDocument )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( put_src )( THIS_ BSTR ) PURE;
    STDMETHOD( get_src )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_longDesc )( THIS_ BSTR ) PURE;
    STDMETHOD( get_longDesc )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_frameBorder )( THIS_ BSTR ) PURE;
    STDMETHOD( get_frameBorder )( THIS_ BSTR * ) PURE;
};

/* DispHTMLIFrame interface */
#undef INTERFACE
#define INTERFACE   DispHTMLIFrame
DECLARE_INTERFACE_( DispHTMLIFrame, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLDivPosition interface */
#undef INTERFACE
#define INTERFACE   IHTMLDivPosition
DECLARE_INTERFACE_( IHTMLDivPosition, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLDivPosition methods */
    STDMETHOD( put_align )( THIS_ BSTR ) PURE;
    STDMETHOD( get_align )( THIS_ BSTR * ) PURE;
};

/* IHTMLFieldSetElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLFieldSetElement
DECLARE_INTERFACE_( IHTMLFieldSetElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLFieldSetElement methods */
    STDMETHOD( put_align )( THIS_ BSTR ) PURE;
    STDMETHOD( get_align )( THIS_ BSTR * ) PURE;
};

/* IHTMLFieldSetElement2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLFieldSetElement2
DECLARE_INTERFACE_( IHTMLFieldSetElement2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLFieldSetElement2 methods */
    STDMETHOD( get_form )( THIS_ IHTMLFormElement ** ) PURE;
};

/* IHTMLLegendElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLLegendElement
DECLARE_INTERFACE_( IHTMLLegendElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLLegendElement methods */
    STDMETHOD( put_align )( THIS_ BSTR ) PURE;
    STDMETHOD( get_align )( THIS_ BSTR * ) PURE;
};

/* IHTMLLegendElement2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLLegendElement2
DECLARE_INTERFACE_( IHTMLLegendElement2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLLegendElement2 methods */
    STDMETHOD( get_form )( THIS_ IHTMLFormElement ** ) PURE;
};

/* DispHTMLDivPosition interface */
#undef INTERFACE
#define INTERFACE   DispHTMLDivPosition
DECLARE_INTERFACE_( DispHTMLDivPosition, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispHTMLFieldSetElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLFieldSetElement
DECLARE_INTERFACE_( DispHTMLFieldSetElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispHTMLLegendElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLLegendElement
DECLARE_INTERFACE_( DispHTMLLegendElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLSpanFlow interface */
#undef INTERFACE
#define INTERFACE   IHTMLSpanFlow
DECLARE_INTERFACE_( IHTMLSpanFlow, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLSpanFlow methods */
    STDMETHOD( put_align )( THIS_ BSTR ) PURE;
    STDMETHOD( get_align )( THIS_ BSTR * ) PURE;
};

/* DispHTMLSpanFlow interface */
#undef INTERFACE
#define INTERFACE   DispHTMLSpanFlow
DECLARE_INTERFACE_( DispHTMLSpanFlow, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLFrameSetElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLFrameSetElement
DECLARE_INTERFACE_( IHTMLFrameSetElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLFrameSetElement methods */
    STDMETHOD( put_rows )( THIS_ BSTR ) PURE;
    STDMETHOD( get_rows )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_cols )( THIS_ BSTR ) PURE;
    STDMETHOD( get_cols )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_border )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_border )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_borderColor )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_borderColor )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_frameBorder )( THIS_ BSTR ) PURE;
    STDMETHOD( get_frameBorder )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_frameSpacing )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_frameSpacing )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_name )( THIS_ BSTR ) PURE;
    STDMETHOD( get_name )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_onload )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onload )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onunload )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onunload )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onbeforeunload )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onbeforeunload )( THIS_ VARIANT * ) PURE;
};

/* IHTMLFrameSetElement2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLFrameSetElement2
DECLARE_INTERFACE_( IHTMLFrameSetElement2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLFrameSetElement2 methods */
    STDMETHOD( put_onbeforeprint )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onbeforeprint )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onafterprint )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onafterprint )( THIS_ VARIANT * ) PURE;
};

/* DispHTMLFrameSetSite interface */
#undef INTERFACE
#define INTERFACE   DispHTMLFrameSetSite
DECLARE_INTERFACE_( DispHTMLFrameSetSite, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLBGsound interface */
#undef INTERFACE
#define INTERFACE   IHTMLBGsound
DECLARE_INTERFACE_( IHTMLBGsound, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLBGsound methods */
    STDMETHOD( put_src )( THIS_ BSTR ) PURE;
    STDMETHOD( get_src )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_loop )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_loop )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_volume )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_volume )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_balance )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_balance )( THIS_ VARIANT * ) PURE;
};

/* DispHTMLBGsound interface */
#undef INTERFACE
#define INTERFACE   DispHTMLBGsound
DECLARE_INTERFACE_( DispHTMLBGsound, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLFontNamesCollection interface */
#undef INTERFACE
#define INTERFACE   IHTMLFontNamesCollection
DECLARE_INTERFACE_( IHTMLFontNamesCollection, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLFontNamesCollection methods */
    STDMETHOD( get_length )( THIS_ long * ) PURE;
    STDMETHOD( get__newEnum )( THIS_ IUnknown ** ) PURE;
    STDMETHOD( item )( THIS_ long, BSTR * ) PURE;
};

/* IHTMLFontSizesCollection interface */
#undef INTERFACE
#define INTERFACE   IHTMLFontSizesCollection
DECLARE_INTERFACE_( IHTMLFontSizesCollection, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLFontSizesCollection methods */
    STDMETHOD( get_length )( THIS_ long * ) PURE;
    STDMETHOD( get__newEnum )( THIS_ IUnknown ** ) PURE;
    STDMETHOD( get_forFont )( THIS_ BSTR * ) PURE;
    STDMETHOD( item )( THIS_ long, long * ) PURE;
};

/* IHTMLOptionsHolder interface */
#undef INTERFACE
#define INTERFACE   IHTMLOptionsHolder
DECLARE_INTERFACE_( IHTMLOptionsHolder, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLOptionsHolder methods */
    STDMETHOD( get_document )( THIS_ IHTMLDocument2 ** ) PURE;
    STDMETHOD( get_fonts )( THIS_ IHTMLFontNamesCollection ** ) PURE;
    STDMETHOD( put_execArg )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_execArg )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_errorLine )( THIS_ long ) PURE;
    STDMETHOD( get_errorLine )( THIS_ long * ) PURE;
    STDMETHOD( put_errorCharacter )( THIS_ long ) PURE;
    STDMETHOD( get_errorCharacter )( THIS_ long * ) PURE;
    STDMETHOD( put_errorCode )( THIS_ long ) PURE;
    STDMETHOD( get_errorCode )( THIS_ long * ) PURE;
    STDMETHOD( put_errorMessage )( THIS_ BSTR ) PURE;
    STDMETHOD( get_errorMessage )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_errorDebug )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_errorDebug )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_unsecuredWindowOfDocument )( THIS_ IHTMLWindow2 ** ) PURE;
    STDMETHOD( put_findText )( THIS_ BSTR ) PURE;
    STDMETHOD( get_findText )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_anythingAfterFrameset )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_anythingAfterFrameset )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( sizes )( THIS_ BSTR, IHTMLFontSizesCollection ** ) PURE;
    STDMETHOD( openfiledlg )( THIS_ VARIANT, VARIANT, VARIANT, VARIANT, BSTR * ) PURE;
    STDMETHOD( savefiledlg )( THIS_ VARIANT, VARIANT, VARIANT, VARIANT, BSTR * ) PURE;
    STDMETHOD( choosecolordlg )( THIS_ VARIANT, long * ) PURE;
    STDMETHOD( showSecurityInfo )( THIS ) PURE;
    STDMETHOD( isApartmentModel )( THIS_ IHTMLObjectElement *, VARIANT_BOOL * ) PURE;
    STDMETHOD( getCharset )( THIS_ BSTR, long * ) PURE;
    STDMETHOD( get_secureConnectionInfo )( THIS_ BSTR * ) PURE;
};

/* HTMLStyleElementEvents2 interface */
#undef INTERFACE
#define INTERFACE   HTMLStyleElementEvents2
DECLARE_INTERFACE_( HTMLStyleElementEvents2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* HTMLStyleElementEvents interface */
#undef INTERFACE
#define INTERFACE   HTMLStyleElementEvents
DECLARE_INTERFACE_( HTMLStyleElementEvents, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLStyleElement interface */
#undef INTERFACE
#define INTERFACE   IHTMLStyleElement
DECLARE_INTERFACE_( IHTMLStyleElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLStyleElement methods */
    STDMETHOD( put_type )( THIS_ BSTR ) PURE;
    STDMETHOD( get_type )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_readyState )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_onreadystatechange )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onreadystatechange )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onload )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onload )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onerror )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onerror )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_styleSheet )( THIS_ IHTMLStyleSheet ** ) PURE;
    STDMETHOD( put_disabled )( THIS_ VARIANT_BOOL ) PURE;
    STDMETHOD( get_disabled )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( put_media )( THIS_ BSTR ) PURE;
    STDMETHOD( get_media )( THIS_ BSTR * ) PURE;
};

/* DispHTMLStyleElement interface */
#undef INTERFACE
#define INTERFACE   DispHTMLStyleElement
DECLARE_INTERFACE_( DispHTMLStyleElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLStyleFontFace interface */
#undef INTERFACE
#define INTERFACE   IHTMLStyleFontFace
DECLARE_INTERFACE_( IHTMLStyleFontFace, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLStyleFontFace methods */
    STDMETHOD( put_fontsrc )( THIS_ BSTR ) PURE;
    STDMETHOD( get_fontsrc )( THIS_ BSTR * ) PURE;
};

/* IHTMLXDomainRequest interface */
#undef INTERFACE
#define INTERFACE   IHTMLXDomainRequest
DECLARE_INTERFACE_( IHTMLXDomainRequest, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLXDomainRequest methods */
    STDMETHOD( get_responseText )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_timeout )( THIS_ long ) PURE;
    STDMETHOD( get_timeout )( THIS_ long * ) PURE;
    STDMETHOD( get_contentType )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_onprogress )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onprogress )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onerror )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onerror )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_ontimeout )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_ontimeout )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onload )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onload )( THIS_ VARIANT * ) PURE;
    STDMETHOD( abort )( THIS ) PURE;
    STDMETHOD( open )( THIS_ BSTR, BSTR ) PURE;
    STDMETHOD( send )( THIS_ VARIANT ) PURE;
};

/* IHTMLXDomainRequestFactory interface */
#undef INTERFACE
#define INTERFACE   IHTMLXDomainRequestFactory
DECLARE_INTERFACE_( IHTMLXDomainRequestFactory, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLXDomainRequestFactory methods */
    STDMETHOD( create )( THIS_ IHTMLXDomainRequest ** ) PURE;
};

/* DispXDomainRequest interface */
#undef INTERFACE
#define INTERFACE   DispXDomainRequest
DECLARE_INTERFACE_( DispXDomainRequest, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLStorage interface */
#undef INTERFACE
#define INTERFACE   IHTMLStorage
DECLARE_INTERFACE_( IHTMLStorage, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLStorage methods */
    STDMETHOD( get_length )( THIS_ long * ) PURE;
    STDMETHOD( get_remainingSpace )( THIS_ long * ) PURE;
    STDMETHOD( key )( THIS_ long, BSTR * ) PURE;
    STDMETHOD( getItem )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( setItem )( THIS_ BSTR, BSTR ) PURE;
    STDMETHOD( removeItem )( THIS_ BSTR ) PURE;
    STDMETHOD( clear )( THIS ) PURE;
};

/* DispHTMLStorage interface */
#undef INTERFACE
#define INTERFACE   DispHTMLStorage
DECLARE_INTERFACE_( DispHTMLStorage, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* ICSSFilterSite interface */
#undef INTERFACE
#define INTERFACE   ICSSFilterSite
DECLARE_INTERFACE_( ICSSFilterSite, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* ICSSFilterSite methods */
    STDMETHOD( GetElement )( THIS_ IHTMLElement ** ) PURE;
    STDMETHOD( FireOnFilterChangeEvent )( THIS ) PURE;
};

/* ICSSFilter interface */
#undef INTERFACE
#define INTERFACE   ICSSFilter
DECLARE_INTERFACE_( ICSSFilter, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* ICSSFilter methods */
    STDMETHOD( SetSite )( THIS_ ICSSFilterSite * ) PURE;
    STDMETHOD( OnAmbientPropertyChange )( THIS_ LONG ) PURE;
};

/* ISecureUrlHost interface */
#undef INTERFACE
#define INTERFACE   ISecureUrlHost
DECLARE_INTERFACE_( ISecureUrlHost, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* ISecureUrlHost methods */
    STDMETHOD( ValidateSecureUrl )( THIS_ BOOL *, OLECHAR *, DWORD ) PURE;
};

/* IMarkupServices interface */
#undef INTERFACE
#define INTERFACE   IMarkupServices
DECLARE_INTERFACE_( IMarkupServices, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IMarkupServices methods */
    STDMETHOD( CreateMarkupPointer )( THIS_ IMarkupPointer ** ) PURE;
    STDMETHOD( CreateMarkupContainer )( THIS_ IMarkupContainer ** ) PURE;
    STDMETHOD( CreateElement )( THIS_ ELEMENT_TAG_ID, OLECHAR *, IHTMLElement ** ) PURE;
    STDMETHOD( CloneElement )( THIS_ IHTMLElement *, IHTMLElement ** ) PURE;
    STDMETHOD( InsertElement )( THIS_ IHTMLElement *, IMarkupPointer *, IMarkupPointer * ) PURE;
    STDMETHOD( RemoveElement )( THIS_ IHTMLElement * ) PURE;
    STDMETHOD( Remove )( THIS_ IMarkupPointer *, IMarkupPointer * ) PURE;
    STDMETHOD( Copy )( THIS_ IMarkupPointer *, IMarkupPointer *, IMarkupPointer * ) PURE;
    STDMETHOD( Move )( THIS_ IMarkupPointer *, IMarkupPointer *, IMarkupPointer * ) PURE;
    STDMETHOD( InsertText )( THIS_ OLECHAR *, long, IMarkupPointer * ) PURE;
    STDMETHOD( ParseString )( THIS_ OLECHAR *, DWORD, IMarkupContainer **, IMarkupPointer *, IMarkupPointer * ) PURE;
    STDMETHOD( ParseGlobal )( THIS_ HGLOBAL, DWORD, IMarkupContainer **, IMarkupPointer *, IMarkupPointer * ) PURE;
    STDMETHOD( IsScopedElement )( THIS_ IHTMLElement *, BOOL * ) PURE;
    STDMETHOD( GetElementTagId )( THIS_ IHTMLElement *, ELEMENT_TAG_ID * ) PURE;
    STDMETHOD( GetTagIDForName )( THIS_ BSTR, ELEMENT_TAG_ID * ) PURE;
    STDMETHOD( GetNameForTagID )( THIS_ ELEMENT_TAG_ID, BSTR * ) PURE;
    STDMETHOD( MovePointersToRange )( THIS_ IHTMLTxtRange *, IMarkupPointer *, IMarkupPointer * ) PURE;
    STDMETHOD( MoveRangeToPointers )( THIS_ IMarkupPointer *, IMarkupPointer *, IHTMLTxtRange * ) PURE;
    STDMETHOD( BeginUndoUnit )( THIS_ OLECHAR * ) PURE;
    STDMETHOD( EndUndoUnit )( THIS ) PURE;
};

/* IMarkupServices2 interface */
#undef INTERFACE
#define INTERFACE   IMarkupServices2
DECLARE_INTERFACE_( IMarkupServices2, IMarkupServices ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IMarkupServices methods */
    STDMETHOD( CreateMarkupPointer )( THIS_ IMarkupPointer ** ) PURE;
    STDMETHOD( CreateMarkupContainer )( THIS_ IMarkupContainer ** ) PURE;
    STDMETHOD( CreateElement )( THIS_ ELEMENT_TAG_ID, OLECHAR *, IHTMLElement ** ) PURE;
    STDMETHOD( CloneElement )( THIS_ IHTMLElement *, IHTMLElement ** ) PURE;
    STDMETHOD( InsertElement )( THIS_ IHTMLElement *, IMarkupPointer *, IMarkupPointer * ) PURE;
    STDMETHOD( RemoveElement )( THIS_ IHTMLElement * ) PURE;
    STDMETHOD( Remove )( THIS_ IMarkupPointer *, IMarkupPointer * ) PURE;
    STDMETHOD( Copy )( THIS_ IMarkupPointer *, IMarkupPointer *, IMarkupPointer * ) PURE;
    STDMETHOD( Move )( THIS_ IMarkupPointer *, IMarkupPointer *, IMarkupPointer * ) PURE;
    STDMETHOD( InsertText )( THIS_ OLECHAR *, long, IMarkupPointer * ) PURE;
    STDMETHOD( ParseString )( THIS_ OLECHAR *, DWORD, IMarkupContainer **, IMarkupPointer *, IMarkupPointer * ) PURE;
    STDMETHOD( ParseGlobal )( THIS_ HGLOBAL, DWORD, IMarkupContainer **, IMarkupPointer *, IMarkupPointer * ) PURE;
    STDMETHOD( IsScopedElement )( THIS_ IHTMLElement *, BOOL * ) PURE;
    STDMETHOD( GetElementTagId )( THIS_ IHTMLElement *, ELEMENT_TAG_ID * ) PURE;
    STDMETHOD( GetTagIDForName )( THIS_ BSTR, ELEMENT_TAG_ID * ) PURE;
    STDMETHOD( GetNameForTagID )( THIS_ ELEMENT_TAG_ID, BSTR * ) PURE;
    STDMETHOD( MovePointersToRange )( THIS_ IHTMLTxtRange *, IMarkupPointer *, IMarkupPointer * ) PURE;
    STDMETHOD( MoveRangeToPointers )( THIS_ IMarkupPointer *, IMarkupPointer *, IHTMLTxtRange * ) PURE;
    STDMETHOD( BeginUndoUnit )( THIS_ OLECHAR * ) PURE;
    STDMETHOD( EndUndoUnit )( THIS ) PURE;

    /* IMarkupServices2 methods */
    STDMETHOD( ParseGlobalEx )( THIS_ HGLOBAL, DWORD, IMarkupContainer *, IMarkupContainer **, IMarkupPointer *, IMarkupPointer * ) PURE;
    STDMETHOD( ValidateElements )( THIS_ IMarkupPointer *, IMarkupPointer *, IMarkupPointer *, IMarkupPointer *, IHTMLElement **, IHTMLElement ** ) PURE;
    STDMETHOD( SaveSegmentsToClipboard )( THIS_ ISegmentList *, DWORD ) PURE;
};

/* IMarkupContainer interface */
#undef INTERFACE
#define INTERFACE   IMarkupContainer
DECLARE_INTERFACE_( IMarkupContainer, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IMarkupContainer methods */
    STDMETHOD( OwningDoc )( THIS_ IHTMLDocument2 ** ) PURE;
};

/* IMarkupContainer2 interface */
#undef INTERFACE
#define INTERFACE   IMarkupContainer2
DECLARE_INTERFACE_( IMarkupContainer2, IMarkupContainer ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IMarkupContainer methods */
    STDMETHOD( OwningDoc )( THIS_ IHTMLDocument2 ** ) PURE;

    /* IMarkupContainer2 methods */
    STDMETHOD( CreateChangeLog )( THIS_ IHTMLChangeSink *, IHTMLChangeLog **, BOOL, BOOL ) PURE;
    STDMETHOD( RegisterForDirtyRange )( THIS_ IHTMLChangeSink *, DWORD * ) PURE;
    STDMETHOD( UnRegisterForDirtyRange )( THIS_ DWORD ) PURE;
    STDMETHOD( GetAndClearDirtyRange )( THIS_ DWORD, IMarkupPointer *, IMarkupPointer * ) PURE;
    STDMETHOD_( long, GetVersionNumber )( THIS ) PURE;
    STDMETHOD( GetMasterElement )( THIS_ IHTMLElement ** ) PURE;
};

/* IHTMLChangePlayback interface */
#undef INTERFACE
#define INTERFACE   IHTMLChangePlayback
DECLARE_INTERFACE_( IHTMLChangePlayback, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IHTMLChangePlayback methods */
    STDMETHOD( ExecChange )( THIS_ BYTE *, BOOL ) PURE;
};

/* IMarkupPointer interface */
#undef INTERFACE
#define INTERFACE   IMarkupPointer
DECLARE_INTERFACE_( IMarkupPointer, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IMarkupPointer methods */
    STDMETHOD( OwningDoc )( THIS_ IHTMLDocument2 ** ) PURE;
    STDMETHOD( Gravity )( THIS_ POINTER_GRAVITY * ) PURE;
    STDMETHOD( SetGravity )( THIS_ POINTER_GRAVITY ) PURE;
    STDMETHOD( Cling )( THIS_ BOOL * ) PURE;
    STDMETHOD( SetCling )( THIS_ BOOL ) PURE;
    STDMETHOD( Unposition )( THIS ) PURE;
    STDMETHOD( IsPositioned )( THIS_ BOOL * ) PURE;
    STDMETHOD( GetContainer )( THIS_ IMarkupContainer ** ) PURE;
    STDMETHOD( MoveAdjacentToElement )( THIS_ IHTMLElement *, ELEMENT_ADJACENCY ) PURE;
    STDMETHOD( MoveToPointer )( THIS_ IMarkupPointer * ) PURE;
    STDMETHOD( MoveToContainer )( THIS_ IMarkupContainer *, BOOL ) PURE;
    STDMETHOD( Left )( THIS_ BOOL, MARKUP_CONTEXT_TYPE *, IHTMLElement **, long *, OLECHAR * ) PURE;
    STDMETHOD( Right )( THIS_ BOOL, MARKUP_CONTEXT_TYPE *, IHTMLElement **, long *, OLECHAR * ) PURE;
    STDMETHOD( CurrentScope )( THIS_ IHTMLElement ** ) PURE;
    STDMETHOD( IsLeftOf )( THIS_ IMarkupPointer *, BOOL * ) PURE;
    STDMETHOD( IsLeftOfOrEqualTo )( THIS_ IMarkupPointer *, BOOL * ) PURE;
    STDMETHOD( IsRightOf )( THIS_ IMarkupPointer *, BOOL * ) PURE;
    STDMETHOD( IsRightOfOrEqualTo )( THIS_ IMarkupPointer *, BOOL * ) PURE;
    STDMETHOD( IsEqualTo )( THIS_ IMarkupPointer *, BOOL * ) PURE;
    STDMETHOD( MoveUnit )( THIS_ MOVEUNIT_ACTION ) PURE;
    STDMETHOD( FindText )( THIS_ OLECHAR *, DWORD, IMarkupPointer *, IMarkupPointer * ) PURE;
};

/* IMarkupPointer2 interface */
#undef INTERFACE
#define INTERFACE   IMarkupPointer2
DECLARE_INTERFACE_( IMarkupPointer2, IMarkupPointer ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IMarkupPointer methods */
    STDMETHOD( OwningDoc )( THIS_ IHTMLDocument2 ** ) PURE;
    STDMETHOD( Gravity )( THIS_ POINTER_GRAVITY * ) PURE;
    STDMETHOD( SetGravity )( THIS_ POINTER_GRAVITY ) PURE;
    STDMETHOD( Cling )( THIS_ BOOL * ) PURE;
    STDMETHOD( SetCling )( THIS_ BOOL ) PURE;
    STDMETHOD( Unposition )( THIS ) PURE;
    STDMETHOD( IsPositioned )( THIS_ BOOL * ) PURE;
    STDMETHOD( GetContainer )( THIS_ IMarkupContainer ** ) PURE;
    STDMETHOD( MoveAdjacentToElement )( THIS_ IHTMLElement *, ELEMENT_ADJACENCY ) PURE;
    STDMETHOD( MoveToPointer )( THIS_ IMarkupPointer * ) PURE;
    STDMETHOD( MoveToContainer )( THIS_ IMarkupContainer *, BOOL ) PURE;
    STDMETHOD( Left )( THIS_ BOOL, MARKUP_CONTEXT_TYPE *, IHTMLElement **, long *, OLECHAR * ) PURE;
    STDMETHOD( Right )( THIS_ BOOL, MARKUP_CONTEXT_TYPE *, IHTMLElement **, long *, OLECHAR * ) PURE;
    STDMETHOD( CurrentScope )( THIS_ IHTMLElement ** ) PURE;
    STDMETHOD( IsLeftOf )( THIS_ IMarkupPointer *, BOOL * ) PURE;
    STDMETHOD( IsLeftOfOrEqualTo )( THIS_ IMarkupPointer *, BOOL * ) PURE;
    STDMETHOD( IsRightOf )( THIS_ IMarkupPointer *, BOOL * ) PURE;
    STDMETHOD( IsRightOfOrEqualTo )( THIS_ IMarkupPointer *, BOOL * ) PURE;
    STDMETHOD( IsEqualTo )( THIS_ IMarkupPointer *, BOOL * ) PURE;
    STDMETHOD( MoveUnit )( THIS_ MOVEUNIT_ACTION ) PURE;
    STDMETHOD( FindText )( THIS_ OLECHAR *, DWORD, IMarkupPointer *, IMarkupPointer * ) PURE;

    /* IMarkupPointer2 methods */
    STDMETHOD( IsAtWordBreak )( THIS_ BOOL * ) PURE;
    STDMETHOD( GetMarkupPosition )( THIS_ long * ) PURE;
    STDMETHOD( MoveToMarkupPosition )( THIS_ IMarkupContainer *, long ) PURE;
    STDMETHOD( MoveUnitBounded )( THIS_ MOVEUNIT_ACTION, IMarkupPointer * ) PURE;
    STDMETHOD( IsInsideURL )( THIS_ IMarkupPointer *, BOOL * ) PURE;
    STDMETHOD( MoveToContent )( THIS_ IHTMLElement *, BOOL ) PURE;
};

/* IMarkupTextFrags interface */
#undef INTERFACE
#define INTERFACE   IMarkupTextFrags
DECLARE_INTERFACE_( IMarkupTextFrags, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IMarkupTextFrags methods */
    STDMETHOD( GetTextFragCount )( THIS_ long * ) PURE;
    STDMETHOD( GetTextFrag )( THIS_ long, BSTR *, IMarkupPointer * ) PURE;
    STDMETHOD( RemoveTextFrag )( THIS_ long ) PURE;
    STDMETHOD( InsertTextFrag )( THIS_ long, BSTR, IMarkupPointer * ) PURE;
    STDMETHOD( FindTextFragFromMarkupPointer )( THIS_ IMarkupPointer *, long *, BOOL * ) PURE;
};

/* IHTMLChangeLog interface */
#undef INTERFACE
#define INTERFACE   IHTMLChangeLog
DECLARE_INTERFACE_( IHTMLChangeLog, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IHTMLChangeLog methods */
    STDMETHOD( GetNextChange )( THIS_ BYTE *, long, long * ) PURE;
};

/* IHTMLChangeSink interface */
#undef INTERFACE
#define INTERFACE   IHTMLChangeSink
DECLARE_INTERFACE_( IHTMLChangeSink, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IHTMLChangeSink methods */
    STDMETHOD( Notify )( THIS ) PURE;
};

/* IXMLGenericParse interface */
#undef INTERFACE
#define INTERFACE   IXMLGenericParse
DECLARE_INTERFACE_( IXMLGenericParse, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IXMLGenericParse methods */
    STDMETHOD( SetGenericParse )( THIS_ VARIANT_BOOL ) PURE;
};

/* IHTMLEditHost interface */
#undef INTERFACE
#define INTERFACE   IHTMLEditHost
DECLARE_INTERFACE_( IHTMLEditHost, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IHTMLEditHost methods */
    STDMETHOD( SnapRect )( THIS_ IHTMLElement *, RECT *, ELEMENT_CORNER ) PURE;
};

/* IHTMLEditHost2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLEditHost2
DECLARE_INTERFACE_( IHTMLEditHost2, IHTMLEditHost ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IHTMLEditHost methods */
    STDMETHOD( SnapRect )( THIS_ IHTMLElement *, RECT *, ELEMENT_CORNER ) PURE;

    /* IHTMLEditHost2 methods */
    STDMETHOD( PreDrag )( THIS ) PURE;
};

/* ISegment interface */
#undef INTERFACE
#define INTERFACE   ISegment
DECLARE_INTERFACE_( ISegment, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* ISegment methods */
    STDMETHOD( GetPointers )( THIS_ IMarkupPointer *, IMarkupPointer * ) PURE;
};

/* ISegmentListIterator interface */
#undef INTERFACE
#define INTERFACE   ISegmentListIterator
DECLARE_INTERFACE_( ISegmentListIterator, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* ISegmentListIterator methods */
    STDMETHOD( Current )( THIS_ ISegment ** ) PURE;
    STDMETHOD( First )( THIS ) PURE;
    STDMETHOD( IsDone )( THIS ) PURE;
    STDMETHOD( Advance )( THIS ) PURE;
};

/* ISegmentList interface */
#undef INTERFACE
#define INTERFACE   ISegmentList
DECLARE_INTERFACE_( ISegmentList, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* ISegmentList methods */
    STDMETHOD( CreateIterator )( THIS_ ISegmentListIterator ** ) PURE;
    STDMETHOD( GetType )( THIS_ SELECTION_TYPE * ) PURE;
    STDMETHOD( IsEmpty )( THIS_ BOOL * ) PURE;
};

/* ISequenceNumber interface */
#undef INTERFACE
#define INTERFACE   ISequenceNumber
DECLARE_INTERFACE_( ISequenceNumber, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* ISequenceNumber methods */
    STDMETHOD( GetSequenceNumber )( THIS_ long, long * ) PURE;
};

/* IIMEServices interface */
#undef INTERFACE
#define INTERFACE   IIMEServices
DECLARE_INTERFACE_( IIMEServices, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IIMEServices methods */
    STDMETHOD( GetActiveIMM )( THIS_ IActiveIMMApp ** ) PURE;
};

/* IHTMLCaret interface */
#undef INTERFACE
#define INTERFACE   IHTMLCaret
DECLARE_INTERFACE_( IHTMLCaret, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IHTMLCaret methods */
    STDMETHOD( MoveCaretToPointer )( THIS_ IDisplayPointer *, BOOL, CARET_DIRECTION ) PURE;
    STDMETHOD( MoveCaretToPointerEx )( THIS_ IDisplayPointer *, BOOL, BOOL, CARET_DIRECTION ) PURE;
    STDMETHOD( MoveMarkupPointerToCaret )( THIS_ IMarkupPointer * ) PURE;
    STDMETHOD( MoveDisplayPointerToCaret )( THIS_ IDisplayPointer * ) PURE;
    STDMETHOD( IsVisible )( THIS_ BOOL * ) PURE;
    STDMETHOD( Show )( THIS_ BOOL ) PURE;
    STDMETHOD( Hide )( THIS ) PURE;
    STDMETHOD( InsertText )( THIS_ OLECHAR *, LONG ) PURE;
    STDMETHOD( ScrollIntoView )( THIS ) PURE;
    STDMETHOD( GetLocation )( THIS_ POINT *, BOOL ) PURE;
    STDMETHOD( GetCaretDirection )( THIS_ CARET_DIRECTION * ) PURE;
    STDMETHOD( SetCaretDirection )( THIS_ CARET_DIRECTION ) PURE;
};

/* IHighlightRenderingServices interface */
#undef INTERFACE
#define INTERFACE   IHighlightRenderingServices
DECLARE_INTERFACE_( IHighlightRenderingServices, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IHighlightRenderingServices methods */
    STDMETHOD( AddSegment )( THIS_ IDisplayPointer *, IDisplayPointer *, IHTMLRenderStyle *, IHighlightSegment ** ) PURE;
    STDMETHOD( MoveSegmentToPointers )( THIS_ IHighlightSegment *, IDisplayPointer *, IDisplayPointer * ) PURE;
    STDMETHOD( RemoveSegment )( THIS_ IHighlightSegment * ) PURE;
};

/* ISelectionServicesListener interface */
#undef INTERFACE
#define INTERFACE   ISelectionServicesListener
DECLARE_INTERFACE_( ISelectionServicesListener, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* ISelectionServicesListener methods */
    STDMETHOD( BeginSelectionUndo )( THIS ) PURE;
    STDMETHOD( EndSelectionUndo )( THIS ) PURE;
    STDMETHOD( OnSelectedElementExit )( THIS_ IMarkupPointer *, IMarkupPointer *, IMarkupPointer *, IMarkupPointer * ) PURE;
    STDMETHOD( OnChangeType )( THIS_ SELECTION_TYPE, ISelectionServicesListener * ) PURE;
    STDMETHOD( GetTypeDetail )( THIS_ BSTR * ) PURE;
};

/* ISelectionServices interface */
#undef INTERFACE
#define INTERFACE   ISelectionServices
DECLARE_INTERFACE_( ISelectionServices, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* ISelectionServices methods */
    STDMETHOD( SetSelectionType )( THIS_ SELECTION_TYPE, ISelectionServicesListener * ) PURE;
    STDMETHOD( GetMarkupContainer )( THIS_ IMarkupContainer ** ) PURE;
    STDMETHOD( AddSegment )( THIS_ IMarkupPointer *, IMarkupPointer *, ISegment ** ) PURE;
    STDMETHOD( AddElementSegment )( THIS_ IHTMLElement *, IElementSegment ** ) PURE;
    STDMETHOD( RemoveSegment )( THIS_ ISegment * ) PURE;
    STDMETHOD( GetSelectionServicesListener )( THIS_ ISelectionServicesListener ** ) PURE;
};

/* IElementSegment interface */
#undef INTERFACE
#define INTERFACE   IElementSegment
DECLARE_INTERFACE_( IElementSegment, ISegment ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* ISegment methods */
    STDMETHOD( GetPointers )( THIS_ IMarkupPointer *, IMarkupPointer * ) PURE;

    /* IElementSegment methods */
    STDMETHOD( GetElement )( THIS_ IHTMLElement ** ) PURE;
    STDMETHOD( SetPrimary )( THIS_ BOOL ) PURE;
    STDMETHOD( IsPrimary )( THIS_ BOOL * ) PURE;
};

/* IHighlightSegment interface */
#undef INTERFACE
#define INTERFACE   IHighlightSegment
DECLARE_INTERFACE_( IHighlightSegment, ISegment ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* ISegment methods */
    STDMETHOD( GetPointers )( THIS_ IMarkupPointer *, IMarkupPointer * ) PURE;
};

/* IHTMLEditDesigner interface */
#undef INTERFACE
#define INTERFACE   IHTMLEditDesigner
DECLARE_INTERFACE_( IHTMLEditDesigner, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IHTMLEditDesigner methods */
    STDMETHOD( PreHandleEvent )( THIS_ DISPID, IHTMLEventObj * ) PURE;
    STDMETHOD( PostHandleEvent )( THIS_ DISPID, IHTMLEventObj * ) PURE;
    STDMETHOD( TranslateAccelerator )( THIS_ DISPID, IHTMLEventObj * ) PURE;
    STDMETHOD( PostEditorEventNotify )( THIS_ DISPID, IHTMLEventObj * ) PURE;
};

/* IHTMLEditServices interface */
#undef INTERFACE
#define INTERFACE   IHTMLEditServices
DECLARE_INTERFACE_( IHTMLEditServices, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IHTMLEditServices methods */
    STDMETHOD( AddDesigner )( THIS_ IHTMLEditDesigner * ) PURE;
    STDMETHOD( RemoveDesigner )( THIS_ IHTMLEditDesigner * ) PURE;
    STDMETHOD( GetSelectionServices )( THIS_ IMarkupContainer *, ISelectionServices ** ) PURE;
    STDMETHOD( MoveToSelectionAnchor )( THIS_ IMarkupPointer * ) PURE;
    STDMETHOD( MoveToSelectionEnd )( THIS_ IMarkupPointer * ) PURE;
    STDMETHOD( SelectRange )( THIS_ IMarkupPointer *, IMarkupPointer *, SELECTION_TYPE ) PURE;
};

/* IHTMLEditServices2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLEditServices2
DECLARE_INTERFACE_( IHTMLEditServices2, IHTMLEditServices ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IHTMLEditServices methods */
    STDMETHOD( AddDesigner )( THIS_ IHTMLEditDesigner * ) PURE;
    STDMETHOD( RemoveDesigner )( THIS_ IHTMLEditDesigner * ) PURE;
    STDMETHOD( GetSelectionServices )( THIS_ IMarkupContainer *, ISelectionServices ** ) PURE;
    STDMETHOD( MoveToSelectionAnchor )( THIS_ IMarkupPointer * ) PURE;
    STDMETHOD( MoveToSelectionEnd )( THIS_ IMarkupPointer * ) PURE;
    STDMETHOD( SelectRange )( THIS_ IMarkupPointer *, IMarkupPointer *, SELECTION_TYPE ) PURE;

    /* IHTMLEditServices2 methods */
    STDMETHOD( MoveToSelectionAnchorEx )( THIS_ IDisplayPointer * ) PURE;
    STDMETHOD( MoveToSelectionEndEx )( THIS_ IDisplayPointer * ) PURE;
    STDMETHOD( FreezeVirtualCaretPos )( THIS_ BOOL ) PURE;
    STDMETHOD( UnFreezeVirtualCaretPos )( THIS_ BOOL ) PURE;
};

/* ILineInfo interface */
#undef INTERFACE
#define INTERFACE   ILineInfo
DECLARE_INTERFACE_( ILineInfo, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* ILineInfo methods */
    STDMETHOD( get_x )( THIS_ long * ) PURE;
    STDMETHOD( get_baseLine )( THIS_ long * ) PURE;
    STDMETHOD( get_textDescent )( THIS_ long * ) PURE;
    STDMETHOD( get_textHeight )( THIS_ long * ) PURE;
    STDMETHOD( get_lineDirection )( THIS_ LONG * ) PURE;
};

/* IHTMLComputedStyle interface */
#undef INTERFACE
#define INTERFACE   IHTMLComputedStyle
DECLARE_INTERFACE_( IHTMLComputedStyle, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IHTMLComputedStyle methods */
    STDMETHOD( get_bold )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_italic )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_underline )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_overline )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_strikeOut )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_subScript )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_superScript )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_explicitFace )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_fontWeight )( THIS_ long * ) PURE;
    STDMETHOD( get_fontSize )( THIS_ long * ) PURE;
    STDMETHOD( get_fontName )( THIS_ TCHAR * ) PURE;
    STDMETHOD( get_hasBgColor )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_textColor )( THIS_ DWORD * ) PURE;
    STDMETHOD( get_backgroundColor )( THIS_ DWORD * ) PURE;
    STDMETHOD( get_preformatted )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_direction )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_blockDirection )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( get_OL )( THIS_ VARIANT_BOOL * ) PURE;
    STDMETHOD( IsEqual )( THIS_ IHTMLComputedStyle *, VARIANT_BOOL * ) PURE;
};

/* IDisplayPointer interface */
#undef INTERFACE
#define INTERFACE   IDisplayPointer
DECLARE_INTERFACE_( IDisplayPointer, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDisplayPointer methods */
    STDMETHOD( MoveToPoint )( THIS_ POINT, COORD_SYSTEM, IHTMLElement *, DWORD, DWORD * ) PURE;
    STDMETHOD( MoveUnit )( THIS_ DISPLAY_MOVEUNIT, LONG ) PURE;
    STDMETHOD( PositionMarkupPointer )( THIS_ IMarkupPointer * ) PURE;
    STDMETHOD( MoveToPointer )( THIS_ IDisplayPointer * ) PURE;
    STDMETHOD( SetPointerGravity )( THIS_ POINTER_GRAVITY ) PURE;
    STDMETHOD( GetPointerGravity )( THIS_ POINTER_GRAVITY * ) PURE;
    STDMETHOD( SetDisplayGravity )( THIS_ DISPLAY_GRAVITY ) PURE;
    STDMETHOD( GetDisplayGravity )( THIS_ DISPLAY_GRAVITY * ) PURE;
    STDMETHOD( IsPositioned )( THIS_ BOOL * ) PURE;
    STDMETHOD( Unposition )( THIS ) PURE;
    STDMETHOD( IsEqualTo )( THIS_ IDisplayPointer *, BOOL * ) PURE;
    STDMETHOD( IsLeftOf )( THIS_ IDisplayPointer *, BOOL * ) PURE;
    STDMETHOD( IsRightOf )( THIS_ IDisplayPointer *, BOOL * ) PURE;
    STDMETHOD( IsAtBOL )( THIS_ BOOL * ) PURE;
    STDMETHOD( MoveToMarkupPointer )( THIS_ IMarkupPointer *, IDisplayPointer * ) PURE;
    STDMETHOD( ScrollIntoView )( THIS ) PURE;
    STDMETHOD( GetLineInfo )( THIS_ ILineInfo ** ) PURE;
    STDMETHOD( GetFlowElement )( THIS_ IHTMLElement ** ) PURE;
    STDMETHOD( QueryBreaks )( THIS_ DWORD * ) PURE;
};

/* IDisplayServices interface */
#undef INTERFACE
#define INTERFACE   IDisplayServices
DECLARE_INTERFACE_( IDisplayServices, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IDisplayServices methods */
    STDMETHOD( CreateDisplayPointer )( THIS_ IDisplayPointer ** ) PURE;
    STDMETHOD( TransformRect )( THIS_ RECT *, COORD_SYSTEM, COORD_SYSTEM, IHTMLElement * ) PURE;
    STDMETHOD( TransformPoint )( THIS_ POINT *, COORD_SYSTEM, COORD_SYSTEM, IHTMLElement * ) PURE;
    STDMETHOD( GetCaret )( THIS_ IHTMLCaret ** ) PURE;
    STDMETHOD( GetComputedStyle )( THIS_ IMarkupPointer *, IHTMLComputedStyle ** ) PURE;
    STDMETHOD( ScrollRectIntoView )( THIS_ IHTMLElement *, RECT ) PURE;
    STDMETHOD( HasFlowLayout )( THIS_ IHTMLElement *, BOOL * ) PURE;
};

/* IHtmlDlgSafeHelper interface */
#undef INTERFACE
#define INTERFACE   IHtmlDlgSafeHelper
DECLARE_INTERFACE_( IHtmlDlgSafeHelper, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHtmlDlgSafeHelper methods */
    STDMETHOD( choosecolordlg )( THIS_ VARIANT, VARIANT * ) PURE;
    STDMETHOD( getCharset )( THIS_ BSTR, VARIANT * ) PURE;
    STDMETHOD( get_Fonts )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_BlockFormats )( THIS_ IDispatch ** ) PURE;
};

/* IBlockFormats interface */
#undef INTERFACE
#define INTERFACE   IBlockFormats
DECLARE_INTERFACE_( IBlockFormats, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IBlockFormats methods */
    STDMETHOD( get__NewEnum )( THIS_ IUnknown ** ) PURE;
    STDMETHOD( get_Count )( THIS_ long * ) PURE;
    STDMETHOD( Item )( THIS_ VARIANT *, BSTR * ) PURE;
};

/* IFontNames interface */
#undef INTERFACE
#define INTERFACE   IFontNames
DECLARE_INTERFACE_( IFontNames, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IFontNames methods */
    STDMETHOD( get__NewEnum )( THIS_ IUnknown ** ) PURE;
    STDMETHOD( get_Count )( THIS_ long * ) PURE;
    STDMETHOD( Item )( THIS_ VARIANT *, BSTR * ) PURE;
};

/* HTMLNamespaceEvents interface */
#undef INTERFACE
#define INTERFACE   HTMLNamespaceEvents
DECLARE_INTERFACE_( HTMLNamespaceEvents, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLNamespace interface */
#undef INTERFACE
#define INTERFACE   IHTMLNamespace
DECLARE_INTERFACE_( IHTMLNamespace, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLNamespace methods */
    STDMETHOD( get_name )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_urn )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_tagNames )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_readyState )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_onreadystatechange )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_onreadystatechange )( THIS_ VARIANT * ) PURE;
    STDMETHOD( doImport )( THIS_ BSTR ) PURE;
    STDMETHOD( attachEvent )( THIS_ BSTR, IDispatch *, VARIANT_BOOL * ) PURE;
    STDMETHOD( detachEvent )( THIS_ BSTR, IDispatch * ) PURE;
};

/* IHTMLNamespaceCollection interface */
#undef INTERFACE
#define INTERFACE   IHTMLNamespaceCollection
DECLARE_INTERFACE_( IHTMLNamespaceCollection, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLNamespaceCollection methods */
    STDMETHOD( get_length )( THIS_ long * ) PURE;
    STDMETHOD( item )( THIS_ VARIANT, IDispatch ** ) PURE;
    STDMETHOD( add )( THIS_ BSTR, BSTR, VARIANT, IDispatch ** ) PURE;
};

/* DispHTMLNamespace interface */
#undef INTERFACE
#define INTERFACE   DispHTMLNamespace
DECLARE_INTERFACE_( DispHTMLNamespace, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispHTMLNamespaceCollection interface */
#undef INTERFACE
#define INTERFACE   DispHTMLNamespaceCollection
DECLARE_INTERFACE_( DispHTMLNamespaceCollection, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLPainter interface */
#undef INTERFACE
#define INTERFACE   IHTMLPainter
DECLARE_INTERFACE_( IHTMLPainter, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IHTMLPainter methods */
    STDMETHOD( Draw )( THIS_ RECT, RECT, LONG, HDC, LPVOID ) PURE;
    STDMETHOD( OnResize )( THIS_ SIZE ) PURE;
    STDMETHOD( GetPainterInfo )( THIS_ HTML_PAINTER_INFO * ) PURE;
    STDMETHOD( HitTestPoint )( THIS_ POINT, BOOL *, LONG * ) PURE;
};

/* IHTMLPainterEventInfo interface */
#undef INTERFACE
#define INTERFACE   IHTMLPainterEventInfo
DECLARE_INTERFACE_( IHTMLPainterEventInfo, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IHTMLPainterEventInfo methods */
    STDMETHOD( GetEventInfoFlags )( THIS_ long * ) PURE;
    STDMETHOD( GetEventTarget )( THIS_ IHTMLElement ** ) PURE;
    STDMETHOD( SetCursor )( THIS_ LONG ) PURE;
    STDMETHOD( StringFromPartID )( THIS_ LONG, BSTR * ) PURE;
};

/* IHTMLPainterOverlay interface */
#undef INTERFACE
#define INTERFACE   IHTMLPainterOverlay
DECLARE_INTERFACE_( IHTMLPainterOverlay, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IHTMLPainterOverlay methods */
    STDMETHOD( OnMove )( THIS_ RECT ) PURE;
};

/* IHTMLPaintSite interface */
#undef INTERFACE
#define INTERFACE   IHTMLPaintSite
DECLARE_INTERFACE_( IHTMLPaintSite, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IHTMLPaintSite methods */
    STDMETHOD( InvalidatePainterInfo )( THIS ) PURE;
    STDMETHOD( InvalidateRect )( THIS_ RECT * ) PURE;
    STDMETHOD( InvalidateRegion )( THIS_ HRGN ) PURE;
    STDMETHOD( GetDrawInfo )( THIS_ LONG, HTML_PAINT_DRAW_INFO * ) PURE;
    STDMETHOD( TransformGlobalToLocal )( THIS_ POINT, POINT * ) PURE;
    STDMETHOD( TransformLocalToGlobal )( THIS_ POINT, POINT * ) PURE;
    STDMETHOD( GetHitTestCookie )( THIS_ LONG * ) PURE;
};

/* IHTMLIPrintCollection interface */
#undef INTERFACE
#define INTERFACE   IHTMLIPrintCollection
DECLARE_INTERFACE_( IHTMLIPrintCollection, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLIPrintCollection methods */
    STDMETHOD( get_length )( THIS_ long * ) PURE;
    STDMETHOD( get__newEnum )( THIS_ IUnknown ** ) PURE;
    STDMETHOD( item )( THIS_ long, IUnknown ** ) PURE;
};

/* IEnumPrivacyRecords interface */
#undef INTERFACE
#define INTERFACE   IEnumPrivacyRecords
DECLARE_INTERFACE_( IEnumPrivacyRecords, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IEnumPrivacyRecords methods */
    STDMETHOD( Reset )( THIS ) PURE;
    STDMETHOD( GetSize )( THIS_ ULONG * ) PURE;
    STDMETHOD( GetPrivacyImpacted )( THIS_ BOOL * ) PURE;
    STDMETHOD( Next )( THIS_ BSTR *, BSTR *, LONG *, DWORD * ) PURE;
};

/* IWPCBlockedUrls interface */
#undef INTERFACE
#define INTERFACE   IWPCBlockedUrls
DECLARE_INTERFACE_( IWPCBlockedUrls, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IWPCBlockedUrls methods */
    STDMETHOD( GetCount )( THIS_ DWORD * ) PURE;
    STDMETHOD( GetUrl )( THIS_ DWORD, BSTR * ) PURE;
};

/* IHTMLDOMConstructorCollection interface */
#undef INTERFACE
#define INTERFACE   IHTMLDOMConstructorCollection
DECLARE_INTERFACE_( IHTMLDOMConstructorCollection, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLDOMConstructorCollection methods */
    STDMETHOD( get_Attr )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_BehaviorUrnsCollection )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_BookmarkCollection )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_CompatibleInfo )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_CompatibleInfoCollection )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_ControlRangeCollection )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_CSSCurrentStyleDeclaration )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_CSSRuleList )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_CSSRuleStyleDeclaration )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_CSSStyleDeclaration )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_CSSStyleRule )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_CSSStyleSheet )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_DataTransfer )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_DOMImplementation )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_Element )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_Event )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_History )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTCElementBehaviorDefaults )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLAnchorElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLAreaElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLAreasCollection )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLBaseElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLBaseFontElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLBGSoundElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLBlockElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLBodyElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLBRElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLButtonElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLCollection )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLCommentElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLDDElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLDivElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLDocument )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLDListElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLDTElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLEmbedElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLFieldSetElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLFontElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLFormElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLFrameElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLFrameSetElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLGenericElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLHeadElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLHeadingElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLHRElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLHtmlElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLIFrameElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLImageElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLInputElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLIsIndexElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLLabelElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLLegendElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLLIElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLLinkElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLMapElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLMarqueeElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLMetaElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLModelessDialog )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLNamespaceInfo )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLNamespaceInfoCollection )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLNextIdElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLNoShowElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLObjectElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLOListElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLOptionElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLParagraphElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLParamElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLPhraseElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLPluginsCollection )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLPopup )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLScriptElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLSelectElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLSpanElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLStyleElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLTableCaptionElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLTableCellElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLTableColElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLTableElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLTableRowElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLTableSectionElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLTextAreaElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLTextElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLTitleElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLUListElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_HTMLUnknownElement )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_Image )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_Location )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_NamedNodeMap )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_Navigator )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_NodeList )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_Option )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_Screen )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_Selection )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_StaticNodeList )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_Storage )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_StyleSheetList )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_StyleSheetPage )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_StyleSheetPageList )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_Text )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_TextRange )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_TextRangeCollection )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_TextRectangle )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_TextRectangleList )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_Window )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_XDomainRequest )( THIS_ IDispatch ** ) PURE;
    STDMETHOD( get_XMLHttpRequest )( THIS_ IDispatch ** ) PURE;
};

/* IHTMLDialog interface */
#undef INTERFACE
#define INTERFACE   IHTMLDialog
DECLARE_INTERFACE_( IHTMLDialog, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLDialog methods */
    STDMETHOD( put_dialogTop )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_dialogTop )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_dialogLeft )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_dialogLeft )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_dialogWidth )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_dialogWidth )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_dialogHeight )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_dialogHeight )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_dialogArguments )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_menuArguments )( THIS_ VARIANT * ) PURE;
    STDMETHOD( put_returnValue )( THIS_ VARIANT ) PURE;
    STDMETHOD( get_returnValue )( THIS_ VARIANT * ) PURE;
    STDMETHOD( close )( THIS ) PURE;
    STDMETHOD( toString )( THIS_ BSTR * ) PURE;
};

/* IHTMLDialog2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLDialog2
DECLARE_INTERFACE_( IHTMLDialog2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLDialog2 methods */
    STDMETHOD( put_status )( THIS_ BSTR ) PURE;
    STDMETHOD( get_status )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_resizable )( THIS_ BSTR ) PURE;
    STDMETHOD( get_resizable )( THIS_ BSTR * ) PURE;
};

/* IHTMLDialog3 interface */
#undef INTERFACE
#define INTERFACE   IHTMLDialog3
DECLARE_INTERFACE_( IHTMLDialog3, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLDialog3 methods */
    STDMETHOD( put_unadorned )( THIS_ BSTR ) PURE;
    STDMETHOD( get_unadorned )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_dialogHide )( THIS_ BSTR ) PURE;
    STDMETHOD( get_dialogHide )( THIS_ BSTR * ) PURE;
};

/* IHTMLModelessInit interface */
#undef INTERFACE
#define INTERFACE   IHTMLModelessInit
DECLARE_INTERFACE_( IHTMLModelessInit, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLModelessInit methods */
    STDMETHOD( get_parameters )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_optionString )( THIS_ VARIANT * ) PURE;
    STDMETHOD( get_moniker )( THIS_ IUnknown ** ) PURE;
    STDMETHOD( get_document )( THIS_ IUnknown ** ) PURE;
};

/* IHTMLPopup interface */
#undef INTERFACE
#define INTERFACE   IHTMLPopup
DECLARE_INTERFACE_( IHTMLPopup, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLPopup methods */
    STDMETHOD( show )( THIS_ long, long, long, long, VARIANT * ) PURE;
    STDMETHOD( hide )( THIS ) PURE;
    STDMETHOD( get_document )( THIS_ IHTMLDocument ** ) PURE;
    STDMETHOD( get_isOpen )( THIS_ VARIANT_BOOL * ) PURE;
};

/* DispHTMLPopup interface */
#undef INTERFACE
#define INTERFACE   DispHTMLPopup
DECLARE_INTERFACE_( DispHTMLPopup, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IHTMLAppBehavior interface */
#undef INTERFACE
#define INTERFACE   IHTMLAppBehavior
DECLARE_INTERFACE_( IHTMLAppBehavior, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLAppBehavior methods */
    STDMETHOD( put_applicationName )( THIS_ BSTR ) PURE;
    STDMETHOD( get_applicationName )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_version )( THIS_ BSTR ) PURE;
    STDMETHOD( get_version )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_icon )( THIS_ BSTR ) PURE;
    STDMETHOD( get_icon )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_singleInstance )( THIS_ BSTR ) PURE;
    STDMETHOD( get_singleInstance )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_minimizeButton )( THIS_ BSTR ) PURE;
    STDMETHOD( get_minimizeButton )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_maximizeButton )( THIS_ BSTR ) PURE;
    STDMETHOD( get_maximizeButton )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_border )( THIS_ BSTR ) PURE;
    STDMETHOD( get_border )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_borderStyle )( THIS_ BSTR ) PURE;
    STDMETHOD( get_borderStyle )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_sysMenu )( THIS_ BSTR ) PURE;
    STDMETHOD( get_sysMenu )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_caption )( THIS_ BSTR ) PURE;
    STDMETHOD( get_caption )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_windowState )( THIS_ BSTR ) PURE;
    STDMETHOD( get_windowState )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_showInTaskBar )( THIS_ BSTR ) PURE;
    STDMETHOD( get_showInTaskBar )( THIS_ BSTR * ) PURE;
    STDMETHOD( get_commandLine )( THIS_ BSTR * ) PURE;
};

/* IHTMLAppBehavior2 interface */
#undef INTERFACE
#define INTERFACE   IHTMLAppBehavior2
DECLARE_INTERFACE_( IHTMLAppBehavior2, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLAppBehavior2 methods */
    STDMETHOD( put_contextMenu )( THIS_ BSTR ) PURE;
    STDMETHOD( get_contextMenu )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_innerBorder )( THIS_ BSTR ) PURE;
    STDMETHOD( get_innerBorder )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_scroll )( THIS_ BSTR ) PURE;
    STDMETHOD( get_scroll )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_scrollFlat )( THIS_ BSTR ) PURE;
    STDMETHOD( get_scrollFlat )( THIS_ BSTR * ) PURE;
    STDMETHOD( put_selection )( THIS_ BSTR ) PURE;
    STDMETHOD( get_selection )( THIS_ BSTR * ) PURE;
};

/* IHTMLAppBehavior3 interface */
#undef INTERFACE
#define INTERFACE   IHTMLAppBehavior3
DECLARE_INTERFACE_( IHTMLAppBehavior3, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;

    /* IHTMLAppBehavior3 methods */
    STDMETHOD( put_navigable )( THIS_ BSTR ) PURE;
    STDMETHOD( get_navigable )( THIS_ BSTR * ) PURE;
};

/* DispHTMLAppBehavior interface */
#undef INTERFACE
#define INTERFACE   DispHTMLAppBehavior
DECLARE_INTERFACE_( DispHTMLAppBehavior, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispIHTMLInputButtonElement interface */
#undef INTERFACE
#define INTERFACE   DispIHTMLInputButtonElement
DECLARE_INTERFACE_( DispIHTMLInputButtonElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispIHTMLInputTextElement interface */
#undef INTERFACE
#define INTERFACE   DispIHTMLInputTextElement
DECLARE_INTERFACE_( DispIHTMLInputTextElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispIHTMLInputFileElement interface */
#undef INTERFACE
#define INTERFACE   DispIHTMLInputFileElement
DECLARE_INTERFACE_( DispIHTMLInputFileElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispIHTMLOptionButtonElement interface */
#undef INTERFACE
#define INTERFACE   DispIHTMLOptionButtonElement
DECLARE_INTERFACE_( DispIHTMLOptionButtonElement, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* DispIHTMLInputImage interface */
#undef INTERFACE
#define INTERFACE   DispIHTMLInputImage
DECLARE_INTERFACE_( DispIHTMLInputImage, IDispatch ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDispatch methods */
    STDMETHOD( GetTypeInfoCount )( THIS_ UINT * ) PURE;
    STDMETHOD( GetTypeInfo )( THIS_ UINT, LCID, ITypeInfo ** ) PURE;
    STDMETHOD( GetIDsOfNames )( THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID * ) PURE;
    STDMETHOD( Invoke )( THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT * ) PURE;
};

/* IElementBehaviorFactory interface */
#undef INTERFACE
#define INTERFACE   IElementBehaviorFactory
DECLARE_INTERFACE_( IElementBehaviorFactory, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IElementBehaviorFactory methods */
    STDMETHOD( FindBehavior )( THIS_ BSTR, BSTR, IElementBehaviorSite *, IElementBehavior ** ) PURE;
};

/* IElementNamespace interface */
#undef INTERFACE
#define INTERFACE   IElementNamespace
DECLARE_INTERFACE_( IElementNamespace, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IElementNamespace methods */
    STDMETHOD( AddTag )( THIS_ BSTR, LONG ) PURE;
};

/* IElementNamespaceTable interface */
#undef INTERFACE
#define INTERFACE   IElementNamespaceTable
DECLARE_INTERFACE_( IElementNamespaceTable, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IElementNamespaceTable methods */
    STDMETHOD( AddNamespace )( THIS_ BSTR, BSTR, LONG, VARIANT * ) PURE;
};

/* IElementNamespaceFactory interface */
#undef INTERFACE
#define INTERFACE   IElementNamespaceFactory
DECLARE_INTERFACE_( IElementNamespaceFactory, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IElementNamespaceFactory methods */
    STDMETHOD( Create )( THIS_ IElementNamespace * ) PURE;
};

/* IElementNamespaceFactory2 interface */
#undef INTERFACE
#define INTERFACE   IElementNamespaceFactory2
DECLARE_INTERFACE_( IElementNamespaceFactory2, IElementNamespaceFactory ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IElementNamespaceFactory methods */
    STDMETHOD( Create )( THIS_ IElementNamespace * ) PURE;

    /* IElementNamespaceFactory2 methods */
    STDMETHOD( CreateWithImplementation )( THIS_ IElementNamespace *, BSTR ) PURE;
};

/* IElementNamespaceFactoryCallback interface */
#undef INTERFACE
#define INTERFACE   IElementNamespaceFactoryCallback
DECLARE_INTERFACE_( IElementNamespaceFactoryCallback, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IElementNamespaceFactoryCallback methods */
    STDMETHOD( Resolve )( THIS_ BSTR, BSTR, BSTR, IElementNamespace * ) PURE;
};

/* IElementBehavior interface */
#undef INTERFACE
#define INTERFACE   IElementBehavior
DECLARE_INTERFACE_( IElementBehavior, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IElementBehavior methods */
    STDMETHOD( Init )( THIS_ IElementBehaviorSite * ) PURE;
    STDMETHOD( Notify )( THIS_ LONG, VARIANT * ) PURE;
    STDMETHOD( Detach )( THIS ) PURE;
};

/* IElementBehaviorSite interface */
#undef INTERFACE
#define INTERFACE   IElementBehaviorSite
DECLARE_INTERFACE_( IElementBehaviorSite, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IElementBehaviorSite methods */
    STDMETHOD( GetElement )( THIS_ IHTMLElement ** ) PURE;
    STDMETHOD( RegisterNotification )( THIS_ LONG  ) PURE;
};

/* IElementBehaviorSiteOM interface */
#undef INTERFACE
#define INTERFACE   IElementBehaviorSiteOM
DECLARE_INTERFACE_( IElementBehaviorSiteOM, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IElementBehaviorSiteOM methods */
    STDMETHOD( RegisterEvent )( THIS_ LPOLESTR, LONG, LONG * ) PURE;
    STDMETHOD( GetEventCookie )( THIS_ LPOLESTR, LONG * ) PURE;
    STDMETHOD( FireEvent )( THIS_ LONG, IHTMLEventObj * ) PURE;
    STDMETHOD( CreateEventObject )( THIS_ IHTMLEventObj ** ) PURE;
    STDMETHOD( RegisterName )( THIS_ LPOLESTR ) PURE;
    STDMETHOD( RegisterUrn )( THIS_ LPOLESTR ) PURE;
};

/* IElementBehaviorSiteOM2 interface */
#undef INTERFACE
#define INTERFACE   IElementBehaviorSiteOM2
DECLARE_INTERFACE_( IElementBehaviorSiteOM2, IElementBehaviorSiteOM ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IElementBehaviorSiteOM methods */
    STDMETHOD( RegisterEvent )( THIS_ LPOLESTR, LONG, LONG * ) PURE;
    STDMETHOD( GetEventCookie )( THIS_ LPOLESTR, LONG * ) PURE;
    STDMETHOD( FireEvent )( THIS_ LONG, IHTMLEventObj * ) PURE;
    STDMETHOD( CreateEventObject )( THIS_ IHTMLEventObj ** ) PURE;
    STDMETHOD( RegisterName )( THIS_ LPOLESTR ) PURE;
    STDMETHOD( RegisterUrn )( THIS_ LPOLESTR ) PURE;

    /* IElementBehaviorSiteOM2 methods */
    STDMETHOD( GetDefaults )( THIS_ IHTMLElementDefaults ** ) PURE;
};

/* IElementBehaviorRender interface */
#undef INTERFACE
#define INTERFACE   IElementBehaviorRender
DECLARE_INTERFACE_( IElementBehaviorRender, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IElementBehaviorRender methods */
    STDMETHOD( Draw )( THIS_ HDC, LONG, RECT *, IUnknown * ) PURE;
    STDMETHOD( GetRenderInfo )( THIS_ LONG * ) PURE;
    STDMETHOD( HitTestPoint )( THIS_ POINT *, IUnknown *, BOOL * ) PURE;
};

/* IElementBehaviorSiteRender interface */
#undef INTERFACE
#define INTERFACE   IElementBehaviorSiteRender
DECLARE_INTERFACE_( IElementBehaviorSiteRender, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IElementBehaviorSiteRender methods */
    STDMETHOD( Invalidate )( THIS_ RECT * ) PURE;
    STDMETHOD( InvalidateRenderInfo )( THIS ) PURE;
    STDMETHOD( InvalidateStyle )( THIS ) PURE;
};

/* IElementBehaviorCategory interface */
#undef INTERFACE
#define INTERFACE   IElementBehaviorCategory
DECLARE_INTERFACE_( IElementBehaviorCategory, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IElementBehaviorCategory methods */
    STDMETHOD( GetCategory )( THIS_ LPOLESTR * ) PURE;
};

/* IElementBehaviorSiteCategory interface */
#undef INTERFACE
#define INTERFACE   IElementBehaviorSiteCategory
DECLARE_INTERFACE_( IElementBehaviorSiteCategory, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IElementBehaviorSiteCategory methods */
    STDMETHOD( GetRelatedBehaviors )( THIS_ LONG, LPOLESTR, IEnumUnknown ** ) PURE;
};

/* IElementBehaviorSubmit interface */
#undef INTERFACE
#define INTERFACE   IElementBehaviorSubmit
DECLARE_INTERFACE_( IElementBehaviorSubmit, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IElementBehaviorSubmit methods */
    STDMETHOD( GetSubmitInfo )( THIS_ IHTMLSubmitData * ) PURE;
    STDMETHOD( Reset )( THIS ) PURE;
};

/* IElementBehaviorFocus interface */
#undef INTERFACE
#define INTERFACE   IElementBehaviorFocus
DECLARE_INTERFACE_( IElementBehaviorFocus, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IElementBehaviorFocus methods */
    STDMETHOD( GetFocusRect )( THIS_ RECT * ) PURE;
};

/* IElementBehaviorLayout interface */
#undef INTERFACE
#define INTERFACE   IElementBehaviorLayout
DECLARE_INTERFACE_( IElementBehaviorLayout, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IElementBehaviorLayout methods */
    STDMETHOD( GetSize )( THIS_ LONG, SIZE, POINT *, POINT *, SIZE * ) PURE;
    STDMETHOD( GetLayoutInfo )( THIS_ LONG * ) PURE;
    STDMETHOD( GetPosition )( THIS_ LONG, POINT * ) PURE;
    STDMETHOD( MapSize )( THIS_ SIZE *, RECT * ) PURE;
};

/* IElementBehaviorLayout2 interface */
#undef INTERFACE
#define INTERFACE   IElementBehaviorLayout2
DECLARE_INTERFACE_( IElementBehaviorLayout2, IElementBehaviorLayout ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IElementBehaviorLayout methods */
    STDMETHOD( GetSize )( THIS_ LONG, SIZE, POINT *, POINT *, SIZE * ) PURE;
    STDMETHOD( GetLayoutInfo )( THIS_ LONG * ) PURE;
    STDMETHOD( GetPosition )( THIS_ LONG, POINT * ) PURE;
    STDMETHOD( MapSize )( THIS_ SIZE *, RECT * ) PURE;

    /* IElementBehaviorLayout2 methods */
    STDMETHOD( GetTextDescent )( THIS_ LONG * ) PURE;
};

/* IElementBehaviorSiteLayout interface */
#undef INTERFACE
#define INTERFACE   IElementBehaviorSiteLayout
DECLARE_INTERFACE_( IElementBehaviorSiteLayout, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IElementBehaviorSiteLayout methods */
    STDMETHOD( InvalidateLayoutInfo )( THIS ) PURE;
    STDMETHOD( InvalidateSize )( THIS ) PURE;
    STDMETHOD( GetMediaResolution )( THIS_ SIZE * ) PURE;
};

/* IElementBehaviorSiteLayout2 interface */
#undef INTERFACE
#define INTERFACE   IElementBehaviorSiteLayout2
DECLARE_INTERFACE_( IElementBehaviorSiteLayout2, IElementBehaviorSiteLayout ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IElementBehaviorSiteLayout methods */
    STDMETHOD( InvalidateLayoutInfo )( THIS ) PURE;
    STDMETHOD( InvalidateSize )( THIS ) PURE;
    STDMETHOD( GetMediaResolution )( THIS_ SIZE * ) PURE;

    /* IElementBehaviorSiteLayout2 methods */
    STDMETHOD( GetFontInfo )( THIS_ LOGFONTW * ) PURE;
};

/* IHostBehaviorInit interface */
#undef INTERFACE
#define INTERFACE   IHostBehaviorInit
DECLARE_INTERFACE_( IHostBehaviorInit, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IHostBehaviorInit methods */
    STDMETHOD( PopulateNamespaceTable )( THIS ) PURE;
};

/* C object macros */
#if (!defined( __cplusplus ) || defined( CINTERFACE )) && defined( COBJMACROS )
    #define IHTMLFiltersCollection_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLFiltersCollection_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLFiltersCollection_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLFiltersCollection_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLFiltersCollection_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLFiltersCollection_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLFiltersCollection_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLFiltersCollection_get_length( x, p ) \
        (x)->lpVtbl->get_length( x, p )
    #define IHTMLFiltersCollection_get__newEnum( x, p ) \
        (x)->lpVtbl->get__newEnum( x, p )
    #define IHTMLFiltersCollection_item( x, p1, p2 ) \
        (x)->lpVtbl->item( x, p1, p2 )
    #define IIE70DispatchEx_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IIE70DispatchEx_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IIE70DispatchEx_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IIE70DispatchEx_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IIE70DispatchEx_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IIE70DispatchEx_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IIE70DispatchEx_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IIE70DispatchEx_GetDispID( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetDispID( x, p1, p2, p3 )
    #define IIE70DispatchEx_InvokeEx( x, p1, p2, p3, p4, p5, p6, p7 ) \
        (x)->lpVtbl->InvokeEx( x, p1, p2, p3, p4, p5, p6, p7 )
    #define IIE70DispatchEx_DeleteMemberByName( x, p1, p2 ) \
        (x)->lpVtbl->DeleteMemberByName( x, p1, p2 )
    #define IIE70DispatchEx_DeleteMemberByDispID( x, p ) \
        (x)->lpVtbl->DeleteMemberByDispID( x, p )
    #define IIE70DispatchEx_GetMemberProperties( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetMemberProperties( x, p1, p2, p3 )
    #define IIE70DispatchEx_GetMemberName( x, p1, p2 ) \
        (x)->lpVtbl->GetMemberName( x, p1, p2 )
    #define IIE70DispatchEx_GetNextDispID( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetNextDispID( x, p1, p2, p3 )
    #define IIE70DispatchEx_GetNameSpaceParent( x, p ) \
        (x)->lpVtbl->GetNameSpaceParent( x, p )
    #define IIE80DispatchEx_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IIE80DispatchEx_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IIE80DispatchEx_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IIE80DispatchEx_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IIE80DispatchEx_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IIE80DispatchEx_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IIE80DispatchEx_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IIE80DispatchEx_GetDispID( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetDispID( x, p1, p2, p3 )
    #define IIE80DispatchEx_InvokeEx( x, p1, p2, p3, p4, p5, p6, p7 ) \
        (x)->lpVtbl->InvokeEx( x, p1, p2, p3, p4, p5, p6, p7 )
    #define IIE80DispatchEx_DeleteMemberByName( x, p1, p2 ) \
        (x)->lpVtbl->DeleteMemberByName( x, p1, p2 )
    #define IIE80DispatchEx_DeleteMemberByDispID( x, p ) \
        (x)->lpVtbl->DeleteMemberByDispID( x, p )
    #define IIE80DispatchEx_GetMemberProperties( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetMemberProperties( x, p1, p2, p3 )
    #define IIE80DispatchEx_GetMemberName( x, p1, p2 ) \
        (x)->lpVtbl->GetMemberName( x, p1, p2 )
    #define IIE80DispatchEx_GetNextDispID( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetNextDispID( x, p1, p2, p3 )
    #define IIE80DispatchEx_GetNameSpaceParent( x, p ) \
        (x)->lpVtbl->GetNameSpaceParent( x, p )
    #define IHTMLDOMConstructor_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLDOMConstructor_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLDOMConstructor_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLDOMConstructor_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLDOMConstructor_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLDOMConstructor_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLDOMConstructor_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLDOMConstructor_get_constructor( x, p ) \
        (x)->lpVtbl->get_constructor( x, p )
    #define IHTMLDOMConstructor_LookupGetter( x, p1, p2 ) \
        (x)->lpVtbl->LookupGetter( x, p1, p2 )
    #define IHTMLDOMConstructor_LookupSetter( x, p1, p2 ) \
        (x)->lpVtbl->LookupSetter( x, p1, p2 )
    #define IHTMLDOMConstructor_DefineGetter( x, p1, p2 ) \
        (x)->lpVtbl->DefineGetter( x, p1, p2 )
    #define IHTMLDOMConstructor_DefineSetter( x, p1, p2 ) \
        (x)->lpVtbl->DefineSetter( x, p1, p2 )
    #define IHTMLStyle_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLStyle_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLStyle_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLStyle_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLStyle_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLStyle_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLStyle_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLStyle_put_fontFamily( x, p ) \
        (x)->lpVtbl->put_fontFamily( x, p )
    #define IHTMLStyle_get_fontFamily( x, p ) \
        (x)->lpVtbl->get_fontFamily( x, p )
    #define IHTMLStyle_put_fontStyle( x, p ) \
        (x)->lpVtbl->put_fontStyle( x, p )
    #define IHTMLStyle_get_fontStyle( x, p ) \
        (x)->lpVtbl->get_fontStyle( x, p )
    #define IHTMLStyle_put_fontVariant( x, p ) \
        (x)->lpVtbl->put_fontVariant( x, p )
    #define IHTMLStyle_get_fontVariant( x, p ) \
        (x)->lpVtbl->get_fontVariant( x, p )
    #define IHTMLStyle_put_fontWeight( x, p ) \
        (x)->lpVtbl->put_fontWeight( x, p )
    #define IHTMLStyle_get_fontWeight( x, p ) \
        (x)->lpVtbl->get_fontWeight( x, p )
    #define IHTMLStyle_put_fontSize( x, p ) \
        (x)->lpVtbl->put_fontSize( x, p )
    #define IHTMLStyle_get_fontSize( x, p ) \
        (x)->lpVtbl->get_fontSize( x, p )
    #define IHTMLStyle_put_font( x, p ) \
        (x)->lpVtbl->put_font( x, p )
    #define IHTMLStyle_get_font( x, p ) \
        (x)->lpVtbl->get_font( x, p )
    #define IHTMLStyle_put_color( x, p ) \
        (x)->lpVtbl->put_color( x, p )
    #define IHTMLStyle_get_color( x, p ) \
        (x)->lpVtbl->get_color( x, p )
    #define IHTMLStyle_put_background( x, p ) \
        (x)->lpVtbl->put_background( x, p )
    #define IHTMLStyle_get_background( x, p ) \
        (x)->lpVtbl->get_background( x, p )
    #define IHTMLStyle_put_backgroundColor( x, p ) \
        (x)->lpVtbl->put_backgroundColor( x, p )
    #define IHTMLStyle_get_backgroundColor( x, p ) \
        (x)->lpVtbl->get_backgroundColor( x, p )
    #define IHTMLStyle_put_backgroundImage( x, p ) \
        (x)->lpVtbl->put_backgroundImage( x, p )
    #define IHTMLStyle_get_backgroundImage( x, p ) \
        (x)->lpVtbl->get_backgroundImage( x, p )
    #define IHTMLStyle_put_backgroundRepeat( x, p ) \
        (x)->lpVtbl->put_backgroundRepeat( x, p )
    #define IHTMLStyle_get_backgroundRepeat( x, p ) \
        (x)->lpVtbl->get_backgroundRepeat( x, p )
    #define IHTMLStyle_put_backgroundAttachment( x, p ) \
        (x)->lpVtbl->put_backgroundAttachment( x, p )
    #define IHTMLStyle_get_backgroundAttachment( x, p ) \
        (x)->lpVtbl->get_backgroundAttachment( x, p )
    #define IHTMLStyle_put_backgroundPosition( x, p ) \
        (x)->lpVtbl->put_backgroundPosition( x, p )
    #define IHTMLStyle_get_backgroundPosition( x, p ) \
        (x)->lpVtbl->get_backgroundPosition( x, p )
    #define IHTMLStyle_put_backgroundPositionX( x, p ) \
        (x)->lpVtbl->put_backgroundPositionX( x, p )
    #define IHTMLStyle_get_backgroundPositionX( x, p ) \
        (x)->lpVtbl->get_backgroundPositionX( x, p )
    #define IHTMLStyle_put_backgroundPositionY( x, p ) \
        (x)->lpVtbl->put_backgroundPositionY( x, p )
    #define IHTMLStyle_get_backgroundPositionY( x, p ) \
        (x)->lpVtbl->get_backgroundPositionY( x, p )
    #define IHTMLStyle_put_wordSpacing( x, p ) \
        (x)->lpVtbl->put_wordSpacing( x, p )
    #define IHTMLStyle_get_wordSpacing( x, p ) \
        (x)->lpVtbl->get_wordSpacing( x, p )
    #define IHTMLStyle_put_letterSpacing( x, p ) \
        (x)->lpVtbl->put_letterSpacing( x, p )
    #define IHTMLStyle_get_letterSpacing( x, p ) \
        (x)->lpVtbl->get_letterSpacing( x, p )
    #define IHTMLStyle_put_textDecoration( x, p ) \
        (x)->lpVtbl->put_textDecoration( x, p )
    #define IHTMLStyle_get_textDecoration( x, p ) \
        (x)->lpVtbl->get_textDecoration( x, p )
    #define IHTMLStyle_put_textDecorationNone( x, p ) \
        (x)->lpVtbl->put_textDecorationNone( x, p )
    #define IHTMLStyle_get_textDecorationNone( x, p ) \
        (x)->lpVtbl->get_textDecorationNone( x, p )
    #define IHTMLStyle_put_textDecorationUnderline( x, p ) \
        (x)->lpVtbl->put_textDecorationUnderline( x, p )
    #define IHTMLStyle_get_textDecorationUnderline( x, p ) \
        (x)->lpVtbl->get_textDecorationUnderline( x, p )
    #define IHTMLStyle_put_textDecorationOverline( x, p ) \
        (x)->lpVtbl->put_textDecorationOverline( x, p )
    #define IHTMLStyle_get_textDecorationOverline( x, p ) \
        (x)->lpVtbl->get_textDecorationOverline( x, p )
    #define IHTMLStyle_put_textDecorationLineThrough( x, p ) \
        (x)->lpVtbl->put_textDecorationLineThrough( x, p )
    #define IHTMLStyle_get_textDecorationLineThrough( x, p ) \
        (x)->lpVtbl->get_textDecorationLineThrough( x, p )
    #define IHTMLStyle_put_textDecorationBlink( x, p ) \
        (x)->lpVtbl->put_textDecorationBlink( x, p )
    #define IHTMLStyle_get_textDecorationBlink( x, p ) \
        (x)->lpVtbl->get_textDecorationBlink( x, p )
    #define IHTMLStyle_put_verticalAlign( x, p ) \
        (x)->lpVtbl->put_verticalAlign( x, p )
    #define IHTMLStyle_get_verticalAlign( x, p ) \
        (x)->lpVtbl->get_verticalAlign( x, p )
    #define IHTMLStyle_put_textTransform( x, p ) \
        (x)->lpVtbl->put_textTransform( x, p )
    #define IHTMLStyle_get_textTransform( x, p ) \
        (x)->lpVtbl->get_textTransform( x, p )
    #define IHTMLStyle_put_textAlign( x, p ) \
        (x)->lpVtbl->put_textAlign( x, p )
    #define IHTMLStyle_get_textAlign( x, p ) \
        (x)->lpVtbl->get_textAlign( x, p )
    #define IHTMLStyle_put_textIndent( x, p ) \
        (x)->lpVtbl->put_textIndent( x, p )
    #define IHTMLStyle_get_textIndent( x, p ) \
        (x)->lpVtbl->get_textIndent( x, p )
    #define IHTMLStyle_put_lineHeight( x, p ) \
        (x)->lpVtbl->put_lineHeight( x, p )
    #define IHTMLStyle_get_lineHeight( x, p ) \
        (x)->lpVtbl->get_lineHeight( x, p )
    #define IHTMLStyle_put_marginTop( x, p ) \
        (x)->lpVtbl->put_marginTop( x, p )
    #define IHTMLStyle_get_marginTop( x, p ) \
        (x)->lpVtbl->get_marginTop( x, p )
    #define IHTMLStyle_put_marginRight( x, p ) \
        (x)->lpVtbl->put_marginRight( x, p )
    #define IHTMLStyle_get_marginRight( x, p ) \
        (x)->lpVtbl->get_marginRight( x, p )
    #define IHTMLStyle_put_marginBottom( x, p ) \
        (x)->lpVtbl->put_marginBottom( x, p )
    #define IHTMLStyle_get_marginBottom( x, p ) \
        (x)->lpVtbl->get_marginBottom( x, p )
    #define IHTMLStyle_put_marginLeft( x, p ) \
        (x)->lpVtbl->put_marginLeft( x, p )
    #define IHTMLStyle_get_marginLeft( x, p ) \
        (x)->lpVtbl->get_marginLeft( x, p )
    #define IHTMLStyle_put_margin( x, p ) \
        (x)->lpVtbl->put_margin( x, p )
    #define IHTMLStyle_get_margin( x, p ) \
        (x)->lpVtbl->get_margin( x, p )
    #define IHTMLStyle_put_paddingTop( x, p ) \
        (x)->lpVtbl->put_paddingTop( x, p )
    #define IHTMLStyle_get_paddingTop( x, p ) \
        (x)->lpVtbl->get_paddingTop( x, p )
    #define IHTMLStyle_put_paddingRight( x, p ) \
        (x)->lpVtbl->put_paddingRight( x, p )
    #define IHTMLStyle_get_paddingRight( x, p ) \
        (x)->lpVtbl->get_paddingRight( x, p )
    #define IHTMLStyle_put_paddingBottom( x, p ) \
        (x)->lpVtbl->put_paddingBottom( x, p )
    #define IHTMLStyle_get_paddingBottom( x, p ) \
        (x)->lpVtbl->get_paddingBottom( x, p )
    #define IHTMLStyle_put_paddingLeft( x, p ) \
        (x)->lpVtbl->put_paddingLeft( x, p )
    #define IHTMLStyle_get_paddingLeft( x, p ) \
        (x)->lpVtbl->get_paddingLeft( x, p )
    #define IHTMLStyle_put_padding( x, p ) \
        (x)->lpVtbl->put_padding( x, p )
    #define IHTMLStyle_get_padding( x, p ) \
        (x)->lpVtbl->get_padding( x, p )
    #define IHTMLStyle_put_border( x, p ) \
        (x)->lpVtbl->put_border( x, p )
    #define IHTMLStyle_get_border( x, p ) \
        (x)->lpVtbl->get_border( x, p )
    #define IHTMLStyle_put_borderTop( x, p ) \
        (x)->lpVtbl->put_borderTop( x, p )
    #define IHTMLStyle_get_borderTop( x, p ) \
        (x)->lpVtbl->get_borderTop( x, p )
    #define IHTMLStyle_put_borderRight( x, p ) \
        (x)->lpVtbl->put_borderRight( x, p )
    #define IHTMLStyle_get_borderRight( x, p ) \
        (x)->lpVtbl->get_borderRight( x, p )
    #define IHTMLStyle_put_borderBottom( x, p ) \
        (x)->lpVtbl->put_borderBottom( x, p )
    #define IHTMLStyle_get_borderBottom( x, p ) \
        (x)->lpVtbl->get_borderBottom( x, p )
    #define IHTMLStyle_put_borderColor( x, p ) \
        (x)->lpVtbl->put_borderColor( x, p )
    #define IHTMLStyle_get_borderColor( x, p ) \
        (x)->lpVtbl->get_borderColor( x, p )
    #define IHTMLStyle_put_borderTopColor( x, p ) \
        (x)->lpVtbl->put_borderTopColor( x, p )
    #define IHTMLStyle_get_borderTopColor( x, p ) \
        (x)->lpVtbl->get_borderTopColor( x, p )
    #define IHTMLStyle_put_borderRightColor( x, p ) \
        (x)->lpVtbl->put_borderRightColor( x, p )
    #define IHTMLStyle_get_borderRightColor( x, p ) \
        (x)->lpVtbl->get_borderRightColor( x, p )
    #define IHTMLStyle_put_borderBottomColor( x, p ) \
        (x)->lpVtbl->put_borderBottomColor( x, p )
    #define IHTMLStyle_get_borderBottomColor( x, p ) \
        (x)->lpVtbl->get_borderBottomColor( x, p )
    #define IHTMLStyle_put_borderLeftColor( x, p ) \
        (x)->lpVtbl->put_borderLeftColor( x, p ) 
    #define IHTMLStyle_get_borderLeftColor( x, p ) \
        (x)->lpVtbl->get_borderLeftColor( x, p )
    #define IHTMLStyle_put_borderWidth( x, p ) \
        (x)->lpVtbl->put_borderWidth( x, p )
    #define IHTMLStyle_get_borderWidth( x, p ) \
        (x)->lpVtbl->get_borderWidth( x, p )
    #define IHTMLStyle_put_borderTopWidth( x, p ) \
        (x)->lpVtbl->put_borderTopWidth( x, p )
    #define IHTMLStyle_get_borderTopWidth( x, p ) \
        (x)->lpVtbl->get_borderTopWidth( x, p )
    #define IHTMLStyle_put_borderRightWidth( x, p ) \
        (x)->lpVtbl->put_borderRightWidth( x, p )
    #define IHTMLStyle_get_borderRightWidth( x, p ) \
        (x)->lpVtbl->get_borderRightWidth( x, p )
    #define IHTMLStyle_put_borderBottomWidth( x, p ) \
        (x)->lpVtbl->put_borderBottomWidth( x, p )
    #define IHTMLStyle_get_borderBottomWidth( x, p ) \
        (x)->lpVtbl->get_borderBottomWidth( x, p )
    #define IHTMLStyle_put_borderLeftWidth( x, p ) \
        (x)->lpVtbl->put_borderLeftWidth( x, p )
    #define IHTMLStyle_get_borderLeftWidth( x, p ) \
        (x)->lpVtbl->get_borderLeftWidth( x, p )
    #define IHTMLStyle_put_borderStyle( x, p ) \
        (x)->lpVtbl->put_borderStyle( x, p )
    #define IHTMLStyle_get_borderStyle( x, p ) \
        (x)->lpVtbl->get_borderStyle( x, p )
    #define IHTMLStyle_put_borderTopStyle( x, p ) \
        (x)->lpVtbl->put_borderTopStyle( x, p )
    #define IHTMLStyle_get_borderTopStyle( x, p ) \
        (x)->lpVtbl->get_borderTopStyle( x, p )
    #define IHTMLStyle_put_borderRightStyle( x, p ) \
        (x)->lpVtbl->put_borderRightStyle( x, p )
    #define IHTMLStyle_get_borderRightStyle( x, p ) \
        (x)->lpVtbl->get_borderRightStyle( x, p )
    #define IHTMLStyle_put_borderBottomStyle( x, p ) \
        (x)->lpVtbl->put_borderBottomStyle( x, p )
    #define IHTMLStyle_get_borderBottomStyle( x, p ) \
        (x)->lpVtbl->get_borderBottomStyle( x, p )
    #define IHTMLStyle_put_borderLeftStyle( x, p ) \
        (x)->lpVtbl->put_borderLeftStyle( x, p )
    #define IHTMLStyle_get_borderLeftStyle( x, p ) \
        (x)->lpVtbl->get_borderLeftStyle( x, p )
    #define IHTMLStyle_put_width( x, p ) \
        (x)->lpVtbl->put_width( x, p )
    #define IHTMLStyle_get_width( x, p ) \
        (x)->lpVtbl->get_width( x, p )
    #define IHTMLStyle_put_height( x, p ) \
        (x)->lpVtbl->put_height( x, p )
    #define IHTMLStyle_get_height( x, p ) \
        (x)->lpVtbl->get_height( x, p )
    #define IHTMLStyle_put_styleFloat( x, p ) \
        (x)->lpVtbl->put_styleFloat( x, p )
    #define IHTMLStyle_get_styleFloat( x, p ) \
        (x)->lpVtbl->get_styleFloat( x, p )
    #define IHTMLStyle_put_clear( x, p ) \
        (x)->lpVtbl->put_clear( x, p )
    #define IHTMLStyle_get_clear( x, p ) \
        (x)->lpVtbl->get_clear( x, p )
    #define IHTMLStyle_put_display( x, p ) \
        (x)->lpVtbl->put_display( x, p )
    #define IHTMLStyle_get_display( x, p ) \
        (x)->lpVtbl->get_display( x, p )
    #define IHTMLStyle_put_visibility( x, p ) \
        (x)->lpVtbl->put_visibility( x, p )
    #define IHTMLStyle_get_visibility( x, p ) \
        (x)->lpVtbl->get_visibility( x, p )
    #define IHTMLStyle_put_listStyleType( x, p ) \
        (x)->lpVtbl->put_listStyleType( x, p )
    #define IHTMLStyle_get_listStyleType( x, p ) \
        (x)->lpVtbl->get_listStyleType( x, p )
    #define IHTMLStyle_put_listStylePosition( x, p ) \
        (x)->lpVtbl->put_listStylePosition( x, p )
    #define IHTMLStyle_get_listStylePosition( x, p ) \
        (x)->lpVtbl->get_listStylePosition( x, p )
    #define IHTMLStyle_put_listStyleImage( x, p ) \
        (x)->lpVtbl->put_listStyleImage( x, p )
    #define IHTMLStyle_get_listStyleImage( x, p ) \
        (x)->lpVtbl->get_listStyleImage( x, p )
    #define IHTMLStyle_put_listStyle( x, p ) \
        (x)->lpVtbl->put_listStyle( x, p )
    #define IHTMLStyle_get_listStyle( x, p ) \
        (x)->lpVtbl->get_listStyle( x, p )
    #define IHTMLStyle_put_whiteSpace( x, p ) \
        (x)->lpVtbl->put_whiteSpace( x, p )
    #define IHTMLStyle_get_whiteSpace( x, p ) \
        (x)->lpVtbl->get_whiteSpace( x, p )
    #define IHTMLStyle_put_top( x, p ) \
        (x)->lpVtbl->put_top( x, p )
    #define IHTMLStyle_get_top( x, p ) \
        (x)->lpVtbl->get_top( x, p )
    #define IHTMLStyle_put_left( x, p ) \
        (x)->lpVtbl->put_left( x, p )
    #define IHTMLStyle_get_left( x, p ) \
        (x)->lpVtbl->get_left( x, p )
    #define IHTMLStyle_get_position( x, p ) \
        (x)->lpVtbl->get_position( x, p )
    #define IHTMLStyle_put_zIndex( x, p ) \
        (x)->lpVtbl->put_zIndex( x, p )
    #define IHTMLStyle_get_zIndex( x, p ) \
        (x)->lpVtbl->get_zIndex( x, p )
    #define IHTMLStyle_put_overflow( x, p ) \
        (x)->lpVtbl->put_overflow( x, p )
    #define IHTMLStyle_get_overflow( x, p ) \
        (x)->lpVtbl->get_overflow( x, p )
    #define IHTMLStyle_put_pageBreakBefore( x, p ) \
        (x)->lpVtbl->put_pageBreakBefore( x, p )
    #define IHTMLStyle_get_pageBreakBefore( x, p ) \
        (x)->lpVtbl->get_pageBreakBefore( x, p )
    #define IHTMLStyle_put_pageBreakAfter( x, p ) \
        (x)->lpVtbl->put_pageBreakAfter( x, p )
    #define IHTMLStyle_get_pageBreakAfter( x, p ) \
        (x)->lpVtbl->get_pageBreakAfter( x, p )
    #define IHTMLStyle_put_cssText( x, p ) \
        (x)->lpVtbl->put_cssText( x, p )
    #define IHTMLStyle_get_cssText( x, p ) \
        (x)->lpVtbl->get_cssText( x, p )
    #define IHTMLStyle_put_pixelTop( x, p ) \
        (x)->lpVtbl->put_pixelTop( x, p )
    #define IHTMLStyle_get_pixelTop( x, p ) \
        (x)->lpVtbl->get_pixelTop( x, p )
    #define IHTMLStyle_put_pixelLeft( x, p ) \
        (x)->lpVtbl->put_pixelLeft( x, p )
    #define IHTMLStyle_get_pixelLeft( x, p ) \
        (x)->lpVtbl->get_pixelLeft( x, p )
    #define IHTMLStyle_put_pixelWidth( x, p ) \
        (x)->lpVtbl->put_pixelWidth( x, p )
    #define IHTMLStyle_get_pixelWidth( x, p ) \
        (x)->lpVtbl->get_pixelWidth( x, p )
    #define IHTMLStyle_put_pixelHeight( x, p ) \
        (x)->lpVtbl->put_pixelHeight( x, p )
    #define IHTMLStyle_get_pixelHeight( x, p ) \
        (x)->lpVtbl->get_pixelHeight( x, p )
    #define IHTMLStyle_put_posTop( x, p ) \
        (x)->lpVtbl->put_posTop( x, p )
    #define IHTMLStyle_get_posTop( x, p ) \
        (x)->lpVtbl->get_posTop( x, p )
    #define IHTMLStyle_put_posLeft( x, p ) \
        (x)->lpVtbl->put_posLeft( x, p )
    #define IHTMLStyle_get_posLeft( x, p ) \
        (x)->lpVtbl->get_posLeft( x, p )
    #define IHTMLStyle_put_posWidth( x, p ) \
        (x)->lpVtbl->put_posWidth( x, p )
    #define IHTMLStyle_get_posWidth( x, p ) \
        (x)->lpVtbl->get_posWidth( x, p )
    #define IHTMLStyle_put_posHeight( x, p ) \
        (x)->lpVtbl->put_posHeight( x, p )
    #define IHTMLStyle_get_posHeight( x, p ) \
        (x)->lpVtbl->get_posHeight( x, p )
    #define IHTMLStyle_put_cursor( x, p ) \
        (x)->lpVtbl->put_cursor( x, p )
    #define IHTMLStyle_get_cursor( x, p ) \
        (x)->lpVtbl->get_cursor( x, p )
    #define IHTMLStyle_put_clip( x, p ) \
        (x)->lpVtbl->put_clip( x, p )
    #define IHTMLStyle_get_clip( x, p ) \
        (x)->lpVtbl->get_clip( x, p )
    #define IHTMLStyle_put_filter( x, p ) \
        (x)->lpVtbl->put_filter( x, p )
    #define IHTMLStyle_get_filter( x, p ) \
        (x)->lpVtbl->get_filter( x, p )
    #define IHTMLStyle_setAttribute( x, p1, p2, p3 ) \
        (x)->lpVtbl->setAttribute( x, p1, p2, p3 )
    #define IHTMLStyle_getAttribute( x, p1, p2, p3 ) \
        (x)->lpVtbl->getAttribute( x, p1, p2, p3 )
    #define IHTMLStyle_removeAttribute( x, p1, p2, p3 ) \
        (x)->lpVtbl->removeAttribute( x, p1, p2, p3 )
    #define IHTMLStyle_toString( x, p ) \
        (x)->lpVtbl->toString( x, p )
    #define IHTMLStyle2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLStyle2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLStyle2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLStyle2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLStyle2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLStyle2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLStyle2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLStyle2_put_tableLayout( x, p ) \
        (x)->lpVtbl->put_tableLayout( x, p )
    #define IHTMLStyle2_get_tableLayout( x, p ) \
        (x)->lpVtbl->get_tableLayout( x, p )
    #define IHTMLStyle2_put_borderCollapse( x, p ) \
        (x)->lpVtbl->put_borderCollapse( x, p )
    #define IHTMLStyle2_get_borderCollapse( x, p ) \
        (x)->lpVtbl->get_borderCollapse( x, p )
    #define IHTMLStyle2_put_direction( x, p ) \
        (x)->lpVtbl->put_direction( x, p )
    #define IHTMLStyle2_get_direction( x, p ) \
        (x)->lpVtbl->get_direction( x, p )
    #define IHTMLStyle2_put_behavior( x, p ) \
        (x)->lpVtbl->put_behavior( x, p )
    #define IHTMLStyle2_get_behavior( x, p ) \
        (x)->lpVtbl->get_behavior( x, p )
    #define IHTMLStyle2_setExpression( x, p1, p2, p3 ) \
        (x)->lpVtbl->setExpression( x, p1, p2, p3 )
    #define IHTMLStyle2_getExpression( x, p1, p2 ) \
        (x)->lpVtbl->getExpression( x, p1, p2 )
    #define IHTMLStyle2_removeExpression( x, p1, p2 ) \
        (x)->lpVtbl->removeExpression( x, p1, p2 )
    #define IHTMLStyle2_put_position( x, p ) \
        (x)->lpVtbl->put_position( x, p )
    #define IHTMLStyle2_get_position( x, p ) \
        (x)->lpVtbl->get_position( x, p )
    #define IHTMLStyle2_put_unicodeBidi( x, p ) \
        (x)->lpVtbl->put_unicodeBidi( x, p )
    #define IHTMLStyle2_get_unicodeBidi( x, p ) \
        (x)->lpVtbl->get_unicodeBidi( x, p )
    #define IHTMLStyle2_put_bottom( x, p ) \
        (x)->lpVtbl->put_bottom( x, p )
    #define IHTMLStyle2_get_bottom( x, p ) \
        (x)->lpVtbl->get_bottom( x, p )
    #define IHTMLStyle2_put_right( x, p ) \
        (x)->lpVtbl->put_right( x, p )
    #define IHTMLStyle2_get_right( x, p ) \
        (x)->lpVtbl->get_right( x, p )
    #define IHTMLStyle2_put_pixelBottom( x, p ) \
        (x)->lpVtbl->put_pixelBottom( x, p )
    #define IHTMLStyle2_get_pixelBottom( x, p ) \
        (x)->lpVtbl->get_pixelBottom( x, p )
    #define IHTMLStyle2_put_pixelRight( x, p ) \
        (x)->lpVtbl->put_pixelRight( x, p )
    #define IHTMLStyle2_get_pixelRight( x, p ) \
        (x)->lpVtbl->get_pixelRight( x, p )
    #define IHTMLStyle2_put_posBottom( x, p ) \
        (x)->lpVtbl->put_posBottom( x, p )
    #define IHTMLStyle2_get_posBottom( x, p ) \
        (x)->lpVtbl->get_posBottom( x, p )
    #define IHTMLStyle2_put_posRight( x, p ) \
        (x)->lpVtbl->put_posRight( x, p )
    #define IHTMLStyle2_get_posRight( x, p ) \
        (x)->lpVtbl->get_posRight( x, p )
    #define IHTMLStyle2_put_imeMode( x, p ) \
        (x)->lpVtbl->put_imeMode( x, p )
    #define IHTMLStyle2_get_imeMode( x, p ) \
        (x)->lpVtbl->get_imeMode( x, p )
    #define IHTMLStyle2_put_rubyAlign( x, p ) \
        (x)->lpVtbl->put_rubyAlign( x, p )
    #define IHTMLStyle2_get_rubyAlign( x, p ) \
        (x)->lpVtbl->get_rubyAlign( x, p )
    #define IHTMLStyle2_put_rubyPosition( x, p ) \
        (x)->lpVtbl->put_rubyPosition( x, p )
    #define IHTMLStyle2_get_rubyPosition( x, p ) \
        (x)->lpVtbl->get_rubyPosition( x, p )
    #define IHTMLStyle2_put_rubyOverhang( x, p ) \
        (x)->lpVtbl->put_rubyOverhang( x, p )
    #define IHTMLStyle2_get_rubyOverhang( x, p ) \
        (x)->lpVtbl->get_rubyOverhang( x, p )
    #define IHTMLStyle2_put_layoutGridChar( x, p ) \
        (x)->lpVtbl->put_layoutGridChar( x, p )
    #define IHTMLStyle2_get_layoutGridChar( x, p ) \
        (x)->lpVtbl->get_layoutGridChar( x, p )
    #define IHTMLStyle2_put_layoutGridLine( x, p ) \
        (x)->lpVtbl->put_layoutGridLine( x, p )
    #define IHTMLStyle2_get_layoutGridLine( x, p ) \
        (x)->lpVtbl->get_layoutGridLine( x, p )
    #define IHTMLStyle2_put_layoutGridMode( x, p ) \
        (x)->lpVtbl->put_layoutGridMode( x, p )
    #define IHTMLStyle2_get_layoutGridMode( x, p ) \
        (x)->lpVtbl->get_layoutGridMode( x, p )
    #define IHTMLStyle2_put_layoutGridType( x, p ) \
        (x)->lpVtbl->put_layoutGridType( x, p )
    #define IHTMLStyle2_get_layoutGridType( x, p ) \
        (x)->lpVtbl->get_layoutGridType( x, p )
    #define IHTMLStyle2_put_layoutGrid( x, p ) \
        (x)->lpVtbl->put_layoutGrid( x, p )
    #define IHTMLStyle2_get_layoutGrid( x, p ) \
        (x)->lpVtbl->get_layoutGrid( x, p )
    #define IHTMLStyle2_put_wordBreak( x, p ) \
        (x)->lpVtbl->put_wordBreak( x, p )
    #define IHTMLStyle2_get_wordBreak( x, p ) \
        (x)->lpVtbl->get_wordBreak( x, p )
    #define IHTMLStyle2_put_lineBreak( x, p ) \
        (x)->lpVtbl->put_lineBreak( x, p )
    #define IHTMLStyle2_get_lineBreak( x, p ) \
        (x)->lpVtbl->get_lineBreak( x, p )
    #define IHTMLStyle2_put_textJustify( x, p ) \
        (x)->lpVtbl->put_textJustify( x, p )
    #define IHTMLStyle2_get_textJustify( x, p ) \
        (x)->lpVtbl->get_textJustify( x, p )
    #define IHTMLStyle2_put_textJustifyTrim( x, p ) \
        (x)->lpVtbl->put_textJustifyTrim( x, p )
    #define IHTMLStyle2_get_textJustifyTrim( x, p ) \
        (x)->lpVtbl->get_textJustifyTrim( x, p )
    #define IHTMLStyle2_put_textKashida( x, p ) \
        (x)->lpVtbl->put_textKashida( x, p )
    #define IHTMLStyle2_get_textKashida( x, p ) \
        (x)->lpVtbl->get_textKashida( x, p )
    #define IHTMLStyle2_put_textAutospace( x, p ) \
        (x)->lpVtbl->put_textAutospace( x, p )
    #define IHTMLStyle2_get_textAutospace( x, p ) \
        (x)->lpVtbl->get_textAutospace( x, p )
    #define IHTMLStyle2_put_overflowX( x, p ) \
        (x)->lpVtbl->put_overflowX( x, p )
    #define IHTMLStyle2_get_overflowX( x, p ) \
        (x)->lpVtbl->get_overflowX( x, p )
    #define IHTMLStyle2_put_overflowY( x, p ) \
        (x)->lpVtbl->put_overflowY( x, p )
    #define IHTMLStyle2_get_overflowY( x, p ) \
        (x)->lpVtbl->get_overflowY( x, p )
    #define IHTMLStyle2_put_accelerator( x, p ) \
        (x)->lpVtbl->put_accelerator( x, p )
    #define IHTMLStyle2_get_accelerator( x, p ) \
        (x)->lpVtbl->get_accelerator( x, p )
    #define IHTMLStyle3_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLStyle3_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLStyle3_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLStyle3_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLStyle3_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLStyle3_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLStyle3_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLStyle3_put_layoutFlow( x, p ) \
        (x)->lpVtbl->put_layoutFlow( x, p )
    #define IHTMLStyle3_get_layoutFlow( x, p ) \
        (x)->lpVtbl->get_layoutFlow( x, p )
    #define IHTMLStyle3_put_zoom( x, p ) \
        (x)->lpVtbl->put_zoom( x, p )
    #define IHTMLStyle3_get_zoom( x, p ) \
        (x)->lpVtbl->get_zoom( x, p )
    #define IHTMLStyle3_put_wordWrap( x, p ) \
        (x)->lpVtbl->put_wordWrap( x, p )
    #define IHTMLStyle3_get_wordWrap( x, p ) \
        (x)->lpVtbl->get_wordWrap( x, p )
    #define IHTMLStyle3_put_textUnderlinePosition( x, p ) \
        (x)->lpVtbl->put_textUnderlinePosition( x, p )
    #define IHTMLStyle3_get_textUnderlinePosition( x, p ) \
        (x)->lpVtbl->get_textUnderlinePosition( x, p )
    #define IHTMLStyle3_put_scrollbarBaseColor( x, p ) \
        (x)->lpVtbl->put_scrollbarBaseColor( x, p )
    #define IHTMLStyle3_get_scrollbarBaseColor( x, p ) \
        (x)->lpVtbl->get_scrollbarBaseColor( x, p )
    #define IHTMLStyle3_put_scrollbar3dLightColor( x, p ) \
        (x)->lpVtbl->put_scrollbar3dLightColor( x, p )
    #define IHTMLStyle3_get_scrollbar3dLightColor( x, p ) \
        (x)->lpVtbl->get_scrollbar3dLightColor( x, p )
    #define IHTMLStyle3_put_scrollbarShadowColor( x, p ) \
        (x)->lpVtbl->put_scrollbarShadowColor( x, p )
    #define IHTMLStyle3_get_scrollbarShadowColor( x, p ) \
        (x)->lpVtbl->get_scrollbarShadowColor( x, p )
    #define IHTMLStyle3_put_scrollbarHighlightColor( x, p ) \
        (x)->lpVtbl->put_scrollbarHighlightColor( x, p )
    #define IHTMLStyle3_get_scrollbarHighlightColor( x, p ) \
        (x)->lpVtbl->get_scrollbarHighlightColor( x, p )
    #define IHTMLStyle3_put_scrollbarDarkShadowColor( x, p ) \
        (x)->lpVtbl->put_scrollbarDarkShadowColor( x, p )
    #define IHTMLStyle3_get_scrollbarDarkShadowColor( x, p ) \
        (x)->lpVtbl->get_scrollbarDarkShadowColor( x, p )
    #define IHTMLStyle3_put_scrollbarArrowColor( x, p ) \
        (x)->lpVtbl->put_scrollbarArrowColor( x, p )
    #define IHTMLStyle3_get_scrollbarArrowColor( x, p ) \
        (x)->lpVtbl->get_scrollbarArrowColor( x, p )
    #define IHTMLStyle3_put_scrollbarTrackColor( x, p ) \
        (x)->lpVtbl->put_scrollbarTrackColor( x, p )
    #define IHTMLStyle3_get_scrollbarTrackColor( x, p ) \
        (x)->lpVtbl->get_scrollbarTrackColor( x, p )
    #define IHTMLStyle3_put_writingMode( x, p ) \
        (x)->lpVtbl->put_writingMode( x, p )
    #define IHTMLStyle3_get_writingMode( x, p ) \
        (x)->lpVtbl->get_writingMode( x, p )
    #define IHTMLStyle3_put_textAlignLast( x, p ) \
        (x)->lpVtbl->put_textAlignLast( x, p )
    #define IHTMLStyle3_get_textAlignLast( x, p ) \
        (x)->lpVtbl->get_textAlignLast( x, p )
    #define IHTMLStyle3_put_textKashidaSpace( x, p ) \
        (x)->lpVtbl->put_textKashidaSpace( x, p )
    #define IHTMLStyle3_get_textKashidaSpace( x, p ) \
        (x)->lpVtbl->get_textKashidaSpace( x, p )
    #define IHTMLStyle4_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLStyle4_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLStyle4_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLStyle4_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLStyle4_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLStyle4_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLStyle4_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLStyle4_put_textOverflow( x, p ) \
        (x)->lpVtbl->put_textOverflow( x, p )
    #define IHTMLStyle4_get_textOverflow( x, p ) \
        (x)->lpVtbl->get_textOverflow( x, p )
    #define IHTMLStyle4_put_minHeight( x, p ) \
        (x)->lpVtbl->put_minHeight( x, p )
    #define IHTMLStyle4_get_minHeight( x, p ) \
        (x)->lpVtbl->get_minHeight( x, p )
    #define IHTMLStyle5_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLStyle5_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLStyle5_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLStyle5_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLStyle5_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLStyle5_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLStyle5_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLStyle5_put_msInterpolationMode( x, p ) \
        (x)->lpVtbl->put_msInterpolationMode( x, p )
    #define IHTMLStyle5_get_msInterpolationMode( x, p ) \
        (x)->lpVtbl->get_msInterpolationMode( x, p )
    #define IHTMLStyle5_put_maxHeight( x, p ) \
        (x)->lpVtbl->put_maxHeight( x, p )
    #define IHTMLStyle5_get_maxHeight( x, p ) \
        (x)->lpVtbl->get_maxHeight( x, p )
    #define IHTMLStyle5_put_minWidth( x, p ) \
        (x)->lpVtbl->put_minWidth( x, p )
    #define IHTMLStyle5_get_minWidth( x, p ) \
        (x)->lpVtbl->get_minWidth( x, p )
    #define IHTMLStyle5_put_maxWidth( x, p ) \
        (x)->lpVtbl->put_maxWidth( x, p )
    #define IHTMLStyle5_get_maxWidth( x, p ) \
        (x)->lpVtbl->get_maxWidth( x, p )
    #define IHTMLStyle6_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLStyle6_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLStyle6_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLStyle6_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLStyle6_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLStyle6_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLStyle6_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLStyle6_put_content( x, p ) \
        (x)->lpVtbl->put_content( x, p )
    #define IHTMLStyle6_get_content( x, p ) \
        (x)->lpVtbl->get_content( x, p )
    #define IHTMLStyle6_put_captionSide( x, p ) \
        (x)->lpVtbl->put_captionSide( x, p )
    #define IHTMLStyle6_get_captionSide( x, p ) \
        (x)->lpVtbl->get_captionSide( x, p )
    #define IHTMLStyle6_put_counterIncrement( x, p ) \
        (x)->lpVtbl->put_counterIncrement( x, p )
    #define IHTMLStyle6_get_counterIncrement( x, p ) \
        (x)->lpVtbl->get_counterIncrement( x, p )
    #define IHTMLStyle6_put_counterReset( x, p ) \
        (x)->lpVtbl->put_counterReset( x, p )
    #define IHTMLStyle6_get_counterReset( x, p ) \
        (x)->lpVtbl->get_counterReset( x, p )
    #define IHTMLStyle6_put_outline( x, p ) \
        (x)->lpVtbl->put_outline( x, p )
    #define IHTMLStyle6_get_outline( x, p ) \
        (x)->lpVtbl->get_outline( x, p )
    #define IHTMLStyle6_put_outlineWidth( x, p ) \
        (x)->lpVtbl->put_outlineWidth( x, p )
    #define IHTMLStyle6_get_outlineWidth( x, p ) \
        (x)->lpVtbl->get_outlineWidth( x, p )
    #define IHTMLStyle6_put_outlineStyle( x, p ) \
        (x)->lpVtbl->put_outlineStyle( x, p )
    #define IHTMLStyle6_get_outlineStyle( x, p ) \
        (x)->lpVtbl->get_outlineStyle( x, p )
    #define IHTMLStyle6_put_outlineColor( x, p ) \
        (x)->lpVtbl->put_outlineColor( x, p )
    #define IHTMLStyle6_get_outlineColor( x, p ) \
        (x)->lpVtbl->get_outlineColor( x, p )
    #define IHTMLStyle6_put_boxSizing( x, p ) \
        (x)->lpVtbl->put_boxSizing( x, p )
    #define IHTMLStyle6_get_boxSizing( x, p ) \
        (x)->lpVtbl->get_boxSizing( x, p )
    #define IHTMLStyle6_put_borderSpacing( x, p ) \
        (x)->lpVtbl->put_borderSpacing( x, p )
    #define IHTMLStyle6_get_borderSpacing( x, p ) \
        (x)->lpVtbl->get_borderSpacing( x, p )
    #define IHTMLStyle6_put_orphans( x, p ) \
        (x)->lpVtbl->put_orphans( x, p )
    #define IHTMLStyle6_get_orphans( x, p ) \
        (x)->lpVtbl->get_orphans( x, p )
    #define IHTMLStyle6_put_widows( x, p ) \
        (x)->lpVtbl->put_widows( x, p )
    #define IHTMLStyle6_get_widows( x, p ) \
        (x)->lpVtbl->get_widows( x, p )
    #define IHTMLStyle6_put_pageBreakInside( x, p ) \
        (x)->lpVtbl->put_pageBreakInside( x, p )
    #define IHTMLStyle6_get_pageBreakInside( x, p ) \
        (x)->lpVtbl->get_pageBreakInside( x, p )
    #define IHTMLStyle6_put_emptyCells( x, p ) \
        (x)->lpVtbl->put_emptyCells( x, p )
    #define IHTMLStyle6_get_emptyCells( x, p ) \
        (x)->lpVtbl->get_emptyCells( x, p )
    #define IHTMLStyle6_put_msBlockProgression( x, p ) \
        (x)->lpVtbl->put_msBlockProgression( x, p )
    #define IHTMLStyle6_get_msBlockProgression( x, p ) \
        (x)->lpVtbl->get_msBlockProgression( x, p )
    #define IHTMLStyle6_put_quotes( x, p ) \
        (x)->lpVtbl->put_quotes( x, p )
    #define IHTMLStyle6_get_quotes( x, p ) \
        (x)->lpVtbl->get_quotes( x, p )
    #define IHTMLRuleStyle_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLRuleStyle_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLRuleStyle_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLRuleStyle_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLRuleStyle_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLRuleStyle_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLRuleStyle_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLRuleStyle_put_fontFamily( x, p ) \
        (x)->lpVtbl->put_fontFamily( x, p )
    #define IHTMLRuleStyle_get_fontFamily( x, p ) \
        (x)->lpVtbl->get_fontFamily( x, p )
    #define IHTMLRuleStyle_put_fontStyle( x, p ) \
        (x)->lpVtbl->put_fontStyle( x, p )
    #define IHTMLRuleStyle_get_fontStyle( x, p ) \
        (x)->lpVtbl->get_fontStyle( x, p )
    #define IHTMLRuleStyle_put_fontVariant( x, p ) \
        (x)->lpVtbl->put_fontVariant( x, p )
    #define IHTMLRuleStyle_get_fontVariant( x, p ) \
        (x)->lpVtbl->get_fontVariant( x, p )
    #define IHTMLRuleStyle_put_fontWeight( x, p ) \
        (x)->lpVtbl->put_fontWeight( x, p )
    #define IHTMLRuleStyle_get_fontWeight( x, p ) \
        (x)->lpVtbl->get_fontWeight( x, p )
    #define IHTMLRuleStyle_put_fontSize( x, p ) \
        (x)->lpVtbl->put_fontSize( x, p )
    #define IHTMLRuleStyle_get_fontSize( x, p ) \
        (x)->lpVtbl->get_fontSize( x, p )
    #define IHTMLRuleStyle_put_font( x, p ) \
        (x)->lpVtbl->put_font( x, p )
    #define IHTMLRuleStyle_get_font( x, p ) \
        (x)->lpVtbl->get_font( x, p )
    #define IHTMLRuleStyle_put_color( x, p ) \
        (x)->lpVtbl->put_color( x, p )
    #define IHTMLRuleStyle_get_color( x, p ) \
        (x)->lpVtbl->get_color( x, p )
    #define IHTMLRuleStyle_put_background( x, p ) \
        (x)->lpVtbl->put_background( x, p )
    #define IHTMLRuleStyle_get_background( x, p ) \
        (x)->lpVtbl->get_background( x, p )
    #define IHTMLRuleStyle_put_backgroundColor( x, p ) \
        (x)->lpVtbl->put_backgroundColor( x, p )
    #define IHTMLRuleStyle_get_backgroundColor( x, p ) \
        (x)->lpVtbl->get_backgroundColor( x, p )
    #define IHTMLRuleStyle_put_backgroundImage( x, p ) \
        (x)->lpVtbl->put_backgroundImage( x, p )
    #define IHTMLRuleStyle_get_backgroundImage( x, p ) \
        (x)->lpVtbl->get_backgroundImage( x, p )
    #define IHTMLRuleStyle_put_backgroundRepeat( x, p ) \
        (x)->lpVtbl->put_backgroundRepeat( x, p )
    #define IHTMLRuleStyle_get_backgroundRepeat( x, p ) \
        (x)->lpVtbl->get_backgroundRepeat( x, p )
    #define IHTMLRuleStyle_put_backgroundAttachment( x, p ) \
        (x)->lpVtbl->put_backgroundAttachment( x, p )
    #define IHTMLRuleStyle_get_backgroundAttachment( x, p ) \
        (x)->lpVtbl->get_backgroundAttachment( x, p )
    #define IHTMLRuleStyle_put_backgroundPosition( x, p ) \
        (x)->lpVtbl->put_backgroundPosition( x, p )
    #define IHTMLRuleStyle_get_backgroundPosition( x, p ) \
        (x)->lpVtbl->get_backgroundPosition( x, p )
    #define IHTMLRuleStyle_put_backgroundPositionX( x, p ) \
        (x)->lpVtbl->put_backgroundPositionX( x, p )
    #define IHTMLRuleStyle_get_backgroundPositionX( x, p ) \
        (x)->lpVtbl->get_backgroundPositionX( x, p )
    #define IHTMLRuleStyle_put_backgroundPositionY( x, p ) \
        (x)->lpVtbl->put_backgroundPositionY( x, p )
    #define IHTMLRuleStyle_get_backgroundPositionY( x, p ) \
        (x)->lpVtbl->get_backgroundPositionY( x, p )
    #define IHTMLRuleStyle_put_wordSpacing( x, p ) \
        (x)->lpVtbl->put_wordSpacing( x, p )
    #define IHTMLRuleStyle_get_wordSpacing( x, p ) \
        (x)->lpVtbl->get_wordSpacing( x, p )
    #define IHTMLRuleStyle_put_letterSpacing( x, p ) \
        (x)->lpVtbl->put_letterSpacing( x, p )
    #define IHTMLRuleStyle_get_letterSpacing( x, p ) \
        (x)->lpVtbl->get_letterSpacing( x, p )
    #define IHTMLRuleStyle_put_textDecoration( x, p ) \
        (x)->lpVtbl->put_textDecoration( x, p )
    #define IHTMLRuleStyle_get_textDecoration( x, p ) \
        (x)->lpVtbl->get_textDecoration( x, p )
    #define IHTMLRuleStyle_put_textDecorationNone( x, p ) \
        (x)->lpVtbl->put_textDecorationNone( x, p )
    #define IHTMLRuleStyle_get_textDecorationNone( x, p ) \
        (x)->lpVtbl->get_textDecorationNone( x, p )
    #define IHTMLRuleStyle_put_textDecorationUnderline( x, p ) \
        (x)->lpVtbl->put_textDecorationUnderline( x, p )
    #define IHTMLRuleStyle_get_textDecorationUnderline( x, p ) \
        (x)->lpVtbl->get_textDecorationUnderline( x, p )
    #define IHTMLRuleStyle_put_textDecorationOverline( x, p ) \
        (x)->lpVtbl->put_textDecorationOverline( x, p )
    #define IHTMLRuleStyle_get_textDecorationOverline( x, p ) \
        (x)->lpVtbl->get_textDecorationOverline( x, p )
    #define IHTMLRuleStyle_put_textDecorationLineThrough( x, p ) \
        (x)->lpVtbl->put_textDecorationLineThrough( x, p )
    #define IHTMLRuleStyle_get_textDecorationLineThrough( x, p ) \
        (x)->lpVtbl->get_textDecorationLineThrough( x, p )
    #define IHTMLRuleStyle_put_textDecorationBlink( x, p ) \
        (x)->lpVtbl->put_textDecorationBlink( x, p )
    #define IHTMLRuleStyle_get_textDecorationBlink( x, p ) \
        (x)->lpVtbl->get_textDecorationBlink( x, p )
    #define IHTMLRuleStyle_put_verticalAlign( x, p ) \
        (x)->lpVtbl->put_verticalAlign( x, p )
    #define IHTMLRuleStyle_get_verticalAlign( x, p ) \
        (x)->lpVtbl->get_verticalAlign( x, p )
    #define IHTMLRuleStyle_put_textTransform( x, p ) \
        (x)->lpVtbl->put_textTransform( x, p )
    #define IHTMLRuleStyle_get_textTransform( x, p ) \
        (x)->lpVtbl->get_textTransform( x, p )
    #define IHTMLRuleStyle_put_textAlign( x, p ) \
        (x)->lpVtbl->put_textAlign( x, p )
    #define IHTMLRuleStyle_get_textAlign( x, p ) \
        (x)->lpVtbl->get_textAlign( x, p )
    #define IHTMLRuleStyle_put_textIndent( x, p ) \
        (x)->lpVtbl->put_textIndent( x, p )
    #define IHTMLRuleStyle_get_textIndent( x, p ) \
        (x)->lpVtbl->get_textIndent( x, p )
    #define IHTMLRuleStyle_put_lineHeight( x, p ) \
        (x)->lpVtbl->put_lineHeight( x, p )
    #define IHTMLRuleStyle_get_lineHeight( x, p ) \
        (x)->lpVtbl->get_lineHeight( x, p )
    #define IHTMLRuleStyle_put_marginTop( x, p ) \
        (x)->lpVtbl->put_marginTop( x, p )
    #define IHTMLRuleStyle_get_marginTop( x, p ) \
        (x)->lpVtbl->get_marginTop( x, p )
    #define IHTMLRuleStyle_put_marginRight( x, p ) \
        (x)->lpVtbl->put_marginRight( x, p )
    #define IHTMLRuleStyle_get_marginRight( x, p ) \
        (x)->lpVtbl->get_marginRight( x, p )
    #define IHTMLRuleStyle_put_marginBottom( x, p ) \
        (x)->lpVtbl->put_marginBottom( x, p )
    #define IHTMLRuleStyle_get_marginBottom( x, p ) \
        (x)->lpVtbl->get_marginBottom( x, p )
    #define IHTMLRuleStyle_put_marginLeft( x, p ) \
        (x)->lpVtbl->put_marginLeft( x, p )
    #define IHTMLRuleStyle_get_marginLeft( x, p ) \
        (x)->lpVtbl->get_marginLeft( x, p )
    #define IHTMLRuleStyle_put_margin( x, p ) \
        (x)->lpVtbl->put_margin( x, p )
    #define IHTMLRuleStyle_get_margin( x, p ) \
        (x)->lpVtbl->get_margin( x, p )
    #define IHTMLRuleStyle_put_paddingTop( x, p ) \
        (x)->lpVtbl->put_paddingTop( x, p )
    #define IHTMLRuleStyle_get_paddingTop( x, p ) \
        (x)->lpVtbl->get_paddingTop( x, p )
    #define IHTMLRuleStyle_put_paddingRight( x, p ) \
        (x)->lpVtbl->put_paddingRight( x, p )
    #define IHTMLRuleStyle_get_paddingRight( x, p ) \
        (x)->lpVtbl->get_paddingRight( x, p )
    #define IHTMLRuleStyle_put_paddingBottom( x, p ) \
        (x)->lpVtbl->put_paddingBottom( x, p )
    #define IHTMLRuleStyle_get_paddingBottom( x, p ) \
        (x)->lpVtbl->get_paddingBottom( x, p )
    #define IHTMLRuleStyle_put_paddingLeft( x, p ) \
        (x)->lpVtbl->put_paddingLeft( x, p )
    #define IHTMLRuleStyle_get_paddingLeft( x, p ) \
        (x)->lpVtbl->get_paddingLeft( x, p )
    #define IHTMLRuleStyle_put_padding( x, p ) \
        (x)->lpVtbl->put_padding( x, p )
    #define IHTMLRuleStyle_get_padding( x, p ) \
        (x)->lpVtbl->get_padding( x, p )
    #define IHTMLRuleStyle_put_border( x, p ) \
        (x)->lpVtbl->put_border( x, p )
    #define IHTMLRuleStyle_get_border( x, p ) \
        (x)->lpVtbl->get_border( x, p )
    #define IHTMLRuleStyle_put_borderTop( x, p ) \
        (x)->lpVtbl->put_borderTop( x, p )
    #define IHTMLRuleStyle_get_borderTop( x, p ) \
        (x)->lpVtbl->get_borderTop( x, p )
    #define IHTMLRuleStyle_put_borderRight( x, p ) \
        (x)->lpVtbl->put_borderRight( x, p )
    #define IHTMLRuleStyle_get_borderRight( x, p ) \
        (x)->lpVtbl->get_borderRight( x, p )
    #define IHTMLRuleStyle_put_borderBottom( x, p ) \
        (x)->lpVtbl->put_borderBottom( x, p )
    #define IHTMLRuleStyle_get_borderBottom( x, p ) \
        (x)->lpVtbl->get_borderBottom( x, p )
    #define IHTMLRuleStyle_put_borderColor( x, p ) \
        (x)->lpVtbl->put_borderColor( x, p )
    #define IHTMLRuleStyle_get_borderColor( x, p ) \
        (x)->lpVtbl->get_borderColor( x, p )
    #define IHTMLRuleStyle_put_borderTopColor( x, p ) \
        (x)->lpVtbl->put_borderTopColor( x, p )
    #define IHTMLRuleStyle_get_borderTopColor( x, p ) \
        (x)->lpVtbl->get_borderTopColor( x, p )
    #define IHTMLRuleStyle_put_borderRightColor( x, p ) \
        (x)->lpVtbl->put_borderRightColor( x, p )
    #define IHTMLRuleStyle_get_borderRightColor( x, p ) \
        (x)->lpVtbl->get_borderRightColor( x, p )
    #define IHTMLRuleStyle_put_borderBottomColor( x, p ) \
        (x)->lpVtbl->put_borderBottomColor( x, p )
    #define IHTMLRuleStyle_get_borderBottomColor( x, p ) \
        (x)->lpVtbl->get_borderBottomColor( x, p )
    #define IHTMLRuleStyle_put_borderLeftColor( x, p ) \
        (x)->lpVtbl->put_borderLeftColor( x, p ) 
    #define IHTMLRuleStyle_get_borderLeftColor( x, p ) \
        (x)->lpVtbl->get_borderLeftColor( x, p )
    #define IHTMLRuleStyle_put_borderWidth( x, p ) \
        (x)->lpVtbl->put_borderWidth( x, p )
    #define IHTMLRuleStyle_get_borderWidth( x, p ) \
        (x)->lpVtbl->get_borderWidth( x, p )
    #define IHTMLRuleStyle_put_borderTopWidth( x, p ) \
        (x)->lpVtbl->put_borderTopWidth( x, p )
    #define IHTMLRuleStyle_get_borderTopWidth( x, p ) \
        (x)->lpVtbl->get_borderTopWidth( x, p )
    #define IHTMLRuleStyle_put_borderRightWidth( x, p ) \
        (x)->lpVtbl->put_borderRightWidth( x, p )
    #define IHTMLRuleStyle_get_borderRightWidth( x, p ) \
        (x)->lpVtbl->get_borderRightWidth( x, p )
    #define IHTMLRuleStyle_put_borderBottomWidth( x, p ) \
        (x)->lpVtbl->put_borderBottomWidth( x, p )
    #define IHTMLRuleStyle_get_borderBottomWidth( x, p ) \
        (x)->lpVtbl->get_borderBottomWidth( x, p )
    #define IHTMLRuleStyle_put_borderLeftWidth( x, p ) \
        (x)->lpVtbl->put_borderLeftWidth( x, p )
    #define IHTMLRuleStyle_get_borderLeftWidth( x, p ) \
        (x)->lpVtbl->get_borderLeftWidth( x, p )
    #define IHTMLRuleStyle_put_borderStyle( x, p ) \
        (x)->lpVtbl->put_borderStyle( x, p )
    #define IHTMLRuleStyle_get_borderStyle( x, p ) \
        (x)->lpVtbl->get_borderStyle( x, p )
    #define IHTMLRuleStyle_put_borderTopStyle( x, p ) \
        (x)->lpVtbl->put_borderTopStyle( x, p )
    #define IHTMLRuleStyle_get_borderTopStyle( x, p ) \
        (x)->lpVtbl->get_borderTopStyle( x, p )
    #define IHTMLRuleStyle_put_borderRightStyle( x, p ) \
        (x)->lpVtbl->put_borderRightStyle( x, p )
    #define IHTMLRuleStyle_get_borderRightStyle( x, p ) \
        (x)->lpVtbl->get_borderRightStyle( x, p )
    #define IHTMLRuleStyle_put_borderBottomStyle( x, p ) \
        (x)->lpVtbl->put_borderBottomStyle( x, p )
    #define IHTMLRuleStyle_get_borderBottomStyle( x, p ) \
        (x)->lpVtbl->get_borderBottomStyle( x, p )
    #define IHTMLRuleStyle_put_borderLeftStyle( x, p ) \
        (x)->lpVtbl->put_borderLeftStyle( x, p )
    #define IHTMLRuleStyle_get_borderLeftStyle( x, p ) \
        (x)->lpVtbl->get_borderLeftStyle( x, p )
    #define IHTMLRuleStyle_put_width( x, p ) \
        (x)->lpVtbl->put_width( x, p )
    #define IHTMLRuleStyle_get_width( x, p ) \
        (x)->lpVtbl->get_width( x, p )
    #define IHTMLRuleStyle_put_height( x, p ) \
        (x)->lpVtbl->put_height( x, p )
    #define IHTMLRuleStyle_get_height( x, p ) \
        (x)->lpVtbl->get_height( x, p )
    #define IHTMLRuleStyle_put_styleFloat( x, p ) \
        (x)->lpVtbl->put_styleFloat( x, p )
    #define IHTMLRuleStyle_get_styleFloat( x, p ) \
        (x)->lpVtbl->get_styleFloat( x, p )
    #define IHTMLRuleStyle_put_clear( x, p ) \
        (x)->lpVtbl->put_clear( x, p )
    #define IHTMLRuleStyle_get_clear( x, p ) \
        (x)->lpVtbl->get_clear( x, p )
    #define IHTMLRuleStyle_put_display( x, p ) \
        (x)->lpVtbl->put_display( x, p )
    #define IHTMLRuleStyle_get_display( x, p ) \
        (x)->lpVtbl->get_display( x, p )
    #define IHTMLRuleStyle_put_visibility( x, p ) \
        (x)->lpVtbl->put_visibility( x, p )
    #define IHTMLRuleStyle_get_visibility( x, p ) \
        (x)->lpVtbl->get_visibility( x, p )
    #define IHTMLRuleStyle_put_listStyleType( x, p ) \
        (x)->lpVtbl->put_listStyleType( x, p )
    #define IHTMLRuleStyle_get_listStyleType( x, p ) \
        (x)->lpVtbl->get_listStyleType( x, p )
    #define IHTMLRuleStyle_put_listStylePosition( x, p ) \
        (x)->lpVtbl->put_listStylePosition( x, p )
    #define IHTMLRuleStyle_get_listStylePosition( x, p ) \
        (x)->lpVtbl->get_listStylePosition( x, p )
    #define IHTMLRuleStyle_put_listStyleImage( x, p ) \
        (x)->lpVtbl->put_listStyleImage( x, p )
    #define IHTMLRuleStyle_get_listStyleImage( x, p ) \
        (x)->lpVtbl->get_listStyleImage( x, p )
    #define IHTMLRuleStyle_put_listStyle( x, p ) \
        (x)->lpVtbl->put_listStyle( x, p )
    #define IHTMLRuleStyle_get_listStyle( x, p ) \
        (x)->lpVtbl->get_listStyle( x, p )
    #define IHTMLRuleStyle_put_whiteSpace( x, p ) \
        (x)->lpVtbl->put_whiteSpace( x, p )
    #define IHTMLRuleStyle_get_whiteSpace( x, p ) \
        (x)->lpVtbl->get_whiteSpace( x, p )
    #define IHTMLRuleStyle_put_top( x, p ) \
        (x)->lpVtbl->put_top( x, p )
    #define IHTMLRuleStyle_get_top( x, p ) \
        (x)->lpVtbl->get_top( x, p )
    #define IHTMLRuleStyle_put_left( x, p ) \
        (x)->lpVtbl->put_left( x, p )
    #define IHTMLRuleStyle_get_left( x, p ) \
        (x)->lpVtbl->get_left( x, p )
    #define IHTMLRuleStyle_get_position( x, p ) \
        (x)->lpVtbl->get_position( x, p )
    #define IHTMLRuleStyle_put_zIndex( x, p ) \
        (x)->lpVtbl->put_zIndex( x, p )
    #define IHTMLRuleStyle_get_zIndex( x, p ) \
        (x)->lpVtbl->get_zIndex( x, p )
    #define IHTMLRuleStyle_put_overflow( x, p ) \
        (x)->lpVtbl->put_overflow( x, p )
    #define IHTMLRuleStyle_get_overflow( x, p ) \
        (x)->lpVtbl->get_overflow( x, p )
    #define IHTMLRuleStyle_put_pageBreakBefore( x, p ) \
        (x)->lpVtbl->put_pageBreakBefore( x, p )
    #define IHTMLRuleStyle_get_pageBreakBefore( x, p ) \
        (x)->lpVtbl->get_pageBreakBefore( x, p )
    #define IHTMLRuleStyle_put_pageBreakAfter( x, p ) \
        (x)->lpVtbl->put_pageBreakAfter( x, p )
    #define IHTMLRuleStyle_get_pageBreakAfter( x, p ) \
        (x)->lpVtbl->get_pageBreakAfter( x, p )
    #define IHTMLRuleStyle_put_cssText( x, p ) \
        (x)->lpVtbl->put_cssText( x, p )
    #define IHTMLRuleStyle_get_cssText( x, p ) \
        (x)->lpVtbl->get_cssText( x, p )
    #define IHTMLRuleStyle_put_cursor( x, p ) \
        (x)->lpVtbl->put_cursor( x, p )
    #define IHTMLRuleStyle_get_cursor( x, p ) \
        (x)->lpVtbl->get_cursor( x, p )
    #define IHTMLRuleStyle_put_clip( x, p ) \
        (x)->lpVtbl->put_clip( x, p )
    #define IHTMLRuleStyle_get_clip( x, p ) \
        (x)->lpVtbl->get_clip( x, p )
    #define IHTMLRuleStyle_put_filter( x, p ) \
        (x)->lpVtbl->put_filter( x, p )
    #define IHTMLRuleStyle_get_filter( x, p ) \
        (x)->lpVtbl->get_filter( x, p )
    #define IHTMLRuleStyle_setAttribute( x, p1, p2, p3 ) \
        (x)->lpVtbl->setAttribute( x, p1, p2, p3 )
    #define IHTMLRuleStyle_getAttribute( x, p1, p2, p3 ) \
        (x)->lpVtbl->getAttribute( x, p1, p2, p3 )
    #define IHTMLRuleStyle_removeAttribute( x, p1, p2, p3 ) \
        (x)->lpVtbl->removeAttribute( x, p1, p2, p3 )
    #define IHTMLRuleStyle_toString( x, p ) \
        (x)->lpVtbl->toString( x, p )
    #define IHTMLRuleStyle2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLRuleStyle2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLRuleStyle2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLRuleStyle2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLRuleStyle2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLRuleStyle2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLRuleStyle2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLRuleStyle2_put_tableLayout( x, p ) \
        (x)->lpVtbl->put_tableLayout( x, p )
    #define IHTMLRuleStyle2_get_tableLayout( x, p ) \
        (x)->lpVtbl->get_tableLayout( x, p )
    #define IHTMLRuleStyle2_put_borderCollapse( x, p ) \
        (x)->lpVtbl->put_borderCollapse( x, p )
    #define IHTMLRuleStyle2_get_borderCollapse( x, p ) \
        (x)->lpVtbl->get_borderCollapse( x, p )
    #define IHTMLRuleStyle2_put_direction( x, p ) \
        (x)->lpVtbl->put_direction( x, p )
    #define IHTMLRuleStyle2_get_direction( x, p ) \
        (x)->lpVtbl->get_direction( x, p )
    #define IHTMLRuleStyle2_put_behavior( x, p ) \
        (x)->lpVtbl->put_behavior( x, p )
    #define IHTMLRuleStyle2_get_behavior( x, p ) \
        (x)->lpVtbl->get_behavior( x, p )
    #define IHTMLRuleStyle2_put_position( x, p ) \
        (x)->lpVtbl->put_position( x, p )
    #define IHTMLRuleStyle2_get_position( x, p ) \
        (x)->lpVtbl->get_position( x, p )
    #define IHTMLRuleStyle2_put_unicodeBidi( x, p ) \
        (x)->lpVtbl->put_unicodeBidi( x, p )
    #define IHTMLRuleStyle2_get_unicodeBidi( x, p ) \
        (x)->lpVtbl->get_unicodeBidi( x, p )
    #define IHTMLRuleStyle2_put_bottom( x, p ) \
        (x)->lpVtbl->put_bottom( x, p )
    #define IHTMLRuleStyle2_get_bottom( x, p ) \
        (x)->lpVtbl->get_bottom( x, p )
    #define IHTMLRuleStyle2_put_right( x, p ) \
        (x)->lpVtbl->put_right( x, p )
    #define IHTMLRuleStyle2_get_right( x, p ) \
        (x)->lpVtbl->get_right( x, p )
    #define IHTMLRuleStyle2_put_pixelBottom( x, p ) \
        (x)->lpVtbl->put_pixelBottom( x, p )
    #define IHTMLRuleStyle2_get_pixelBottom( x, p ) \
        (x)->lpVtbl->get_pixelBottom( x, p )
    #define IHTMLRuleStyle2_put_pixelRight( x, p ) \
        (x)->lpVtbl->put_pixelRight( x, p )
    #define IHTMLRuleStyle2_get_pixelRight( x, p ) \
        (x)->lpVtbl->get_pixelRight( x, p )
    #define IHTMLRuleStyle2_put_posBottom( x, p ) \
        (x)->lpVtbl->put_posBottom( x, p )
    #define IHTMLRuleStyle2_get_posBottom( x, p ) \
        (x)->lpVtbl->get_posBottom( x, p )
    #define IHTMLRuleStyle2_put_posRight( x, p ) \
        (x)->lpVtbl->put_posRight( x, p )
    #define IHTMLRuleStyle2_get_posRight( x, p ) \
        (x)->lpVtbl->get_posRight( x, p )
    #define IHTMLRuleStyle2_put_imeMode( x, p ) \
        (x)->lpVtbl->put_imeMode( x, p )
    #define IHTMLRuleStyle2_get_imeMode( x, p ) \
        (x)->lpVtbl->get_imeMode( x, p )
    #define IHTMLRuleStyle2_put_rubyAlign( x, p ) \
        (x)->lpVtbl->put_rubyAlign( x, p )
    #define IHTMLRuleStyle2_get_rubyAlign( x, p ) \
        (x)->lpVtbl->get_rubyAlign( x, p )
    #define IHTMLRuleStyle2_put_rubyPosition( x, p ) \
        (x)->lpVtbl->put_rubyPosition( x, p )
    #define IHTMLRuleStyle2_get_rubyPosition( x, p ) \
        (x)->lpVtbl->get_rubyPosition( x, p )
    #define IHTMLRuleStyle2_put_rubyOverhang( x, p ) \
        (x)->lpVtbl->put_rubyOverhang( x, p )
    #define IHTMLRuleStyle2_get_rubyOverhang( x, p ) \
        (x)->lpVtbl->get_rubyOverhang( x, p )
    #define IHTMLRuleStyle2_put_layoutGridChar( x, p ) \
        (x)->lpVtbl->put_layoutGridChar( x, p )
    #define IHTMLRuleStyle2_get_layoutGridChar( x, p ) \
        (x)->lpVtbl->get_layoutGridChar( x, p )
    #define IHTMLRuleStyle2_put_layoutGridLine( x, p ) \
        (x)->lpVtbl->put_layoutGridLine( x, p )
    #define IHTMLRuleStyle2_get_layoutGridLine( x, p ) \
        (x)->lpVtbl->get_layoutGridLine( x, p )
    #define IHTMLRuleStyle2_put_layoutGridMode( x, p ) \
        (x)->lpVtbl->put_layoutGridMode( x, p )
    #define IHTMLRuleStyle2_get_layoutGridMode( x, p ) \
        (x)->lpVtbl->get_layoutGridMode( x, p )
    #define IHTMLRuleStyle2_put_layoutGridType( x, p ) \
        (x)->lpVtbl->put_layoutGridType( x, p )
    #define IHTMLRuleStyle2_get_layoutGridType( x, p ) \
        (x)->lpVtbl->get_layoutGridType( x, p )
    #define IHTMLRuleStyle2_put_layoutGrid( x, p ) \
        (x)->lpVtbl->put_layoutGrid( x, p )
    #define IHTMLRuleStyle2_get_layoutGrid( x, p ) \
        (x)->lpVtbl->get_layoutGrid( x, p )
    #define IHTMLRuleStyle2_put_textAutospace( x, p ) \
        (x)->lpVtbl->put_textAutospace( x, p )
    #define IHTMLRuleStyle2_get_textAutospace( x, p ) \
        (x)->lpVtbl->get_textAutospace( x, p )
    #define IHTMLRuleStyle2_put_wordBreak( x, p ) \
        (x)->lpVtbl->put_wordBreak( x, p )
    #define IHTMLRuleStyle2_get_wordBreak( x, p ) \
        (x)->lpVtbl->get_wordBreak( x, p )
    #define IHTMLRuleStyle2_put_lineBreak( x, p ) \
        (x)->lpVtbl->put_lineBreak( x, p )
    #define IHTMLRuleStyle2_get_lineBreak( x, p ) \
        (x)->lpVtbl->get_lineBreak( x, p )
    #define IHTMLRuleStyle2_put_textJustify( x, p ) \
        (x)->lpVtbl->put_textJustify( x, p )
    #define IHTMLRuleStyle2_get_textJustify( x, p ) \
        (x)->lpVtbl->get_textJustify( x, p )
    #define IHTMLRuleStyle2_put_textJustifyTrim( x, p ) \
        (x)->lpVtbl->put_textJustifyTrim( x, p )
    #define IHTMLRuleStyle2_get_textJustifyTrim( x, p ) \
        (x)->lpVtbl->get_textJustifyTrim( x, p )
    #define IHTMLRuleStyle2_put_textKashida( x, p ) \
        (x)->lpVtbl->put_textKashida( x, p )
    #define IHTMLRuleStyle2_get_textKashida( x, p ) \
        (x)->lpVtbl->get_textKashida( x, p )
    #define IHTMLRuleStyle2_put_overflowX( x, p ) \
        (x)->lpVtbl->put_overflowX( x, p )
    #define IHTMLRuleStyle2_get_overflowX( x, p ) \
        (x)->lpVtbl->get_overflowX( x, p )
    #define IHTMLRuleStyle2_put_overflowY( x, p ) \
        (x)->lpVtbl->put_overflowY( x, p )
    #define IHTMLRuleStyle2_get_overflowY( x, p ) \
        (x)->lpVtbl->get_overflowY( x, p )
    #define IHTMLRuleStyle2_put_accelerator( x, p ) \
        (x)->lpVtbl->put_accelerator( x, p )
    #define IHTMLRuleStyle2_get_accelerator( x, p ) \
        (x)->lpVtbl->get_accelerator( x, p )
    #define IHTMLRuleStyle3_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLRuleStyle3_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLRuleStyle3_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLRuleStyle3_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLRuleStyle3_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLRuleStyle3_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLRuleStyle3_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLRuleStyle3_put_layoutFlow( x, p ) \
        (x)->lpVtbl->put_layoutFlow( x, p )
    #define IHTMLRuleStyle3_get_layoutFlow( x, p ) \
        (x)->lpVtbl->get_layoutFlow( x, p )
    #define IHTMLRuleStyle3_put_zoom( x, p ) \
        (x)->lpVtbl->put_zoom( x, p )
    #define IHTMLRuleStyle3_get_zoom( x, p ) \
        (x)->lpVtbl->get_zoom( x, p )
    #define IHTMLRuleStyle3_put_wordWrap( x, p ) \
        (x)->lpVtbl->put_wordWrap( x, p )
    #define IHTMLRuleStyle3_get_wordWrap( x, p ) \
        (x)->lpVtbl->get_wordWrap( x, p )
    #define IHTMLRuleStyle3_put_textUnderlinePosition( x, p ) \
        (x)->lpVtbl->put_textUnderlinePosition( x, p )
    #define IHTMLRuleStyle3_get_textUnderlinePosition( x, p ) \
        (x)->lpVtbl->get_textUnderlinePosition( x, p )
    #define IHTMLRuleStyle3_put_scrollbarBaseColor( x, p ) \
        (x)->lpVtbl->put_scrollbarBaseColor( x, p )
    #define IHTMLRuleStyle3_get_scrollbarBaseColor( x, p ) \
        (x)->lpVtbl->get_scrollbarBaseColor( x, p )
    #define IHTMLRuleStyle3_put_scrollbar3dLightColor( x, p ) \
        (x)->lpVtbl->put_scrollbar3dLightColor( x, p )
    #define IHTMLRuleStyle3_get_scrollbar3dLightColor( x, p ) \
        (x)->lpVtbl->get_scrollbar3dLightColor( x, p )
    #define IHTMLRuleStyle3_put_scrollbarShadowColor( x, p ) \
        (x)->lpVtbl->put_scrollbarShadowColor( x, p )
    #define IHTMLRuleStyle3_get_scrollbarShadowColor( x, p ) \
        (x)->lpVtbl->get_scrollbarShadowColor( x, p )
    #define IHTMLRuleStyle3_put_scrollbarHighlightColor( x, p ) \
        (x)->lpVtbl->put_scrollbarHighlightColor( x, p )
    #define IHTMLRuleStyle3_get_scrollbarHighlightColor( x, p ) \
        (x)->lpVtbl->get_scrollbarHighlightColor( x, p )
    #define IHTMLRuleStyle3_put_scrollbarDarkShadowColor( x, p ) \
        (x)->lpVtbl->put_scrollbarDarkShadowColor( x, p )
    #define IHTMLRuleStyle3_get_scrollbarDarkShadowColor( x, p ) \
        (x)->lpVtbl->get_scrollbarDarkShadowColor( x, p )
    #define IHTMLRuleStyle3_put_scrollbarArrowColor( x, p ) \
        (x)->lpVtbl->put_scrollbarArrowColor( x, p )
    #define IHTMLRuleStyle3_get_scrollbarArrowColor( x, p ) \
        (x)->lpVtbl->get_scrollbarArrowColor( x, p )
    #define IHTMLRuleStyle3_put_scrollbarTrackColor( x, p ) \
        (x)->lpVtbl->put_scrollbarTrackColor( x, p )
    #define IHTMLRuleStyle3_get_scrollbarTrackColor( x, p ) \
        (x)->lpVtbl->get_scrollbarTrackColor( x, p )
    #define IHTMLRuleStyle3_put_writingMode( x, p ) \
        (x)->lpVtbl->put_writingMode( x, p )
    #define IHTMLRuleStyle3_get_writingMode( x, p ) \
        (x)->lpVtbl->get_writingMode( x, p )
    #define IHTMLRuleStyle3_put_textAlignLast( x, p ) \
        (x)->lpVtbl->put_textAlignLast( x, p )
    #define IHTMLRuleStyle3_get_textAlignLast( x, p ) \
        (x)->lpVtbl->get_textAlignLast( x, p )
    #define IHTMLRuleStyle3_put_textKashidaSpace( x, p ) \
        (x)->lpVtbl->put_textKashidaSpace( x, p )
    #define IHTMLRuleStyle3_get_textKashidaSpace( x, p ) \
        (x)->lpVtbl->get_textKashidaSpace( x, p )
    #define IHTMLRuleStyle4_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLRuleStyle4_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLRuleStyle4_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLRuleStyle4_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLRuleStyle4_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLRuleStyle4_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLRuleStyle4_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLRuleStyle4_put_textOverflow( x, p ) \
        (x)->lpVtbl->put_textOverflow( x, p )
    #define IHTMLRuleStyle4_get_textOverflow( x, p ) \
        (x)->lpVtbl->get_textOverflow( x, p )
    #define IHTMLRuleStyle4_put_minHeight( x, p ) \
        (x)->lpVtbl->put_minHeight( x, p )
    #define IHTMLRuleStyle4_get_minHeight( x, p ) \
        (x)->lpVtbl->get_minHeight( x, p )
    #define IHTMLRuleStyle5_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLRuleStyle5_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLRuleStyle5_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLRuleStyle5_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLRuleStyle5_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLRuleStyle5_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLRuleStyle5_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLRuleStyle5_put_msInterpolationMode( x, p ) \
        (x)->lpVtbl->put_msInterpolationMode( x, p )
    #define IHTMLRuleStyle5_get_msInterpolationMode( x, p ) \
        (x)->lpVtbl->get_msInterpolationMode( x, p )
    #define IHTMLRuleStyle5_put_maxHeight( x, p ) \
        (x)->lpVtbl->put_maxHeight( x, p )
    #define IHTMLRuleStyle5_get_maxHeight( x, p ) \
        (x)->lpVtbl->get_maxHeight( x, p )
    #define IHTMLRuleStyle5_put_minWidth( x, p ) \
        (x)->lpVtbl->put_minWidth( x, p )
    #define IHTMLRuleStyle5_get_minWidth( x, p ) \
        (x)->lpVtbl->get_minWidth( x, p )
    #define IHTMLRuleStyle5_put_maxWidth( x, p ) \
        (x)->lpVtbl->put_maxWidth( x, p )
    #define IHTMLRuleStyle5_get_maxWidth( x, p ) \
        (x)->lpVtbl->get_maxWidth( x, p )
    #define IHTMLRuleStyle6_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLRuleStyle6_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLRuleStyle6_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLRuleStyle6_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLRuleStyle6_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLRuleStyle6_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLRuleStyle6_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLRuleStyle6_put_content( x, p ) \
        (x)->lpVtbl->put_content( x, p )
    #define IHTMLRuleStyle6_get_content( x, p ) \
        (x)->lpVtbl->get_content( x, p )
    #define IHTMLRuleStyle6_put_captionSide( x, p ) \
        (x)->lpVtbl->put_captionSide( x, p )
    #define IHTMLRuleStyle6_get_captionSide( x, p ) \
        (x)->lpVtbl->get_captionSide( x, p )
    #define IHTMLRuleStyle6_put_counterIncrement( x, p ) \
        (x)->lpVtbl->put_counterIncrement( x, p )
    #define IHTMLRuleStyle6_get_counterIncrement( x, p ) \
        (x)->lpVtbl->get_counterIncrement( x, p )
    #define IHTMLRuleStyle6_put_counterReset( x, p ) \
        (x)->lpVtbl->put_counterReset( x, p )
    #define IHTMLRuleStyle6_get_counterReset( x, p ) \
        (x)->lpVtbl->get_counterReset( x, p )
    #define IHTMLRuleStyle6_put_outline( x, p ) \
        (x)->lpVtbl->put_outline( x, p )
    #define IHTMLRuleStyle6_get_outline( x, p ) \
        (x)->lpVtbl->get_outline( x, p )
    #define IHTMLRuleStyle6_put_outlineWidth( x, p ) \
        (x)->lpVtbl->put_outlineWidth( x, p )
    #define IHTMLRuleStyle6_get_outlineWidth( x, p ) \
        (x)->lpVtbl->get_outlineWidth( x, p )
    #define IHTMLRuleStyle6_put_outlineStyle( x, p ) \
        (x)->lpVtbl->put_outlineStyle( x, p )
    #define IHTMLRuleStyle6_get_outlineStyle( x, p ) \
        (x)->lpVtbl->get_outlineStyle( x, p )
    #define IHTMLRuleStyle6_put_outlineColor( x, p ) \
        (x)->lpVtbl->put_outlineColor( x, p )
    #define IHTMLRuleStyle6_get_outlineColor( x, p ) \
        (x)->lpVtbl->get_outlineColor( x, p )
    #define IHTMLRuleStyle6_put_boxSizing( x, p ) \
        (x)->lpVtbl->put_boxSizing( x, p )
    #define IHTMLRuleStyle6_get_boxSizing( x, p ) \
        (x)->lpVtbl->get_boxSizing( x, p )
    #define IHTMLRuleStyle6_put_borderSpacing( x, p ) \
        (x)->lpVtbl->put_borderSpacing( x, p )
    #define IHTMLRuleStyle6_get_borderSpacing( x, p ) \
        (x)->lpVtbl->get_borderSpacing( x, p )
    #define IHTMLRuleStyle6_put_orphans( x, p ) \
        (x)->lpVtbl->put_orphans( x, p )
    #define IHTMLRuleStyle6_get_orphans( x, p ) \
        (x)->lpVtbl->get_orphans( x, p )
    #define IHTMLRuleStyle6_put_widows( x, p ) \
        (x)->lpVtbl->put_widows( x, p )
    #define IHTMLRuleStyle6_get_widows( x, p ) \
        (x)->lpVtbl->get_widows( x, p )
    #define IHTMLRuleStyle6_put_pageBreakInside( x, p ) \
        (x)->lpVtbl->put_pageBreakInside( x, p )
    #define IHTMLRuleStyle6_get_pageBreakInside( x, p ) \
        (x)->lpVtbl->get_pageBreakInside( x, p )
    #define IHTMLRuleStyle6_put_emptyCells( x, p ) \
        (x)->lpVtbl->put_emptyCells( x, p )
    #define IHTMLRuleStyle6_get_emptyCells( x, p ) \
        (x)->lpVtbl->get_emptyCells( x, p )
    #define IHTMLRuleStyle6_put_msBlockProgression( x, p ) \
        (x)->lpVtbl->put_msBlockProgression( x, p )
    #define IHTMLRuleStyle6_get_msBlockProgression( x, p ) \
        (x)->lpVtbl->get_msBlockProgression( x, p )
    #define IHTMLRuleStyle6_put_quotes( x, p ) \
        (x)->lpVtbl->put_quotes( x, p )
    #define IHTMLRuleStyle6_get_quotes( x, p ) \
        (x)->lpVtbl->get_quotes( x, p )
    #define DispHTMLStyle_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLStyle_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLStyle_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLStyle_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLStyle_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLStyle_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLStyle_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define DispHTMLRuleStyle_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLRuleStyle_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLRuleStyle_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLRuleStyle_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLRuleStyle_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLRuleStyle_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLRuleStyle_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLRenderStyle_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLRenderStyle_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLRenderStyle_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLRenderStyle_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLRenderStyle_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLRenderStyle_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLRenderStyle_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLRenderStyle_put_textLineThroughStyle( x, p ) \
        (x)->lpVtbl->put_textLineThroughStyle( x, p )
    #define IHTMLRenderStyle_get_textLineThroughStyle( x, p ) \
        (x)->lpVtbl->get_textLineThroughStyle( x, p )
    #define IHTMLRenderStyle_put_textUnderlineStyle( x, p ) \
        (x)->lpVtbl->put_textUnderlineStyle( x, p )
    #define IHTMLRenderStyle_get_textUnderlineStyle( x, p ) \
        (x)->lpVtbl->get_textUnderlineStyle( x, p )
    #define IHTMLRenderStyle_put_textEffect( x, p ) \
        (x)->lpVtbl->put_textEffect( x, p )
    #define IHTMLRenderStyle_get_textEffect( x, p ) \
        (x)->lpVtbl->get_textEffect( x, p )
    #define IHTMLRenderStyle_put_textColor( x, p ) \
        (x)->lpVtbl->put_textColor( x, p )
    #define IHTMLRenderStyle_get_textColor( x, p ) \
        (x)->lpVtbl->get_textColor( x, p )
    #define IHTMLRenderStyle_put_textBackgroundColor( x, p ) \
        (x)->lpVtbl->put_textBackgroundColor( x, p )
    #define IHTMLRenderStyle_get_textBackgroundColor( x, p ) \
        (x)->lpVtbl->get_textBackgroundColor( x, p )
    #define IHTMLRenderStyle_put_textDecorationColor( x, p ) \
        (x)->lpVtbl->put_textDecorationColor( x, p )
    #define IHTMLRenderStyle_get_textDecorationColor( x, p ) \
        (x)->lpVtbl->get_textDecorationColor( x, p )
    #define IHTMLRenderStyle_put_renderingPriority( x, p ) \
        (x)->lpVtbl->put_renderingPriority( x, p )
    #define IHTMLRenderStyle_get_renderingPriority( x, p ) \
        (x)->lpVtbl->get_renderingPriority( x, p )
    #define IHTMLRenderStyle_put_defaultTextSelection( x, p ) \
        (x)->lpVtbl->put_defaultTextSelection( x, p )
    #define IHTMLRenderStyle_get_defaultTextSelection( x, p ) \
        (x)->lpVtbl->get_defaultTextSelection( x, p )
    #define IHTMLRenderStyle_put_textDecoration( x, p ) \
        (x)->lpVtbl->put_textDecoration( x, p )
    #define IHTMLRenderStyle_get_textDecoration( x, p ) \
        (x)->lpVtbl->get_textDecoration( x, p )
    #define DispHTMLRenderStyle_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLRenderStyle_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLRenderStyle_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLRenderStyle_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLRenderStyle_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLRenderStyle_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLRenderStyle_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLCurrentStyle_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLCurrentStyle_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLCurrentStyle_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLCurrentStyle_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLCurrentStyle_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLCurrentStyle_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLCurrentStyle_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLCurrentStyle_get_position( x, p ) \
        (x)->lpVtbl->get_position( x, p )
    #define IHTMLCurrentStyle_get_styleFloat( x, p ) \
        (x)->lpVtbl->get_styleFloat( x, p )
    #define IHTMLCurrentStyle_get_color( x, p ) \
        (x)->lpVtbl->get_color( x, p )
    #define IHTMLCurrentStyle_get_backgroundColor( x, p ) \
        (x)->lpVtbl->get_backgroundColor( x, p )
    #define IHTMLCurrentStyle_get_fontFamily( x, p ) \
        (x)->lpVtbl->get_fontFamily( x, p )
    #define IHTMLCurrentStyle_get_fontStyle( x, p ) \
        (x)->lpVtbl->get_fontStyle( x, p )
    #define IHTMLCurrentStyle_get_fontVariant( x, p ) \
        (x)->lpVtbl->get_fontVariant( x, p )
    #define IHTMLCurrentStyle_get_fontWeight( x, p ) \
        (x)->lpVtbl->get_fontWeight( x, p )
    #define IHTMLCurrentStyle_get_fontSize( x, p ) \
        (x)->lpVtbl->get_fontSize( x, p )
    #define IHTMLCurrentStyle_get_backgroundImage( x, p ) \
        (x)->lpVtbl->get_backgroundImage( x, p )
    #define IHTMLCurrentStyle_get_backgroundPositionX( x, p ) \
        (x)->lpVtbl->get_backgroundPositionX( x, p )
    #define IHTMLCurrentStyle_get_backgroundPositionY( x, p ) \
        (x)->lpVtbl->get_backgroundPositionY( x, p )
    #define IHTMLCurrentStyle_get_backgroundRepeat( x, p ) \
        (x)->lpVtbl->get_backgroundRepeat( x, p )
    #define IHTMLCurrentStyle_get_borderLeftColor( x, p ) \
        (x)->lpVtbl->get_borderLeftColor( x, p )
    #define IHTMLCurrentStyle_get_borderTopColor( x, p ) \
        (x)->lpVtbl->get_borderTopColor( x, p )
    #define IHTMLCurrentStyle_get_borderRightColor( x, p ) \
        (x)->lpVtbl->get_borderRightColor( x, p )
    #define IHTMLCurrentStyle_get_borderBottomColor( x, p ) \
        (x)->lpVtbl->get_borderBottomColor( x, p )
    #define IHTMLCurrentStyle_get_borderTopStyle( x, p ) \
        (x)->lpVtbl->get_borderTopStyle( x, p )
    #define IHTMLCurrentStyle_get_borderRightStyle( x, p ) \
        (x)->lpVtbl->get_borderRightStyle( x, p )
    #define IHTMLCurrentStyle_get_borderBottomStyle( x, p ) \
        (x)->lpVtbl->get_borderBottomStyle( x, p )
    #define IHTMLCurrentStyle_get_borderLeftStyle( x, p ) \
        (x)->lpVtbl->get_borderLeftStyle( x, p )
    #define IHTMLCurrentStyle_get_borderTopWidth( x, p ) \
        (x)->lpVtbl->get_borderTopWidth( x, p )
    #define IHTMLCurrentStyle_get_borderRightWidth( x, p ) \
        (x)->lpVtbl->get_borderRightWidth( x, p )
    #define IHTMLCurrentStyle_get_borderBottomWidth( x, p ) \
        (x)->lpVtbl->get_borderBottomWidth( x, p )
    #define IHTMLCurrentStyle_get_borderLeftWidth( x, p ) \
        (x)->lpVtbl->get_borderLeftWidth( x, p )
    #define IHTMLCurrentStyle_get_left( x, p ) \
        (x)->lpVtbl->get_left( x, p )
    #define IHTMLCurrentStyle_get_top( x, p ) \
        (x)->lpVtbl->get_top( x, p )
    #define IHTMLCurrentStyle_get_width( x, p ) \
        (x)->lpVtbl->get_width( x, p )
    #define IHTMLCurrentStyle_get_height( x, p ) \
        (x)->lpVtbl->get_height( x, p )
    #define IHTMLCurrentStyle_get_paddingLeft( x, p ) \
        (x)->lpVtbl->get_paddingLeft( x, p )
    #define IHTMLCurrentStyle_get_paddingTop( x, p ) \
        (x)->lpVtbl->get_paddingTop( x, p )
    #define IHTMLCurrentStyle_get_paddingRight( x, p ) \
        (x)->lpVtbl->get_paddingRight( x, p )
    #define IHTMLCurrentStyle_get_paddingBottom( x, p ) \
        (x)->lpVtbl->get_paddingBottom( x, p )
    #define IHTMLCurrentStyle_get_textAlign( x, p ) \
        (x)->lpVtbl->get_textAlign( x, p )
    #define IHTMLCurrentStyle_get_textDecoration( x, p ) \
        (x)->lpVtbl->get_textDecoration( x, p )
    #define IHTMLCurrentStyle_get_display( x, p ) \
        (x)->lpVtbl->get_display( x, p )
    #define IHTMLCurrentStyle_get_visibility( x, p ) \
        (x)->lpVtbl->get_visibility( x, p )
    #define IHTMLCurrentStyle_get_zIndex( x, p ) \
        (x)->lpVtbl->get_zIndex( x, p )
    #define IHTMLCurrentStyle_get_letterSpacing( x, p ) \
        (x)->lpVtbl->get_letterSpacing( x, p )
    #define IHTMLCurrentStyle_get_lineHeight( x, p ) \
        (x)->lpVtbl->get_lineHeight( x, p )
    #define IHTMLCurrentStyle_get_textIndent( x, p ) \
        (x)->lpVtbl->get_textIndent( x, p )
    #define IHTMLCurrentStyle_get_verticalAlign( x, p ) \
        (x)->lpVtbl->get_verticalAlign( x, p )
    #define IHTMLCurrentStyle_get_backgroundAttachment( x, p ) \
        (x)->lpVtbl->get_backgroundAttachment( x, p )
    #define IHTMLCurrentStyle_get_marginTop( x, p ) \
        (x)->lpVtbl->get_marginTop( x, p )
    #define IHTMLCurrentStyle_get_marginRight( x, p ) \
        (x)->lpVtbl->get_marginRight( x, p )
    #define IHTMLCurrentStyle_get_marginBottom( x, p ) \
        (x)->lpVtbl->get_marginBottom( x, p )
    #define IHTMLCurrentStyle_get_marginLeft( x, p ) \
        (x)->lpVtbl->get_marginLeft( x, p )
    #define IHTMLCurrentStyle_get_clear( x, p ) \
        (x)->lpVtbl->get_clear( x, p )
    #define IHTMLCurrentStyle_get_listStyleType( x, p ) \
        (x)->lpVtbl->get_listStyleType( x, p )
    #define IHTMLCurrentStyle_get_listStylePosition( x, p ) \
        (x)->lpVtbl->get_listStylePosition( x, p )
    #define IHTMLCurrentStyle_get_listStyleImage( x, p ) \
        (x)->lpVtbl->get_listStyleImage( x, p )
    #define IHTMLCurrentStyle_get_clipTop( x, p ) \
        (x)->lpVtbl->get_clipTop( x, p )
    #define IHTMLCurrentStyle_get_clipRight( x, p ) \
        (x)->lpVtbl->get_clipRight( x, p )
    #define IHTMLCurrentStyle_get_clipBottom( x, p ) \
        (x)->lpVtbl->get_clipBottom( x, p )
    #define IHTMLCurrentStyle_get_clipLeft( x, p ) \
        (x)->lpVtbl->get_clipLeft( x, p )
    #define IHTMLCurrentStyle_get_overflow( x, p ) \
        (x)->lpVtbl->get_overflow( x, p )
    #define IHTMLCurrentStyle_get_pageBreakBefore( x, p ) \
        (x)->lpVtbl->get_pageBreakBefore( x, p )
    #define IHTMLCurrentStyle_get_pageBreakAfter( x, p ) \
        (x)->lpVtbl->get_pageBreakAfter( x, p )
    #define IHTMLCurrentStyle_get_cursor( x, p ) \
        (x)->lpVtbl->get_cursor( x, p )
    #define IHTMLCurrentStyle_get_tableLayout( x, p ) \
        (x)->lpVtbl->get_tableLayout( x, p )
    #define IHTMLCurrentStyle_get_borderCollapse( x, p ) \
        (x)->lpVtbl->get_borderCollapse( x, p )
    #define IHTMLCurrentStyle_get_direction( x, p ) \
        (x)->lpVtbl->get_direction( x, p )
    #define IHTMLCurrentStyle_get_behavior( x, p ) \
        (x)->lpVtbl->get_behavior( x, p )
    #define IHTMLCurrentStyle_getAttribute( x, p1, p2, p3 ) \
        (x)->lpVtbl->getAttribute( x, p1, p2, p3 )
    #define IHTMLCurrentStyle_get_unicodeBidi( x, p ) \
        (x)->lpVtbl->get_unicodeBidi( x, p )
    #define IHTMLCurrentStyle_get_right( x, p ) \
        (x)->lpVtbl->get_right( x, p )
    #define IHTMLCurrentStyle_get_bottom( x, p ) \
        (x)->lpVtbl->get_bottom( x, p )
    #define IHTMLCurrentStyle_get_imeMode( x, p ) \
        (x)->lpVtbl->get_imeMode( x, p )
    #define IHTMLCurrentStyle_get_rubyAlign( x, p ) \
        (x)->lpVtbl->get_rubyAlign( x, p )
    #define IHTMLCurrentStyle_get_rubyPosition( x, p ) \
        (x)->lpVtbl->get_rubyPosition( x, p )
    #define IHTMLCurrentStyle_get_rubyOverhang( x, p ) \
        (x)->lpVtbl->get_rubyOverhang( x, p )
    #define IHTMLCurrentStyle_get_textAutospace( x, p ) \
        (x)->lpVtbl->get_textAutospace( x, p )
    #define IHTMLCurrentStyle_get_lineBreak( x, p ) \
        (x)->lpVtbl->get_lineBreak( x, p )
    #define IHTMLCurrentStyle_get_wordBreak( x, p ) \
        (x)->lpVtbl->get_wordBreak( x, p )
    #define IHTMLCurrentStyle_get_textJustify( x, p ) \
        (x)->lpVtbl->get_textJustify( x, p )
    #define IHTMLCurrentStyle_get_textJustifyTrim( x, p ) \
        (x)->lpVtbl->get_textJustifyTrim( x, p )
    #define IHTMLCurrentStyle_get_textKashida( x, p ) \
        (x)->lpVtbl->get_textKashida( x, p )
    #define IHTMLCurrentStyle_get_blockDirection( x, p ) \
        (x)->lpVtbl->get_blockDirection( x, p )
    #define IHTMLCurrentStyle_get_layoutGridChar( x, p ) \
        (x)->lpVtbl->get_layoutGridChar( x, p )
    #define IHTMLCurrentStyle_get_layoutGridLine( x, p ) \
        (x)->lpVtbl->get_layoutGridLine( x, p )
    #define IHTMLCurrentStyle_get_layoutGridMode( x, p ) \
        (x)->lpVtbl->get_layoutGridMode( x, p )
    #define IHTMLCurrentStyle_get_layoutGridType( x, p ) \
        (x)->lpVtbl->get_layoutGridType( x, p )
    #define IHTMLCurrentStyle_get_borderStyle( x, p ) \
        (x)->lpVtbl->get_borderStyle( x, p )
    #define IHTMLCurrentStyle_get_borderColor( x, p ) \
        (x)->lpVtbl->get_borderColor( x, p )
    #define IHTMLCurrentStyle_get_borderWidth( x, p ) \
        (x)->lpVtbl->get_borderWidth( x, p )
    #define IHTMLCurrentStyle_get_padding( x, p ) \
        (x)->lpVtbl->get_padding( x, p )
    #define IHTMLCurrentStyle_get_margin( x, p ) \
        (x)->lpVtbl->get_margin( x, p )
    #define IHTMLCurrentStyle_get_accelerator( x, p ) \
        (x)->lpVtbl->get_accelerator( x, p )
    #define IHTMLCurrentStyle_get_overflowX( x, p ) \
        (x)->lpVtbl->get_overflowX( x, p )
    #define IHTMLCurrentStyle_get_overflowY( x, p ) \
        (x)->lpVtbl->get_overflowY( x, p )
    #define IHTMLCurrentStyle_get_textTransform( x, p ) \
        (x)->lpVtbl->get_textTransform( x, p )
    #define IHTMLCurrentStyle2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLCurrentStyle2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLCurrentStyle2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLCurrentStyle2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLCurrentStyle2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLCurrentStyle2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLCurrentStyle2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLCurrentStyle2_get_layoutFlow( x, p ) \
        (x)->lpVtbl->get_layoutFlow( x, p )
    #define IHTMLCurrentStyle2_get_wordWrap( x, p ) \
        (x)->lpVtbl->get_wordWrap( x, p )
    #define IHTMLCurrentStyle2_get_textUnderlinePosition( x, p ) \
        (x)->lpVtbl->get_textUnderlinePosition( x, p )
    #define IHTMLCurrentStyle2_get_hasLayout( x, p ) \
        (x)->lpVtbl->get_hasLayout( x, p )
    #define IHTMLCurrentStyle2_get_scrollbarBaseColor( x, p ) \
        (x)->lpVtbl->get_scrollbarBaseColor( x, p )
    #define IHTMLCurrentStyle2_get_scrollbarFaceColor( x, p ) \
        (x)->lpVtbl->get_scrollbarFaceColor( x, p )
    #define IHTMLCurrentStyle2_get_scrollbar3dLightColor( x, p ) \
        (x)->lpVtbl->get_scrollbar3dLightColor( x, p )
    #define IHTMLCurrentStyle2_get_scrollbarShadowColor( x, p ) \
        (x)->lpVtbl->get_scrollbarShadowColor( x, p )
    #define IHTMLCurrentStyle2_get_scrollbarHighlightColor( x, p ) \
        (x)->lpVtbl->get_scrollbarHighlightColor( x, p )
    #define IHTMLCurrentStyle2_get_scrollbarDarkShadowColor( x, p ) \
        (x)->lpVtbl->get_scrollbarDarkShadowColor( x, p )
    #define IHTMLCurrentStyle2_get_scrollbarArrowColor( x, p ) \
        (x)->lpVtbl->get_scrollbarArrowColor( x, p )
    #define IHTMLCurrentStyle2_get_scrollbarTrackColor( x, p ) \
        (x)->lpVtbl->get_scrollbarTrackColor( x, p )
    #define IHTMLCurrentStyle2_get_writingMode( x, p ) \
        (x)->lpVtbl->get_writingMode( x, p )
    #define IHTMLCurrentStyle2_get_zoom( x, p ) \
        (x)->lpVtbl->get_zoom( x, p )
    #define IHTMLCurrentStyle2_get_filter( x, p ) \
        (x)->lpVtbl->get_filter( x, p )
    #define IHTMLCurrentStyle2_get_textAlignLast( x, p ) \
        (x)->lpVtbl->get_textAlignLast( x, p )
    #define IHTMLCurrentStyle2_get_textKashidaSpace( x, p ) \
        (x)->lpVtbl->get_textKashidaSpace( x, p )
    #define IHTMLCurrentStyle2_get_isBlock( x, p ) \
        (x)->lpVtbl->get_isBlock( x, p )
    #define IHTMLCurrentStyle3_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLCurrentStyle3_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLCurrentStyle3_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLCurrentStyle3_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLCurrentStyle3_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLCurrentStyle3_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLCurrentStyle3_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLCurrentStyle3_get_textOverflow( x, p ) \
        (x)->lpVtbl->get_textOverflow( x, p )
    #define IHTMLCurrentStyle3_get_minHeight( x, p ) \
        (x)->lpVtbl->get_minHeight( x, p )
    #define IHTMLCurrentStyle3_get_wordSpacing( x, p ) \
        (x)->lpVtbl->get_wordSpacing( x, p )
    #define IHTMLCurrentStyle3_get_whiteSpace( x, p ) \
        (x)->lpVtbl->get_whiteSpace( x, p )
    #define IHTMLCurrentStyle4_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLCurrentStyle4_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLCurrentStyle4_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLCurrentStyle4_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLCurrentStyle4_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLCurrentStyle4_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLCurrentStyle4_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLCurrentStyle4_get_msInterpolationMode( x, p ) \
        (x)->lpVtbl->get_msInterpolationMode( x, p )
    #define IHTMLCurrentStyle4_get_maxHeight( x, p ) \
        (x)->lpVtbl->get_maxHeight( x, p )
    #define IHTMLCurrentStyle4_get_minWidth( x, p ) \
        (x)->lpVtbl->get_minWidth( x, p )
    #define IHTMLCurrentStyle4_get_maxWidth( x, p ) \
        (x)->lpVtbl->get_maxWidth( x, p )
    #define IHTMLCurrentStyle5_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLCurrentStyle5_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLCurrentStyle5_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLCurrentStyle5_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLCurrentStyle5_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLCurrentStyle5_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLCurrentStyle5_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLCurrentStyle5_get_captionSide( x, p ) \
        (x)->lpVtbl->get_captionSide( x, p )
    #define IHTMLCurrentStyle5_get_outline( x, p ) \
        (x)->lpVtbl->get_outline( x, p )
    #define IHTMLCurrentStyle5_get_outlineWidth( x, p ) \
        (x)->lpVtbl->get_outlineWidth( x, p )
    #define IHTMLCurrentStyle5_get_outlineStyle( x, p ) \
        (x)->lpVtbl->get_outlineStyle( x, p )
    #define IHTMLCurrentStyle5_get_outlineColor( x, p ) \
        (x)->lpVtbl->get_outlineColor( x, p )
    #define IHTMLCurrentStyle5_get_boxSizing( x, p ) \
        (x)->lpVtbl->get_boxSizing( x, p )
    #define IHTMLCurrentStyle5_get_borderSpacing( x, p ) \
        (x)->lpVtbl->get_borderSpacing( x, p )
    #define IHTMLCurrentStyle5_get_orphans( x, p ) \
        (x)->lpVtbl->get_orphans( x, p )
    #define IHTMLCurrentStyle5_get_widows( x, p ) \
        (x)->lpVtbl->get_widows( x, p )
    #define IHTMLCurrentStyle5_get_pageBreakInside( x, p ) \
        (x)->lpVtbl->get_pageBreakInside( x, p )
    #define IHTMLCurrentStyle5_get_emptyCells( x, p ) \
        (x)->lpVtbl->get_emptyCells( x, p )
    #define IHTMLCurrentStyle5_get_msBlockProgression( x, p ) \
        (x)->lpVtbl->get_msBlockProgression( x, p )
    #define IHTMLCurrentStyle5_get_quotes( x, p ) \
        (x)->lpVtbl->get_quotes( x, p )
    #define DispHTMLCurrentStyle_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLCurrentStyle_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLCurrentStyle_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLCurrentStyle_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLCurrentStyle_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLCurrentStyle_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLCurrentStyle_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLRect_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLRect_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLRect_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLRect_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLRect_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLRect_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLRect_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLRect_put_left( x, p ) \
        (x)->lpVtbl->put_left( x, p )
    #define IHTMLRect_get_left( x, p ) \
        (x)->lpVtbl->get_left( x, p )
    #define IHTMLRect_put_top( x, p ) \
        (x)->lpVtbl->put_top( x, p )
    #define IHTMLRect_get_top( x, p ) \
        (x)->lpVtbl->get_top( x, p )
    #define IHTMLRect_put_right( x, p ) \
        (x)->lpVtbl->put_right( x, p )
    #define IHTMLRect_get_right( x, p ) \
        (x)->lpVtbl->get_right( x, p )
    #define IHTMLRect_put_bottom( x, p ) \
        (x)->lpVtbl->put_bottom( x, p )
    #define IHTMLRect_get_bottom( x, p ) \
        (x)->lpVtbl->get_bottom( x, p )
    #define IHTMLRectCollection_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLRectCollection_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLRectCollection_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLRectCollection_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLRectCollection_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLRectCollection_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLRectCollection_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLRectCollection_get_length( x, p ) \
        (x)->lpVtbl->get_length( x, p )
    #define IHTMLRectCollection_get__newEnum( x, p ) \
        (x)->lpVtbl->get__newEnum( x, p )
    #define IHTMLRectCollection_item( x, p1, p2 ) \
        (x)->lpVtbl->item( x, p1, p2 )
    #define IHTMLDOMNode_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLDOMNode_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLDOMNode_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLDOMNode_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLDOMNode_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLDOMNode_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLDOMNode_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLDOMNode_get_nodeType( x, p ) \
        (x)->lpVtbl->get_nodeType( x, p )
    #define IHTMLDOMNode_get_parentNode( x, p ) \
        (x)->lpVtbl->get_parentNode( x, p )
    #define IHTMLDOMNode_hasChildNodes( x, p ) \
        (x)->lpVtbl->hasChildNodes( x, p )
    #define IHTMLDOMNode_get_childNodes( x, p ) \
        (x)->lpVtbl->get_childNodes( x, p )
    #define IHTMLDOMNode_get_attributes( x, p ) \
        (x)->lpVtbl->get_attributes( x, p )
    #define IHTMLDOMNode_insertBefore( x, p1, p2, p3 ) \
        (x)->lpVtbl->insertBefore( x, p1, p2, p3 )
    #define IHTMLDOMNode_removeChild( x, p1, p2 ) \
        (x)->lpVtbl->removeChild( x, p1, p2 )
    #define IHTMLDOMNode_replaceChild( x, p1, p2, p3 ) \
        (x)->lpVtbl->replaceChild( x, p1, p2, p3 )
    #define IHTMLDOMNode_cloneNode( x, p1, p2 ) \
        (x)->lpVtbl->cloneNode( x, p1, p2 )
    #define IHTMLDOMNode_removeNode( x, p1, p2 ) \
        (x)->lpVtbl->removeNode( x, p1, p2 )
    #define IHTMLDOMNode_swapNode( x, p1, p2 ) \
        (x)->lpVtbl->swapNode( x, p1, p2 )
    #define IHTMLDOMNode_replaceNode( x, p1, p2 ) \
        (x)->lpVtbl->replaceNode( x, p1, p2 )
    #define IHTMLDOMNode_appendChild( x, p1, p2 ) \
        (x)->lpVtbl->appendChild( x, p1, p2 )
    #define IHTMLDOMNode_get_nodeName( x, p ) \
        (x)->lpVtbl->get_nodeName( x, p )
    #define IHTMLDOMNode_put_nodeValue( x, p ) \
        (x)->lpVtbl->put_nodeValue( x, p )
    #define IHTMLDOMNode_get_nodeValue( x, p ) \
        (x)->lpVtbl->get_nodeValue( x, p )
    #define IHTMLDOMNode_get_firstChild( x, p ) \
        (x)->lpVtbl->get_firstChild( x, p )
    #define IHTMLDOMNode_get_lastChild( x, p ) \
        (x)->lpVtbl->get_lastChild( x, p )
    #define IHTMLDOMNode_get_previousSibling( x, p ) \
        (x)->lpVtbl->get_previousSibling( x, p )
    #define IHTMLDOMNode_get_nextSibling( x, p ) \
        (x)->lpVtbl->get_nextSibling( x, p )
    #define IHTMLDOMNode2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLDOMNode2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLDOMNode2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLDOMNode2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLDOMNode2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLDOMNode2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLDOMNode2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLDOMNode2_get_ownerDocument( x, p ) \
        (x)->lpVtbl->get_ownerDocument( x, p )
    #define IHTMLDOMAttribute_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLDOMAttribute_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLDOMAttribute_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLDOMAttribute_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLDOMAttribute_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLDOMAttribute_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLDOMAttribute_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLDOMAttribute_get_nodeName( x, p ) \
        (x)->lpVtbl->get_nodeName( x, p )
    #define IHTMLDOMAttribute_put_nodeValue( x, p ) \
        (x)->lpVtbl->put_nodeValue( x, p )
    #define IHTMLDOMAttribute_get_nodeValue( x, p ) \
        (x)->lpVtbl->get_nodeValue( x, p )
    #define IHTMLDOMAttribute_get_specified( x, p ) \
        (x)->lpVtbl->get_specified( x, p )
    #define IHTMLDOMAttribute2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLDOMAttribute2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLDOMAttribute2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLDOMAttribute2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLDOMAttribute2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLDOMAttribute2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLDOMAttribute2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLDOMAttribute2_get_name( x, p ) \
        (x)->lpVtbl->get_name( x, p )
    #define IHTMLDOMAttribute2_put_value( x, p ) \
        (x)->lpVtbl->put_value( x, p )
    #define IHTMLDOMAttribute2_get_value( x, p ) \
        (x)->lpVtbl->get_value( x, p )
    #define IHTMLDOMAttribute2_get_expando( x, p ) \
        (x)->lpVtbl->get_expando( x, p )
    #define IHTMLDOMAttribute2_get_nodeType( x, p ) \
        (x)->lpVtbl->get_nodeType( x, p )
    #define IHTMLDOMAttribute2_get_parentNode( x, p ) \
        (x)->lpVtbl->get_parentNode( x, p )
    #define IHTMLDOMAttribute2_get_childNodes( x, p ) \
        (x)->lpVtbl->get_childNodes( x, p )
    #define IHTMLDOMAttribute2_get_firstChild( x, p ) \
        (x)->lpVtbl->get_firstChild( x, p )
    #define IHTMLDOMAttribute2_get_lastChild( x, p ) \
        (x)->lpVtbl->get_lastChild( x, p )
    #define IHTMLDOMAttribute2_get_previousSibling( x, p ) \
        (x)->lpVtbl->get_previousSibling( x, p )
    #define IHTMLDOMAttribute2_get_nextSibling( x, p ) \
        (x)->lpVtbl->get_nextSibling( x, p )
    #define IHTMLDOMAttribute2_get_attributes( x, p ) \
        (x)->lpVtbl->get_attributes( x, p )
    #define IHTMLDOMAttribute2_get_ownerDocument( x, p ) \
        (x)->lpVtbl->get_ownerDocument( x, p )
    #define IHTMLDOMAttribute2_insertBefore( x, p1, p2, p3 ) \
        (x)->lpVtbl->insertBefore( x, p1, p2, p3 )
    #define IHTMLDOMAttribute2_replaceChild( x, p1, p2, p3 ) \
        (x)->lpVtbl->replaceChild( x, p1, p2, p3 )
    #define IHTMLDOMAttribute2_removeChild( x, p1, p2 ) \
        (x)->lpVtbl->removeChild( x, p1, p2 )
    #define IHTMLDOMAttribute2_appendChild( x, p1, p2 ) \
        (x)->lpVtbl->appendChild( x, p1, p2 )
    #define IHTMLDOMAttribute2_hasChildNodes( x, p ) \
        (x)->lpVtbl->hasChildNodes( x, p )
    #define IHTMLDOMAttribute2_cloneNode( x, p1, p2 ) \
        (x)->lpVtbl->cloneNode( x, p1, p2 )
    #define IHTMLDOMAttribute3_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLDOMAttribute3_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLDOMAttribute3_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLDOMAttribute3_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLDOMAttribute3_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLDOMAttribute3_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLDOMAttribute3_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLDOMAttribute3_put_nodeValue( x, p ) \
        (x)->lpVtbl->put_nodeValue( x, p )
    #define IHTMLDOMAttribute3_get_nodeValue( x, p ) \
        (x)->lpVtbl->get_nodeValue( x, p )
    #define IHTMLDOMAttribute3_put_value( x, p ) \
        (x)->lpVtbl->put_value( x, p )
    #define IHTMLDOMAttribute3_get_value( x, p ) \
        (x)->lpVtbl->get_value( x, p )
    #define IHTMLDOMAttribute3_get_specified( x, p ) \
        (x)->lpVtbl->get_specified( x, p )
    #define IHTMLDOMAttribute3_get_ownerElement( x, p ) \
        (x)->lpVtbl->get_ownerElement( x, p )
    #define IHTMLDOMTextNode_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLDOMTextNode_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLDOMTextNode_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLDOMTextNode_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLDOMTextNode_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLDOMTextNode_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLDOMTextNode_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLDOMTextNode_put_data( x, p ) \
        (x)->lpVtbl->put_data( x, p )
    #define IHTMLDOMTextNode_get_data( x, p ) \
        (x)->lpVtbl->get_data( x, p )
    #define IHTMLDOMTextNode_toString( x, p ) \
        (x)->lpVtbl->toString( x, p )
    #define IHTMLDOMTextNode_get_length( x, p ) \
        (x)->lpVtbl->get_length( x, p )
    #define IHTMLDOMTextNode_splitText( x, p1, p2 ) \
        (x)->lpVtbl->splitText( x, p1, p2 )
    #define IHTMLDOMTextNode2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLDOMTextNode2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLDOMTextNode2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLDOMTextNode2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLDOMTextNode2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLDOMTextNode2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLDOMTextNode2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLDOMTextNode2_substringData( x, p1, p2, p3 ) \
        (x)->lpVtbl->substringData( x, p1, p2, p3 )
    #define IHTMLDOMTextNode2_appendData( x, p ) \
        (x)->lpVtbl->appendData( x, p )
    #define IHTMLDOMTextNode2_insertData( x, p1, p2 ) \
        (x)->lpVtbl->insertData( x, p1, p2 )
    #define IHTMLDOMTextNode2_deleteData( x, p1, p2 ) \
        (x)->lpVtbl->deleteData( x, p1, p2 )
    #define IHTMLDOMTextNode2_replaceData( x, p1, p2, p3 ) \
        (x)->lpVtbl->replaceData( x, p1, p2, p3 )
    #define IHTMLDOMImplementation_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLDOMImplementation_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLDOMImplementation_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLDOMImplementation_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLDOMImplementation_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLDOMImplementation_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLDOMImplementation_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLDOMImplementation_hasFeature( x, p1, p2, p3 ) \
        (x)->lpVtbl->hasFeature( x, p1, p2, p3 )
    #define DispHTMLDOMAttribute_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLDOMAttribute_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLDOMAttribute_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLDOMAttribute_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLDOMAttribute_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLDOMAttribute_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLDOMAttribute_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define DispHTMLDOMTextNode_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLDOMTextNode_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLDOMTextNode_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLDOMTextNode_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLDOMTextNode_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLDOMTextNode_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLDOMTextNode_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define DispHTMLDOMImplementation_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLDOMImplementation_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLDOMImplementation_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLDOMImplementation_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLDOMImplementation_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLDOMImplementation_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLDOMImplementation_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLAttributeCollection_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLAttributeCollection_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLAttributeCollection_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLAttributeCollection_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLAttributeCollection_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLAttributeCollection_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLAttributeCollection_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLAttributeCollection_get_length( x, p ) \
        (x)->lpVtbl->get_length( x, p )
    #define IHTMLAttributeCollection_get__newEnum( x, p ) \
        (x)->lpVtbl->get__newEnum( x, p )
    #define IHTMLAttributeCollection_item( x, p1, p2 ) \
        (x)->lpVtbl->item( x, p1, p2 )
    #define IHTMLAttributeCollection2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLAttributeCollection2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLAttributeCollection2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLAttributeCollection2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLAttributeCollection2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLAttributeCollection2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLAttributeCollection2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLAttributeCollection2_getNamedItem( x, p1, p2 ) \
        (x)->lpVtbl->getNamedItem( x, p1, p2 )
    #define IHTMLAttributeCollection2_setNamedItem( x, p1, p2 ) \
        (x)->lpVtbl->setNamedItem( x, p1, p2 )
    #define IHTMLAttributeCollection2_removeNamedItem( x, p1, p2 ) \
        (x)->lpVtbl->removeNamedItem( x, p1, p2 )
    #define IHTMLAttributeCollection3_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLAttributeCollection3_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLAttributeCollection3_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLAttributeCollection3_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLAttributeCollection3_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLAttributeCollection3_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLAttributeCollection3_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLAttributeCollection3_getNamedItem( x, p1, p2 ) \
        (x)->lpVtbl->getNamedItem( x, p1, p2 )
    #define IHTMLAttributeCollection3_setNamedItem( x, p1, p2 ) \
        (x)->lpVtbl->setNamedItem( x, p1, p2 )
    #define IHTMLAttributeCollection3_removeNamedItem( x, p1, p2 ) \
        (x)->lpVtbl->removeNamedItem( x, p1, p2 )
    #define IHTMLAttributeCollection3_item( x, p1, p2 ) \
        (x)->lpVtbl->item( x, p1, p2 )
    #define IHTMLAttributeCollection3_get_length( x, p ) \
        (x)->lpVtbl->get_length( x, p )
    #define IHTMLDOMChildrenCollection_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLDOMChildrenCollection_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLDOMChildrenCollection_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLDOMChildrenCollection_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLDOMChildrenCollection_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLDOMChildrenCollection_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLDOMChildrenCollection_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLDOMChildrenCollection_get_length( x, p ) \
        (x)->lpVtbl->get_length( x, p )
    #define IHTMLDOMChildrenCollection_get__newEnum( x, p ) \
        (x)->lpVtbl->get__newEnum( x, p )
    #define IHTMLDOMChildrenCollection_item( x, p1, p2 ) \
        (x)->lpVtbl->item( x, p1, p2 )
    #define DispHTMLAttributeCollection_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLAttributeCollection_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLAttributeCollection_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLAttributeCollection_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLAttributeCollection_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLAttributeCollection_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLAttributeCollection_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define DispStaticNodeList_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispStaticNodeList_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispStaticNodeList_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispStaticNodeList_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispStaticNodeList_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispStaticNodeList_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispStaticNodeList_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define DispDOMChildrenCollection_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispDOMChildrenCollection_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispDOMChildrenCollection_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispDOMChildrenCollection_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispDOMChildrenCollection_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispDOMChildrenCollection_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispDOMChildrenCollection_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define HTMLElementEvents3_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define HTMLElementEvents3_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define HTMLElementEvents3_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define HTMLElementEvents3_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define HTMLElementEvents3_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define HTMLElementEvents3_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define HTMLElementEvents3_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define HTMLElementEvents2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define HTMLElementEvents2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define HTMLElementEvents2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define HTMLElementEvents2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define HTMLElementEvents2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define HTMLElementEvents2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define HTMLElementEvents2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define HTMLElementEvents_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define HTMLElementEvents_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define HTMLElementEvents_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define HTMLElementEvents_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define HTMLElementEvents_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define HTMLElementEvents_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define HTMLElementEvents_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLElement_setAttribute( x, p1, p2, p3 ) \
        (x)->lpVtbl->setAttribute( x, p1, p2, p3 )
    #define IHTMLElement_getAttribute( x, p1, p2, p3 ) \
        (x)->lpVtbl->getAttribute( x, p1, p2, p3 )
    #define IHTMLElement_removeAttribute( x, p1, p2, p3 ) \
        (x)->lpVtbl->removeAttribute( x, p1, p2, p3 )
    #define IHTMLElement_put_className( x, p ) \
        (x)->lpVtbl->put_className( x, p )
    #define IHTMLElement_get_className( x, p ) \
        (x)->lpVtbl->get_className( x, p )
    #define IHTMLElement_put_id( x, p ) \
        (x)->lpVtbl->put_id( x, p )
    #define IHTMLElement_get_id( x, p ) \
        (x)->lpVtbl->get_id( x, p )
    #define IHTMLElement_get_tagName( x, p ) \
        (x)->lpVtbl->get_tagName( x, p )
    #define IHTMLElement_get_parentElement( x, p ) \
        (x)->lpVtbl->get_parentElement( x, p )
    #define IHTMLElement_get_style( x, p ) \
        (x)->lpVtbl->get_style( x, p )
    #define IHTMLElement_put_onhelp( x, p ) \
        (x)->lpVtbl->put_onhelp( x, p )
    #define IHTMLElement_get_onhelp( x, p ) \
        (x)->lpVtbl->get_onhelp( x, p )
    #define IHTMLElement_put_onclick( x, p ) \
        (x)->lpVtbl->put_onclick( x, p )
    #define IHTMLElement_get_onclick( x, p ) \
        (x)->lpVtbl->get_onclick( x, p )
    #define IHTMLElement_put_ondblclick( x, p ) \
        (x)->lpVtbl->put_ondblclick( x, p )
    #define IHTMLElement_get_ondblclick( x, p ) \
        (x)->lpVtbl->get_ondblclick( x, p )
    #define IHTMLElement_put_onkeydown( x, p ) \
        (x)->lpVtbl->put_onkeydown( x, p )
    #define IHTMLElement_get_onkeydown( x, p ) \
        (x)->lpVtbl->get_onkeydown( x, p )
    #define IHTMLElement_put_onkeyup( x, p ) \
        (x)->lpVtbl->put_onkeyup( x, p )
    #define IHTMLElement_get_onkeyup( x, p ) \
        (x)->lpVtbl->get_onkeyup( x, p )
    #define IHTMLElement_put_onkeypress( x, p ) \
        (x)->lpVtbl->put_onkeypress( x, p )
    #define IHTMLElement_get_onkeypress( x, p ) \
        (x)->lpVtbl->get_onkeypress( x, p )
    #define IHTMLElement_put_onmouseout( x, p ) \
        (x)->lpVtbl->put_onmouseout( x, p )
    #define IHTMLElement_get_onmouseout( x, p ) \
        (x)->lpVtbl->get_onmouseout( x, p )
    #define IHTMLElement_put_onmouseover( x, p ) \
        (x)->lpVtbl->put_onmouseover( x, p )
    #define IHTMLElement_get_onmouseover( x, p ) \
        (x)->lpVtbl->get_onmouseover( x, p )
    #define IHTMLElement_put_onmousemove( x, p ) \
        (x)->lpVtbl->put_onmousemove( x, p )
    #define IHTMLElement_get_onmousemove( x, p ) \
        (x)->lpVtbl->get_onmousemove( x, p )
    #define IHTMLElement_put_onmousedown( x, p ) \
        (x)->lpVtbl->put_onmousedown( x, p )
    #define IHTMLElement_get_onmousedown( x, p ) \
        (x)->lpVtbl->get_onmousedown( x, p )
    #define IHTMLElement_put_onmouseup( x, p ) \
        (x)->lpVtbl->put_onmouseup( x, p )
    #define IHTMLElement_get_onmouseup( x, p ) \
        (x)->lpVtbl->get_onmouseup( x, p )
    #define IHTMLElement_get_document( x, p ) \
        (x)->lpVtbl->get_document( x, p )
    #define IHTMLElement_put_title( x, p ) \
        (x)->lpVtbl->put_title( x, p )
    #define IHTMLElement_get_title( x, p ) \
        (x)->lpVtbl->get_title( x, p )
    #define IHTMLElement_put_language( x, p ) \
        (x)->lpVtbl->put_language( x, p )
    #define IHTMLElement_get_language( x, p ) \
        (x)->lpVtbl->get_language( x, p )
    #define IHTMLElement_put_onselectstart( x, p ) \
        (x)->lpVtbl->put_onselectstart( x, p )
    #define IHTMLElement_get_onselectstart( x, p ) \
        (x)->lpVtbl->get_onselectstart( x, p )
    #define IHTMLElement_scrollIntoView( x, p ) \
        (x)->lpVtbl->scrollIntoView( x, p )
    #define IHTMLElement_contains( x, p1, p2 ) \
        (x)->lpVtbl->contains( x, p1, p2 )
    #define IHTMLElement_get_sourceIndex( x, p ) \
        (x)->lpVtbl->get_sourceIndex( x, p )
    #define IHTMLElement_get_recordNumber( x, p ) \
        (x)->lpVtbl->get_recordNumber( x, p )
    #define IHTMLElement_put_lang( x, p ) \
        (x)->lpVtbl->put_lang( x, p )
    #define IHTMLElement_get_lang( x, p ) \
        (x)->lpVtbl->get_lang( x, p )
    #define IHTMLElement_get_offsetLeft( x, p ) \
        (x)->lpVtbl->get_offsetLeft( x, p )
    #define IHTMLElement_get_offsetTop( x, p ) \
        (x)->lpVtbl->get_offsetTop( x, p )
    #define IHTMLElement_get_offsetRight( x, p ) \
        (x)->lpVtbl->get_offsetRight( x, p )
    #define IHTMLElement_get_offsetBottom( x, p ) \
        (x)->lpVtbl->get_offsetBottom( x, p )
    #define IHTMLElement_get_offsetParent( x, p ) \
        (x)->lpVtbl->get_offsetParent( x, p )
    #define IHTMLElement_put_innerHTML( x, p ) \
        (x)->lpVtbl->put_innerHTML( x, p )
    #define IHTMLElement_get_innerHTML( x, p ) \
        (x)->lpVtbl->get_innerHTML( x, p )
    #define IHTMLElement_put_innerText( x, p ) \
        (x)->lpVtbl->put_innerText( x, p )
    #define IHTMLElement_get_innerText( x, p ) \
        (x)->lpVtbl->get_innerText( x, p )
    #define IHTMLElement_put_outerHTML( x, p ) \
        (x)->lpVtbl->put_outerHTML( x, p )
    #define IHTMLElement_get_outerHTML( x, p ) \
        (x)->lpVtbl->get_outerHTML( x, p )
    #define IHTMLElement_put_outerText( x, p ) \
        (x)->lpVtbl->put_outerText( x, p )
    #define IHTMLElement_get_outerText( x, p ) \
        (x)->lpVtbl->get_outerText( x, p )
    #define IHTMLElement_insertAdjacentHTML( x, p1, p2 ) \
        (x)->lpVtbl->insertAdjacentHTML( x, p1, p2 )
    #define IHTMLElement_insertAdjacentText( x, p1, p2 ) \
        (x)->lpVtbl->insertAdjacentText( x, p1, p2 )
    #define IHTMLElement_get_parentTextEdit( x, p ) \
        (x)->lpVtbl->get_parentTextEdit( x, p )
    #define IHTMLElement_get_isTextEdit( x, p ) \
        (x)->lpVtbl->get_isTextEdit( x, p )
    #define IHTMLElement_click( x ) \
        (x)->lpVtbl->click( x )
    #define IHTMLElement_get_filters( x, p ) \
        (x)->lpVtbl->get_filters( x, p )
    #define IHTMLElement_put_ondragstart( x, p ) \
        (x)->lpVtbl->put_ondragstart( x, p )
    #define IHTMLElement_get_ondragstart( x, p ) \
        (x)->lpVtbl->get_ondragstart( x, p )
    #define IHTMLElement_toString( x, p ) \
        (x)->lpVtbl->toString( x, p )
    #define IHTMLElement_put_onbeforeupdate( x, p ) \
        (x)->lpVtbl->put_onbeforeupdate( x, p )
    #define IHTMLElement_get_onbeforeupdate( x, p ) \
        (x)->lpVtbl->get_onbeforeupdate( x, p )
    #define IHTMLElement_put_onafterupdate( x, p ) \
        (x)->lpVtbl->put_onafterupdate( x, p )
    #define IHTMLElement_get_onafterupdate( x, p ) \
        (x)->lpVtbl->get_onafterupdate( x, p )
    #define IHTMLElement_put_onerrorupdate( x, p ) \
        (x)->lpVtbl->put_onerrorupdate( x, p )
    #define IHTMLElement_get_onerrorupdate( x, p ) \
        (x)->lpVtbl->get_onerrorupdate( x, p )
    #define IHTMLElement_put_onrowexit( x, p ) \
        (x)->lpVtbl->put_onrowexit( x, p )
    #define IHTMLElement_get_onrowexit( x, p ) \
        (x)->lpVtbl->get_onrowexit( x, p )
    #define IHTMLElement_put_onrowenter( x, p ) \
        (x)->lpVtbl->put_onrowenter( x, p )
    #define IHTMLElement_get_onrowenter( x, p ) \
        (x)->lpVtbl->get_onrowenter( x, p )
    #define IHTMLElement_put_ondatasetchanged( x, p ) \
        (x)->lpVtbl->put_ondatasetchanged( x, p )
    #define IHTMLElement_get_ondatasetchanged( x, p ) \
        (x)->lpVtbl->get_ondatasetchanged( x, p )
    #define IHTMLElement_put_ondataavailable( x, p ) \
        (x)->lpVtbl->put_ondataavailable( x, p )
    #define IHTMLElement_get_ondataavailable( x, p ) \
        (x)->lpVtbl->get_ondataavailable( x, p )
    #define IHTMLElement_put_ondatasetcomplete( x, p ) \
        (x)->lpVtbl->put_ondatasetcomplete( x, p )
    #define IHTMLElement_get_ondatasetcomplete( x, p ) \
        (x)->lpVtbl->get_ondatasetcomplete( x, p )
    #define IHTMLElement_put_onfilterchange( x, p ) \
        (x)->lpVtbl->put_onfilterchange( x, p )
    #define IHTMLElement_get_onfilterchange( x, p ) \
        (x)->lpVtbl->get_onfilterchange( x, p )
    #define IHTMLElement_get_children( x, p ) \
        (x)->lpVtbl->get_children( x, p )
    #define IHTMLElement_get_all( x, p ) \
        (x)->lpVtbl->get_all( x, p )
    #define IHTMLElement2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLElement2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLElement2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLElement2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLElement2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLElement2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLElement2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLElement2_get_scopeName( x, p ) \
        (x)->lpVtbl->get_scopeName( x, p )
    #define IHTMLElement2_setCapture( x, p ) \
        (x)->lpVtbl->setCapture( x, p )
    #define IHTMLElement2_releaseCapture( x ) \
        (x)->lpVtbl->releaseCapture( x )
    #define IHTMLElement2_put_onlosecapture( x, p ) \
        (x)->lpVtbl->put_onlosecapture( x, p )
    #define IHTMLElement2_get_onlosecapture( x, p ) \
        (x)->lpVtbl->get_onlosecapture( x, p )
    #define IHTMLElement2_componentFromPoint( x, p1, p2, p3 ) \
        (x)->lpVtbl->componentFromPoint( x, p1, p2, p3 )
    #define IHTMLElement2_doScroll( x, p ) \
        (x)->lpVtbl->doScroll( x, p )
    #define IHTMLElement2_put_onscroll( x, p ) \
        (x)->lpVtbl->put_onscroll( x, p )
    #define IHTMLElement2_get_onscroll( x, p ) \
        (x)->lpVtbl->get_onscroll( x, p )
    #define IHTMLElement2_put_ondrag( x, p ) \
        (x)->lpVtbl->put_ondrag( x, p )
    #define IHTMLElement2_get_ondrag( x, p ) \
        (x)->lpVtbl->get_ondrag( x, p )
    #define IHTMLElement2_put_ondragend( x, p ) \
        (x)->lpVtbl->put_ondragend( x, p )
    #define IHTMLElement2_get_ondragend( x, p ) \
        (x)->lpVtbl->get_ondragend( x, p )
    #define IHTMLElement2_put_ondragenter( x, p ) \
        (x)->lpVtbl->put_ondragenter( x, p )
    #define IHTMLElement2_get_ondragenter( x, p ) \
        (x)->lpVtbl->get_ondragenter( x, p )
    #define IHTMLElement2_put_ondragover( x, p ) \
        (x)->lpVtbl->put_ondragover( x, p )
    #define IHTMLElement2_get_ondragover( x, p ) \
        (x)->lpVtbl->get_ondragover( x, p )
    #define IHTMLElement2_put_ondragleave( x, p ) \
        (x)->lpVtbl->put_ondragleave( x, p )
    #define IHTMLElement2_get_ondragleave( x, p ) \
        (x)->lpVtbl->get_ondragleave( x, p )
    #define IHTMLElement2_put_ondrop( x, p ) \
        (x)->lpVtbl->put_ondrop( x, p )
    #define IHTMLElement2_get_ondrop( x, p ) \
        (x)->lpVtbl->get_ondrop( x, p )
    #define IHTMLElement2_put_onbeforecut( x, p ) \
        (x)->lpVtbl->put_onbeforecut( x, p )
    #define IHTMLElement2_get_onbeforecut( x, p ) \
        (x)->lpVtbl->get_onbeforecut( x, p )
    #define IHTMLElement2_put_oncut( x, p ) \
        (x)->lpVtbl->put_oncut( x, p )
    #define IHTMLElement2_get_oncut( x, p ) \
        (x)->lpVtbl->get_oncut( x, p )
    #define IHTMLElement2_put_onbeforecopy( x, p ) \
        (x)->lpVtbl->put_onbeforecopy( x, p )
    #define IHTMLElement2_get_onbeforecopy( x, p ) \
        (x)->lpVtbl->get_onbeforecopy( x, p )
    #define IHTMLElement2_put_oncopy( x, p ) \
        (x)->lpVtbl->put_oncopy( x, p )
    #define IHTMLElement2_get_oncopy( x, p ) \
        (x)->lpVtbl->get_oncopy( x, p )
    #define IHTMLElement2_put_onbeforepaste( x, p ) \
        (x)->lpVtbl->put_onbeforepaste( x, p )
    #define IHTMLElement2_get_onbeforepaste( x, p ) \
        (x)->lpVtbl->get_onbeforepaste( x, p )
    #define IHTMLElement2_put_onpaste( x, p ) \
        (x)->lpVtbl->put_onpaste( x, p )
    #define IHTMLElement2_get_onpaste( x, p ) \
        (x)->lpVtbl->get_onpaste( x, p )
    #define IHTMLElement2_get_currentStyle( x, p ) \
        (x)->lpVtbl->get_currentStyle( x, p )
    #define IHTMLElement2_put_onpropertychange( x, p ) \
        (x)->lpVtbl->put_onpropertychange( x, p )
    #define IHTMLElement2_get_onpropertychange( x, p ) \
        (x)->lpVtbl->get_onpropertychange( x, p )
    #define IHTMLElement2_getClientRects( x, p ) \
        (x)->lpVtbl->getClientRects( x, p )
    #define IHTMLElement2_getBoundingClientRect( x, p ) \
        (x)->lpVtbl->getBoundingClientRect( x, p )
    #define IHTMLElement2_setExpression( x, p1, p2, p3 ) \
        (x)->lpVtbl->setExpression( x, p1, p2, p3 )
    #define IHTMLElement2_getExpression( x, p1, p2 ) \
        (x)->lpVtbl->getExpression( x, p1, p2 )
    #define IHTMLElement2_removeExpression( x, p1, p2 ) \
        (x)->lpVtbl->removeExpression( x, p1, p2 )
    #define IHTMLElement2_put_tabIndex( x, p ) \
        (x)->lpVtbl->put_tabIndex( x, p )
    #define IHTMLElement2_get_tabIndex( x, p ) \
        (x)->lpVtbl->get_tabIndex( x, p )
    #define IHTMLElement2_focus( x ) \
        (x)->lpVtbl->focus( x )
    #define IHTMLElement2_put_accessKey( x, p ) \
        (x)->lpVtbl->put_accessKey( x, p )
    #define IHTMLElement2_get_accessKey( x, p ) \
        (x)->lpVtbl->get_accessKey( x, p )
    #define IHTMLElement2_put_onblur( x, p ) \
        (x)->lpVtbl->put_onblur( x, p )
    #define IHTMLElement2_get_onblur( x, p ) \
        (x)->lpVtbl->get_onblur( x, p )
    #define IHTMLElement2_put_onfocus( x, p ) \
        (x)->lpVtbl->put_onfocus( x, p )
    #define IHTMLElement2_get_onfocus( x, p ) \
        (x)->lpVtbl->get_onfocus( x, p )
    #define IHTMLElement2_put_onresize( x, p ) \
        (x)->lpVtbl->put_onresize( x, p )
    #define IHTMLElement2_get_onresize( x, p ) \
        (x)->lpVtbl->get_onresize( x, p )
    #define IHTMLElement2_blur( x ) \
        (x)->lpVtbl->blur( x )
    #define IHTMLElement2_addFilter( x, p ) \
        (x)->lpVtbl->addFilter( x, p )
    #define IHTMLElement2_removeFilter( x, p ) \
        (x)->lpVtbl->removeFilter( x, p )
    #define IHTMLElement2_get_clientHeight( x, p ) \
        (x)->lpVtbl->get_clientHeight( x, p )
    #define IHTMLElement2_get_clientWidth( x, p ) \
        (x)->lpVtbl->get_clientWidth( x, p )
    #define IHTMLElement2_get_clientTop( x, p ) \
        (x)->lpVtbl->get_clientTop( x, p )
    #define IHTMLElement2_get_clientLeft( x, p ) \
        (x)->lpVtbl->get_clientLeft( x, p )
    #define IHTMLElement2_attachEvent( x, p1, p2, p3 ) \
        (x)->lpVtbl->attachEvent( x, p1, p2, p3 )
    #define IHTMLElement2_detachEvent( x, p1, p2 ) \
        (x)->lpVtbl->detachEvent( x, p1, p2 )
    #define IHTMLElement2_get_readyState( x, p ) \
        (x)->lpVtbl->get_readyState( x, p )
    #define IHTMLElement2_put_onreadystatechange( x, p ) \
        (x)->lpVtbl->put_onreadystatechange( x, p )
    #define IHTMLElement2_get_onreadystatechange( x, p ) \
        (x)->lpVtbl->get_onreadystatechange( x, p )
    #define IHTMLElement2_put_onrowsdelete( x, p ) \
        (x)->lpVtbl->put_onrowsdelete( x, p )
    #define IHTMLElement2_get_onrowsdelete( x, p ) \
        (x)->lpVtbl->get_onrowsdelete( x, p )
    #define IHTMLElement2_put_onrowsinserted( x, p ) \
        (x)->lpVtbl->put_onrowsinserted( x, p )
    #define IHTMLElement2_get_onrowsinserted( x, p ) \
        (x)->lpVtbl->get_onrowsinserted( x, p )
    #define IHTMLElement2_put_oncellchange( x, p ) \
        (x)->lpVtbl->put_oncellchange( x, p )
    #define IHTMLElement2_get_oncellchange( x, p ) \
        (x)->lpVtbl->get_oncellchange( x, p )
    #define IHTMLElement2_put_dir( x, p ) \
        (x)->lpVtbl->put_dir( x, p )
    #define IHTMLElement2_get_dir( x, p ) \
        (x)->lpVtbl->get_dir( x, p )
    #define IHTMLElement2_createControlRange( x, p ) \
        (x)->lpVtbl->createControlRange( x, p )
    #define IHTMLElement2_get_scrollHeight( x, p ) \
        (x)->lpVtbl->get_scrollHeight( x, p )
    #define IHTMLElement2_get_scrollWidth( x, p ) \
        (x)->lpVtbl->get_scrollWidth( x, p )
    #define IHTMLElement2_put_scrollTop( x, p ) \
        (x)->lpVtbl->put_scrollTop( x, p )
    #define IHTMLElement2_get_scrollTop( x, p ) \
        (x)->lpVtbl->get_scrollTop( x, p )
    #define IHTMLElement2_put_scrollLeft( x, p ) \
        (x)->lpVtbl->put_scrollLeft( x, p )
    #define IHTMLElement2_get_scrollLeft( x, p ) \
        (x)->lpVtbl->get_scrollLeft( x, p )
    #define IHTMLElement2_clearAttributes( x ) \
        (x)->lpVtbl->clearAttributes( x )
    #define IHTMLElement2_mergeAttributes( x, p ) \
        (x)->lpVtbl->mergeAttributes( x, p )
    #define IHTMLElement2_put_oncontextmenu( x, p ) \
        (x)->lpVtbl->put_oncontextmenu( x, p )
    #define IHTMLElement2_get_oncontextmenu( x, p ) \
        (x)->lpVtbl->get_oncontextmenu( x, p )
    #define IHTMLElement2_insertAdjacentElement( x, p1, p2, p3 ) \
        (x)->lpVtbl->insertAdjacentElement( x, p1, p2, p3 )
    #define IHTMLElement2_applyElement( x, p1, p2, p3 ) \
        (x)->lpVtbl->applyElement( x, p1, p2, p3 )
    #define IHTMLElement2_getAdjacentText( x, p1, p2 ) \
        (x)->lpVtbl->getAdjacentText( x, p1, p2 )
    #define IHTMLElement2_replaceAdjacentText( x, p1, p2, p3 ) \
        (x)->lpVtbl->replaceAdjacentText( x, p1, p2, p3 )
    #define IHTMLElement2_get_canHaveChildren( x, p ) \
        (x)->lpVtbl->get_canHaveChildren( x, p )
    #define IHTMLElement2_addBehavior( x, p1, p2, p3 ) \
        (x)->lpVtbl->addBehavior( x, p1, p2, p3 )
    #define IHTMLElement2_removeBehavior( x, p1, p2 ) \
        (x)->lpVtbl->removeBehavior( x, p1, p2 )
    #define IHTMLElement2_get_runtimeStyle( x, p ) \
        (x)->lpVtbl->get_runtimeStyle( x, p )
    #define IHTMLElement2_get_behaviorUrns( x, p ) \
        (x)->lpVtbl->get_behaviorUrns( x, p )
    #define IHTMLElement2_put_tagUrn( x, p ) \
        (x)->lpVtbl->put_tagUrn( x, p )
    #define IHTMLElement2_get_tagUrn( x, p ) \
        (x)->lpVtbl->get_tagUrn( x, p )
    #define IHTMLElement2_put_onbeforeeditfocus( x, p ) \
        (x)->lpVtbl->put_onbeforeeditfocus( x, p )
    #define IHTMLElement2_get_onbeforeeditfocus( x, p ) \
        (x)->lpVtbl->get_onbeforeeditfocus( x, p )
    #define IHTMLElement2_get_readyStateValue( x, p ) \
        (x)->lpVtbl->get_readyStateValue( x, p )
    #define IHTMLElement2_getElementsByTagName( x, p1, p2 ) \
        (x)->lpVtbl->getElementsByTagName( x, p1, p2 )
    #define IHTMLElement3_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLElement3_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLElement3_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLElement3_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLElement3_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLElement3_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLElement3_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLElement3_mergeAttributes( x, p1, p2 ) \
        (x)->lpVtbl->mergeAttributes( x, p1, p2 )
    #define IHTMLElement3_get_isMultiLine( x, p ) \
        (x)->lpVtbl->get_isMultiLine( x, p )
    #define IHTMLElement3_get_canHaveHTML( x, p ) \
        (x)->lpVtbl->get_canHaveHTML( x, p )
    #define IHTMLElement3_put_onlayoutcomplete( x, p ) \
        (x)->lpVtbl->put_onlayoutcomplete( x, p )
    #define IHTMLElement3_get_onlayoutcomplete( x, p ) \
        (x)->lpVtbl->get_onlayoutcomplete( x, p )
    #define IHTMLElement3_put_onpage( x, p ) \
        (x)->lpVtbl->put_onpage( x, p )
    #define IHTMLElement3_get_onpage( x, p ) \
        (x)->lpVtbl->get_onpage( x, p )
    #define IHTMLElement3_put_inflateBlock( x, p ) \
        (x)->lpVtbl->put_inflateBlock( x, p )
    #define IHTMLElement3_get_inflateBlock( x, p ) \
        (x)->lpVtbl->get_inflateBlock( x, p )
    #define IHTMLElement3_put_onbeforedeactivate( x, p ) \
        (x)->lpVtbl->put_onbeforedeactivate( x, p )
    #define IHTMLElement3_get_onbeforedeactivate( x, p ) \
        (x)->lpVtbl->get_onbeforedeactivate( x, p )
    #define IHTMLElement3_setActive( x ) \
        (x)->lpVtbl->setActive( x )
    #define IHTMLElement3_put_contentEditable( x, p ) \
        (x)->lpVtbl->put_contentEditable( x, p )
    #define IHTMLElement3_get_contentEditable( x, p ) \
        (x)->lpVtbl->get_contentEditable( x, p )
    #define IHTMLElement3_get_isContentEditable( x, p ) \
        (x)->lpVtbl->get_isContentEditable( x, p )
    #define IHTMLElement3_put_hideFocus( x, p ) \
        (x)->lpVtbl->put_hideFocus( x, p )
    #define IHTMLElement3_get_hideFocus( x, p ) \
        (x)->lpVtbl->get_hideFocus( x, p )
    #define IHTMLElement3_put_disabled( x, p ) \
        (x)->lpVtbl->put_disabled( x, p )
    #define IHTMLElement3_get_disabled( x, p ) \
        (x)->lpVtbl->get_disabled( x, p )
    #define IHTMLElement3_get_isDisabled( x, p ) \
        (x)->lpVtbl->get_isDisabled( x, p )
    #define IHTMLElement3_put_onmove( x, p ) \
        (x)->lpVtbl->put_onmove( x, p )
    #define IHTMLElement3_get_onmove( x, p ) \
        (x)->lpVtbl->get_onmove( x, p )
    #define IHTMLElement3_put_oncontrolselect( x, p ) \
        (x)->lpVtbl->put_oncontrolselect( x, p )
    #define IHTMLElement3_get_oncontrolselect( x, p ) \
        (x)->lpVtbl->get_oncontrolselect( x, p )
    #define IHTMLElement3_fireEvent( x, p1, p2, p3 ) \
        (x)->lpVtbl->fireEvent( x, p1, p2, p3 )
    #define IHTMLElement3_put_onresizestart( x, p ) \
        (x)->lpVtbl->put_onresizestart( x, p )
    #define IHTMLElement3_get_onresizestart( x, p ) \
        (x)->lpVtbl->get_onresizestart( x, p )
    #define IHTMLElement3_put_onresizeend( x, p ) \
        (x)->lpVtbl->put_onresizeend( x, p )
    #define IHTMLElement3_get_onresizeend( x, p ) \
        (x)->lpVtbl->get_onresizeend( x, p )
    #define IHTMLElement3_put_onmovestart( x, p ) \
        (x)->lpVtbl->put_onmovestart( x, p )
    #define IHTMLElement3_get_onmovestart( x, p ) \
        (x)->lpVtbl->get_onmovestart( x, p )
    #define IHTMLElement3_put_onmoveend( x, p ) \
        (x)->lpVtbl->put_onmoveend( x, p )
    #define IHTMLElement3_get_onmoveend( x, p ) \
        (x)->lpVtbl->get_onmoveend( x, p )
    #define IHTMLElement3_put_onmouseenter( x, p ) \
        (x)->lpVtbl->put_onmouseenter( x, p )
    #define IHTMLElement3_get_onmouseenter( x, p ) \
        (x)->lpVtbl->get_onmouseenter( x, p )
    #define IHTMLElement3_put_onmouseleave( x, p ) \
        (x)->lpVtbl->put_onmouseleave( x, p )
    #define IHTMLElement3_get_onmouseleave( x, p ) \
        (x)->lpVtbl->get_onmouseleave( x, p )
    #define IHTMLElement3_put_onactivate( x, p ) \
        (x)->lpVtbl->put_onactivate( x, p )
    #define IHTMLElement3_get_onactivate( x, p ) \
        (x)->lpVtbl->get_onactivate( x, p )
    #define IHTMLElement3_put_ondeactivate( x, p ) \
        (x)->lpVtbl->put_ondeactivate( x, p )
    #define IHTMLElement3_get_ondeactivate( x, p ) \
        (x)->lpVtbl->get_ondeactivate( x, p )
    #define IHTMLElement3_dragDrop( x, p ) \
        (x)->lpVtbl->dragDrop( x, p )
    #define IHTMLElement3_get_glyphMode( x, p ) \
        (x)->lpVtbl->get_glyphMode( x, p )
    #define IHTMLElement4_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLElement4_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLElement4_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLElement4_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLElement4_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLElement4_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLElement4_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLElement4_put_onmousewheel( x, p ) \
        (x)->lpVtbl->put_onmousewheel( x, p )
    #define IHTMLElement4_get_onmousewheel( x, p ) \
        (x)->lpVtbl->get_onmousewheel( x, p )
    #define IHTMLElement4_normalize( x ) \
        (x)->lpVtbl->normalize( x )
    #define IHTMLElement4_getAttributeNode( x, p1, p2 ) \
        (x)->lpVtbl->getAttributeNode( x, p1, p2 )
    #define IHTMLElement4_setAttributeNode( x, p1, p2 ) \
        (x)->lpVtbl->setAttributeNode( x, p1, p2 )
    #define IHTMLElement4_removeAttributeNode( x, p1, p2 ) \
        (x)->lpVtbl->removeAttributeNode( x, p1, p2 )
    #define IHTMLElement4_put_onbeforeactivate( x, p ) \
        (x)->lpVtbl->put_onbeforeactivate( x, p )
    #define IHTMLElement4_get_onbeforeactivate( x, p ) \
        (x)->lpVtbl->get_onbeforeactivate( x, p )
    #define IHTMLElement4_put_onfocusin( x, p ) \
        (x)->lpVtbl->put_onfocusin( x, p )
    #define IHTMLElement4_get_onfocusin( x, p ) \
        (x)->lpVtbl->get_onfocusin( x, p )
    #define IHTMLElement4_put_onfocusout( x, p ) \
        (x)->lpVtbl->put_onfocusout( x, p )
    #define IHTMLElement4_get_onfocusout( x, p ) \
        (x)->lpVtbl->get_onfocusout( x, p )
    #define IElementSelector_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IElementSelector_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IElementSelector_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IElementSelector_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IElementSelector_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IElementSelector_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IElementSelector_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IElementSelector_querySelector( x, p1, p2 ) \
        (x)->lpVtbl->querySelector( x, p1, p2 )
    #define IElementSelector_querySelectorAll( x, p1, p2 ) \
        (x)->lpVtbl->querySelectorAll( x, p1, p2 )
    #define IHTMLElementRender_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLElementRender_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLElementRender_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLElementRender_DrawToDC( x, p ) \
        (x)->lpVtbl->DrawToDC( x, p )
    #define IHTMLElementRender_SetDocumentPrinter( x, p1, p2 ) \
        (x)->lpVtbl->SetDocumentPrinter( x, p1, p2 )
    #define IHTMLUniqueName_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLUniqueName_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLUniqueName_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLUniqueName_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLUniqueName_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLUniqueName_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLUniqueName_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLUniqueName_get_uniqueNumber( x, p ) \
        (x)->lpVtbl->get_uniqueNumber( x, p )
    #define IHTMLUniqueName_get_uniqueID( x, p ) \
        (x)->lpVtbl->get_uniqueID( x, p )
    #define IHTMLElement5_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLElement5_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLElement5_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLElement5_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLElement5_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLElement5_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLElement5_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLElement5_getAttributeNode( x, p1, p2 ) \
        (x)->lpVtbl->getAttributeNode( x, p1, p2 )
    #define IHTMLElement5_setAttributeNode( x, p1, p2 ) \
        (x)->lpVtbl->setAttributeNode( x, p1, p2 )
    #define IHTMLElement5_removeAttributeNode( x, p1, p2 ) \
        (x)->lpVtbl->removeAttributeNode( x, p1, p2 )
    #define IHTMLElement5_hasAttribute( x, p1, p2 ) \
        (x)->lpVtbl->hasAttribute( x, p1, p2 )
    #define IHTMLElement5_put_role( x, p ) \
        (x)->lpVtbl->put_role( x, p )
    #define IHTMLElement5_get_role( x, p ) \
        (x)->lpVtbl->get_role( x, p )
    #define IHTMLElement5_put_ariaBusy( x, p ) \
        (x)->lpVtbl->put_ariaBusy( x, p )
    #define IHTMLElement5_get_ariaBusy( x, p ) \
        (x)->lpVtbl->get_ariaBusy( x, p )
    #define IHTMLElement5_put_ariaChecked( x, p ) \
        (x)->lpVtbl->put_ariaChecked( x, p )
    #define IHTMLElement5_get_ariaChecked( x, p ) \
        (x)->lpVtbl->get_ariaChecked( x, p )
    #define IHTMLElement5_put_ariaDisabled( x, p ) \
        (x)->lpVtbl->put_ariaDisabled( x, p )
    #define IHTMLElement5_get_ariaDisabled( x, p ) \
        (x)->lpVtbl->get_ariaDisabled( x, p )
    #define IHTMLElement5_put_ariaExpanded( x, p ) \
        (x)->lpVtbl->put_ariaExpanded( x, p )
    #define IHTMLElement5_get_ariaExpanded( x, p ) \
        (x)->lpVtbl->get_ariaExpanded( x, p )
    #define IHTMLElement5_put_ariaHaspopup( x, p ) \
        (x)->lpVtbl->put_ariaHaspopup( x, p )
    #define IHTMLElement5_get_ariaHaspopup( x, p ) \
        (x)->lpVtbl->get_ariaHaspopup( x, p )
    #define IHTMLElement5_put_ariaHidden( x, p ) \
        (x)->lpVtbl->put_ariaHidden( x, p )
    #define IHTMLElement5_get_ariaHidden( x, p ) \
        (x)->lpVtbl->get_ariaHidden( x, p )
    #define IHTMLElement5_put_ariaInvalid( x, p ) \
        (x)->lpVtbl->put_ariaInvalid( x, p )
    #define IHTMLElement5_get_ariaInvalid( x, p ) \
        (x)->lpVtbl->get_ariaInvalid( x, p )
    #define IHTMLElement5_put_ariaMultiselectable( x, p ) \
        (x)->lpVtbl->put_ariaMultiselectable( x, p )
    #define IHTMLElement5_get_ariaMultiselectable( x, p ) \
        (x)->lpVtbl->get_ariaMultiselectable( x, p )
    #define IHTMLElement5_put_ariaPressed( x, p ) \
        (x)->lpVtbl->put_ariaPressed( x, p )
    #define IHTMLElement5_get_ariaPressed( x, p ) \
        (x)->lpVtbl->get_ariaPressed( x, p )
    #define IHTMLElement5_put_ariaReadonly( x, p ) \
        (x)->lpVtbl->put_ariaReadonly( x, p )
    #define IHTMLElement5_get_ariaReadonly( x, p ) \
        (x)->lpVtbl->get_ariaReadonly( x, p )
    #define IHTMLElement5_put_ariaRequired( x, p ) \
        (x)->lpVtbl->put_ariaRequired( x, p )
    #define IHTMLElement5_get_ariaRequired( x, p ) \
        (x)->lpVtbl->get_ariaRequired( x, p )
    #define IHTMLElement5_put_ariaSecret( x, p ) \
        (x)->lpVtbl->put_ariaSecret( x, p )
    #define IHTMLElement5_get_ariaSecret( x, p ) \
        (x)->lpVtbl->get_ariaSecret( x, p )
    #define IHTMLElement5_put_ariaSelected( x, p ) \
        (x)->lpVtbl->put_ariaSelected( x, p )
    #define IHTMLElement5_get_ariaSelected( x, p ) \
        (x)->lpVtbl->get_ariaSelected( x, p )
    #define IHTMLElement5_getAttribute( x, p1, p2 ) \
        (x)->lpVtbl->getAttribute( x, p1, p2 )
    #define IHTMLElement5_setAttribute( x, p1, p2 ) \
        (x)->lpVtbl->setAttribute( x, p1, p2 )
    #define IHTMLElement5_removeAtttribute( x, p1, p2 ) \
        (x)->lpVtbl->removeAttribute( x, p1, p2 )
    #define IHTMLElement5_get_attributes( x, p ) \
        (x)->lpVtbl->get_attributes( x, p )
    #define IHTMLElement5_put_ariaValuenow( x, p ) \
        (x)->lpVtbl->put_ariaValuenow( x, p )
    #define IHTMLElement5_get_ariaValuenow( x, p ) \
        (x)->lpVtbl->get_ariaValuenow( x, p )
    #define IHTMLElement5_put_ariaPosinset( x, p ) \
        (x)->lpVtbl->put_ariaPosinset( x, p )
    #define IHTMLElement5_get_ariaPosinset( x, p ) \
        (x)->lpVtbl->get_ariaPosinset( x, p )
    #define IHTMLElement5_put_ariaSetsize( x, p ) \
        (x)->lpVtbl->put_ariaSetsize( x, p )
    #define IHTMLElement5_get_ariaSetsize( x, p ) \
        (x)->lpVtbl->get_ariaSetsize( x, p )
    #define IHTMLElement5_put_ariaLevel( x, p ) \
        (x)->lpVtbl->put_ariaLevel( x, p )
    #define IHTMLElement5_get_ariaLevel( x, p ) \
        (x)->lpVtbl->get_ariaLevel( x, p )
    #define IHTMLElement5_put_ariaValuemin( x, p ) \
        (x)->lpVtbl->put_ariaValuemin( x, p )
    #define IHTMLElement5_get_ariaValuemin( x, p ) \
        (x)->lpVtbl->get_ariaValuemin( x, p )
    #define IHTMLElement5_put_ariaValuemax( x, p ) \
        (x)->lpVtbl->put_ariaValuemax( x, p )
    #define IHTMLElement5_get_ariaValuemax( x, p ) \
        (x)->lpVtbl->get_ariaValuemax( x, p )
    #define IHTMLElement5_put_ariaControls( x, p ) \
        (x)->lpVtbl->put_ariaControls( x, p )
    #define IHTMLElement5_get_ariaControls( x, p ) \
        (x)->lpVtbl->get_ariaControls( x, p )
    #define IHTMLElement5_put_ariaDescribedby( x, p ) \
        (x)->lpVtbl->put_ariaDescribedby( x, p )
    #define IHTMLElement5_get_ariaDescribedby( x, p ) \
        (x)->lpVtbl->get_ariaDescribedby( x, p )
    #define IHTMLElement5_put_ariaFlowto( x, p ) \
        (x)->lpVtbl->put_ariaFlowto( x, p )
    #define IHTMLElement5_get_ariaFlowto( x, p ) \
        (x)->lpVtbl->get_ariaFlowto( x, p )
    #define IHTMLElement5_put_ariaLabelledby( x, p ) \
        (x)->lpVtbl->put_ariaLabelledby( x, p )
    #define IHTMLElement5_get_ariaLabelledby( x, p ) \
        (x)->lpVtbl->get_ariaLabelledby( x, p )
    #define IHTMLElement5_put_ariaActivedescendant( x, p ) \
        (x)->lpVtbl->put_ariaActivedescendant( x, p )
    #define IHTMLElement5_get_ariaActivedescendant( x, p ) \
        (x)->lpVtbl->get_ariaActivedescendant( x, p )
    #define IHTMLElement5_put_ariaOwns( x, p ) \
        (x)->lpVtbl->put_ariaOwns( x, p )
    #define IHTMLElement5_get_ariaOwns( x, p ) \
        (x)->lpVtbl->get_ariaOwns( x, p )
    #define IHTMLElement5_hasAttributes( x, p ) \
        (x)->lpVtbl->hasAttributes( x, p )
    #define IHTMLElement5_put_ariaLive( x, p ) \
        (x)->lpVtbl->put_ariaLive( x, p )
    #define IHTMLElement5_get_ariaLive( x, p ) \
        (x)->lpVtbl->get_ariaLive( x, p )
    #define IHTMLElement5_put_ariaRelevant( x, p ) \
        (x)->lpVtbl->put_ariaRelevant( x, p )
    #define IHTMLElement5_get_ariaRelevant( x, p ) \
        (x)->lpVtbl->get_ariaRelevant( x, p )
    #define IHTMLDatabinding_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLDatabinding_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLDatabinding_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLDatabinding_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLDatabinding_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLDatabinding_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLDatabinding_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLDatabinding_put_dataFld( x, p ) \
        (x)->lpVtbl->put_dataFld( x, p )
    #define IHTMLDatabinding_get_dataFld( x, p ) \
        (x)->lpVtbl->get_dataFld( x, p )
    #define IHTMLDatabinding_put_dataSrc( x, p ) \
        (x)->lpVtbl->put_dataSrc( x, p )
    #define IHTMLDatabinding_get_dataSrc( x, p ) \
        (x)->lpVtbl->get_dataSrc( x, p )
    #define IHTMLDatabinding_put_dataFormatAs( x, p ) \
        (x)->lpVtbl->put_dataFormatAs( x, p )
    #define IHTMLDatabinding_get_dataFormatAs( x, p ) \
        (x)->lpVtbl->get_dataFormatAs( x, p )
    #define IHTMLElementDefaults_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLElementDefaults_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLElementDefaults_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLElementDefaults_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLElementDefaults_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLElementDefaults_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLElementDefaults_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLElementDefaults_get_style( x, p ) \
        (x)->lpVtbl->get_style( x, p )
    #define IHTMLElementDefaults_put_tabStop( x, p ) \
        (x)->lpVtbl->put_tabStop( x, p )
    #define IHTMLElementDefaults_get_tabStop( x, p ) \
        (x)->lpVtbl->get_tabStop( x, p )
    #define IHTMLElementDefaults_put_viewInheritStyle( x, p ) \
        (x)->lpVtbl->put_viewInheritStyle( x, p )
    #define IHTMLElementDefaults_get_viewInheritStyle( x, p ) \
        (x)->lpVtbl->get_viewInheritStyle( x, p )
    #define IHTMLElementDefaults_put_viewMasterTab( x, p ) \
        (x)->lpVtbl->put_viewMasterTab( x, p )
    #define IHTMLElementDefaults_get_viewMasterTab( x, p ) \
        (x)->lpVtbl->get_viewMasterTab( x, p )
    #define IHTMLElementDefaults_put_scrollSegmentX( x, p ) \
        (x)->lpVtbl->put_scrollSegmentX( x, p )
    #define IHTMLElementDefaults_get_scrollSegmentX( x, p ) \
        (x)->lpVtbl->get_scrollSegmentX( x, p )
    #define IHTMLElementDefaults_put_scrollSegmentY( x, p ) \
        (x)->lpVtbl->put_scrollSegmentY( x, p )
    #define IHTMLElementDefaults_get_scrollSegmentY( x, p ) \
        (x)->lpVtbl->get_scrollSegmentY( x, p )
    #define IHTMLElementDefaults_put_isMultiLine( x, p ) \
        (x)->lpVtbl->put_isMultiLine( x, p )
    #define IHTMLElementDefaults_get_isMultiLine( x, p ) \
        (x)->lpVtbl->get_isMultiLine( x, p )
    #define IHTMLElementDefaults_put_contentEditable( x, p ) \
        (x)->lpVtbl->put_contentEditable( x, p )
    #define IHTMLElementDefaults_get_contentEditable( x, p ) \
        (x)->lpVtbl->get_contentEditable( x, p )
    #define IHTMLElementDefaults_put_canHaveHTML( x, p ) \
        (x)->lpVtbl->put_canHaveHTML( x, p )
    #define IHTMLElementDefaults_get_canHaveHTML( x, p ) \
        (x)->lpVtbl->get_canHaveHTML( x, p )
    #define IHTMLElementDefaults_putref_viewLink( x, p ) \
        (x)->lpVtbl->putref_viewLink( x, p )
    #define IHTMLElementDefaults_get_viewLink( x, p ) \
        (x)->lpVtbl->get_viewLink( x, p )
    #define IHTMLElementDefaults_put_frozen( x, p ) \
        (x)->lpVtbl->put_frozen( x, p )
    #define IHTMLElementDefaults_get_frozen( x, p ) \
        (x)->lpVtbl->get_frozen( x, p )
    #define DispHTMLDefaults_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLDefaults_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLDefaults_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLDefaults_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLDefaults_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLDefaults_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLDefaults_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTCDefaultDispatch_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTCDefaultDispatch_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTCDefaultDispatch_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTCDefaultDispatch_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTCDefaultDispatch_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTCDefaultDispatch_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTCDefaultDispatch_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTCDefaultDispatch_get_element( x, p ) \
        (x)->lpVtbl->get_element( x, p )
    #define IHTCDefaultDispatch_createEventObject( x, p ) \
        (x)->lpVtbl->createEventObject( x, p )
    #define IHTCDefaultDispatch_get_defaults( x, p ) \
        (x)->lpVtbl->get_defaults( x, p )
    #define IHTCDefaultDispatch_get_document( x, p ) \
        (x)->lpVtbl->get_document( x, p )
    #define IHTCPropertyBehavior_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTCPropertyBehavior_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTCPropertyBehavior_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTCPropertyBehavior_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTCPropertyBehavior_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTCPropertyBehavior_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTCPropertyBehavior_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTCPropertyBehavior_fireChange( x ) \
        (x)->lpVtbl->fireChange( x )
    #define IHTCPropertyBehavior_put_value( x, p ) \
        (x)->lpVtbl->put_value( x, p )
    #define IHTCPropertyBehavior_get_value( x, p ) \
        (x)->lpVtbl->get_value( x, p )
    #define IHTCMethodBehavior_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTCMethodBehavior_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTCMethodBehavior_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTCMethodBehavior_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTCMethodBehavior_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTCMethodBehavior_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTCMethodBehavior_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTCEventBehavior_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTCEventBehavior_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTCEventBehavior_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTCEventBehavior_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTCEventBehavior_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTCEventBehavior_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTCEventBehavior_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTCEventBehavior_fire( x, p ) \
        (x)->lpVtbl->fire( x, p )
    #define IHTCAttachBehavior_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTCAttachBehavior_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTCAttachBehavior_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTCAttachBehavior_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTCAttachBehavior_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTCAttachBehavior_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTCAttachBehavior_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTCAttachBehavior_fireEvent( x, p ) \
        (x)->lpVtbl->fireEvent( x, p )
    #define IHTCAttachBehavior_detachEvent( x ) \
        (x)->lpVtbl->detachEvent( x )
    #define IHTCAttachBehavior2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTCAttachBehavior2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTCAttachBehavior2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTCAttachBehavior2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTCAttachBehavior2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTCAttachBehavior2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTCAttachBehavior2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTCAttachBehavior2_fireEvent( x, p ) \
        (x)->lpVtbl->fireEvent( x, p )
    #define IHTCDescBehavior_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTCDescBehavior_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTCDescBehavior_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTCDescBehavior_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTCDescBehavior_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTCDescBehavior_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTCDescBehavior_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTCDescBehavior_get_urn( x, p ) \
        (x)->lpVtbl->get_urn( x, p )
    #define IHTCDescBehavior_get_name( x, p ) \
        (x)->lpVtbl->get_name( x, p )
    #define DispHTCDefaultDispatch_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTCDefaultDispatch_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTCDefaultDispatch_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTCDefaultDispatch_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTCDefaultDispatch_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTCDefaultDispatch_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTCDefaultDispatch_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define DispHTCPropertyBehavior_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTCPropertyBehavior_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTCPropertyBehavior_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTCPropertyBehavior_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTCPropertyBehavior_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTCPropertyBehavior_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTCPropertyBehavior_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define DispHTCMethodBehavior_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTCMethodBehavior_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTCMethodBehavior_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTCMethodBehavior_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTCMethodBehavior_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTCMethodBehavior_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTCMethodBehavior_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define DispHTCEventBehavior_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTCEventBehavior_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTCEventBehavior_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTCEventBehavior_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTCEventBehavior_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTCEventBehavior_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTCEventBehavior_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define DispHTCAttachBehavior_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTCAttachBehavior_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTCAttachBehavior_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTCAttachBehavior_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTCAttachBehavior_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTCAttachBehavior_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTCAttachBehavior_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define DispHTCDescBehavior_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTCDescBehavior_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTCDescBehavior_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTCDescBehavior_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTCDescBehavior_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTCDescBehavior_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTCDescBehavior_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLUrnCollection_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLUrnCollection_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLUrnCollection_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLUrnCollection_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLUrnCollection_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLUrnCollection_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLUrnCollection_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLUrnCollection_get_length( x, p ) \
        (x)->lpVtbl->get_length( x, p )
    #define IHTMLUrnCollection_item( x, p1, p2 ) \
        (x)->lpVtbl->item( x, p1, p2 )
    #define DispHTMLUrnCollection_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLUrnCollection_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLUrnCollection_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLUrnCollection_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLUrnCollection_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLUrnCollection_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLUrnCollection_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLGenericElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLGenericElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLGenericElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLGenericElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLGenericElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLGenericElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLGenericElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLGenericElement_get_recordset( x, p ) \
        (x)->lpVtbl->get_recordset( x, p )
    #define IHTMLGenericElement_namedRecordset( x, p1, p2, p3 ) \
        (x)->lpVtbl->namedRecordset( x, p1, p2, p3 )
    #define DispHTMLGenericElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLGenericElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLGenericElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLGenericElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLGenericElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLGenericElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLGenericElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLStyleSheetRule_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLStyleSheetRule_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLStyleSheetRule_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLStyleSheetRule_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLStyleSheetRule_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLStyleSheetRule_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLStyleSheetRule_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLStyleSheetRule_put_selectorText( x, p ) \
        (x)->lpVtbl->put_selectorText( x, p )
    #define IHTMLStyleSheetRule_get_selectorText( x, p ) \
        (x)->lpVtbl->get_selectorText( x, p )
    #define IHTMLStyleSheetRule_get_style( x, p ) \
        (x)->lpVtbl->get_style( x, p )
    #define IHTMLStyleSheetRule_get_readOnly( x, p ) \
        (x)->lpVtbl->get_readOnly( x, p )
    #define IHTMLStyleSheetRulesCollection_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLStyleSheetRulesCollection_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLStyleSheetRulesCollection_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLStyleSheetRulesCollection_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLStyleSheetRulesCollection_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLStyleSheetRulesCollection_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLStyleSheetRulesCollection_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLStyleSheetRulesCollection_get_length( x, p ) \
        (x)->lpVtbl->get_length( x, p )
    #define IHTMLStyleSheetRulesCollection_item( x, p1, p2 ) \
        (x)->lpVtbl->item( x, p1, p2 )
    #define DispHTMLStyleSheetRule_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLStyleSheetRule_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLStyleSheetRule_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLStyleSheetRule_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLStyleSheetRule_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLStyleSheetRule_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLStyleSheetRule_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define DispHTMLStyleSheetRulesCollection_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLStyleSheetRulesCollection_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLStyleSheetRulesCollection_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLStyleSheetRulesCollection_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLStyleSheetRulesCollection_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLStyleSheetRulesCollection_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLStyleSheetRulesCollection_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLStyleSheetPage_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLStyleSheetPage_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLStyleSheetPage_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLStyleSheetPage_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLStyleSheetPage_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLStyleSheetPage_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLStyleSheetPage_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLStyleSheetPage_get_selector( x, p ) \
        (x)->lpVtbl->get_selector( x, p )
    #define IHTMLStyleSheetPage_get_pseudoClass( x, p ) \
        (x)->lpVtbl->get_pseudoClass( x, p )
    #define IHTMLStyleSheetPagesCollection_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLStyleSheetPagesCollection_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLStyleSheetPagesCollection_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLStyleSheetPagesCollection_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLStyleSheetPagesCollection_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLStyleSheetPagesCollection_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLStyleSheetPagesCollection_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLStyleSheetPagesCollection_get_length( x, p ) \
        (x)->lpVtbl->get_length( x, p )
    #define IHTMLStyleSheetPagesCollection_item( x, p1, p2 ) \
        (x)->lpVtbl->item( x, p1, p2 )
    #define DispHTMLStyleSheetPage_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLStyleSheetPage_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLStyleSheetPage_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLStyleSheetPage_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLStyleSheetPage_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLStyleSheetPage_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLStyleSheetPage_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define DispHTMLStyleSheetPagesCollection_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLStyleSheetPagesCollection_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLStyleSheetPagesCollection_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLStyleSheetPagesCollection_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLStyleSheetPagesCollection_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLStyleSheetPagesCollection_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLStyleSheetPagesCollection_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLStyleSheet_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLStyleSheet_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLStyleSheet_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLStyleSheet_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLStyleSheet_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLStyleSheet_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLStyleSheet_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLStyleSheet_put_title( x, p ) \
        (x)->lpVtbl->put_title( x, p )
    #define IHTMLStyleSheet_get_title( x, p ) \
        (x)->lpVtbl->get_title( x, p )
    #define IHTMLStyleSheet_get_parentStyleSheet( x, p ) \
        (x)->lpVtbl->get_parentStyleSheet( x, p )
    #define IHTMLStyleSheet_get_owningElement( x, p ) \
        (x)->lpVtbl->get_owningElement( x, p )
    #define IHTMLStyleSheet_put_disabled( x, p ) \
        (x)->lpVtbl->put_disabled( x, p )
    #define IHTMLStyleSheet_get_disabled( x, p ) \
        (x)->lpVtbl->get_disabled( x, p )
    #define IHTMLStyleSheet_get_readOnly( x, p ) \
        (x)->lpVtbl->get_readOnly( x, p )
    #define IHTMLStyleSheet_get_imports( x, p ) \
        (x)->lpVtbl->get_imports( x, p )
    #define IHTMLStyleSheet_put_href( x, p ) \
        (x)->lpVtbl->put_href( x, p )
    #define IHTMLStyleSheet_get_href( x, p ) \
        (x)->lpVtbl->get_href( x, p )
    #define IHTMLStyleSheet_get_type( x, p ) \
        (x)->lpVtbl->get_type( x, p )
    #define IHTMLStyleSheet_get_id( x, p ) \
        (x)->lpVtbl->get_id( x, p )
    #define IHTMLStyleSheet_addImport( x, p1, p2, p3 ) \
        (x)->lpVtbl->addImport( x, p1, p2, p3 )
    #define IHTMLStyleSheet_addRule( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->addRule( x, p1, p2, p3, p4 )
    #define IHTMLStyleSheet_removeImport( x, p ) \
        (x)->lpVtbl->removeImport( x, p )
    #define IHTMLStyleSheet_removeRule( x, p ) \
        (x)->lpVtbl->removeRule( x, p )
    #define IHTMLStyleSheet_put_media( x, p ) \
        (x)->lpVtbl->put_media( x, p )
    #define IHTMLStyleSheet_get_media( x, p ) \
        (x)->lpVtbl->get_media( x, p )
    #define IHTMLStyleSheet_put_cssText( x, p ) \
        (x)->lpVtbl->put_cssText( x, p )
    #define IHTMLStyleSheet_get_cssText( x, p ) \
        (x)->lpVtbl->get_cssText( x, p )
    #define IHTMLStyleSheet_get_rules( x, p ) \
        (x)->lpVtbl->get_rules( x, p )
    #define IHTMLStyleSheet2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLStyleSheet2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLStyleSheet2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLStyleSheet2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLStyleSheet2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLStyleSheet2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLStyleSheet2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLStyleSheet2_get_pages( x, p ) \
        (x)->lpVtbl->get_pages( x, p )
    #define IHTMLStyleSheet2_addPageRule( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->addPageRule( x, p1, p2, p3, p4 )
    #define IHTMLStyleSheet3_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLStyleSheet3_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLStyleSheet3_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLStyleSheet3_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLStyleSheet3_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLStyleSheet3_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLStyleSheet3_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLStyleSheet3_put_href( x, p ) \
        (x)->lpVtbl->put_href( x, p )
    #define IHTMLStyleSheet3_get_href( x, p ) \
        (x)->lpVtbl->get_href( x, p )
    #define IHTMLStyleSheet3_get_isAlternate( x, p ) \
        (x)->lpVtbl->get_isAlternate( x, p )
    #define IHTMLStyleSheet3_get_isPrefAlternate( x, p ) \
        (x)->lpVtbl->get_isPrefAlternate( x, p )
    #define DispHTMLStyleSheet_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLStyleSheet_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLStyleSheet_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLStyleSheet_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLStyleSheet_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLStyleSheet_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLStyleSheet_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLStyleSheetsCollection_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLStyleSheetsCollection_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLStyleSheetsCollection_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLStyleSheetsCollection_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLStyleSheetsCollection_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLStyleSheetsCollection_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLStyleSheetsCollection_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLStyleSheetsCollection_get_length( x, p ) \
        (x)->lpVtbl->get_length( x, p )
    #define IHTMLStyleSheetsCollection_get__newEnum( x, p ) \
        (x)->lpVtbl->get__newEnum( x, p )
    #define IHTMLStyleSheetsCollection_item( x, p1, p2 ) \
        (x)->lpVtbl->item( x, p1, p2 )
    #define DispHTMLStyleSheetsCollection_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLStyleSheetsCollection_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLStyleSheetsCollection_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLStyleSheetsCollection_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLStyleSheetsCollection_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLStyleSheetsCollection_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLStyleSheetsCollection_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define HTMLLinkElementEvents2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define HTMLLinkElementEvents2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define HTMLLinkElementEvents2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define HTMLLinkElementEvents2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define HTMLLinkElementEvents2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define HTMLLinkElementEvents2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define HTMLLinkElementEvents2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define HTMLLinkElementEvents_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define HTMLLinkElementEvents_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define HTMLLinkElementEvents_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define HTMLLinkElementEvents_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define HTMLLinkElementEvents_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define HTMLLinkElementEvents_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define HTMLLinkElementEvents_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLLinkElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLLinkElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLLinkElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLLinkElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLLinkElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLLinkElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLLinkElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLLinkElement_put_href( x, p ) \
        (x)->lpVtbl->put_href( x, p )
    #define IHTMLLinkElement_get_href( x, p ) \
        (x)->lpVtbl->get_href( x, p )
    #define IHTMLLinkElement_put_rel( x, p ) \
        (x)->lpVtbl->put_rel( x, p )
    #define IHTMLLinkElement_get_rel( x, p ) \
        (x)->lpVtbl->get_rel( x, p )
    #define IHTMLLinkElement_put_rev( x, p ) \
        (x)->lpVtbl->put_rev( x, p )
    #define IHTMLLinkElement_get_rev( x, p ) \
        (x)->lpVtbl->get_rev( x, p )
    #define IHTMLLinkElement_put_type( x, p ) \
        (x)->lpVtbl->put_type( x, p )
    #define IHTMLLinkElement_get_type( x, p ) \
        (x)->lpVtbl->get_type( x, p )
    #define IHTMLLinkElement_get_readyState( x, p ) \
        (x)->lpVtbl->get_readyState( x, p )
    #define IHTMLLinkElement_put_onreadystatechange( x, p ) \
        (x)->lpVtbl->put_onreadystatechange( x, p )
    #define IHTMLLinkElement_get_onreadystatechange( x, p ) \
        (x)->lpVtbl->get_onreadystatechange( x, p )
    #define IHTMLLinkElement_put_onload( x, p ) \
        (x)->lpVtbl->put_onload( x, p )
    #define IHTMLLinkElement_get_onload( x, p ) \
        (x)->lpVtbl->get_onload( x, p )
    #define IHTMLLinkElement_put_onerror( x, p ) \
        (x)->lpVtbl->put_onerror( x, p )
    #define IHTMLLinkElement_get_onerror( x, p ) \
        (x)->lpVtbl->get_onerror( x, p )
    #define IHTMLLinkElement_get_styleSheet( x, p ) \
        (x)->lpVtbl->get_styleSheet( x, p )
    #define IHTMLLinkElement_put_disabled( x, p ) \
        (x)->lpVtbl->put_disabled( x, p )
    #define IHTMLLinkElement_get_disabled( x, p ) \
        (x)->lpVtbl->get_disabled( x, p )
    #define IHTMLLinkElement_put_media( x, p ) \
        (x)->lpVtbl->put_media( x, p )
    #define IHTMLLinkElement_get_media( x, p ) \
        (x)->lpVtbl->get_media( x, p )
    #define IHTMLLinkElement2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLLinkElement2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLLinkElement2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLLinkElement2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLLinkElement2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLLinkElement2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLLinkElement2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLLinkElement2_put_target( x, p ) \
        (x)->lpVtbl->put_target( x, p )
    #define IHTMLLinkElement2_get_target( x, p ) \
        (x)->lpVtbl->get_target( x, p )
    #define IHTMLLinkElement3_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLLinkElement3_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLLinkElement3_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLLinkElement3_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLLinkElement3_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLLinkElement3_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLLinkElement3_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLLinkElement3_put_charset( x, p ) \
        (x)->lpVtbl->put_charset( x, p )
    #define IHTMLLinkElement3_get_charset( x, p ) \
        (x)->lpVtbl->get_charset( x, p )
    #define IHTMLLinkElement3_put_hreflang( x, p ) \
        (x)->lpVtbl->put_hreflang( x, p )
    #define IHTMLLinkElement3_get_hreflang( x, p ) \
        (x)->lpVtbl->get_hreflang( x, p )
    #define IHTMLLinkElement4_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLLinkElement4_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLLinkElement4_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLLinkElement4_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLLinkElement4_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLLinkElement4_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLLinkElement4_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLLinkElement4_put_href( x, p ) \
        (x)->lpVtbl->put_href( x, p )
    #define IHTMLLinkElement4_get_href( x, p ) \
        (x)->lpVtbl->get_href( x, p )
    #define DispHTMLLinkElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLLinkElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLLinkElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLLinkElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLLinkElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLLinkElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLLinkElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLTxtRange_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLTxtRange_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLTxtRange_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLTxtRange_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLTxtRange_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLTxtRange_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLTxtRange_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLTxtRange_get_htmlText( x, p ) \
        (x)->lpVtbl->get_htmlText( x, p )
    #define IHTMLTxtRange_put_text( x, p ) \
        (x)->lpVtbl->put_text( x, p )
    #define IHTMLTxtRange_get_text( x, p ) \
        (x)->lpVtbl->get_text( x, p )
    #define IHTMLTxtRange_parentElement( x, p ) \
        (x)->lpVtbl->parentElement( x, p )
    #define IHTMLTxtRange_duplicate( x, p ) \
        (x)->lpVtbl->duplicate( x, p )
    #define IHTMLTxtRange_inRange( x, p1, p2 ) \
        (x)->lpVtbl->inRange( x, p1, p2 )
    #define IHTMLTxtRange_isEqual( x, p1, p2 ) \
        (x)->lpVtbl->isEqual( x, p1, p2 )
    #define IHTMLTxtRange_scrollIntoView( x, p ) \
        (x)->lpVtbl->scrollIntoView( x, p )
    #define IHTMLTxtRange_collapse( x, p ) \
        (x)->lpVtbl->collapse( x, p )
    #define IHTMLTxtRange_expand( x, p1, p2 ) \
        (x)->lpVtbl->expand( x, p1, p2 )
    #define IHTMLTxtRange_move( x, p1, p2, p3 ) \
        (x)->lpVtbl->move( x, p1, p2, p3 )
    #define IHTMLTxtRange_moveStart( x, p1, p2, p3 ) \
        (x)->lpVtbl->moveStart( x, p1, p2, p3 )
    #define IHTMLTxtRange_moveEnd( x, p1, p2, p3 ) \
        (x)->lpVtbl->moveEnd( x, p1, p2, p3 )
    #define IHTMLTxtRange_select( x ) \
        (x)->lpVtbl->select( x )
    #define IHTMLTxtRange_pasteHTML( x, p ) \
        (x)->lpVtbl->pasteHTML( x, p )
    #define IHTMLTxtRange_moveToElementText( x, p ) \
        (x)->lpVtbl->moveToElementText( x, p )
    #define IHTMLTxtRange_setEndPoint( x, p1, p2 ) \
        (x)->lpVtbl->setEndPoint( x, p1, p2 )
    #define IHTMLTxtRange_compareEndPoints( x, p1, p2, p3 ) \
        (x)->lpVtbl->compareEndPoints( x, p1, p2, p3 )
    #define IHTMLTxtRange_findText( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->findText( x, p1, p2, p3, p4 )
    #define IHTMLTxtRange_moveToPoint( x, p1, p2 ) \
        (x)->lpVtbl->moveToPoint( x, p1, p2 )
    #define IHTMLTxtRange_getBookmark( x, p ) \
        (x)->lpVtbl->getBookmark( x, p )
    #define IHTMLTxtRange_moveToBookmark( x, p1, p2 ) \
        (x)->lpVtbl->moveToBookmark( x, p1, p2 )
    #define IHTMLTxtRange_queryCommandSupported( x, p1, p2 ) \
        (x)->lpVtbl->queryCommandSupported( x, p1, p2 )
    #define IHTMLTxtRange_queryCommandEnabled( x, p1, p2 ) \
        (x)->lpVtbl->queryCommandEnabled( x, p1, p2 )
    #define IHTMLTxtRange_queryCommandState( x, p1, p2 ) \
        (x)->lpVtbl->queryCommandState( x, p1, p2 )
    #define IHTMLTxtRange_queryCommandIndeterm( x, p1, p2 ) \
        (x)->lpVtbl->queryCommandIndeterm( x, p1, p2 )
    #define IHTMLTxtRange_queryCommandText( x, p1, p2 ) \
        (x)->lpVtbl->queryCommandText( x, p1, p2 )
    #define IHTMLTxtRange_queryCommandValue( x, p1, p2 ) \
        (x)->lpVtbl->queryCommandValue( x, p1, p2 )
    #define IHTMLTxtRange_execCommand( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->execCommand( x, p1, p2, p3, p4 )
    #define IHTMLTxtRange_execCommandShowHelp( x, p1, p2 ) \
        (x)->lpVtbl->execCommandShowHelp( x, p1, p2 )
    #define IHTMLTextRangeMetrics_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLTextRangeMetrics_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLTextRangeMetrics_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLTextRangeMetrics_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLTextRangeMetrics_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLTextRangeMetrics_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLTextRangeMetrics_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLTextRangeMetrics_get_offsetTop( x, p ) \
        (x)->lpVtbl->get_offsetTop( x, p )
    #define IHTMLTextRangeMetrics_get_offsetLeft( x, p ) \
        (x)->lpVtbl->get_offsetLeft( x, p )
    #define IHTMLTextRangeMetrics_get_boundingTop( x, p ) \
        (x)->lpVtbl->get_boundingTop( x, p )
    #define IHTMLTextRangeMetrics_get_boundingLeft( x, p ) \
        (x)->lpVtbl->get_boundingLeft( x, p )
    #define IHTMLTextRangeMetrics_get_boundingWidth( x, p ) \
        (x)->lpVtbl->get_boundingWidth( x, p )
    #define IHTMLTextRangeMetrics_get_boundingHeight( x, p ) \
        (x)->lpVtbl->get_boundingHeight( x, p )
    #define IHTMLTextRangeMetrics2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLTextRangeMetrics2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLTextRangeMetrics2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLTextRangeMetrics2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLTextRangeMetrics2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLTextRangeMetrics2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLTextRangeMetrics2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLTextRangeMetrics2_getClientRects( x, p ) \
        (x)->lpVtbl->getClientRects( x, p )
    #define IHTMLTextRangeMetrics2_getBoundingClientRect( x, p ) \
        (x)->lpVtbl->getBoundingClientRect( x, p )
    #define IHTMLTxtRangeCollection_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLTxtRangeCollection_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLTxtRangeCollection_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLTxtRangeCollection_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLTxtRangeCollection_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLTxtRangeCollection_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLTxtRangeCollection_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLTxtRangeCollection_get_length( x, p ) \
        (x)->lpVtbl->get_length( x, p )
    #define IHTMLTxtRangeCollection_get__newEnum( x, p ) \
        (x)->lpVtbl->get__newEnum( x, p )
    #define IHTMLTxtRangeCollection_item( x, p1, p2 ) \
        (x)->lpVtbl->item( x, p1, p2 )
    #define HTMLFormElementEvents2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define HTMLFormElementEvents2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define HTMLFormElementEvents2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define HTMLFormElementEvents2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define HTMLFormElementEvents2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define HTMLFormElementEvents2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define HTMLFormElementEvents2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define HTMLFormElementEvents_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define HTMLFormElementEvents_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define HTMLFormElementEvents_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define HTMLFormElementEvents_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define HTMLFormElementEvents_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define HTMLFormElementEvents_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define HTMLFormElementEvents_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLFormElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLFormElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLFormElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLFormElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLFormElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLFormElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLFormElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLFormElement_put_action( x, p ) \
        (x)->lpVtbl->put_action( x, p )
    #define IHTMLFormElement_get_action( x, p ) \
        (x)->lpVtbl->get_action( x, p )
    #define IHTMLFormElement_put_dir( x, p ) \
        (x)->lpVtbl->put_dir( x, p )
    #define IHTMLFormElement_get_dir( x, p ) \
        (x)->lpVtbl->get_dir( x, p )
    #define IHTMLFormElement_put_encoding( x, p ) \
        (x)->lpVtbl->put_encoding( x, p )
    #define IHTMLFormElement_get_encoding( x, p ) \
        (x)->lpVtbl->get_encoding( x, p )
    #define IHTMLFormElement_put_method( x, p ) \
        (x)->lpVtbl->put_method( x, p )
    #define IHTMLFormElement_get_method( x, p ) \
        (x)->lpVtbl->get_method( x, p )
    #define IHTMLFormElement_get_elements( x, p ) \
        (x)->lpVtbl->get_elements( x, p )
    #define IHTMLFormElement_put_target( x, p ) \
        (x)->lpVtbl->put_target( x, p )
    #define IHTMLFormElement_get_target( x, p ) \
        (x)->lpVtbl->get_target( x, p )
    #define IHTMLFormElement_put_name( x, p ) \
        (x)->lpVtbl->put_name( x, p )
    #define IHTMLFormElement_get_name( x, p ) \
        (x)->lpVtbl->get_name( x, p )
    #define IHTMLFormElement_put_onsubmit( x, p ) \
        (x)->lpVtbl->put_onsubmit( x, p )
    #define IHTMLFormElement_get_onsubmit( x, p ) \
        (x)->lpVtbl->get_onsubmit( x, p )
    #define IHTMLFormElement_put_onreset( x, p ) \
        (x)->lpVtbl->put_onreset( x, p )
    #define IHTMLFormElement_get_onreset( x, p ) \
        (x)->lpVtbl->get_onreset( x, p )
    #define IHTMLFormElement_submit( x ) \
        (x)->lpVtbl->submit( x )
    #define IHTMLFormElement_reset( x ) \
        (x)->lpVtbl->reset( x )
    #define IHTMLFormElement_put_length( x, p ) \
        (x)->lpVtbl->put_length( x, p )
    #define IHTMLFormElement_get_length( x, p ) \
        (x)->lpVtbl->get_length( x, p )
    #define IHTMLFormElement_get__newEnum( x, p ) \
        (x)->lpVtbl->get__newEnum( x, p )
    #define IHTMLFormElement_item( x, p1, p2, p3 ) \
        (x)->lpVtbl->item( x, p1, p2, p3 )
    #define IHTMLFormElement_tags( x, p1, p2 ) \
        (x)->lpVtbl->tags( x, p1, p2 )
    #define IHTMLFormElement2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLFormElement2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLFormElement2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLFormElement2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLFormElement2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLFormElement2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLFormElement2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLFormElement2_put_acceptCharset( x, p ) \
        (x)->lpVtbl->put_acceptCharset( x, p )
    #define IHTMLFormElement2_get_acceptCharset( x, p ) \
        (x)->lpVtbl->get_acceptCharset( x, p )
    #define IHTMLFormElement2_urns( x, p1, p2 ) \
        (x)->lpVtbl->urns( x, p1, p2 )
    #define IHTMLFormElement3_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLFormElement3_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLFormElement3_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLFormElement3_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLFormElement3_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLFormElement3_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLFormElement3_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLFormElement3_namedItem( x, p1, p2 ) \
        (x)->lpVtbl->namedItem( x, p1, p2 )
    #define IHTMLSubmitData_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLSubmitData_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLSubmitData_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLSubmitData_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLSubmitData_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLSubmitData_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLSubmitData_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLSubmitData_appendNameValuePair( x, p1, p2 ) \
        (x)->lpVtbl->appendNameValuePair( x, p1, p2 )
    #define IHTMLSubmitData_appendNameFilePair( x, p1, p2 ) \
        (x)->lpVtbl->appendNameFilePair( x, p1, p2 )
    #define IHTMLSubmitData_appendItemSeparator( x ) \
        (x)->lpVtbl->appendItemSeparator( x )
    #define IHTMLFormElement4_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLFormElement4_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLFormElement4_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLFormElement4_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLFormElement4_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLFormElement4_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLFormElement4_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLFormElement4_put_action( x, p ) \
        (x)->lpVtbl->put_action( x, p )
    #define IHTMLFormElement4_get_action( x, p ) \
        (x)->lpVtbl->get_action( x, p )
    #define DispHTMLFormElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLFormElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLFormElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLFormElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLFormElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLFormElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLFormElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define HTMLControlElementEvents2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define HTMLControlElementEvents2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define HTMLControlElementEvents2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define HTMLControlElementEvents2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define HTMLControlElementEvents2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define HTMLControlElementEvents2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define HTMLControlElementEvents2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define HTMLControlElementEvents_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define HTMLControlElementEvents_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define HTMLControlElementEvents_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define HTMLControlElementEvents_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define HTMLControlElementEvents_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define HTMLControlElementEvents_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define HTMLControlElementEvents_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLControlElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLControlElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLControlElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLControlElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLControlElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLControlElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLControlElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLControlElement_put_tabIndex( x, p ) \
        (x)->lpVtbl->put_tabIndex( x, p )
    #define IHTMLControlElement_get_tabIndex( x, p ) \
        (x)->lpVtbl->get_tabIndex( x, p )
    #define IHTMLControlElement_focus( x ) \
        (x)->lpVtbl->focus( x )
    #define IHTMLControlElement_put_accessKey( x, p ) \
        (x)->lpVtbl->put_accessKey( x, p )
    #define IHTMLControlElement_get_accessKey( x, p ) \
        (x)->lpVtbl->get_accessKey( x, p )
    #define IHTMLControlElement_put_onblur( x, p ) \
        (x)->lpVtbl->put_onblur( x, p )
    #define IHTMLControlElement_get_onblur( x, p ) \
        (x)->lpVtbl->get_onblur( x, p )
    #define IHTMLControlElement_put_onfocus( x, p ) \
        (x)->lpVtbl->put_onfocus( x, p )
    #define IHTMLControlElement_get_onfocus( x, p ) \
        (x)->lpVtbl->get_onfocus( x, p )
    #define IHTMLControlElement_put_onresize( x, p ) \
        (x)->lpVtbl->put_onresize( x, p )
    #define IHTMLControlElement_get_onresize( x, p ) \
        (x)->lpVtbl->get_onresize( x, p )
    #define IHTMLControlElement_blur( x ) \
        (x)->lpVtbl->blur( x )
    #define IHTMLControlElement_addFilter( x, p ) \
        (x)->lpVtbl->addFilter( x, p )
    #define IHTMLControlElement_removeFilter( x, p ) \
        (x)->lpVtbl->removeFilter( x, p )
    #define IHTMLControlElement_get_clientHeight( x, p ) \
        (x)->lpVtbl->get_clientHeight( x, p )
    #define IHTMLControlElement_get_clientWidth( x, p ) \
        (x)->lpVtbl->get_clientWidth( x, p )
    #define IHTMLControlElement_get_clientTop( x, p ) \
        (x)->lpVtbl->get_clientTop( x, p )
    #define IHTMLControlElement_get_clientLeft( x, p ) \
        (x)->lpVtbl->get_clientLeft( x, p )
    #define IHTMLTextElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLTextElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLTextElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLTextElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLTextElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLTextElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLTextElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define DispHTMLTextElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLTextElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLTextElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLTextElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLTextElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLTextElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLTextElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define HTMLTextContainerEvents2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define HTMLTextContainerEvents2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define HTMLTextContainerEvents2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define HTMLTextContainerEvents2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define HTMLTextContainerEvents2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define HTMLTextContainerEvents2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define HTMLTextContainerEvents2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define HTMLTextContainerEvents_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define HTMLTextContainerEvents_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define HTMLTextContainerEvents_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define HTMLTextContainerEvents_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define HTMLTextContainerEvents_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define HTMLTextContainerEvents_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define HTMLTextContainerEvents_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLTextContainer_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLTextContainer_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLTextContainer_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLTextContainer_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLTextContainer_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLTextContainer_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLTextContainer_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLTextContainer_createControlRange( x, p ) \
        (x)->lpVtbl->createControlRange( x, p )
    #define IHTMLTextContainer_get_scrollHeight( x, p ) \
        (x)->lpVtbl->get_scrollHeight( x, p )
    #define IHTMLTextContainer_get_scrollWidth( x, p ) \
        (x)->lpVtbl->get_scrollWidth( x, p )
    #define IHTMLTextContainer_put_scrollTop( x, p ) \
        (x)->lpVtbl->put_scrollTop( x, p )
    #define IHTMLTextContainer_get_scrollTop( x, p ) \
        (x)->lpVtbl->get_scrollTop( x, p )
    #define IHTMLTextContainer_put_scrollLeft( x, p ) \
        (x)->lpVtbl->put_scrollLeft( x, p )
    #define IHTMLTextContainer_get_scrollLeft( x, p ) \
        (x)->lpVtbl->get_scrollLeft( x, p )
    #define IHTMLTextContainer_put_onscroll( x, p ) \
        (x)->lpVtbl->put_onscroll( x, p )
    #define IHTMLTextContainer_get_onscroll( x, p ) \
        (x)->lpVtbl->get_onscroll( x, p )
    #define IHTMLControlRange_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLControlRange_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLControlRange_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLControlRange_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLControlRange_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLControlRange_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLControlRange_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLControlRange_select( x ) \
        (x)->lpVtbl->select( x )
    #define IHTMLControlRange_add( x, p ) \
        (x)->lpVtbl->add( x, p )
    #define IHTMLControlRange_remove( x, p ) \
        (x)->lpVtbl->remove( x, p )
    #define IHTMLControlRange_item( x, p1, p2 ) \
        (x)->lpVtbl->item( x, p1, p2 )
    #define IHTMLControlRange_scrollIntoView( x, p ) \
        (x)->lpVtbl->scrollIntoView( x, p )
    #define IHTMLControlRange_queryCommandSupported( x, p1, p2 ) \
        (x)->lpVtbl->queryCommandSupported( x, p1, p2 )
    #define IHTMLControlRange_queryCommandEnabled( x, p1, p2 ) \
        (x)->lpVtbl->queryCommandEnabled( x, p1, p2 )
    #define IHTMLControlRange_queryCommandState( x, p1, p2 ) \
        (x)->lpVtbl->queryCommandState( x, p1, p2 )
    #define IHTMLControlRange_queryCommandIndeterm( x, p1, p2 ) \
        (x)->lpVtbl->queryCommandIndeterm( x, p1, p2 )
    #define IHTMLControlRange_queryCommandText( x, p1, p2 ) \
        (x)->lpVtbl->queryCommandText( x, p1, p2 )
    #define IHTMLControlRange_queryCommandValue( x, p1, p2 ) \
        (x)->lpVtbl->queryCommandValue( x, p1, p2 )
    #define IHTMLControlRange_execCommand( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->execCommand( x, p1, p2, p3, p4 )
    #define IHTMLControlRange_execCommandShowHelp( x, p1, p2 ) \
        (x)->lpVtbl->execCommandShowHelp( x, p1, p2 )
    #define IHTMLControlRange_commonParentElement( x, p ) \
        (x)->lpVtbl->commonParentElement( x, p )
    #define IHTMLControlRange_get_length( x, p ) \
        (x)->lpVtbl->get_length( x, p )
    #define IHTMLControlRange2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLControlRange2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLControlRange2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLControlRange2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLControlRange2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLControlRange2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLControlRange2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLControlRange2_addElement( x, p ) \
        (x)->lpVtbl->addElement( x, p )
    #define HTMLImgEvents2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define HTMLImgEvents2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define HTMLImgEvents2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define HTMLImgEvents2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define HTMLImgEvents2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define HTMLImgEvents2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define HTMLImgEvents2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define HTMLImgEvents_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define HTMLImgEvents_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define HTMLImgEvents_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define HTMLImgEvents_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define HTMLImgEvents_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define HTMLImgEvents_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define HTMLImgEvents_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLImgElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLImgElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLImgElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLImgElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLImgElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLImgElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLImgElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLImgElement_put_isMap( x, p ) \
        (x)->lpVtbl->put_isMap( x, p )
    #define IHTMLImgElement_get_isMap( x, p ) \
        (x)->lpVtbl->get_isMap( x, p )
    #define IHTMLImgElement_put_useMap( x, p ) \
        (x)->lpVtbl->put_useMap( x, p )
    #define IHTMLImgElement_get_useMap( x, p ) \
        (x)->lpVtbl->get_useMap( x, p )
    #define IHTMLImgElement_get_mimeType( x, p ) \
        (x)->lpVtbl->get_mimeType( x, p )
    #define IHTMLImgElement_get_fileSize( x, p ) \
        (x)->lpVtbl->get_fileSize( x, p )
    #define IHTMLImgElement_get_fileCreatedDate( x, p ) \
        (x)->lpVtbl->get_fileCreatedDate( x, p )
    #define IHTMLImgElement_get_fileModifiedDate( x, p ) \
        (x)->lpVtbl->get_fileModifiedDate( x, p )
    #define IHTMLImgElement_get_fileUpdatedDate( x, p ) \
        (x)->lpVtbl->get_fileUpdatedDate( x, p )
    #define IHTMLImgElement_get_protocol( x, p ) \
        (x)->lpVtbl->get_protocol( x, p )
    #define IHTMLImgElement_get_href( x, p ) \
        (x)->lpVtbl->get_href( x, p )
    #define IHTMLImgElement_get_nameProp( x, p ) \
        (x)->lpVtbl->get_nameProp( x, p )
    #define IHTMLImgElement_put_border( x, p ) \
        (x)->lpVtbl->put_border( x, p )
    #define IHTMLImgElement_get_border( x, p ) \
        (x)->lpVtbl->get_border( x, p )
    #define IHTMLImgElement_put_vspace( x, p ) \
        (x)->lpVtbl->put_vspace( x, p )
    #define IHTMLImgElement_get_vspace( x, p ) \
        (x)->lpVtbl->get_vspace( x, p )
    #define IHTMLImgElement_put_hspace( x, p ) \
        (x)->lpVtbl->put_hspace( x, p )
    #define IHTMLImgElement_get_hspace( x, p ) \
        (x)->lpVtbl->get_hspace( x, p )
    #define IHTMLImgElement_put_alt( x, p ) \
        (x)->lpVtbl->put_alt( x, p )
    #define IHTMLImgElement_get_alt( x, p ) \
        (x)->lpVtbl->get_alt( x, p )
    #define IHTMLImgElement_put_src( x, p ) \
        (x)->lpVtbl->put_src( x, p )
    #define IHTMLImgElement_get_src( x, p ) \
        (x)->lpVtbl->get_src( x, p )
    #define IHTMLImgElement_put_lowsrc( x, p ) \
        (x)->lpVtbl->put_lowsrc( x, p )
    #define IHTMLImgElement_get_lowsrc( x, p ) \
        (x)->lpVtbl->get_lowsrc( x, p )
    #define IHTMLImgElement_put_vrml( x, p ) \
        (x)->lpVtbl->put_vrml( x, p )
    #define IHTMLImgElement_get_vrml( x, p ) \
        (x)->lpVtbl->get_vrml( x, p )
    #define IHTMLImgElement_put_dynsrc( x, p ) \
        (x)->lpVtbl->put_dynsrc( x, p )
    #define IHTMLImgElement_get_dynsrc( x, p ) \
        (x)->lpVtbl->get_dynsrc( x, p )
    #define IHTMLImgElement_get_readyState( x, p ) \
        (x)->lpVtbl->get_readyState( x, p )
    #define IHTMLImgElement_get_complete( x, p ) \
        (x)->lpVtbl->get_complete( x, p )
    #define IHTMLImgElement_put_loop( x, p ) \
        (x)->lpVtbl->put_loop( x, p )
    #define IHTMLImgElement_get_loop( x, p ) \
        (x)->lpVtbl->get_loop( x, p )
    #define IHTMLImgElement_put_align( x, p ) \
        (x)->lpVtbl->put_align( x, p )
    #define IHTMLImgElement_get_align( x, p ) \
        (x)->lpVtbl->get_align( x, p )
    #define IHTMLImgElement_put_onload( x, p ) \
        (x)->lpVtbl->put_onload( x, p )
    #define IHTMLImgElement_get_onload( x, p ) \
        (x)->lpVtbl->get_onload( x, p )
    #define IHTMLImgElement_put_onerror( x, p ) \
        (x)->lpVtbl->put_onerror( x, p )
    #define IHTMLImgElement_get_onerror( x, p ) \
        (x)->lpVtbl->get_onerror( x, p )
    #define IHTMLImgElement_put_onabort( x, p ) \
        (x)->lpVtbl->put_onabort( x, p )
    #define IHTMLImgElement_get_onabort( x, p ) \
        (x)->lpVtbl->get_onabort( x, p )
    #define IHTMLImgElement_put_name( x, p ) \
        (x)->lpVtbl->put_name( x, p )
    #define IHTMLImgElement_get_name( x, p ) \
        (x)->lpVtbl->get_name( x, p )
    #define IHTMLImgElement_put_width( x, p ) \
        (x)->lpVtbl->put_width( x, p )
    #define IHTMLImgElement_get_width( x, p ) \
        (x)->lpVtbl->get_width( x, p )
    #define IHTMLImgElement_put_height( x, p ) \
        (x)->lpVtbl->put_height( x, p )
    #define IHTMLImgElement_get_height( x, p ) \
        (x)->lpVtbl->get_height( x, p )
    #define IHTMLImgElement_put_start( x, p ) \
        (x)->lpVtbl->put_start( x, p )
    #define IHTMLImgElement_get_start( x, p ) \
        (x)->lpVtbl->get_start( x, p )
    #define IHTMLImgElement2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLImgElement2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLImgElement2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLImgElement2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLImgElement2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLImgElement2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLImgElement2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLImgElement2_put_longDesc( x, p ) \
        (x)->lpVtbl->put_longDesc( x, p )
    #define IHTMLImgElement2_get_longDesc( x, p ) \
        (x)->lpVtbl->get_longDesc( x, p )
    #define IHTMLImgElement3_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLImgElement3_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLImgElement3_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLImgElement3_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLImgElement3_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLImgElement3_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLImgElement3_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLImgElement3_put_longDesc( x, p ) \
        (x)->lpVtbl->put_longDesc( x, p )
    #define IHTMLImgElement3_get_longDesc( x, p ) \
        (x)->lpVtbl->get_longDesc( x, p )
    #define IHTMLImgElement3_put_vrml( x, p ) \
        (x)->lpVtbl->put_vrml( x, p )
    #define IHTMLImgElement3_get_vrml( x, p ) \
        (x)->lpVtbl->get_vrml( x, p )
    #define IHTMLImgElement3_put_lowsrc( x, p ) \
        (x)->lpVtbl->put_lowsrc( x, p )
    #define IHTMLImgElement3_get_lowsrc( x, p ) \
        (x)->lpVtbl->get_lowsrc( x, p )
    #define IHTMLImgElement3_put_dynsrc( x, p ) \
        (x)->lpVtbl->put_dynsrc( x, p )
    #define IHTMLImgElement3_get_dynsrc( x, p ) \
        (x)->lpVtbl->get_dynsrc( x, p )
    #define IHTMLImageElementFactory_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLImageElementFactory_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLImageElementFactory_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLImageElementFactory_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLImageElementFactory_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLImageElementFactory_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLImageElementFactory_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLImageElementFactory_create( x, p1, p2, p3 ) \
        (x)->lpVtbl->create( x, p1, p2, p3 )
    #define DispHTMLImg_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLImg_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLImg_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLImg_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLImg_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLImg_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLImg_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define HTMLXMLHttpRequestEvents_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define HTMLXMLHttpRequestEvents_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define HTMLXMLHttpRequestEvents_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define HTMLXMLHttpRequestEvents_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define HTMLXMLHttpRequestEvents_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define HTMLXMLHttpRequestEvents_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define HTMLXMLHttpRequestEvents_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLXMLHttpRequest_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLXMLHttpRequest_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLXMLHttpRequest_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLXMLHttpRequest_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLXMLHttpRequest_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLXMLHttpRequest_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLXMLHttpRequest_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLXMLHttpRequest_get_readyState( x, p ) \
        (x)->lpVtbl->get_readyState( x, p )
    #define IHTMLXMLHttpRequest_get_responseBody( x, p ) \
        (x)->lpVtbl->get_responseBody( x, p )
    #define IHTMLXMLHttpRequest_get_responseText( x, p ) \
        (x)->lpVtbl->get_responseText( x, p )
    #define IHTMLXMLHttpRequest_get_responseXML( x, p ) \
        (x)->lpVtbl->get_responseXML( x, p )
    #define IHTMLXMLHttpRequest_get_status( x, p ) \
        (x)->lpVtbl->get_status( x, p )
    #define IHTMLXMLHttpRequest_get_statusText( x, p ) \
        (x)->lpVtbl->get_statusText( x, p )
    #define IHTMLXMLHttpRequest_put_onreadystatechange( x, p ) \
        (x)->lpVtbl->put_onreadystatechange( x, p )
    #define IHTMLXMLHttpRequest_get_onreadystatechange( x, p ) \
        (x)->lpVtbl->get_onreadystatechange( x, p )
    #define IHTMLXMLHttpRequest_abort( x ) \
        (x)->lpVtbl->abort( x )
    #define IHTMLXMLHttpRequest_open( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->open( x, p1, p2, p3, p4, p5 )
    #define IHTMLXMLHttpRequest_send( x, p ) \
        (x)->lpVtbl->send( x, p )
    #define IHTMLXMLHttpRequest_getAllResponseHeaders( x, p ) \
        (x)->lpVtbl->getAllResponseHeaders( x, p )
    #define IHTMLXMLHttpRequest_getResponseHeader( x, p1, p2 ) \
        (x)->lpVtbl->getResponseHeader( x, p1, p2 )
    #define IHTMLXMLHttpRequest_setRequestHeader( x, p1, p2 ) \
        (x)->lpVtbl->setRequestHeader( x, p1, p2 )
    #define IHTMLXMLHttpRequest2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLXMLHttpRequest2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLXMLHttpRequest2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLXMLHttpRequest2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLXMLHttpRequest2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLXMLHttpRequest2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLXMLHttpRequest2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLXMLHttpRequest2_put_timeout( x, p ) \
        (x)->lpVtbl->put_timeout( x, p )
    #define IHTMLXMLHttpRequest2_get_timeout( x, p ) \
        (x)->lpVtbl->get_timeout( x, p )
    #define IHTMLXMLHttpRequest2_put_ontimeout( x, p ) \
        (x)->lpVtbl->put_ontimeout( x, p )
    #define IHTMLXMLHttpRequest2_get_ontimeout( x, p ) \
        (x)->lpVtbl->get_ontimeout( x, p )
    #define IHTMLXMLHttpRequestFactory_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLXMLHttpRequestFactory_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLXMLHttpRequestFactory_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLXMLHttpRequestFactory_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLXMLHttpRequestFactory_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLXMLHttpRequestFactory_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLXMLHttpRequestFactory_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLXMLHttpRequestFactory_create( x, p ) \
        (x)->lpVtbl->create( x, p )
    #define DispHTMLXMLHttpRequest_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLXMLHttpRequest_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLXMLHttpRequest_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLXMLHttpRequest_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLXMLHttpRequest_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLXMLHttpRequest_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLXMLHttpRequest_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLBodyElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLBodyElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLBodyElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLBodyElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLBodyElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLBodyElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLBodyElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLBodyElement_put_background( x, p ) \
        (x)->lpVtbl->put_background( x, p )
    #define IHTMLBodyElement_get_background( x, p ) \
        (x)->lpVtbl->get_background( x, p )
    #define IHTMLBodyElement_put_bgProperties( x, p ) \
        (x)->lpVtbl->put_bgProperties( x, p )
    #define IHTMLBodyElement_get_bgProperties( x, p ) \
        (x)->lpVtbl->get_bgProperties( x, p )
    #define IHTMLBodyElement_put_leftMargin( x, p ) \
        (x)->lpVtbl->put_leftMargin( x, p )
    #define IHTMLBodyElement_get_leftMargin( x, p ) \
        (x)->lpVtbl->get_leftMargin( x, p )
    #define IHTMLBodyElement_put_topMargin( x, p ) \
        (x)->lpVtbl->put_topMargin( x, p )
    #define IHTMLBodyElement_get_topMargin( x, p ) \
        (x)->lpVtbl->get_topMargin( x, p )
    #define IHTMLBodyElement_put_rightMargin( x, p ) \
        (x)->lpVtbl->put_rightMargin( x, p )
    #define IHTMLBodyElement_get_rightMargin( x, p ) \
        (x)->lpVtbl->get_rightMargin( x, p )
    #define IHTMLBodyElement_put_bottomMargin( x, p ) \
        (x)->lpVtbl->put_bottomMargin( x, p )
    #define IHTMLBodyElement_get_bottomMargin( x, p ) \
        (x)->lpVtbl->get_bottomMargin( x, p )
    #define IHTMLBodyElement_put_noWrap( x, p ) \
        (x)->lpVtbl->put_noWrap( x, p )
    #define IHTMLBodyElement_get_noWrap( x, p ) \
        (x)->lpVtbl->get_noWrap( x, p )
    #define IHTMLBodyElement_put_bgColor( x, p ) \
        (x)->lpVtbl->put_bgColor( x, p )
    #define IHTMLBodyElement_get_bgColor( x, p ) \
        (x)->lpVtbl->get_bgColor( x, p )
    #define IHTMLBodyElement_put_text( x, p ) \
        (x)->lpVtbl->put_text( x, p )
    #define IHTMLBodyElement_get_text( x, p ) \
        (x)->lpVtbl->get_text( x, p )
    #define IHTMLBodyElement_put_link( x, p ) \
        (x)->lpVtbl->put_link( x, p )
    #define IHTMLBodyElement_get_link( x, p ) \
        (x)->lpVtbl->get_link( x, p )
    #define IHTMLBodyElement_put_vLink( x, p ) \
        (x)->lpVtbl->put_vLink( x, p )
    #define IHTMLBodyElement_get_vLink( x, p ) \
        (x)->lpVtbl->get_vLink( x, p )
    #define IHTMLBodyElement_put_aLink( x, p ) \
        (x)->lpVtbl->put_aLink( x, p )
    #define IHTMLBodyElement_get_aLink( x, p ) \
        (x)->lpVtbl->get_aLink( x, p )
    #define IHTMLBodyElement_put_onload( x, p ) \
        (x)->lpVtbl->put_onload( x, p )
    #define IHTMLBodyElement_get_onload( x, p ) \
        (x)->lpVtbl->get_onload( x, p )
    #define IHTMLBodyElement_put_onunload( x, p ) \
        (x)->lpVtbl->put_onunload( x, p )
    #define IHTMLBodyElement_get_onunload( x, p ) \
        (x)->lpVtbl->get_onunload( x, p )
    #define IHTMLBodyElement_put_scroll( x, p ) \
        (x)->lpVtbl->put_scroll( x, p )
    #define IHTMLBodyElement_get_scroll( x, p ) \
        (x)->lpVtbl->get_scroll( x, p )
    #define IHTMLBodyElement_put_onselect( x, p ) \
        (x)->lpVtbl->put_onselect( x, p )
    #define IHTMLBodyElement_get_onselect( x, p ) \
        (x)->lpVtbl->get_onselect( x, p )
    #define IHTMLBodyElement_put_onbeforeunload( x, p ) \
        (x)->lpVtbl->put_onbeforeunload( x, p )
    #define IHTMLBodyElement_get_onbeforeunload( x, p ) \
        (x)->lpVtbl->get_onbeforeunload( x, p )
    #define IHTMLBodyElement_createTextRange( x, p ) \
        (x)->lpVtbl->createTextRange( x, p )
    #define IHTMLBodyElement2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLBodyElement2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLBodyElement2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLBodyElement2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLBodyElement2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLBodyElement2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLBodyElement2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLBodyElement2_put_onbeforeprint( x, p ) \
        (x)->lpVtbl->put_onbeforeprint( x, p )
    #define IHTMLBodyElement2_get_onbeforeprint( x, p ) \
        (x)->lpVtbl->get_onbeforeprint( x, p )
    #define IHTMLBodyElement2_put_onafterprint( x, p ) \
        (x)->lpVtbl->put_onafterprint( x, p )
    #define IHTMLBodyElement2_get_onafterprint( x, p ) \
        (x)->lpVtbl->get_onafterprint( x, p )
    #define IHTMLBodyElement3_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLBodyElement3_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLBodyElement3_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLBodyElement3_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLBodyElement3_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLBodyElement3_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLBodyElement3_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLBodyElement3_put_background( x, p ) \
        (x)->lpVtbl->put_background( x, p )
    #define IHTMLBodyElement3_get_background( x, p ) \
        (x)->lpVtbl->get_background( x, p )
    #define IHTMLBodyElement3_put_ononline( x, p ) \
        (x)->lpVtbl->put_ononline( x, p )
    #define IHTMLBodyElement3_get_ononline( x, p ) \
        (x)->lpVtbl->get_ononline( x, p )
    #define IHTMLBodyElement3_put_onoffline( x, p ) \
        (x)->lpVtbl->put_onoffline( x, p )
    #define IHTMLBodyElement3_get_onoffline( x, p ) \
        (x)->lpVtbl->get_onoffline( x, p )
    #define IHTMLBodyElement3_put_onhashchange( x, p ) \
        (x)->lpVtbl->put_onhashchange( x, p )
    #define IHTMLBodyElement3_get_onhashchange( x, p ) \
        (x)->lpVtbl->get_onhashchange( x, p )
    #define DispHTMLBody_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLBody_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLBody_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLBody_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLBody_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLBody_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLBody_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLFontElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLFontElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLFontElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLFontElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLFontElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLFontElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLFontElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLFontElement_put_color( x, p ) \
        (x)->lpVtbl->put_color( x, p )
    #define IHTMLFontElement_get_color( x, p ) \
        (x)->lpVtbl->get_color( x, p )
    #define IHTMLFontElement_put_face( x, p ) \
        (x)->lpVtbl->put_face( x, p )
    #define IHTMLFontElement_get_face( x, p ) \
        (x)->lpVtbl->get_face( x, p )
    #define IHTMLFontElement_put_size( x, p ) \
        (x)->lpVtbl->put_size( x, p )
    #define IHTMLFontElement_get_size( x, p ) \
        (x)->lpVtbl->get_size( x, p )
    #define DispHTMLFontElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLFontElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLFontElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLFontElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLFontElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLFontElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLFontElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define HTMLAnchorEvents2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define HTMLAnchorEvents2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define HTMLAnchorEvents2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define HTMLAnchorEvents2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define HTMLAnchorEvents2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define HTMLAnchorEvents2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define HTMLAnchorEvents2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define HTMLAnchorEvents_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define HTMLAnchorEvents_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define HTMLAnchorEvents_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define HTMLAnchorEvents_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define HTMLAnchorEvents_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define HTMLAnchorEvents_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define HTMLAnchorEvents_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLAnchorElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLAnchorElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLAnchorElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLAnchorElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLAnchorElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLAnchorElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLAnchorElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLAnchorElement_put_href( x, p ) \
        (x)->lpVtbl->put_href( x, p )
    #define IHTMLAnchorElement_get_href( x, p ) \
        (x)->lpVtbl->get_href( x, p )
    #define IHTMLAnchorElement_put_target( x, p ) \
        (x)->lpVtbl->put_target( x, p )
    #define IHTMLAnchorElement_get_target( x, p ) \
        (x)->lpVtbl->get_target( x, p )
    #define IHTMLAnchorElement_put_rel( x, p ) \
        (x)->lpVtbl->put_rel( x, p )
    #define IHTMLAnchorElement_get_rel( x, p ) \
        (x)->lpVtbl->get_rel( x, p )
    #define IHTMLAnchorElement_put_rev( x, p ) \
        (x)->lpVtbl->put_rev( x, p )
    #define IHTMLAnchorElement_get_rev( x, p ) \
        (x)->lpVtbl->get_rev( x, p )
    #define IHTMLAnchorElement_put_urn( x, p ) \
        (x)->lpVtbl->put_urn( x, p )
    #define IHTMLAnchorElement_get_urn( x, p ) \
        (x)->lpVtbl->get_urn( x, p )
    #define IHTMLAnchorElement_put_Methods( x, p ) \
        (x)->lpVtbl->put_Methods( x, p )
    #define IHTMLAnchorElement_get_Methods( x, p ) \
        (x)->lpVtbl->get_Methods( x, p )
    #define IHTMLAnchorElement_put_name( x, p ) \
        (x)->lpVtbl->put_name( x, p )
    #define IHTMLAnchorElement_get_name( x, p ) \
        (x)->lpVtbl->get_name( x, p )
    #define IHTMLAnchorElement_put_host( x, p ) \
        (x)->lpVtbl->put_host( x, p )
    #define IHTMLAnchorElement_get_host( x, p ) \
        (x)->lpVtbl->get_host( x, p )
    #define IHTMLAnchorElement_put_hostname( x, p ) \
        (x)->lpVtbl->put_hostname( x, p )
    #define IHTMLAnchorElement_get_hostname( x, p ) \
        (x)->lpVtbl->get_hostname( x, p )
    #define IHTMLAnchorElement_put_pathname( x, p ) \
        (x)->lpVtbl->put_pathname( x, p )
    #define IHTMLAnchorElement_get_pathname( x, p ) \
        (x)->lpVtbl->get_pathname( x, p )
    #define IHTMLAnchorElement_put_port( x, p ) \
        (x)->lpVtbl->put_port( x, p )
    #define IHTMLAnchorElement_get_port( x, p ) \
        (x)->lpVtbl->get_port( x, p )
    #define IHTMLAnchorElement_put_protocol( x, p ) \
        (x)->lpVtbl->put_protocol( x, p )
    #define IHTMLAnchorElement_get_protocol( x, p ) \
        (x)->lpVtbl->get_protocol( x, p )
    #define IHTMLAnchorElement_put_search( x, p ) \
        (x)->lpVtbl->put_search( x, p )
    #define IHTMLAnchorElement_get_search( x, p ) \
        (x)->lpVtbl->get_search( x, p )
    #define IHTMLAnchorElement_put_hash( x, p ) \
        (x)->lpVtbl->put_hash( x, p )
    #define IHTMLAnchorElement_get_hash( x, p ) \
        (x)->lpVtbl->get_hash( x, p )
    #define IHTMLAnchorElement_put_onblur( x, p ) \
        (x)->lpVtbl->put_onblur( x, p )
    #define IHTMLAnchorElement_get_onblur( x, p ) \
        (x)->lpVtbl->get_onblur( x, p )
    #define IHTMLAnchorElement_put_onfocus( x, p ) \
        (x)->lpVtbl->put_onfocus( x, p )
    #define IHTMLAnchorElement_get_onfocus( x, p ) \
        (x)->lpVtbl->get_onfocus( x, p )
    #define IHTMLAnchorElement_put_accessKey( x, p ) \
        (x)->lpVtbl->put_accessKey( x, p )
    #define IHTMLAnchorElement_get_accessKey( x, p ) \
        (x)->lpVtbl->get_accessKey( x, p )
    #define IHTMLAnchorElement_get_protocolLong( x, p ) \
        (x)->lpVtbl->get_protocolLong( x, p )
    #define IHTMLAnchorElement_get_mimeType( x, p ) \
        (x)->lpVtbl->get_mimeType( x, p )
    #define IHTMLAnchorElement_get_nameProp( x, p ) \
        (x)->lpVtbl->get_nameProp( x, p )
    #define IHTMLAnchorElement_put_tabIndex( x, p ) \
        (x)->lpVtbl->put_tabIndex( x, p )
    #define IHTMLAnchorElement_get_tabIndex( x, p ) \
        (x)->lpVtbl->get_tabIndex( x, p )
    #define IHTMLAnchorElement_focus( x ) \
        (x)->lpVtbl->focus( x )
    #define IHTMLAnchorElement_blur( x ) \
        (x)->lpVtbl->blur( x )
    #define IHTMLAnchorElement2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLAnchorElement2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLAnchorElement2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLAnchorElement2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLAnchorElement2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLAnchorElement2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLAnchorElement2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLAnchorElement2_put_charset( x, p ) \
        (x)->lpVtbl->put_charset( x, p )
    #define IHTMLAnchorElement2_get_charset( x, p ) \
        (x)->lpVtbl->get_charset( x, p )
    #define IHTMLAnchorElement2_put_coords( x, p ) \
        (x)->lpVtbl->put_coords( x, p )
    #define IHTMLAnchorElement2_get_coords( x, p ) \
        (x)->lpVtbl->get_coords( x, p )
    #define IHTMLAnchorElement2_put_hreflang( x, p ) \
        (x)->lpVtbl->put_hreflang( x, p )
    #define IHTMLAnchorElement2_get_hreflang( x, p ) \
        (x)->lpVtbl->get_hreflang( x, p )
    #define IHTMLAnchorElement2_put_shape( x, p ) \
        (x)->lpVtbl->put_shape( x, p )
    #define IHTMLAnchorElement2_get_shape( x, p ) \
        (x)->lpVtbl->get_shape( x, p )
    #define IHTMLAnchorElement2_put_type( x, p ) \
        (x)->lpVtbl->put_type( x, p )
    #define IHTMLAnchorElement2_get_type( x, p ) \
        (x)->lpVtbl->get_type( x, p )
    #define IHTMLAnchorElement3_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLAnchorElement3_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLAnchorElement3_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLAnchorElement3_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLAnchorElement3_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLAnchorElement3_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLAnchorElement3_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLAnchorElement3_put_shape( x, p ) \
        (x)->lpVtbl->put_shape( x, p )
    #define IHTMLAnchorElement3_get_shape( x, p ) \
        (x)->lpVtbl->get_shape( x, p )
    #define IHTMLAnchorElement3_put_coords( x, p ) \
        (x)->lpVtbl->put_coords( x, p )
    #define IHTMLAnchorElement3_get_coords( x, p ) \
        (x)->lpVtbl->get_coords( x, p )
    #define IHTMLAnchorElement3_put_href( x, p ) \
        (x)->lpVtbl->put_href( x, p )
    #define IHTMLAnchorElement3_get_href( x, p ) \
        (x)->lpVtbl->get_href( x, p )
    #define DispHTMLAnchorElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLAnchorElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLAnchorElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLAnchorElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLAnchorElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLAnchorElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLAnchorElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define HTMLLabelEvents2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define HTMLLabelEvents2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define HTMLLabelEvents2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define HTMLLabelEvents2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define HTMLLabelEvents2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define HTMLLabelEvents2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define HTMLLabelEvents2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define HTMLLabelEvents_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define HTMLLabelEvents_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define HTMLLabelEvents_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define HTMLLabelEvents_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define HTMLLabelEvents_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define HTMLLabelEvents_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define HTMLLabelEvents_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLLabelElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLLabelElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLLabelElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLLabelElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLLabelElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLLabelElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLLabelElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLLabelElement_put_htmlFor( x, p ) \
        (x)->lpVtbl->put_htmlFor( x, p )
    #define IHTMLLabelElement_get_htmlFor( x, p ) \
        (x)->lpVtbl->get_htmlFor( x, p )
    #define IHTMLLabelElement_put_accessKey( x, p ) \
        (x)->lpVtbl->put_accessKey( x, p )
    #define IHTMLLabelElement_get_accessKey( x, p ) \
        (x)->lpVtbl->get_accessKey( x, p )
    #define IHTMLLabelElement2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLLabelElement2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLLabelElement2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLLabelElement2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLLabelElement2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLLabelElement2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLLabelElement2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLLabelElement2_get_form( x, p ) \
        (x)->lpVtbl->get_form( x, p )
    #define DispHTMLLabelElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLLabelElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLLabelElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLLabelElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLLabelElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLLabelElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLLabelElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLListElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLListElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLListElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLListElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLListElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLListElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLListElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLListElement2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLListElement2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLListElement2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLListElement2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLListElement2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLListElement2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLListElement2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLListElement2_put_compact( x, p ) \
        (x)->lpVtbl->put_compact( x, p )
    #define IHTMLListElement2_get_compact( x, p ) \
        (x)->lpVtbl->get_compact( x, p )
    #define DispHTMLListElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLListElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLListElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLListElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLListElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLListElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLListElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLUListElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLUListElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLUListElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLUListElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLUListElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLUListElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLUListElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLUListElement_put_compact( x, p ) \
        (x)->lpVtbl->put_compact( x, p )
    #define IHTMLUListElement_get_compact( x, p ) \
        (x)->lpVtbl->get_compact( x, p )
    #define IHTMLUListElement_put_type( x, p ) \
        (x)->lpVtbl->put_type( x, p )
    #define IHTMLUListElement_get_type( x, p ) \
        (x)->lpVtbl->get_type( x, p )
    #define DispHTMLUListElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLUListElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLUListElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLUListElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLUListElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLUListElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLUListElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLOListElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLOListElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLOListElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLOListElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLOListElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLOListElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLOListElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLOListElement_put_compact( x, p ) \
        (x)->lpVtbl->put_compact( x, p )
    #define IHTMLOListElement_get_compact( x, p ) \
        (x)->lpVtbl->get_compact( x, p )
    #define IHTMLOListElement_put_start( x, p ) \
        (x)->lpVtbl->put_start( x, p )
    #define IHTMLOListElement_get_start( x, p ) \
        (x)->lpVtbl->get_start( x, p )
    #define IHTMLOListElement_put_type( x, p ) \
        (x)->lpVtbl->put_type( x, p )
    #define IHTMLOListElement_get_type( x, p ) \
        (x)->lpVtbl->get_type( x, p )
    #define DispHTMLOListElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLOListElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLOListElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLOListElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLOListElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLOListElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLOListElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLLIElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLLIElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLLIElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLLIElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLLIElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLLIElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLLIElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLLIElement_put_type( x, p ) \
        (x)->lpVtbl->put_type( x, p )
    #define IHTMLLIElement_get_type( x, p ) \
        (x)->lpVtbl->get_type( x, p )
    #define IHTMLLIElement_put_value( x, p ) \
        (x)->lpVtbl->put_value( x, p )
    #define IHTMLLIElement_get_value( x, p ) \
        (x)->lpVtbl->get_value( x, p )
    #define DispHTMLLIElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLLIElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLLIElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLLIElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLLIElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLLIElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLLIElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLBlockElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLBlockElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLBlockElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLBlockElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLBlockElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLBlockElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLBlockElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLBlockElement_put_clear( x, p ) \
        (x)->lpVtbl->put_clear( x, p )
    #define IHTMLBlockElement_get_clear( x, p ) \
        (x)->lpVtbl->get_clear( x, p )
    #define IHTMLBlockElement2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLBlockElement2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLBlockElement2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLBlockElement2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLBlockElement2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLBlockElement2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLBlockElement2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLBlockElement2_put_cite( x, p ) \
        (x)->lpVtbl->put_cite( x, p )
    #define IHTMLBlockElement2_get_cite( x, p ) \
        (x)->lpVtbl->get_cite( x, p )
    #define IHTMLBlockElement2_put_width( x, p ) \
        (x)->lpVtbl->put_width( x, p )
    #define IHTMLBlockElement2_get_width( x, p ) \
        (x)->lpVtbl->get_width( x, p )
    #define IHTMLBlockElement3_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLBlockElement3_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLBlockElement3_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLBlockElement3_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLBlockElement3_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLBlockElement3_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLBlockElement3_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLBlockElement3_put_cite( x, p ) \
        (x)->lpVtbl->put_cite( x, p )
    #define IHTMLBlockElement3_get_cite( x, p ) \
        (x)->lpVtbl->get_cite( x, p )
    #define DispHTMLBlockElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLBlockElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLBlockElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLBlockElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLBlockElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLBlockElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLBlockElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLDivElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLDivElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLDivElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLDivElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLDivElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLDivElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLDivElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLDivElement_put_align( x, p ) \
        (x)->lpVtbl->put_align( x, p )
    #define IHTMLDivElement_get_align( x, p ) \
        (x)->lpVtbl->get_align( x, p )
    #define IHTMLDivElement_put_noWrap( x, p ) \
        (x)->lpVtbl->put_noWrap( x, p )
    #define IHTMLDivElement_get_noWrap( x, p ) \
        (x)->lpVtbl->get_noWrap( x, p )
    #define DispHTMLDivElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLDivElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLDivElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLDivElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLDivElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLDivElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLDivElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLDDElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLDDElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLDDElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLDDElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLDDElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLDDElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLDDElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLDDElement_put_noWrap( x, p ) \
        (x)->lpVtbl->put_noWrap( x, p )
    #define IHTMLDDElement_get_noWrap( x, p ) \
        (x)->lpVtbl->get_noWrap( x, p )
    #define DispHTMLDDElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLDDElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLDDElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLDDElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLDDElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLDDElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLDDElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLDTElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLDTElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLDTElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLDTElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLDTElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLDTElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLDTElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLDTElement_put_noWrap( x, p ) \
        (x)->lpVtbl->put_noWrap( x, p )
    #define IHTMLDTElement_get_noWrap( x, p ) \
        (x)->lpVtbl->get_noWrap( x, p )
    #define DispHTMLDTElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLDTElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLDTElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLDTElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLDTElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLDTElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLDTElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLBRElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLBRElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLBRElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLBRElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLBRElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLBRElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLBRElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLBRElement_put_clear( x, p ) \
        (x)->lpVtbl->put_clear( x, p )
    #define IHTMLBRElement_get_clear( x, p ) \
        (x)->lpVtbl->get_clear( x, p )
    #define DispHTMLBRElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLBRElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLBRElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLBRElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLBRElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLBRElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLBRElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLDListElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLDListElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLDListElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLDListElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLDListElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLDListElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLDListElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLDListElement_put_compact( x, p ) \
        (x)->lpVtbl->put_compact( x, p )
    #define IHTMLDListElement_get_compact( x, p ) \
        (x)->lpVtbl->get_compact( x, p )
    #define DispHTMLDListElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLDListElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLDListElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLDListElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLDListElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLDListElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLDListElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLHRElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLHRElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLHRElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLHRElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLHRElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLHRElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLHRElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLHRElement_put_align( x, p ) \
        (x)->lpVtbl->put_align( x, p )
    #define IHTMLHRElement_get_align( x, p ) \
        (x)->lpVtbl->get_align( x, p )
    #define IHTMLHRElement_put_color( x, p ) \
        (x)->lpVtbl->put_color( x, p )
    #define IHTMLHRElement_get_color( x, p ) \
        (x)->lpVtbl->get_color( x, p )
    #define IHTMLHRElement_put_noShade( x, p ) \
        (x)->lpVtbl->put_noShade( x, p )
    #define IHTMLHRElement_get_noShade( x, p ) \
        (x)->lpVtbl->get_noShade( x, p )
    #define IHTMLHRElement_put_width( x, p ) \
        (x)->lpVtbl->put_width( x, p )
    #define IHTMLHRElement_get_width( x, p ) \
        (x)->lpVtbl->get_width( x, p )
    #define IHTMLHRElement_put_size( x, p ) \
        (x)->lpVtbl->put_size( x, p )
    #define IHTMLHRElement_get_size( x, p ) \
        (x)->lpVtbl->get_size( x, p )
    #define DispHTMLHRElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLHRElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLHRElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLHRElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLHRElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLHRElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLHRElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLParaElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLParaElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLParaElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLParaElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLParaElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLParaElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLParaElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLParaElement_put_align( x, p ) \
        (x)->lpVtbl->put_align( x, p )
    #define IHTMLParaElement_get_align( x, p ) \
        (x)->lpVtbl->get_align( x, p )
    #define DispHTMLParaElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLParaElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLParaElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLParaElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLParaElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLParaElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLParaElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLElementCollection_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLElementCollection_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLElementCollection_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLElementCollection_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLElementCollection_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLElementCollection_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLElementCollection_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLElementCollection_toString( x, p ) \
        (x)->lpVtbl->toString( x, p )
    #define IHTMLElementCollection_put_length( x, p ) \
        (x)->lpVtbl->put_length( x, p )
    #define IHTMLElementCollection_get_length( x, p ) \
        (x)->lpVtbl->get_length( x, p )
    #define IHTMLElementCollection_get__newEnum( x, p ) \
        (x)->lpVtbl->get__newEnum( x, p )
    #define IHTMLElementCollection_item( x, p1, p2, p3 ) \
        (x)->lpVtbl->item( x, p1, p2, p3 )
    #define IHTMLElementCollection_tags( x, p1, p2 ) \
        (x)->lpVtbl->tags( x, p1, p2 )
    #define IHTMLElementCollection2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLElementCollection2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLElementCollection2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLElementCollection2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLElementCollection2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLElementCollection2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLElementCollection2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLElementCollection2_urns( x, p1, p2 ) \
        (x)->lpVtbl->urns( x, p1, p2 )
    #define IHTMLElementCollection3_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLElementCollection3_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLElementCollection3_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLElementCollection3_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLElementCollection3_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLElementCollection3_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLElementCollection3_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLElementCollection3_namedItem( x, p1, p2 ) \
        (x)->lpVtbl->namedItem( x, p1, p2 )
    #define IHTMLElementCollection4_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLElementCollection4_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLElementCollection4_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLElementCollection4_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLElementCollection4_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLElementCollection4_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLElementCollection4_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLElementCollection4_get_length( x, p ) \
        (x)->lpVtbl->get_length( x, p )
    #define IHTMLElementCollection4_item( x, p1, p2 ) \
        (x)->lpVtbl->item( x, p1, p2 )
    #define IHTMLElementCollection4_namedItem( x, p1, p2 ) \
        (x)->lpVtbl->namedItem( x, p1, p2 )
    #define DispHTMLElementCollection_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLElementCollection_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLElementCollection_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLElementCollection_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLElementCollection_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLElementCollection_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLElementCollection_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLHeaderElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLHeaderElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLHeaderElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLHeaderElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLHeaderElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLHeaderElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLHeaderElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLHeaderElement_put_align( x, p ) \
        (x)->lpVtbl->put_align( x, p )
    #define IHTMLHeaderElement_get_align( x, p ) \
        (x)->lpVtbl->get_align( x, p )
    #define DispHTMLHeaderElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLHeaderElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLHeaderElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLHeaderElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLHeaderElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLHeaderElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLHeaderElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define HTMLSelectElementEvents2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define HTMLSelectElementEvents2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define HTMLSelectElementEvents2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define HTMLSelectElementEvents2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define HTMLSelectElementEvents2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define HTMLSelectElementEvents2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define HTMLSelectElementEvents2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define HTMLSelectElementEvents_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define HTMLSelectElementEvents_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define HTMLSelectElementEvents_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define HTMLSelectElementEvents_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define HTMLSelectElementEvents_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define HTMLSelectElementEvents_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define HTMLSelectElementEvents_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLSelectElementEx_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLSelectElementEx_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLSelectElementEx_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLSelectElementEx_ShowDropdown( x, p ) \
        (x)->lpVtbl->ShowDropdown( x, p )
    #define IHTMLSelectElementEx_SetSelectExFlags( x, p ) \
        (x)->lpVtbl->SetSelectExFlags( x, p )
    #define IHTMLSelectElementEx_GetSelectExFlags( x, p ) \
        (x)->lpVtbl->GetSelectExFlags( x, p )
    #define IHTMLSelectElementEx_GetDropdownOpen( x, p ) \
        (x)->lpVtbl->GetDropdownOpen( x, p )
    #define IHTMLSelectElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLSelectElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLSelectElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLSelectElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLSelectElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLSelectElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLSelectElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLSelectElement_put_size( x, p ) \
        (x)->lpVtbl->put_size( x, p )
    #define IHTMLSelectElement_get_size( x, p ) \
        (x)->lpVtbl->get_size( x, p )
    #define IHTMLSelectElement_put_multiple( x, p ) \
        (x)->lpVtbl->put_multiple( x, p )
    #define IHTMLSelectElement_get_multiple( x, p ) \
        (x)->lpVtbl->get_multiple( x, p )
    #define IHTMLSelectElement_put_name( x, p ) \
        (x)->lpVtbl->put_name( x, p )
    #define IHTMLSelectElement_get_name( x, p ) \
        (x)->lpVtbl->get_name( x, p )
    #define IHTMLSelectElement_get_options( x, p ) \
        (x)->lpVtbl->get_options( x, p )
    #define IHTMLSelectElement_put_onchange( x, p ) \
        (x)->lpVtbl->put_onchange( x, p )
    #define IHTMLSelectElement_get_onchange( x, p ) \
        (x)->lpVtbl->get_onchange( x, p )
    #define IHTMLSelectElement_put_selectedIndex( x, p ) \
        (x)->lpVtbl->put_selectedIndex( x, p )
    #define IHTMLSelectElement_get_selectedIndex( x, p ) \
        (x)->lpVtbl->get_selectedIndex( x, p )
    #define IHTMLSelectElement_get_type( x, p ) \
        (x)->lpVtbl->get_type( x, p )
    #define IHTMLSelectElement_put_value( x, p ) \
        (x)->lpVtbl->put_value( x, p )
    #define IHTMLSelectElement_get_value( x, p ) \
        (x)->lpVtbl->get_value( x, p )
    #define IHTMLSelectElement_put_disabled( x, p ) \
        (x)->lpVtbl->put_disabled( x, p )
    #define IHTMLSelectElement_get_disabled( x, p ) \
        (x)->lpVtbl->get_disabled( x, p )
    #define IHTMLSelectElement_get_form( x, p ) \
        (x)->lpVtbl->get_form( x, p )
    #define IHTMLSelectElement_add( x, p1, p2 ) \
        (x)->lpVtbl->add( x, p1, p2 )
    #define IHTMLSelectElement_remove( x, p ) \
        (x)->lpVtbl->remove( x, p )
    #define IHTMLSelectElement_put_length( x, p ) \
        (x)->lpVtbl->put_length( x, p )
    #define IHTMLSelectElement_get_length( x, p ) \
        (x)->lpVtbl->get_length( x, p )
    #define IHTMLSelectElement_get__newEnum( x, p ) \
        (x)->lpVtbl->get__newEnum( x, p )
    #define IHTMLSelectElement_item( x, p1, p2, p3 ) \
        (x)->lpVtbl->item( x, p1, p2, p3 )
    #define IHTMLSelectElement_tags( x, p1, p2 ) \
        (x)->lpVtbl->tags( x, p1, p2 )
    #define IHTMLSelectElement2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLSelectElement2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLSelectElement2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLSelectElement2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLSelectElement2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLSelectElement2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLSelectElement2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLSelectElement2_urns( x, p1, p2 ) \
        (x)->lpVtbl->urns( x, p1, p2 )
    #define IHTMLSelectElement4_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLSelectElement4_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLSelectElement4_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLSelectElement4_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLSelectElement4_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLSelectElement4_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLSelectElement4_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLSelectElement4_namedItem( x, p1, p2 ) \
        (x)->lpVtbl->namedItem( x, p1, p2 )
    #define IHTMLSelectElement5_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLSelectElement5_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLSelectElement5_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLSelectElement5_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLSelectElement5_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLSelectElement5_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLSelectElement5_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLSelectElement5_add( x, p1, p2 ) \
        (x)->lpVtbl->add( x, p1, p2 )
    #define DispHTMLSelectElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLSelectElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLSelectElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLSelectElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLSelectElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLSelectElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLSelectElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define DispHTMLWndSelectElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLWndSelectElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLWndSelectElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLWndSelectElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLWndSelectElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLWndSelectElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLWndSelectElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLSelectionObject_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLSelectionObject_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLSelectionObject_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLSelectionObject_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLSelectionObject_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLSelectionObject_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLSelectionObject_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLSelectionObject_createRange( x, p ) \
        (x)->lpVtbl->createRange( x, p )
    #define IHTMLSelectionObject_empty( x ) \
        (x)->lpVtbl->empty( x )
    #define IHTMLSelectionObject_clear( x ) \
        (x)->lpVtbl->clear( x )
    #define IHTMLSelectionObject_get_type( x, p ) \
        (x)->lpVtbl->get_type( x, p )
    #define IHTMLSelectionObject2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLSelectionObject2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLSelectionObject2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLSelectionObject2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLSelectionObject2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLSelectionObject2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLSelectionObject2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLSelectionObject2_createRangeCollection( x, p ) \
        (x)->lpVtbl->createRangeCollection( x, p )
    #define IHTMLSelectionObject2_get_typeDetail( x, p ) \
        (x)->lpVtbl->get_typeDetail( x, p )
    #define IHTMLOptionElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLOptionElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLOptionElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLOptionElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLOptionElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLOptionElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLOptionElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLOptionElement_put_selected( x, p ) \
        (x)->lpVtbl->put_selected( x, p )
    #define IHTMLOptionElement_get_selected( x, p ) \
        (x)->lpVtbl->get_selected( x, p )
    #define IHTMLOptionElement_put_value( x, p ) \
        (x)->lpVtbl->put_value( x, p )
    #define IHTMLOptionElement_get_value( x, p ) \
        (x)->lpVtbl->get_value( x, p )
    #define IHTMLOptionElement_put_defaultSelected( x, p ) \
        (x)->lpVtbl->put_defaultSelected( x, p )
    #define IHTMLOptionElement_get_defaultSelected( x, p ) \
        (x)->lpVtbl->get_defaultSelected( x, p )
    #define IHTMLOptionElement_put_index( x, p ) \
        (x)->lpVtbl->put_index( x, p )
    #define IHTMLOptionElement_get_index( x, p ) \
        (x)->lpVtbl->get_index( x, p )
    #define IHTMLOptionElement_put_text( x, p ) \
        (x)->lpVtbl->put_text( x, p )
    #define IHTMLOptionElement_get_text( x, p ) \
        (x)->lpVtbl->get_text( x, p )
    #define IHTMLOptionElement_get_form( x, p ) \
        (x)->lpVtbl->get_form( x, p )
    #define IHTMLOptionElement3_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLOptionElement3_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLOptionElement3_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLOptionElement3_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLOptionElement3_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLOptionElement3_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLOptionElement3_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLOptionElement3_put_label( x, p ) \
        (x)->lpVtbl->put_label( x, p )
    #define IHTMLOptionElement3_get_label( x, p ) \
        (x)->lpVtbl->get_label( x, p )
    #define IHTMLOptionElementFactory_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLOptionElementFactory_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLOptionElementFactory_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLOptionElementFactory_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLOptionElementFactory_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLOptionElementFactory_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLOptionElementFactory_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLOptionElementFactory_create( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->create( x, p1, p2, p3, p4, p5 )
    #define DispHTMLOptionElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLOptionElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLOptionElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLOptionElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLOptionElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLOptionElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLOptionElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define DispHTMLWndOptionElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLWndOptionElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLWndOptionElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLWndOptionElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLWndOptionElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLWndOptionElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLWndOptionElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define HTMLButtonElementEvents2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define HTMLButtonElementEvents2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define HTMLButtonElementEvents2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define HTMLButtonElementEvents2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define HTMLButtonElementEvents2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define HTMLButtonElementEvents2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define HTMLButtonElementEvents2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define HTMLButtonElementEvents_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define HTMLButtonElementEvents_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define HTMLButtonElementEvents_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define HTMLButtonElementEvents_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define HTMLButtonElementEvents_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define HTMLButtonElementEvents_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define HTMLButtonElementEvents_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define HTMLInputTextElementEvents2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define HTMLInputTextElementEvents2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define HTMLInputTextElementEvents2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define HTMLInputTextElementEvents2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define HTMLInputTextElementEvents2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define HTMLInputTextElementEvents2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define HTMLInputTextElementEvents2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define HTMLOptionButtonElementEvents2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define HTMLOptionButtonElementEvents2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define HTMLOptionButtonElementEvents2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define HTMLOptionButtonElementEvents2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define HTMLOptionButtonElementEvents2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define HTMLOptionButtonElementEvents2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define HTMLOptionButtonElementEvents2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define HTMLInputFileElementEvents2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define HTMLInputFileElementEvents2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define HTMLInputFileElementEvents2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define HTMLInputFileElementEvents2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define HTMLInputFileElementEvents2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define HTMLInputFileElementEvents2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define HTMLInputFileElementEvents2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define HTMLInputImageEvents2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define HTMLInputImageEvents2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define HTMLInputImageEvents2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define HTMLInputImageEvents2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define HTMLInputImageEvents2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define HTMLInputImageEvents2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define HTMLInputImageEvents2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define HTMLInputTextElementEvents_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define HTMLInputTextElementEvents_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define HTMLInputTextElementEvents_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define HTMLInputTextElementEvents_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define HTMLInputTextElementEvents_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define HTMLInputTextElementEvents_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define HTMLInputTextElementEvents_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define HTMLOptionButtonElementEvents_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define HTMLOptionButtonElementEvents_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define HTMLOptionButtonElementEvents_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define HTMLOptionButtonElementEvents_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define HTMLOptionButtonElementEvents_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define HTMLOptionButtonElementEvents_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define HTMLOptionButtonElementEvents_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define HTMLInputFileElementEvents_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define HTMLInputFileElementEvents_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define HTMLInputFileElementEvents_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define HTMLInputFileElementEvents_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define HTMLInputFileElementEvents_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define HTMLInputFileElementEvents_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define HTMLInputFileElementEvents_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define HTMLInputImageEvents_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define HTMLInputImageEvents_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define HTMLInputImageEvents_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define HTMLInputImageEvents_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define HTMLInputImageEvents_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define HTMLInputImageEvents_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define HTMLInputImageEvents_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLInputElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLInputElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLInputElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLInputElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLInputElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLInputElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLInputElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLInputElement_put_type( x, p ) \
        (x)->lpVtbl->put_type( x, p )
    #define IHTMLInputElement_get_type( x, p ) \
        (x)->lpVtbl->get_type( x, p )
    #define IHTMLInputElement_put_value( x, p ) \
        (x)->lpVtbl->put_value( x, p )
    #define IHTMLInputElement_get_value( x, p ) \
        (x)->lpVtbl->get_value( x, p )
    #define IHTMLInputElement_put_name( x, p ) \
        (x)->lpVtbl->put_name( x, p )
    #define IHTMLInputElement_get_name( x, p ) \
        (x)->lpVtbl->get_name( x, p )
    #define IHTMLInputElement_put_status( x, p ) \
        (x)->lpVtbl->put_status( x, p )
    #define IHTMLInputElement_get_status( x, p ) \
        (x)->lpVtbl->get_status( x, p )
    #define IHTMLInputElement_put_disabled( x, p ) \
        (x)->lpVtbl->put_disabled( x, p )
    #define IHTMLInputElement_get_disabled( x, p ) \
        (x)->lpVtbl->get_disabled( x, p )
    #define IHTMLInputElement_get_form( x, p ) \
        (x)->lpVtbl->get_form( x, p )
    #define IHTMLInputElement_put_size( x, p ) \
        (x)->lpVtbl->put_size( x, p )
    #define IHTMLInputElement_get_size( x, p ) \
        (x)->lpVtbl->get_size( x, p )
    #define IHTMLInputElement_put_maxLength( x, p ) \
        (x)->lpVtbl->put_maxLength( x, p )
    #define IHTMLInputElement_get_maxLength( x, p ) \
        (x)->lpVtbl->get_maxLength( x, p )
    #define IHTMLInputElement_put_onchange( x, p ) \
        (x)->lpVtbl->put_onchange( x, p )
    #define IHTMLInputElement_get_onchange( x, p ) \
        (x)->lpVtbl->get_onchange( x, p )
    #define IHTMLInputElement_put_onselect( x, p ) \
        (x)->lpVtbl->put_onselect( x, p )
    #define IHTMLInputElement_get_onselect( x, p ) \
        (x)->lpVtbl->get_onselect( x, p )
    #define IHTMLInputElement_put_defaultValue( x, p ) \
        (x)->lpVtbl->put_defaultValue( x, p )
    #define IHTMLInputElement_get_defaultValue( x, p ) \
        (x)->lpVtbl->get_defaultValue( x, p )
    #define IHTMLInputElement_put_readOnly( x, p ) \
        (x)->lpVtbl->put_readOnly( x, p )
    #define IHTMLInputElement_get_readOnly( x, p ) \
        (x)->lpVtbl->get_readOnly( x, p )
    #define IHTMLInputElement_createTextRange( x, p ) \
        (x)->lpVtbl->createTextRange( x, p )
    #define IHTMLInputElement_put_indeterminate( x, p ) \
        (x)->lpVtbl->put_indeterminate( x, p )
    #define IHTMLInputElement_get_indeterminate( x, p ) \
        (x)->lpVtbl->get_indeterminate( x, p )
    #define IHTMLInputElement_put_defaultChecked( x, p ) \
        (x)->lpVtbl->put_defaultChecked( x, p )
    #define IHTMLInputElement_get_defaultChecked( x, p ) \
        (x)->lpVtbl->get_defaultChecked( x, p )
    #define IHTMLInputElement_put_checked( x, p ) \
        (x)->lpVtbl->put_checked( x, p )
    #define IHTMLInputElement_get_checked( x, p ) \
        (x)->lpVtbl->get_checked( x, p )
    #define IHTMLInputElement_put_border( x, p ) \
        (x)->lpVtbl->put_border( x, p )
    #define IHTMLInputElement_get_border( x, p ) \
        (x)->lpVtbl->get_border( x, p )
    #define IHTMLInputElement_put_vspace( x, p ) \
        (x)->lpVtbl->put_vspace( x, p )
    #define IHTMLInputElement_get_vspace( x, p ) \
        (x)->lpVtbl->get_vspace( x, p )
    #define IHTMLInputElement_put_hspace( x, p ) \
        (x)->lpVtbl->put_hspace( x, p )
    #define IHTMLInputElement_get_hspace( x, p ) \
        (x)->lpVtbl->get_hspace( x, p )
    #define IHTMLInputElement_put_alt( x, p ) \
        (x)->lpVtbl->put_alt( x, p )
    #define IHTMLInputElement_get_alt( x, p ) \
        (x)->lpVtbl->get_alt( x, p )
    #define IHTMLInputElement_put_src( x, p ) \
        (x)->lpVtbl->put_src( x, p )
    #define IHTMLInputElement_get_src( x, p ) \
        (x)->lpVtbl->get_src( x, p )
    #define IHTMLInputElement_put_lowsrc( x, p ) \
        (x)->lpVtbl->put_lowsrc( x, p )
    #define IHTMLInputElement_get_lowsrc( x, p ) \
        (x)->lpVtbl->get_lowsrc( x, p )
    #define IHTMLInputElement_put_vrml( x, p ) \
        (x)->lpVtbl->put_vrml( x, p )
    #define IHTMLInputElement_get_vrml( x, p ) \
        (x)->lpVtbl->get_vrml( x, p )
    #define IHTMLInputElement_put_dynsrc( x, p ) \
        (x)->lpVtbl->put_dynsrc( x, p )
    #define IHTMLInputElement_get_dynsrc( x, p ) \
        (x)->lpVtbl->get_dynsrc( x, p )
    #define IHTMLInputElement_get_readyState( x, p ) \
        (x)->lpVtbl->get_readyState( x, p )
    #define IHTMLInputElement_get_complete( x, p ) \
        (x)->lpVtbl->get_complete( x, p )
    #define IHTMLInputElement_put_loop( x, p ) \
        (x)->lpVtbl->put_loop( x, p )
    #define IHTMLInputElement_get_loop( x, p ) \
        (x)->lpVtbl->get_loop( x, p )
    #define IHTMLInputElement_put_align( x, p ) \
        (x)->lpVtbl->put_align( x, p )
    #define IHTMLInputElement_get_align( x, p ) \
        (x)->lpVtbl->get_align( x, p )
    #define IHTMLInputElement_put_onload( x, p ) \
        (x)->lpVtbl->put_onload( x, p )
    #define IHTMLInputElement_get_onload( x, p ) \
        (x)->lpVtbl->get_onload( x, p )
    #define IHTMLInputElement_put_onerror( x, p ) \
        (x)->lpVtbl->put_onerror( x, p )
    #define IHTMLInputElement_get_onerror( x, p ) \
        (x)->lpVtbl->get_onerror( x, p )
    #define IHTMLInputElement_put_onabort( x, p ) \
        (x)->lpVtbl->put_onabort( x, p )
    #define IHTMLInputElement_get_onabort( x, p ) \
        (x)->lpVtbl->get_onabort( x, p )
    #define IHTMLInputElement_put_width( x, p ) \
        (x)->lpVtbl->put_width( x, p )
    #define IHTMLInputElement_get_width( x, p ) \
        (x)->lpVtbl->get_width( x, p )
    #define IHTMLInputElement_put_height( x, p ) \
        (x)->lpVtbl->put_height( x, p )
    #define IHTMLInputElement_get_height( x, p ) \
        (x)->lpVtbl->get_height( x, p )
    #define IHTMLInputElement_put_start( x, p ) \
        (x)->lpVtbl->put_start( x, p )
    #define IHTMLInputElement_get_start( x, p ) \
        (x)->lpVtbl->get_start( x, p )
    #define IHTMLInputElement2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLInputElement2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLInputElement2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLInputElement2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLInputElement2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLInputElement2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLInputElement2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLInputElement2_put_accept( x, p ) \
        (x)->lpVtbl->put_accept( x, p )
    #define IHTMLInputElement2_get_accept( x, p ) \
        (x)->lpVtbl->get_accept( x, p )
    #define IHTMLInputElement2_put_useMap( x, p ) \
        (x)->lpVtbl->put_useMap( x, p )
    #define IHTMLInputElement2_get_useMap( x, p ) \
        (x)->lpVtbl->get_useMap( x, p )
    #define IHTMLInputElement3_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLInputElement3_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLInputElement3_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLInputElement3_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLInputElement3_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLInputElement3_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLInputElement3_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLInputElement3_put_src( x, p ) \
        (x)->lpVtbl->put_src( x, p )
    #define IHTMLInputElement3_get_src( x, p ) \
        (x)->lpVtbl->get_src( x, p )
    #define IHTMLInputElement3_put_lowsrc( x, p ) \
        (x)->lpVtbl->put_lowsrc( x, p )
    #define IHTMLInputElement3_get_lowsrc( x, p ) \
        (x)->lpVtbl->get_lowsrc( x, p )
    #define IHTMLInputElement3_put_vrml( x, p ) \
        (x)->lpVtbl->put_vrml( x, p )
    #define IHTMLInputElement3_get_vrml( x, p ) \
        (x)->lpVtbl->get_vrml( x, p )
    #define IHTMLInputElement3_put_dynsrc( x, p ) \
        (x)->lpVtbl->put_dynsrc( x, p )
    #define IHTMLInputElement3_get_dynsrc( x, p ) \
        (x)->lpVtbl->get_dynsrc( x, p )
    #define IHTMLInputButtonElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLInputButtonElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLInputButtonElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLInputButtonElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLInputButtonElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLInputButtonElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLInputButtonElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLInputButtonElement_get_type( x, p ) \
        (x)->lpVtbl->get_type( x, p )
    #define IHTMLInputButtonElement_put_value( x, p ) \
        (x)->lpVtbl->put_value( x, p )
    #define IHTMLInputButtonElement_get_value( x, p ) \
        (x)->lpVtbl->get_value( x, p )
    #define IHTMLInputButtonElement_put_name( x, p ) \
        (x)->lpVtbl->put_name( x, p )
    #define IHTMLInputButtonElement_get_name( x, p ) \
        (x)->lpVtbl->get_name( x, p )
    #define IHTMLInputButtonElement_put_status( x, p ) \
        (x)->lpVtbl->put_status( x, p )
    #define IHTMLInputButtonElement_get_status( x, p ) \
        (x)->lpVtbl->get_status( x, p )
    #define IHTMLInputButtonElement_put_disabled( x, p ) \
        (x)->lpVtbl->put_disabled( x, p )
    #define IHTMLInputButtonElement_get_disabled( x, p ) \
        (x)->lpVtbl->get_disabled( x, p )
    #define IHTMLInputButtonElement_get_form( x, p ) \
        (x)->lpVtbl->get_form( x, p )
    #define IHTMLInputButtonElement_createTextRange( x, p ) \
        (x)->lpVtbl->createTextRange( x, p )
    #define IHTMLInputHiddenElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLInputHiddenElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLInputHiddenElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLInputHiddenElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLInputHiddenElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLInputHiddenElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLInputHiddenElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLInputHiddenElement_get_type( x, p ) \
        (x)->lpVtbl->get_type( x, p )
    #define IHTMLInputHiddenElement_put_value( x, p ) \
        (x)->lpVtbl->put_value( x, p )
    #define IHTMLInputHiddenElement_get_value( x, p ) \
        (x)->lpVtbl->get_value( x, p )
    #define IHTMLInputHiddenElement_put_name( x, p ) \
        (x)->lpVtbl->put_name( x, p )
    #define IHTMLInputHiddenElement_get_name( x, p ) \
        (x)->lpVtbl->get_name( x, p )
    #define IHTMLInputHiddenElement_put_status( x, p ) \
        (x)->lpVtbl->put_status( x, p )
    #define IHTMLInputHiddenElement_get_status( x, p ) \
        (x)->lpVtbl->get_status( x, p )
    #define IHTMLInputHiddenElement_put_disabled( x, p ) \
        (x)->lpVtbl->put_disabled( x, p )
    #define IHTMLInputHiddenElement_get_disabled( x, p ) \
        (x)->lpVtbl->get_disabled( x, p )
    #define IHTMLInputHiddenElement_get_form( x, p ) \
        (x)->lpVtbl->get_form( x, p )
    #define IHTMLInputHiddenElement_createTextRange( x, p ) \
        (x)->lpVtbl->createTextRange( x, p )
    #define IHTMLInputTextElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLInputTextElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLInputTextElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLInputTextElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLInputTextElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLInputTextElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLInputTextElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLInputTextElement_get_type( x, p ) \
        (x)->lpVtbl->get_type( x, p )
    #define IHTMLInputTextElement_put_value( x, p ) \
        (x)->lpVtbl->put_value( x, p )
    #define IHTMLInputTextElement_get_value( x, p ) \
        (x)->lpVtbl->get_value( x, p )
    #define IHTMLInputTextElement_put_name( x, p ) \
        (x)->lpVtbl->put_name( x, p )
    #define IHTMLInputTextElement_get_name( x, p ) \
        (x)->lpVtbl->get_name( x, p )
    #define IHTMLInputTextElement_put_status( x, p ) \
        (x)->lpVtbl->put_status( x, p )
    #define IHTMLInputTextElement_get_status( x, p ) \
        (x)->lpVtbl->get_status( x, p )
    #define IHTMLInputTextElement_put_disabled( x, p ) \
        (x)->lpVtbl->put_disabled( x, p )
    #define IHTMLInputTextElement_get_disabled( x, p ) \
        (x)->lpVtbl->get_disabled( x, p )
    #define IHTMLInputTextElement_get_form( x, p ) \
        (x)->lpVtbl->get_form( x, p )
    #define IHTMLInputTextElement_put_defaultValue( x, p ) \
        (x)->lpVtbl->put_defaultValue( x, p )
    #define IHTMLInputTextElement_get_defaultValue( x, p ) \
        (x)->lpVtbl->get_defaultValue( x, p )
    #define IHTMLInputTextElement_put_size( x, p ) \
        (x)->lpVtbl->put_size( x, p )
    #define IHTMLInputTextElement_get_size( x, p ) \
        (x)->lpVtbl->get_size( x, p )
    #define IHTMLInputTextElement_put_maxLength( x, p ) \
        (x)->lpVtbl->put_maxLength( x, p )
    #define IHTMLInputTextElement_get_maxLength( x, p ) \
        (x)->lpVtbl->get_maxLength( x, p )
    #define IHTMLInputTextElement_put_onchange( x, p ) \
        (x)->lpVtbl->put_onchange( x, p )
    #define IHTMLInputTextElement_get_onchange( x, p ) \
        (x)->lpVtbl->get_onchange( x, p )
    #define IHTMLInputTextElement_put_onselect( x, p ) \
        (x)->lpVtbl->put_onselect( x, p )
    #define IHTMLInputTextElement_get_onselect( x, p ) \
        (x)->lpVtbl->get_onselect( x, p )
    #define IHTMLInputTextElement_put_readOnly( x, p ) \
        (x)->lpVtbl->put_readOnly( x, p )
    #define IHTMLInputTextElement_get_readOnly( x, p ) \
        (x)->lpVtbl->get_readOnly( x, p )
    #define IHTMLInputFileElement_createTextRange( x, p ) \
        (x)->lpVtbl->createTextRange( x, p )
    #define IHTMLInputFileElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLInputFileElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLInputFileElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLInputFileElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLInputFileElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLInputFileElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLInputFileElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLInputFileElement_get_type( x, p ) \
        (x)->lpVtbl->get_type( x, p )
    #define IHTMLInputFileElement_put_name( x, p ) \
        (x)->lpVtbl->put_name( x, p )
    #define IHTMLInputFileElement_get_name( x, p ) \
        (x)->lpVtbl->get_name( x, p )
    #define IHTMLInputFileElement_put_status( x, p ) \
        (x)->lpVtbl->put_status( x, p )
    #define IHTMLInputFileElement_get_status( x, p ) \
        (x)->lpVtbl->get_status( x, p )
    #define IHTMLInputFileElement_put_disabled( x, p ) \
        (x)->lpVtbl->put_disabled( x, p )
    #define IHTMLInputFileElement_get_disabled( x, p ) \
        (x)->lpVtbl->get_disabled( x, p )
    #define IHTMLInputFileElement_get_form( x, p ) \
        (x)->lpVtbl->get_form( x, p )
    #define IHTMLInputFileElement_put_size( x, p ) \
        (x)->lpVtbl->put_size( x, p )
    #define IHTMLInputFileElement_get_size( x, p ) \
        (x)->lpVtbl->get_size( x, p )
    #define IHTMLInputFileElement_put_maxLength( x, p ) \
        (x)->lpVtbl->put_maxLength( x, p )
    #define IHTMLInputFileElement_get_maxLength( x, p ) \
        (x)->lpVtbl->get_maxLength( x, p )
    #define IHTMLInputFileElement_put_onchange( x, p ) \
        (x)->lpVtbl->put_onchange( x, p )
    #define IHTMLInputFileElement_get_onchange( x, p ) \
        (x)->lpVtbl->get_onchange( x, p )
    #define IHTMLInputFileElement_put_onselect( x, p ) \
        (x)->lpVtbl->put_onselect( x, p )
    #define IHTMLInputFileElement_get_onselect( x, p ) \
        (x)->lpVtbl->get_onselect( x, p )
    #define IHTMLInputFileElement_put_value( x, p ) \
        (x)->lpVtbl->put_value( x, p )
    #define IHTMLInputFileElement_get_value( x, p ) \
        (x)->lpVtbl->get_value( x, p )
    #define IHTMLOptionButtonElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLOptionButtonElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLOptionButtonElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLOptionButtonElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLOptionButtonElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLOptionButtonElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLOptionButtonElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLOptionButtonElement_put_value( x, p ) \
        (x)->lpVtbl->put_value( x, p )
    #define IHTMLOptionButtonElement_get_value( x, p ) \
        (x)->lpVtbl->get_value( x, p )
    #define IHTMLOptionButtonElement_get_type( x, p ) \
        (x)->lpVtbl->get_type( x, p )
    #define IHTMLOptionButtonElement_put_name( x, p ) \
        (x)->lpVtbl->put_name( x, p )
    #define IHTMLOptionButtonElement_get_name( x, p ) \
        (x)->lpVtbl->get_name( x, p )
    #define IHTMLOptionButtonElement_put_checked( x, p ) \
        (x)->lpVtbl->put_checked( x, p )
    #define IHTMLOptionButtonElement_get_checked( x, p ) \
        (x)->lpVtbl->get_checked( x, p )
    #define IHTMLOptionButtonElement_put_defaultChecked( x, p ) \
        (x)->lpVtbl->put_defaultChecked( x, p )
    #define IHTMLOptionButtonElement_get_defaultChecked( x, p ) \
        (x)->lpVtbl->get_defaultChecked( x, p )
    #define IHTMLOptionButtonElement_put_onchange( x, p ) \
        (x)->lpVtbl->put_onchange( x, p )
    #define IHTMLOptionButtonElement_get_onchange( x, p ) \
        (x)->lpVtbl->get_onchange( x, p )
    #define IHTMLOptionButtonElement_put_disabled( x, p ) \
        (x)->lpVtbl->put_disabled( x, p )
    #define IHTMLOptionButtonElement_get_disabled( x, p ) \
        (x)->lpVtbl->get_disabled( x, p )
    #define IHTMLOptionButtonElement_put_status( x, p ) \
        (x)->lpVtbl->put_status( x, p )
    #define IHTMLOptionButtonElement_get_status( x, p ) \
        (x)->lpVtbl->get_status( x, p )
    #define IHTMLOptionButtonElement_put_indeterminate( x, p ) \
        (x)->lpVtbl->put_indeterminate( x, p )
    #define IHTMLOptionButtonElement_get_indeterminate( x, p ) \
        (x)->lpVtbl->get_indeterminate( x, p )
    #define IHTMLOptionButtonElement_get_form( x, p ) \
        (x)->lpVtbl->get_form( x, p )
    #define IHTMLInputImage_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLInputImage_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLInputImage_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLInputImage_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLInputImage_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLInputImage_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLInputImage_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLInputImage_get_type( x, p ) \
        (x)->lpVtbl->get_type( x, p )
    #define IHTMLInputImage_put_disabled( x, p ) \
        (x)->lpVtbl->put_disabled( x, p )
    #define IHTMLInputImage_get_disabled( x, p ) \
        (x)->lpVtbl->get_disabled( x, p )
    #define IHTMLInputImage_put_border( x, p ) \
        (x)->lpVtbl->put_border( x, p )
    #define IHTMLInputImage_get_border( x, p ) \
        (x)->lpVtbl->get_border( x, p )
    #define IHTMLInputImage_put_vspace( x, p ) \
        (x)->lpVtbl->put_vspace( x, p )
    #define IHTMLInputImage_get_vspace( x, p ) \
        (x)->lpVtbl->get_vspace( x, p )
    #define IHTMLInputImage_put_hspace( x, p ) \
        (x)->lpVtbl->put_hspace( x, p )
    #define IHTMLInputImage_get_hspace( x, p ) \
        (x)->lpVtbl->get_hspace( x, p )
    #define IHTMLInputImage_put_alt( x, p ) \
        (x)->lpVtbl->put_alt( x, p )
    #define IHTMLInputImage_get_alt( x, p ) \
        (x)->lpVtbl->get_alt( x, p )
    #define IHTMLInputImage_put_src( x, p ) \
        (x)->lpVtbl->put_src( x, p )
    #define IHTMLInputImage_get_src( x, p ) \
        (x)->lpVtbl->get_src( x, p )
    #define IHTMLInputImage_put_lowsrc( x, p ) \
        (x)->lpVtbl->put_lowsrc( x, p )
    #define IHTMLInputImage_get_lowsrc( x, p ) \
        (x)->lpVtbl->get_lowsrc( x, p )
    #define IHTMLInputImage_put_vrml( x, p ) \
        (x)->lpVtbl->put_vrml( x, p )
    #define IHTMLInputImage_get_vrml( x, p ) \
        (x)->lpVtbl->get_vrml( x, p )
    #define IHTMLInputImage_put_dynsrc( x, p ) \
        (x)->lpVtbl->put_dynsrc( x, p )
    #define IHTMLInputImage_get_dynsrc( x, p ) \
        (x)->lpVtbl->get_dynsrc( x, p )
    #define IHTMLInputImage_get_readyState( x, p ) \
        (x)->lpVtbl->get_readyState( x, p )
    #define IHTMLInputImage_get_complete( x, p ) \
        (x)->lpVtbl->get_complete( x, p )
    #define IHTMLInputImage_put_loop( x, p ) \
        (x)->lpVtbl->put_loop( x, p )
    #define IHTMLInputImage_get_loop( x, p ) \
        (x)->lpVtbl->get_loop( x, p )
    #define IHTMLInputImage_put_align( x, p ) \
        (x)->lpVtbl->put_align( x, p )
    #define IHTMLInputImage_get_align( x, p ) \
        (x)->lpVtbl->get_align( x, p )
    #define IHTMLInputImage_put_onload( x, p ) \
        (x)->lpVtbl->put_onload( x, p )
    #define IHTMLInputImage_get_onload( x, p ) \
        (x)->lpVtbl->get_onload( x, p )
    #define IHTMLInputImage_put_onerror( x, p ) \
        (x)->lpVtbl->put_onerror( x, p )
    #define IHTMLInputImage_get_onerror( x, p ) \
        (x)->lpVtbl->get_onerror( x, p )
    #define IHTMLInputImage_put_onabort( x, p ) \
        (x)->lpVtbl->put_onabort( x, p )
    #define IHTMLInputImage_get_onabort( x, p ) \
        (x)->lpVtbl->get_onabort( x, p )
    #define IHTMLInputImage_put_name( x, p ) \
        (x)->lpVtbl->put_name( x, p )
    #define IHTMLInputImage_get_name( x, p ) \
        (x)->lpVtbl->get_name( x, p )
    #define IHTMLInputImage_put_width( x, p ) \
        (x)->lpVtbl->put_width( x, p )
    #define IHTMLInputImage_get_width( x, p ) \
        (x)->lpVtbl->get_width( x, p )
    #define IHTMLInputImage_put_height( x, p ) \
        (x)->lpVtbl->put_height( x, p )
    #define IHTMLInputImage_get_height( x, p ) \
        (x)->lpVtbl->get_height( x, p )
    #define IHTMLInputImage_put_start( x, p ) \
        (x)->lpVtbl->put_start( x, p )
    #define IHTMLInputImage_get_start( x, p ) \
        (x)->lpVtbl->get_start( x, p )
    #define DispHTMLInputElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLInputElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLInputElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLInputElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLInputElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLInputElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLInputElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLTextAreaElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLTextAreaElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLTextAreaElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLTextAreaElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLTextAreaElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLTextAreaElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLTextAreaElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLTextAreaElement_get_type( x, p ) \
        (x)->lpVtbl->get_type( x, p )
    #define IHTMLTextAreaElement_put_value( x, p ) \
        (x)->lpVtbl->put_value( x, p )
    #define IHTMLTextAreaElement_get_value( x, p ) \
        (x)->lpVtbl->get_value( x, p )
    #define IHTMLTextAreaElement_put_name( x, p ) \
        (x)->lpVtbl->put_name( x, p )
    #define IHTMLTextAreaElement_get_name( x, p ) \
        (x)->lpVtbl->get_name( x, p )
    #define IHTMLTextAreaElement_put_status( x, p ) \
        (x)->lpVtbl->put_status( x, p )
    #define IHTMLTextAreaElement_get_status( x, p ) \
        (x)->lpVtbl->get_status( x, p )
    #define IHTMLTextAreaElement_put_disabled( x, p ) \
        (x)->lpVtbl->put_disabled( x, p )
    #define IHTMLTextAreaElement_get_disabled( x, p ) \
        (x)->lpVtbl->get_disabled( x, p )
    #define IHTMLTextAreaElement_get_form( x, p ) \
        (x)->lpVtbl->get_form( x, p )
    #define IHTMLTextAreaElement_put_defaultValue( x, p ) \
        (x)->lpVtbl->put_defaultValue( x, p )
    #define IHTMLTextAreaElement_get_defaultValue( x, p ) \
        (x)->lpVtbl->get_defaultValue( x, p )
    #define IHTMLTextAreaElement_select( x ) \
        (x)->lpVtbl->select( x )
    #define IHTMLTextAreaElement_put_onchange( x, p ) \
        (x)->lpVtbl->put_onchange( x, p )
    #define IHTMLTextAreaElement_get_onchange( x, p ) \
        (x)->lpVtbl->get_onchange( x, p )
    #define IHTMLTextAreaElement_put_onselect( x, p ) \
        (x)->lpVtbl->put_onselect( x, p )
    #define IHTMLTextAreaElement_get_onselect( x, p ) \
        (x)->lpVtbl->get_onselect( x, p )
    #define IHTMLTextAreaElement_put_readOnly( x, p ) \
        (x)->lpVtbl->put_readOnly( x, p )
    #define IHTMLTextAreaElement_get_readOnly( x, p ) \
        (x)->lpVtbl->get_readOnly( x, p )
    #define IHTMLTextAreaElement_put_rows( x, p ) \
        (x)->lpVtbl->put_rows( x, p )
    #define IHTMLTextAreaElement_get_rows( x, p ) \
        (x)->lpVtbl->get_rows( x, p )
    #define IHTMLTextAreaElement_put_cols( x, p ) \
        (x)->lpVtbl->put_cols( x, p )
    #define IHTMLTextAreaElement_get_cols( x, p ) \
        (x)->lpVtbl->get_cols( x, p )
    #define IHTMLTextAreaElement_put_wrap( x, p ) \
        (x)->lpVtbl->put_wrap( x, p )
    #define IHTMLTextAreaElement_get_wrap( x, p ) \
        (x)->lpVtbl->get_wrap( x, p )
    #define IHTMLTextAreaElement_createTextRange( x, p ) \
        (x)->lpVtbl->createTextRange( x, p )
    #define DispHTMLTextAreaElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLTextAreaElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLTextAreaElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLTextAreaElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLTextAreaElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLTextAreaElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLTextAreaElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define DispHTMLRichtextElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLRichtextElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLRichtextElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLRichtextElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLRichtextElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLRichtextElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLRichtextElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLButtonElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLButtonElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLButtonElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLButtonElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLButtonElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLButtonElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLButtonElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLButtonElement_get_type( x, p ) \
        (x)->lpVtbl->get_type( x, p )
    #define IHTMLButtonElement_put_value( x, p ) \
        (x)->lpVtbl->put_value( x, p )
    #define IHTMLButtonElement_get_value( x, p ) \
        (x)->lpVtbl->get_value( x, p )
    #define IHTMLButtonElement_put_name( x, p ) \
        (x)->lpVtbl->put_name( x, p )
    #define IHTMLButtonElement_get_name( x, p ) \
        (x)->lpVtbl->get_name( x, p )
    #define IHTMLButtonElement_put_status( x, p ) \
        (x)->lpVtbl->put_status( x, p )
    #define IHTMLButtonElement_get_status( x, p ) \
        (x)->lpVtbl->get_status( x, p )
    #define IHTMLButtonElement_put_disabled( x, p ) \
        (x)->lpVtbl->put_disabled( x, p )
    #define IHTMLButtonElement_get_disabled( x, p ) \
        (x)->lpVtbl->get_disabled( x, p )
    #define IHTMLButtonElement_get_form( x, p ) \
        (x)->lpVtbl->get_form( x, p )
    #define IHTMLButtonElement_createTextRange( x, p ) \
        (x)->lpVtbl->createTextRange( x, p )
    #define DispHTMLButtonElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLButtonElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLButtonElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLButtonElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLButtonElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLButtonElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLButtonElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define HTMLMarqueeElementEvents2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define HTMLMarqueeElementEvents2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define HTMLMarqueeElementEvents2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define HTMLMarqueeElementEvents2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define HTMLMarqueeElementEvents2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define HTMLMarqueeElementEvents2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define HTMLMarqueeElementEvents2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define HTMLMarqueeElementEvents_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define HTMLMarqueeElementEvents_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define HTMLMarqueeElementEvents_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define HTMLMarqueeElementEvents_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define HTMLMarqueeElementEvents_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define HTMLMarqueeElementEvents_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define HTMLMarqueeElementEvents_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLMarqueeElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLMarqueeElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLMarqueeElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLMarqueeElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLMarqueeElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLMarqueeElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLMarqueeElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLMarqueeElement_put_bgColor( x, p ) \
        (x)->lpVtbl->put_bgColor( x, p )
    #define IHTMLMarqueeElement_get_bgColor( x, p ) \
        (x)->lpVtbl->get_bgColor( x, p )
    #define IHTMLMarqueeElement_put_scrollDelay( x, p ) \
        (x)->lpVtbl->put_scrollDelay( x, p )
    #define IHTMLMarqueeElement_get_scrollDelay( x, p ) \
        (x)->lpVtbl->get_scrollDelay( x, p )
    #define IHTMLMarqueeElement_put_direction( x, p ) \
        (x)->lpVtbl->put_direction( x, p )
    #define IHTMLMarqueeElement_get_direction( x, p ) \
        (x)->lpVtbl->get_direction( x, p )
    #define IHTMLMarqueeElement_put_behavior( x, p ) \
        (x)->lpVtbl->put_behavior( x, p )
    #define IHTMLMarqueeElement_get_behavior( x, p ) \
        (x)->lpVtbl->get_behavior( x, p )
    #define IHTMLMarqueeElement_put_scrollAmount( x, p ) \
        (x)->lpVtbl->put_scrollAmount( x, p )
    #define IHTMLMarqueeElement_get_scrollAmount( x, p ) \
        (x)->lpVtbl->get_scrollAmount( x, p )
    #define IHTMLMarqueeElement_put_loop( x, p ) \
        (x)->lpVtbl->put_loop( x, p )
    #define IHTMLMarqueeElement_get_loop( x, p ) \
        (x)->lpVtbl->get_loop( x, p )
    #define IHTMLMarqueeElement_put_vspace( x, p ) \
        (x)->lpVtbl->put_vspace( x, p )
    #define IHTMLMarqueeElement_get_vspace( x, p ) \
        (x)->lpVtbl->get_vspace( x, p )
    #define IHTMLMarqueeElement_put_hspace( x, p ) \
        (x)->lpVtbl->put_hspace( x, p )
    #define IHTMLMarqueeElement_get_hspace( x, p ) \
        (x)->lpVtbl->get_hspace( x, p )
    #define IHTMLMarqueeElement_put_onfinish( x, p ) \
        (x)->lpVtbl->put_onfinish( x, p )
    #define IHTMLMarqueeElement_get_onfinish( x, p ) \
        (x)->lpVtbl->get_onfinish( x, p )
    #define IHTMLMarqueeElement_put_onstart( x, p ) \
        (x)->lpVtbl->put_onstart( x, p )
    #define IHTMLMarqueeElement_get_onstart( x, p ) \
        (x)->lpVtbl->get_onstart( x, p )
    #define IHTMLMarqueeElement_put_onbounce( x, p ) \
        (x)->lpVtbl->put_onbounce( x, p )
    #define IHTMLMarqueeElement_get_onbounce( x, p ) \
        (x)->lpVtbl->get_onbounce( x, p )
    #define IHTMLMarqueeElement_put_width( x, p ) \
        (x)->lpVtbl->put_width( x, p )
    #define IHTMLMarqueeElement_get_width( x, p ) \
        (x)->lpVtbl->get_width( x, p )
    #define IHTMLMarqueeElement_put_height( x, p ) \
        (x)->lpVtbl->put_height( x, p )
    #define IHTMLMarqueeElement_get_height( x, p ) \
        (x)->lpVtbl->get_height( x, p )
    #define IHTMLMarqueeElement_put_trueSpeed( x, p ) \
        (x)->lpVtbl->put_trueSpeed( x, p )
    #define IHTMLMarqueeElement_get_trueSpeed( x, p ) \
        (x)->lpVtbl->get_trueSpeed( x, p )
    #define IHTMLMarqueeElement_start( x ) \
        (x)->lpVtbl->start( x )
    #define IHTMLMarqueeElement_stop( x ) \
        (x)->lpVtbl->stop( x )
    #define DispHTMLMarqueeElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define DispHTMLMarqueeElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define DispHTMLMarqueeElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define DispHTMLMarqueeElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define DispHTMLMarqueeElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define DispHTMLMarqueeElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define DispHTMLMarqueeElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLHtmlElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLHtmlElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLHtmlElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLHtmlElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLHtmlElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLHtmlElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLHtmlElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLHtmlElement_put_version( x, p ) \
        (x)->lpVtbl->put_version( x, p )
    #define IHTMLHtmlElement_get_version( x, p ) \
        (x)->lpVtbl->get_version( x, p )
    #define IHTMLHeadElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLHeadElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLHeadElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLHeadElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLHeadElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLHeadElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLHeadElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLHeadElement_put_profile( x, p ) \
        (x)->lpVtbl->put_profile( x, p )
    #define IHTMLHeadElement_get_profile( x, p ) \
        (x)->lpVtbl->get_profile( x, p )
    #define IHTMLHeadElement2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLHeadElement2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLHeadElement2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLHeadElement2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLHeadElement2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLHeadElement2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLHeadElement2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLHeadElement2_put_profile( x, p ) \
        (x)->lpVtbl->put_profile( x, p )
    #define IHTMLHeadElement2_get_profile( x, p ) \
        (x)->lpVtbl->get_profile( x, p )
    #define IHTMLTitleElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLTitleElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLTitleElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLTitleElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLTitleElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLTitleElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLTitleElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLTitleElement_put_text( x, p ) \
        (x)->lpVtbl->put_text( x, p )
    #define IHTMLTitleElement_get_text( x, p ) \
        (x)->lpVtbl->get_text( x, p )
    #define IHTMLMetaElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLMetaElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLMetaElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLMetaElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLMetaElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLMetaElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLMetaElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLMetaElement_put_httpEquiv( x, p ) \
        (x)->lpVtbl->put_httpEquiv( x, p )
    #define IHTMLMetaElement_get_httpEquiv( x, p ) \
        (x)->lpVtbl->get_httpEquiv( x, p )
    #define IHTMLMetaElement_put_content( x, p ) \
        (x)->lpVtbl->put_content( x, p )
    #define IHTMLMetaElement_get_content( x, p ) \
        (x)->lpVtbl->get_content( x, p )
    #define IHTMLMetaElement_put_name( x, p ) \
        (x)->lpVtbl->put_name( x, p )
    #define IHTMLMetaElement_get_name( x, p ) \
        (x)->lpVtbl->get_name( x, p )
    #define IHTMLMetaElement_put_url( x, p ) \
        (x)->lpVtbl->put_url( x, p )
    #define IHTMLMetaElement_get_url( x, p ) \
        (x)->lpVtbl->get_url( x, p )
    #define IHTMLMetaElement_put_charset( x, p ) \
        (x)->lpVtbl->put_charset( x, p )
    #define IHTMLMetaElement_get_charset( x, p ) \
        (x)->lpVtbl->get_charset( x, p )
    #define IHTMLMetaElement2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLMetaElement2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLMetaElement2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLMetaElement2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLMetaElement2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLMetaElement2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLMetaElement2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLMetaElement2_put_scheme( x, p ) \
        (x)->lpVtbl->put_scheme( x, p )
    #define IHTMLMetaElement2_get_scheme( x, p ) \
        (x)->lpVtbl->get_scheme( x, p )
    #define IHTMLMetaElement3_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLMetaElement3_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLMetaElement3_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLMetaElement3_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLMetaElement3_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLMetaElement3_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLMetaElement3_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLMetaElement3_put_url( x, p ) \
        (x)->lpVtbl->put_url( x, p )
    #define IHTMLMetaElement3_get_url( x, p ) \
        (x)->lpVtbl->get_url( x, p )
    #define IHTMLBaseElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLBaseElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLBaseElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLBaseElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLBaseElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLBaseElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLBaseElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLBaseElement_put_href( x, p ) \
        (x)->lpVtbl->put_href( x, p )
    #define IHTMLBaseElement_get_href( x, p ) \
        (x)->lpVtbl->get_href( x, p )
    #define IHTMLBaseElement_put_target( x, p ) \
        (x)->lpVtbl->put_target( x, p )
    #define IHTMLBaseElement_get_target( x, p ) \
        (x)->lpVtbl->get_target( x, p )
    #define IHTMLBaseElement2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLBaseElement2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLBaseElement2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLBaseElement2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLBaseElement2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLBaseElement2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLBaseElement2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLBaseElement2_put_href( x, p ) \
        (x)->lpVtbl->put_href( x, p )
    #define IHTMLBaseElement2_get_href( x, p ) \
        (x)->lpVtbl->get_href( x, p )
    #define IHTMLIsIndexElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLIsIndexElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLIsIndexElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLIsIndexElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLIsIndexElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLIsIndexElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLIsIndexElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLIsIndexElement_put_prompt( x, p ) \
        (x)->lpVtbl->put_prompt( x, p )
    #define IHTMLIsIndexElement_get_prompt( x, p ) \
        (x)->lpVtbl->get_prompt( x, p )
    #define IHTMLIsIndexElement_put_action( x, p ) \
        (x)->lpVtbl->put_action( x, p )
    #define IHTMLIsIndexElement_get_action( x, p ) \
        (x)->lpVtbl->get_action( x, p )
    #define IHTMLIsIndexElement2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLIsIndexElement2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLIsIndexElement2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLIsIndexElement2_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLIsIndexElement2_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLIsIndexElement2_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLIsIndexElement2_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IHTMLIsIndexElement2_get_form( x, p ) \
        (x)->lpVtbl->get_form( x, p )
    #define IHTMLNextIdElement_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IHTMLNextIdElement_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IHTMLNextIdElement_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IHTMLNextIdElement_GetTypeInfoCount( x, p ) \
        (x)->lpVtbl->GetTypeInfoCount( x, p )
    #define IHTMLNextIdElement_GetTypeInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTypeInfo( x, p1, p2, p3 )
    #define IHTMLNextIdElement_GetIDsOfNames( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetIDsOfNames( x, p1, p2, p3, p4, p5 )
    #define IHTMLNextIdElement_Invoke( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
     