/*
 *  powrprof.h  Power profile functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2010 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* NT error code data type */
#ifndef _NTSTATUS_DEFINED
#define _NTSTATUS_DEFINED
typedef LONG    NTSTATUS;
typedef LONG    *PNTSTATUS;
#endif

/* Handle to a power notification */
#ifndef _HPOWERNOTIFY_DEF_
#define _HPOWERNOTIFY_DEF_
typedef PVOID           HPOWERNOTIFY;
typedef HPOWERNOTIFY    *PHPOWERNOTIFY;
#endif

/* Global flags */
#define EnableSysTrayBatteryManager 0x00000001L
#define EnableMultiBatteryDisplay   0x00000002L
#define EnablePasswordLogon         0x00000004L
#define EnableWakeOnRing            0x00000008L
#define EnableVideoDimDisplay       0x00000010L

/* Power attributes */
#define POWER_ATTRIBUTE_HIDE    0x00000001L

/* Power scheme identifier special value */
#define NEWSCHEME   0xFFFFFFFF

/* DevicePowerEnumDevices() flags */
#define DEVICEPOWER_HARDWAREID              0x80000000L
#define DEVICEPOWER_AND_OPERATION           0x40000000L
#define DEVICEPOWER_FILTER_DEVICES_PRESENT  0x20000000L
#define DEVICEPOWER_FILTER_HARDWARE         0x10000000L
#define DEVICEPOWER_FILTER_WAKEENABLED      0x08000000L
#define DEVICEPOWER_FILTER_WAKEPROGRAMMABLE 0x04000000L
#define DEVICEPOWER_FILTER_ON_NAME          0x02000000L
#define DEVICEPOWER_SET_WAKEENABLED         0x00000001L
#define DEVICEPOWER_CLEAR_WAKEENABLED       0x00000002L

/* Device power capabilities */
#define PDCAP_S0_SUPPORTED              0x00010000L
#define PDCAP_S1_SUPPORTED              0x00020000L
#define PDCAP_S2_SUPPORTED              0x00040000L
#define PDCAP_S3_SUPPORTED              0x00080000L
#define PDCAP_WAKE_FROM_S0_SUPPORTED    0x00100000L
#define PDCAP_WAKE_FROM_S1_SUPPORTED    0x00200000L
#define PDCAP_WAKE_FROM_S2_SUPPORTED    0x00400000L
#define PDCAP_WAKE_FROM_S3_SUPPORTED    0x00800000L
#define PDCAP_S4_SUPPORTED              0x01000000L
#define PDCAP_S5_SUPPORTED              0x02000000L

/* Global machine power policy */
typedef struct _GLOBAL_MACHINE_POWER_POLICY {
    ULONG               Revision;
    SYSTEM_POWER_STATE  LidOpenWakeAc;
    SYSTEM_POWER_STATE  LidOpenWakeDc;
    ULONG               BroadcastCapacityResolution;
} GLOBAL_MACHINE_POWER_POLICY;
typedef GLOBAL_MACHINE_POWER_POLICY *PGLOBAL_MACHINE_POWER_POLICY;

/* Global user power policy */
typedef struct _GLOBAL_USER_POWER_POLICY {
    ULONG               Revision;
    POWER_ACTION_POLICY PowerButtonAc;
    POWER_ACTION_POLICY PowerButtonDc;
    POWER_ACTION_POLICY SleepButtonAc;
    POWER_ACTION_POLICY SleepButtonDc;
    POWER_ACTION_POLICY LidCloseAc;
    POWER_ACTION_POLICY LidCloseDc;
    SYSTEM_POWER_LEVEL  DischargePolicy[NUM_DISCHARGE_POLICIES];
    ULONG               GlobalFlags;
} GLOBAL_USER_POWER_POLICY;
typedef GLOBAL_USER_POWER_POLICY    *PGLOBAL_USER_POWER_POLICY;

/* Global power policy */
typedef struct _GLOBAL_POWER_POLICY {
    GLOBAL_USER_POWER_POLICY    user;
    GLOBAL_MACHINE_POWER_POLICY mach;
} GLOBAL_POWER_POLICY;
typedef GLOBAL_POWER_POLICY *PGLOBAL_POWER_POLICY;

/* Machine power policy */
typedef struct _MACHINE_POWER_POLICY {
    ULONG               Revision;
    SYSTEM_POWER_STATE  MinSleepAc;
    SYSTEM_POWER_STATE  MinSleepDc;
    SYSTEM_POWER_STATE  ReducedLatencySleepAc;
    SYSTEM_POWER_STATE  ReducedLatencySleepDc;
    ULONG               DozeTimeoutAc;
    ULONG               DozeTimeoutDc;
    ULONG               DozeS4TimeoutAc;
    ULONG               DozeS4TimeoutDc;
    UCHAR               MinThrottleAc;
    UCHAR               MinThrottleDc;
    UCHAR               pad1[2];
    POWER_ACTION_POLICY OverThrottledAc;
    POWER_ACTION_POLICY OverThrottledDc;
} MACHINE_POWER_POLICY;
typedef MACHINE_POWER_POLICY    *PMACHINE_POWER_POLICY;

/* Machine processor power policy */
#if (NTDDI_VERSION >= 0x05010000)
typedef struct _MACHINE_PROCESSOR_POWER_POLICY {
    ULONG                   Revision;
    PROCESSOR_POWER_POLICY  ProcessorPolicyAc;
    PROCESSOR_POWER_POLICY  ProcessorPolicyDc;
} MACHINE_PROCESSOR_POWER_POLICY;
typedef MACHINE_PROCESSOR_POWER_POLICY  *PMACHINE_PROCESSOR_POWER_POLICY;
#endif

/* User power policy */
typedef struct _USER_POWER_POLICY {
    ULONG               Revision;
    POWER_ACTION_POLICY IdleAc;
    POWER_ACTION_POLICY IdleDc;
    ULONG               IdleTimeoutAc;
    ULONG               IdleTimeoutDc;
    UCHAR               IdleSensitivityAc;
    UCHAR               IdleSensitivityDc;
    UCHAR               ThrottlePolicyAc;
    UCHAR               ThrottlePolicyDc;
    SYSTEM_POWER_STATE  MaxSleepAc;
    SYSTEM_POWER_STATE  MaxSleepDc;
    ULONG               Reserved[2];
    ULONG               VideoTimeoutAc;
    ULONG               VideoTimeoutDc;
    ULONG               SpindownTimeoutAc;
    ULONG               SpindownTimeoutDc;
    BOOLEAN             OptimizeForPowerAc;
    BOOLEAN             OptimizeForPowerDc;
    UCHAR               FanThrottleToleranceAc;
    UCHAR               FanThrottleToleranceDc;
    UCHAR               ForcedThrottleAc;
    UCHAR               ForcedThrottleDc;
} USER_POWER_POLICY;
typedef USER_POWER_POLICY   *PUSER_POWER_POLICY;

/* Power policy */
typedef struct _POWER_POLICY {
    USER_POWER_POLICY       user;
    MACHINE_POWER_POLICY    mach;
} POWER_POLICY;
typedef POWER_POLICY    *PPOWER_POLICY;

/* Power enumeration callbacks */
typedef BOOLEAN CALLBACK PWRSCHEMESENUMPROC_V1( UINT, DWORD, LPTSTR, DWORD, LPTSTR, PPOWER_POLICY, LPARAM );
typedef BOOLEAN CALLBACK PWRSCHEMESENUMPROC_V2( UINT, DWORD, LPWSTR, DWORD, LPWSTR, PPOWER_POLICY, LPARAM );
#if (NTDDI_VERSION >= 0x06000000)
typedef PWRSCHEMESENUMPROC_V2   *PWRSCHEMESENUMPROC;
#else
typedef PWRSCHEMESENUMPROC_V1   *PWRSCHEMESENUMPROC;
#endif
typedef BOOLEAN (CALLBACK *PFNNTINITIATEPWRACTION)( POWER_ACTION, SYSTEM_POWER_STATE, ULONG, BOOLEAN );

/* Power data accessors */
typedef enum _POWER_DATA_ACCESSOR {
    ACCESS_AC_POWER_SETTING_INDEX               = 0,
    ACCESS_DC_POWER_SETTING_INDEX               = 1,
    ACCESS_FRIENDLY_NAME                        = 2,
    ACCESS_DESCRIPTION                          = 3,
    ACCESS_POSSIBLE_POWER_SETTING               = 4,
    ACCESS_POSSIBLE_POWER_SETTING_FRIENDLY_NAME = 5,
    ACCESS_POSSIBLE_POWER_SETTING_DESCRIPTION   = 6,
    ACCESS_DEFAULT_AC_POWER_SETTING             = 7,
    ACCESS_DEFAULT_DC_POWER_SETTING             = 8,
    ACCESS_POSSIBLE_VALUE_MIN                   = 9,
    ACCESS_POSSIBLE_VALUE_MAX                   = 10,
    ACCESS_POSSIBLE_VALUE_INCREMENT             = 11,
    ACCESS_POSSIBLE_VALUE_UNITS                 = 12,
    ACCESS_ICON_RESOURCE                        = 13,
    ACCESS_DEFAULT_SECURITY_DESCRIPTOR          = 14,
    ACCESS_ATTRIBUTES                           = 15,
    ACCESS_SCHEME                               = 16,
    ACCESS_SUBGROUP                             = 17,
    ACCESS_INDIVIDUAL_SETTING                   = 18,
    ACCESS_ACTIVE_SCHEME                        = 19,
    ACCESS_CREATE_SCHEME                        = 20,
    ACCESS_AC_POWER_SETTING_MAX                 = 21,
    ACCESS_DC_POWER_SETTING_MAX                 = 22,
    ACCESS_AC_POWER_SETTING_MIN                 = 23,
    ACCESS_DC_POWER_SETTING_MIN                 = 24
} POWER_DATA_ACCESSOR;
typedef POWER_DATA_ACCESSOR *PPOWER_DATA_ACCESSOR;

/* Functions in POWRPROF.DLL */
NTSTATUS WINAPI     CallNtPowerInformation( POWER_INFORMATION_LEVEL, PVOID, ULONG, PVOID, ULONG );
STDAPI_( BOOLEAN )  CanUserWritePwrScheme( VOID );
STDAPI_( BOOLEAN )  DeletePwrScheme( UINT );
STDAPI_( BOOLEAN )  EnumPwrSchemes( PWRSCHEMESENUMPROC, LPARAM );
STDAPI_( BOOLEAN )  GetActivePwrScheme( PUINT );
STDAPI_( BOOLEAN )  GetCurrentPowerPolicies( PGLOBAL_POWER_POLICY, PPOWER_POLICY );
STDAPI_( BOOLEAN )  GetPwrCapabilities( PSYSTEM_POWER_CAPABILITIES );
STDAPI_( BOOLEAN )  GetPwrDiskSpindownRange( PUINT, PUINT );
STDAPI_( BOOLEAN )  IsAdminOverrideActive( PADMINISTRATOR_POWER_POLICY );
STDAPI_( BOOLEAN )  IsPwrHibernateAllowed( VOID );
STDAPI_( BOOLEAN )  IsPwrShutdownAllowed( VOID );
STDAPI_( BOOLEAN )  IsPwrSuspendAllowed( VOID );
STDAPI_( BOOLEAN )  ReadGlobalPwrPolicy( PGLOBAL_POWER_POLICY );
STDAPI_( BOOLEAN )  ReadPwrScheme( UINT, PPOWER_POLICY );
STDAPI_( BOOLEAN )  SetActivePwrScheme( UINT, PGLOBAL_POWER_POLICY, PPOWER_POLICY );
STDAPI_( BOOLEAN )  SetSuspendState( BOOLEAN, BOOLEAN, BOOLEAN );
STDAPI_( BOOLEAN )  ValidatePowerPolicies( PGLOBAL_POWER_POLICY, PPOWER_POLICY );
STDAPI_( BOOLEAN )  WriteGlobalPwrPolicy( PGLOBAL_POWER_POLICY );
STDAPI_( BOOLEAN )  WritePwrScheme( PUINT, LPCWSTR, LPCWSTR, PPOWER_POLICY );
#if (NTDDI_VERSION >= 0x05010000)
STDAPI_( BOOLEAN )  ReadProcessorPwrScheme( UINT, PMACHINE_PROCESSOR_POWER_POLICY );
STDAPI_( BOOLEAN )  WriteProcessorPwrScheme( UINT, PMACHINE_PROCESSOR_POWER_POLICY );
#endif
#if (NTDDI_VERSION >= 0x05020000)
STDAPI_( BOOLEAN )  DevicePowerClose( VOID );
STDAPI_( BOOLEAN )  DevicePowerEnumDevices( ULONG, ULONG, ULONG, PBYTE, PULONG );
STDAPI_( BOOLEAN )  DevicePowerOpen( ULONG );
STDAPI_( DWORD )    DevicePowerSetDeviceState( LPCWSTR, ULONG, PVOID );
#endif
#if (NTDDI_VERSION >= 0x06000000)
STDAPI_( DWORD )    PowerCanRestoreIndividualDefaultPowerScheme( CONST GUID * );
STDAPI_( DWORD )    PowerCreatePossibleSetting( HKEY, CONST GUID *, CONST GUID *, ULONG );
STDAPI_( DWORD )    PowerCreateSetting( HKEY, CONST GUID *, CONST GUID * );
STDAPI_( DWORD )    PowerDeleteScheme( HKEY, CONST GUID * );
STDAPI_( POWER_PLATFORM_ROLE )  PowerDeterminePlatformRole( VOID );
STDAPI_( DWORD )    PowerDuplicateScheme( HKEY, CONST GUID *, GUID ** );
STDAPI_( DWORD )    PowerEnumerate( HKEY, CONST GUID *, CONST GUID *, POWER_DATA_ACCESSOR, ULONG, UCHAR *, DWORD * );
STDAPI_( DWORD )    PowerGetActiveScheme( HKEY, GUID ** );
STDAPI_( DWORD )    PowerImportPowerScheme( HKEY, LPCWSTR, GUID ** );
STDAPI_( DWORD )    PowerOpenSystemPowerKey( HKEY *, REGSAM, BOOL );
STDAPI_( DWORD )    PowerOpenUserPowerKey( HKEY *, REGSAM, BOOL );
STDAPI_( DWORD )    PowerReadACDefaultIndex( HKEY, CONST GUID *, CONST GUID *, CONST GUID *, LPDWORD );
STDAPI_( DWORD )    PowerReadACValue( HKEY, CONST GUID *, CONST GUID *, CONST GUID *, PULONG, LPBYTE, LPDWORD );
STDAPI_( DWORD )    PowerReadACValueIndex( HKEY, CONST GUID *, CONST GUID *, CONST GUID *, LPDWORD );
STDAPI_( DWORD )    PowerReadDCDefaultIndex( HKEY, CONST GUID *, CONST GUID *, CONST GUID *, LPDWORD );
STDAPI_( DWORD )    PowerReadDCValue( HKEY, CONST GUID *, CONST GUID *, CONST GUID *, PULONG, PUCHAR, LPDWORD );
STDAPI_( DWORD )    PowerReadDCValueIndex( HKEY, CONST GUID *, CONST GUID *, CONST GUID *, LPDWORD );
STDAPI_( DWORD )    PowerReadDescription( HKEY, CONST GUID *, CONST GUID *, CONST GUID *, PUCHAR, LPDWORD );
STDAPI_( DWORD )    PowerReadFriendlyName( HKEY, CONST GUID *, CONST GUID *, CONST GUID *, PUCHAR, LPDWORD );
STDAPI_( DWORD )    PowerReadIconResourceSpecifier( HKEY, CONST GUID *, CONST GUID *, CONST GUID *, PUCHAR, LPDWORD );
STDAPI_( DWORD )    PowerReadPossibleDescription( HKEY, CONST GUID *, CONST GUID *, ULONG, PUCHAR, LPDWORD );
STDAPI_( DWORD )    PowerReadPossibleFriendlyName( HKEY, CONST GUID *, CONST GUID *, ULONG, PUCHAR, LPDWORD );
STDAPI_( DWORD )    PowerReadPossibleValue( HKEY, CONST GUID *, CONST GUID *, PULONG, ULONG, PUCHAR, LPDWORD );
STDAPI_( DWORD )    PowerReadSettingAttributes( CONST GUID *, CONST GUID * );
STDAPI_( DWORD )    PowerReadValueIncrement( HKEY, CONST GUID *, CONST GUID *, LPDWORD );
STDAPI_( DWORD )    PowerReadValueMax( HKEY, CONST GUID *, CONST GUID *, LPDWORD );
STDAPI_( DWORD )    PowerReadValueMin( HKEY, CONST GUID *, CONST GUID *, LPDWORD );
STDAPI_( DWORD )    PowerReadValueUnitsSpecifier( HKEY, CONST GUID *, CONST GUID *, UCHAR *, LPDWORD );
STDAPI_( DWORD )    PowerRemovePowerSetting( CONST GUID *, CONST GUID * );
STDAPI_( DWORD )    PowerReplaceDefaultPowerSchemes( VOID );
STDAPI_( DWORD )    PowerRestoreDefaultPowerSchemes( VOID );
STDAPI_( DWORD )    PowerRestoreIndividualDefaultPowerScheme( CONST GUID * );
STDAPI_( DWORD )    PowerSetActiveScheme( HKEY, CONST GUID * );
STDAPI_( DWORD )    PowerSettingAccessCheck( POWER_DATA_ACCESSOR, CONST GUID * );
STDAPI_( DWORD )    PowerWriteACDefaultIndex( HKEY, CONST GUID *, CONST GUID *, CONST GUID *, DWORD );
STDAPI_( DWORD )    PowerWriteACValueIndex( HKEY, CONST GUID *, CONST GUID *, CONST GUID *, DWORD );
STDAPI_( DWORD )    PowerWriteDCDefaultIndex( HKEY, CONST GUID *, CONST GUID *, CONST GUID *, DWORD );
STDAPI_( DWORD )    PowerWriteDCValueIndex( HKEY, CONST GUID *, CONST GUID *, CONST GUID *, DWORD );
STDAPI_( DWORD )    PowerWriteDescription( HKEY, CONST GUID *, CONST GUID *, CONST GUID *, UCHAR *, DWORD );
STDAPI_( DWORD )    PowerWriteFriendlyName( HKEY, CONST GUID *, CONST GUID *, CONST GUID *, UCHAR *, DWORD );
STDAPI_( DWORD )    PowerWriteIconResourceSpecifier( HKEY, CONST GUID *, CONST GUID *, CONST GUID *, UCHAR *, DWORD );
STDAPI_( DWORD )    PowerWritePossibleDescription( HKEY, CONST GUID *, CONST GUID *, ULONG, UCHAR *, DWORD );
STDAPI_( DWORD )    PowerWritePossibleFriendlyName( HKEY, CONST GUID *, CONST GUID *, ULONG, UCHAR *, DWORD );
STDAPI_( DWORD )    PowerWritePossibleValue( HKEY, CONST GUID *, CONST GUID *, ULONG, ULONG, UCHAR *, DWORD );
STDAPI_( DWORD )    PowerWriteSettingAttributes( CONST GUID *, CONST GUID *, DWORD );
STDAPI_( DWORD )    PowerWriteValueIncrement( HKEY, CONST GUID *, CONST GUID *, DWORD );
STDAPI_( DWORD )    PowerWriteValueMax( HKEY, CONST GUID *, CONST GUID *, DWORD );
STDAPI_( DWORD )    PowerWriteValueMin( HKEY, CONST GUID *, CONST GUID *, DWORD );
STDAPI_( DWORD )    PowerWriteValueUnitsSpecifier( HKEY, CONST GUID *, CONST GUID *, UCHAR *, DWORD );
#endif
#if (NTDDI_VERSION >= 0x06010000)
STDAPI_( DWORD )    PowerSettingRegisterNotification( LPCGUID, DWORD, HANDLE, PHPOWERNOTIFY );
STDAPI_( DWORD )    PowerSettingUnregisterNotification( HPOWERNOTIFY );
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif
