/*
 *  rpcdce.h    RPC Distributed Computing Environment (DCE) functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2010 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef __RPCDCE_H__
#define __RPCDCE_H__

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* RPC string data types */
typedef unsigned char           *RPC_CSTR;
#ifdef RPC_USE_NATIVE_WCHAR
typedef wchar_t                 *RPC_WSTR;
typedef const wchar_t           *RPC_CWSTR;
#else
typedef unsigned short          *RPC_WSTR;
typedef const unsigned short    *RPC_CWSTR;
#endif

/* RPC handle data types */
typedef I_RPC_HANDLE            RPC_BINDING_HANDLE;
typedef RPC_BINDING_HANDLE      handle_t;
#define rpc_binding_handle_t    RPC_BINDING_HANDLE
typedef void                    *RPC_IF_HANDLE;
typedef void                    *RPC_AUTH_IDENTITY_HANDLE;
typedef void                    *RPC_AUTHZ_HANDLE;
typedef I_RPC_HANDLE            RPC_EP_INQ_HANDLE;

/* Other RPC primitive data types */
#define RPC_MGR_EPV void

/* Universally unique identifier (UUID) data types */
#ifndef GUID_DEFINED
#include <guiddef.h>
#endif

#ifndef UUID_DEFINED
#define UUID_DEFINED
typedef GUID    UUID;
#ifndef uuid_t
#define uuid_t  UUID
#endif
#endif

#ifndef _AUTH_IDENTITY_DEFINED
#define _AUTH_IDENTITY_DEFINED

/* Authentication identity flags */
#define SEC_WINNT_AUTH_IDENTITY_ANSI    0x00000001L
#define SEC_WINNT_AUTH_IDENTITY_UNICODE 0x00000002L

/* Authentication identity */
typedef struct _SEC_WINNT_AUTH_IDENTITY_A {
    unsigned char   *User;
    unsigned long   UserLength;
    unsigned char   *Domain;
    unsigned long   DomainLength;
    unsigned char   *Password;
    unsigned long   PasswordLength;
    unsigned long   Flags;
} SEC_WINNT_AUTH_IDENTITY_A;
typedef SEC_WINNT_AUTH_IDENTITY_A   *PSEC_WINNT_AUTH_IDENTITY_A;
typedef struct _SEC_WINNT_AUTH_IDENTITY_W {
    unsigned short  *User;
    unsigned long   UserLength;
    unsigned short  *Domain;
    unsigned long   DomainLength;
    unsigned short  *Password;
    unsigned long   PasswordLength;
    unsigned long   Flags;
} SEC_WINNT_AUTH_IDENTITY_W;
typedef SEC_WINNT_AUTH_IDENTITY_W   *PSEC_WINNT_AUTH_IDENTITY_W;
#ifdef UNICODE
typedef SEC_WINNT_AUTH_IDENTITY_W   SEC_WINNT_AUTH_IDENTITY;
typedef PSEC_WINNT_AUTH_IDENTITY_W  PSEC_WINNT_AUTH_IDENTITY;
#else
typedef SEC_WINNT_AUTH_IDENTITY_A   SEC_WINNT_AUTH_IDENTITY;
typedef PSEC_WINNT_AUTH_IDENTITY_A  PSEC_WINNT_AUTH_IDENTITY;
#endif

#endif /* _AUTH_IDENTITY_DEFINED */

/* RPC timeout values */
#define RPC_C_BINDING_INFINITE_TIMEOUT  10
#define RPC_C_BINDING_MIN_TIMEOUT       0
#define RPC_C_BINDING_DEFAULT_TIMEOUT   5
#define RPC_C_BINDING_MAX_TIMEOUT       9
#define RPC_C_CANCEL_INFINITE_TIMEOUT   (-1)

/* Maximum values */
#define RPC_C_LISTEN_MAX_CALLS_DEFAULT  1234
#define RPC_C_PROTSEQ_MAX_REQS_DEFAULT  10

/* RPC_POLICY endpoint flags */
#define RPC_C_BIND_TO_ALL_NICS                  0x00000001L
#define RPC_C_USE_INTERNET_PORT                 0x00000001L
#define RPC_C_USE_INTRANET_PORT                 0x00000002L
#define RPC_C_DONT_FAIL                         0x00000004L
#define RPC_C_RPCHTTP_USE_LOAD_BALANCE          0x00000008L
#if (NTDDI_VERSION < 0x06000000)
    #define RPC_C_MQ_TEMPORARY                  0x00000000L
    #define RPC_C_MQ_PERMANENT                  0x00000001L
    #define RPC_C_MQ_CLEAR_ON_OPEN              0x00000002L
    #define RPC_C_MQ_USE_EXISTING_SECURITY      0x00000004L
    #define RPC_C_MQ_AUTHN_LEVEL_NONE           0x00000000L
    #define RPC_C_MQ_AUTHN_LEVEL_PKT_INTEGRITY  0x00000008L
    #define RPC_C_MQ_AUTHN_LEVEL_PKT_PRIVACY    0x00000010L
#endif

/* RPC delivery option values */
#if (NTDDI_VERSION < 0x06000000)
    #define RPC_C_MQ_EXPRESS        0L
    #define RPC_C_MQ_RECOVERABLE    1L
#endif

/* RPC journal option values */
#if (NTDDI_VERSION < 0x06000000)
    #define RPC_C_MQ_JOURNAL_NONE       0L
    #define RPC_C_MQ_JOURNAL_DEADLETTER 1L
    #define RPC_C_MQ_JOURNAL_ALWAYS     2L
#endif

/* RPC binding options */
#if (NTDDI_VERSION < 0x06000000)
    #define RPC_C_OPT_MQ_DELIVERY               1L
    #define RPC_C_OPT_MQ_PRIORITY               2L
    #define RPC_C_OPT_MQ_JOURNAL                3L
    #define RPC_C_OPT_MQ_ACKNOWLEDGE            4L
    #define RPC_C_OPT_MQ_AUTHN_SERVICE          5L
    #define RPC_C_OPT_MQ_AUTHN_LEVEL            6L
    #define RPC_C_OPT_MQ_TIME_TO_REACH_QUEUE    7L
    #define RPC_C_OPT_MQ_TIME_TO_BE_RECEIVED    8L
#endif
#define RPC_C_OPT_BINDING_NONCAUSAL             9L
#define RPC_C_OPT_SECURITY_CALLBACK             10L
#define RPC_C_OPT_UNIQUE_BINDING                11L
#if (NTDDI_VERSION >= 0x05010000)
    #define RPC_C_OPT_CALL_TIMEOUT              12L
    #define RPC_C_OPT_DONT_LINGER               13L
#endif
#if (NTDDI_VERSION >= 0x06000000)
    #define RPC_C_OPT_TRANS_SEND_BUFFER_SIZE    5L
    #define RPC_C_OPT_TRUST_PEER                14L
    #define RPC_C_OPT_ASYNC_BLOCK               15L
    #define RPC_C_OPT_OPTIMIZE_TIME             16L
    #define RPC_C_OPT_MAX_OPTIONS               17L
#elif (NTDDI_VERSION >= 0x05010000)
    #define RPC_C_OPT_MAX_OPTIONS               14L
#else
    #define RPC_C_OPT_MAX_OPTIONS               12L
#endif

/* RpcServerInqAuthClientEx() flags */
#define RPC_C_FULL_CERT_CHAIN   0x00000001L

/* RPC server statistics */
#define RPC_C_STATS_CALLS_IN    0L
#define RPC_C_STATS_CALLS_OUT   1L
#define RPC_C_STATS_PKTS_IN     2L
#define RPC_C_STATS_PKTS_OUT    3L

/* RPC authentication levels */
#define RPC_C_AUTHN_LEVEL_DEFAULT       0L
#define RPC_C_AUTHN_LEVEL_NONE          1L
#define RPC_C_AUTHN_LEVEL_CONNECT       2L
#define RPC_C_AUTHN_LEVEL_CALL          3L
#define RPC_C_AUTHN_LEVEL_PKT           4L
#define RPC_C_AUTHN_LEVEL_PKT_INTEGRITY 5L
#define RPC_C_AUTHN_LEVEL_PKT_PRIVACY   6L

/* RPC impersonation levels */
#define RPC_C_IMP_LEVEL_DEFAULT     0L
#define RPC_C_IMP_LEVEL_ANONYMOUS   1L
#define RPC_C_IMP_LEVEL_IDENTITY    2L
#define RPC_C_IMP_LEVEL_IMPERSONATE 3L
#define RPC_C_IMP_LEVEL_DELEGATE    4L

/* RPC quality of serivce (QOS) identities */
#define RPC_C_QOS_IDENTITY_STATIC   0L
#define RPC_C_QOS_IDENTITY_DYNAMIC  1L

/* RPC quality of service (QOS) capabilities */
#define RPC_C_QOS_CAPABILITIES_DEFAULT                          0x00000000L
#define RPC_C_QOS_CAPABILITIES_MUTUAL_AUTH                      0x00000001L
#define RPC_C_QOS_CAPABILITIES_MAKE_FULLSIC                     0x00000002L
#define RPC_C_QOS_CAPABILITIES_ANY_AUTHOITY                     0x00000004L
#if (NTDDI_VERSION >= 0x05020000)
    #define RPC_C_QOS_CAPABILITIES_IGNORE_DELEGATE_FAILURE      0x00000008L
    #define RPC_C_QOS_CAPABILITIES_LOCAL_MA_HINT                0x00000010L
#endif
#if (NTDDI_VERSION >= 0x06000000)
    #define RPC_C_QOS_CAPABILITIES_SCHANNEL_FULL_AUTH_IDENTITY  0x00000020L
#endif

/* RPC protection levels */
#define RPC_C_PROTECT_LEVEL_DEFAULT         RPC_C_AUTHN_LEVEL_DEFAULT
#define RPC_C_PROTECT_LEVEL_NONE            RPC_C_AUTHN_LEVEL_NONE
#define RPC_C_PROTECT_LEVEL_CONNECT         RPC_C_AUTHN_LEVEL_CONNECT
#define RPC_C_PROTECT_LEVEL_CALL            RPC_C_AUTHN_LEVEL_CALL
#define RPC_C_PROTECT_LEVEL_PKT             RPC_C_AUTHN_LEVEL_PKT
#define RPC_C_PROTECT_LEVEL_PKT_INTEGRITY   RPC_C_AUTHN_LEVEL_PKT_INTEGRITY
#define RPC_C_PROTECT_LEVEL_PKT_PRIVACY     RPC_C_AUTHN_LEVEL_PKT_PRIVACY

/* RPC authentication services */
#define RPC_C_AUTHN_NONE            0L
#define RPC_C_AUTHN_DCE_PRIVATE     1L
#define RPC_C_AUTHN_DCE_PUBLIC      2L
#define RPC_C_AUTHN_DEC_PUBLIC      4L
#define RPC_C_AUTHN_GSS_NEGOTIATE   9L
#define RPC_C_AUTHN_WINNT           10L
#define RPC_C_AUTHN_GSS_SCHANNEL    14L
#define RPC_C_AUTHN_GSS_KERBEROS    16L
#define RPC_C_AUTHN_DPA             17L
#define RPC_C_AUTHN_MSN             18L
#if (NTDDI_VERSION >= 0x05000000)
    #define RPC_C_AUTHN_DIGEST      21L
#endif
#if (NTDDI_VERSION >= 0x06010000)
    #define RPC_C_AUTHN_KERNEL      20L
#endif
#define RPC_C_AUTHN_NEGO_EXTENDER   30L
#define RPC_C_AUTHN_PKU2U           31L
#define RPC_C_AUTHN_MQ              100L
#define RPC_C_AUTHN_DEFAULT         0xFFFFFFFFL

/* Special authentication identity handle value */
#define RPC_C_NO_CREDENTIALS    0xFFFFFFFFL

/* RPC_SECURITY_QOS structure version */
#define RPC_C_SECURITY_QOS_VERSION          1L
#define RPC_C_SECURITY_QOS_VERSION_1        1L
#if (NTDDI_VERSION >= 0x05010000)
    #define RPC_C_SECURITY_QOS_VERSION_2    2L
#endif

/* RPC HTTP authentication targets */
#if (NTDDI_VERSION >= 0x05010000)
    #define RPC_C_HTTP_AUTHN_TARGET_SERVER  1L
#endif
#if (NTDDI_VERSION >= 0x06000000)
    #define RPC_C_HTTP_AUTHN_TARGET_PROXY   2L
#endif

/* RPC HTTP authentication schemes */
#if (NTDDI_VERSION >= 0x05010000)
    #define RPC_C_HTTP_AUTHN_SCHEME_BASIC       0x00000001L
    #define RPC_C_HTTP_AUTHN_SCHEME_NTLM        0x00000002L
    #define RPC_C_HTTP_AUTHN_SCHEME_PASSPORT    0x00000004L
    #define RPC_C_HTTP_AUTHN_SCHEME_DIGEST      0x00000008L
    #define RPC_C_HTTP_AUTHN_SCHEME_NEGOTITATE  0x00000010L
#endif
#if (NTDDI_VERSION >= 0x05020000)
    #define RPC_C_HTTP_AUTHN_SCHEME_CERT        0x00010000L
#endif

/* RPC HTTP flags */
#if (NTDDI_VERSION >= 0x05010000)
    #define RPC_C_HTTP_FLAG_USE_SSL                         1L
    #define RPC_C_HTTP_FLAG_USE_FIRST_AUTH_SCHEME           2L
#endif
#if (NTDDI_VERSION >= 0x05020000)
    #define RPC_C_HTTP_FLAG_IGNORE_CERT_CN_INVALID          8L
#endif
#if (NTDDI_VERSION >= 0x06000100)
    #define RPC_C_HTTP_FLAG_ENABLE_CERT_REVOCATION_CHECK    16L
#endif

/* RPC protocol sequence protocols */
#if (NTDDI_VERSION >= 0x06000000)
    #define RPC_PROTSEQ_TCP     0x01
    #define RPC_PROTSEQ_NMP     0x02
    #define RPC_PROTSEQ_LRPC    0x03
    #define RPC_PROTSEQ_HTTP    0x04
#endif

/* RPC binding handle template flags */
#if (NTDDI_VERSION >= 0x06000000)
    #define RPC_BHT_OBJECT_UUID_VALID   0x00000001L
#endif

/* RPC binding handle options flags */
#if (NTDDI_VERSION >= 0x06000000)
    #define RPC_BHO_NONCAUSAL                   0x00000001L
    #define RPC_BHO_DONTLINGER                  0x00000002L
    #define RPC_BHO_EXCLUSIVE_AND_GUARANTEED    0x00000004L
#endif

/* RPC authorization services */
#define RPC_C_AUTHZ_NONE    0x00000000L
#define RPC_C_AUTHZ_NAME    0x00000001L
#define RPC_C_AUTHZ_DCE     0x00000002L
#define RPC_C_AUTHZ_DEFAULT 0xFFFFFFFFL

/* RPC endpoint inquiry types */
#define RPC_C_EP_ALL_ELTS       0L
#define RPC_C_EP_MATCH_BY_IF    1L
#define RPC_C_EP_MATCH_BY_OBJ   2L
#define RPC_C_EP_MATCH_BY_BOTH  3L

/* RPC version options */
#define RPC_C_VERS_ALL          1L
#define RPC_C_VERS_COMPATIBLE   2L
#define RPC_C_VERS_EXACT        3L
#define RPC_C_VERS_MAJOR_ONLY   4L
#define RPC_C_VERS_UPTO         5L

/* RPC management operations */
#define RPC_C_MGMT_INQ_IF_IDS           0L
#define RPC_C_MGMT_INQ_PRINC_NAME       1L
#define RPC_C_MGMT_INQ_STATS            2L
#define RPC_C_MGMT_IS_SERVER_LISTEN     3L
#define RPC_C_MGMT_STOP_SERVER_LISTEN   4L

/* RPC interface registration flags */
#define RPC_IF_AUTOLISTEN                   0x0001
#define RPC_IF_OLE                          0x0002
#define RPC_IF_ALLOW_UNKNOWN_AUTHORITY      0x0004
#define RPC_IF_ALLOW_SECURE_ONLY            0x0008
#define RPC_IF_ALLOW_CALLBACKS_WITH_NO_AUTH 0x0010
#define RPC_IF_ALLOW_LOCAL_ONLY             0x0020
#define RPC_IF_SEC_NO_CACHE                 0x0040
#if (NTDDI_VERSION >= 0x06000000)
    #define RPC_IF_SEC_CACHE_PER_PROC       0x0080
    #define RPC_IF_ASYNC_CALLBACK           0x0100
#endif

/* RPC binding vector */
typedef struct _RPC_BINDING_VECTOR {
    unsigned long       Count;
    RPC_BINDING_HANDLE  BindingH[1];
} RPC_BINDING_VECTOR;

/* UUID vector */
typedef struct _UUID_VECTOR {
    unsigned long   Count;
    UUID            *Uuid[1];
} UUID_VECTOR;
#define uuid_vector_t   UUID_VECTOR

/* RPC interface identifier */
typedef struct _RPC_IF_ID {
    UUID            Uuid;
    unsigned short  VersMajor;
    unsigned short  VersMinor;
} RPC_IF_ID;

/* RPC protocol sequence vector */
typedef struct _RPC_PROTSEQ_VECTORA {
    unsigned int    Count;
    unsigned char   *Protseq[1];
} RPC_PROTSEQ_VECTORA;
typedef struct _RPC_PROTSEQ_VECTORW {
    unsigned int    Count;
    unsigned short  *Protseq[1];
} RPC_PROTSEQ_VECTORW;
#ifdef UNICODE
typedef RPC_PROTSEQ_VECTORW RPC_PROTSEQ_VECTOR;
#else
typedef RPC_PROTSEQ_VECTORA RPC_PROTSEQ_VECTOR;
#endif

/* RPC policy */
typedef struct _RPC_POLICY {
    unsigned int    Length;
    unsigned long   EndpointFlags;
    unsigned long   NICFlags;
} RPC_POLICY;
typedef RPC_POLICY  *PRPC_POLICY;

/* RPC callbacks */
typedef void (RPC_ENTRY RPC_OBJECT_INQ_FN)( UUID *, UUID *, RPC_STATUS * );
typedef RPC_STATUS (RPC_ENTRY RPC_IF_CALLBACK_FN)( RPC_IF_HANDLE, void * );
typedef void (RPC_ENTRY RPC_SECURITY_CALLBACK_FN)( void * );

/* RPC statistics vector */
typedef struct {
    unsigned int    Count;
    unsigned long   Stats[1];
} RPC_STATS_VECTOR;

/* RPC interface identifier vector */
typedef struct {
    unsigned long   Count;
    RPC_IF_ID       *IfId[1];
} RPC_IF_ID_VECTOR;

/* RPC security quality of service (QOS) */
typedef struct _RPC_SECURITY_QOS {
    unsigned long   Version;
    unsigned long   Capabilities;
    unsigned long   IdentityTracking;
    unsigned long   ImpersonationType;
} RPC_SECURITY_QOS;
typedef RPC_SECURITY_QOS    *PRPC_SECURITY_QOS;

/* RPC HTTP transport credentials */
typedef struct _RPC_HTTP_TRANSPORT_CREDENTIALS_A {
    SEC_WINNT_AUTH_IDENTITY_A   *TransportCredentials;
    unsigned long               Flags;
    unsigned long               AuthenticationTarget;
    unsigned long               NumberOfAuthnSchemes;
    unsigned long               *AuthnSchemes;
    unsigned char               *ServerCertificateSubject;
} RPC_HTTP_TRANSPORT_CREDENTIALS_A;
typedef RPC_HTTP_TRANSPORT_CREDENTIALS_A    *PRPC_HTTP_TRANSPORT_CREDENTIALS_A;
typedef struct _RPC_HTTP_TRANSPORT_CREDENTIALS_W {
    SEC_WINNT_AUTH_IDENTITY_W   *TransportCredentials;
    unsigned long               Flags;
    unsigned long               AuthenticationTarget;
    unsigned long               NumberOfAuthnSchemes;
    unsigned long               *AuthnSchemes;
    unsigned short              *ServerCertificateSubject;
} RPC_HTTP_TRANSPORT_CREDENTIALS_W;
typedef RPC_HTTP_TRANSPORT_CREDENTIALS_W    *PRPC_HTTP_TRANSPORT_CREDENTIALS_W;
#ifdef UNICODE
typedef RPC_HTTP_TRANSPORT_CREDENTIALS_W    RPC_HTTP_TRANSPORT_CREDENTIALS;
typedef PRPC_HTTP_TRANSPORT_CREDENTIALS_W   PRPC_HTTP_TRANSPORT_CREDENTIALS;
#else
typedef RPC_HTTP_TRANSPORT_CREDENTIALS_A    RPC_HTTP_TRANSPORT_CREDENTIALS;
typedef PRPC_HTTP_TRANSPORT_CREDENTIALS_A   PRPC_HTTP_TRANSPORT_CREDENTIALS;
#endif

/* RPC HTTP transport credentials (version 2) */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _RPC_HTTP_TRANSPORT_CREDENTIALS_V2_A {
    SEC_WINNT_AUTH_IDENTITY_A   *TransportCredentials;
    unsigned long               Flags;
    unsigned long               AuthenticationTarget;
    unsigned long               NumberOfAuthnSchemes;
    unsigned long               *AuthnSchemes;
    unsigned char               *ServerCertificateSubject;
    SEC_WINNT_AUTH_IDENTITY_A   *ProxyCredentials;
    unsigned long               NumberOfProxyAuthnSchemes;
    unsigned long               *ProxyAuthnSchemes;
} RPC_HTTP_TRANSPORT_CREDENTIALS_V2_A;
typedef RPC_HTTP_TRANSPORT_CREDENTIALS_V2_A     *PRPC_HTTP_TRANSPORT_CREDENTIALS_V2_A;
typedef struct _RPC_HTTP_TRANSPORT_CREDENTIALS_V2_W {
    SEC_WINNT_AUTH_IDENTITY_W   *TransportCredentials;
    unsigned long               Flags;
    unsigned long               AuthenticationTarget;
    unsigned long               NumberOfAuthnSchemes;
    unsigned long               *AuthnSchemes;
    unsigned short              *ServerCertificateSubject;
    SEC_WINNT_AUTH_IDENTITY_W   *ProxyCredentials;
    unsigned long               NumberOfProxyAuthnSchemes;
    unsigned long               *ProxyAuthnSchemes;
} RPC_HTTP_TRANSPORT_CREDENTIALS_V2_W;
typedef RPC_HTTP_TRANSPORT_CREDENTIALS_V2_W     *PRPC_HTTP_TRANSPORT_CREDENTIALS_V2_W;
#ifdef UNICODE
typedef RPC_HTTP_TRANSPORT_CREDENTIALS_V2_W     RPC_HTTP_TRANSPORT_CREDENTIALS_V2;
typedef PRPC_HTTP_TRANSPORT_CREDENTIALS_V2_W    PRPC_HTTP_TRANSPORT_CREDENTIALS_V2;
#else
typedef RPC_HTTP_TRANSPORT_CREDENTIALS_V2_A     RPC_HTTP_TRANSPORT_CREDENTIALS_V2;
typedef PRPC_HTTP_TRANSPORT_CREDENTIALS_V2_A    PRPC_HTTP_TRANSPORT_CREDENTIALS_V2;
#endif
#endif

/* RPC HTTP transport credentials (version 3) */
#if (NTDDI_VERSION >= 0x06010000)
typedef struct _RPC_HTTP_TRANSPORT_CREDENTIALS_V3_A {
    RPC_AUTH_IDENTITY_HANDLE    TransportCredentials;
    unsigned long               Flags;
    unsigned long               AuthenticationTarget;
    unsigned long               NumberOfAuthnSchemes;
    unsigned long               *AuthnSchemes;
    unsigned char               *ServerCertificateSubject;
    RPC_AUTH_IDENTITY_HANDLE    ProxyCredentials;
    unsigned long               NumberOfProxyAuthnSchemes;
    unsigned long               *ProxyAuthnSchemes;
} RPC_HTTP_TRANSPORT_CREDENTIALS_V3_A;
typedef RPC_HTTP_TRANSPORT_CREDENTIALS_V3_A     *PRPC_HTTP_TRANSPORT_CREDENTIALS_V3_A;
typedef struct _RPC_HTTP_TRANSPORT_CREDENTIALS_V3_W {
    RPC_AUTH_IDENTITY_HANDLE    TransportCredentials;
    unsigned long               Flags;
    unsigned long               AuthenticationTarget;
    unsigned long               NumberOfAuthnSchemes;
    unsigned long               *AuthnSchemes;
    unsigned short              *ServerCertificateSubject;
    RPC_AUTH_IDENTITY_HANDLE    ProxyCredentials;
    unsigned long               NumberOfProxyAuthnSchemes;
    unsigned long               *ProxyAuthnSchemes;
} RPC_HTTP_TRANSPORT_CREDENTIALS_V3_W;
typedef RPC_HTTP_TRANSPORT_CREDENTIALS_V3_W     *PRPC_HTTP_TRANSPORT_CREDENTIALS_V3_W;
#ifdef UNICODE
typedef RPC_HTTP_TRANSPORT_CREDENTIALS_V3_W     RPC_HTTP_TRANSPORT_CREDENTIALS_V3;
typedef PRPC_HTTP_TRANSPORT_CREDENTIALS_V3_W    PRPC_HTTP_TRANSPORT_CREDENTIALS_V3;
#else
typedef RPC_HTTP_TRANSPORT_CREDENTIALS_V3_A     RPC_HTTP_TRANSPORT_CREDENTIALS_V3;
typedef PRPC_HTTP_TRANSPORT_CREDENTIALS_V3_A    PRPC_HTTP_TRANSPORT_CREDENTIALS_V3;
#endif
#endif

/* RPC security quality of service (QOS) (version 2) */
typedef struct _RPC_SECURITY_QOS_V2_A {
    unsigned long   Version;
    unsigned long   Capabilities;
    unsigned long   IdentityTracking;
    unsigned long   ImpersonationType;
    unsigned long   AdditionalSecurityInfoType;
    union {
        RPC_HTTP_TRANSPORT_CREDENTIALS_A    *HttpCredentials;
    } u;
} RPC_SECURITY_QOS_V2_A;
typedef RPC_SECURITY_QOS_V2_A   *PRPC_SECURITY_QOS_V2_A;
typedef struct _RPC_SECURITY_QOS_V2_W {
    unsigned long   Version;
    unsigned long   Capabilities;
    unsigned long   IdentityTracking;
    unsigned long   ImpersonationType;
    unsigned long   AdditionalSecurityInfoType;
    union {
        RPC_HTTP_TRANSPORT_CREDENTIALS_W    *HttpCredentials;
    } u;
} RPC_SECURITY_QOS_V2_W;
typedef RPC_SECURITY_QOS_V2_W   *PRPC_SECURITY_QOS_V2_W;
#ifdef UNICODE
typedef RPC_SECURITY_QOS_V2_W   RPC_SECURITY_QOS_V2;
typedef PRPC_SECURITY_QOS_V2_W  PRPC_SECURITY_QOS_V2;
#else
typedef RPC_SECURITY_QOS_V2_A   RPC_SECURITY_QOS_V2;
typedef PRPC_SECURITY_QOS_V2_A  PRPC_SECURITY_QOS_V2;
#endif

/* RPC security quality of service (QOS) (version 3) */
#if (NTDDI_VERSION >= 0x05020000)
typedef struct _RPC_SECURITY_QOS_V3_A {
    unsigned long   Version;
    unsigned long   Capabilities;
    unsigned long   IdentityTracking;
    unsigned long   ImpersonationType;
    unsigned long   AdditionalSecurityInfoType;
    union {
        RPC_HTTP_TRANSPORT_CREDENTIALS_A    *HttpCredentials;
    } u;
    void            *Sid;
} RPC_SECURITY_QOS_V3_A;
typedef RPC_SECURITY_QOS_V3_A   *PRPC_SECURITY_QOS_V3_A;
typedef struct _RPC_SECURITY_QOS_V3_W {
    unsigned long   Version;
    unsigned long   Capabilities;
    unsigned long   IdentityTracking;
    unsigned long   ImpersonationType;
    unsigned long   AdditionalSecurityInfoType;
    union {
        RPC_HTTP_TRANSPORT_CREDENTIALS_W    *HttpCredentials;
    } u;
    void            *Sid;
} RPC_SECURITY_QOS_V3_W;
typedef RPC_SECURITY_QOS_V3_W   *PRPC_SECURITY_QOS_V3_W;
#ifdef UNICODE
typedef RPC_SECURITY_QOS_V3_W   RPC_SECURITY_QOS_V3;
typedef PRPC_SECURITY_QOS_V3_W  PRPC_SECURITY_QOS_V3;
#else
typedef RPC_SECURITY_QOS_V3_W   RPC_SECURITY_QOS_V3;
typedef PRPC_SECURITY_QOS_V3_W  PRPC_SECURITY_QOS_V3;
#endif
#endif

/* RPC security quality of service (QOS) (version 4) */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _RPC_SECURITY_QOS_V4_A {
    unsigned long   Version;
    unsigned long   Capabilities;
    unsigned long   IdentityTracking;
    unsigned long   ImpersonationType;
    unsigned long   AdditionalSecurityInfoType;
    union {
        RPC_HTTP_TRANSPORT_CREDENTIALS_A    *HttpCredentials;
    } u;
    void            *Sid;
    unsigned int    EffectiveOnly;
} RPC_SECURITY_QOS_V4_A;
typedef RPC_SECURITY_QOS_V4_A   *PRPC_SECURITY_QOS_V4_A;
typedef struct _RPC_SECURITY_QOS_V4_W {
    unsigned long   Version;
    unsigned long   Capabilities;
    unsigned long   IdentityTracking;
    unsigned long   ImpersonationType;
    unsigned long   AdditionalSecurityInfoType;
    union {
        RPC_HTTP_TRANSPORT_CREDENTIALS_W    *HttpCredentials;
    } u;
    void            *Sid;
    unsigned int    EffectiveOnly;
} RPC_SECURITY_QOS_V4_W;
typedef RPC_SECURITY_QOS_V4_W   *PRPC_SECURITY_QOS_V4_W;
#ifdef UNICODE
typedef RPC_SECURITY_QOS_V4_W   RPC_SECURITY_QOS_V4;
typedef PRPC_SECURITY_QOS_V4_W  PRPC_SECURITY_QOS_V4;
#else
typedef RPC_SECURITY_QOS_V4_W   RPC_SECURITY_QOS_V4;
typedef PRPC_SECURITY_QOS_V4_W  PRPC_SECURITY_QOS_V4;
#endif
#endif

/* RPC binding handle template (version 1) */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _RPC_BINDING_HANDLE_TEMPLATE_V1_A {
    unsigned long   Version;
    unsigned long   Flags;
    unsigned long   ProtocolSequence;
    unsigned char   *NetworkAddress;
    unsigned char   *StringEndpoint;
    union {
        unsigned char   *Reserved;
    } u1;
    UUID            ObjectUuid;
} RPC_BINDING_HANDLE_TEMPLATE_V1_A;
typedef RPC_BINDING_HANDLE_TEMPLATE_V1_A    *PRPC_BINDING_HANDLE_TEMPLATE_V1_A;
typedef struct _RPC_BINDING_HANDLE_TEMPLATE_V1_W {
    unsigned long   Version;
    unsigned long   Flags;
    unsigned long   ProtocolSequence;
    unsigned short  *NetworkAddress;
    unsigned short  *StringEndpoint;
    union {
        unsigned short  *Reserved;
    } u1;
    UUID            ObjectUuid;
} RPC_BINDING_HANDLE_TEMPLATE_V1_W;
typedef RPC_BINDING_HANDLE_TEMPLATE_V1_W    *PRPC_BINDING_HANDLE_TEMPLATE_V1_W;
#ifdef UNICODE
typedef RPC_BINDING_HANDLE_TEMPLATE_V1_W    RPC_BINDING_HANDLE_TEMPLATE_V1;
typedef PRPC_BINDING_HANDLE_TEMPLATE_V1_W   PRPC_BINDING_HANDLE_TEMPLATE_V1;
#else
typedef RPC_BINDING_HANDLE_TEMPLATE_V1_A    RPC_BINDING_HANDLE_TEMPLATE_V1;
typedef PRPC_BINDING_HANDLE_TEMPLATE_V1_A   PRPC_BINDING_HANDLE_TEMPLATE_V1;
#endif
#endif

/* RPC binding handle security (version 1) */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _RPC_BINDING_HANDLE_SECURITY_V1_A {
    unsigned long               Version;
    unsigned char               *ServerPrincName;
    unsigned long               AuthnLevel;
    unsigned long               AuthnSvc;
    SEC_WINNT_AUTH_IDENTITY_A   *AuthIdentity;
    RPC_SECURITY_QOS            *SecurityQos;
} RPC_BINDING_HANDLE_SECURITY_V1_A;
typedef RPC_BINDING_HANDLE_SECURITY_V1_A    *PRPC_BINDING_HANDLE_SECURITY_V1_A;
typedef struct _RPC_BINDING_HANDLE_SECURITY_V1_W {
    unsigned long               Version;
    unsigned short              *ServerPrincName;
    unsigned long               AuthnLevel;
    unsigned long               AuthnSvc;
    SEC_WINNT_AUTH_IDENTITY_W   *AuthIdentity;
    RPC_SECURITY_QOS            *SecurityQos;
} RPC_BINDING_HANDLE_SECURITY_V1_W;
typedef RPC_BINDING_HANDLE_SECURITY_V1_W    *PRPC_BINDING_HANDLE_SECURITY_V1_W;
#ifdef UNICODE
typedef RPC_BINDING_HANDLE_SECURITY_V1_W    RPC_BINDING_HANDLE_SECURITY_V1;
typedef PRPC_BINDING_HANDLE_SECURITY_V1_W   PRPC_BINDING_HANDLE_SECURITY_V1;
#else
typedef RPC_BINDING_HANDLE_SECURITY_V1_A    RPC_BINDING_HANDLE_SECURITY_V1;
typedef PRPC_BINDING_HANDLE_SECURITY_V1_A   PRPC_BINDING_HANDLE_SECURITY_V1;
#endif
#endif

/* RPC binding handle options (version 1) */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _RPC_BINDING_HANDLE_OPTIONS_V1 {
    unsigned long   Version;
    unsigned long   Flags;
    unsigned long   ComTimeout;
    unsigned long   CallTimeout;
} RPC_BINDING_HANDLE_OPTIONS_V1;
typedef RPC_BINDING_HANDLE_OPTIONS_V1   *PRPC_BINDING_HANDLE_OPTIONS_V1;
#endif

/* RPC HTTP redirector stages */
#if (NTDDI_VERSION >= 0x05020000)
typedef enum _RPC_HTTP_REDIRECTOR_STAGE {
    RPCHTTP_RS_REDIRECT     = 1,
    RPCHTTP_RS_ACCESS_1     = 2,
    RPCHTTP_RS_SESSION      = 3,
    RPCHTTP_RS_ACCESS_2     = 4,
    RPCHTTP_RS_INTERFACE    = 5
} RPC_HTTP_REDIRECTOR_STAGE;
#endif

/* RPC HTTP callbacks */
#if (NTDDI_VERSION >= 0x05020000)
typedef RPC_STATUS (RPC_ENTRY *RPC_NEW_HTTP_PROXY_CHANNEL)( RPC_HTTP_REDIRECTOR_STAGE, RPC_WSTR, RPC_WSTR, RPC_WSTR, RPC_WSTR, void *, void *, void *, void *, unsigned long, RPC_WSTR *, RPC_WSTR * );
#else
typedef RPC_STATUS (RPC_ENTRY *RPC_NEW_HTTP_PROXY_CHANNEL)( unsigned short *, unsigned short *, unsigned char *, unsigned short ** );
#endif
#if (NTDDI_VERSION >= 0x05010000)
typedef void (RPC_ENTRY *RPC_HTTP_PROXY_FREE_STRING)( RPC_WSTR );
#endif

/* RPC authentication key retrieval callback function */
typedef void (RPC_ENTRY *RPC_AUTH_KEY_RETRIEVAL_FN)( void *, unsigned char *, unsigned long, void *, RPC_STATUS * );

/* RPC client information */
typedef struct {
    unsigned char   *UserName;
    unsigned char   *ComputerName;
    unsigned short  Privilege;
    unsigned long   AuthFlags;
} RPC_CLIENT_INFORMATION1;
typedef RPC_CLIENT_INFORMATION1 *PRPC_CLIENT_INFORMATION1;

/* RPC management authorization callback function */
typedef int (RPC_ENTRY *RPC_MGMT_AUTHORIZATION_FN)( RPC_BINDING_HANDLE, unsigned long, RPC_STATUS * );

/* Functions in RPCRT4.DLL */
RPCRTAPI RPC_STATUS RPC_ENTRY   DceErrorInqTextA( RPC_STATUS, RPC_CSTR );
RPCRTAPI RPC_STATUS RPC_ENTRY   DceErrorInqTextW( RPC_STATUS, RPC_WSTR );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcBindingCopy( RPC_BINDING_HANDLE, RPC_BINDING_HANDLE * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcBindingFree( RPC_BINDING_HANDLE * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcBindingFromStringBindingA( RPC_CSTR, RPC_BINDING_HANDLE * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcBindingFromStringBindingW( RPC_WSTR, RPC_BINDING_HANDLE * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcBindingInqAuthClientA( RPC_BINDING_HANDLE, RPC_AUTHZ_HANDLE *, RPC_CSTR *, unsigned long *, unsigned long *, unsigned long * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcBindingInqAuthClientExA( RPC_BINDING_HANDLE, RPC_AUTHZ_HANDLE *, RPC_CSTR *, unsigned long *, unsigned long *, unsigned long *, unsigned long );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcBindingInqAuthClientExW( RPC_BINDING_HANDLE, RPC_AUTHZ_HANDLE *, RPC_WSTR *, unsigned long *, unsigned long *, unsigned long *, unsigned long );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcBindingInqAuthClientW( RPC_BINDING_HANDLE, RPC_AUTHZ_HANDLE *, RPC_WSTR *, unsigned long *, unsigned long *, unsigned long * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcBindingInqAuthInfoA( RPC_BINDING_HANDLE, RPC_CSTR *, unsigned long *, unsigned long *, RPC_AUTH_IDENTITY_HANDLE *, unsigned long * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcBindingInqAuthInfoExA( RPC_BINDING_HANDLE, RPC_CSTR *, unsigned long *, unsigned long *, RPC_AUTH_IDENTITY_HANDLE *, unsigned long *, unsigned long, RPC_SECURITY_QOS * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcBindingInqAuthInfoExW( RPC_BINDING_HANDLE, RPC_WSTR *, unsigned long *, unsigned long *, RPC_AUTH_IDENTITY_HANDLE *, unsigned long *, unsigned long, RPC_SECURITY_QOS * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcBindingInqAuthInfoW( RPC_BINDING_HANDLE, RPC_WSTR *, unsigned long *, unsigned long *, RPC_AUTH_IDENTITY_HANDLE *, unsigned long * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcBindingInqObject( RPC_BINDING_HANDLE, UUID * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcBindingInqOption( RPC_BINDING_HANDLE, unsigned long, ULONG_PTR * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcBindingReset( RPC_BINDING_HANDLE );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcBindingServerFromClient( RPC_BINDING_HANDLE, RPC_BINDING_HANDLE * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcBindingSetAuthInfoA( RPC_BINDING_HANDLE, RPC_CSTR, unsigned long, unsigned long, RPC_AUTH_IDENTITY_HANDLE, unsigned long );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcBindingSetAuthInfoExA( RPC_BINDING_HANDLE, RPC_CSTR, unsigned long, unsigned long, RPC_AUTH_IDENTITY_HANDLE, unsigned long, RPC_SECURITY_QOS * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcBindingSetAuthInfoExW( RPC_BINDING_HANDLE, RPC_WSTR, unsigned long, unsigned long, RPC_AUTH_IDENTITY_HANDLE, unsigned long, RPC_SECURITY_QOS * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcBindingSetAuthInfoW( RPC_BINDING_HANDLE, RPC_WSTR, unsigned long, unsigned long, RPC_AUTH_IDENTITY_HANDLE, unsigned long );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcBindingSetObject( RPC_BINDING_HANDLE, UUID * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcBindingSetOption( RPC_BINDING_HANDLE, unsigned long,  ULONG_PTR );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcBindingToStringBindingA( RPC_BINDING_HANDLE, RPC_CSTR * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcBindingToStringBindingW( RPC_BINDING_HANDLE, RPC_WSTR * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcBindingVectorFree( RPC_BINDING_VECTOR ** );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcCancelThread( void * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcCancelThreadEx( void *, long );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcEpRegisterA( RPC_IF_HANDLE, RPC_BINDING_VECTOR *, UUID_VECTOR *, RPC_CSTR );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcEpRegisterNoReplaceA( RPC_IF_HANDLE, RPC_BINDING_VECTOR *, UUID_VECTOR *, RPC_CSTR );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcEpRegisterNoReplaceW( RPC_IF_HANDLE, RPC_BINDING_VECTOR *, UUID_VECTOR *, RPC_WSTR );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcEpRegisterW( RPC_IF_HANDLE, RPC_BINDING_VECTOR *, UUID_VECTOR *, RPC_WSTR );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcEpResolveBinding( RPC_BINDING_HANDLE, RPC_IF_HANDLE );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcEpUnregister( RPC_IF_HANDLE, RPC_BINDING_VECTOR *, UUID_VECTOR * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcIfIdVectorFree( RPC_IF_ID_VECTOR ** );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcIfInqId( RPC_IF_HANDLE, RPC_IF_ID * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcImpersonateClient( RPC_BINDING_HANDLE );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcMgmtEnableIdleCleanup( void );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcMgmtEpEltInqBegin( RPC_BINDING_HANDLE, unsigned long, RPC_IF_ID *, unsigned long, UUID *, RPC_EP_INQ_HANDLE * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcMgmtEpEltInqDone( RPC_EP_INQ_HANDLE * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcMgmtEpEltInqNextA( RPC_EP_INQ_HANDLE, RPC_IF_ID *, RPC_BINDING_HANDLE *, UUID *, RPC_CSTR * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcMgmtEpEltInqNextW( RPC_EP_INQ_HANDLE, RPC_IF_ID *, RPC_BINDING_HANDLE *, UUID *, RPC_WSTR * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcMgmtEpUnregister( RPC_BINDING_HANDLE, RPC_IF_ID *, RPC_BINDING_HANDLE, UUID * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcMgmtInqComTimeout( RPC_BINDING_HANDLE, unsigned int * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcMgmtInqDefaultProtectLevel( unsigned long, unsigned long * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcMgmtInqIfIds( RPC_BINDING_HANDLE, RPC_IF_ID_VECTOR ** );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcMgmtInqServerPrincNameA( RPC_BINDING_HANDLE, unsigned long, RPC_CSTR * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcMgmtInqServerPrincNameW( RPC_BINDING_HANDLE, unsigned long, RPC_WSTR * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcMgmtInqStats( RPC_BINDING_HANDLE, RPC_STATS_VECTOR ** );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcMgmtIsServerListening( RPC_BINDING_HANDLE );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcMgmtSetAuthorizationFn( RPC_MGMT_AUTHORIZATION_FN );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcMgmtSetCancelTimeout( long );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcMgmtSetComTimeout( RPC_BINDING_HANDLE, unsigned int );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcMgmtSetServerStackSize( unsigned long );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcMgmtStatsVectorFree( RPC_STATS_VECTOR ** );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcMgmtStopServerListening( RPC_BINDING_HANDLE );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcMgmtWaitServerListen( void );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcNetworkInqProtseqsA( RPC_PROTSEQ_VECTORA ** );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcNetworkInqProtseqsW( RPC_PROTSEQ_VECTORW ** );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcNetworkIsProtseqValidA( RPC_CSTR );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcNetworkIsProtseqValidW( RPC_WSTR );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcNsBindingInqEntryNameA( RPC_BINDING_HANDLE, unsigned long, RPC_CSTR * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcNsBindingInqEntryNameW( RPC_BINDING_HANDLE, unsigned long, RPC_WSTR * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcObjectInqType( UUID *, UUID * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcObjectSetInqFn( RPC_OBJECT_INQ_FN * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcObjectSetType( UUID *, UUID * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcProtseqVectorFreeA( RPC_PROTSEQ_VECTORA ** );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcProtseqVectorFreeW( RPC_PROTSEQ_VECTORW ** );
RPCRTAPI DECLSPEC_NORETURN void RPC_ENTRY   RpcRaiseException( RPC_STATUS );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcRevertToSelf( void );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcRevertToSelfEx( RPC_BINDING_HANDLE );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcServerCompleteSecurityCallback( RPC_BINDING_HANDLE, RPC_STATUS );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcServerInqBindings( RPC_BINDING_VECTOR ** );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcServerInqDefaultPrincNameA( unsigned long, RPC_CSTR * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcServerInqDefaultPrincNameW( unsigned long, RPC_WSTR * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcServerInqIf( RPC_IF_HANDLE, UUID *, RPC_MGR_EPV ** );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcServerListen( unsigned int, unsigned int, unsigned int );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcServerRegisterAuthInfoA( RPC_CSTR, unsigned long, RPC_AUTH_KEY_RETRIEVAL_FN, void * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcServerRegisterAuthInfoW( RPC_WSTR, unsigned long, RPC_AUTH_KEY_RETRIEVAL_FN, void * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcServerRegisterIf( RPC_IF_HANDLE, UUID *, RPC_MGR_EPV * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcServerRegisterIf2( RPC_IF_HANDLE, UUID *, RPC_MGR_EPV *, unsigned int, unsigned int, unsigned int, RPC_IF_CALLBACK_FN * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcServerRegisterIfEx( RPC_IF_HANDLE, UUID *, RPC_MGR_EPV *, unsigned int, unsigned int, RPC_IF_CALLBACK_FN * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcServerTestCancel( RPC_BINDING_HANDLE );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcServerUnregisterIf( RPC_IF_HANDLE, UUID *, unsigned int );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcServerUseAllProtseqs( unsigned int, void * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcServerUseAllProtseqsEx( unsigned int, void *, PRPC_POLICY );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcServerUseAllProtseqsIf( unsigned int, RPC_IF_HANDLE, void * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcServerUseAllProtseqsIfEx( unsigned int, RPC_IF_HANDLE, void *, PRPC_POLICY );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcServerUseProtseqA( RPC_CSTR, unsigned int, void * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcServerUseProtseqEpA( RPC_CSTR, unsigned int, RPC_CSTR, void * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcServerUseProtseqEpExA( RPC_CSTR, unsigned int, RPC_CSTR, void *, PRPC_POLICY );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcServerUseProtseqEpExW( RPC_WSTR, unsigned int, RPC_WSTR, void *, PRPC_POLICY );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcServerUseProtseqEpW( RPC_WSTR, unsigned int, RPC_WSTR, void * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcServerUseProtseqExA( RPC_CSTR, unsigned int, void *, PRPC_POLICY );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcServerUseProtseqExW( RPC_WSTR, unsigned int, void *, PRPC_POLICY );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcServerUseProtseqIfA( RPC_CSTR, unsigned int, RPC_IF_HANDLE, void * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcServerUseProtseqIfExA( RPC_CSTR, unsigned int, RPC_IF_HANDLE, void *, PRPC_POLICY );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcServerUseProtseqIfExW( RPC_WSTR, unsigned int, RPC_IF_HANDLE, void *, PRPC_POLICY );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcServerUseProtseqIfW( RPC_WSTR, unsigned int, RPC_IF_HANDLE, void * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcServerUseProtseqW( RPC_WSTR, unsigned int, void * );
RPCRTAPI void RPC_ENTRY         RpcServerYield( void );
RPCRTAPI void RPC_ENTRY         RpcSsDontSerializeContext( void );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcSsGetContextBinding( void *, RPC_BINDING_HANDLE * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcStringBindingComposeA( RPC_CSTR, RPC_CSTR, RPC_CSTR, RPC_CSTR, RPC_CSTR, RPC_CSTR * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcStringBindingComposeW( RPC_WSTR, RPC_WSTR, RPC_WSTR, RPC_WSTR, RPC_WSTR, RPC_WSTR * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcStringBindingParseA( RPC_CSTR, RPC_CSTR *, RPC_CSTR *, RPC_CSTR *, RPC_CSTR *, RPC_CSTR * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcStringBindingParseW( RPC_WSTR, RPC_WSTR *, RPC_WSTR *, RPC_WSTR *, RPC_WSTR *, RPC_WSTR * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcStringFreeA( RPC_CSTR * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcStringFreeW( RPC_WSTR * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcTestCancel( void );
RPCRTAPI signed int RPC_ENTRY   UuidCompare( UUID *, UUID *, RPC_STATUS * );
RPCRTAPI RPC_STATUS RPC_ENTRY   UuidCreate( UUID * );
RPCRTAPI RPC_STATUS RPC_ENTRY   UuidCreateNil( UUID * );
RPCRTAPI RPC_STATUS RPC_ENTRY   UuidCreateSequential( UUID * );
RPCRTAPI int RPC_ENTRY          UuidEqual( UUID *, UUID *, RPC_STATUS * );
RPCRTAPI RPC_STATUS RPC_ENTRY   UuidFromStringA( RPC_CSTR, UUID * );
RPCRTAPI RPC_STATUS RPC_ENTRY   UuidFromStringW( RPC_WSTR, UUID * );
RPCRTAPI unsigned short RPC_ENTRY   UuidHash( UUID *, RPC_STATUS * );
RPCRTAPI int RPC_ENTRY          UuidIsNil( UUID *, RPC_STATUS * );
RPCRTAPI RPC_STATUS RPC_ENTRY   UuidToStringA( UUID *, RPC_CSTR * );
RPCRTAPI RPC_STATUS RPC_ENTRY   UuidToStringW( UUID *, RPC_WSTR * );
#if (NTDDI_VERSION >= 0x05010000)
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcServerUnregisterIfEx( RPC_IF_HANDLE, UUID *, int );
#endif
#if (NTDDI_VERSION >= 0x06000000)
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcBindingCreateA( RPC_BINDING_HANDLE_TEMPLATE_V1_A *, RPC_BINDING_HANDLE_SECURITY_V1_A *, RPC_BINDING_HANDLE_OPTIONS_V1 *, RPC_BINDING_HANDLE * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcBindingCreateW( RPC_BINDING_HANDLE_TEMPLATE_V1_W *, RPC_BINDING_HANDLE_SECURITY_V1_W *, RPC_BINDING_HANDLE_OPTIONS_V1 *, RPC_BINDING_HANDLE * );
RPCRTAPI int RPC_ENTRY          RpcExceptionFilter( unsigned long );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcServerInqBindingHandle( RPC_BINDING_HANDLE * );
#endif

/* Map generic function names to the appropriate ANSI or Unicode version. */
#ifdef UNICODE
    #define DceErrorInqText                 DceErrorInqTextW
    #define RpcBindingCreate                RpcBindingCreateW
    #define RpcBindingFromStringBinding     RpcBindingFromStringBindingW
    #define RpcBindingInqAuthClient         RpcBindingInqAuthClientW
    #define RpcBindingInqAuthClientEx       RpcBindingInqAuthClientExW
    #define RpcBindingInqAuthInfo           RpcBindingInqAuthInfoW
    #define RpcBindingInqAuthInfoEx         RpcBindingInqAuthInfoExW
    #define RpcBindingSetAuthInfo           RpcBindingSetAuthInfoW
    #define RpcBindingSetAuthInfoEx         RpcBindingSetAuthInfoExW
    #define RpcBindingToStringBinding       RpcBindingToStringBindingW
    #define RpcEpRegister                   RpcEpRegisterW
    #define RpcEpRegisterNoReplace          RpcEpRegisterNoReplaceW
    #define RpcMgmtEpEltInqNext             RpcMgmtEpEltInqNextW
    #define RpcMgmtInqServerPrincName       RpcMgmtInqServerPrincNameW
    #define RpcNetworkInqProtseqs           RpcNetworkInqProtseqsW
    #define RpcNetworkIsProtseqValid        RpcNetworkIsProtseqValidW
    #define RpcNsBindingInqEntryName        RpcNsBindingInqEntryNameW
    #define RpcProtseqVectorFree            RpcProtseqVectorFreeW
    #define RpcServerInqDefaultPrincName    RpcServerInqDefaultPrincNameW
    #define RpcServerRegisterAuthInfo       RpcServerRegisterAuthInfoW
    #define RpcServerUseProtseq             RpcServerUseProtseqW
    #define RpcServerUseProtseqEp           RpcServerUseProtseqEpW
    #define RpcServerUseProtseqEpEx         RpcServerUseProtseqEpExW
    #define RpcServerUseProtseqEx           RpcServerUseProtseqExW
    #define RpcServerUseProtseqIf           RpcServerUseProtseqIfA
    #define RpcServerUseProtseqIfEx         RpcServerUseProtseqIfExA
    #define RpcStringBindingCompose         RpcStringBindingComposeW
    #define RpcStringBindingParse           RpcStringBindingParseW
    #define RpcStringFree                   RpcStringFreeW
    #define UuidFromString                  UuidFromStringW
    #define UuidToString                    UuidToStringW
#else
    #define DceErrorInqText                 DceErrorInqTextA
    #define RpcBindingCreate                RpcBindingCreateA
    #define RpcBindingFromStringBinding     RpcBindingFromStringBindingA
    #define RpcBindingInqAuthClient         RpcBindingInqAuthClientA
    #define RpcBindingInqAuthClientEx       RpcBindingInqAuthClientExA
    #define RpcBindingInqAuthInfo           RpcBindingInqAuthInfoA
    #define RpcBindingInqAuthInfoEx         RpcBindingInqAuthInfoExA
    #define RpcBindingSetAuthInfo           RpcBindingSetAuthInfoA
    #define RpcBindingSetAuthInfoEx         RpcBindingSetAuthInfoExA
    #define RpcBindingToStringBinding       RpcBindingToStringBindingA
    #define RpcEpRegister                   RpcEpRegisterA
    #define RpcEpRegisterNoReplace          RpcEpRegisterNoReplaceA
    #define RpcMgmtEpEltInqNext             RpcMgmtEpEltInqNextA
    #define RpcMgmtInqServerPrincName       RpcMgmtInqServerPrincNameA
    #define RpcNetworkInqProtseqs           RpcNetworkInqProtseqsA
    #define RpcNetworkIsProtseqValid        RpcNetworkIsProtseqValidA
    #define RpcNsBindingInqEntryName        RpcNsBindingInqEntryNameA
    #define RpcProtseqVectorFree            RpcProtseqVectorFreeA
    #define RpcServerInqDefaultPrincName    RpcServerInqDefaultPrincNameA
    #define RpcServerRegisterAuthInfo       RpcServerRegisterAuthInfoA
    #define RpcServerUseProtseq             RpcServerUseProtseqA
    #define RpcServerUseProtseqEp           RpcServerUseProtseqEpA
    #define RpcServerUseProtseqEpEx         RpcServerUseProtseqEpExA
    #define RpcServerUseProtseqEx           RpcServerUseProtseqExA
    #define RpcServerUseProtseqIf           RpcServerUseProtseqIfA
    #define RpcServerUseProtseqIfEx         RpcServerUseProtseqIfExA
    #define RpcStringBindingCompose         RpcStringBindingComposeA
    #define RpcStringBindingParse           RpcStringBindingParseA
    #define RpcStringFree                   RpcStringFreeA
    #define UuidFromString                  UuidFromStringA
    #define UuidToString                    UuidToStringA
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#include <rpcdcep.h>

#endif /* __RPCDCE_H__ */
