/*
 *  secext.h    Security extension functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2010 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef __SECEXT_H__
#define __SECEXT_H__

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Extended name formats */
typedef enum {
    NameUnknown             = 0,
    NameFullyQualifiedDN    = 1,
    NameSamCompatible       = 2,
    NameDisplay             = 3,
    NameUniqueId            = 6,
    NameCanonical           = 7,
    NameUserPrincipal       = 8,
    NameCanonicalEx         = 9,
    NameServicePrincipal    = 10,
    NameDnsDomain           = 12,
} EXTENDED_NAME_FORMAT;
typedef EXTENDED_NAME_FORMAT    *PEXTENDED_NAME_FORMAT;

/* Functions in SECUR32.DLL */
BOOLEAN SEC_ENTRY   GetComputerObjectNameA( EXTENDED_NAME_FORMAT, LPSTR, PULONG );
BOOLEAN SEC_ENTRY   GetComputerObjectNameW( EXTENDED_NAME_FORMAT, LPWSTR, PULONG );
BOOLEAN SEC_ENTRY   GetUserNameExA( EXTENDED_NAME_FORMAT, LPSTR, PULONG );
BOOLEAN SEC_ENTRY   GetUserNameExW( EXTENDED_NAME_FORMAT, LPWSTR, PULONG );
BOOLEAN SEC_ENTRY   TranslateNameA( LPCSTR, EXTENDED_NAME_FORMAT, EXTENDED_NAME_FORMAT, LPSTR, PULONG );
BOOLEAN SEC_ENTRY   TranslateNameW( LPCWSTR, EXTENDED_NAME_FORMAT, EXTENDED_NAME_FORMAT, LPWSTR, PULONG );

/* Map generic function names to the appropriate ANSI or Unicode version. */
#ifdef UNICODE
    #define GetComputerObjectName   GetComputerObjectNameW
    #define GetUserNameEx           GetUserNameExW
    #define TranslateName           TranslateNameW
#else
    #define GetComputerObjectName   GetComputerObjectNameA
    #define GetUserNameEx           GetUserNameExA
    #define TranslateName           TranslateNameA
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __SECEXT_H__ */
