' Copyright (c) 2005, Mateusz Viste
' All rights reserved.
'
' Redistribution and use in source and binary forms, with or without
' modification, are permitted provided that the following conditions are met:
'
' 1. Redistributions of source code must retain the above copyright notice, this
'    list of conditions and the following disclaimer.
' 2. Redistributions in binary form must reproduce the above copyright notice,
'    this list of conditions and the following disclaimer in the documentation
'    and/or other materials provided with the distribution.
'
' THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
' ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
' WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
' DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
' ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
' (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
' LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
' ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
' (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
' SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'

DECLARE FUNCTION PrintNum$ (num AS INTEGER, n AS INTEGER)
DECLARE SUB AutoHandler ()
DECLARE SUB ReadStates ()
DECLARE SUB HelpScreen ()
DECLARE SUB CheckCFGfile ()
DECLARE SUB Quit (pVer$, pDate$, Mode%)
DECLARE SUB RefreshScreen (Choice%, ChoiceY%, Mode%)
DECLARE SUB KeybHandler (Choice%, ChoiceY%, LastKey$, Mode%)
DECLARE SUB InitScreen (pVer$, pDate$, Mode%)
DECLARE SUB iBeep ()

CLEAR

TYPE EventsCFG
 Day     AS INTEGER
 Month   AS INTEGER
 Year    AS INTEGER
 Hour    AS INTEGER
 Minute  AS INTEGER
 Second  AS INTEGER
 Port    AS INTEGER
 D       AS INTEGER
 State   AS INTEGER
END TYPE

COLOR 7, 0
CLS

pVer$ = "0.7"
pDate$ = "2005"

DIM SHARED Port3BC(0 TO 7) AS INTEGER
DIM SHARED Port378(0 TO 7) AS INTEGER
DIM SHARED Port278(0 TO 7) AS INTEGER
DIM SHARED Months(-1 TO 12) AS STRING * 3
DIM SHARED Events(1 TO 30) AS EventsCFG
DIM SHARED Ports(1 TO 3) AS STRING * 5
DIM SHARED HiLo(0 TO 1) AS STRING * 2

Ports(1) = "0x3BC": Ports(2) = "0x378": Ports(3) = "0x278"
HiLo(0) = "LO": HiLo(1) = "HI"

Months(-1) = "***": Months(1) = "Jan": Months(2) = "Feb": Months(3) = "Mar": Months(4) = "Apr"
Months(5) = "May": Months(6) = "Jun": Months(7) = "Jul": Months(8) = "Aug"
Months(9) = "Sep": Months(10) = "Oct": Months(11) = "Nov": Months(12) = "Dec"

IF LCASE$(COMMAND$) = "/auto" THEN Mode% = 1
IF LEN(COMMAND$) = 0 THEN Mode% = 2
IF Mode% = 0 THEN CALL HelpScreen

IF Mode% = 1 THEN CALL CheckCFGfile
CALL ReadStates
CALL InitScreen(pVer$, pDate$, Mode%)

IF Mode% = 2 THEN Choice% = 0: ChoiceY% = 1 ELSE Choice% = 1: ChoiceY% = -1

DO: LastKey$ = INKEY$

CALL KeybHandler(Choice%, ChoiceY%, LastKey$, Mode%)
IF Mode% = 1 THEN CALL AutoHandler
CALL RefreshScreen(Choice%, ChoiceY%, Mode%)

  OUT &H3BC, Port3BC(7) * 128 + Port3BC(6) * 64 + Port3BC(5) * 32 + Port3BC(4) * 16 + Port3BC(3) * 8 + Port3BC(2) * 4 + Port3BC(1) * 2 + Port3BC(0) * 1
  OUT &H378, Port378(7) * 128 + Port378(6) * 64 + Port378(5) * 32 + Port378(4) * 16 + Port378(3) * 8 + Port378(2) * 4 + Port378(1) * 2 + Port378(0) * 1
  OUT &H278, Port278(7) * 128 + Port278(6) * 64 + Port278(5) * 32 + Port278(4) * 16 + Port278(3) * 8 + Port278(2) * 4 + Port278(1) * 2 + Port278(0) * 1

LOOP UNTIL LastKey$ = CHR$(27)

CALL Quit(pVer$, pDate$, Mode%)

SUB AutoHandler

Day = VAL(MID$(DATE$, 4, 2))
Month = VAL(MID$(DATE$, 1, 2))
Year = VAL(MID$(DATE$, 7, 4))
Hour = VAL(MID$(TIME$, 1, 2))
Minute = VAL(MID$(TIME$, 4, 2))
Second = VAL(MID$(TIME$, 7, 2))

FOR x% = 1 TO 30

IF Events(x%).Day <> -1 THEN nDay = Day - Events(x%).Day - 1 ELSE nDay = -1
IF Events(x%).Month <> -1 THEN nMonth = Month - Events(x%).Month - 1 ELSE nMonth = -1
IF Events(x%).Year <> -1 THEN nYear = Year - Events(x%).Year - 1 ELSE nYear = -1
IF Events(x%).Hour <> -1 THEN nHour = Hour - Events(x%).Hour - 1 ELSE nHour = -1
IF Events(x%).Minute <> -1 THEN nMinute = Minute - Events(x%).Minute - 1 ELSE nMinute = -1
IF Events(x%).Second <> -1 THEN nSecond = Second - Events(x%).Second - 1 ELSE nSecond = -1

IF nDay = -1 AND nMonth = -1 AND nYear = -1 AND nHour = -1 AND nMinute = -1 AND nSecond = -1 THEN
  IF Events(x%).Port = 1 THEN Port3BC(Events(x%).D) = Events(x%).State
  IF Events(x%).Port = 2 THEN Port378(Events(x%).D) = Events(x%).State
  IF Events(x%).Port = 3 THEN Port278(Events(x%).D) = Events(x%).State
 END IF
NEXT x%

END SUB

SUB CheckCFGfile
IF DIR$("LPTDRV.CFG") = "" THEN
  OPEN "LPTDRV.CFG" FOR OUTPUT AS #1
  PRINT #1,
  PRINT #1,
  PRINT #1,
  PRINT #1,
  PRINT #1,
  PRINT #1,
  PRINT #1,
  PRINT #1,
  PRINT #1,
  PRINT #1,
  PRINT #1,
  PRINT #1,
  FOR x% = 1 TO 30
  PRINT #1, 0, 0, 0, 0, 0, 0, 0, 0, 0
  NEXT x%
  CLOSE #1
 END IF

OPEN "LPTDRV.CFG" FOR INPUT AS #1
FOR x% = 1 TO 12
  LINE INPUT #1, Line$
NEXT x%
FOR x% = 1 TO 30
  INPUT #1, Events(x%).Day
  INPUT #1, Events(x%).Month
  INPUT #1, Events(x%).Year
  INPUT #1, Events(x%).Hour
  INPUT #1, Events(x%).Minute
  INPUT #1, Events(x%).Second
  INPUT #1, Events(x%).Port
  INPUT #1, Events(x%).D
  INPUT #1, Events(x%).State
NEXT x%
CLOSE #1

END SUB

SUB HelpScreen
PRINT
PRINT "Help"
PRINT
PRINT "/Auto - Automatic mode"
PRINT
SYSTEM
END SUB

DEFINT A-Z
SUB iBeep
SOUND 700, 2
END SUB

DEFSNG A-Z
SUB InitScreen (pVer$, pDate$, Mode%)
COLOR 15, 1
LOCATE 1, 1: PRINT "             LPT Driver v"; pVer$; " Copyright (C) Mateusz Viste "; pDate$; "                   ";

COLOR 2, 0
LOCATE 2, 27: PRINT "             Ŀ";
LOCATE 3, 27: PRINT "              D0  D1  D2  D3  D4  D5  D6  D7 ";
LOCATE 4, 27: PRINT "Ĵ";
LOCATE 5, 27: PRINT " Port 0x3BC                                 ";
LOCATE 6, 27: PRINT " Port 0x378                                 ";
LOCATE 7, 27: PRINT " Port 0x278                                 ";
LOCATE 8, 27: PRINT "";

IF Mode% = 1 THEN
    COLOR 13, 0: LOCATE 6, 4: PRINT "* AUTOMATIC MODE *";
    COLOR 2, 0
    LOCATE 9, 3: PRINT "-[ Programmed events ]Ŀ";
    LOCATE 10, 3: PRINT "                                                                          ";
    LOCATE 11, 3: PRINT "                                                                          ";
    LOCATE 12, 3: PRINT "                                                                          ";
    LOCATE 13, 3: PRINT "                                                                          ";
    LOCATE 14, 3: PRINT "                                                                          ";
    LOCATE 15, 3: PRINT "                                                                          ";
    LOCATE 16, 3: PRINT "                                                                          ";
    LOCATE 17, 3: PRINT "                                                                          ";
    LOCATE 18, 3: PRINT "                                                                          ";
    LOCATE 19, 3: PRINT "                                                                          ";
    LOCATE 20, 3: PRINT "                                                                          ";
    LOCATE 21, 3: PRINT "                                                                          ";
    LOCATE 22, 3: PRINT "                                                                          ";
    LOCATE 23, 3: PRINT "                                                                          ";
    LOCATE 24, 3: PRINT "                                                                          ";
    LOCATE 25, 3: PRINT "";
 END IF

COLOR 7, 0
END SUB

SUB KeybHandler (Choice%, ChoiceY%, LastKey$, Mode%)

IF Mode% = 2 THEN
  IF LastKey$ = CHR$(0) + "H" THEN ChoiceY% = ChoiceY% - 1
  IF LastKey$ = CHR$(0) + "P" THEN ChoiceY% = ChoiceY% + 1
  IF LastKey$ = CHR$(0) + "K" THEN Choice% = Choice% - 1
  IF LastKey$ = CHR$(0) + "M" THEN Choice% = Choice% + 1
  IF LastKey$ = CHR$(13) THEN
   IF ChoiceY% = 1 THEN IF Port3BC(Choice%) = 1 THEN Port3BC(Choice%) = 0 ELSE Port3BC(Choice%) = 1
   IF ChoiceY% = 2 THEN IF Port378(Choice%) = 1 THEN Port378(Choice%) = 0 ELSE Port378(Choice%) = 1
   IF ChoiceY% = 3 THEN IF Port278(Choice%) = 1 THEN Port278(Choice%) = 0 ELSE Port278(Choice%) = 1
  END IF

  IF ChoiceY% = 0 THEN ChoiceY% = 1: CALL iBeep
  IF ChoiceY% = 4 THEN ChoiceY% = 3: CALL iBeep
  IF Choice% = -1 THEN Choice% = 0: CALL iBeep
  IF Choice% = 8 THEN Choice% = 7: CALL iBeep
 ELSE

  IF LastKey$ = CHR$(0) + "H" THEN Choice% = Choice% - 1
  IF LastKey$ = CHR$(0) + "P" THEN Choice% = Choice% + 1
  IF Choice% = 0 THEN Choice% = 1: CALL iBeep
  IF Choice% = 31 THEN Choice% = 30: CALL iBeep
END IF

END SUB

FUNCTION PrintNum$ (num AS INTEGER, n AS INTEGER)

IF num = -1 THEN PrintNum$ = RIGHT$("********", n) ELSE PrintNum$ = RIGHT$("00000000" + LTRIM$(STR$(num)), n)

END FUNCTION

SUB Quit (pVer$, pDate$, Mode%)
IF Mode% = 1 THEN
  OUT &H3BC, 0
  OUT &H378, 0
  OUT &H278, 0
 END IF
COLOR 7, 0
CLS
PRINT "LPT Driver v"; pVer$; " (C) Copyright Mateusz Viste "; pDate$
PRINT
SYSTEM

END SUB

SUB ReadStates

numb = INP(&H3BC)
dzielnik = 524288
wynik$ = ""
DO
n = numb \ dzielnik MOD 2
dzielnik = dzielnik / 2
x = x + n
IF NOT x = 0 THEN wynik$ = wynik$ + LTRIM$(STR$(n))
LOOP UNTIL dzielnik = .5
IF x = 0 THEN wynik$ = "0"
wynik$ = RIGHT$("0000000" + wynik$, 8)
FOR x% = 0 TO 7
  Port3BC(x%) = VAL(MID$(wynik$, 8 - x%, 1))
 NEXT x%


numb = INP(&H378)
dzielnik = 524288
wynik$ = ""
DO
n = numb \ dzielnik MOD 2
dzielnik = dzielnik / 2
x = x + n
IF NOT x = 0 THEN wynik$ = wynik$ + LTRIM$(STR$(n))
LOOP UNTIL dzielnik = .5
IF x = 0 THEN wynik$ = "0"
wynik$ = RIGHT$("0000000" + wynik$, 8)
FOR x% = 0 TO 7
  Port378(x%) = VAL(MID$(wynik$, 8 - x%, 1))
 NEXT x%


numb = INP(&H278)
dzielnik = 524288
wynik$ = ""
DO
n = numb \ dzielnik MOD 2
dzielnik = dzielnik / 2
x = x + n
IF NOT x = 0 THEN wynik$ = wynik$ + LTRIM$(STR$(n))
LOOP UNTIL dzielnik = .5
IF x = 0 THEN wynik$ = "0"
wynik$ = RIGHT$("0000000" + wynik$, 8)
FOR x% = 0 TO 7
  Port278(x%) = VAL(MID$(wynik$, 8 - x%, 1))
 NEXT x%

END SUB

SUB RefreshScreen (Choice%, ChoiceY%, Mode%)
FOR x% = 0 TO 7
LOCATE 5, 41 + x% * 5
IF Choice% = x% AND ChoiceY% = 1 THEN COLOR 0, 2
PRINT " "; HiLo(Port3BC(x%)); " ";
COLOR 7, 0

LOCATE 6, 41 + x% * 5
IF Choice% = x% AND ChoiceY% = 2 THEN COLOR 0, 2
PRINT " "; HiLo(Port378(x%)); " ";
COLOR 7, 0

LOCATE 7, 41 + x% * 5
IF Choice% = x% AND ChoiceY% = 3 THEN COLOR 0, 2
PRINT " "; HiLo(Port278(x%)); " ";
COLOR 7, 0
NEXT x%

IF Mode% = 1 THEN
  FOR x% = 1 TO 30
    IF x% = Choice% THEN COLOR 0, 2 ELSE COLOR 7, 0
    IF x% <= 15 THEN LOCATE 9 + x%, 4 ELSE LOCATE x% - 6, 42
    IF Events(x%).Port > 0 THEN
      PRINT " "; PrintNum$(Events(x%).Day, 2); " "; Months(Events(x%).Month); " ";
      PRINT PrintNum$(Events(x%).Year, 4); ", "; PrintNum$(Events(x%).Hour, 2); ":"; PrintNum$(Events(x%).Minute, 2); ":";
      PRINT PrintNum$(Events(x%).Second, 2); " - "; Ports(Events(x%).Port); " D"; LTRIM$(STR$(Events(x%).D)); " "; HiLo(Events(x%).State); " ";
     ELSE
      PRINT " .. ... ...., ..:..:.. - ..... .. .. ";
    END IF
  NEXT x%
 END IF

COLOR 3, 0
LOCATE 3, 1: PRINT " Date: "; MID$(DATE$, 4, 2); " "; Months(VAL(MID$(DATE$, 1, 2))); " "; MID$(DATE$, 7, 4);
LOCATE 4, 1: PRINT " Time: "; TIME$;
COLOR 7, 0

END SUB

