/*
 * This file is part of the zBoy project.
 * Copyright (C) Mateusz Viste 2010-2019
 *
 * Generates the about.c file, on the basis of zboy.txt.
 */

#include <stdio.h>

int main(void) {
  FILE *fd, *fdout;
  int c, i;

  /* open files */
  fd = fopen("zboy.txt", "rb");
  if (fd == NULL) {
    fprintf(stderr, "ERROR: fopen() failure!\n");
    return(1);
  }
  fdout = fopen("about.c", "wb");
  if (fdout == NULL) {
    fprintf(stderr, "ERROR: fopen() failure!\n");
    fclose(fd);
    return(1);
  }

  /* generate content */
  fprintf(fdout, "/* THIS FILE IS AUTO-GENERATED, DO NOT MODIFY!\n"
                 " * (generated by aboutgen.c) */\n"
                 "\n"
                 "#include <stdio.h>\n"
                 "#include <unistd.h>\n"
                 "\n"
                 "void printhelp(void) {\n"
                 "  const char about[] = {");
  for (i = 0;; i++) {
    c = fgetc(fd);
    if (c == EOF) break;
    if (i > 0) fprintf(fdout, ",");
    if ((i & 15) == 0) fprintf(fdout, "\n    ");
    fprintf(fdout, "0x%02x", c);
  }
  fprintf(fdout, "};\n"
                 "  write(STDOUT_FILENO, about, sizeof(about));\n"
                 "}\n"
                 "\n"
  );

  /* close descriptors and quit */
  fclose(fd);
  fclose(fdout);
  return(0);
}
