/* NetCat, derived from module nc.c BusyBox[http://www.busybox.net]
 * Hacked to work for 16 bit DOS(Waterloo TCP) by, kpk of DOS Solutions.
 * www.dossolutions.pwp.blueyonder.co.uk/wattcp.htm
 *
 * Almost completely re-written
 * in 07/2008 by Jrgen Hoffmann
 * j_hoff@hrz1.hrz.tu-darmstadt.de
 */

 /* Waterloo TCP */
#include <tcp.h>
/* Borland Clib */
#include <conio.h>
#include <ctype.h>
#include <dos.h>
#include <errno.h>
#include <fcntl.h>
#include <io.h>
#include <process.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <time.h>
#include <conio.h>
/* kpk */
#include "getopt.h"

#define BUFSIZE 2048

#define STDIN  0
#define STDOUT 1
#define STDERR 2

tcp_Socket *tsock;
int retval = 0;
int status = 0;
int do_mirror  = 0;
int do_hexmode = 0;
char myname[9];
char tmpfilename[129] = "";
char cmdline[129] = "";
char l_buf[129] = "";
char l_ch = '\0';

void usage(char *str) {
 if(str) fprintf(stderr,"\n%s\n",str);
 else    fprintf(stderr,"\n%s for DOS V1.5 (re-)written by Jrgen Hoffmann (2008)\n",myname);
 fprintf(stderr, "\n%s -h",myname);
 fprintf(stderr, "\n%s -g <str>",myname);
 fprintf(stderr, "\n%s -l -p <lp> [ -imotvx -e \"cmd\" -s <str> -w <sec>  <host> ]",myname);
 fprintf(stderr, "\n%s  [ -p <lp>   -imotvx -e \"cmd\" -s <str> -w <sec> -z <p2> ] <host>\n",myname);
 fprintf(stderr,"            <host> = host_name | ip_address[:]remote_port\n");
 fprintf(stderr, "Switches:\n");
 fprintf(stderr, "\t-h this helptext\n");
 fprintf(stderr, "\t-g <str> get TCP/IP configuration\n");
 fprintf(stderr, "\t-e \"cmd\" execute command\n");
 fprintf(stderr, "\t-i interactive mode\n");
 fprintf(stderr, "\t-l listen on port for connection\n");
 fprintf(stderr, "\t-m mirror (echo) data back to remote\n");
 fprintf(stderr, "\t-o pipe output of \"-e\" through tempfile\n");
 fprintf(stderr, "\t-p <lp> local port to use (1 - 65535)\n");
 fprintf(stderr, "\t-s <str> string to be sent initially\n");
 fprintf(stderr, "\t-t telnet mode (implies interactive)\n");
 fprintf(stderr, "\t-w <sec> wait, default = 0(listen), 3(client)\n");
 fprintf(stderr, "\t-x show incoming data as hex dump\n");
 fprintf(stderr, "\t-z <p2> upper limit of port scan range\n");
 fprintf(stderr, "\t-v verbose debug information\n");
 fprintf(stderr, "\t-d <lvl> WATTCP debug level (1..2)\n");
 }

int stresc(char *d, char *s, int max) {
  int i;
  for(i=0; *s&&(i<max); d++, s++, i++) {
    if(*s!='\\') *d = *s;
    else {
      s++;
      switch(*s) {
	case 'b': *d = '\b'; break;   // back space
	case 'e': *d =  27 ; break;   // escape
	case 'f': *d = '\f'; break;   // form feed
	case 'n': *d = '\n'; break;   // new line
	case 'r': *d = '\r'; break;   // carriage return
	case 't': *d = '\t'; break;   // tabulator
	default: if((*s<'0') || (*s>'9')) *d = *s;
	else {
	  *d = (atoi(s) & 0xFF);
	  while((s[1]>='0')&&(s[1]<='9')) s++;
	  if(s[1] == '.') s++; // skip trailing dot
	  }
	}
      }
    }
  *d = '\0';
  return(i);
  }

int c_break() {
  fprintf(stderr,"<CTRL/C>\n");
  sock_close(tsock);
  _ip_delay2(tsock,1,NULL,&status);
  retval = 1;
  return(1);
  }

char esclch    = '\0';
int  escarg[3] = { 0, 0, 0 };
int  lstpos[2] = { 0, 0 };
void do_ansy(char *buf, int len) {
  struct text_info *ti;
  int i;
  gettextinfo(ti);
  if(lstpos[0] && lstpos[1]) gotoxy(lstpos[0],lstpos[1]);
  for(i=0; i<len; esclch=buf[i++] ) {
    if(escarg[0] > 0) {
      if(isdigit(buf[i])) {
	if(escarg[0] < 3) {
	  escarg[escarg[0]] *= 10;
	  escarg[escarg[0]] += (buf[i]&0x0F);
	  }
	}
      else if(buf[i]==';') escarg[0]++;
      else {
	if(escarg[1] < 1) escarg[1] = 1;
	if(escarg[2] < 1) escarg[2] = 1;
	switch(buf[i]) {
	  case 'H':
	  case 'f': if(escarg[1]>ti->screenheight) escarg[1]=ti->screenheight;
		    if(escarg[2]>ti->screenwidth)  escarg[2]=ti->screenwidth;
		    gotoxy(escarg[2],escarg[1]);                  break;
	  case 'A': if(escarg[1]>=wherey()) escarg[1]=wherey()-1;
		    gotoxy(wherex(),wherey()-escarg[1]);          break;
	  case 'B': if(wherey()+escarg[1]>ti->screenheight) escarg[1]=ti->screenheight-wherey();
		    gotoxy(wherex(),wherey()+escarg[1]);          break;
	  case 'C': if(wherex()+escarg[1]>ti->screenwidth) escarg[1]=ti->screenwidth-wherex();
		    gotoxy(wherex()+escarg[1],wherex());          break;
	  case 'D': if(escarg[1]>=wherex()) escarg[1]=wherex()-1;
		    gotoxy(wherex()-escarg[1],wherey());          break;
	  case 'J': clrscr();                                     break;
	  case 'K': clreol();                                     break;
	  case 'm': if(escarg[1]==7) textattr(0x70);
		    else             textattr(0x07);		  break;
	  }
	escarg[0] = 0;
	}
      }
    else {
      switch(buf[i]) {
	case '\033': escarg[0]=escarg[1]=escarg[2]=0;  break;
	case '[':    if(esclch=='\033') { escarg[0]++; break; }
	default:     cprintf("%c",buf[i]);
//	default:     putc(buf[i],stdout);
	}
      }
    }
  lstpos[0] = wherex();
  lstpos[1] = wherey();
  }

void trans_key(unsigned char *buf) {
  char table[14] = "1A5 D C 4B623";
  if((buf[1] >= 0x47) && (buf[1] <= 0x53)) {
    buf[2] = table[buf[1]-71];
    if(buf[2]>' ') {
      buf[0] = 0x1B;
      buf[1] = '[';
      if((buf[2]>='A') && (buf[2]<='D')) buf[3] = '\0';
      else {
	buf[3] = '~';
	buf[4] = '\0';
	}
      }
    }
  }

void dump_hex(unsigned char *buf, int len) {
  int i;
  fprintf(stdout,"  ");
  for(i=0;   i<len; i++) fprintf(stdout," %02X",buf[i]);
  for(i=len; i<17;  i++) fprintf(stdout,"   ");
  for(i=0;   i<len; i++) fprintf(stdout,"%c",(buf[i]>=' ')?buf[i]:'');
  fprintf(stdout,"\n");
  }

void wait_for_data(unsigned char *buffer, int max, int v, int to, int t, int l) {
  int i,j,k,n,to2;
  int xi,flg;
  unsigned char xb[16], iacbuf[45];
  longword dataread;
  if(!(stdout->flags&_F_TERM)) setmode(STDOUT,O_BINARY);
  xi = flg = 0;
  if(to < 1) to = 1;
  for(i=to, to2=0; i; i>>=1) to2++;
  dataread = 0L;
  ip_timer_init(tsock,to);
  while(!ip_timer_expired(tsock)) {
    tcp_tick(tsock);
    n = sock_fastread(tsock,buffer,max);
      if(n > 0) {
	if(t) {
	  for(i=j=k=0; i < n; i++)
	    if((buffer[i]>240) || (i&&(buffer[i-1]>240))) iacbuf[j++]=buffer[i];
	    else { if(j) buffer[k++] = buffer[i]; else k++; }
	  if(v && j) {
	    fprintf(stderr,"received %d bytes of IAC codes: ",j);
	    if(j > 12) fprintf(stderr,"\n");
	    for(i=0; i<(j<25?j:25); i++) fprintf(stderr," %02X",iacbuf[i]);
	    fprintf(stderr,"\n");
	    }
	  for(i=1; i < j; i++) {
	    if(iacbuf[i-1]==255 && iacbuf[i]>250) {
	      if((iacbuf[i]==251) || (iacbuf[i]==251)) iacbuf[i]=254;
	      if((iacbuf[i]==253) || (iacbuf[i]==254)) iacbuf[i]=252;
	      if((i<(j-1)) && iacbuf[i+1]==1) {
		if(l) iacbuf[i]=(do_mirror?251:252);
		else  iacbuf[i]=253;
		flg++;
		}
	      }
	    }
	  if(!flg && l) {
	    memcpy(iacbuf,"\377\373\3\377\373\1",6);
	    iacbuf[4] = (do_mirror?251:252);
	    j = 6;
	    flg++;
	    }
	  sock_fastwrite(tsock,iacbuf,j);
	  if(v && j) {
	    fprintf(stderr,"sent %d bytes of IAC codes: ",j);
	    if(j > 12) fprintf(stderr,"\n");
	    for(i=0; i<(j<25?j:25); i++) fprintf(stderr," %02X",iacbuf[i]);
	    fprintf(stderr,"\n");
	    }
	  if(stdout->flags&_F_TERM) do_ansy(buffer,k);
	  else for(i=0; i<k; i++) if(buffer[i]==27) fprintf(stdout,"<ESC>");
				  else putc(buffer[i],stdout);
	  }
	else {
	  k = n;
	  for(i=0; i < n; i++) if(!do_hexmode) putchar(buffer[i]);
	  else {
	    xb[xi++] = buffer[i];
	    if(xi >= 16) {
	      dump_hex(xb,16);
	      xi = 0;
	      }
	    }
	  }
      dataread += n;
      ip_timer_init(tsock,to2);
      if(do_mirror) sock_fastwrite(tsock,buffer,k);
      }
    }
  if(!t && do_hexmode && xi) dump_hex(xb,xi);
  if(v) fprintf(stderr,"\n %lu bytes from remote\n",dataread);
  }

void get_screen(void) {
  int beg, end, i, j, k;
  unsigned char line[83];
  typedef struct {
    unsigned char c;
    unsigned char a;
    } scrchr;
  typedef union {
    unsigned int w;
    scrchr       b;
    } scrwrd;
  typedef scrwrd scrlin[80];
  scrlin screen[25];
  gettext(1,1,80,25,screen);
  for(beg=-1, i=0; i<24; i++)
    if((screen[i][0].w==243)&&(screen[i][1].w==224)&&(screen[i][2].w==242)) beg=i;
  if(beg < 0) beg = 0; else beg++;
  for(end=-1, i=beg; i<24 && end<0; i++)
    if((screen[i][0].w==243)&&(screen[i][1].w==234)&&(screen[i][2].w==242)) end=i;
  if(end < 0) end = 24; else end--;
  for(i=beg; i <= end; i++) {
    for(j = 0; j < 80; j++) line[j] = screen[i][j].b.c;
    line[80] = '\0';
    for(k = 79; (k > 0) && (line[k] <= ' '); k--) line[k] = '\0';
    strcat(line,"\r\n");
    sock_fastwrite(tsock,line,strlen(line));
    }
  }

void get_textfile(char *filename) {
  FILE *tf;
  char line[130], *p;
  if((tf=fopen(filename,"r"))==NULL) fprintf(stderr,"ERROR: cannot open file: %s\n",filename);
  else while(!feof(tf)) {
    if(fgets(line,128,tf)) {
      if((p=strrchr(line,'\n'))!=NULL) *p = '\0';
      strcat(line,"\r\n");
      sock_fastwrite(tsock,line,strlen(line));
      }
    }
  }

int get_textattr(void) {
  struct text_info r;
  gettextinfo(&r);
  return(r.attribute);
  }

void exec_command(char *cmd, char *cmdarg, char *tmpf, int oflg, int v) {
  char cmdbuf[260];
  int  retval;
  int  txtattr;
  txtattr = get_textattr();
  strcpy(cmdbuf,cmd);
  strcat(cmdbuf,cmdarg);
  if(oflg) {
    strcat(cmdbuf," > ");
    strcat(cmdbuf,tmpf);
    }
  cputs("\r"); textattr(0x00); cputs(""); textattr(txtattr); cputs("\r\n");
  retval = system(cmdbuf);
  cputs("\r"); textattr(0x00); cputs(""); textattr(txtattr); cputs("\r\n");
  if(v) fprintf(stderr,"system(\"%s\") returned: %d  errno: %d\n", cmdbuf, retval, errno);
  if(!oflg || retval || errno) get_screen();
  else get_textfile(tmpf);
  }

int cooked_mode(char *rb, int dm, int op, int dv) {
  int rv, bl, el;
  char *p;
  char eb[129];
  rv = 0xFFFF;
  el = 0;
  bl = strlen(l_buf);
  for(p=rb; *p; l_ch=*p++) {
    switch(*p) {
      case '\177':
      case '\b': if(bl>0) l_buf[--bl] = '\0';
		 eb[el++]='\b'; eb[el++]=' '; eb[el++]='\b'; break;
      case '\t': l_buf[bl++] = ' '; l_buf[bl]='\0';
		 eb[el++] = ' ';                             break;
      case '\r': if(l_ch=='\n')                              break;
      case '\n': if(l_ch=='\r')                              break;
		 eb[el++]='\r'; eb[el++]='\n';
		 if(dm) sock_fastwrite(tsock,eb,el);
		 el = 0;
		 if(*cmdline)
		   exec_command(cmdline,l_buf,tmpfilename,op,dv);
		 else fprintf(stdout,"%s",l_buf);
		 if(dm) sock_fastwrite(tsock,"> ",2);
		 l_buf[0] = '\0';
		 rv = bl = 0;                                break;
      default: if(*p>=' ') {l_buf[bl++]=*p; l_buf[bl]='\0'; eb[el++]=*p;}
      }
    if(bl > 128) bl = 128;
    }
  if(dm) sock_fastwrite(tsock,eb,el);
  return(rv);
  }

void get_config(char *prefix) {
  extern longword _arp_gate_data[];
  extern int _arp_last_gateway;
  extern int _last_nameserver;
  int i;
  char *p;
  char tmpstr[16];
  longword peer;
  for(i=0, p=prefix; *p; p++) if(*p > ' ') i++;
  if(!i) *prefix='\0';
  peer = gethostid();
  fprintf(stdout,"%sMY_IP=%s\n",prefix,inet_ntoa(tmpstr,peer));
  fprintf(stdout,"%sNETMASK=%s\n",prefix,inet_ntoa(tmpstr,sin_mask));
  for(i = 0;i < (_arp_last_gateway * 3); i += 3)
    if(_arp_gate_data[i+1]==0L)
      fprintf(stdout,"%sGATEWAY=%s\n",prefix,inet_ntoa(tmpstr,_arp_gate_data[i]));
  if(_last_nameserver) fprintf(stdout,"%sNAMESERVER=%s\n",prefix,inet_ntoa(tmpstr,def_nameservers[0]));
  if(*prefix) fprintf(stdout,"%sBROADCAST=%s\n",prefix,inet_ntoa(tmpstr,
				 ((peer&sin_mask)|(0xFFFFFFFFL&~sin_mask))));
  }

int main(int argc, char **argv)
{
  struct sockaddr ra;
  int port   = 0, wait  = 0, do_scan    = 0, interactive = 0;
  int port2  = 0, wait2 = 3, refused    = 0, do_listen   = 0;
  int lport  = 0, prmt  = 0, wtcp_debug = 0, out_pipe    = 0;
  int st_len = 0, do_telnet = 0;
  longword remoteip = 0L;
  longword dataread = 0L;
  longword datasent = 0L;
  char cfg_prefix[40] = "";
  char host[50] = "";
  char c_buf[129], r_buf[BUFSIZE];
  int  ch;
  char *bp;
  int  bc;
  char tmpstr[16];
  int len, opt;
  long length;
  int do_verbose = 0;
  longword peer;
  byte *b2;
  c_buf[0] = '\0';

  if((bp=strrchr(argv[0],'\\'))!=NULL) bp++; else bp = argv[0];
  strncpy(myname,bp,8);
  if((bp=strchr(myname,'.'))!=NULL) *bp = '\0';
  if((bp=getenv("TEMP"))!=NULL) strncpy(tmpfilename,bp,sizeof(tmpfilename)-14);
  else {
    if((bp=getenv("TMP"))!=NULL) strncpy(tmpfilename,bp,sizeof(tmpfilename)-14);
    else {
      strncpy(tmpfilename,argv[0],sizeof(tmpfilename)-14);
      if((bp=strrchr(tmpfilename,'\\'))!=NULL) *(++bp) = '\0';
      else strcpy(tmpfilename,".\\");
      }
    }
  bp = &tmpfilename[strlen(tmpfilename)-1];
  if(*bp !='\\') strcat(tmpfilename,"\\");
  strcat(tmpfilename,myname);
  strcat(tmpfilename,".TMP");

  if((tsock = calloc(1,sizeof(tcp_Socket))) == NULL) return(3);
  while ((opt = getopt(argc, argv, "hilmotvxd:g:e:p:s:w:z:")) >= 0) {
    switch (opt) {
      case 'd': wtcp_debug = atoi(optarg);         break;
      case 'e': strncpy(cmdline,optarg,128);       break;
      case 'g': strncpy(cfg_prefix,optarg,39);     break;
      case 'i': interactive++;                     break;
      case 'l': do_listen++;                       break;
      case 'm': do_mirror++;                       break;
      case 'o': out_pipe++;                        break;
      case 'p': lport  = atoi(optarg);             break;
      case 's': st_len = stresc(c_buf,optarg,128); break;
      case 't': do_telnet++;                       break;
      case 'w': wait2  = wait = atoi(optarg);      break;
      case 'h': usage(NULL);                       return(2);
      case 'v': do_verbose++;                      break;
      case 'x': do_hexmode++;                      break;
      case 'z': port2 = atoi(optarg);              break;
      default:  /* usage(); */                     return(2);
      } // end switch(opt)
    } // end while

  sock_init(); /* Initialize Connection */
  ctrlbrk(c_break);
  tcp_set_debug_state(wtcp_debug);

  if(do_telnet) interactive++;
  strcpy(host, argv[optind]);
  if(*host) {
    if((bp = strchr(host, ':')) != NULL) {
      *bp++ = '\0';
      port = atoi(bp);
      }
    else if(argc > (optind+1)) port = atoi(argv[optind+1]);
    if(!(remoteip = resolve(host))) {
      fprintf(stderr,"ERROR: Unable to resolve host: '%s'\n", host);
      return(3);
      }
    if(do_verbose && !isdigit(host[0])) {
      inet_ntoa(tmpstr,remoteip);
      fprintf(stderr,"resolved: %s --> %s\n",host,tmpstr);
      }
    }
  if(!port || (port2 <= port)) port2 = port;
  else {
    do_scan     = 1;
    do_listen   = 0;
    do_mirror   = 0;
    do_telnet   = 0;
    interactive = 0;
    }
  if(*cmdline) {
    if((bp=strchr(cmdline,'>'))!=NULL) *bp = '\0';
    }

  if(*cfg_prefix) { get_config(cfg_prefix); return(0); }
/*-------------------------------------------------------------*/
  for(; (retval!=1) && (port<=port2); port++) {
    if(do_listen) {
      if(!lport) { usage("ERROR: No local port number specified"); return(2); }
      if(!tcp_listen(tsock, lport, 0L, 0, NULL, wait)) {
	fprintf(stderr,"Unable to Listen on connection!\n");
	return(3);
	}
      refused = 0;
      if(do_verbose) {
	b2 = (byte *)&peer;
	peer = gethostid();
	fprintf(stderr,"Listening on Local  IP %hu.%hu.%hu.%hu Local Port %u\n", b2[3],b2[2],b2[1],b2[0], lport);
	if(remoteip!=0L) fprintf(stderr,"But only for Remote IP %s",host);
	if(port) fprintf(stderr," Remote Port %u",port);
	fprintf(stderr,"\n");
	}
      sock_wait_established(tsock, wait, NULL, &status);
      getpeername(tsock,&ra,NULL);
      if(((remoteip!=0L)&&(remoteip!=ra.s_ip)) || (port&&(port!=ra.s_port))) refused++;
      if(do_verbose) {
	inet_ntoa(tmpstr,ra.s_ip);
	fprintf(stderr,"%s connction with: %s   remote port: %u\n",
		       (refused?"Refused":"Established"),tmpstr,ra.s_port);
	}
      if(refused) {
	sock_close(tsock);
	port--;
	continue;
	}
      wait_for_data(r_buf,sizeof(r_buf),do_verbose,1,do_telnet,do_listen);
      if(!(stdout->flags&_F_TERM)) freopen("CON","w",stdout);
      } //if(do_listen)
    else { // not listening
      if(host && optind == argc) { usage("ERROR: No host specified in client mode");  return(2); }
      if(!port) { usage("ERROR: No remote port number specified"); return(2); }
      if(!tcp_open(tsock,lport,remoteip,port,NULL)) {
	fprintf(stderr,"Unable to open connection!\n");
	return(3);
	}
      else {
	if(do_scan) fprintf(stderr,"  Scanning port: %u\r",port);
	if(!do_scan) { sock_wait_established(tsock, sock_delay, NULL, &status); }
	else if(_ip_delay0(tsock, 3, NULL, &status)) continue;
	if(do_verbose || do_scan) {
	  b2 = (byte *)&peer;
	  peer = gethostid();
	  if(do_scan) fprintf(stdout,"Found open port number: %u on host: %s\n", port, host);
	  else fprintf(stderr, "Connected local IP %hu.%hu.%hu.%hu to remote Host %s Port %u\r\n",
							   b2[3],b2[2],b2[1],b2[0], host, port);
	  }
	}
      } // not listening
/*-------------------------------------------------------------*/
    if(!do_listen && do_telnet)
      if(!(stdin->flags&_F_TERM) || st_len)
	wait_for_data(r_buf,sizeof(r_buf),do_verbose,wait2,do_telnet,do_listen);
    if(st_len) {
      if(do_verbose) fprintf(stderr,"Sending init string: (%d) %s\n", st_len, c_buf);
      sock_fastwrite(tsock,c_buf,st_len);
      }
    flushall();
    if(!(stdin->flags&_F_TERM) && !do_scan) {  // stdin is NOT Terminal
      setmode(STDIN,O_BINARY);
      if(do_verbose) fprintf(stderr,"Sending data from stdin: ");
      bp = c_buf;
      bc = 0;
      while((ch = getc(stdin)) != EOF) {
	*bp++ = ch;
	bc++;
	dataread++;
	if(bc >= sizeof(c_buf)) {
	  while(sock_tbleft(tsock) < bc) tcp_tick(tsock);
	  datasent += sock_fastwrite(tsock,c_buf,bc);
	  bp = c_buf;
	  bc = 0;
	  }
	}
      if(bc) {
	while(sock_tbleft(tsock) < bc) tcp_tick(tsock);
	datasent += sock_fastwrite(tsock,c_buf,bc);
	}
      if(do_verbose) fprintf(stderr,"%lu/%lu bytes sent\n",datasent,dataread);
      if(freopen("CON","r",stdin) == NULL) interactive = 0;
      }
    flushall();
    do tcp_tick(tsock); while(sock_tbused(tsock));
    if(*cmdline && !do_telnet) exec_command(cmdline,"",tmpfilename,out_pipe,do_verbose);
    if(!do_listen) wait_for_data(r_buf,sizeof(r_buf),do_verbose,wait2,do_telnet,do_listen);
    if(do_scan) sock_close(tsock);
    else if(!(stdout->flags&_F_TERM)) {
      freopen("CON","w",stdout);
      if(!do_listen && do_telnet) interactive=0;
      }
    }
/*-------------------------------------------------------------*/
  if(!retval&&interactive&&do_telnet&&do_mirror&&do_listen) sock_fastwrite(tsock,"> ",2);
  while(!retval && interactive) {
    if(!do_listen && do_telnet) prmt = 1;
    sock_tick(tsock, &status);
    while(sock_dataready(tsock)) {
      len = sock_fastread(tsock,r_buf,sizeof(r_buf));
      if(len > 0) {
	r_buf[len] = '\0';
	if(prmt) fprintf(stderr,"\r");
	if(do_telnet&&do_listen) prmt &= cooked_mode(r_buf,do_mirror,out_pipe,do_verbose);
	else {
	  if(do_telnet) do_ansy(r_buf,len);
	  else {
	    if(do_mirror) sock_fastwrite(tsock,r_buf,len);
	    if(!do_hexmode) fprintf(stdout,"%s",r_buf);
	    else for(bc=0; len>0; bc+=16, len -= 16) dump_hex(&r_buf[bc],((len>16)?16:len));
	    prmt = 0;
	    }
	  }
	}
      }
    if(!prmt) { fprintf(stderr,"\n> "); prmt++; }
    c_buf[0] = 129;
    c_buf[1] = c_buf[2] = '\0';
    if(kbhit()) {
      if(do_telnet) {
	while(kbhit()) {
	  c_buf[c_buf[1]+2] = getch();
	  c_buf[1]++;
	  c_buf[c_buf[1]+2] = '\0';
	  }
	if((c_buf[1] > 1) && (c_buf[2] == 0)) trans_key(&c_buf[2]);
	}
      else {
	cgets(c_buf);
	strcat(&c_buf[2],"\r\n");
	}
      sock_fastwrite(tsock,&c_buf[2],strlen(&c_buf[2]));
      flushall();
      prmt = 0;
      }
    }
/*-------------------------------------------------------------*/
shutdown:
  if(do_verbose) fprintf(stderr,"\nConnection shutdown\n");
  flushall();
  sock_tick(tsock,&status);
  sock_close(tsock);
  sock_wait_closed(tsock,sock_delay,NULL,&status);
sock_err:
  if(do_scan && status==1) fprintf(stderr,"\rScan completed%-40.40s\n"," ");
  else if(retval==1) fprintf(stderr,"Programm terminated locally\n");
  else fprintf(stderr,"\n%s",sockerr(tsock));
  if((status!=1)&&(status!=-1)) fprintf(stderr, " Status=%d",status);
  fprintf(stderr,"\n");
  free(tsock);
  return(retval);
  } // end-main
/* eof ntool */
