REM $INCLUDE: 'SJGPLAY.BI'

REM $DYNAMIC
SUB Author (Ver$)
 IF Mode = LastMd THEN EXIT SUB
 COLOR 15, 1: ClrWin "":
 COLOR 11: BPrat 5, 4, 0, 0, "SJGPLAY"
 CPrat 5, 50, "@(C)1996 Steve J. Gray": CPrat 7, 50, "#Version: $" + Ver$
 CPrat 11, 2, "#This program is @FREEWARE#.": PRINT " You may use it without payment of any kind, however"
 PRINT " I retain full copyrights to the program. You may not modify, sell, or use it"
 PRINT " for commercial purposes. You may include it in FREEWARE/SHAREWARE compilations"
 PRINT " provided all files and documentation are included and un-modified (a free copy"
 PRINT " would be nice too!). If you use this program I'd like to hear your comments or"
 PRINT " suggestions. Thanks!": PRINT
 PRINT " My e-mail address is: "
 CPrat 18, 24, "@": PRINT "sgray@acs.ryerson.ca"
 COLOR 11: Prat WTop + WH - 1, 0, "** Press function key for another mode, or H for Help **"
END SUB

SUB BPrat (Row, Col, Wid, H, A$)
 
 FH = FontH: IF Col < 0 THEN Col = -Col: FH = 4
 IF Wid < Col THEN Wid = 80
 IF H < 0 THEN NoClear = 1: H = -H
 IF H = 0 THEN H = Row + FontH
 RR = Row: CC = Col: P = 1: L = LEN(A$)
 FOR A = 1 TO L
   N = ASC(MID$(A$, A, 1)) - 31
   IF N > 0 AND N <= MaxChr THEN
     W = FontW(N): P = FontP(N)
     TC = CC: IF N = 1 AND H > FontH THEN GOSUB WrapTest
     IF TC <= Wid THEN
       IF CC + W - 1 > Wid THEN GOSUB NextLine
       FOR B = 1 TO FH
         LOCATE RR + B - 1, CC: PRINT MID$(Font$(B), P, W);
       NEXT B
       CC = CC + W
     END IF
   END IF
 NEXT A
 IF NoClear = 0 THEN DO: GOSUB NextLine: LOOP
 EXIT SUB

WrapTest:
 TL = INSTR(A + 1, A$ + " ", " ")
 FOR T = A TO TL - 1
   TN = ASC(MID$(A$, T, 1)) - 31: TC = TC + FontW(TN)
 NEXT T
 IF TC < Wid THEN RETURN
 GOSUB NextLine: RETURN

NextLine:
 GOSUB ClearLine
 RR = RR + FontH: CC = Col: IF RR + FontH - 1 > H THEN EXIT SUB
 RETURN

ClearLine: IF CC > 79 OR (Wid - CC) < 1 THEN RETURN
 FOR B = 1 TO FH
   LOCATE RR + B - 1, CC: PRINT LEFT$(SP$, Wid - CC);
 NEXT B
 RETURN

END SUB

REM $STATIC
DEFSNG A-Z
SUB Calc
 STATIC Num$, Tot, LastNum, Op$, Mem

 ClrWin "Calculator": GOSUB Equals
 Prat 20, 0, "Enter Num, Opr (+-*/=), SPACE=, BKSPC=Erase Digit. ESC when done!"
 DO
   DO: K$ = INKEY$: DispTime: LOOP WHILE K$ = "": COLOR 2
   SELECT CASE UCASE$(K$)
     CASE "0" TO "9": IF LEN(Num$) < 8 THEN GOSUB ShowAdd ELSE BEEP
     CASE ".": IF INSTR(Num$, ".") = 0 THEN GOSUB ShowAdd ELSE BEEP
     CASE "+", "-", "*", "/", "\": GOSUB NewOp
     CASE "=": GOSUB Equals
     CASE " ": Num$ = STR$(-VAL(Num$)): K$ = "": GOSUB ShowAdd
     CASE "M": IF Num$ = "" THEN Mem = VAL(Tot$) ELSE Mem = VAL(Num$)
     CASE "R": Num$ = STR$(Mem): K$ = "": GOSUB ShowAdd
     CASE CHR$(8): L = LEN(Num$): IF L > 0 THEN Num$ = LEFT$(Num$, L - 1): K$ = "": GOSUB ShowAdd
     CASE ESC$: EXIT DO
   END SELECT
 LOOP
 Ref = TRUE
 EXIT SUB

Equals: GOSUB NewOp: BPrat 12, 1, 80, 0, STR$(Tot): Op$ = "": RETURN
ShowAdd:
 Num$ = Num$ + K$
 IF LEFT$(Num$, 1) = " " THEN Num$ = MID$(Num$, 2)
 IF LEFT$(Num$, 1) = "0" THEN Num$ = MID$(Num$, 2)
 BPrat 12, 1, 80, 0, Num$: RETURN
NewOp: IF Num$ = "" THEN Num$ = STR$(Tot)
 Num = VAL(Num$)
 SELECT CASE Op$
   CASE "": Tot = Num
   CASE "+": Tot = LastNum + Num
   CASE "-": Tot = LastNum - Num
   CASE "*": Tot = LastNum * Num
   CASE "/", "\": IF Num <> 0 THEN Tot = LastNum / Num
 END SELECT
 BPrat 12, 1, 80, 0, STR$(Tot): LastNum = Tot: Op$ = K$: Num$ = "": RETURN
END SUB

SUB Calendar (K%) STATIC
 IF K% = -1 THEN GOSUB SetToday: EXIT SUB
 IF K% = 0 THEN GOSUB DrawPopCal: EXIT SUB
 
 SELECT CASE K%
   CASE 75: DY% = -1
   CASE 77: DY% = 1
   CASE 72: DM% = -1
   CASE 80: DM% = 1
   CASE 71: GOSUB SetToday: GOSUB DrawCal
 END SELECT
 IF DM% <> 0 OR DY% <> 0 THEN GOSUB DrawCal
 IF DN% <> 0 THEN GOSUB MoveDay
 EXIT SUB

SetToday:
 Y% = VAL(MID$(DATE$, 9, 2)): M% = VAL(MID$(DATE$, 1, 2))
 D% = VAL(MID$(DATE$, 4, 2)): DM% = 0: DY% = 0
 HD% = D%: RETURN

MoveDay:
 HD% = HD% + DN%: IF HD% < 1 OR HD% > MaxDay% THEN HD% = HD% - DN%
 DN% = 0

DrawCal:
 M% = M% + DM%: Y% = Y% + DY%
 DY% = 0: DM% = 0:  N% = 0
 IF M% < 1 THEN M% = M% + 12: Y% = Y% - 1
 IF M% > 12 THEN M% = M% - 12: Y% = Y% + 1
 IF Y% < 1 THEN Y% = 1
 IF Y% > 99 THEN Y% = 99

 T$ = MID$(STR$(Y% * 100 + M%), 2): M$ = Day$(T$ + "01")
 DayOff% = (INSTR("SunMonTueWedThuFriSat", LEFT$(M$, 3)) - 1) \ 3
 MaxDay% = VAL(Day$("?" + STR$(M%)))
 IF M% = 2 AND Y% / 4 = Y% \ 4 THEN MaxDay% = MaxDay% + 1
 IF HD% > MaxDay% THEN HD% = MaxDay%

 COLOR 15, 0: RR% = R% + 3
 Prat R%, 1, STR$(1900 + Y%) + "    " + MID$(M$, 5, 3) + ".   " + STR$(1900 + Y%)
 FOR P% = 1 TO 42
   DD% = P% - DayOff%: LOCATE RR%, N% * 3 + 2: COLOR 7, 0
   IF DD% < 1 OR DD% > MaxDay% THEN
     PRINT "  ";
   ELSE
     X$ = T$ + RIGHT$(STR$(100 + DD%), 2)
     IF DD% = D% THEN COLOR 15
     LOCATE RR%, N% * 3 + 2: PRINT USING "##"; DD%;
   END IF
   N% = N% + 1: IF N% = 7 THEN N% = 0: RR% = RR% + 1
 NEXT P%
 RETURN

DrawPopCal:
 ClrWin Day$(DATE$): R% = 10
 COLOR 14, 0: Prat R% + 2, 2, "Su Mo Tu We Th Fr Sa"
 GOSUB DrawCal
 Prat R% + 2, 30, "UP/DOWN......Set Month"
 Prat R% + 3, 30, "LEFT/RIGHT...Set Year"
 Prat R% + 4, 30, "HOME.........This Month"
 RETURN

END SUB

DEFINT A-Z
SUB ClrWin (A$)
  FOR A = WTop TO WTop + WH - 1: Prat A, 1, SP$: NEXT
  Ref = TRUE: LastMd = -1: LastTop = -1: COLOR 3
  IF A$ <> "" THEN BPrat 5, 2, 0, 0, A$
  COLOR 7
END SUB

SUB ConfigText
  COLOR 7, 0: A = 14
  CPrat 4, 34, "$CONFIGURATION"
  CPrat 5, 8, "@NAME  DESCRIPTION                                  SETTING RANGE#"
  Prat 6, A, "Initial display mode..(Same as FKEY; 0=Help):     <> 0 to 12"
  Prat 7, A, "Full-screen mode on startup.................:     <> Yes/No"
  Prat 8, A, "Use programmed playlist if available........:     <> Yes/No"
  Prat 9, A, "Auto edit unknown CD when inserted..........:     <> Yes/No"
  Prat 10, A, "Auto play CD...........(0=No,1=Yes,2=Jumble):     <> 0 to 2"
  Prat 11, A, "CD Action on exit....(0=None,1=Stop,2=Eject):     <> 0 to 2"
  Prat 12, A, "Alternate video mode.(Lines: 0=25,1=43,2=50):     <> 0 to 2"
  Prat 13, A, "Intro Time.........................(seconds):     <> 5 to 30"
  Prat 14, A, "Fastforward/Reverse time...........(seconds):     <> 1 to 10"
  Prat 15, A, "Volume control........(0=CD,1=SBMain,2=SBCD):     <> 0 to 2"
  Prat 16, A, "Initial repeat mode.(0=No,1=One,2=STP,3=All):     <> 0 to 3"
  Prat 17, A, "Karaoke Background colour...................:     <> 0 to 7"
  Prat 18, A, "Karaoke Text colour.........................:     <> 0 to 15"
  Prat 19, A, "Joystick control string.....................:"
  CPrat 6, 8, "$MODE!FULL!PRG!EDIT!PLAY!EXIT!VIDEO!INTRO!FFREV!VDEV!REPT!KBACK!KTEXT!JOY"
  CPrat WTop + WH - 1, 3, "#Use @UP#/@DOWN# to select then @LEFT#/@RIGHT# to change setting. @W# to Write (save)."
  COLOR 7, 0: Prat WTop + 15, 60, Joy$
END SUB

REM $DYNAMIC
SUB CPrat (Row, Col, A$)
 L = LEN(A$): IF Col = 0 THEN Col = 41 - (L \ 2)
 IF Row > 0 THEN LOCATE Row, Col
 N = 1: S$ = "@#$%&!"
 FOR A = 1 TO L
   K$ = MID$(A$, A, 1): P = INSTR(S$, K$)
   IF P > 0 THEN
     GOSUB COut
     SELECT CASE P
       CASE 1: COLOR 14
       CASE 2: COLOR 7
       CASE 3: COLOR 15
       CASE 4: COLOR , 4
       CASE 5: COLOR 15, 1
       CASE 6: Row = Row + 1: LOCATE Row, Col
     END SELECT
   END IF
 NEXT A
 GOSUB COut
 EXIT SUB

COut:
 IF N <= A THEN PRINT MID$(A$, N, A - N); : N = A + 1
 RETURN
END SUB

REM $STATIC
FUNCTION Day$ (TD$)

' TD$ is a DATE or a NUMBER
' Date formats: YYMMDD or MM-DD-YYYY (DATE$ format)
' Usage: DATE     = Convert date to DOW MON DD/YY
'        @DATE    = Convert date to number
'        -NUMBER  = Convert number to YYMMDD format
'        @-NUMBER = Convert number to DOW MON DD/YY format
'        ?MM      = Return number of days in month
 Mo$ = "JanFebMarAprMayJunJulAugSepOctNovDec"
 Ma$ = "31 28 31 30 31 30 31 31 30 31 30 31 "
 DA$ = "SunMonTueWedThuFriSat": F = 0

 NFlag% = 0: IF LEFT$(TD$, 1) = "@" THEN NFlag% = 1: TD$ = MID$(TD$, 2)
 SELECT CASE LEFT$(TD$, 1)
   CASE "-"
     N& = -VAL(TD$): GOSUB NumToDate
     IF NFlag% = 1 THEN TD$ = D$: GOSUB DateToStr
     Day$ = D$
   CASE "?": Day$ = MID$(Ma$, 3 * VAL(MID$(TD$, 2)) - 2, 2)
   CASE ELSE
     GOSUB DateToStr
     IF NFlag% = 0 THEN Day$ = D$ ELSE Day$ = STR$(N)
 END SELECT
 EXIT FUNCTION

'-- Convert date to "DOW MON DD/YY" and the number "N"
DateToStr:
 IF MID$(TD$, 3, 1) = "-" THEN
   YY = VAL(MID$(TD$, 7, 4))
   MM = VAL(MID$(TD$, 1, 2))
   DD = VAL(MID$(TD$, 4, 2))
 ELSE
   YY = 1900 + VAL(LEFT$(TD$, 2))
   MM = VAL(MID$(TD$, 3, 2)): IF MM < 1 OR MM > 12 THEN F = 1: MM = 1
   DD = VAL(RIGHT$(TD$, 2)): IF DD < 1 OR DD > VAL(MID$(Ma$, MM * 3 - 2, 2)) THEN F = 1
   IF F = 1 THEN D$ = "": N& = 0: RETURN 'Invalid date
 END IF

 N& = INT(1461& * (YY + (MM < 3)) / 4) + INT(153 * (MM + 1 - 12 * (MM < 3)) / 5) + DD - 621049
 Dow = N& - (INT(N& / 7) * 7)
 D$ = MID$(DA$, Dow * 3 + 1, 3) + " " + MID$(Mo$, MM * 3 - 2, 3) + STR$(DD) + "/" + RIGHT$(STR$(100 + YY), 2)
 RETURN

'-- Convert "N" to "YYMMDD"
NumToDate:
  MM = 1: YY = 1901&: DD = N& - 73355  'Start at Jan 1, 1901
  N& = INT((DD + 1) / 1461&): YY = YY + N& * 4: DD = DD - N& * 1461&
  N& = INT(DD / 365&): YY = YY + N&: DD = DD - N& * 365
  DO
    MN = VAL(MID$(Ma$, MM * 3 - 2, 2)): IF N = 3 AND MM = 2 THEN MN = 29
    IF DD >= MN THEN DD = DD - MN: MM = MM + 1 ELSE EXIT DO
  LOOP
  DD = DD + 1
  D$ = RIGHT$(STR$(YY), 2) + RIGHT$(STR$(100 + MM), 2) + RIGHT$(STR$(100 + DD), 2)
  RETURN

END FUNCTION

REM $DYNAMIC
FUNCTION Dec& (H$)
  Dec& = 0: P = 0
  FOR A = LEN(H$) TO 1 STEP -1
    V = ASC(UCASE$(MID$(H$, A, 1))) - 48: IF V > 9 THEN V = V - 7
    D& = D& + V * (16 ^ P): P = P + 1
  NEXT A
  Dec& = D&
END FUNCTION

REM $STATIC
FUNCTION DoJoy
 N = 0
 DO WHILE STRIG(1) + STRIG(3) + STRIG(5) + STRIG(7) < 0
   IF STRIG(1) THEN IF (N AND 1) = 0 THEN N = N + 1
   IF STRIG(3) THEN IF (N AND 2) = 0 THEN N = N + 2
   IF STRIG(5) THEN IF (N AND 4) = 0 THEN N = N + 4
   IF STRIG(7) THEN IF (N AND 8) = 0 THEN N = N + 8
   CALL DispTime
 LOOP
 DoJoy = N
END FUNCTION

SUB EditLyrics

  IF LyricLines < 2 THEN GOSUB ClearLyr2
  BTop = 0: BBot = 0
  C = 0: Top = 1: LLine = 0: LyricLines = MaxLyric: ShowEPage
  DO
    IF Top + WH > MaxLyric THEN Top = MaxLyric - WH: X% = 1
    IF C > Top + WH - 1 THEN Top = Top + 1: X% = 1
    IF C > MaxLyric THEN C = MaxLyric
    IF C < Top THEN Top = Top - 1: X% = 1
    IF Top < 1 THEN Top = 1: X% = 1
    IF C < 1 THEN C = 1: X% = 1
    IF X% > 0 THEN ShowEPage: X% = 0
    R = WTop + C - Top
    COLOR 14, 0: LOCATE 2, 73: PRINT Msg$(97); USING "###"; C;
    Lyric$(C) = SuppIn(R, 3, 77, "", (Lyric$(C))): COLOR 7, 0: X% = 1
    SELECT CASE CF$
      CASE "", "2": C = C + 1: X% = 1
      CASE "8": C = C - 1: X% = 1
      CASE "7": C = 0: Top = 1
      CASE "1"
        FOR C = MaxLyric TO 1 STEP -1
          IF Lyric$(C) <> "" THEN EXIT FOR
        NEXT C
        Top = C - WH: X% = 1
      CASE "9": Top = Top - WH: C = Top: X% = 1
      CASE "3": Top = Top + WH: C = Top: X% = 1
      CASE "ins": GOSUB InsLLine
      CASE "del": GOSUB DelLLine
      CASE "top": BTop = C: X = 1
      CASE "bot": BBot = C: X = 1
      CASE "copy": GOSUB CopyBlock
      CASE "ESC": EXIT DO
      CASE ELSE
        IF LEFT$(CF$, 1) = "\" THEN
          C = C + 1: GOSUB InsLLine
          X% = 1: CF$ = "+" + MID$(CF$, 2)
        ELSE
          X% = 0
        END IF
    END SELECT
  LOOP
  SaveLyrics ("")
  BTop = 0: BBot = 0: LLine = -1: Ref = TRUE
  EXIT SUB

CopyBlock:
  IF BTop = 0 OR BBot = 0 THEN BEEP: RETURN
  IF BTop > BBot THEN A = BTop: BTop = BBot: BBot = A
  N = BBot - BTop: X = N + 1: GOSUB InsLines
  FOR A = 0 TO N
    Lyric$(C + A) = Lyric$(BTop + A): Sync&(C + A) = NoSync&
  NEXT
  X = 1: RETURN

InsLLine: X = 1
InsLines:
  FOR A = MaxLyric - X TO C STEP -1
    Lyric$(A + X) = Lyric$(A): Sync&(A + X) = Sync&(A)
  NEXT
  IF C < BTop THEN BTop = BTop + X
  IF C < BBot% THEN BBot = BBot + X
  Lyric$(C) = "": X = 1: RETURN

DelLLine:
  FOR A = C TO MaxLyric - 1
    Lyric$(A) = Lyric$(A + 1): Sync&(A) = Sync&(A + 1)
  NEXT
  IF C < BTop THEN BTop = BTop - 1
  IF C < BBot THEN BBot = BBot - 1
  Lyric$(MaxLyric) = "": Sync&(MaxLyric) = NoSync&: X = 1
  RETURN

ClearLyr2:
 FOR A = 0 TO MaxLyric: Lyric$(A) = "": Sync&(A) = NoSync&: NEXT
 Sync&(0) = 1: LyricLines = 1: RETURN

END SUB

REM $DYNAMIC
FUNCTION Exists (A$)
 ON LOCAL ERROR GOTO NotExist
 F = FREEFILE: OPEN A$ FOR INPUT AS F
 CLOSE F: Exists = 1
 EXIT FUNCTION
NotExist: Exists = 0: RESUME NotResume
NotResume:
END FUNCTION

SUB FontEd (K) STATIC
 IF K = -2 THEN GOSUB DoFontMouse: EXIT SUB
 IF K = -1 THEN GOSUB InitFed: EXIT SUB
 IF K = 0 THEN GOSUB DrawFScr: GOSUB DrawFont: EXIT SUB
 
 SELECT CASE K
   CASE 72: CRow = CRow - 1: GOSUB DrawChar
   CASE 75: CCol = CCol - 1: GOSUB DrawChar
   CASE 77: CCol = CCol + 1: GOSUB DrawChar
   CASE 80: CRow = CRow + 1: GOSUB DrawChar
   CASE 71: BNum = ASC(MID$(Font$(CRow), FontP(CNum) + CCol - 1, 1)): GOSUB ShowAsc
   CASE 79: F$ = SuppIn(20, 1, 12, "Save font as: ", "sjgplay.fnt")
     IF CF$ = "" THEN SaveFont (F$)
   CASE 85: F$ = SuppIn(20, 1, 12, "Font to Load? ", "")
     IF CF$ = "" AND F$ <> "" THEN ReadFont (F$): GOSUB DrawFont: Ref = TRUE
   CASE 83: BNum = BNum - 1: GOSUB ShowAsc
   CASE 84: BNum = BNum + 1: GOSUB ShowAsc
   CASE 141: BNum = BNum - 32: GOSUB ShowAsc
   CASE 145: BNum = BNum + 32: GOSUB ShowAsc
   CASE 73: K$ = CHR$(BNum): GOSUB SetChar: GOSUB DrawChar
   CASE 81: K$ = " ": GOSUB SetChar: GOSUB DrawChar
   CASE 155: IF CNum > 1 THEN CNum = CNum - 1: GOSUB DrawFont 'FScr
   CASE 157: IF CNum < MaxChr THEN CNum = CNum + 1: GOSUB DrawFont 'FScr
   CASE 152: GOSUB Wider
   CASE 160: GOSUB Thinner
   CASE ELSE: Ref = FALSE
 END SELECT
 EXIT SUB

Thinner: IF FontW(CNum) < 2 THEN BEEP: RETURN
 A$ = "": C = -1: N = -1: GOSUB InDel: RETURN
Wider: IF FontW(CNum) > 20 THEN BEEP: RETURN
 A$ = " ": C = 1: N = 0: GOSUB InDel: RETURN

InDel:
 P = FontP(CNum) + FontW(CNum) - 1
 FOR A = 1 TO FontH
  K$ = LEFT$(Font$(A), P + N): KK$ = MID$(Font$(A), P + 1)
  Font$(A) = K$ + A$ + KK$
 NEXT A
 FontW(CNum) = FontW(CNum) + C
 FOR A = CNum + 1 TO MaxChr: FontP(A) = FontP(A) + C: NEXT
 K$ = "": KK$ = "": GOSUB DrawFont 'FScr
 RETURN

InitFed:
 CNum = 2: CRow = 1: CCol = 1: BNum = 128
 CK$ = ""
 FOR A = 32 TO 31 + MaxChr
   IF A <> 127 THEN CK$ = CK$ + CHR$(A) ELSE CK$ = CK$ + " "
 NEXT
 Ref = TRUE: RETURN

DrawFScr:
 ClrWin "": C = 35
 COLOR 11, 0: Prat 4, 2, "[<>]": COLOR 7, 0
 Prat 14, 1, "[ ][ ] ASCII Chart"
 Prat 19, 1, "Use CTRL-CURSOR to select"
 Prat 14, C, "CURSOR........Move block pointer"
 Prat 15, C, "PG-UP/DOWN....Set/Clear block"
 Prat 16, C, "ALT-LFT/RGHT..Select big chr"
 Prat 17, C, "ALT-UP/DOWN...Change width (+/-)"
 Prat 18, C, "HOME..........Set ASCII to match pointer"
 Prat 19, C, "CTRL-END......Load font"
 Prat 20, C, "END...........Save Font"
 
 GOSUB DrawChar
 RETURN

DrawFont:
 IF CNum < 1 THEN CNum = 1
 IF CNum > MaxChr THEN CNum = MaxChr
 COLOR 14, 0: BPrat 5, 1, 0, 0, MID$(CK$, CNum)

DrawChar:
 IF CRow < 1 THEN CRow = FontH
 IF CRow > FontH THEN CRow = 1
 IF CCol < 1 THEN CCol = FontW(CNum)
 IF CCol > FontW(CNum) THEN CCol = 1
 COLOR 7, 0: LOCATE 4, 8
 PRINT "Font Editor   Chr#=["; CHR$(CNum + 31); "] ASCII=["; USING "###"; CNum + 31;
 PRINT "] Width=["; FontW(CNum); "] "
 COLOR 14, 1: BPrat 5, 1, FontW(CNum), 0, CHR$(CNum + 31)
 COLOR 4, 3: Prat 4 + CRow, CCol, MID$(Font$(CRow), FontP(CNum) + CCol - 1, 1)

ShowAsc:
 COLOR 14, 1
 IF BNum < 128 THEN BNum = BNum + 128
 IF BNum > 255 THEN BNum = BNum - 128
 FOR A = 0 TO 3: LOCATE 15 + A, 1
   FOR B = 0 TO 31: N = 128 + A * 32 + B
     IF N = BNum THEN K$ = CHR$(N): COLOR 4, 3: PRINT CHR$(N); : COLOR 14, 1 ELSE PRINT CHR$(N);
 NEXT B, A
 COLOR 7, 0: Prat 14, 2, K$: RETURN

DoFontMouse:
 CALL MouseInfo(Row, Col, MB)
 SELECT CASE Row
   CASE 4
     SELECT CASE Col
       CASE 2: CNum = 2
       CASE 3: CNum = CNum - 1
       CASE 4: CNum = CNum + 1
       CASE 5: CNum = MaxChr
     END SELECT
   CASE 5 TO 4 + FontH: IF Col <= FontW(CNum) THEN CCol = Col: CRow = Row - 4
   CASE 14 TO 18: IF Col < 33 THEN GOSUB SetCharS
 END SELECT
 GOSUB DrawFont: RETURN

SetCharS: K$ = CHR$(SCREEN(Row, Col))
SetChar: MID$(Font$(CRow), FontP(CNum) + CCol - 1, 1) = K$: RETURN

END SUB

REM $STATIC
SUB Freq (BRow, Bar1, Bar2, BWid, NumS)
 at = 0: LRaw = 0: A = &H20: R = 127
 ZZ$ = STRING$(BWid - 1, " "): Z$ = STRING$(BWid - 1, CHR$(220))
 
 DO
   OUT WPort, A: Raw = INP(RPort)
   Z! = ((ABS(Raw - R) / 42!)): chng! = (ABS(Raw - LRaw) * Z! + Z!) MOD R
   FC!(chng!) = FC!(chng!) + Z!: at = at + 1: LRaw = Raw
 LOOP WHILE at < NumS
 FOR R = Bar1 TO Bar2
   V = FC!(R): IF V > WH THEN V = WH
   IF V >= FB!(R) THEN FB!(R) = V
   FB!(R) = FB!(R) - 1: V = FB!(R): COLOR 2
   X = (R - Bar1) * BWid + 3
   FOR A = 1 TO V + 1: LOCATE BRow - A, X
     COLOR 2: IF A > 8 THEN COLOR 14: IF A > 11 THEN COLOR 4
     IF A <= V THEN PRINT Z$;  ELSE PRINT ZZ$;
   NEXT A
 NEXT
 FOR A = 0 TO 255: FC!(A) = 0: NEXT

END SUB

REM $DYNAMIC
DEFSNG A-Z
FUNCTION GetSKey$ (A$)

  DO: K$ = UCASE$(INPUT$(1)): LOOP WHILE INSTR(UCASE$(A$), K$) = 0
  GetSKey$ = K$

END FUNCTION

REM $STATIC
DEFINT A-Z
FUNCTION GetYN$
  CPrat WTop + WH - 3, 2, "$Press: @Y# for Yes": IF MFlag = 1 THEN PRINT " (or click RIGHT button)";
  CPrat WTop + WH - 2, 9, "@N# for No": IF MFlag = 1 THEN PRINT "  (or click LEFT button)";
  DO
    DispTime
    K$ = UCASE$(INKEY$): IF K$ = "Y" OR K$ = "N" OR K$ = ESC$ THEN EXIT DO
    IF MFlag = 1 THEN
      CALL MouseInfo(Row, Col, MB)
      IF (MB AND 1) = 1 THEN K$ = "N": EXIT DO
      IF (MB AND 2) = 2 THEN K$ = "Y": EXIT DO
    END IF
  LOOP
  NoButtons
  GetYN$ = K$

END FUNCTION

REM $DYNAMIC
SUB Help
 N = Mouse(2)
 CPrat 4, 1, "% SJGPLAY# (C)1996 @Steve J. Gray  #FREEWARE #(Press @F10# for Info or @H# to exit Help) &"
 C = 2
 CPrat 5, C, "$TRACK CONTROL:"
 CPrat 6, C, "@P#,@ENTER#": PRINT "..Play Current"
 CPrat 7, C, "@0# to @9#..$*#": PRINT "Play (2 digits)"
 CPrat 8, C, "@+#/@-#": PRINT "......Next/Prev Track"
 CPrat 9, C, "@SPACE#": PRINT "....Pause, Resume"
 CPrat 10, C, "@S#,@PERIOD#.Stop"
 CPrat 11, C, "@CURSOR#..$*#Track Search"

 C = 27
 CPrat 5, C, "$DISPLAY/REPEAT/MISC:"
 CPrat 6, C, "@T#": PRINT "........Cycle Time Display"
 CPrat 7, C, "@R#": PRINT "........Cycle Repeat Mode"
 CPrat 8, C, "@A#/@B#": PRINT "......Set A/B Repeat"
 CPrat 9, C, "@I#": PRINT "........Toggle Intro"
 CPrat 10, C, "@F#/@V#": PRINT "......Toggle Full/Video"
 CPrat 11, C, "@E#/@DEL#/@?#.$*#Edit/Delete/Print"
 
 C = 55
 CPrat 5, C, "$DEVICE CONTROL:"
 CPrat 6, C, "@Q#,@ALT-X#": PRINT ".Quit Program"
 CPrat 7, C, "@X#": PRINT ".......Eject/Close Tray"
 CPrat 8, C, "@[#/@]#/@=#": PRINT "...Volume Dn/Up/Mute"
 CPrat 9, C, "@<#/@>#/@~#": PRINT "...Select/Reset Unit"
 Prat 10, C, "Drives:"
 Prat 11, C, "This CD's IDNUM:"

 C = 2
 CPrat 13, C, "$MODES:# (@TAB# or @M# to cycle mode)"
 CPrat 14, C, "@F1#/@F2#": PRINT "....PlayList/Track Titles"
 CPrat 15, C, "@F3#/@F4#": PRINT "....Paged Lyrics/Karaoke"
 CPrat 16, C, "@F5#/@F6#": PRINT "....Large Track/CD Title"
 CPrat 17, C, "@F7#/@F8#": PRINT "....Frequency Bars/Scope"
 CPrat 18, C, "@F9#.......Configuration"
 CPrat 19, C, "@F11#......Catalog (@\#=type,@INS#=Sort)"
 CPrat 20, C, "@F12#/@U#": PRINT "....Utility Help"

 C = 37
 CPrat 13, C, "$PROGRAMMING:# (@G# to toggle PlayList)"
 CPrat 14, C, "@CURSOR#.....$*#": PRINT "Move the yellow marker"
 CPrat 15, C, "@0# to @9#.....$*#": PRINT "Insert step (2-digit track num)"
 CPrat 16, C, "@DEL#/@BCKSPC#": PRINT "..Delete Current/Previous step"
 CPrat 17, C, "@J#/@C#": PRINT ".........Jumble/Clear, Use All tracks"
 CPrat 18, C, "@L#/@W#": PRINT ".........Load/Write(save) PlayList"

 CPrat 20, C, "$Note:# Keys marked with `$*#' change with mode"
 N = Mouse(1)
END SUB

REM $STATIC
SUB LoadConfig (F$)
  IF F$ = "" THEN
    F$ = Path$ + CfgName$
    IF Exists(F$) = 0 THEN F$ = CfgName$: IF Exists(F$) = 0 THEN EXIT SUB
  ELSE
    IF Exists(F$) = 0 THEN EXIT SUB
  END IF
  F = FREEFILE: OPEN F$ FOR INPUT AS F
  DO WHILE NOT EOF(F)
    LINE INPUT #F, A$
    P = INSTR(A$, "="): IF P > 4 THEN GOSUB ParseConfig
  LOOP
  CLOSE F: EXIT SUB

ParseConfig:
  X$ = UCASE$(LTRIM$(RTRIM$(LEFT$(A$, P - 1)))): V = VAL(MID$(A$, P + 1))
  IF X$ = "PATH" THEN Path$ = MID$(A$, P + 1): RETURN
  IF X$ = "JOY" THEN Joy$ = MID$(A$, P + 1): RETURN
  IF X$ = "TXTED" THEN Editor$ = LTRIM$(MID$(A$, P + 1)): RETURN
  FOR A = 1 TO 13: IF X$ = Cfg$(A) THEN Config(A) = V
  NEXT A: RETURN

END SUB

SUB MakeAlbum
  cdInit cdu, tlist(): cdGetInfo cdu, 0, cd, tlist()
  IF AlbumF = 1 THEN
    ClrWin Msg$(51)
    Prat WTop + 6, 2, Msg$(52)
    Prat WTop + 7, 2, Msg$(53)
    Prat WTop + 9, 2, Msg$(54): IF GetYN$ <> "Y" THEN EXIT SUB
  END IF
  ClrWin Msg$(55)
  Prat WTop + 7, 2, Msg$(56)
  A$ = SuppIn(WTop + 12, 2, 68, Msg$(57), ""): IF CF$ = ESCS$ THEN EXIT SUB
  OPEN Path$ + "CD" + IDnum$ + ".ALB" FOR OUTPUT AS 1: PRINT #1, "@ALBUM: " + CDTitle$
  PRINT #1, "; IDNUM="; IDnum$
  IF A$ <> "" THEN PRINT #1, ";": PRINT #1, "; "; A$: PRINT #1, ";"
  PRINT #1, "@TRACKS:"
  FOR A = 1 TO NumT
    F& = tlist(A).absframe: IF A = NumT THEN F2& = TotF& ELSE F2& = tlist(A + 1).absframe
    X& = F2& - F&: FrameToMSF X&, mins, secs, frames
    PRINT #1, USING "##."; A; : PRINT #1, " "; TimeStr$(mins, secs); " - "; Song$(A)
  NEXT A
  PRINT #1, "@ENDTRACKS": PRINT #1, ""
  FOR A = 0 TO NumT
    F$ = Path$ + "CD" + IDnum$ + ".T" + RIGHT$(STR$(100 + A), 2)
    IF Exists(F$) THEN GOSUB AddFile
  NEXT A
  CLOSE 1: ClrWin Msg$(58): AlbumF = 1
  Prat WTop + 7, 2, Msg$(59)
  IF GetYN$ = "Y" THEN LOCATE 4, 1: SHELL "del " + Path$ + "CD" + IDnum$ + ".T??"
  EXIT SUB

AddFile:
  IF A > 0 THEN PRINT #1, "@SONG: " + Song$(A)
  F = FREEFILE: OPEN F$ FOR INPUT AS F
  DO WHILE NOT EOF(F)
    LINE INPUT #F, A$: IF LEFT$(A$, 1) <> ";" THEN PRINT #1, A$
  LOOP
  PRINT #1, "": CLOSE F: RETURN

END SUB

SUB Mixer (K) STATIC
 IF K = -1 THEN GOSUB InitMix: EXIT SUB
 IF K = 0 THEN GOSUB DrawMix: EXIT SUB

 SELECT CASE K
   CASE 72: CRow = CRow - 1: GOSUB DrawMix
   CASE 80: CRow = CRow + 1: GOSUB DrawMix
   CASE 75: Adj = -1: GOSUB Adjust
   CASE 77: Adj = 1: GOSUB Adjust
 END SELECT
 EXIT SUB

InitMix: CRow = 1: RETURN
DrawMix:
  IF CRow < 1 THEN CRow = 1
  IF CRow > 7 THEN CRow = 7
  COLOR 15: Prat 4, 0, "SoundBlaster Pro / 16* Mixer"
  CPrat WTop + WH - 1, 15, "#Use @UP#/@DOWN# to select Scale, @LEFT#/@RIGHT# to adjust."
  FOR A = 1 TO 7: GOSUB DrawScale: NEXT: RETURN

DrawScale:
  Adr = VAL(MID$(" 34 46 40 04 38-68-70", A * 3 - 2, 3))
  M$ = MID$(Msg$(107), A * 8 - 7, 8)
  OUT SBBase + 4, ABS(Adr): V = (INP(SBBase + 5) AND 240) / 16
  COLOR 15: Prat 4 + A * 2, 12, M$
  IF A = CRow THEN COLOR 14: MVol = V ELSE COLOR 7
  PRINT " [" + STRING$(V * 3, "") + STRING$(45 - V * 3, "") + "]"
  RETURN

Adjust:
  MVol = MVol + Adj
  IF MVol < 0 THEN MVol = 0
  IF MVol > 15 THEN MVol = 15
  V2 = MVol * 16
  IF Adr > 0 THEN
    V2 = V2 + MVol: OUT SBBase + 4, ABS(Adr): OUT SBBase + 5, V2
  ELSE
    OUT SBBase + 4, ABS(Adr): OUT SBBase + 5, V2
    OUT SBBase + 4, ABS(Adr) + 1: OUT SBBase + 5, V2
  END IF
  A = CRow: GOSUB DrawScale: RETURN
END SUB

REM $DYNAMIC
FUNCTION Mouse (N)
  'N=Function: 0=Initialize, 1=Show, 2=Hide

  InRegs.ax = N: CALL INTERRUPT(&H33, InRegs, OutRegs)
  Mouse = OutRegs.ax
END FUNCTION

REM $STATIC
SUB MouseInfo (Row, Col, MB)
  
  InRegs.ax = 3: CALL INTERRUPT(&H33, InRegs, OutRegs)
  Row = OutRegs.dx / 8 + 1: Col = OutRegs.cx / 8 + 1: MB = OutRegs.bx

END SUB

FUNCTION Msg$ (A) STATIC

 DIM EM$(110)

 IF A < 1 THEN GOSUB LoadExtFile: EXIT FUNCTION
 IF MsgFlag = 1 THEN Msg$ = EM$(A): EXIT FUNCTION

 SELECT CASE A
   CASE 1: Msg$ = "No CD-ROM driver!"
   CASE 2: Msg$ = "Welcome!"
   CASE 3: Msg$ = "  Track(   % of   :  )"
   CASE 4: Msg$ = "Disc(  :  ) * Drive( )"
   CASE 5: Msg$ = "Volume(  ) Repeat(   )"
   CASE 6: Msg$ = "H=Help M=Mode(       )"
   CASE 7: Msg$ = "Track"
   CASE 8: Msg$ = "---OneSTPAllDrvA-?A-B"
   CASE 9: Msg$ = "--------STOPPED [--2---]PLAYING [--4---]PAUSED  [--6---][--7---][--8---]OPEN    "
   CASE 10: Msg$ = "Elapsed RemainElapsed Remain  Track Remain"
   CASE 11: Msg$ = "                   CD     CD Frame# Frame#"
   CASE 12: Msg$ = "Help   PlayLstCD InfoLyrics KaraokeTrack  CDTitleFreqBrsScope  Config About  CatalogUtilHlpTimer  UnitScnFontEd Calendr"
   CASE 13: Msg$ = "     Intro"
   CASE 14: Msg$ = "       Prg"
   CASE 15: Msg$ = " -+PlayLCDInfLyrcsKaraoTrackCDTtlFrqBrScopeConfgAboutCatlgUtils "
   CASE 16: Msg$ = " -+0123456789[<-<<<<<>>>>>>->]+-INTROABREPTTIMEEJECT-VOL+"
   CASE 17: Msg$ = " -+|0123456789|@71|@73|@75S| |P@77|@81|@79|+-|IIIII|AB|RRRR|TTTT|XXXXX|[[=]]"
   CASE 18: Msg$ = " -+0123456789JCDELPRGLOADSAVEPRINTEDITFULLHELPVID-VOL+-DRV+QUIT"
   CASE 19: Msg$ = " -+|0123456789JC|@83|GGG|LLLL|WWWW|?????|EEEE|FFFF|HHHH|VVV|[[=]]|<<~>>|QQQQ"
   CASE 20: Msg$ = "Quit?"
   CASE 21: Msg$ = "Set Event"
   CASE 22: Msg$ = "Display a message, play a track or change at specified time or when Count=0."
   CASE 23: Msg$ = "For countdown enter a negative seconds (ie: -30)."
   CASE 24: Msg$ = "Enter event Time(HH:MM:SS) or Countdown(-SS): "
   CASE 25: Msg$ = "Message? "
   CASE 26: Msg$ = "Play track# (-1=Stop, 0=No change): "
   CASE 27: Msg$ = "Display mode.........(0=No change): "
   CASE 28: Msg$ = "Display Timer"
   CASE 29: Msg$ = "Changes Display Mode after specified elapsed time."
   CASE 30: Msg$ = "Elapsed time (Seconds, 0=Disable): "
   CASE 31: Msg$ = "Modes List: "
   CASE 32: Msg$ = "CD Frame Accuracy:"
   CASE 33: Msg$ = "$Time...:# "
   CASE 34: Msg$ = "$  Track:#"
   CASE 35: Msg$ = "$  Display Mode:#"
   CASE 36: Msg$ = "$Message:# "
   CASE 37: Msg$ = "Timer:"
   CASE 38: Msg$ = "Countdown:"
   CASE 39: Msg$ = "H=Help  "
   CASE 40: Msg$ = "Name CD:"
   CASE 41: Msg$ = "If you used a text editor to type out the lyrics or tracklist and you don't"
   CASE 42: Msg$ = "know the {IDNUM} for the CD, this will rename those files as CD{idnum}.*"
   CASE 43: Msg$ = "Files must be in the form: {NAME}.CD or {NAME}.Tnn"
   CASE 44: Msg$ = "(where nn is the track number, ie: 01, 02 etc)"
   CASE 45: Msg$ = "Enter {NAME} for THIS CD: "
   CASE 46: Msg$ = "Extract:"
   CASE 47: Msg$ = "This will extract lyrics for the CURRENTLY SELECTED track from an album file"
   CASE 48: Msg$ = "Enter filename to extract from: "
   CASE 49: Msg$ = "Song name: "
   CASE 50: Msg$ = "Not found! Lyrics Available for extraction:"
   CASE 51: Msg$ = "Alert!"
   CASE 52: Msg$ = "You are already using an album file for this CD. You MUST have the individual"
   CASE 53: Msg$ = "lyric files or you will loose information in the current album file!"
   CASE 54: Msg$ = "Continue?"
   CASE 55: Msg$ = "Make Album:"
   CASE 56: Msg$ = "This will make an album file for the CURRENT CD."
   CASE 57: Msg$ = "Comment: "
   CASE 58: Msg$ = "Done!..."
   CASE 59: Msg$ = "Do you want to erase the individual lyric files?"
   CASE 60: Msg$ = "Import Lyrics:"
   CASE 61: Msg$ = "This will import the specified lyric file to the CURRENT track format."
   CASE 62: Msg$ = "Enter name for file: "
   CASE 63: Msg$ = "Save Lyrics:"
   CASE 64: Msg$ = "This will save (copy) the lyrics for the CURRENT track."
   CASE 65: Msg$ = "Enter name for file: "
   CASE 66: Msg$ = "Delete Lyric:"
   CASE 67: Msg$ = "@TRACK:$ "
   CASE 68: Msg$ = "@ID   :$ "
   CASE 69: Msg$ = "@CD   :$ "
   CASE 70: Msg$ = "#Are you sure you want to @delete# the lyrics for this track?"
   CASE 71: Msg$ = "Delete CD:"
   CASE 72: Msg$ = "#Are you sure you want to @delete# ALL files for this CD?"
   CASE 73: Msg$ = "#(@INCLUDING# any lyrics files)"
   CASE 74: Msg$ = "Zip "
   CASE 75: Msg$ = "#Are you sure you want to @"
   CASE 76: Msg$ = "# the files for THIS CD?"
   CASE 77: Msg$ = "Add"
   CASE 78: Msg$ = "Extract"
   CASE 79: Msg$ = "pkzip"
   CASE 80: Msg$ = "pkunzip"
   CASE 81: Msg$ = "Tape Dub:"
   CASE 82: Msg$ = "This inserts appropriate PAUSES in the PLAYLIST so tracks fit to each side."
   CASE 83: Msg$ = "Enter tape length for ONE side (minutes): "
   CASE 84: Msg$ = "To add/insert at marker enter a 2-digit track number..."
   CASE 85: Msg$ = "Step"
   CASE 86: Msg$ = "(PAUSE)"
   CASE 87: Msg$ = "Loading..."
   CASE 88: Msg$ = "Sorting..."
   CASE 89: Msg$ = "Print "
   CASE 90: Msg$ = "#Are you sure you want to print the "
   CASE 91: Msg$ = "Printing..."
   CASE 92: Msg$ = "Lyrics not available "
   CASE 93: Msg$ = "Save?"
   CASE 94: Msg$ = "No CD in the drive! Please enter a filename (or press ESC to abort)"
   CASE 95: Msg$ = "Filename: "
   CASE 96: Msg$ = "Saving..."
   CASE 97: Msg$ = "Line:"
   CASE 98: Msg$ = "Checking if any units are playing..."
   CASE 99: Msg$ = "ESC=Exit"
   CASE 100: Msg$ = "edit"
   CASE 101: Msg$ = "sjgplay.cfg"
   CASE 102: Msg$ = "Select Tray"
   CASE 103: Msg$ = "Unit Scan"
   CASE 104: Msg$ = "Load Messages?"
   CASE 105: Msg$ = "Load Font?"
   CASE 106: Msg$ = "Save Catalog?"
   CASE 107: Msg$ = "Main    Line    CD      Wave    MIDI    Treble *Bass   *"
 END SELECT
 EXIT FUNCTION

LoadExtFile:
 IF A = -1 THEN MsgFlag = 0: RETURN
 OPEN "sjgplay.msg" FOR INPUT AS 1
 DO WHILE NOT EOF(1) AND C < 110
   LINE INPUT #1, A$: C = C + 1: EM$(C) = A$
 LOOP
 CLOSE 1: MsgFlag = 1: RETURN

END FUNCTION

SUB NoButtons
 DO: CALL MouseInfo(A, A, N): LOOP WHILE N <> 0
END SUB

REM $DYNAMIC
SUB Prat (Row, Col, A$)
 IF Col = 0 THEN L = LEN(A$): Col = 41 - (L \ 2)
 LOCATE Row, Col: PRINT A$;
END SUB

REM $STATIC
SUB SaveConfig (F$)
  F = FREEFILE: OPEN Path$ + F$ FOR OUTPUT AS F
  PRINT #F, "; SJGPLAY CONFIG FILE"
  FOR A = 1 TO 13: PRINT #F, Cfg$(A); " ="; Config(A): NEXT
  PRINT #F, "JOY ="; Joy$
  IF Editor$ <> Msg$(100) THEN PRINT #F, "TXTED = "; Editor$
  CLOSE F
END SUB

SUB SaveFont (F$)

Q$ = CHR$(34): C$ = ","
IF F$ = "" THEN F$ = "SJGPLAY.FNT"
OPEN F$ FOR OUTPUT AS 1
PRINT #1, FontH; C$; MaxChr; C$; LF1$; C$; LF2$
FOR A = 1 TO MaxChr
  PRINT #1, ";ASCII"; A
  FOR B = 1 TO FontH
   PRINT #1, Q$ + MID$(Font$(B), FontP(A), FontW(A)) + Q$
  NEXT B
NEXT A
CLOSE

END SUB

SUB SaveLyrics (F$)
 LyricLines = 0
 FOR A = MaxLyric TO 1 STEP -1
   IF Trim$(Lyric$(A)) <> "" THEN LyricLines = A: EXIT FOR
 NEXT A: IF LyricLines < 2 THEN EXIT SUB

 IF F$ = "" THEN F$ = Path$ + "CD" + IDnum$ + ".T" + RIGHT$(STR$(100 + LyricTrack%), 2)
 IF IDnum$ = "" THEN
  ClrWin Msg$(93): Prat WTop + 5, 2, Msg$(95)
  F$ = SuppIn(WTop + 7, 2, 12, Msg$(95), ""): IF F$ = "" THEN EXIT SUB
  F$ = Path$ + F$
 END IF

 ClrWin Msg$(96): Prat WTop + 6, 2, Msg$(95) + F$
 F = FREEFILE: OPEN F$ FOR OUTPUT AS F
 IF Mode <> 11 THEN
   PRINT #F, "; TITLE: "; SongName$
   PRINT #F, "; CD   : "; CDTitle$
   PRINT #F, "; ------"
 END IF
 R& = Sync&(1): IF R& = NoSync& OR Mode = 11 THEN R& = 0
 FOR A = 1 TO LyricLines
   IF R& > 0 THEN PRINT #F, USING "######## "; Sync&(A);
   PRINT #F, Trim$(Lyric$(A))
 NEXT A
 CLOSE F: SLEEP 1

END SUB

SUB Scope (Delay)
  ZE$ = CHR$(220): ZO$ = CHR$(223)
  COLOR 3, 0: S1 = 1: S2 = 80: Sc! = (256! / (WH * 2! - 2))
  FOR C = S1 TO S2: OUT WPort, &H20: FC!(C) = INP(RPort): FOR A = 1 TO Delay: NEXT A, C
  FOR C = S1 TO S2
    LOCATE WTop + FB!(C), C: PRINT " ";
    V = FC!(C) / Sc!: VV = INT(V / 2 + .5): FB!(C) = VV
    LOCATE WTop + VV, C: IF V MOD 2 = 0 THEN PRINT ZE$;  ELSE PRINT ZO$;
  NEXT C

END SUB

SUB ShowEPage
 COLOR 7, 0
 FOR A = 0 TO WH - 1
  LOCATE WTop + A, 1: N = Top + A: K$ = Lyric$(N)
   IF N > LyricLines THEN
     PRINT SP$;
   ELSE
     COLOR 7, 0
     IF Sync&(N) = NoSync& THEN
       PRINT ". ";
     ELSE
       IF Mode = 3 THEN
         IF (Sync&(N + 1) > EFrame&) AND (Sync&(N) < EFrame&) THEN COLOR 2: PRINT Ptr$; " ";  ELSE PRINT "  ";
       ELSE
         PRINT "  ";
       END IF
       COLOR 7, 0
     END IF
     IF Mode = 11 THEN
       IF MID$(K$, 8, 6) = IDnum$ THEN COLOR 15, 0: IF VAL(MID$(K$, 16, 2)) = track THEN COLOR 14, 0
     ELSE
       IF N >= BTop AND N <= BBot THEN COLOR 14, 4
     END IF
     PRINT LEFT$(K$ + SP$, 77);
   END IF
 NEXT A

END SUB

FUNCTION ShowErr$
  COLOR 20, 0
  BPrat WTop, 1, 0, 0, "Error!": COLOR 14, 0
  PRINT : PRINT "ERROR#"; ERR; " at line "; ERL: PRINT : F = 0: COLOR 15, 0
  SELECT CASE ERR
    CASE 5
      IF ERL = 666 THEN
        NumLines = 25: HMode = 0
        PRINT "The alternate video mode is not supported on this video card."
      ELSE
        PRINT "Illegal function call."
      END IF
    CASE 24, 25: F = 1: PRINT "The printer is not ready!"
    CASE 27: PRINT "The printer is out of paper!"
    CASE 53: PRINT "File not found. Try re-typing the name."
    CASE 52, 64: PRINT "You have used an illegal character in your file name."
    CASE 62: PRINT "Invalid file!"
    CASE 68: PRINT "Device un-available!"
    CASE 71: F = 1: PRINT "Problem reading the disk."
    CASE 72: F = 1: PRINT "Your disk MAY be damaged, or the drive may need maintenance."
    CASE ELSE: PRINT "An unknown problem has occurred."
  END SELECT
  IF F = 1 THEN
    COLOR 15, 0
    CPrat WTop + 12, 2, "$Do you want to: @R#etry, @C#ancel, or @A#bort Program$?"
    ShowErr = GetSKey$("RCA" + ESC$)
  ELSE
    ShowErr = ""
  END IF

END FUNCTION

SUB ShowStatus
  STATIC LastTime$, LastStatus%

  LOCATE 1, 73, 0: COLOR 15, 0
  IF Full = 0 THEN
    IF TIME$ <> LastTime$ THEN LastTime$ = TIME$: PRINT TIME$;
  ELSE
    PRINT Msg$(39);
  END IF
  IF ((cd.status AND 7) = LastStatus%) AND (Mode = LastMd) THEN EXIT SUB
  LastStatus% = (cd.status AND 7)
  LOCATE 2, 73: COLOR 14, 0: IF LastStatus% = 5 THEN COLOR 30, 0
  PRINT MID$(Msg$(9), LastStatus% * 8 + 1, 8);
END SUB

REM $DYNAMIC
DEFSNG A-Z
FUNCTION SuppIn$ (Row%, Col%, Max%, P$, W$)
 STATIC Ins%, Mem$

 NumS% = Mouse%(2): NumS% = 1
 IF LEFT$(CF$, 1) = "+" THEN W$ = MID$(CF$, 2) + W$ 'join prev line end
 IF Col% > 0 THEN W$ = LEFT$(LTRIM$(W$) + SP$, Max%)
 Col% = ABS(Col%): CF$ = "": L% = LEN(P$)
 LOCATE Row%, Col%: PRINT P$; : Col% = POS(0)
 WW$ = W$: P = 1: CurStart% = 8: CurEnd% = 10: GOSUB Show: T = 0
 DO
   DO
     IF TIMER - T > 1 THEN GOSUB SITime
     LOCATE Row%, Col% + P - 1, 1, CurStart% - 2 * Ins%, CurEnd%
     K$ = INKEY$: L% = LEN(K$)
   LOOP WHILE L% = 0
   IF L% = 1 THEN
     SELECT CASE ASC(K$)
       CASE 10
         K$ = MID$(W$, P): IF P = 1 THEN W$ = "" ELSE W$ = LEFT$(W$, P - 1)
         CF$ = "\" + K$: EXIT DO
       CASE 13: CF$ = "": EXIT DO
       CASE 27: CF$ = "ESC": EXIT DO
       CASE 9: P = P + 8: IF P > Max% THEN P = Max% 'TAB
       CASE 8: GOSUB BackSpc
       CASE 32 TO 126, 128 TO 254: GOSUB AddChar
     END SELECT
   ELSE
     SELECT CASE ASC(RIGHT$(K$, 1))
       CASE 15: P = P - 8: IF P < 1 THEN P = 1
       CASE 75: IF P > 1 THEN P = P - 1
       CASE 77: IF P < Max% THEN P = P + 1
       CASE 82: Ins% = 1 - Ins%
       CASE 83: GOSUB DelChar
       CASE 72: CF$ = "8"
       CASE 80: CF$ = "2"
       CASE 79: CF$ = "1"
       CASE 71: CF$ = "7"
       CASE 73: CF$ = "9"
       CASE 81: CF$ = "3"
       CASE 32: CF$ = "del"
       CASE 23: CF$ = "ins"
       CASE 20: CF$ = "top"
       CASE 48: CF$ = "bot"
       CASE 46: CF$ = "copy"
       CASE 47: K$ = Trim$(Mem$): GOSUB AddChar
       CASE 22: W$ = UCASE$(W$): GOSUB Show
       CASE 38: W$ = LCASE$(W$): GOSUB Show
       CASE 117: P = 1: W$ = "": GOSUB Show 'CTRL-End
       CASE 119: P = 1: W$ = WW$: GOSUB Show 'CTRL-Home
       CASE 118: P = 1: W$ = Mem$: GOSUB Show 'CTRL-PgDn
       CASE 132: Mem$ = W$ 'CTRL-PgUp
       CASE 115: P = 1 'CTRL-Left
       CASE 116: P = LEN(Trim$(W$)): IF P < Max% THEN P = P + 1 'CTRL-Right
       CASE ELSE: GOSUB CtrlTrack
     END SELECT
   END IF
 LOOP WHILE CF$ = ""
 W$ = Trim$(W$)
 GOSUB Show2: SuppIn$ = W$: NumS% = Mouse%(1)
 EXIT FUNCTION

BackSpc:
 IF P > 1 THEN
   W$ = LEFT$(W$, P - 2) + MID$(W$, P) + " ": P = P - 1
 ELSE
   W$ = ""
 END IF
 GOTO Show

DelChar:
 F$ = "": IF P > 1 THEN F$ = LEFT$(W$, P - 1)
 W$ = LEFT$(F$ + MID$(W$, P + 1) + " ", Max%): GOTO Show

AddChar:
 PP = P: IF Ins% = 0 THEN PP = P + 1
 F$ = "": IF P > 1 THEN F$ = LEFT$(W$, P - 1)
 W$ = LEFT$(F$ + K$ + MID$(W$, PP), Max%)
 IF P < Max% THEN P = P + LEN(K$): IF P > Max% THEN P = Max%

Show:  N = Mouse%(2): COLOR 15, 1: GOSUB ShowIn: RETURN
Show2: COLOR 7, 0 '0
ShowIn: LOCATE Row%, Col%, 0: PRINT LEFT$(W$ + SP$, Max%);
  N = Mouse%(1): RETURN

'--Track control additions
CtrlTrack: N& = 0
 SELECT CASE ASC(RIGHT$(K$, 1))
   CASE 155: N& = -300
   CASE 157: N& = 300
   CASE 160: cdPlay cdu, track%, 99, tlist()
   CASE 152: GOSUB SIPause
 END SELECT
 
 IF N& <> 0 THEN
   cdGetInfo cdu, 0, cd, tlist()
   N& = cd.frame + N&: R& = TotF& - N& - 1
   cdPause cdu: cdPlayFrames cdu, N&, R&
 END IF
 ShowStatus
 RETURN

SIPause: COLOR 14, 0: cdGetInfo cdu, 0, cd, tlist()
  IF (cd.status AND CDPAUSED) = CDPAUSED THEN cdResume cdu ELSE cdPause cdu
  RETURN

SITime: CALL DispTime: T = TIMER: RETURN
END FUNCTION

REM $STATIC
DEFINT A-Z
SUB SyncHelp
 BPrat 5, 2, 0, 0, "Sync Lyrics:"
 CPrat 10, 2, "$INITIAL SYNC CONTROLS:"
 CPrat 11, 2, "@SPACE#......When each line starts"
 CPrat 12, 2, "@BACKSPACE#..Re-try from previous line"
 CPrat 15, 2, "$TO EXIT SYNCRO OR FINETUNE:"
 CPrat 16, 2, "@ESC#........Abort without saving"
 CPrat 17, 2, "@END#........Exit and Save changes"
 CPrat 10, 40, "$FINETUNE CONTROLS:#"
 CPrat 11, 40, "@LEFT#/@RIGHT#..Earlier/Later start 5/75"
 CPrat 12, 40, "#(With @CTRL#).Earlier/Later start 36/75"
 CPrat 13, 40, "@UP#/@DOWN#.....Select Line"
 CPrat 14, 40, "@PG UP#/@DOWN#..Select Page"
 CPrat 15, 40, "@+#/@-#.........Increase/Decrease looptime"
 CPrat 16, 40, "@*#...........Loop to start of next line"
 CPrat 17, 40, "@/#...........Reset looptime"
END SUB

SUB SyncLyrics
 ClrWin ""
 CALL SyncHelp: CPrat WTop + WH - 1, 2, "Press @I# for Initial Sync, @F# to finetune, or @ESC# to abort"
 K$ = GetSKey$("IF" + ESC$): IF K$ = ESC$ THEN EXIT SUB
 Fine = 0: IF K$ = "F" AND Sync&(1) <> NoSync& THEN Fine = 1: GOSUB ResetLoopTime
 ClrWin "": cdStop cdu

 STrack = track
 cdInit cdu, tlist(): cdGetInfo cdu, 0, cd, tlist()
 StartF& = tlist(STrack).absframe: LastTop = 0: Ref = TRUE
 IF track = NumT THEN EndFrame& = TotF& ELSE EndFrame& = tlist(track + 1).absframe
 NumF& = EndFrame& - StartF&
 
 cdPlayFrames cdu, StartF&, NumF& 'start playing
 
 RLine = 0: LLine = 1: Top = 1: ShowEPage
 COLOR 14, 0: IF Fine = 1 THEN Prat 2, 73, "FINETUNE" ELSE Prat 2, 73, "SYNC'ING"
 IF Fine = 1 THEN RMode = 6: L = 0: GOSUB SetLine
 
 
 DO
   DispTime
   COLOR 14, 0: LOCATE WTop + LLine - Top, 1: PRINT Ptr$;
   IF Fine = 1 THEN
     IF cd.frame > RepeatB& THEN cdStop cdu: cdPlayFrames cdu, RepeatA&, R&
   END IF
   
   K$ = INKEY$
   SELECT CASE K$
     CASE " "
       LOCATE WTop + LLine - Top, 1: PRINT " ";
       Sync&(LLine) = EFrame&: LLine = LLine + 1
       Sync&(LLine) = NoSync&
       IF LLine > LyricLines THEN EXIT DO
       IF LLine > Top + WH - 2 THEN Top = LLine - 1: ShowEPage
     CASE BCKSPC$
       LOCATE WTop + LLine - Top, 1: PRINT " ";
       IF LLine > 1 THEN LLine = LLine - 1: IF LLine < Top THEN Top = LLine
       IF LLine > 1 THEN N& = StartF& + Sync&(LLine - 1) ELSE N& = StartF&
       GOSUB ShutAbs2
     CASE Nul$ + CHR$(79): EXIT DO
     CASE ESC$: EXIT SUB
   END SELECT
   IF Fine% = 1 THEN GOSUB CheckFineKey
 LOOP
 COLOR 7, 0: SaveLyrics ("")
 EXIT SUB

CheckFineKey:
 SELECT CASE K$
   CASE "-": IF LoopTime& > 20 THEN LoopTime& = LoopTime& - 20: GOSUB SetFLoop
   CASE "+": LoopTime& = LoopTime& + 20: GOSUB SetFLoop
   CASE "*": LoopTime& = Sync&(LLine + 1) - Sync&(LLine): GOSUB SetFLoop
   CASE "/": GOSUB ResetLoopTime: GOSUB SetFLoop
   CASE Nul$ + CHR$(75): F& = -5: GOSUB SetFine
   CASE Nul$ + CHR$(77): F& = 5: GOSUB SetFine
   CASE Nul$ + CHR$(115): F& = -37: GOSUB SetFine
   CASE Nul$ + CHR$(116): F& = 37: GOSUB SetFine
   CASE Nul$ + CHR$(72): L = -1: GOSUB SetLine
   CASE Nul$ + CHR$(80): L = 1: GOSUB SetLine
   CASE Nul$ + CHR$(73): L = -WH: GOSUB SetLine
   CASE Nul$ + CHR$(81): L = WH: GOSUB SetLine
 END SELECT
 RETURN

SetLine:
 LLine = LLine + L
 IF LLine < 1 THEN LLine = 1
 IF LLine > LyricLines THEN LLine = LyricLines
 IF LLine < Top THEN Top = LLine - WH + 1: IF Top < 1 THEN Top = 1
 IF LLine > Top + WH - 2 THEN Top = LLine
 ShowEPage
 F& = 0

SetFine:
 Sync&(LLine) = Sync&(LLine) + F&
 RepeatA& = StartF& + Sync&(LLine)
SetFLoop:
 RepeatB& = RepeatA& + LoopTime&: N& = RepeatA&: GOSUB ShutAbs2
 RETURN
ResetLoopTime:
 LoopTime& = Config(9) * 38: RETURN

ShutAbs2:
 R& = TotF& - N&
 cdPause cdu: cdPlayFrames cdu, N&, R&: cd.status = 5
 RETURN

END SUB

REM $DYNAMIC
FUNCTION TimeStr$ (BYVAL mins, BYVAL secs)

 IF secs = 254 THEN secs = 0
 text$ = RIGHT$(STR$(100 + mins), 2) + ":" + RIGHT$(STR$(100 + secs), 2)
 TimeStr$ = text$

END FUNCTION

FUNCTION Trim$ (A$)
 L = LEN(A$)
 DO WHILE L > 0
   IF MID$(A$, L, 1) > " " THEN EXIT DO
   L = L - 1
 LOOP
 Trim$ = MID$(A$, 1, L)
END FUNCTION

SUB Utils
  COLOR 3: BPrat 5, 1, 0, 0, "Utilities": C = 2: COLOR 7
  Prat 9, C, "ALT-C..Calculator  |  ALT-E..Edit Font  |  ALT-M..Load Messages"
  Prat 10, C, "ALT-D..Calendar    |  ALT-F..Load Font  |  ALT-B..Screen Blanker (2-30min)"
  Prat 11, C, "ALT-S..Sound Mixer |"
  Prat 12, C, "!/@ ...Rename files with specified {name} / {000000} to {idnum} for current CD"
  Prat 13, C, "# .....Extract Lyrics for current track from Album file"
  Prat 14, C, "$ .....Make Album file from all lyric files for current CD"
  Prat 15, C, "%/^ ...Program PlayList: For Cassette Tape Dub / Lyric tracks only"
  Prat 16, C, "&/* ...Import / Export Lyrics for current track to or from specified file"
  Prat 17, C, "(/) ...Extract / Add data files to or from SAMPLES.ZIP file"
  Prat 18, C, "` .....Unit Scan - Display CD's in all drives"
  Prat 19, C, "D/Y/O..Display Mode Timer / Start, Clear Elapsed Timer / Display Elapsed"
  Prat 20, C, "Z .....Set Event"
END SUB

REM $STATIC
SUB VUMeter (Row)
  FOR C = 1 TO 100
    OUT WPort, &H20: N = ABS(INP(RPort) - 127): IF N > V THEN V = N
  NEXT C
  V = V / 3.6: IF V > V2 THEN V2 = V
  C1 = V2: C2 = 0: IF V2 > 25 THEN C1 = 25: C2 = V2 - 25
  C3 = 37 - C1 - C2
  LOCATE Row, 3: COLOR 2, 0: PRINT LEFT$(DL$, C3);
  COLOR 12, 0: PRINT STRING$(C2, SPtr$);
  COLOR 14, 0: PRINT STRING$(C1, SPtr$);
  COLOR 2, 0: PRINT "][";
  COLOR 14, 0: PRINT STRING$(C1, SPtr$);
  COLOR 12, 0: PRINT STRING$(C2, SPtr$);
  COLOR 2, 0: PRINT LEFT$(DL$, C3);
  V2 = V2 - 4: IF V2 < 1 THEN V2 = 0

END SUB

FUNCTION Words$ (A$)
 L = LEN(A$): P = INSTR(A$, "@"): IF P > 2 THEN L = P - 1
 X$ = ""
 FOR A = 1 TO L
   K$ = MID$(A$, A, 1): IF K$ <> "-" THEN X$ = X$ + K$
 NEXT A
 Words$ = X$
  
END FUNCTION

