#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <process.h>
#include <sys\stat.h>

#define STDOUT 1
#define STDERR 2

typedef char *charptr;

char helptext[] = "\n\
 INVOKE 1.1 by Jrgen Hoffmann (2010) j_hoff@hrz1.hrz.tu-darmstadt.de\n\n\
 usage:  invoke [ options ] <program> [ arguments for program ]\n\n\
  valid options are:\n\
     /D       discard stderr\n\
     /P       propagate result\n\
     /Q       quiet operation\n\
     /R       re-direct stderr into stdout\n\
     /H /?    print this helptext\n";


void main (int argc, char* argv[]) {
  int   i,j,pr,qu,re,nul;
  charptr av[21];

  nul = pr = qu = re = i = 0;
  if(argc < 2) printf(helptext);
  else {
    for(i=1; i < argc && ((*argv[i]=='/')||(*argv[i]=='-'));i++) {
      switch (toupper(argv[i][1])) {
	case 'D': re = 2;           break;
	case 'P': pr = 1;           break;
	case 'Q': qu = 1;           break;
	case 'R': re = 1;           break;
	case 'H':
	case '?': printf(helptext); exit(0);
	}
      }
    if(re) {
      if(re<2) dup2(STDOUT,STDERR);
      else {
	nul = open("NUL", O_RDWR, S_IWRITE);
	dup2(nul,STDERR);
	}
      }
    av[0] = argv[i];
    for(++i,j=1; i<argc&&j<20; i++,j++) av[j] = argv[i];
    av[j] = NULL;
    if(!qu) {
      printf("Invoking:  %s",av[0]);
      for(j=1; av[j]; j++) printf(" %s",av[j]);
      printf("\n");
      }
    i = spawnvp(P_WAIT,av[0],av);
    if(!qu) printf("Returning: %d\n",i);
    }
  if(!pr||(i<0)) i = 0;
  exit(i);
  }