#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <dos.h>

int  skipmatch   = 0;
int  skiplin     = 0;
int  name1       = 0;
char *inlin2;
char *inlin1;
char inlin[256];
char *field[16];
char done;
char fixmode     = 0;
char safemode    = 0;
char csvmode     = 0;
char sepchr[256];

char helptext[] = "\n\
 PIPESET 1.1 by Jrgen Hoffmann (2010) j_hoff@hrz1.hrz.tu-darmstadt.de\n\n\
 usage: <program> | pipeset [ options ] <target1> [ target2 ... ]\n\
    or:             pipeset [ options ] <target1> [ target2 ... ] < <file>\n\n\
 valid options are:\n\
     /S      safe mode  (also useful for testing)\n\
     /L<num> skip <num> lines /L$ skip all but last\n\
     /M<num> skip <num> matches /M$ last match\n\
     /F<fld> define fixed fields e.g. /F3.5.2 or /F-3.5.2\n\
     /C<str> define set of separator  characters\n\
     /W<str> define set of whitespace characters\n\
	     A-Z range   \\XX hex   ^<str> complement\n\n\
 where target is  [variablename][=[<*>pattern]]\n\
      and <*> is  = equal      { not  ( begining  ? containing\n\
		  # not equal  } not  ) ending    ! not containing\n\n\
 examples:  cd  | pipeset /S current_path\n\
	    ver | pipeset /S syst=(MS vers\n\
	    pipeset /S /C=, ==country country codepage driver < \\config.sys\n";

void set_sepchr(char *p) {
  unsigned char tmp[230];
  unsigned char *q, c, neg, tmp2[4];
  neg = 0;
  if(*p=='^') {
    neg = 1;
    p++;
    }
  if(strchr(p,'\\')) {
    for(q=tmp; *p; p++)
      if(*p!='\\') *q++ = *p;
      else {
	p++;
	if(!isxdigit(*p)||!isxdigit(p[1])) *q++ = *p;
	else {
	  tmp2[0] = *p++;
	  tmp2[1] = *p;
	  tmp2[2] = '\0';
	  *q++ = strtol(tmp2,NULL,16) & 0XFF;
	  }
	}
    *q++ = '\0';
    p = tmp;
    }
  q = &sepchr[31];
  *q++ = c = *p++;
  for( ; *p; p++)
    if((*p!='-')||(c>=p[1])) *q++ = c = *p;
    else for(c++ ; c<p[1]; c++)  *q++ = c;
  *q = '\0';
  if(neg) {
    for(q=tmp,c=' '; c<255; c++) if(!strchr(&sepchr[31],c)) *q++ = c;
    *q = '\0';
    strcpy(&sepchr[31],tmp);
    }
  }

void set_fixmode(char *p) {
  char *q;
  fixmode = 1;
  if(*p=='-') {
    p++;
    fixmode = -1;
    }
  if(isdigit(*p)) {
    q = &sepchr[31];
    while(*p) {
      *q++ = atoi(p);
      while(isdigit(*p)) p++;
      while(*p&&!isdigit(*p)) p++;
      }
    *q = 0;
    }
  else fixmode = 0;
  }

void put_parentenv(char *cmdp) {
  unsigned int far *ip1; // ptr --> parent's PSP
  unsigned int far *ip2; // ptr --> ptp -->  parent's environment
  unsigned int far *ip3; // ptr --> size  of parent's environment
  int pesize, peused;    // available, actually used
  char far *pebeg;       // ptr --> Parent's Environment BEGin
  char far *peend;       // ptr --> Parent's Environment END
  char far *cp1;
  char far *cp2;
  char far *vpos;        // ptr --> variable, if already present
  int  vlen,vsiz;        // new len, present len, if already present
  vpos = NULL;
  vsiz = 0;
  vlen = (strchr(cmdp,'=') - cmdp) + 1;
  ip1 = MK_FP(_psp,0X0016);
  ip2 = MK_FP(*ip1,0X002C);
  pebeg = MK_FP(*ip2,0);
  ip3 = MK_FP(*ip2-1,3); // !!!!!!!!
  for(cp1=pebeg; *cp1; cp1=MK_FP(FP_SEG(cp1),FP_OFF(cp1)+_fstrlen(cp1)+1))
    if(!_fstrncmp(cp1,cmdp,vlen)) { vpos = cp1; vsiz = _fstrlen(cp1) + 1; }
  peend  = cp1;
  peused = cp1 - pebeg + 1;
  pesize = *ip3 <<  4;
  if(vsiz) {             // if already present, remove it first
    cp1 = vpos;
    cp2 = MK_FP(FP_SEG(cp1),FP_OFF(cp1)+vsiz);
    while(cp2 < peend) *cp1++ = *cp2++;
    peend  = cp1;
    peused -= vsiz;
    }
  if((pesize-peused-5)<strlen(cmdp)) fprintf(stderr,"\nERROR: out of environment space\n");
  else {                 // now append new copy, if space is sufficient
    _fstrcpy(peend,cmdp);
    cp1  = MK_FP(FP_SEG(peend),FP_OFF(peend)+strlen(cmdp)+1);
    *cp1 = '\0';
    }
  }

void chop(int nfields) {
  int i,j,k,l;
  l = strlen(inlin);
  for(i=1; i<16; i++) field[i] = NULL;
  if(fixmode>0) {
    k = sepchr[31];
    j = 31;
    }
  else {
    k = l - 1;
    for(j=31; sepchr[j]; j++);
    for(i=1,j--; i<nfields&&j>30; i++,j--) k -= sepchr[j];
    }
  field[0] = inlin;
  for(i=1; i<nfields&&sepchr[30+i]; i++) {
    if(l>=k) memmove(&inlin[k+1],&inlin[k],l-k+1);
    inlin[k++] = '\0';
    field[i] = &inlin[k];
    k += sepchr[j+i];
    }
  }

void split(int nfields) {
  int i;
  char *p;
  for(i=1; i<16; i++) field[i] = NULL;
  field[0] = inlin;
  for(i=1,p=inlin; *p&&i<nfields; p++) if(strchr(sepchr,*p)) {
    *p = '\0';
    field[i++] = &p[1];
    }
  }

void scan(int nfields) {
  int i;
  char *p;
  if(nfields>16) nfields = 16;
  for(i=0; i<16; i++) field[i] = NULL;
  for(i=0,p=inlin; *p&&i<nfields; ) {
    while(*p&&strchr(sepchr,*p)) p++;
    if(*p) {
      field[i++] = p;
      while(*p&&!strchr(sepchr,*p)) p++;
      if(*p&&i<nfields) *p++ = '\0';
      }
    }
  }

void main (int argc, char* argv[]) {
  int   i,j;
  char *p;

  for(i=0; i<32; i++) sepchr[i] = i+1;
  if(argc < 2) printf(helptext);
  else {
    for(i=1; i < argc && ((*argv[i]=='/')||(*argv[i]=='-'));i++) {
      switch (toupper(argv[i][1])) {
	case 'L': if(argv[i][2]=='$') skiplin = -1;
		  else skiplin = atoi(&argv[i][2]);   break;
	case 'M': if(argv[i][2]=='$') skipmatch = -1;
		  else skipmatch = atoi(&argv[i][2]); break;
	case 'F': set_fixmode(&argv[i][2]);           break;
	case 'S': safemode = 1;                       break;
	case 'C': csvmode  = 1;
	case 'W': set_sepchr(&argv[i][2]);            break;
	case '?':
	case 'H': printf(helptext);                   exit(0);
	}
      }
    if(skipmatch) {
      inlin1 = malloc(sizeof(inlin));
      inlin2 = malloc(sizeof(inlin));
      if(!inlin1||!inlin2) skipmatch = 0;
      else if(skipmatch>0) skipmatch++;
      }
    name1 = i;
    if(skiplin<0) do {} while(gets(inlin));
    else do { gets(inlin); skiplin--; } while(skiplin>-1);
    do {
      if(skipmatch<0) strcpy(inlin1,inlin);
      if(fixmode) chop(argc-name1);
      else if(csvmode) split(argc-name1);
      else scan(argc-name1);
      done = 1;
      i = name1;
      while(i < argc) {
	j = i - name1;
	p=strchr(argv[i],'=');
	if(p) switch(p[1]) {
	  case '=': if(!field[j]||strcmp(&p[2],field[j]))    done = 0; break;
	  case '#': if(field[j]&&!strcmp(&p[2],field[j]))    done = 0; break;
	  case '(': if(!field[j]||strncmp(&p[2],field[j],strlen(&p[2])))
							     done = 0; break;
	  case '{': if(field[j]&&!strncmp(&p[2],field[j],strlen(&p[2])))
							     done = 0; break;
	  case ')': if(!field[j])                            done = 0;
		    else if(strlen(&p[2])>strlen(field[j]))  done = 0;
		    else if(strcmp(&p[2],&field[j][strlen(field[j])-strlen(&p[2])]))
							     done = 0; break;
	  case '}': if(field[j]&&strlen(&p[2])<=strlen(field[j]))
		      if(!strcmp(&p[2],&field[j][strlen(field[j])-strlen(&p[2])]))
							     done = 0; break;
	  case '?': if(!field[j]||!strstr(field[j],&p[2]))   done = 0; break;
	  case '!': if(field[j]&&strstr(field[j],&p[2]))     done = 0; break;
	  }
	i++;
	}
      if(skipmatch&&done) {
	if(skipmatch>0) skipmatch--;
	else strcpy(inlin2,inlin1);
	if(skipmatch) done = 0;
	}
      if(!done) {
	p = gets(inlin);
	if(!p&&(skipmatch<0)&&inlin2[0]) {
	  strcpy(inlin,inlin2);
	  p = inlin;
	  skipmatch = 0;
	  }
	}
      } while(!done&&p);
    if(done) {
      i = name1;
      while(i < argc) {
	j = i - name1;
	p=strchr(argv[i],'=');
	if(p) *p = '\0';
	if(*argv[i]&&field[j]) {
	  strupr(argv[i]);
	  if(safemode) printf("SET %s=%s\n",argv[i],field[j]);
	  else {
	    sprintf(sepchr,"%s=%s",argv[i],field[j]);
	    put_parentenv(sepchr);
	    }
	  }
	i++;
	}
      }
    }
  exit(0);
  }
